"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UrlFetcher = void 0;
/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
const inversify_1 = require("inversify");
/**
 * Allow to grab external content
 * if browser support is enabled, it will update URLs to make them work on browser side.
 */
let UrlFetcher = class UrlFetcher {
    // fetch content optionally, if the URL is not found, we return undefined without throwing errors
    async fetchTextOptionalContent(url) {
        try {
            const response = await this.axiosInstance.get(url, {
                responseType: 'text',
            });
            return response.data;
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
        }
        catch (error) {
            // not found then we return undefined
            if (error.response && error.response.status === 404) {
                return undefined;
            }
            throw error;
        }
    }
    // fetch content
    async fetchText(url) {
        const response = await this.axiosInstance.get(url, {
            responseType: 'text',
        });
        return response.data;
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
    }
};
__decorate([
    inversify_1.inject(Symbol.for('AxiosInstance')),
    __metadata("design:type", Function)
], UrlFetcher.prototype, "axiosInstance", void 0);
UrlFetcher = __decorate([
    inversify_1.injectable()
], UrlFetcher);
exports.UrlFetcher = UrlFetcher;
//# sourceMappingURL=url-fetcher.js.map