"use strict";
/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheTheiaPluginsAnalyzer = void 0;
const jsYaml = require("js-yaml");
const inversify_1 = require("inversify");
/**
 * This class needs to analyze the content of a local .che/che-theia-plugins.yaml file and grab different ids and optional parameters
 */
let CheTheiaPluginsAnalyzer = class CheTheiaPluginsAnalyzer {
    async extractPlugins(cheTheiaPluginsYamlContent) {
        // it's a yaml so convert it !
        const cheTheiaPluginsYamlInRepository = jsYaml.load(cheTheiaPluginsYamlContent);
        // example of the supported format:
        // - id: redhat/java8/latest
        //   override:
        //     preferences:
        //       java.server.launchMode: LightWeight
        //     sidecar:
        //       memoryLimit: 1280Mi
        //       cpuLimit: 128Mi
        if (cheTheiaPluginsYamlInRepository && Array.isArray(cheTheiaPluginsYamlInRepository)) {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            return cheTheiaPluginsYamlInRepository.map(entry => {
                var _a, _b;
                const sidecar = (_a = entry.override) === null || _a === void 0 ? void 0 : _a.sidecar;
                if (sidecar && !sidecar.image) {
                    // image will be applied from the plugin registry
                    sidecar.image = '';
                }
                return {
                    id: entry.id,
                    resolved: false,
                    extensions: [],
                    preferences: (_b = entry.override) === null || _b === void 0 ? void 0 : _b.preferences,
                    sidecar: sidecar,
                };
            });
        }
        // not able to really see the content, return something empty
        return [];
    }
};
CheTheiaPluginsAnalyzer = __decorate([
    inversify_1.injectable()
], CheTheiaPluginsAnalyzer);
exports.CheTheiaPluginsAnalyzer = CheTheiaPluginsAnalyzer;
//# sourceMappingURL=che-theia-plugins-analyzer.js.map