"use strict";
/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
exports.Generate = void 0;
var inversify_1 = require("inversify");
var che_code_devfile_resolver_1 = require("./api/che-code-devfile-resolver");
var jsYaml = __importStar(require("js-yaml"));
var fs = __importStar(require("fs-extra"));
var Generate = /** @class */ (function () {
    function Generate() {
    }
    Generate.prototype.generate = function (devfileContent, editorContent, outputFile) {
        return __awaiter(this, void 0, void 0, function () {
            var context, allContentArray, generatedContent;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.generateContent(devfileContent, editorContent)];
                    case 1:
                        context = _a.sent();
                        allContentArray = context.devWorkspaceTemplates.map(function (template) { return jsYaml.dump(template); });
                        allContentArray.push(jsYaml.dump(context.devWorkspace));
                        generatedContent = allContentArray.join('---\n');
                        return [4 /*yield*/, fs.writeFile(outputFile, generatedContent, 'utf-8')];
                    case 2:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    Generate.prototype.generateContent = function (devfileContent, editorContent) {
        return __awaiter(this, void 0, void 0, function () {
            var devfile, suffix, editorDevfile, metadata, editorDevWorkspaceTemplate, devfileMetadata, devfileCopy, devWorkspace, devWorkspaceTemplates, context;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        devfile = jsYaml.load(devfileContent);
                        suffix = devfile.metadata.name || '';
                        editorDevfile = jsYaml.load(editorContent);
                        metadata = editorDevfile.metadata;
                        // add sufix
                        metadata.name = metadata.name + "-" + suffix;
                        delete editorDevfile.metadata;
                        delete editorDevfile.schemaVersion;
                        editorDevWorkspaceTemplate = {
                            apiVersion: 'workspace.devfile.io/v1alpha2',
                            kind: 'DevWorkspaceTemplate',
                            metadata: metadata,
                            spec: editorDevfile
                        };
                        devfileMetadata = devfile.metadata;
                        devfileCopy = Object.assign({}, devfile);
                        delete devfileCopy.schemaVersion;
                        delete devfileCopy.metadata;
                        devWorkspace = {
                            apiVersion: 'workspace.devfile.io/v1alpha2',
                            kind: 'DevWorkspace',
                            metadata: devfileMetadata,
                            spec: {
                                started: true,
                                template: devfileCopy
                            }
                        };
                        devWorkspaceTemplates = [editorDevWorkspaceTemplate];
                        context = {
                            devfile: devfile,
                            devWorkspace: devWorkspace,
                            devWorkspaceTemplates: devWorkspaceTemplates,
                            suffix: suffix
                        };
                        return [4 /*yield*/, this.cheCodeDevfileResolver.update(context)];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, context];
                }
            });
        });
    };
    __decorate([
        (0, inversify_1.inject)(che_code_devfile_resolver_1.CheCodeDevfileResolver)
    ], Generate.prototype, "cheCodeDevfileResolver");
    Generate = __decorate([
        (0, inversify_1.injectable)()
    ], Generate);
    return Generate;
}());
exports.Generate = Generate;
//# sourceMappingURL=generate.js.map