"use strict";
exports.__esModule = true;
exports.devfileModule = void 0;
/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var inversify_1 = require("inversify");
var che_code_devfile_resolver_1 = require("../api/che-code-devfile-resolver");
var che_code_description_component_finder_1 = require("./che-code-description-component-finder");
var che_code_description_component_removal_1 = require("./che-code-description-component-removal");
var che_code_devfile_extract_1 = require("./che-code-devfile-extract");
var che_code_devfile_resolver_impl_1 = require("./che-code-devfile-resolver-impl");
var dev_container_component_finder_1 = require("./dev-container-component-finder");
var dev_container_component_inserter_1 = require("./dev-container-component-inserter");
var dev_container_component_updater_1 = require("./dev-container-component-updater");
var devfileModule = new inversify_1.ContainerModule(function (bind) {
    bind(che_code_description_component_finder_1.CheCodeDescriptionComponentFinder).toSelf().inSingletonScope();
    bind(che_code_description_component_removal_1.CheCodeDescriptionComponentRemoval).toSelf().inSingletonScope();
    bind(che_code_devfile_resolver_1.CheCodeDevfileResolver).to(che_code_devfile_resolver_impl_1.CheCodeDevfileResolverImpl).inSingletonScope();
    bind(dev_container_component_finder_1.DevContainerComponentFinder).toSelf().inSingletonScope();
    bind(dev_container_component_inserter_1.DevContainerComponentInserter).toSelf().inSingletonScope();
    bind(dev_container_component_updater_1.DevContainerComponentUpdater).toSelf().inSingletonScope();
    bind(che_code_devfile_extract_1.CheCodeDevfileExtract).toSelf().inSingletonScope();
});
exports.devfileModule = devfileModule;
//# sourceMappingURL=devfile-module.js.map