"use strict";
/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
exports.CheCodeDevfileExtract = void 0;
var inversify_1 = require("inversify");
var jsYaml = __importStar(require("js-yaml"));
var dev_container_component_updater_1 = require("./dev-container-component-updater");
/**
 * This class handle the extraction of the original devfile from a DevWorkspace object
 */
var CheCodeDevfileExtract = /** @class */ (function () {
    function CheCodeDevfileExtract() {
    }
    /**
     * Extracts devfile from the given DevWorkspace
     */
    CheCodeDevfileExtract.prototype.extract = function (devfile, devWorkspace) {
        var _a, _b;
        return __awaiter(this, void 0, void 0, function () {
            var contributedComponentContainer, builtDevfile;
            return __generator(this, function (_c) {
                if (((_a = devWorkspace.spec) === null || _a === void 0 ? void 0 : _a.template) == null) {
                    throw new Error('Requires a template in devWorkspace object');
                }
                contributedComponentContainer = (_b = devWorkspace.spec.template.components) === null || _b === void 0 ? void 0 : _b.find(function (component) { var _a; return (_a = component.attributes) === null || _a === void 0 ? void 0 : _a[dev_container_component_updater_1.DevContainerComponentUpdater.CONTRIBUTE_CONTAINER]; });
                if (!contributedComponentContainer) {
                    throw new Error('Unable to find contribution container');
                }
                // remove contributed objects
                this.removeContributedVolumes(contributedComponentContainer);
                this.removeContributedVolumeComponents(contributedComponentContainer, devWorkspace.spec.template, devWorkspace.spec.template.components);
                this.removeContributedEndpoints(contributedComponentContainer);
                this.removeContributedEntrypoint(contributedComponentContainer);
                this.removeContributedResources(contributedComponentContainer);
                this.removeContributedAttributes(contributedComponentContainer);
                builtDevfile = __assign({ schemaVersion: devfile.schemaVersion, metadata: devfile.metadata }, devWorkspace.spec.template);
                return [2 /*return*/, jsYaml.dump(builtDevfile)];
            });
        });
    };
    // remove contributed resources
    CheCodeDevfileExtract.prototype.removeContributedResources = function (contributedComponentContainer) {
        this.removeContributedResource(contributedComponentContainer, 'memoryLimit');
        this.removeContributedResource(contributedComponentContainer, 'memoryRequest');
        this.removeContributedResource(contributedComponentContainer, 'cpuLimit');
        this.removeContributedResource(contributedComponentContainer, 'cpuRequest');
    };
    // remove contributed resource
    CheCodeDevfileExtract.prototype.removeContributedResource = function (contributedComponentContainer, resourceName) {
        var attributeName = "" + dev_container_component_updater_1.DevContainerComponentUpdater.CONTRIBUTE_PREFIX + resourceName;
        var originalAttributeName = "" + dev_container_component_updater_1.DevContainerComponentUpdater.CONTRIBUTE_ORIGINAL_PREFIX + resourceName;
        if (contributedComponentContainer.attributes[attributeName]) {
            delete contributedComponentContainer.container[resourceName];
        }
        // restore original resource
        if (contributedComponentContainer.attributes[originalAttributeName]) {
            contributedComponentContainer.container[resourceName] =
                contributedComponentContainer.attributes[originalAttributeName];
        }
    };
    // remove contributed entrypoint
    CheCodeDevfileExtract.prototype.removeContributedEntrypoint = function (contributedComponentContainer) {
        // remove entrypoint
        if (contributedComponentContainer.attributes[dev_container_component_updater_1.DevContainerComponentUpdater.CONTRIBUTE_ENTRYPOINT]) {
            delete contributedComponentContainer.container.command;
        }
        // restore original entrypoint
        if (contributedComponentContainer.attributes[dev_container_component_updater_1.DevContainerComponentUpdater.CONTRIBUTE_ORIGINAL_ENTRYPOINT]) {
            contributedComponentContainer.container.command =
                contributedComponentContainer.attributes[dev_container_component_updater_1.DevContainerComponentUpdater.CONTRIBUTE_ORIGINAL_ENTRYPOINT];
        }
    };
    // remove contributed volumes
    CheCodeDevfileExtract.prototype.removeContributedVolumes = function (contributedComponentContainer) {
        var contributedVolumeNames = Object.keys(contributedComponentContainer.attributes)
            .filter(function (key) { return key.startsWith(dev_container_component_updater_1.DevContainerComponentUpdater.CONTRIBUTE_VOLUME_MOUNT); })
            .map(function (key) { return key.substring(dev_container_component_updater_1.DevContainerComponentUpdater.CONTRIBUTE_VOLUME_MOUNT.length); });
        contributedComponentContainer.container.volumeMounts.forEach(function (volumeMount, index) {
            if (contributedVolumeNames.includes(volumeMount.name)) {
                delete contributedComponentContainer.container.volumeMounts[index];
            }
        });
        // cleanup volumeMounts
        this.cleanupArray(contributedComponentContainer.container, 'volumeMounts', contributedComponentContainer.container.volumeMounts);
    };
    // remove contributed volume components
    CheCodeDevfileExtract.prototype.removeContributedVolumeComponents = function (contributedComponentContainer, template, currentComponents) {
        var contributedVolumeComponents = Object.keys(contributedComponentContainer.attributes)
            .filter(function (key) { return key.startsWith(dev_container_component_updater_1.DevContainerComponentUpdater.CONTRIBUTE_VOLUME_COMPONENT); })
            .map(function (key) { return key.substring(dev_container_component_updater_1.DevContainerComponentUpdater.CONTRIBUTE_VOLUME_COMPONENT.length); });
        currentComponents.forEach(function (component, index) {
            if (contributedVolumeComponents.includes(component.name)) {
                delete currentComponents[index];
            }
        });
        // remove non null elements
        currentComponents = currentComponents.filter(function (a) { return a; });
        template.components = currentComponents;
    };
    // remove contributed endpoints
    CheCodeDevfileExtract.prototype.removeContributedEndpoints = function (contributedComponentContainer) {
        var contributedEndpoints = Object.keys(contributedComponentContainer.attributes)
            .filter(function (key) { return key.startsWith(dev_container_component_updater_1.DevContainerComponentUpdater.CONTRIBUTE_ENDPOINT); })
            .map(function (key) { return key.substring(dev_container_component_updater_1.DevContainerComponentUpdater.CONTRIBUTE_ENDPOINT.length); });
        contributedComponentContainer.container.endpoints.forEach(function (endpoint, index) {
            if (contributedEndpoints.includes(endpoint.name)) {
                delete contributedComponentContainer.container.endpoints[index];
            }
        });
        // cleanup endpoints
        this.cleanupArray(contributedComponentContainer.container, 'endpoints', contributedComponentContainer.container.endpoints);
    };
    // remove all contributed attributes
    CheCodeDevfileExtract.prototype.removeContributedAttributes = function (contributedComponentContainer) {
        Object.keys(contributedComponentContainer.attributes).forEach(function (key) {
            if (key.startsWith(dev_container_component_updater_1.DevContainerComponentUpdater.CHECODE_ATTRIBUTE_PREFIX)) {
                delete contributedComponentContainer.attributes[key];
            }
        });
        // delete all attributes if no-entry
        if (Object.keys(contributedComponentContainer.attributes).length === 0) {
            delete contributedComponentContainer.attributes;
        }
    };
    // remove any null, undefined element from the array and if at the end the array is empty, remove the element
    CheCodeDevfileExtract.prototype.cleanupArray = function (parent, attributeName, array) {
        // remove non null elements
        array = array.filter(function (a) { return a; });
        parent[attributeName] = array;
        if (array.length === 0) {
            delete parent[attributeName];
        }
    };
    CheCodeDevfileExtract = __decorate([
        (0, inversify_1.injectable)()
    ], CheCodeDevfileExtract);
    return CheCodeDevfileExtract;
}());
exports.CheCodeDevfileExtract = CheCodeDevfileExtract;
//# sourceMappingURL=che-code-devfile-extract.js.map