"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var child_process_1 = require("child_process");
var semaphore_1 = require("@calebboyd/semaphore");
var WorkerThread = /** @class */ (function () {
    function WorkerThread(_a) {
        var _b = (_a === void 0 ? {} : _a).taskConccurency, taskConccurency = _b === void 0 ? 10 : _b;
        var _this = this;
        this.pending = {};
        this.child = child_process_1.fork(require.resolve('./worker-runtime'));
        this.lock = new semaphore_1.Semaphore(taskConccurency);
        this.child.on('message', function (message) {
            _this.lock.release();
            var waiter = _this.pending[message.id];
            delete _this.pending[message.id];
            if (message.error) {
                waiter.reject(new Error(message.error));
            }
            else {
                waiter.resolve(message.result);
            }
        });
    }
    WorkerThread.prototype.sendMessage = function (message) {
        var _this = this;
        return this.lock.acquire().then(function (id) {
            _this.child.send(__assign({ id: id }, message));
            return (_this.pending[id] = semaphore_1.createDeferred()).promise;
        });
    };
    WorkerThread.prototype.end = function () {
        this.child.kill();
    };
    return WorkerThread;
}());
exports.WorkerThread = WorkerThread;
