"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var fs_1 = require("fs");
var globby_1 = require("globby");
var pify = require("pify");
var readFile = pify(fs_1.readFile);
var path_1 = require("path");
var gather_deps_1 = require("./gather-deps");
var file_1 = require("./file");
var enhanced_resolve_1 = require("enhanced-resolve");
function createResolver(useSyncFileSystemCalls) {
    if (useSyncFileSystemCalls === void 0) { useSyncFileSystemCalls = true; }
    var resolver = enhanced_resolve_1.ResolverFactory.createResolver({
        extensions: ['.js', '.json', '.node'],
        useSyncFileSystemCalls: true,
        fileSystem: new enhanced_resolve_1.CachedInputFileSystem(new enhanced_resolve_1.NodeJsInputFileSystem(), 4000)
    });
    return resolver.resolve.bind(resolver, {
        environments: ['node+es3+es5+process+native']
    });
}
var nodeResolve = createResolver(), asyncNodeResolve = createResolver(false), moduleGlob = ['**/*', '!node_modules', '!test'], defaultOptions = { loadContent: true, expand: false };
function resolveSync(from, request) {
    var result = {
        absPath: '',
        pkgPath: '',
        pkg: null,
        warning: ''
    };
    nodeResolve(from, request, {}, function (err, path, data) {
        if (err) {
            result.warning = err.message;
            return;
        }
        result.absPath = path;
        result.pkgPath = data.descriptionFilePath;
        result.pkg = data.descriptionFileData;
        return;
    });
    return result;
}
exports.resolveSync = resolveSync;
function resolve(from, request) {
    var result = {
        absPath: '',
        pkgPath: '',
        pkg: null,
        warning: ''
    };
    return new Promise(function (resolve, reject) {
        asyncNodeResolve(from, request, {}, function (err, path, data) {
            if (err) {
                result.warning = err.message;
                return resolve(result);
            }
            result.absPath = path;
            result.pkgPath = data.descriptionFilePath;
            result.pkg = data.descriptionFileData;
            resolve(result);
        });
    });
}
exports.resolve = resolve;
function load(wd, request, options) {
    if (options === void 0) { options = defaultOptions; }
    return __awaiter(this, void 0, void 0, function () {
        var _a, absPath, pkg, pkgPath, warning, file, isJs, _b, parseResult, pkgDir_1, fileDir_1, files, currentDeps_1;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0: return [4 /*yield*/, resolve(wd, request)];
                case 1:
                    _a = _c.sent(), absPath = _a.absPath, pkg = _a.pkg, pkgPath = _a.pkgPath, warning = _a.warning;
                    if (!absPath) {
                        return [2 /*return*/, { warning: warning }];
                    }
                    file = file_1.createFile(absPath);
                    isJs = absPath.endsWith('.js');
                    file.absPath = absPath;
                    if (!(isJs || absPath.endsWith('json'))) return [3 /*break*/, 3];
                    _b = file;
                    return [4 /*yield*/, readFile(absPath, 'utf-8')];
                case 2:
                    _b.contents = _c.sent();
                    _c.label = 3;
                case 3:
                    if (isJs) {
                        try {
                            parseResult = gather_deps_1.gatherDependencies(file.contents);
                            Object.assign(file.deps, parseResult.deps);
                            file.variableImports = parseResult.variable;
                        }
                        catch (e) {
                            return [2 /*return*/, { warning: "Error parsing file: \"" + file.absPath + "\"\n" + e.stack }];
                        }
                    }
                    if (!file_1.isNodeModule(request)) return [3 /*break*/, 5];
                    if (!(pkg && pkgPath)) return [3 /*break*/, 5];
                    pkgDir_1 = (file.moduleRoot = path_1.dirname(pkgPath));
                    fileDir_1 = path_1.dirname(file.absPath);
                    file.package = pkg;
                    file.deps[file_1.ensureDottedRelative(fileDir_1, pkgPath)] = null;
                    if (!options.expand) return [3 /*break*/, 5];
                    return [4 /*yield*/, globby_1.default(file.package.files || moduleGlob, { cwd: pkgDir_1 })];
                case 4:
                    files = _c.sent();
                    files
                        .map(function (dep) { return file_1.ensureDottedRelative(fileDir_1, path_1.join(pkgDir_1, dep)); })
                        .filter(function (relDep) { return file.absPath !== path_1.join(pkgDir_1, relDep); })
                        .forEach(function (relDep) {
                        file.deps[relDep] = file.deps[relDep] || null;
                    });
                    currentDeps_1 = Object.keys(file.deps);
                    //when expand is set, include dependencies in the package.json that might be dynamically required
                    Object.keys(file.package.dependencies || {}).forEach(function (dependency) {
                        if (!currentDeps_1.some(function (curDep) { return curDep.startsWith(dependency); })) {
                            file.deps[dependency] = file.deps[dependency] || null;
                        }
                    });
                    _c.label = 5;
                case 5:
                    if (!options.loadContent) {
                        file.contents = null;
                    }
                    return [2 /*return*/, file];
            }
        });
    });
}
exports.load = load;
