"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var file_1 = require("./file");
var path_1 = require("path");
var worker_1 = require("./worker");
var node_builtins_1 = require("./node-builtins");
var cpus = require('os').cpus().length;
var Loader = /** @class */ (function () {
    function Loader(options) {
        this.options = options;
        this.pool = [];
        this.ended = false;
        this.size = Math.max(cpus - 1, 1);
        this.currentWorker = 0;
        this.starting = __spread(Array(this.size)).map(function (x) { return new worker_1.WorkerThread({ taskConccurency: 100 }); });
        this.workerOptions = __assign({}, options, { files: {} });
    }
    Loader.prototype.initialize = function () {
        var _this = this;
        if (this.initializing) {
            return this.initializing;
        }
        this.ended = false;
        //initailize all, but only wait for the first one
        return (this.initializing = Promise.race(this.starting.map(function (x) {
            return x
                .sendMessage({
                modulePath: require.resolve('./node-loader'),
                contextName: 'node-loader',
                options: _this.workerOptions
            })
                .then(function () {
                if (_this.ended) {
                    x.end();
                }
                _this.pool.push(x);
            });
        })).then(function () { return undefined; }));
    };
    Loader.prototype.quit = function () {
        this.ended = true;
        this.pool.forEach(function (x) { return x.end(); });
    };
    Loader.prototype.getWorker = function () {
        //todo wait for workers to warm up
        var worker = this.pool[this.currentWorker++];
        if (this.currentWorker === this.pool.length) {
            this.currentWorker = 0;
        }
        return worker;
    };
    Loader.prototype.loadEntry = function (wd, request, files, warnings) {
        if (files === void 0) { files = {}; }
        if (warnings === void 0) { warnings = []; }
        var mainFile = file_1.ensureDottedRelative(wd, path_1.resolve(wd, request));
        return this.load(wd, mainFile, files, warnings).then(function (entry) {
            return { entry: entry, files: files, warnings: warnings };
        }, function (e) {
            throw e;
        });
    };
    Loader.prototype.load = function (cd, request, files, warnings) {
        if (files === void 0) { files = {}; }
        return __awaiter(this, void 0, void 0, function () {
            var worker, file, fileDir;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        worker = this.getWorker();
                        return [4 /*yield*/, worker.sendMessage({
                                contextName: 'node-loader',
                                method: 'load',
                                args: [cd, request, this.workerOptions]
                            })];
                    case 1:
                        file = _a.sent();
                        if ('warning' in file) {
                            warnings.push(file.warning);
                            return [2 /*return*/, null];
                        }
                        if (files[file.absPath] !== undefined) {
                            return [2 /*return*/, files[file.absPath]];
                        }
                        else {
                            files[file.absPath] = file;
                        }
                        fileDir = path_1.dirname(file.absPath);
                        return [4 /*yield*/, Promise.all(Object.keys(file.deps).map(function (req) {
                                if (~node_builtins_1.default.indexOf(req)) {
                                    return (file.deps[req] = null);
                                }
                                return _this.load(fileDir, req, files, warnings).then(function (dep) {
                                    file.deps[req] = dep;
                                    if ((file.moduleRoot || file.belongsTo) && dep && !dep.moduleRoot) {
                                        var owner = file.moduleRoot ? file : file.belongsTo;
                                        dep.belongsTo = owner;
                                    }
                                });
                            }))];
                    case 2:
                        _a.sent();
                        return [2 /*return*/, file];
                }
            });
        });
    };
    return Loader;
}());
exports.Loader = Loader;
