"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var path_1 = require("path");
var esmRegex = /(^\s*|[}\);\n]\s*)(import\s*(['"]|(\*\s+as\s+)?(?!type)([^"'\(\)\n; ]+)\s*from\s*['"]|\{)|export\s+\*\s+from\s+["']|export\s*(\{|default|function|class|var|const|let|async\s+function))/;
function isScript(code) {
    return !Boolean(code.match(esmRegex));
}
exports.isScript = isScript;
var variableImports = false;
var notNodeModule = /^\.|^\//;
function isNodeModule(request) {
    return !notNodeModule.test(request);
}
exports.isNodeModule = isNodeModule;
function ensureDottedRelative(from, to) {
    var rel = path_1.relative(from, to);
    if (!rel.startsWith('.')) {
        rel = './' + rel;
    }
    return rel.split(path_1.sep).join('/');
}
exports.ensureDottedRelative = ensureDottedRelative;
function createFile(absPath) {
    return {
        deps: {},
        absPath: absPath,
        contents: null,
        variableImports: variableImports
    };
}
exports.createFile = createFile;
