# Contribution Guide

This page describes how to contribute changes to Cherow.

Please do **not** create a pull request without reading this guide first. Failure to do so may result in the **rejection** of the pull request.
And also keep in mind that performance is the main priority. The "fastest" way to solve an issue, isn't the fastest one, but the slowest one!

**1. Create a ticket in the [issue tracker](https://github.com/cherow/cherow/issues)**.
This serves as a placeholder for important feedback, review, or any future updates.

**2. Run all the tests**. This requires Node.js: `npm install` to set up, `npm test` to run the tests.

**3. Work on a feature branch**.  If the change still needs some tweaks, it will not clutter the master branch.

**4. Write a reasonable commit message:**

* Keep the first line < 72 characters. Write additional paragraphs if necessary.
* Put the link to the ticket. This is important for cross-referencing purposes.

