"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var semaphore_1 = require("./semaphore");
function each(list, iterator, _a) {
    var _b = _a === void 0 ? { concurrency: null } : _a, context = _b.context, concurrency = _b.concurrency;
    var arrList = Array.from(list);
    context = context || this;
    if (concurrency === null)
        concurrency = arrList.length;
    var lock = new semaphore_1.Semaphore(concurrency);
    var pending = [];
    var handler = function (locks) { return iterator.call(context, arrList[locks - 1], locks - 1, list); };
    for (var i = 0; i < arrList.length; i++) {
        pending.push(lock.acquire().then(handler).then(lock.release));
    }
    return Promise.all(pending).then(function () { return void 0; });
}
exports.each = each;
