"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function createDeferredFactory(PromiseCtor) {
    if (PromiseCtor === void 0) { PromiseCtor = Promise; }
    return function deferred() {
        var deferred = {};
        var promise = new PromiseCtor(function (resolve, reject) {
            deferred.resolve = resolve;
            deferred.reject = reject;
        });
        deferred.promise = promise;
        return deferred;
    };
}
exports.createDeferredFactory = createDeferredFactory;
exports.createDeferred = createDeferredFactory();
