// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.11.2
// source: google/storage/v1/storage.proto

package storage

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// A collection of constant values meaningful to the Storage API.
type ServiceConstants_Values int32

const (
	// Unused. Proto3 requires first enum to be 0.
	ServiceConstants_VALUES_UNSPECIFIED ServiceConstants_Values = 0
	// The maximum size chunk that can will be returned in a single
	// ReadRequest.
	// 2 MiB.
	ServiceConstants_MAX_READ_CHUNK_BYTES ServiceConstants_Values = 2097152
	// The maximum size chunk that can be sent in a single InsertObjectRequest.
	// 2 MiB.
	ServiceConstants_MAX_WRITE_CHUNK_BYTES ServiceConstants_Values = 2097152
	// The maximum size of an object in MB - whether written in a single stream
	// or composed from multiple other objects.
	// 5 TiB.
	ServiceConstants_MAX_OBJECT_SIZE_MB ServiceConstants_Values = 5242880
	// The maximum length field name that can be sent in a single
	// custom metadata field.
	// 1 KiB.
	ServiceConstants_MAX_CUSTOM_METADATA_FIELD_NAME_BYTES ServiceConstants_Values = 1024
	// The maximum length field value that can be sent in a single
	// custom_metadata field.
	// 4 KiB.
	ServiceConstants_MAX_CUSTOM_METADATA_FIELD_VALUE_BYTES ServiceConstants_Values = 4096
	// The maximum total bytes that can be populated into all field names and
	// values of the custom_metadata for one object.
	// 8 KiB.
	ServiceConstants_MAX_CUSTOM_METADATA_TOTAL_SIZE_BYTES ServiceConstants_Values = 8192
	// The maximum total bytes that can be populated into all bucket metadata
	// fields.
	// 20 KiB.
	ServiceConstants_MAX_BUCKET_METADATA_TOTAL_SIZE_BYTES ServiceConstants_Values = 20480
	// The maximum number of NotificationConfigurations that can be registered
	// for a given bucket.
	ServiceConstants_MAX_NOTIFICATION_CONFIGS_PER_BUCKET ServiceConstants_Values = 100
	// The maximum number of LifecycleRules that can be registered for a given
	// bucket.
	ServiceConstants_MAX_LIFECYCLE_RULES_PER_BUCKET ServiceConstants_Values = 100
	// The maximum number of custom attributes per NotificationConfig.
	ServiceConstants_MAX_NOTIFICATION_CUSTOM_ATTRIBUTES ServiceConstants_Values = 5
	// The maximum length of a custom attribute key included in
	// NotificationConfig.
	ServiceConstants_MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_KEY_LENGTH ServiceConstants_Values = 256
	// The maximum length of a custom attribute value included in a
	// NotificationConfig.
	ServiceConstants_MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_VALUE_LENGTH ServiceConstants_Values = 1024
	// The maximum number of key/value entries per bucket label.
	ServiceConstants_MAX_LABELS_ENTRIES_COUNT ServiceConstants_Values = 64
	// The maximum character length of the key or value in a bucket
	// label map.
	ServiceConstants_MAX_LABELS_KEY_VALUE_LENGTH ServiceConstants_Values = 63
	// The maximum byte size of the key or value in a bucket label
	// map.
	ServiceConstants_MAX_LABELS_KEY_VALUE_BYTES ServiceConstants_Values = 128
	// The maximum number of object IDs that can be included in a
	// DeleteObjectsRequest.
	ServiceConstants_MAX_OBJECT_IDS_PER_DELETE_OBJECTS_REQUEST ServiceConstants_Values = 1000
	// The maximum number of days for which a token returned by the
	// GetListObjectsSplitPoints RPC is valid.
	ServiceConstants_SPLIT_TOKEN_MAX_VALID_DAYS ServiceConstants_Values = 14
)

// Enum value maps for ServiceConstants_Values.
var (
	ServiceConstants_Values_name = map[int32]string{
		0:       "VALUES_UNSPECIFIED",
		2097152: "MAX_READ_CHUNK_BYTES",
		// Duplicate value: 2097152: "MAX_WRITE_CHUNK_BYTES",
		5242880: "MAX_OBJECT_SIZE_MB",
		1024:    "MAX_CUSTOM_METADATA_FIELD_NAME_BYTES",
		4096:    "MAX_CUSTOM_METADATA_FIELD_VALUE_BYTES",
		8192:    "MAX_CUSTOM_METADATA_TOTAL_SIZE_BYTES",
		20480:   "MAX_BUCKET_METADATA_TOTAL_SIZE_BYTES",
		100:     "MAX_NOTIFICATION_CONFIGS_PER_BUCKET",
		// Duplicate value: 100: "MAX_LIFECYCLE_RULES_PER_BUCKET",
		5:   "MAX_NOTIFICATION_CUSTOM_ATTRIBUTES",
		256: "MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_KEY_LENGTH",
		// Duplicate value: 1024: "MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_VALUE_LENGTH",
		64:   "MAX_LABELS_ENTRIES_COUNT",
		63:   "MAX_LABELS_KEY_VALUE_LENGTH",
		128:  "MAX_LABELS_KEY_VALUE_BYTES",
		1000: "MAX_OBJECT_IDS_PER_DELETE_OBJECTS_REQUEST",
		14:   "SPLIT_TOKEN_MAX_VALID_DAYS",
	}
	ServiceConstants_Values_value = map[string]int32{
		"VALUES_UNSPECIFIED":                             0,
		"MAX_READ_CHUNK_BYTES":                           2097152,
		"MAX_WRITE_CHUNK_BYTES":                          2097152,
		"MAX_OBJECT_SIZE_MB":                             5242880,
		"MAX_CUSTOM_METADATA_FIELD_NAME_BYTES":           1024,
		"MAX_CUSTOM_METADATA_FIELD_VALUE_BYTES":          4096,
		"MAX_CUSTOM_METADATA_TOTAL_SIZE_BYTES":           8192,
		"MAX_BUCKET_METADATA_TOTAL_SIZE_BYTES":           20480,
		"MAX_NOTIFICATION_CONFIGS_PER_BUCKET":            100,
		"MAX_LIFECYCLE_RULES_PER_BUCKET":                 100,
		"MAX_NOTIFICATION_CUSTOM_ATTRIBUTES":             5,
		"MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_KEY_LENGTH":   256,
		"MAX_NOTIFICATION_CUSTOM_ATTRIBUTE_VALUE_LENGTH": 1024,
		"MAX_LABELS_ENTRIES_COUNT":                       64,
		"MAX_LABELS_KEY_VALUE_LENGTH":                    63,
		"MAX_LABELS_KEY_VALUE_BYTES":                     128,
		"MAX_OBJECT_IDS_PER_DELETE_OBJECTS_REQUEST":      1000,
		"SPLIT_TOKEN_MAX_VALID_DAYS":                     14,
	}
)

func (x ServiceConstants_Values) Enum() *ServiceConstants_Values {
	p := new(ServiceConstants_Values)
	*p = x
	return p
}

func (x ServiceConstants_Values) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServiceConstants_Values) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storage_v1_storage_proto_enumTypes[0].Descriptor()
}

func (ServiceConstants_Values) Type() protoreflect.EnumType {
	return &file_google_storage_v1_storage_proto_enumTypes[0]
}

func (x ServiceConstants_Values) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServiceConstants_Values.Descriptor instead.
func (ServiceConstants_Values) EnumDescriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{62, 0}
}

// Request message for DeleteBucketAccessControl.
type DeleteBucketAccessControlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The entity holding the permission. Can be one of:
	// * `user-`*userId*
	// * `user-`*emailAddress*
	// * `group-`*groupId*
	// * `group-`*emailAddress*
	// * `allUsers`
	// * `allAuthenticatedUsers`
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,4,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *DeleteBucketAccessControlRequest) Reset() {
	*x = DeleteBucketAccessControlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteBucketAccessControlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBucketAccessControlRequest) ProtoMessage() {}

func (x *DeleteBucketAccessControlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBucketAccessControlRequest.ProtoReflect.Descriptor instead.
func (*DeleteBucketAccessControlRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{0}
}

func (x *DeleteBucketAccessControlRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *DeleteBucketAccessControlRequest) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *DeleteBucketAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for GetBucketAccessControl.
type GetBucketAccessControlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The entity holding the permission. Can be one of:
	// * `user-`*userId*
	// * `user-`*emailAddress*
	// * `group-`*groupId*
	// * `group-`*emailAddress*
	// * `allUsers`
	// * `allAuthenticatedUsers`
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,4,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *GetBucketAccessControlRequest) Reset() {
	*x = GetBucketAccessControlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBucketAccessControlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBucketAccessControlRequest) ProtoMessage() {}

func (x *GetBucketAccessControlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBucketAccessControlRequest.ProtoReflect.Descriptor instead.
func (*GetBucketAccessControlRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{1}
}

func (x *GetBucketAccessControlRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *GetBucketAccessControlRequest) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *GetBucketAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for InsertBucketAccessControl.
type InsertBucketAccessControlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Properties of the new bucket access control being inserted.
	BucketAccessControl *BucketAccessControl `protobuf:"bytes,3,opt,name=bucket_access_control,json=bucketAccessControl,proto3" json:"bucket_access_control,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,4,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *InsertBucketAccessControlRequest) Reset() {
	*x = InsertBucketAccessControlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InsertBucketAccessControlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InsertBucketAccessControlRequest) ProtoMessage() {}

func (x *InsertBucketAccessControlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InsertBucketAccessControlRequest.ProtoReflect.Descriptor instead.
func (*InsertBucketAccessControlRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{2}
}

func (x *InsertBucketAccessControlRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *InsertBucketAccessControlRequest) GetBucketAccessControl() *BucketAccessControl {
	if x != nil {
		return x.BucketAccessControl
	}
	return nil
}

func (x *InsertBucketAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for ListBucketAccessControl.
type ListBucketAccessControlsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,3,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *ListBucketAccessControlsRequest) Reset() {
	*x = ListBucketAccessControlsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBucketAccessControlsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBucketAccessControlsRequest) ProtoMessage() {}

func (x *ListBucketAccessControlsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBucketAccessControlsRequest.ProtoReflect.Descriptor instead.
func (*ListBucketAccessControlsRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{3}
}

func (x *ListBucketAccessControlsRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *ListBucketAccessControlsRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request for PatchBucketAccessControl.
type PatchBucketAccessControlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The entity holding the permission. Can be one of:
	// * `user-`*userId*
	// * `user-`*emailAddress*
	// * `group-`*groupId*
	// * `group-`*emailAddress*
	// * `allUsers`
	// * `allAuthenticatedUsers`
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// The BucketAccessControl for updating.
	BucketAccessControl *BucketAccessControl `protobuf:"bytes,4,opt,name=bucket_access_control,json=bucketAccessControl,proto3" json:"bucket_access_control,omitempty"`
	// List of fields to be updated.
	//
	// To specify ALL fields, equivalent to the JSON API's "update" function,
	// specify a single field with the value `*`.
	//
	//
	// Not specifying any fields is an error.
	// Not specifying a field while setting that field to a non-default value is
	// an error.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,5,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,6,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *PatchBucketAccessControlRequest) Reset() {
	*x = PatchBucketAccessControlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchBucketAccessControlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchBucketAccessControlRequest) ProtoMessage() {}

func (x *PatchBucketAccessControlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchBucketAccessControlRequest.ProtoReflect.Descriptor instead.
func (*PatchBucketAccessControlRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{4}
}

func (x *PatchBucketAccessControlRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *PatchBucketAccessControlRequest) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *PatchBucketAccessControlRequest) GetBucketAccessControl() *BucketAccessControl {
	if x != nil {
		return x.BucketAccessControl
	}
	return nil
}

func (x *PatchBucketAccessControlRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *PatchBucketAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request for UpdateBucketAccessControl.
type UpdateBucketAccessControlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The entity holding the permission. Can be one of:
	// * `user-`*userId*
	// * `user-`*emailAddress*
	// * `group-`*groupId*
	// * `group-`*emailAddress*
	// * `allUsers`
	// * `allAuthenticatedUsers`
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// The BucketAccessControl for updating.
	BucketAccessControl *BucketAccessControl `protobuf:"bytes,4,opt,name=bucket_access_control,json=bucketAccessControl,proto3" json:"bucket_access_control,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,5,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *UpdateBucketAccessControlRequest) Reset() {
	*x = UpdateBucketAccessControlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateBucketAccessControlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBucketAccessControlRequest) ProtoMessage() {}

func (x *UpdateBucketAccessControlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBucketAccessControlRequest.ProtoReflect.Descriptor instead.
func (*UpdateBucketAccessControlRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateBucketAccessControlRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *UpdateBucketAccessControlRequest) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *UpdateBucketAccessControlRequest) GetBucketAccessControl() *BucketAccessControl {
	if x != nil {
		return x.BucketAccessControl
	}
	return nil
}

func (x *UpdateBucketAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for DeleteBucket.
type DeleteBucketRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// If set, only deletes the bucket if its metageneration matches this value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,2,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// If set, only deletes the bucket if its metageneration does not match this
	// value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,3,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,5,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *DeleteBucketRequest) Reset() {
	*x = DeleteBucketRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteBucketRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBucketRequest) ProtoMessage() {}

func (x *DeleteBucketRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBucketRequest.ProtoReflect.Descriptor instead.
func (*DeleteBucketRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteBucketRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *DeleteBucketRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationMatch
	}
	return nil
}

func (x *DeleteBucketRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationNotMatch
	}
	return nil
}

func (x *DeleteBucketRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for GetBucket.
type GetBucketRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Makes the return of the bucket metadata conditional on whether the bucket's
	// current metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,2,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Makes the return of the bucket metadata conditional on whether the bucket's
	// current metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,3,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// Set of properties to return. Defaults to `NO_ACL`.
	Projection CommonEnums_Projection `protobuf:"varint,4,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,6,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *GetBucketRequest) Reset() {
	*x = GetBucketRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBucketRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBucketRequest) ProtoMessage() {}

func (x *GetBucketRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBucketRequest.ProtoReflect.Descriptor instead.
func (*GetBucketRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{7}
}

func (x *GetBucketRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *GetBucketRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationMatch
	}
	return nil
}

func (x *GetBucketRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationNotMatch
	}
	return nil
}

func (x *GetBucketRequest) GetProjection() CommonEnums_Projection {
	if x != nil {
		return x.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (x *GetBucketRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for InsertBucket.
type InsertBucketRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Apply a predefined set of access controls to this bucket.
	PredefinedAcl CommonEnums_PredefinedBucketAcl `protobuf:"varint,1,opt,name=predefined_acl,json=predefinedAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedBucketAcl" json:"predefined_acl,omitempty"`
	// Apply a predefined set of default object access controls to this bucket.
	PredefinedDefaultObjectAcl CommonEnums_PredefinedObjectAcl `protobuf:"varint,2,opt,name=predefined_default_object_acl,json=predefinedDefaultObjectAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedObjectAcl" json:"predefined_default_object_acl,omitempty"`
	// Required. A valid API project identifier.
	Project string `protobuf:"bytes,3,opt,name=project,proto3" json:"project,omitempty"`
	// Set of properties to return. Defaults to `NO_ACL`, unless the
	// bucket resource specifies `acl` or `defaultObjectAcl`
	// properties, when it defaults to `FULL`.
	Projection CommonEnums_Projection `protobuf:"varint,4,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// Properties of the new bucket being inserted, including its name.
	Bucket *Bucket `protobuf:"bytes,6,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,7,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *InsertBucketRequest) Reset() {
	*x = InsertBucketRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InsertBucketRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InsertBucketRequest) ProtoMessage() {}

func (x *InsertBucketRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InsertBucketRequest.ProtoReflect.Descriptor instead.
func (*InsertBucketRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{8}
}

func (x *InsertBucketRequest) GetPredefinedAcl() CommonEnums_PredefinedBucketAcl {
	if x != nil {
		return x.PredefinedAcl
	}
	return CommonEnums_PREDEFINED_BUCKET_ACL_UNSPECIFIED
}

func (x *InsertBucketRequest) GetPredefinedDefaultObjectAcl() CommonEnums_PredefinedObjectAcl {
	if x != nil {
		return x.PredefinedDefaultObjectAcl
	}
	return CommonEnums_PREDEFINED_OBJECT_ACL_UNSPECIFIED
}

func (x *InsertBucketRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *InsertBucketRequest) GetProjection() CommonEnums_Projection {
	if x != nil {
		return x.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (x *InsertBucketRequest) GetBucket() *Bucket {
	if x != nil {
		return x.Bucket
	}
	return nil
}

func (x *InsertBucketRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for ListChannels.
type ListChannelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,3,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *ListChannelsRequest) Reset() {
	*x = ListChannelsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListChannelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListChannelsRequest) ProtoMessage() {}

func (x *ListChannelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListChannelsRequest.ProtoReflect.Descriptor instead.
func (*ListChannelsRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{9}
}

func (x *ListChannelsRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *ListChannelsRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for ListBuckets.
type ListBucketsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Maximum number of buckets to return in a single response. The service will
	// use this parameter or 1,000 items, whichever is smaller.
	MaxResults int32 `protobuf:"varint,1,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// A previously-returned page token representing part of the larger set of
	// results to view.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filter results to buckets whose names begin with this prefix.
	Prefix string `protobuf:"bytes,3,opt,name=prefix,proto3" json:"prefix,omitempty"`
	// Required. A valid API project identifier.
	Project string `protobuf:"bytes,4,opt,name=project,proto3" json:"project,omitempty"`
	// Set of properties to return. Defaults to `NO_ACL`.
	Projection CommonEnums_Projection `protobuf:"varint,5,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,7,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *ListBucketsRequest) Reset() {
	*x = ListBucketsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBucketsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBucketsRequest) ProtoMessage() {}

func (x *ListBucketsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBucketsRequest.ProtoReflect.Descriptor instead.
func (*ListBucketsRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{10}
}

func (x *ListBucketsRequest) GetMaxResults() int32 {
	if x != nil {
		return x.MaxResults
	}
	return 0
}

func (x *ListBucketsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListBucketsRequest) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

func (x *ListBucketsRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *ListBucketsRequest) GetProjection() CommonEnums_Projection {
	if x != nil {
		return x.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (x *ListBucketsRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for LockRetentionPolicy.
type LockRetentionPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Makes the operation conditional on whether bucket's current metageneration
	// matches the given value. Must be positive.
	IfMetagenerationMatch int64 `protobuf:"varint,2,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,4,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *LockRetentionPolicyRequest) Reset() {
	*x = LockRetentionPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LockRetentionPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LockRetentionPolicyRequest) ProtoMessage() {}

func (x *LockRetentionPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LockRetentionPolicyRequest.ProtoReflect.Descriptor instead.
func (*LockRetentionPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{11}
}

func (x *LockRetentionPolicyRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *LockRetentionPolicyRequest) GetIfMetagenerationMatch() int64 {
	if x != nil {
		return x.IfMetagenerationMatch
	}
	return 0
}

func (x *LockRetentionPolicyRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request for PatchBucket method.
type PatchBucketRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Makes the return of the bucket metadata conditional on whether the bucket's
	// current metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,2,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Makes the return of the bucket metadata conditional on whether the bucket's
	// current metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,3,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// Apply a predefined set of access controls to this bucket.
	PredefinedAcl CommonEnums_PredefinedBucketAcl `protobuf:"varint,4,opt,name=predefined_acl,json=predefinedAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedBucketAcl" json:"predefined_acl,omitempty"`
	// Apply a predefined set of default object access controls to this bucket.
	PredefinedDefaultObjectAcl CommonEnums_PredefinedObjectAcl `protobuf:"varint,5,opt,name=predefined_default_object_acl,json=predefinedDefaultObjectAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedObjectAcl" json:"predefined_default_object_acl,omitempty"`
	// Set of properties to return. Defaults to `FULL`.
	Projection CommonEnums_Projection `protobuf:"varint,6,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// The Bucket metadata for updating.
	Metadata *Bucket `protobuf:"bytes,8,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// List of fields to be updated.
	//
	// To specify ALL fields, equivalent to the JSON API's "update" function,
	// specify a single field with the value `*`. Note: not recommended. If a new
	// field is introduced at a later time, an older client updating with the `*`
	// may accidentally reset the new field's value.
	//
	// Not specifying any fields is an error.
	// Not specifying a field while setting that field to a non-default value is
	// an error.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,9,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,10,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *PatchBucketRequest) Reset() {
	*x = PatchBucketRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchBucketRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchBucketRequest) ProtoMessage() {}

func (x *PatchBucketRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchBucketRequest.ProtoReflect.Descriptor instead.
func (*PatchBucketRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{12}
}

func (x *PatchBucketRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *PatchBucketRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationMatch
	}
	return nil
}

func (x *PatchBucketRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationNotMatch
	}
	return nil
}

func (x *PatchBucketRequest) GetPredefinedAcl() CommonEnums_PredefinedBucketAcl {
	if x != nil {
		return x.PredefinedAcl
	}
	return CommonEnums_PREDEFINED_BUCKET_ACL_UNSPECIFIED
}

func (x *PatchBucketRequest) GetPredefinedDefaultObjectAcl() CommonEnums_PredefinedObjectAcl {
	if x != nil {
		return x.PredefinedDefaultObjectAcl
	}
	return CommonEnums_PREDEFINED_OBJECT_ACL_UNSPECIFIED
}

func (x *PatchBucketRequest) GetProjection() CommonEnums_Projection {
	if x != nil {
		return x.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (x *PatchBucketRequest) GetMetadata() *Bucket {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *PatchBucketRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *PatchBucketRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request for UpdateBucket method.
type UpdateBucketRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Makes the return of the bucket metadata conditional on whether the bucket's
	// current metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,2,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Makes the return of the bucket metadata conditional on whether the bucket's
	// current metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,3,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// Apply a predefined set of access controls to this bucket.
	PredefinedAcl CommonEnums_PredefinedBucketAcl `protobuf:"varint,4,opt,name=predefined_acl,json=predefinedAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedBucketAcl" json:"predefined_acl,omitempty"`
	// Apply a predefined set of default object access controls to this bucket.
	PredefinedDefaultObjectAcl CommonEnums_PredefinedObjectAcl `protobuf:"varint,5,opt,name=predefined_default_object_acl,json=predefinedDefaultObjectAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedObjectAcl" json:"predefined_default_object_acl,omitempty"`
	// Set of properties to return. Defaults to `FULL`.
	Projection CommonEnums_Projection `protobuf:"varint,6,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// The Bucket metadata for updating.
	Metadata *Bucket `protobuf:"bytes,8,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,9,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *UpdateBucketRequest) Reset() {
	*x = UpdateBucketRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateBucketRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBucketRequest) ProtoMessage() {}

func (x *UpdateBucketRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBucketRequest.ProtoReflect.Descriptor instead.
func (*UpdateBucketRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{13}
}

func (x *UpdateBucketRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *UpdateBucketRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationMatch
	}
	return nil
}

func (x *UpdateBucketRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationNotMatch
	}
	return nil
}

func (x *UpdateBucketRequest) GetPredefinedAcl() CommonEnums_PredefinedBucketAcl {
	if x != nil {
		return x.PredefinedAcl
	}
	return CommonEnums_PREDEFINED_BUCKET_ACL_UNSPECIFIED
}

func (x *UpdateBucketRequest) GetPredefinedDefaultObjectAcl() CommonEnums_PredefinedObjectAcl {
	if x != nil {
		return x.PredefinedDefaultObjectAcl
	}
	return CommonEnums_PREDEFINED_OBJECT_ACL_UNSPECIFIED
}

func (x *UpdateBucketRequest) GetProjection() CommonEnums_Projection {
	if x != nil {
		return x.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (x *UpdateBucketRequest) GetMetadata() *Bucket {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *UpdateBucketRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for StopChannel.
type StopChannelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The channel to be stopped.
	Channel *Channel `protobuf:"bytes,1,opt,name=channel,proto3" json:"channel,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,2,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *StopChannelRequest) Reset() {
	*x = StopChannelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StopChannelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopChannelRequest) ProtoMessage() {}

func (x *StopChannelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopChannelRequest.ProtoReflect.Descriptor instead.
func (*StopChannelRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{14}
}

func (x *StopChannelRequest) GetChannel() *Channel {
	if x != nil {
		return x.Channel
	}
	return nil
}

func (x *StopChannelRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for DeleteDefaultObjectAccessControl.
type DeleteDefaultObjectAccessControlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The entity holding the permission. Can be one of:
	// * `user-`*userId*
	// * `user-`*emailAddress*
	// * `group-`*groupId*
	// * `group-`*emailAddress*
	// * `allUsers`
	// * `allAuthenticatedUsers`
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,4,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *DeleteDefaultObjectAccessControlRequest) Reset() {
	*x = DeleteDefaultObjectAccessControlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDefaultObjectAccessControlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDefaultObjectAccessControlRequest) ProtoMessage() {}

func (x *DeleteDefaultObjectAccessControlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDefaultObjectAccessControlRequest.ProtoReflect.Descriptor instead.
func (*DeleteDefaultObjectAccessControlRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{15}
}

func (x *DeleteDefaultObjectAccessControlRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *DeleteDefaultObjectAccessControlRequest) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *DeleteDefaultObjectAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for GetDefaultObjectAccessControl.
type GetDefaultObjectAccessControlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The entity holding the permission. Can be one of:
	// * `user-`*userId*
	// * `user-`*emailAddress*
	// * `group-`*groupId*
	// * `group-`*emailAddress*
	// * `allUsers`
	// * `allAuthenticatedUsers`
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,4,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *GetDefaultObjectAccessControlRequest) Reset() {
	*x = GetDefaultObjectAccessControlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDefaultObjectAccessControlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDefaultObjectAccessControlRequest) ProtoMessage() {}

func (x *GetDefaultObjectAccessControlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDefaultObjectAccessControlRequest.ProtoReflect.Descriptor instead.
func (*GetDefaultObjectAccessControlRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{16}
}

func (x *GetDefaultObjectAccessControlRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *GetDefaultObjectAccessControlRequest) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *GetDefaultObjectAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for InsertDefaultObjectAccessControl.
type InsertDefaultObjectAccessControlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Properties of the object access control being inserted.
	ObjectAccessControl *ObjectAccessControl `protobuf:"bytes,3,opt,name=object_access_control,json=objectAccessControl,proto3" json:"object_access_control,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,4,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *InsertDefaultObjectAccessControlRequest) Reset() {
	*x = InsertDefaultObjectAccessControlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InsertDefaultObjectAccessControlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InsertDefaultObjectAccessControlRequest) ProtoMessage() {}

func (x *InsertDefaultObjectAccessControlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InsertDefaultObjectAccessControlRequest.ProtoReflect.Descriptor instead.
func (*InsertDefaultObjectAccessControlRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{17}
}

func (x *InsertDefaultObjectAccessControlRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *InsertDefaultObjectAccessControlRequest) GetObjectAccessControl() *ObjectAccessControl {
	if x != nil {
		return x.ObjectAccessControl
	}
	return nil
}

func (x *InsertDefaultObjectAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for ListDefaultObjectAccessControls.
type ListDefaultObjectAccessControlsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// If present, only return default ACL listing if the bucket's current
	// metageneration matches this value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,2,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// If present, only return default ACL listing if the bucket's current
	// metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,3,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,5,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *ListDefaultObjectAccessControlsRequest) Reset() {
	*x = ListDefaultObjectAccessControlsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDefaultObjectAccessControlsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDefaultObjectAccessControlsRequest) ProtoMessage() {}

func (x *ListDefaultObjectAccessControlsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDefaultObjectAccessControlsRequest.ProtoReflect.Descriptor instead.
func (*ListDefaultObjectAccessControlsRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{18}
}

func (x *ListDefaultObjectAccessControlsRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *ListDefaultObjectAccessControlsRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationMatch
	}
	return nil
}

func (x *ListDefaultObjectAccessControlsRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationNotMatch
	}
	return nil
}

func (x *ListDefaultObjectAccessControlsRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for PatchDefaultObjectAccessControl.
type PatchDefaultObjectAccessControlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The entity holding the permission. Can be one of:
	// * `user-`*userId*
	// * `user-`*emailAddress*
	// * `group-`*groupId*
	// * `group-`*emailAddress*
	// * `allUsers`
	// * `allAuthenticatedUsers`
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// The ObjectAccessControl for updating.
	ObjectAccessControl *ObjectAccessControl `protobuf:"bytes,4,opt,name=object_access_control,json=objectAccessControl,proto3" json:"object_access_control,omitempty"`
	// List of fields to be updated.
	//
	// To specify ALL fields, equivalent to the JSON API's "update" function,
	// specify a single field with the value `*`. Note: not recommended. If a new
	// field is introduced at a later time, an older client updating with the `*`
	// may accidentally reset the new field's value.
	//
	// Not specifying any fields is an error.
	// Not specifying a field while setting that field to a non-default value is
	// an error.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,5,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,6,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *PatchDefaultObjectAccessControlRequest) Reset() {
	*x = PatchDefaultObjectAccessControlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchDefaultObjectAccessControlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchDefaultObjectAccessControlRequest) ProtoMessage() {}

func (x *PatchDefaultObjectAccessControlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchDefaultObjectAccessControlRequest.ProtoReflect.Descriptor instead.
func (*PatchDefaultObjectAccessControlRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{19}
}

func (x *PatchDefaultObjectAccessControlRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *PatchDefaultObjectAccessControlRequest) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *PatchDefaultObjectAccessControlRequest) GetObjectAccessControl() *ObjectAccessControl {
	if x != nil {
		return x.ObjectAccessControl
	}
	return nil
}

func (x *PatchDefaultObjectAccessControlRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *PatchDefaultObjectAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for UpdateDefaultObjectAccessControl.
type UpdateDefaultObjectAccessControlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The entity holding the permission. Can be one of:
	// * `user-`*userId*
	// * `user-`*emailAddress*
	// * `group-`*groupId*
	// * `group-`*emailAddress*
	// * `allUsers`
	// * `allAuthenticatedUsers`
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// The ObjectAccessControl for updating.
	ObjectAccessControl *ObjectAccessControl `protobuf:"bytes,4,opt,name=object_access_control,json=objectAccessControl,proto3" json:"object_access_control,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,5,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *UpdateDefaultObjectAccessControlRequest) Reset() {
	*x = UpdateDefaultObjectAccessControlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDefaultObjectAccessControlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDefaultObjectAccessControlRequest) ProtoMessage() {}

func (x *UpdateDefaultObjectAccessControlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDefaultObjectAccessControlRequest.ProtoReflect.Descriptor instead.
func (*UpdateDefaultObjectAccessControlRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{20}
}

func (x *UpdateDefaultObjectAccessControlRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *UpdateDefaultObjectAccessControlRequest) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *UpdateDefaultObjectAccessControlRequest) GetObjectAccessControl() *ObjectAccessControl {
	if x != nil {
		return x.ObjectAccessControl
	}
	return nil
}

func (x *UpdateDefaultObjectAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for DeleteNotification.
type DeleteNotificationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent bucket of the notification.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. ID of the notification to delete.
	Notification string `protobuf:"bytes,2,opt,name=notification,proto3" json:"notification,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,4,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *DeleteNotificationRequest) Reset() {
	*x = DeleteNotificationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteNotificationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteNotificationRequest) ProtoMessage() {}

func (x *DeleteNotificationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteNotificationRequest.ProtoReflect.Descriptor instead.
func (*DeleteNotificationRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{21}
}

func (x *DeleteNotificationRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *DeleteNotificationRequest) GetNotification() string {
	if x != nil {
		return x.Notification
	}
	return ""
}

func (x *DeleteNotificationRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for GetNotification.
type GetNotificationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent bucket of the notification.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. Notification ID.
	// Required.
	Notification string `protobuf:"bytes,2,opt,name=notification,proto3" json:"notification,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,4,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *GetNotificationRequest) Reset() {
	*x = GetNotificationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNotificationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNotificationRequest) ProtoMessage() {}

func (x *GetNotificationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNotificationRequest.ProtoReflect.Descriptor instead.
func (*GetNotificationRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{22}
}

func (x *GetNotificationRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *GetNotificationRequest) GetNotification() string {
	if x != nil {
		return x.Notification
	}
	return ""
}

func (x *GetNotificationRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for InsertNotification.
type InsertNotificationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent bucket of the notification.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Properties of the notification to be inserted.
	Notification *Notification `protobuf:"bytes,3,opt,name=notification,proto3" json:"notification,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,4,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *InsertNotificationRequest) Reset() {
	*x = InsertNotificationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InsertNotificationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InsertNotificationRequest) ProtoMessage() {}

func (x *InsertNotificationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InsertNotificationRequest.ProtoReflect.Descriptor instead.
func (*InsertNotificationRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{23}
}

func (x *InsertNotificationRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *InsertNotificationRequest) GetNotification() *Notification {
	if x != nil {
		return x.Notification
	}
	return nil
}

func (x *InsertNotificationRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for ListNotifications.
type ListNotificationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a Google Cloud Storage bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,3,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *ListNotificationsRequest) Reset() {
	*x = ListNotificationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNotificationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNotificationsRequest) ProtoMessage() {}

func (x *ListNotificationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNotificationsRequest.ProtoReflect.Descriptor instead.
func (*ListNotificationsRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{24}
}

func (x *ListNotificationsRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *ListNotificationsRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for DeleteObjectAccessControl.
type DeleteObjectAccessControlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The entity holding the permission. Can be one of:
	// * `user-`*userId*
	// * `user-`*emailAddress*
	// * `group-`*groupId*
	// * `group-`*emailAddress*
	// * `allUsers`
	// * `allAuthenticatedUsers`
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// Required. Name of the object.
	Object string `protobuf:"bytes,3,opt,name=object,proto3" json:"object,omitempty"`
	// If present, selects a specific revision of this object (as opposed to the
	// latest version, the default).
	Generation int64 `protobuf:"varint,4,opt,name=generation,proto3" json:"generation,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,6,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *DeleteObjectAccessControlRequest) Reset() {
	*x = DeleteObjectAccessControlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteObjectAccessControlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteObjectAccessControlRequest) ProtoMessage() {}

func (x *DeleteObjectAccessControlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteObjectAccessControlRequest.ProtoReflect.Descriptor instead.
func (*DeleteObjectAccessControlRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{25}
}

func (x *DeleteObjectAccessControlRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *DeleteObjectAccessControlRequest) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *DeleteObjectAccessControlRequest) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

func (x *DeleteObjectAccessControlRequest) GetGeneration() int64 {
	if x != nil {
		return x.Generation
	}
	return 0
}

func (x *DeleteObjectAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for GetObjectAccessControl.
type GetObjectAccessControlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The entity holding the permission. Can be one of:
	// * `user-`*userId*
	// * `user-`*emailAddress*
	// * `group-`*groupId*
	// * `group-`*emailAddress*
	// * `allUsers`
	// * `allAuthenticatedUsers`
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// Required. Name of the object.
	Object string `protobuf:"bytes,3,opt,name=object,proto3" json:"object,omitempty"`
	// If present, selects a specific revision of this object (as opposed to the
	// latest version, the default).
	Generation int64 `protobuf:"varint,4,opt,name=generation,proto3" json:"generation,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,6,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *GetObjectAccessControlRequest) Reset() {
	*x = GetObjectAccessControlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetObjectAccessControlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetObjectAccessControlRequest) ProtoMessage() {}

func (x *GetObjectAccessControlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetObjectAccessControlRequest.ProtoReflect.Descriptor instead.
func (*GetObjectAccessControlRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{26}
}

func (x *GetObjectAccessControlRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *GetObjectAccessControlRequest) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *GetObjectAccessControlRequest) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

func (x *GetObjectAccessControlRequest) GetGeneration() int64 {
	if x != nil {
		return x.Generation
	}
	return 0
}

func (x *GetObjectAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for InsertObjectAccessControl.
type InsertObjectAccessControlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. Name of the object.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// If present, selects a specific revision of this object (as opposed to the
	// latest version, the default).
	Generation int64 `protobuf:"varint,3,opt,name=generation,proto3" json:"generation,omitempty"`
	// Properties of the object access control to be inserted.
	ObjectAccessControl *ObjectAccessControl `protobuf:"bytes,5,opt,name=object_access_control,json=objectAccessControl,proto3" json:"object_access_control,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,6,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *InsertObjectAccessControlRequest) Reset() {
	*x = InsertObjectAccessControlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InsertObjectAccessControlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InsertObjectAccessControlRequest) ProtoMessage() {}

func (x *InsertObjectAccessControlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InsertObjectAccessControlRequest.ProtoReflect.Descriptor instead.
func (*InsertObjectAccessControlRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{27}
}

func (x *InsertObjectAccessControlRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *InsertObjectAccessControlRequest) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

func (x *InsertObjectAccessControlRequest) GetGeneration() int64 {
	if x != nil {
		return x.Generation
	}
	return 0
}

func (x *InsertObjectAccessControlRequest) GetObjectAccessControl() *ObjectAccessControl {
	if x != nil {
		return x.ObjectAccessControl
	}
	return nil
}

func (x *InsertObjectAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for ListObjectAccessControls.
type ListObjectAccessControlsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. Name of the object.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// If present, selects a specific revision of this object (as opposed to the
	// latest version, the default).
	Generation int64 `protobuf:"varint,3,opt,name=generation,proto3" json:"generation,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,5,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *ListObjectAccessControlsRequest) Reset() {
	*x = ListObjectAccessControlsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListObjectAccessControlsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListObjectAccessControlsRequest) ProtoMessage() {}

func (x *ListObjectAccessControlsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListObjectAccessControlsRequest.ProtoReflect.Descriptor instead.
func (*ListObjectAccessControlsRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{28}
}

func (x *ListObjectAccessControlsRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *ListObjectAccessControlsRequest) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

func (x *ListObjectAccessControlsRequest) GetGeneration() int64 {
	if x != nil {
		return x.Generation
	}
	return 0
}

func (x *ListObjectAccessControlsRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for PatchObjectAccessControl.
type PatchObjectAccessControlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The entity holding the permission. Can be one of:
	// * `user-`*userId*
	// * `user-`*emailAddress*
	// * `group-`*groupId*
	// * `group-`*emailAddress*
	// * `allUsers`
	// * `allAuthenticatedUsers`
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// Required. Name of the object.
	// Required.
	Object string `protobuf:"bytes,3,opt,name=object,proto3" json:"object,omitempty"`
	// If present, selects a specific revision of this object (as opposed to the
	// latest version, the default).
	Generation int64 `protobuf:"varint,4,opt,name=generation,proto3" json:"generation,omitempty"`
	// The ObjectAccessControl for updating.
	ObjectAccessControl *ObjectAccessControl `protobuf:"bytes,5,opt,name=object_access_control,json=objectAccessControl,proto3" json:"object_access_control,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,6,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	// List of fields to be updated.
	//
	// To specify ALL fields, equivalent to the JSON API's "update" function,
	// specify a single field with the value `*`. Note: not recommended. If a new
	// field is introduced at a later time, an older client updating with the `*`
	// may accidentally reset the new field's value.
	//
	// Not specifying any fields is an error.
	// Not specifying a field while setting that field to a non-default value is
	// an error.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,7,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *PatchObjectAccessControlRequest) Reset() {
	*x = PatchObjectAccessControlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchObjectAccessControlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchObjectAccessControlRequest) ProtoMessage() {}

func (x *PatchObjectAccessControlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchObjectAccessControlRequest.ProtoReflect.Descriptor instead.
func (*PatchObjectAccessControlRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{29}
}

func (x *PatchObjectAccessControlRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *PatchObjectAccessControlRequest) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *PatchObjectAccessControlRequest) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

func (x *PatchObjectAccessControlRequest) GetGeneration() int64 {
	if x != nil {
		return x.Generation
	}
	return 0
}

func (x *PatchObjectAccessControlRequest) GetObjectAccessControl() *ObjectAccessControl {
	if x != nil {
		return x.ObjectAccessControl
	}
	return nil
}

func (x *PatchObjectAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

func (x *PatchObjectAccessControlRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for UpdateObjectAccessControl.
type UpdateObjectAccessControlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of a bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The entity holding the permission. Can be one of:
	// * `user-`*userId*
	// * `user-`*emailAddress*
	// * `group-`*groupId*
	// * `group-`*emailAddress*
	// * `allUsers`
	// * `allAuthenticatedUsers`
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// Required. Name of the object.
	// Required.
	Object string `protobuf:"bytes,3,opt,name=object,proto3" json:"object,omitempty"`
	// If present, selects a specific revision of this object (as opposed to the
	// latest version, the default).
	Generation int64 `protobuf:"varint,4,opt,name=generation,proto3" json:"generation,omitempty"`
	// The ObjectAccessControl for updating.
	ObjectAccessControl *ObjectAccessControl `protobuf:"bytes,6,opt,name=object_access_control,json=objectAccessControl,proto3" json:"object_access_control,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,7,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
	// List of fields to be updated.
	//
	// To specify ALL fields, equivalent to the JSON API's "update" function,
	// specify a single field with the value `*`. Note: not recommended. If a new
	// field is introduced at a later time, an older client updating with the `*`
	// may accidentally reset the new field's value.
	//
	// Not specifying any fields is an error.
	// Not specifying a field while setting that field to a non-default value is
	// an error.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,8,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateObjectAccessControlRequest) Reset() {
	*x = UpdateObjectAccessControlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateObjectAccessControlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateObjectAccessControlRequest) ProtoMessage() {}

func (x *UpdateObjectAccessControlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateObjectAccessControlRequest.ProtoReflect.Descriptor instead.
func (*UpdateObjectAccessControlRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{30}
}

func (x *UpdateObjectAccessControlRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *UpdateObjectAccessControlRequest) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *UpdateObjectAccessControlRequest) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

func (x *UpdateObjectAccessControlRequest) GetGeneration() int64 {
	if x != nil {
		return x.Generation
	}
	return 0
}

func (x *UpdateObjectAccessControlRequest) GetObjectAccessControl() *ObjectAccessControl {
	if x != nil {
		return x.ObjectAccessControl
	}
	return nil
}

func (x *UpdateObjectAccessControlRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

func (x *UpdateObjectAccessControlRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ComposeObject.
type ComposeObjectRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the bucket containing the source objects. The destination object is
	// stored in this bucket.
	DestinationBucket string `protobuf:"bytes,1,opt,name=destination_bucket,json=destinationBucket,proto3" json:"destination_bucket,omitempty"`
	// Required. Name of the new object.
	DestinationObject string `protobuf:"bytes,2,opt,name=destination_object,json=destinationObject,proto3" json:"destination_object,omitempty"`
	// Apply a predefined set of access controls to the destination object.
	DestinationPredefinedAcl CommonEnums_PredefinedObjectAcl `protobuf:"varint,3,opt,name=destination_predefined_acl,json=destinationPredefinedAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedObjectAcl" json:"destination_predefined_acl,omitempty"`
	// Properties of the resulting object.
	Destination *Object `protobuf:"bytes,11,opt,name=destination,proto3" json:"destination,omitempty"`
	// The list of source objects that will be concatenated into a single object.
	SourceObjects []*ComposeObjectRequest_SourceObjects `protobuf:"bytes,12,rep,name=source_objects,json=sourceObjects,proto3" json:"source_objects,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// matches the given value. Setting to 0 makes the operation succeed only if
	// there are no live versions of the object.
	IfGenerationMatch *wrappers.Int64Value `protobuf:"bytes,4,opt,name=if_generation_match,json=ifGenerationMatch,proto3" json:"if_generation_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,5,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Resource name of the Cloud KMS key, of the form
	// `projects/my-project/locations/my-location/keyRings/my-kr/cryptoKeys/my-key`,
	// that will be used to encrypt the object. Overrides the object
	// metadata's `kms_key_name` value, if any.
	KmsKeyName string `protobuf:"bytes,6,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,9,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,10,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *ComposeObjectRequest) Reset() {
	*x = ComposeObjectRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComposeObjectRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComposeObjectRequest) ProtoMessage() {}

func (x *ComposeObjectRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComposeObjectRequest.ProtoReflect.Descriptor instead.
func (*ComposeObjectRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{31}
}

func (x *ComposeObjectRequest) GetDestinationBucket() string {
	if x != nil {
		return x.DestinationBucket
	}
	return ""
}

func (x *ComposeObjectRequest) GetDestinationObject() string {
	if x != nil {
		return x.DestinationObject
	}
	return ""
}

func (x *ComposeObjectRequest) GetDestinationPredefinedAcl() CommonEnums_PredefinedObjectAcl {
	if x != nil {
		return x.DestinationPredefinedAcl
	}
	return CommonEnums_PREDEFINED_OBJECT_ACL_UNSPECIFIED
}

func (x *ComposeObjectRequest) GetDestination() *Object {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *ComposeObjectRequest) GetSourceObjects() []*ComposeObjectRequest_SourceObjects {
	if x != nil {
		return x.SourceObjects
	}
	return nil
}

func (x *ComposeObjectRequest) GetIfGenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfGenerationMatch
	}
	return nil
}

func (x *ComposeObjectRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationMatch
	}
	return nil
}

func (x *ComposeObjectRequest) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

func (x *ComposeObjectRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if x != nil {
		return x.CommonObjectRequestParams
	}
	return nil
}

func (x *ComposeObjectRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for CopyObject.
type CopyObjectRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the bucket in which to store the new object. Overrides the provided
	// object
	// metadata's `bucket` value, if any.
	DestinationBucket string `protobuf:"bytes,1,opt,name=destination_bucket,json=destinationBucket,proto3" json:"destination_bucket,omitempty"`
	// Required. Name of the new object.
	// Required when the object metadata is not otherwise provided. Overrides the
	// object metadata's `name` value, if any.
	DestinationObject string `protobuf:"bytes,2,opt,name=destination_object,json=destinationObject,proto3" json:"destination_object,omitempty"`
	// Apply a predefined set of access controls to the destination object.
	DestinationPredefinedAcl CommonEnums_PredefinedObjectAcl `protobuf:"varint,3,opt,name=destination_predefined_acl,json=destinationPredefinedAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedObjectAcl" json:"destination_predefined_acl,omitempty"`
	// Makes the operation conditional on whether the destination object's current
	// generation matches the given value. Setting to 0 makes the operation
	// succeed only if there are no live versions of the object.
	IfGenerationMatch *wrappers.Int64Value `protobuf:"bytes,4,opt,name=if_generation_match,json=ifGenerationMatch,proto3" json:"if_generation_match,omitempty"`
	// Makes the operation conditional on whether the destination object's current
	// generation does not match the given value. If no live object exists, the
	// precondition fails. Setting to 0 makes the operation succeed only if there
	// is a live version of the object.
	IfGenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,5,opt,name=if_generation_not_match,json=ifGenerationNotMatch,proto3" json:"if_generation_not_match,omitempty"`
	// Makes the operation conditional on whether the destination object's current
	// metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,6,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Makes the operation conditional on whether the destination object's current
	// metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,7,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// Makes the operation conditional on whether the source object's current
	// generation matches the given value.
	IfSourceGenerationMatch *wrappers.Int64Value `protobuf:"bytes,8,opt,name=if_source_generation_match,json=ifSourceGenerationMatch,proto3" json:"if_source_generation_match,omitempty"`
	// Makes the operation conditional on whether the source object's current
	// generation does not match the given value.
	IfSourceGenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,9,opt,name=if_source_generation_not_match,json=ifSourceGenerationNotMatch,proto3" json:"if_source_generation_not_match,omitempty"`
	// Makes the operation conditional on whether the source object's current
	// metageneration matches the given value.
	IfSourceMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,10,opt,name=if_source_metageneration_match,json=ifSourceMetagenerationMatch,proto3" json:"if_source_metageneration_match,omitempty"`
	// Makes the operation conditional on whether the source object's current
	// metageneration does not match the given value.
	IfSourceMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,11,opt,name=if_source_metageneration_not_match,json=ifSourceMetagenerationNotMatch,proto3" json:"if_source_metageneration_not_match,omitempty"`
	// Set of properties to return. Defaults to `NO_ACL`, unless the
	// object resource specifies the `acl` property, when it defaults
	// to `full`.
	Projection CommonEnums_Projection `protobuf:"varint,12,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// Required. Name of the bucket in which to find the source object.
	SourceBucket string `protobuf:"bytes,13,opt,name=source_bucket,json=sourceBucket,proto3" json:"source_bucket,omitempty"`
	// Required. Name of the source object.
	SourceObject string `protobuf:"bytes,14,opt,name=source_object,json=sourceObject,proto3" json:"source_object,omitempty"`
	// If present, selects a specific revision of the source object (as opposed to
	// the latest version, the default).
	SourceGeneration int64 `protobuf:"varint,15,opt,name=source_generation,json=sourceGeneration,proto3" json:"source_generation,omitempty"`
	// Properties of the resulting object. If not set, duplicate properties of
	// source object.
	Destination *Object `protobuf:"bytes,17,opt,name=destination,proto3" json:"destination,omitempty"`
	// Resource name of the Cloud KMS key, of the form
	// `projects/my-project/locations/my-location/keyRings/my-kr/cryptoKeys/my-key`,
	// that will be used to encrypt the object. Overrides the object
	// metadata's `kms_key_name` value, if any.
	DestinationKmsKeyName string `protobuf:"bytes,20,opt,name=destination_kms_key_name,json=destinationKmsKeyName,proto3" json:"destination_kms_key_name,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,18,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,19,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *CopyObjectRequest) Reset() {
	*x = CopyObjectRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CopyObjectRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CopyObjectRequest) ProtoMessage() {}

func (x *CopyObjectRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CopyObjectRequest.ProtoReflect.Descriptor instead.
func (*CopyObjectRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{32}
}

func (x *CopyObjectRequest) GetDestinationBucket() string {
	if x != nil {
		return x.DestinationBucket
	}
	return ""
}

func (x *CopyObjectRequest) GetDestinationObject() string {
	if x != nil {
		return x.DestinationObject
	}
	return ""
}

func (x *CopyObjectRequest) GetDestinationPredefinedAcl() CommonEnums_PredefinedObjectAcl {
	if x != nil {
		return x.DestinationPredefinedAcl
	}
	return CommonEnums_PREDEFINED_OBJECT_ACL_UNSPECIFIED
}

func (x *CopyObjectRequest) GetIfGenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfGenerationMatch
	}
	return nil
}

func (x *CopyObjectRequest) GetIfGenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfGenerationNotMatch
	}
	return nil
}

func (x *CopyObjectRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationMatch
	}
	return nil
}

func (x *CopyObjectRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationNotMatch
	}
	return nil
}

func (x *CopyObjectRequest) GetIfSourceGenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfSourceGenerationMatch
	}
	return nil
}

func (x *CopyObjectRequest) GetIfSourceGenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfSourceGenerationNotMatch
	}
	return nil
}

func (x *CopyObjectRequest) GetIfSourceMetagenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfSourceMetagenerationMatch
	}
	return nil
}

func (x *CopyObjectRequest) GetIfSourceMetagenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfSourceMetagenerationNotMatch
	}
	return nil
}

func (x *CopyObjectRequest) GetProjection() CommonEnums_Projection {
	if x != nil {
		return x.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (x *CopyObjectRequest) GetSourceBucket() string {
	if x != nil {
		return x.SourceBucket
	}
	return ""
}

func (x *CopyObjectRequest) GetSourceObject() string {
	if x != nil {
		return x.SourceObject
	}
	return ""
}

func (x *CopyObjectRequest) GetSourceGeneration() int64 {
	if x != nil {
		return x.SourceGeneration
	}
	return 0
}

func (x *CopyObjectRequest) GetDestination() *Object {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *CopyObjectRequest) GetDestinationKmsKeyName() string {
	if x != nil {
		return x.DestinationKmsKeyName
	}
	return ""
}

func (x *CopyObjectRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if x != nil {
		return x.CommonObjectRequestParams
	}
	return nil
}

func (x *CopyObjectRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Message for deleting an object.
// Either `bucket` and `object` *or* `upload_id` **must** be set (but not both).
type DeleteObjectRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the bucket in which the object resides.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. The name of the object to delete (when not using a resumable write).
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// The resumable upload_id of the object to delete (when using a
	// resumable write). This should be copied from the `upload_id` field of
	// `StartResumableWriteResponse`.
	UploadId string `protobuf:"bytes,3,opt,name=upload_id,json=uploadId,proto3" json:"upload_id,omitempty"`
	// If present, permanently deletes a specific revision of this object (as
	// opposed to the latest version, the default).
	Generation int64 `protobuf:"varint,4,opt,name=generation,proto3" json:"generation,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// matches the given value. Setting to 0 makes the operation succeed only if
	// there are no live versions of the object.
	IfGenerationMatch *wrappers.Int64Value `protobuf:"bytes,5,opt,name=if_generation_match,json=ifGenerationMatch,proto3" json:"if_generation_match,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// does not match the given value. If no live object exists, the precondition
	// fails. Setting to 0 makes the operation succeed only if there is a live
	// version of the object.
	IfGenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,6,opt,name=if_generation_not_match,json=ifGenerationNotMatch,proto3" json:"if_generation_not_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,7,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,8,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,10,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,11,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *DeleteObjectRequest) Reset() {
	*x = DeleteObjectRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteObjectRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteObjectRequest) ProtoMessage() {}

func (x *DeleteObjectRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteObjectRequest.ProtoReflect.Descriptor instead.
func (*DeleteObjectRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{33}
}

func (x *DeleteObjectRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *DeleteObjectRequest) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

func (x *DeleteObjectRequest) GetUploadId() string {
	if x != nil {
		return x.UploadId
	}
	return ""
}

func (x *DeleteObjectRequest) GetGeneration() int64 {
	if x != nil {
		return x.Generation
	}
	return 0
}

func (x *DeleteObjectRequest) GetIfGenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfGenerationMatch
	}
	return nil
}

func (x *DeleteObjectRequest) GetIfGenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfGenerationNotMatch
	}
	return nil
}

func (x *DeleteObjectRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationMatch
	}
	return nil
}

func (x *DeleteObjectRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationNotMatch
	}
	return nil
}

func (x *DeleteObjectRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if x != nil {
		return x.CommonObjectRequestParams
	}
	return nil
}

func (x *DeleteObjectRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for GetObjectMedia.
type GetObjectMediaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the bucket containing the object to read.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// The name of the object to read.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// If present, selects a specific revision of this object (as opposed
	// to the latest version, the default).
	Generation int64 `protobuf:"varint,3,opt,name=generation,proto3" json:"generation,omitempty"`
	// The offset for the first byte to return in the read, relative to the start
	// of the object.
	//
	// A negative `read_offset` value will be interpreted as the number of bytes
	// back from the end of the object to be returned. For example, if an object's
	// length is 15 bytes, a GetObjectMediaRequest with `read_offset` = -5 and
	// `read_limit` = 3 would return bytes 10 through 12 of the object.
	ReadOffset int64 `protobuf:"varint,4,opt,name=read_offset,json=readOffset,proto3" json:"read_offset,omitempty"`
	// The maximum number of `data` bytes the server is allowed to return in the
	// sum of all `Object` messages. A `read_limit` of zero indicates that there
	// is no limit, and a negative `read_limit` will cause an error.
	//
	// If the stream returns fewer bytes than allowed by the `read_limit` and no
	// error occurred, the stream includes all data from the `read_offset` to the
	// end of the resource.
	ReadLimit int64 `protobuf:"varint,5,opt,name=read_limit,json=readLimit,proto3" json:"read_limit,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// matches the given value. Setting to 0 makes the operation succeed only if
	// there are no live versions of the object.
	IfGenerationMatch *wrappers.Int64Value `protobuf:"bytes,6,opt,name=if_generation_match,json=ifGenerationMatch,proto3" json:"if_generation_match,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// does not match the given value. If no live object exists, the precondition
	// fails. Setting to 0 makes the operation succeed only if there is a live
	// version of the object.
	IfGenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,7,opt,name=if_generation_not_match,json=ifGenerationNotMatch,proto3" json:"if_generation_not_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,8,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,9,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,11,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,12,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *GetObjectMediaRequest) Reset() {
	*x = GetObjectMediaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetObjectMediaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetObjectMediaRequest) ProtoMessage() {}

func (x *GetObjectMediaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetObjectMediaRequest.ProtoReflect.Descriptor instead.
func (*GetObjectMediaRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{34}
}

func (x *GetObjectMediaRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *GetObjectMediaRequest) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

func (x *GetObjectMediaRequest) GetGeneration() int64 {
	if x != nil {
		return x.Generation
	}
	return 0
}

func (x *GetObjectMediaRequest) GetReadOffset() int64 {
	if x != nil {
		return x.ReadOffset
	}
	return 0
}

func (x *GetObjectMediaRequest) GetReadLimit() int64 {
	if x != nil {
		return x.ReadLimit
	}
	return 0
}

func (x *GetObjectMediaRequest) GetIfGenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfGenerationMatch
	}
	return nil
}

func (x *GetObjectMediaRequest) GetIfGenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfGenerationNotMatch
	}
	return nil
}

func (x *GetObjectMediaRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationMatch
	}
	return nil
}

func (x *GetObjectMediaRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationNotMatch
	}
	return nil
}

func (x *GetObjectMediaRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if x != nil {
		return x.CommonObjectRequestParams
	}
	return nil
}

func (x *GetObjectMediaRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for GetObject.
type GetObjectRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the bucket in which the object resides.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. Name of the object.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// If present, selects a specific revision of this object (as opposed to the
	// latest version, the default).
	Generation int64 `protobuf:"varint,3,opt,name=generation,proto3" json:"generation,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// matches the given value. Setting to 0 makes the operation succeed only if
	// there are no live versions of the object.
	IfGenerationMatch *wrappers.Int64Value `protobuf:"bytes,4,opt,name=if_generation_match,json=ifGenerationMatch,proto3" json:"if_generation_match,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// does not match the given value. If no live object exists, the precondition
	// fails. Setting to 0 makes the operation succeed only if there is a live
	// version of the object.
	IfGenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,5,opt,name=if_generation_not_match,json=ifGenerationNotMatch,proto3" json:"if_generation_not_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,6,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,7,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// Set of properties to return. Defaults to `NO_ACL`.
	Projection CommonEnums_Projection `protobuf:"varint,8,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,10,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,11,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *GetObjectRequest) Reset() {
	*x = GetObjectRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetObjectRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetObjectRequest) ProtoMessage() {}

func (x *GetObjectRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetObjectRequest.ProtoReflect.Descriptor instead.
func (*GetObjectRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{35}
}

func (x *GetObjectRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *GetObjectRequest) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

func (x *GetObjectRequest) GetGeneration() int64 {
	if x != nil {
		return x.Generation
	}
	return 0
}

func (x *GetObjectRequest) GetIfGenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfGenerationMatch
	}
	return nil
}

func (x *GetObjectRequest) GetIfGenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfGenerationNotMatch
	}
	return nil
}

func (x *GetObjectRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationMatch
	}
	return nil
}

func (x *GetObjectRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationNotMatch
	}
	return nil
}

func (x *GetObjectRequest) GetProjection() CommonEnums_Projection {
	if x != nil {
		return x.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (x *GetObjectRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if x != nil {
		return x.CommonObjectRequestParams
	}
	return nil
}

func (x *GetObjectRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Response message for GetObject.
type GetObjectMediaResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A portion of the data for the object. The service **may** leave `data`
	// empty for any given `ReadResponse`. This enables the service to inform the
	// client that the request is still live while it is running an operation to
	// generate more data.
	ChecksummedData *ChecksummedData `protobuf:"bytes,1,opt,name=checksummed_data,json=checksummedData,proto3" json:"checksummed_data,omitempty"`
	// The checksums of the complete object. The client should compute one of
	// these checksums over the downloaded object and compare it against the value
	// provided here.
	ObjectChecksums *ObjectChecksums `protobuf:"bytes,2,opt,name=object_checksums,json=objectChecksums,proto3" json:"object_checksums,omitempty"`
	// If read_offset and or read_limit was specified on the
	// GetObjectMediaRequest, ContentRange will be populated on the first
	// GetObjectMediaResponse message of the read stream.
	ContentRange *ContentRange `protobuf:"bytes,3,opt,name=content_range,json=contentRange,proto3" json:"content_range,omitempty"`
	// Metadata of the object whose media is being returned.
	// Only populated in the first response in the stream.
	Metadata *Object `protobuf:"bytes,4,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *GetObjectMediaResponse) Reset() {
	*x = GetObjectMediaResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetObjectMediaResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetObjectMediaResponse) ProtoMessage() {}

func (x *GetObjectMediaResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetObjectMediaResponse.ProtoReflect.Descriptor instead.
func (*GetObjectMediaResponse) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{36}
}

func (x *GetObjectMediaResponse) GetChecksummedData() *ChecksummedData {
	if x != nil {
		return x.ChecksummedData
	}
	return nil
}

func (x *GetObjectMediaResponse) GetObjectChecksums() *ObjectChecksums {
	if x != nil {
		return x.ObjectChecksums
	}
	return nil
}

func (x *GetObjectMediaResponse) GetContentRange() *ContentRange {
	if x != nil {
		return x.ContentRange
	}
	return nil
}

func (x *GetObjectMediaResponse) GetMetadata() *Object {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// Describes an attempt to insert an object, possibly over multiple requests.
type InsertObjectSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Destination object, including its name and its metadata.
	Resource *Object `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	// Apply a predefined set of access controls to this object.
	PredefinedAcl CommonEnums_PredefinedObjectAcl `protobuf:"varint,2,opt,name=predefined_acl,json=predefinedAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedObjectAcl" json:"predefined_acl,omitempty"`
	// Makes the operation conditional on whether the object's current
	// generation matches the given value. Setting to 0 makes the operation
	// succeed only if there are no live versions of the object.
	IfGenerationMatch *wrappers.Int64Value `protobuf:"bytes,3,opt,name=if_generation_match,json=ifGenerationMatch,proto3" json:"if_generation_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// generation does not match the given value. If no live object exists, the
	// precondition fails. Setting to 0 makes the operation succeed only if
	// there is a live version of the object.
	IfGenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,4,opt,name=if_generation_not_match,json=ifGenerationNotMatch,proto3" json:"if_generation_not_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,5,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,6,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// Set of properties to return. Defaults to `NO_ACL`, unless the
	// object resource specifies the `acl` property, when it defaults
	// to `full`.
	Projection CommonEnums_Projection `protobuf:"varint,7,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
}

func (x *InsertObjectSpec) Reset() {
	*x = InsertObjectSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InsertObjectSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InsertObjectSpec) ProtoMessage() {}

func (x *InsertObjectSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InsertObjectSpec.ProtoReflect.Descriptor instead.
func (*InsertObjectSpec) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{37}
}

func (x *InsertObjectSpec) GetResource() *Object {
	if x != nil {
		return x.Resource
	}
	return nil
}

func (x *InsertObjectSpec) GetPredefinedAcl() CommonEnums_PredefinedObjectAcl {
	if x != nil {
		return x.PredefinedAcl
	}
	return CommonEnums_PREDEFINED_OBJECT_ACL_UNSPECIFIED
}

func (x *InsertObjectSpec) GetIfGenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfGenerationMatch
	}
	return nil
}

func (x *InsertObjectSpec) GetIfGenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfGenerationNotMatch
	}
	return nil
}

func (x *InsertObjectSpec) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationMatch
	}
	return nil
}

func (x *InsertObjectSpec) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationNotMatch
	}
	return nil
}

func (x *InsertObjectSpec) GetProjection() CommonEnums_Projection {
	if x != nil {
		return x.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

// Message for writing an object.
type InsertObjectRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The first message of each stream should set one of the following.
	//
	// Types that are assignable to FirstMessage:
	//	*InsertObjectRequest_UploadId
	//	*InsertObjectRequest_InsertObjectSpec
	FirstMessage isInsertObjectRequest_FirstMessage `protobuf_oneof:"first_message"`
	// Required. The offset from the beginning of the object at which the data should be
	// written.
	//
	// In the first `InsertObjectRequest` of a `InsertObject()` action, it
	// indicates the initial offset for the `Insert()` call. The value **must** be
	// equal to the `committed_size` that a call to `QueryWriteStatus()` would
	// return (0 if this is the first write to the object).
	//
	// On subsequent calls, this value **must** be no larger than the sum of the
	// first `write_offset` and the sizes of all `data` chunks sent previously on
	// this stream.
	//
	// An incorrect value will cause an error.
	WriteOffset int64 `protobuf:"varint,3,opt,name=write_offset,json=writeOffset,proto3" json:"write_offset,omitempty"`
	// A portion of the data for the object.
	//
	// Types that are assignable to Data:
	//	*InsertObjectRequest_ChecksummedData
	//	*InsertObjectRequest_Reference
	Data isInsertObjectRequest_Data `protobuf_oneof:"data"`
	// Checksums for the complete object. If the checksums computed by the service
	// don't match the specifified checksums the call will fail. May only be
	// provided in the first or last request (either with first_message, or
	// finish_write set).
	ObjectChecksums *ObjectChecksums `protobuf:"bytes,6,opt,name=object_checksums,json=objectChecksums,proto3" json:"object_checksums,omitempty"`
	// If `true`, this indicates that the write is complete. Sending any
	// `InsertObjectRequest`s subsequent to one in which `finish_write` is `true`
	// will cause an error.
	// For a non-resumable write (where the upload_id was not set in the first
	// message), it is an error not to set this field in the final message of the
	// stream.
	FinishWrite bool `protobuf:"varint,7,opt,name=finish_write,json=finishWrite,proto3" json:"finish_write,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,8,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,9,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *InsertObjectRequest) Reset() {
	*x = InsertObjectRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InsertObjectRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InsertObjectRequest) ProtoMessage() {}

func (x *InsertObjectRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InsertObjectRequest.ProtoReflect.Descriptor instead.
func (*InsertObjectRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{38}
}

func (m *InsertObjectRequest) GetFirstMessage() isInsertObjectRequest_FirstMessage {
	if m != nil {
		return m.FirstMessage
	}
	return nil
}

func (x *InsertObjectRequest) GetUploadId() string {
	if x, ok := x.GetFirstMessage().(*InsertObjectRequest_UploadId); ok {
		return x.UploadId
	}
	return ""
}

func (x *InsertObjectRequest) GetInsertObjectSpec() *InsertObjectSpec {
	if x, ok := x.GetFirstMessage().(*InsertObjectRequest_InsertObjectSpec); ok {
		return x.InsertObjectSpec
	}
	return nil
}

func (x *InsertObjectRequest) GetWriteOffset() int64 {
	if x != nil {
		return x.WriteOffset
	}
	return 0
}

func (m *InsertObjectRequest) GetData() isInsertObjectRequest_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (x *InsertObjectRequest) GetChecksummedData() *ChecksummedData {
	if x, ok := x.GetData().(*InsertObjectRequest_ChecksummedData); ok {
		return x.ChecksummedData
	}
	return nil
}

func (x *InsertObjectRequest) GetReference() *GetObjectMediaRequest {
	if x, ok := x.GetData().(*InsertObjectRequest_Reference); ok {
		return x.Reference
	}
	return nil
}

func (x *InsertObjectRequest) GetObjectChecksums() *ObjectChecksums {
	if x != nil {
		return x.ObjectChecksums
	}
	return nil
}

func (x *InsertObjectRequest) GetFinishWrite() bool {
	if x != nil {
		return x.FinishWrite
	}
	return false
}

func (x *InsertObjectRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if x != nil {
		return x.CommonObjectRequestParams
	}
	return nil
}

func (x *InsertObjectRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

type isInsertObjectRequest_FirstMessage interface {
	isInsertObjectRequest_FirstMessage()
}

type InsertObjectRequest_UploadId struct {
	// For resumable uploads. This should be the `upload_id` returned from a
	// call to `StartResumableWriteResponse`.
	UploadId string `protobuf:"bytes,1,opt,name=upload_id,json=uploadId,proto3,oneof"`
}

type InsertObjectRequest_InsertObjectSpec struct {
	// For non-resumable uploads. Describes the overall upload, including the
	// destination bucket and object name, preconditions, etc.
	InsertObjectSpec *InsertObjectSpec `protobuf:"bytes,2,opt,name=insert_object_spec,json=insertObjectSpec,proto3,oneof"`
}

func (*InsertObjectRequest_UploadId) isInsertObjectRequest_FirstMessage() {}

func (*InsertObjectRequest_InsertObjectSpec) isInsertObjectRequest_FirstMessage() {}

type isInsertObjectRequest_Data interface {
	isInsertObjectRequest_Data()
}

type InsertObjectRequest_ChecksummedData struct {
	// The data to insert. If a crc32c checksum is provided that doesn't match
	// the checksum computed by the service, the request will fail.
	ChecksummedData *ChecksummedData `protobuf:"bytes,4,opt,name=checksummed_data,json=checksummedData,proto3,oneof"`
}

type InsertObjectRequest_Reference struct {
	// A reference to an existing object. This can be used to support
	// several use cases:
	//   - Writing a sequence of data buffers supports the basic use case of
	//     uploading a complete object, chunk by chunk.
	//   - Writing a sequence of references to existing objects allows an
	//     object to be composed from a collection of objects, which can be
	//     used to support parallel object writes.
	//   - Writing a single reference with a given offset and size can be used
	//     to create an object from a slice of an existing object.
	//   - Writing an object referencing a object slice (created as noted
	//     above) followed by a data buffer followed by another object
	//     slice can be used to support delta upload functionality.
	Reference *GetObjectMediaRequest `protobuf:"bytes,5,opt,name=reference,proto3,oneof"`
}

func (*InsertObjectRequest_ChecksummedData) isInsertObjectRequest_Data() {}

func (*InsertObjectRequest_Reference) isInsertObjectRequest_Data() {}

// Request message for ListObjects.
type ListObjectsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the bucket in which to look for objects.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Returns results in a directory-like mode. `items` will contain
	// only objects whose names, aside from the `prefix`, do not
	// contain `delimiter`. Objects whose names, aside from the
	// `prefix`, contain `delimiter` will have their name,
	// truncated after the `delimiter`, returned in
	// `prefixes`. Duplicate `prefixes` are omitted.
	Delimiter string `protobuf:"bytes,2,opt,name=delimiter,proto3" json:"delimiter,omitempty"`
	// If true, objects that end in exactly one instance of `delimiter`
	// will have their metadata included in `items` in addition to
	// `prefixes`.
	IncludeTrailingDelimiter bool `protobuf:"varint,3,opt,name=include_trailing_delimiter,json=includeTrailingDelimiter,proto3" json:"include_trailing_delimiter,omitempty"`
	// Maximum number of `items` plus `prefixes` to return
	// in a single page of responses. As duplicate `prefixes` are
	// omitted, fewer total results may be returned than requested. The service
	// will use this parameter or 1,000 items, whichever is smaller.
	MaxResults int32 `protobuf:"varint,4,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// A previously-returned page token representing part of the larger set of
	// results to view.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filter results to objects whose names begin with this prefix.
	Prefix string `protobuf:"bytes,6,opt,name=prefix,proto3" json:"prefix,omitempty"`
	// Set of properties to return. Defaults to `NO_ACL`.
	Projection CommonEnums_Projection `protobuf:"varint,7,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// If `true`, lists all versions of an object as distinct results.
	// The default is `false`. For more information, see
	// [Object
	// Versioning](https://cloud.google.com/storage/docs/object-versioning).
	Versions bool `protobuf:"varint,9,opt,name=versions,proto3" json:"versions,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,10,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *ListObjectsRequest) Reset() {
	*x = ListObjectsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListObjectsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListObjectsRequest) ProtoMessage() {}

func (x *ListObjectsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListObjectsRequest.ProtoReflect.Descriptor instead.
func (*ListObjectsRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{39}
}

func (x *ListObjectsRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *ListObjectsRequest) GetDelimiter() string {
	if x != nil {
		return x.Delimiter
	}
	return ""
}

func (x *ListObjectsRequest) GetIncludeTrailingDelimiter() bool {
	if x != nil {
		return x.IncludeTrailingDelimiter
	}
	return false
}

func (x *ListObjectsRequest) GetMaxResults() int32 {
	if x != nil {
		return x.MaxResults
	}
	return 0
}

func (x *ListObjectsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListObjectsRequest) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

func (x *ListObjectsRequest) GetProjection() CommonEnums_Projection {
	if x != nil {
		return x.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (x *ListObjectsRequest) GetVersions() bool {
	if x != nil {
		return x.Versions
	}
	return false
}

func (x *ListObjectsRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request object for `ByteStream.QueryWriteStatus`.
type QueryWriteStatusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the resume token for the object whose write status is being
	// requested.
	UploadId string `protobuf:"bytes,1,opt,name=upload_id,json=uploadId,proto3" json:"upload_id,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,2,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,3,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *QueryWriteStatusRequest) Reset() {
	*x = QueryWriteStatusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryWriteStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryWriteStatusRequest) ProtoMessage() {}

func (x *QueryWriteStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryWriteStatusRequest.ProtoReflect.Descriptor instead.
func (*QueryWriteStatusRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{40}
}

func (x *QueryWriteStatusRequest) GetUploadId() string {
	if x != nil {
		return x.UploadId
	}
	return ""
}

func (x *QueryWriteStatusRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if x != nil {
		return x.CommonObjectRequestParams
	}
	return nil
}

func (x *QueryWriteStatusRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Response object for `ByteStream.QueryWriteStatus`.
type QueryWriteStatusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of bytes that have been processed for the given object.
	CommittedSize int64 `protobuf:"varint,1,opt,name=committed_size,json=committedSize,proto3" json:"committed_size,omitempty"`
	// `complete` is `true` only if the client has sent a `InsertObjectRequest`
	// with `finish_write` set to true, and the server has processed that request.
	Complete bool `protobuf:"varint,2,opt,name=complete,proto3" json:"complete,omitempty"`
}

func (x *QueryWriteStatusResponse) Reset() {
	*x = QueryWriteStatusResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryWriteStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryWriteStatusResponse) ProtoMessage() {}

func (x *QueryWriteStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryWriteStatusResponse.ProtoReflect.Descriptor instead.
func (*QueryWriteStatusResponse) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{41}
}

func (x *QueryWriteStatusResponse) GetCommittedSize() int64 {
	if x != nil {
		return x.CommittedSize
	}
	return 0
}

func (x *QueryWriteStatusResponse) GetComplete() bool {
	if x != nil {
		return x.Complete
	}
	return false
}

// Request message for RewriteObject.
type RewriteObjectRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the bucket in which to store the new object. Overrides the provided
	// object metadata's `bucket` value, if any.
	DestinationBucket string `protobuf:"bytes,1,opt,name=destination_bucket,json=destinationBucket,proto3" json:"destination_bucket,omitempty"`
	// Required. Name of the new object.
	// Required when the object metadata is not otherwise provided. Overrides the
	// object metadata's `name` value, if any.
	DestinationObject string `protobuf:"bytes,2,opt,name=destination_object,json=destinationObject,proto3" json:"destination_object,omitempty"`
	// Resource name of the Cloud KMS key, of the form
	// `projects/my-project/locations/my-location/keyRings/my-kr/cryptoKeys/my-key`,
	// that will be used to encrypt the object. Overrides the object
	// metadata's `kms_key_name` value, if any.
	DestinationKmsKeyName string `protobuf:"bytes,3,opt,name=destination_kms_key_name,json=destinationKmsKeyName,proto3" json:"destination_kms_key_name,omitempty"`
	// Apply a predefined set of access controls to the destination object.
	DestinationPredefinedAcl CommonEnums_PredefinedObjectAcl `protobuf:"varint,4,opt,name=destination_predefined_acl,json=destinationPredefinedAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedObjectAcl" json:"destination_predefined_acl,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// matches the given value. Setting to 0 makes the operation succeed only if
	// there are no live versions of the object.
	IfGenerationMatch *wrappers.Int64Value `protobuf:"bytes,5,opt,name=if_generation_match,json=ifGenerationMatch,proto3" json:"if_generation_match,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// does not match the given value. If no live object exists, the precondition
	// fails. Setting to 0 makes the operation succeed only if there is a live
	// version of the object.
	IfGenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,6,opt,name=if_generation_not_match,json=ifGenerationNotMatch,proto3" json:"if_generation_not_match,omitempty"`
	// Makes the operation conditional on whether the destination object's current
	// metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,7,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Makes the operation conditional on whether the destination object's current
	// metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,8,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// Makes the operation conditional on whether the source object's current
	// generation matches the given value.
	IfSourceGenerationMatch *wrappers.Int64Value `protobuf:"bytes,9,opt,name=if_source_generation_match,json=ifSourceGenerationMatch,proto3" json:"if_source_generation_match,omitempty"`
	// Makes the operation conditional on whether the source object's current
	// generation does not match the given value.
	IfSourceGenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,10,opt,name=if_source_generation_not_match,json=ifSourceGenerationNotMatch,proto3" json:"if_source_generation_not_match,omitempty"`
	// Makes the operation conditional on whether the source object's current
	// metageneration matches the given value.
	IfSourceMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,11,opt,name=if_source_metageneration_match,json=ifSourceMetagenerationMatch,proto3" json:"if_source_metageneration_match,omitempty"`
	// Makes the operation conditional on whether the source object's current
	// metageneration does not match the given value.
	IfSourceMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,12,opt,name=if_source_metageneration_not_match,json=ifSourceMetagenerationNotMatch,proto3" json:"if_source_metageneration_not_match,omitempty"`
	// The maximum number of bytes that will be rewritten per rewrite request.
	// Most callers
	// shouldn't need to specify this parameter - it is primarily in place to
	// support testing. If specified the value must be an integral multiple of
	// 1 MiB (1048576). Also, this only applies to requests where the source and
	// destination span locations and/or storage classes. Finally, this value must
	// not change across rewrite calls else you'll get an error that the
	// `rewriteToken` is invalid.
	MaxBytesRewrittenPerCall int64 `protobuf:"varint,13,opt,name=max_bytes_rewritten_per_call,json=maxBytesRewrittenPerCall,proto3" json:"max_bytes_rewritten_per_call,omitempty"`
	// Set of properties to return. Defaults to `NO_ACL`, unless the
	// object resource specifies the `acl` property, when it defaults
	// to `full`.
	Projection CommonEnums_Projection `protobuf:"varint,14,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// Include this field (from the previous rewrite response) on each rewrite
	// request after the first one, until the rewrite response 'done' flag is
	// true. Calls that provide a rewriteToken can omit all other request fields,
	// but if included those fields must match the values provided in the first
	// rewrite request.
	RewriteToken string `protobuf:"bytes,15,opt,name=rewrite_token,json=rewriteToken,proto3" json:"rewrite_token,omitempty"`
	// Required. Name of the bucket in which to find the source object.
	SourceBucket string `protobuf:"bytes,16,opt,name=source_bucket,json=sourceBucket,proto3" json:"source_bucket,omitempty"`
	// Required. Name of the source object.
	SourceObject string `protobuf:"bytes,17,opt,name=source_object,json=sourceObject,proto3" json:"source_object,omitempty"`
	// If present, selects a specific revision of the source object (as opposed to
	// the latest version, the default).
	SourceGeneration int64 `protobuf:"varint,18,opt,name=source_generation,json=sourceGeneration,proto3" json:"source_generation,omitempty"`
	// Properties of the destination, post-rewrite object.
	Object *Object `protobuf:"bytes,20,opt,name=object,proto3" json:"object,omitempty"`
	// The algorithm used to encrypt the source object, if any.
	CopySourceEncryptionAlgorithm string `protobuf:"bytes,21,opt,name=copy_source_encryption_algorithm,json=copySourceEncryptionAlgorithm,proto3" json:"copy_source_encryption_algorithm,omitempty"`
	// The encryption key used to encrypt the source object, if any.
	CopySourceEncryptionKey string `protobuf:"bytes,22,opt,name=copy_source_encryption_key,json=copySourceEncryptionKey,proto3" json:"copy_source_encryption_key,omitempty"`
	// The SHA-256 hash of the key used to encrypt the source object, if any.
	CopySourceEncryptionKeySha256 string `protobuf:"bytes,23,opt,name=copy_source_encryption_key_sha256,json=copySourceEncryptionKeySha256,proto3" json:"copy_source_encryption_key_sha256,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,24,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,25,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *RewriteObjectRequest) Reset() {
	*x = RewriteObjectRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RewriteObjectRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RewriteObjectRequest) ProtoMessage() {}

func (x *RewriteObjectRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RewriteObjectRequest.ProtoReflect.Descriptor instead.
func (*RewriteObjectRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{42}
}

func (x *RewriteObjectRequest) GetDestinationBucket() string {
	if x != nil {
		return x.DestinationBucket
	}
	return ""
}

func (x *RewriteObjectRequest) GetDestinationObject() string {
	if x != nil {
		return x.DestinationObject
	}
	return ""
}

func (x *RewriteObjectRequest) GetDestinationKmsKeyName() string {
	if x != nil {
		return x.DestinationKmsKeyName
	}
	return ""
}

func (x *RewriteObjectRequest) GetDestinationPredefinedAcl() CommonEnums_PredefinedObjectAcl {
	if x != nil {
		return x.DestinationPredefinedAcl
	}
	return CommonEnums_PREDEFINED_OBJECT_ACL_UNSPECIFIED
}

func (x *RewriteObjectRequest) GetIfGenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfGenerationMatch
	}
	return nil
}

func (x *RewriteObjectRequest) GetIfGenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfGenerationNotMatch
	}
	return nil
}

func (x *RewriteObjectRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationMatch
	}
	return nil
}

func (x *RewriteObjectRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationNotMatch
	}
	return nil
}

func (x *RewriteObjectRequest) GetIfSourceGenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfSourceGenerationMatch
	}
	return nil
}

func (x *RewriteObjectRequest) GetIfSourceGenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfSourceGenerationNotMatch
	}
	return nil
}

func (x *RewriteObjectRequest) GetIfSourceMetagenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfSourceMetagenerationMatch
	}
	return nil
}

func (x *RewriteObjectRequest) GetIfSourceMetagenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfSourceMetagenerationNotMatch
	}
	return nil
}

func (x *RewriteObjectRequest) GetMaxBytesRewrittenPerCall() int64 {
	if x != nil {
		return x.MaxBytesRewrittenPerCall
	}
	return 0
}

func (x *RewriteObjectRequest) GetProjection() CommonEnums_Projection {
	if x != nil {
		return x.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (x *RewriteObjectRequest) GetRewriteToken() string {
	if x != nil {
		return x.RewriteToken
	}
	return ""
}

func (x *RewriteObjectRequest) GetSourceBucket() string {
	if x != nil {
		return x.SourceBucket
	}
	return ""
}

func (x *RewriteObjectRequest) GetSourceObject() string {
	if x != nil {
		return x.SourceObject
	}
	return ""
}

func (x *RewriteObjectRequest) GetSourceGeneration() int64 {
	if x != nil {
		return x.SourceGeneration
	}
	return 0
}

func (x *RewriteObjectRequest) GetObject() *Object {
	if x != nil {
		return x.Object
	}
	return nil
}

func (x *RewriteObjectRequest) GetCopySourceEncryptionAlgorithm() string {
	if x != nil {
		return x.CopySourceEncryptionAlgorithm
	}
	return ""
}

func (x *RewriteObjectRequest) GetCopySourceEncryptionKey() string {
	if x != nil {
		return x.CopySourceEncryptionKey
	}
	return ""
}

func (x *RewriteObjectRequest) GetCopySourceEncryptionKeySha256() string {
	if x != nil {
		return x.CopySourceEncryptionKeySha256
	}
	return ""
}

func (x *RewriteObjectRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if x != nil {
		return x.CommonObjectRequestParams
	}
	return nil
}

func (x *RewriteObjectRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// A rewrite response.
type RewriteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The total bytes written so far, which can be used to provide a waiting user
	// with a progress indicator. This property is always present in the response.
	TotalBytesRewritten int64 `protobuf:"varint,1,opt,name=total_bytes_rewritten,json=totalBytesRewritten,proto3" json:"total_bytes_rewritten,omitempty"`
	// The total size of the object being copied in bytes. This property is always
	// present in the response.
	ObjectSize int64 `protobuf:"varint,2,opt,name=object_size,json=objectSize,proto3" json:"object_size,omitempty"`
	// `true` if the copy is finished; otherwise, `false` if
	// the copy is in progress. This property is always present in the response.
	Done bool `protobuf:"varint,3,opt,name=done,proto3" json:"done,omitempty"`
	// A token to use in subsequent requests to continue copying data. This token
	// is present in the response only when there is more data to copy.
	RewriteToken string `protobuf:"bytes,4,opt,name=rewrite_token,json=rewriteToken,proto3" json:"rewrite_token,omitempty"`
	// A resource containing the metadata for the copied-to object. This property
	// is present in the response only when copying completes.
	Resource *Object `protobuf:"bytes,5,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *RewriteResponse) Reset() {
	*x = RewriteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RewriteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RewriteResponse) ProtoMessage() {}

func (x *RewriteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RewriteResponse.ProtoReflect.Descriptor instead.
func (*RewriteResponse) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{43}
}

func (x *RewriteResponse) GetTotalBytesRewritten() int64 {
	if x != nil {
		return x.TotalBytesRewritten
	}
	return 0
}

func (x *RewriteResponse) GetObjectSize() int64 {
	if x != nil {
		return x.ObjectSize
	}
	return 0
}

func (x *RewriteResponse) GetDone() bool {
	if x != nil {
		return x.Done
	}
	return false
}

func (x *RewriteResponse) GetRewriteToken() string {
	if x != nil {
		return x.RewriteToken
	}
	return ""
}

func (x *RewriteResponse) GetResource() *Object {
	if x != nil {
		return x.Resource
	}
	return nil
}

// Request message StartResumableWrite.
type StartResumableWriteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The destination bucket, object, and metadata, as well as any preconditions.
	InsertObjectSpec *InsertObjectSpec `protobuf:"bytes,1,opt,name=insert_object_spec,json=insertObjectSpec,proto3" json:"insert_object_spec,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,3,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,4,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *StartResumableWriteRequest) Reset() {
	*x = StartResumableWriteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartResumableWriteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartResumableWriteRequest) ProtoMessage() {}

func (x *StartResumableWriteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartResumableWriteRequest.ProtoReflect.Descriptor instead.
func (*StartResumableWriteRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{44}
}

func (x *StartResumableWriteRequest) GetInsertObjectSpec() *InsertObjectSpec {
	if x != nil {
		return x.InsertObjectSpec
	}
	return nil
}

func (x *StartResumableWriteRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if x != nil {
		return x.CommonObjectRequestParams
	}
	return nil
}

func (x *StartResumableWriteRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Response object for ByteStream.StartResumableWrite.
type StartResumableWriteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The upload_id of the newly started resumable write operation. This
	// value should be copied into the `InsertObjectRequest.upload_id` field.
	UploadId string `protobuf:"bytes,1,opt,name=upload_id,json=uploadId,proto3" json:"upload_id,omitempty"`
}

func (x *StartResumableWriteResponse) Reset() {
	*x = StartResumableWriteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartResumableWriteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartResumableWriteResponse) ProtoMessage() {}

func (x *StartResumableWriteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartResumableWriteResponse.ProtoReflect.Descriptor instead.
func (*StartResumableWriteResponse) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{45}
}

func (x *StartResumableWriteResponse) GetUploadId() string {
	if x != nil {
		return x.UploadId
	}
	return ""
}

// Request message for PatchObject.
type PatchObjectRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the bucket in which the object resides.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. Name of the object.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// If present, selects a specific revision of this object (as opposed to the
	// latest version, the default).
	Generation int64 `protobuf:"varint,3,opt,name=generation,proto3" json:"generation,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// matches the given value. Setting to 0 makes the operation succeed only if
	// there are no live versions of the object.
	IfGenerationMatch *wrappers.Int64Value `protobuf:"bytes,4,opt,name=if_generation_match,json=ifGenerationMatch,proto3" json:"if_generation_match,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// does not match the given value. If no live object exists, the precondition
	// fails. Setting to 0 makes the operation succeed only if there is a live
	// version of the object.
	IfGenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,5,opt,name=if_generation_not_match,json=ifGenerationNotMatch,proto3" json:"if_generation_not_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,6,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,7,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// Apply a predefined set of access controls to this object.
	PredefinedAcl CommonEnums_PredefinedObjectAcl `protobuf:"varint,8,opt,name=predefined_acl,json=predefinedAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedObjectAcl" json:"predefined_acl,omitempty"`
	// Set of properties to return. Defaults to `FULL`.
	Projection CommonEnums_Projection `protobuf:"varint,9,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// The Object metadata for updating.
	Metadata *Object `protobuf:"bytes,11,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// List of fields to be updated.
	//
	// To specify ALL fields, equivalent to the JSON API's "update" function,
	// specify a single field with the value `*`. Note: not recommended. If a new
	// field is introduced at a later time, an older client updating with the `*`
	// may accidentally reset the new field's value.
	//
	// Not specifying any fields is an error.
	// Not specifying a field while setting that field to a non-default value is
	// an error.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,12,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,13,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,14,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *PatchObjectRequest) Reset() {
	*x = PatchObjectRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchObjectRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchObjectRequest) ProtoMessage() {}

func (x *PatchObjectRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchObjectRequest.ProtoReflect.Descriptor instead.
func (*PatchObjectRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{46}
}

func (x *PatchObjectRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *PatchObjectRequest) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

func (x *PatchObjectRequest) GetGeneration() int64 {
	if x != nil {
		return x.Generation
	}
	return 0
}

func (x *PatchObjectRequest) GetIfGenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfGenerationMatch
	}
	return nil
}

func (x *PatchObjectRequest) GetIfGenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfGenerationNotMatch
	}
	return nil
}

func (x *PatchObjectRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationMatch
	}
	return nil
}

func (x *PatchObjectRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationNotMatch
	}
	return nil
}

func (x *PatchObjectRequest) GetPredefinedAcl() CommonEnums_PredefinedObjectAcl {
	if x != nil {
		return x.PredefinedAcl
	}
	return CommonEnums_PREDEFINED_OBJECT_ACL_UNSPECIFIED
}

func (x *PatchObjectRequest) GetProjection() CommonEnums_Projection {
	if x != nil {
		return x.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (x *PatchObjectRequest) GetMetadata() *Object {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *PatchObjectRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *PatchObjectRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if x != nil {
		return x.CommonObjectRequestParams
	}
	return nil
}

func (x *PatchObjectRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for UpdateObject.
type UpdateObjectRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the bucket in which the object resides.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Required. Name of the object.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// If present, selects a specific revision of this object (as opposed to the
	// latest version, the default).
	Generation int64 `protobuf:"varint,3,opt,name=generation,proto3" json:"generation,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// matches the given value. Setting to 0 makes the operation succeed only if
	// there are no live versions of the object.
	IfGenerationMatch *wrappers.Int64Value `protobuf:"bytes,4,opt,name=if_generation_match,json=ifGenerationMatch,proto3" json:"if_generation_match,omitempty"`
	// Makes the operation conditional on whether the object's current generation
	// does not match the given value. If no live object exists, the precondition
	// fails. Setting to 0 makes the operation succeed only if there is a live
	// version of the object.
	IfGenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,5,opt,name=if_generation_not_match,json=ifGenerationNotMatch,proto3" json:"if_generation_not_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration matches the given value.
	IfMetagenerationMatch *wrappers.Int64Value `protobuf:"bytes,6,opt,name=if_metageneration_match,json=ifMetagenerationMatch,proto3" json:"if_metageneration_match,omitempty"`
	// Makes the operation conditional on whether the object's current
	// metageneration does not match the given value.
	IfMetagenerationNotMatch *wrappers.Int64Value `protobuf:"bytes,7,opt,name=if_metageneration_not_match,json=ifMetagenerationNotMatch,proto3" json:"if_metageneration_not_match,omitempty"`
	// Apply a predefined set of access controls to this object.
	PredefinedAcl CommonEnums_PredefinedObjectAcl `protobuf:"varint,8,opt,name=predefined_acl,json=predefinedAcl,proto3,enum=google.storage.v1.CommonEnums_PredefinedObjectAcl" json:"predefined_acl,omitempty"`
	// Set of properties to return. Defaults to `FULL`.
	Projection CommonEnums_Projection `protobuf:"varint,9,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// The Object metadata for updating.
	Metadata *Object `protobuf:"bytes,11,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// A set of parameters common to Storage API requests concerning an object.
	CommonObjectRequestParams *CommonObjectRequestParams `protobuf:"bytes,12,opt,name=common_object_request_params,json=commonObjectRequestParams,proto3" json:"common_object_request_params,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,13,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *UpdateObjectRequest) Reset() {
	*x = UpdateObjectRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateObjectRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateObjectRequest) ProtoMessage() {}

func (x *UpdateObjectRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateObjectRequest.ProtoReflect.Descriptor instead.
func (*UpdateObjectRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{47}
}

func (x *UpdateObjectRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *UpdateObjectRequest) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

func (x *UpdateObjectRequest) GetGeneration() int64 {
	if x != nil {
		return x.Generation
	}
	return 0
}

func (x *UpdateObjectRequest) GetIfGenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfGenerationMatch
	}
	return nil
}

func (x *UpdateObjectRequest) GetIfGenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfGenerationNotMatch
	}
	return nil
}

func (x *UpdateObjectRequest) GetIfMetagenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationMatch
	}
	return nil
}

func (x *UpdateObjectRequest) GetIfMetagenerationNotMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfMetagenerationNotMatch
	}
	return nil
}

func (x *UpdateObjectRequest) GetPredefinedAcl() CommonEnums_PredefinedObjectAcl {
	if x != nil {
		return x.PredefinedAcl
	}
	return CommonEnums_PREDEFINED_OBJECT_ACL_UNSPECIFIED
}

func (x *UpdateObjectRequest) GetProjection() CommonEnums_Projection {
	if x != nil {
		return x.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (x *UpdateObjectRequest) GetMetadata() *Object {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *UpdateObjectRequest) GetCommonObjectRequestParams() *CommonObjectRequestParams {
	if x != nil {
		return x.CommonObjectRequestParams
	}
	return nil
}

func (x *UpdateObjectRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for WatchAllObjects.
type WatchAllObjectsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the bucket in which to look for objects.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// If `true`, lists all versions of an object as distinct results.
	// The default is `false`. For more information, see
	// [Object
	// Versioning](https://cloud.google.com/storage/docs/object-versioning).
	Versions bool `protobuf:"varint,2,opt,name=versions,proto3" json:"versions,omitempty"`
	// Returns results in a directory-like mode. `items` will contain
	// only objects whose names, aside from the `prefix`, do not
	// contain `delimiter`. Objects whose names, aside from the
	// `prefix`, contain `delimiter` will have their name,
	// truncated after the `delimiter`, returned in
	// `prefixes`. Duplicate `prefixes` are omitted.
	Delimiter string `protobuf:"bytes,3,opt,name=delimiter,proto3" json:"delimiter,omitempty"`
	// Maximum number of `items` plus `prefixes` to return
	// in a single page of responses. As duplicate `prefixes` are
	// omitted, fewer total results may be returned than requested. The service
	// will use this parameter or 1,000 items, whichever is smaller.
	MaxResults int32 `protobuf:"varint,4,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// Filter results to objects whose names begin with this prefix.
	Prefix string `protobuf:"bytes,5,opt,name=prefix,proto3" json:"prefix,omitempty"`
	// If true, objects that end in exactly one instance of `delimiter`
	// will have their metadata included in `items` in addition to
	// `prefixes`.
	IncludeTrailingDelimiter bool `protobuf:"varint,6,opt,name=include_trailing_delimiter,json=includeTrailingDelimiter,proto3" json:"include_trailing_delimiter,omitempty"`
	// A previously-returned page token representing part of the larger set of
	// results to view.
	PageToken string `protobuf:"bytes,7,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Set of properties to return. Defaults to `NO_ACL`.
	Projection CommonEnums_Projection `protobuf:"varint,8,opt,name=projection,proto3,enum=google.storage.v1.CommonEnums_Projection" json:"projection,omitempty"`
	// Properties of the channel to be inserted.
	Channel *Channel `protobuf:"bytes,10,opt,name=channel,proto3" json:"channel,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,11,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *WatchAllObjectsRequest) Reset() {
	*x = WatchAllObjectsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WatchAllObjectsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WatchAllObjectsRequest) ProtoMessage() {}

func (x *WatchAllObjectsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WatchAllObjectsRequest.ProtoReflect.Descriptor instead.
func (*WatchAllObjectsRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{48}
}

func (x *WatchAllObjectsRequest) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *WatchAllObjectsRequest) GetVersions() bool {
	if x != nil {
		return x.Versions
	}
	return false
}

func (x *WatchAllObjectsRequest) GetDelimiter() string {
	if x != nil {
		return x.Delimiter
	}
	return ""
}

func (x *WatchAllObjectsRequest) GetMaxResults() int32 {
	if x != nil {
		return x.MaxResults
	}
	return 0
}

func (x *WatchAllObjectsRequest) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

func (x *WatchAllObjectsRequest) GetIncludeTrailingDelimiter() bool {
	if x != nil {
		return x.IncludeTrailingDelimiter
	}
	return false
}

func (x *WatchAllObjectsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *WatchAllObjectsRequest) GetProjection() CommonEnums_Projection {
	if x != nil {
		return x.Projection
	}
	return CommonEnums_PROJECTION_UNSPECIFIED
}

func (x *WatchAllObjectsRequest) GetChannel() *Channel {
	if x != nil {
		return x.Channel
	}
	return nil
}

func (x *WatchAllObjectsRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request message for GetProjectServiceAccount.
type GetProjectServiceAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Project ID.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,3,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *GetProjectServiceAccountRequest) Reset() {
	*x = GetProjectServiceAccountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetProjectServiceAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProjectServiceAccountRequest) ProtoMessage() {}

func (x *GetProjectServiceAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProjectServiceAccountRequest.ProtoReflect.Descriptor instead.
func (*GetProjectServiceAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{49}
}

func (x *GetProjectServiceAccountRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *GetProjectServiceAccountRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

type CreateHmacKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project that the HMAC-owning service account lives in.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The service account to create the HMAC for.
	ServiceAccountEmail string `protobuf:"bytes,2,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,3,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *CreateHmacKeyRequest) Reset() {
	*x = CreateHmacKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateHmacKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateHmacKeyRequest) ProtoMessage() {}

func (x *CreateHmacKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateHmacKeyRequest.ProtoReflect.Descriptor instead.
func (*CreateHmacKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{50}
}

func (x *CreateHmacKeyRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *CreateHmacKeyRequest) GetServiceAccountEmail() string {
	if x != nil {
		return x.ServiceAccountEmail
	}
	return ""
}

func (x *CreateHmacKeyRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Create hmac response.  The only time the secret for an HMAC will be returned.
type CreateHmacKeyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key metadata.
	Metadata *HmacKeyMetadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// HMAC key secret material.
	Secret string `protobuf:"bytes,2,opt,name=secret,proto3" json:"secret,omitempty"`
}

func (x *CreateHmacKeyResponse) Reset() {
	*x = CreateHmacKeyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateHmacKeyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateHmacKeyResponse) ProtoMessage() {}

func (x *CreateHmacKeyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateHmacKeyResponse.ProtoReflect.Descriptor instead.
func (*CreateHmacKeyResponse) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{51}
}

func (x *CreateHmacKeyResponse) GetMetadata() *HmacKeyMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *CreateHmacKeyResponse) GetSecret() string {
	if x != nil {
		return x.Secret
	}
	return ""
}

// Request object to delete a given HMAC key.
type DeleteHmacKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The identifying key for the HMAC to delete.
	AccessId string `protobuf:"bytes,1,opt,name=access_id,json=accessId,proto3" json:"access_id,omitempty"`
	// Required. The project id the HMAC key lies in.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,3,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *DeleteHmacKeyRequest) Reset() {
	*x = DeleteHmacKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteHmacKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteHmacKeyRequest) ProtoMessage() {}

func (x *DeleteHmacKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteHmacKeyRequest.ProtoReflect.Descriptor instead.
func (*DeleteHmacKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{52}
}

func (x *DeleteHmacKeyRequest) GetAccessId() string {
	if x != nil {
		return x.AccessId
	}
	return ""
}

func (x *DeleteHmacKeyRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *DeleteHmacKeyRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request object to get metadata on a given HMAC key.
type GetHmacKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The identifying key for the HMAC to delete.
	AccessId string `protobuf:"bytes,1,opt,name=access_id,json=accessId,proto3" json:"access_id,omitempty"`
	// Required. The project id the HMAC key lies in.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,3,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *GetHmacKeyRequest) Reset() {
	*x = GetHmacKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetHmacKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetHmacKeyRequest) ProtoMessage() {}

func (x *GetHmacKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetHmacKeyRequest.ProtoReflect.Descriptor instead.
func (*GetHmacKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{53}
}

func (x *GetHmacKeyRequest) GetAccessId() string {
	if x != nil {
		return x.AccessId
	}
	return ""
}

func (x *GetHmacKeyRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *GetHmacKeyRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Request to fetch a list of HMAC keys under a given project.
type ListHmacKeysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project id to list HMAC keys for.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// An optional filter to only return HMAC keys for one service account.
	ServiceAccountEmail string `protobuf:"bytes,2,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// An optional bool to return deleted keys that have not been wiped out yet.
	ShowDeletedKeys bool `protobuf:"varint,3,opt,name=show_deleted_keys,json=showDeletedKeys,proto3" json:"show_deleted_keys,omitempty"`
	// The maximum number of keys to return.
	MaxResults int32 `protobuf:"varint,4,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// A previously returned token from ListHmacKeysResponse to get the next page.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,6,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *ListHmacKeysRequest) Reset() {
	*x = ListHmacKeysRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListHmacKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListHmacKeysRequest) ProtoMessage() {}

func (x *ListHmacKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListHmacKeysRequest.ProtoReflect.Descriptor instead.
func (*ListHmacKeysRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{54}
}

func (x *ListHmacKeysRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ListHmacKeysRequest) GetServiceAccountEmail() string {
	if x != nil {
		return x.ServiceAccountEmail
	}
	return ""
}

func (x *ListHmacKeysRequest) GetShowDeletedKeys() bool {
	if x != nil {
		return x.ShowDeletedKeys
	}
	return false
}

func (x *ListHmacKeysRequest) GetMaxResults() int32 {
	if x != nil {
		return x.MaxResults
	}
	return 0
}

func (x *ListHmacKeysRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListHmacKeysRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Hmac key list response with next page information.
type ListHmacKeysResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The continuation token, used to page through large result sets. Provide
	// this value in a subsequent request to return the next page of results.
	NextPageToken string `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The list of items.
	Items []*HmacKeyMetadata `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty"`
}

func (x *ListHmacKeysResponse) Reset() {
	*x = ListHmacKeysResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListHmacKeysResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListHmacKeysResponse) ProtoMessage() {}

func (x *ListHmacKeysResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListHmacKeysResponse.ProtoReflect.Descriptor instead.
func (*ListHmacKeysResponse) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{55}
}

func (x *ListHmacKeysResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListHmacKeysResponse) GetItems() []*HmacKeyMetadata {
	if x != nil {
		return x.Items
	}
	return nil
}

// Request object to update an HMAC key state.
type UpdateHmacKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The id of the HMAC key.
	AccessId string `protobuf:"bytes,1,opt,name=access_id,json=accessId,proto3" json:"access_id,omitempty"`
	// Required. The project id the HMAC's service account lies in.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The service account owner of the HMAC key.
	Metadata *HmacKeyMetadata `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,5,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *UpdateHmacKeyRequest) Reset() {
	*x = UpdateHmacKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateHmacKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateHmacKeyRequest) ProtoMessage() {}

func (x *UpdateHmacKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateHmacKeyRequest.ProtoReflect.Descriptor instead.
func (*UpdateHmacKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{56}
}

func (x *UpdateHmacKeyRequest) GetAccessId() string {
	if x != nil {
		return x.AccessId
	}
	return ""
}

func (x *UpdateHmacKeyRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *UpdateHmacKeyRequest) GetMetadata() *HmacKeyMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *UpdateHmacKeyRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// A wrapper around the IAM get policy request to support our
// common_request_params.
type GetIamPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request sent to IAM.
	IamRequest *v1.GetIamPolicyRequest `protobuf:"bytes,1,opt,name=iam_request,json=iamRequest,proto3" json:"iam_request,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,2,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *GetIamPolicyRequest) Reset() {
	*x = GetIamPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetIamPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIamPolicyRequest) ProtoMessage() {}

func (x *GetIamPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIamPolicyRequest.ProtoReflect.Descriptor instead.
func (*GetIamPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{57}
}

func (x *GetIamPolicyRequest) GetIamRequest() *v1.GetIamPolicyRequest {
	if x != nil {
		return x.IamRequest
	}
	return nil
}

func (x *GetIamPolicyRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// A wrapper around the IAM set policy request to support our
// common_request_params.
type SetIamPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request sent to IAM.
	IamRequest *v1.SetIamPolicyRequest `protobuf:"bytes,1,opt,name=iam_request,json=iamRequest,proto3" json:"iam_request,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,2,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *SetIamPolicyRequest) Reset() {
	*x = SetIamPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetIamPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetIamPolicyRequest) ProtoMessage() {}

func (x *SetIamPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetIamPolicyRequest.ProtoReflect.Descriptor instead.
func (*SetIamPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{58}
}

func (x *SetIamPolicyRequest) GetIamRequest() *v1.SetIamPolicyRequest {
	if x != nil {
		return x.IamRequest
	}
	return nil
}

func (x *SetIamPolicyRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// A wrapper around the IAM test iam permissions request to support our
// common_request_params.
type TestIamPermissionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request sent to IAM.
	IamRequest *v1.TestIamPermissionsRequest `protobuf:"bytes,1,opt,name=iam_request,json=iamRequest,proto3" json:"iam_request,omitempty"`
	// A set of parameters common to all Storage API requests.
	CommonRequestParams *CommonRequestParams `protobuf:"bytes,2,opt,name=common_request_params,json=commonRequestParams,proto3" json:"common_request_params,omitempty"`
}

func (x *TestIamPermissionsRequest) Reset() {
	*x = TestIamPermissionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestIamPermissionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestIamPermissionsRequest) ProtoMessage() {}

func (x *TestIamPermissionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestIamPermissionsRequest.ProtoReflect.Descriptor instead.
func (*TestIamPermissionsRequest) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{59}
}

func (x *TestIamPermissionsRequest) GetIamRequest() *v1.TestIamPermissionsRequest {
	if x != nil {
		return x.IamRequest
	}
	return nil
}

func (x *TestIamPermissionsRequest) GetCommonRequestParams() *CommonRequestParams {
	if x != nil {
		return x.CommonRequestParams
	}
	return nil
}

// Parameters that can be passed to any object request.
type CommonObjectRequestParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Encryption algorithm used with Customer-Supplied Encryption Keys feature.
	EncryptionAlgorithm string `protobuf:"bytes,1,opt,name=encryption_algorithm,json=encryptionAlgorithm,proto3" json:"encryption_algorithm,omitempty"`
	// Encryption key used with Customer-Supplied Encryption Keys feature.
	EncryptionKey string `protobuf:"bytes,2,opt,name=encryption_key,json=encryptionKey,proto3" json:"encryption_key,omitempty"`
	// SHA256 hash of encryption key used with Customer-Supplied Encryption Keys
	// feature.
	EncryptionKeySha256 string `protobuf:"bytes,3,opt,name=encryption_key_sha256,json=encryptionKeySha256,proto3" json:"encryption_key_sha256,omitempty"`
}

func (x *CommonObjectRequestParams) Reset() {
	*x = CommonObjectRequestParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommonObjectRequestParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommonObjectRequestParams) ProtoMessage() {}

func (x *CommonObjectRequestParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommonObjectRequestParams.ProtoReflect.Descriptor instead.
func (*CommonObjectRequestParams) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{60}
}

func (x *CommonObjectRequestParams) GetEncryptionAlgorithm() string {
	if x != nil {
		return x.EncryptionAlgorithm
	}
	return ""
}

func (x *CommonObjectRequestParams) GetEncryptionKey() string {
	if x != nil {
		return x.EncryptionKey
	}
	return ""
}

func (x *CommonObjectRequestParams) GetEncryptionKeySha256() string {
	if x != nil {
		return x.EncryptionKeySha256
	}
	return ""
}

// Parameters that can be passed to any request.
type CommonRequestParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Required when using buckets with Requestor Pays feature enabled.
	UserProject string `protobuf:"bytes,1,opt,name=user_project,json=userProject,proto3" json:"user_project,omitempty"`
	// Lets you enforce per-user quotas from a server-side application even in
	// cases when the user's IP address is unknown. This can occur, for example,
	// with applications that run cron jobs on App Engine on a user's behalf.
	// You can choose any arbitrary string that uniquely identifies a user, but it
	// is limited to 40 characters.
	// Overrides user_ip if both are provided.
	QuotaUser string `protobuf:"bytes,2,opt,name=quota_user,json=quotaUser,proto3" json:"quota_user,omitempty"`
	// Subset of fields to include in the response.
	Fields *field_mask.FieldMask `protobuf:"bytes,4,opt,name=fields,proto3" json:"fields,omitempty"`
}

func (x *CommonRequestParams) Reset() {
	*x = CommonRequestParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommonRequestParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommonRequestParams) ProtoMessage() {}

func (x *CommonRequestParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommonRequestParams.ProtoReflect.Descriptor instead.
func (*CommonRequestParams) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{61}
}

func (x *CommonRequestParams) GetUserProject() string {
	if x != nil {
		return x.UserProject
	}
	return ""
}

func (x *CommonRequestParams) GetQuotaUser() string {
	if x != nil {
		return x.QuotaUser
	}
	return ""
}

func (x *CommonRequestParams) GetFields() *field_mask.FieldMask {
	if x != nil {
		return x.Fields
	}
	return nil
}

// Shared constants.
type ServiceConstants struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ServiceConstants) Reset() {
	*x = ServiceConstants{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceConstants) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceConstants) ProtoMessage() {}

func (x *ServiceConstants) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceConstants.ProtoReflect.Descriptor instead.
func (*ServiceConstants) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{62}
}

// Description of a source object for a composition request.
type ComposeObjectRequest_SourceObjects struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source object's name. All source objects must reside in the same
	// bucket.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The generation of this object to use as the source.
	Generation int64 `protobuf:"varint,2,opt,name=generation,proto3" json:"generation,omitempty"`
	// Conditions that must be met for this operation to execute.
	ObjectPreconditions *ComposeObjectRequest_SourceObjects_ObjectPreconditions `protobuf:"bytes,3,opt,name=object_preconditions,json=objectPreconditions,proto3" json:"object_preconditions,omitempty"`
}

func (x *ComposeObjectRequest_SourceObjects) Reset() {
	*x = ComposeObjectRequest_SourceObjects{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComposeObjectRequest_SourceObjects) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComposeObjectRequest_SourceObjects) ProtoMessage() {}

func (x *ComposeObjectRequest_SourceObjects) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComposeObjectRequest_SourceObjects.ProtoReflect.Descriptor instead.
func (*ComposeObjectRequest_SourceObjects) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{31, 0}
}

func (x *ComposeObjectRequest_SourceObjects) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ComposeObjectRequest_SourceObjects) GetGeneration() int64 {
	if x != nil {
		return x.Generation
	}
	return 0
}

func (x *ComposeObjectRequest_SourceObjects) GetObjectPreconditions() *ComposeObjectRequest_SourceObjects_ObjectPreconditions {
	if x != nil {
		return x.ObjectPreconditions
	}
	return nil
}

// Preconditions for a source object of a composition request.
type ComposeObjectRequest_SourceObjects_ObjectPreconditions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Only perform the composition if the generation of the source object
	// that would be used matches this value.  If this value and a generation
	// are both specified, they must be the same value or the call will fail.
	IfGenerationMatch *wrappers.Int64Value `protobuf:"bytes,1,opt,name=if_generation_match,json=ifGenerationMatch,proto3" json:"if_generation_match,omitempty"`
}

func (x *ComposeObjectRequest_SourceObjects_ObjectPreconditions) Reset() {
	*x = ComposeObjectRequest_SourceObjects_ObjectPreconditions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComposeObjectRequest_SourceObjects_ObjectPreconditions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComposeObjectRequest_SourceObjects_ObjectPreconditions) ProtoMessage() {}

func (x *ComposeObjectRequest_SourceObjects_ObjectPreconditions) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComposeObjectRequest_SourceObjects_ObjectPreconditions.ProtoReflect.Descriptor instead.
func (*ComposeObjectRequest_SourceObjects_ObjectPreconditions) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_proto_rawDescGZIP(), []int{31, 0, 0}
}

func (x *ComposeObjectRequest_SourceObjects_ObjectPreconditions) GetIfGenerationMatch() *wrappers.Int64Value {
	if x != nil {
		return x.IfGenerationMatch
	}
	return nil
}

var File_google_storage_v1_storage_proto protoreflect.FileDescriptor

var file_google_storage_v1_storage_proto_rawDesc = []byte{
	0x0a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2f, 0x76, 0x31, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x11, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61,
	0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61,
	0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2f, 0x76, 0x31, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb8, 0x01, 0x0a, 0x20, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22,
	0xb5, 0x01, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x1b,
	0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x5a, 0x0a, 0x15, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xf7, 0x01, 0x0a, 0x20, 0x49, 0x6e, 0x73, 0x65,
	0x72, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x5a, 0x0a, 0x15, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x52, 0x13, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x22, 0x9a, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xd0,
	0x02, 0x0a, 0x1f, 0x50, 0x61, 0x74, 0x63, 0x68, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12,
	0x1b, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x5a, 0x0a, 0x15,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x52, 0x13, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x22, 0x94, 0x02, 0x0a, 0x20, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x12, 0x5a, 0x0a, 0x15, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x13, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x5a, 0x0a, 0x15,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xbf, 0x02, 0x0a, 0x13, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x53, 0x0a,
	0x17, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x69, 0x66, 0x4d,
	0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x12, 0x5a, 0x0a, 0x1b, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x18, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x5a,
	0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0x87, 0x03, 0x0a, 0x10, 0x47,
	0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x53, 0x0a, 0x17,
	0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x69, 0x66, 0x4d, 0x65,
	0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x12, 0x5a, 0x0a, 0x1b, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x18, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x49, 0x0a,
	0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d,
	0x73, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52,
	0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x22, 0xe0, 0x03, 0x0a, 0x13, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x59, 0x0a, 0x0e,
	0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45,
	0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x63, 0x6c, 0x52, 0x0d, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66,
	0x69, 0x6e, 0x65, 0x64, 0x41, 0x63, 0x6c, 0x12, 0x75, 0x0a, 0x1d, 0x70, 0x72, 0x65, 0x64, 0x65,
	0x66, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x63, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50,
	0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41,
	0x63, 0x6c, 0x52, 0x1a, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x44, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x6c, 0x12, 0x1d,
	0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x49, 0x0a,
	0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d,
	0x73, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x5a, 0x0a, 0x15, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0x8e, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x5a, 0x0a, 0x15,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xb2, 0x02, 0x0a, 0x12, 0x4c, 0x69, 0x73,
	0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1f, 0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x16, 0x0a, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x1d, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x49, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xcd, 0x01,
	0x0a, 0x1a, 0x4c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x36, 0x0a, 0x17, 0x69, 0x66, 0x5f,
	0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x69, 0x66, 0x4d, 0x65,
	0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xcf, 0x05,
	0x0a, 0x12, 0x50, 0x61, 0x74, 0x63, 0x68, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x12, 0x53, 0x0a, 0x17, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x15, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x5a, 0x0a, 0x1b, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x18, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x12, 0x59, 0x0a, 0x0e, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64,
	0x5f, 0x61, 0x63, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x65,
	0x66, 0x69, 0x6e, 0x65, 0x64, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x63, 0x6c, 0x52, 0x0d,
	0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x41, 0x63, 0x6c, 0x12, 0x75, 0x0a,
	0x1d, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x63, 0x6c, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45,
	0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x6c, 0x52, 0x1a, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66,
	0x69, 0x6e, 0x65, 0x64, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x41, 0x63, 0x6c, 0x12, 0x49, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x35, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x08, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22,
	0x93, 0x05, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x12, 0x53, 0x0a, 0x17, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x15, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x5a, 0x0a, 0x1b, 0x69, 0x66, 0x5f,
	0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e,
	0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x18, 0x69, 0x66, 0x4d,
	0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x59, 0x0a, 0x0e, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69,
	0x6e, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72,
	0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x63,
	0x6c, 0x52, 0x0d, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x41, 0x63, 0x6c,
	0x12, 0x75, 0x0a, 0x1d, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x63,
	0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e,
	0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x6c, 0x52, 0x1a, 0x70, 0x72, 0x65,
	0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x6c, 0x12, 0x49, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52,
	0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xa6, 0x01, 0x0a, 0x12, 0x53, 0x74, 0x6f, 0x70, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x34, 0x0a, 0x07,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xbf,
	0x01, 0x0a, 0x27, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x22, 0xbc, 0x01, 0x0a, 0x24, 0x47, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22,
	0xfe, 0x01, 0x0a, 0x27, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x5a, 0x0a, 0x15, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52,
	0x13, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x22, 0xd2, 0x02, 0x0a, 0x26, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x53, 0x0a, 0x17, 0x69, 0x66, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x5a, 0x0a,
	0x1b, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x18, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xd7, 0x02, 0x0a, 0x26, 0x50, 0x61, 0x74, 0x63, 0x68, 0x44,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x1b, 0x0a,
	0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x5a, 0x0a, 0x15, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x52, 0x13, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22,
	0x9b, 0x02, 0x0a, 0x27, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x5a, 0x0a, 0x15, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x13, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xbd, 0x01,
	0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x27, 0x0a, 0x0c, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xba, 0x01,
	0x0a, 0x16, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x27, 0x0a, 0x0c, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0c, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a,
	0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xd9, 0x01, 0x0a, 0x19, 0x49,
	0x6e, 0x73, 0x65, 0x72, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x43, 0x0a, 0x0c, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x6e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0x93, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x4e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xf5, 0x01, 0x0a,
	0x20, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x1b,
	0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x1b, 0x0a, 0x06, 0x6f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52,
	0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x22, 0xf2, 0x01, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x12, 0x1b, 0x0a, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1e, 0x0a,
	0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a,
	0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xb4, 0x02, 0x0a, 0x20, 0x49, 0x6e,
	0x73, 0x65, 0x72, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b,
	0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x6f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a, 0x15, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52,
	0x13, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x22, 0xd7, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x12, 0x1b, 0x0a, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1e,
	0x0a, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a,
	0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0x8d, 0x03, 0x0a, 0x1f, 0x50,
	0x61, 0x74, 0x63, 0x68, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b,
	0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x1b, 0x0a, 0x06, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a, 0x15, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x13, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x3b, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x8e, 0x03, 0x0a, 0x20, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x1b, 0x0a, 0x06,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x1b, 0x0a, 0x06, 0x6f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a, 0x15, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x13, 0x6f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x3b,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xc2, 0x08, 0x0a, 0x14,
	0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x32, 0x0a, 0x12, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x32, 0x0a, 0x12, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x70, 0x0a, 0x1a,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x65, 0x64,
	0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d, 0x73,
	0x2e, 0x50, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x41, 0x63, 0x6c, 0x52, 0x18, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x41, 0x63, 0x6c, 0x12, 0x3b,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5c, 0x0a, 0x0e, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x0c, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x52, 0x0d, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x12, 0x4b, 0x0a, 0x13, 0x69, 0x66, 0x5f,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x11, 0x69, 0x66, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x53, 0x0a, 0x17, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x20, 0x0a, 0x0c, 0x6b,
	0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x6d, 0x0a,
	0x1c, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x52, 0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x5a, 0x0a, 0x15,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x1a, 0xa5, 0x02, 0x0a, 0x0d, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1e,
	0x0a, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7c,
	0x0a, 0x14, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x70, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x50, 0x72, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x13, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x50,
	0x72, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x62, 0x0a, 0x13,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x50, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x4b, 0x0a, 0x13, 0x69, 0x66, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x69,
	0x66, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x22, 0xd2, 0x0b, 0x0a, 0x11, 0x43, 0x6f, 0x70, 0x79, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x32, 0x0a, 0x12, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x32, 0x0a, 0x12, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x70,
	0x0a, 0x1a, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72,
	0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x6c, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x75,
	0x6d, 0x73, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x41, 0x63, 0x6c, 0x52, 0x18, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x41, 0x63, 0x6c,
	0x12, 0x4b, 0x0a, 0x13, 0x69, 0x66, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x69, 0x66, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x52, 0x0a,
	0x17, 0x69, 0x66, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e,
	0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x14, 0x69, 0x66, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x12, 0x53, 0x0a, 0x17, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x15, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x5a, 0x0a, 0x1b, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x18, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x12, 0x58, 0x0a, 0x1a, 0x69, 0x66, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x17, 0x69, 0x66, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x5f, 0x0a, 0x1e,
	0x69, 0x66, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x1a, 0x69, 0x66, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x60, 0x0a,
	0x1e, 0x69, 0x66, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x1b, 0x69, 0x66, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12,
	0x67, 0x0a, 0x22, 0x69, 0x66, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1e, 0x69, 0x66, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x49, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x28, 0x0a,
	0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x10, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x37, 0x0a, 0x18, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x14, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x15, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x6d, 0x0a, 0x1c, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x19,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xa9, 0x05, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a,
	0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x75, 0x70, 0x6c, 0x6f, 0x61,
	0x64, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x70, 0x6c, 0x6f,
	0x61, 0x64, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x13, 0x69, 0x66, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11,
	0x69, 0x66, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x12, 0x52, 0x0a, 0x17, 0x69, 0x66, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x14, 0x69, 0x66, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x53, 0x0a, 0x17, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x15, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x5a, 0x0a, 0x1b, 0x69, 0x66,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x18, 0x69, 0x66,
	0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f,
	0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x6d, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x19, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x22, 0xc4, 0x05, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4d,
	0x65, 0x64, 0x69, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x72,
	0x65, 0x61, 0x64, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0a, 0x72, 0x65, 0x61, 0x64, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x1d, 0x0a, 0x0a,
	0x72, 0x65, 0x61, 0x64, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x09, 0x72, 0x65, 0x61, 0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x4b, 0x0a, 0x13, 0x69,
	0x66, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x69, 0x66, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x52, 0x0a, 0x17, 0x69, 0x66, 0x5f, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x14, 0x69, 0x66, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x53, 0x0a, 0x17,
	0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x69, 0x66, 0x4d, 0x65,
	0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x12, 0x5a, 0x0a, 0x1b, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x18, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x6d, 0x0a,
	0x1c, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x52, 0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x5a, 0x0a, 0x15,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xd4, 0x05, 0x0a, 0x10, 0x47, 0x65, 0x74,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a,
	0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x13, 0x69, 0x66, 0x5f, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x11, 0x69, 0x66, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x12, 0x52, 0x0a, 0x17, 0x69, 0x66, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x14, 0x69, 0x66, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x53, 0x0a, 0x17, 0x69, 0x66, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x5a, 0x0a,
	0x1b, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x18, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x49, 0x0a, 0x0a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6d, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22,
	0xb3, 0x02, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4d, 0x65, 0x64,
	0x69, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x10, 0x63, 0x68,
	0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x6d, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75,
	0x6d, 0x6d, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73,
	0x75, 0x6d, 0x6d, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x12, 0x4d, 0x0a, 0x10, 0x6f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x73, 0x52, 0x0f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x73, 0x12, 0x44, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x35,
	0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x08, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xc1, 0x04, 0x0a, 0x10, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x35, 0x0a, 0x08, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x59, 0x0a, 0x0e, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x5f,
	0x61, 0x63, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x65, 0x66,
	0x69, 0x6e, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x6c, 0x52, 0x0d, 0x70,
	0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x41, 0x63, 0x6c, 0x12, 0x4b, 0x0a, 0x13,
	0x69, 0x66, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x69, 0x66, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x52, 0x0a, 0x17, 0x69, 0x66, 0x5f,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74,
	0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x14, 0x69, 0x66, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x53, 0x0a,
	0x17, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x69, 0x66, 0x4d,
	0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x12, 0x5a, 0x0a, 0x1b, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x18, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x49,
	0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x75,
	0x6d, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa2, 0x05, 0x0a, 0x13, 0x49, 0x6e,
	0x73, 0x65, 0x72, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1d, 0x0a, 0x09, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64,
	0x12, 0x53, 0x0a, 0x12, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x70, 0x65,
	0x63, 0x48, 0x00, 0x52, 0x10, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x26, 0x0a, 0x0c, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x77, 0x72, 0x69, 0x74, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x4f, 0x0a,
	0x10, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x6d, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63,
	0x6b, 0x73, 0x75, 0x6d, 0x6d, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x48, 0x01, 0x52, 0x0f, 0x63,
	0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x6d, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x12, 0x48,
	0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4d,
	0x65, 0x64, 0x69, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x4d, 0x0a, 0x10, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x73, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x73, 0x75, 0x6d, 0x73, 0x52, 0x0f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x66, 0x69, 0x6e, 0x69, 0x73,
	0x68, 0x5f, 0x77, 0x72, 0x69, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x66,
	0x69, 0x6e, 0x69, 0x73, 0x68, 0x57, 0x72, 0x69, 0x74, 0x65, 0x12, 0x6d, 0x0a, 0x1c, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x19,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x42, 0x0f, 0x0a, 0x0d, 0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x22, 0xa8,
	0x03, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x64, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72,
	0x12, 0x3c, 0x0a, 0x1a, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x69,
	0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x18, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x54, 0x72, 0x61,
	0x69, 0x6c, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72, 0x12, 0x1f,
	0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16,
	0x0a, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x49, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5a, 0x0a,
	0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0x86, 0x02, 0x0a, 0x17, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x75,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x12, 0x6d, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x19, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x22, 0x5d, 0x0a, 0x18, 0x51, 0x75, 0x65, 0x72, 0x79, 0x57, 0x72, 0x69, 0x74, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x25,
	0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65,
	0x64, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74,
	0x65, 0x22, 0x80, 0x0e, 0x0a, 0x14, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x32, 0x0a, 0x12, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x32,
	0x0a, 0x12, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x11, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x12, 0x37, 0x0a, 0x18, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x70, 0x0a, 0x1a, 0x64,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x65,
	0x66, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d, 0x73, 0x2e,
	0x50, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x41, 0x63, 0x6c, 0x52, 0x18, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x41, 0x63, 0x6c, 0x12, 0x4b, 0x0a,
	0x13, 0x69, 0x66, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74,
	0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x69, 0x66, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x52, 0x0a, 0x17, 0x69, 0x66,
	0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x14, 0x69, 0x66, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x53,
	0x0a, 0x17, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x69, 0x66,
	0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x12, 0x5a, 0x0a, 0x1b, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x18, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12,
	0x58, 0x0a, 0x1a, 0x69, 0x66, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x17, 0x69, 0x66, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x5f, 0x0a, 0x1e, 0x69, 0x66, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1a,
	0x69, 0x66, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x60, 0x0a, 0x1e, 0x69, 0x66,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x1b, 0x69, 0x66, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x67, 0x0a, 0x22,
	0x69, 0x66, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1e, 0x69, 0x66, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x3e, 0x0a, 0x1c, 0x6d, 0x61, 0x78, 0x5f, 0x62, 0x79, 0x74,
	0x65, 0x73, 0x5f, 0x72, 0x65, 0x77, 0x72, 0x69, 0x74, 0x74, 0x65, 0x6e, 0x5f, 0x70, 0x65, 0x72,
	0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x03, 0x52, 0x18, 0x6d, 0x61, 0x78,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x74, 0x65, 0x6e, 0x50, 0x65,
	0x72, 0x43, 0x61, 0x6c, 0x6c, 0x12, 0x49, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12,
	0x28, 0x0a, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x12,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x0a, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x52, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x47, 0x0a, 0x20, 0x63, 0x6f, 0x70,
	0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x15, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x1d, 0x63, 0x6f, 0x70, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74,
	0x68, 0x6d, 0x12, 0x3b, 0x0a, 0x1a, 0x63, 0x6f, 0x70, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x63, 0x6f, 0x70, 0x79, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12,
	0x48, 0x0a, 0x21, 0x63, 0x6f, 0x70, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x68,
	0x61, 0x32, 0x35, 0x36, 0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1d, 0x63, 0x6f, 0x70, 0x79,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x4b, 0x65, 0x79, 0x53, 0x68, 0x61, 0x32, 0x35, 0x36, 0x12, 0x6d, 0x0a, 0x1c, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x19, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52,
	0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x22, 0xd6, 0x01, 0x0a, 0x0f, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x72, 0x65, 0x77, 0x72, 0x69, 0x74, 0x74, 0x65,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x74, 0x65, 0x6e, 0x12, 0x1f, 0x0a, 0x0b,
	0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0a, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x64, 0x6f, 0x6e, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x04, 0x64, 0x6f, 0x6e,
	0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x35, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xba, 0x02,
	0x0a, 0x1a, 0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x61, 0x62, 0x6c, 0x65,
	0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x12,
	0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73,
	0x65, 0x72, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x70, 0x65, 0x63, 0x52, 0x10, 0x69,
	0x6e, 0x73, 0x65, 0x72, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x6d, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x52, 0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x5a,
	0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0x3a, 0x0a, 0x1b, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x72, 0x69, 0x74,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x75, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x22, 0xa5, 0x07, 0x0a, 0x12, 0x50, 0x61, 0x74, 0x63, 0x68,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a,
	0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x13, 0x69, 0x66, 0x5f, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x11, 0x69, 0x66, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x12, 0x52, 0x0a, 0x17, 0x69, 0x66, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x14, 0x69, 0x66, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x53, 0x0a, 0x17, 0x69, 0x66, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x5a, 0x0a,
	0x1b, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x18, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x59, 0x0a, 0x0e, 0x70, 0x72, 0x65,
	0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d,
	0x73, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x41, 0x63, 0x6c, 0x52, 0x0d, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65,
	0x64, 0x41, 0x63, 0x6c, 0x12, 0x49, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x35, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x08, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x12, 0x6d, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xe9,
	0x06, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x12, 0x1e, 0x0a, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x4b, 0x0a, 0x13, 0x69, 0x66, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x69, 0x66, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x52, 0x0a,
	0x17, 0x69, 0x66, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e,
	0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x14, 0x69, 0x66, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x12, 0x53, 0x0a, 0x17, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x15, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x5a, 0x0a, 0x1b, 0x69, 0x66, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x18, 0x69, 0x66, 0x4d, 0x65, 0x74, 0x61,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x12, 0x59, 0x0a, 0x0e, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64,
	0x5f, 0x61, 0x63, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x65,
	0x66, 0x69, 0x6e, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x6c, 0x52, 0x0d,
	0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x41, 0x63, 0x6c, 0x12, 0x49, 0x0a,
	0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d,
	0x73, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x6d, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x52, 0x19, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x5a,
	0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xdd, 0x03, 0x0a, 0x16, 0x57,
	0x61, 0x74, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x1a, 0x0a,
	0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x64, 0x65, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x65,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x6d, 0x61,
	0x78, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x72, 0x65, 0x66,
	0x69, 0x78, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x12, 0x3c, 0x0a, 0x1a, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x69,
	0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x18, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x54, 0x72, 0x61,
	0x69, 0x6c, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x49, 0x0a,
	0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d,
	0x73, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x07, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x5a,
	0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xa1, 0x01, 0x0a, 0x1f, 0x47,
	0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22,
	0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x49, 0x64, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xcf,
	0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x48, 0x6d, 0x61, 0x63, 0x4b, 0x65, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x37, 0x0a, 0x15, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x65,
	0x6d, 0x61, 0x69, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x13, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45,
	0x6d, 0x61, 0x69, 0x6c, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x22, 0x6f, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x48, 0x6d, 0x61, 0x63, 0x4b, 0x65,
	0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x08, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x48, 0x6d, 0x61, 0x63, 0x4b, 0x65, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x22, 0xb8, 0x01, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x48, 0x6d, 0x61, 0x63,
	0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64,
	0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xb5, 0x01, 0x0a,
	0x11, 0x47, 0x65, 0x74, 0x48, 0x6d, 0x61, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52,
	0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x22, 0xb5, 0x02, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x6d, 0x61,
	0x63, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64,
	0x12, 0x32, 0x0a, 0x15, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x13, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45,
	0x6d, 0x61, 0x69, 0x6c, 0x12, 0x2a, 0x0a, 0x11, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0f, 0x73, 0x68, 0x6f, 0x77, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x73,
	0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0x78, 0x0a, 0x14,
	0x4c, 0x69, 0x73, 0x74, 0x48, 0x6d, 0x61, 0x63, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x38, 0x0a, 0x05,
	0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x48, 0x6d, 0x61, 0x63, 0x4b, 0x65, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x22, 0xfd, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x48, 0x6d, 0x61, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x20, 0x0a, 0x09, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x49,
	0x64, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x43, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x6d, 0x61, 0x63,
	0x4b, 0x65, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xb6, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x49, 0x61,
	0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43,
	0x0a, 0x0b, 0x69, 0x61, 0x6d, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x0a, 0x69, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22,
	0xb6, 0x01, 0x0a, 0x13, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x0b, 0x69, 0x61, 0x6d, 0x5f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74,
	0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x52, 0x0a, 0x69, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5a, 0x0a, 0x15,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xc2, 0x01, 0x0a, 0x19, 0x54, 0x65, 0x73,
	0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x0b, 0x69, 0x61, 0x6d, 0x5f, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74,
	0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x0a, 0x69, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x5a, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xa9, 0x01,
	0x0a, 0x19, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x31, 0x0a, 0x14, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69,
	0x74, 0x68, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x65, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x25,
	0x0a, 0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x32, 0x0a, 0x15, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x68, 0x61, 0x32, 0x35, 0x36, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x4b, 0x65, 0x79, 0x53, 0x68, 0x61, 0x32, 0x35, 0x36, 0x22, 0x90, 0x01, 0x0a, 0x13, 0x43, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x12, 0x26, 0x0a, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x75, 0x73,
	0x65, 0x72, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x71, 0x75, 0x6f,
	0x74, 0x61, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x71,
	0x75, 0x6f, 0x74, 0x61, 0x55, 0x73, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x22, 0xca, 0x05, 0x0a,
	0x10, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74,
	0x73, 0x22, 0xb5, 0x05, 0x0a, 0x06, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x16, 0x0a, 0x12,
	0x56, 0x41, 0x4c, 0x55, 0x45, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x14, 0x4d, 0x41, 0x58, 0x5f, 0x52, 0x45, 0x41, 0x44,
	0x5f, 0x43, 0x48, 0x55, 0x4e, 0x4b, 0x5f, 0x42, 0x59, 0x54, 0x45, 0x53, 0x10, 0x80, 0x80, 0x80,
	0x01, 0x12, 0x1c, 0x0a, 0x15, 0x4d, 0x41, 0x58, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x5f, 0x43,
	0x48, 0x55, 0x4e, 0x4b, 0x5f, 0x42, 0x59, 0x54, 0x45, 0x53, 0x10, 0x80, 0x80, 0x80, 0x01, 0x12,
	0x19, 0x0a, 0x12, 0x4d, 0x41, 0x58, 0x5f, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x53, 0x49,
	0x5a, 0x45, 0x5f, 0x4d, 0x42, 0x10, 0x80, 0x80, 0xc0, 0x02, 0x12, 0x29, 0x0a, 0x24, 0x4d, 0x41,
	0x58, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54,
	0x41, 0x5f, 0x46, 0x49, 0x45, 0x4c, 0x44, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x42, 0x59, 0x54,
	0x45, 0x53, 0x10, 0x80, 0x08, 0x12, 0x2a, 0x0a, 0x25, 0x4d, 0x41, 0x58, 0x5f, 0x43, 0x55, 0x53,
	0x54, 0x4f, 0x4d, 0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x46, 0x49, 0x45,
	0x4c, 0x44, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x42, 0x59, 0x54, 0x45, 0x53, 0x10, 0x80,
	0x20, 0x12, 0x29, 0x0a, 0x24, 0x4d, 0x41, 0x58, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x5f,
	0x4d, 0x45, 0x54, 0x41, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x4f, 0x54, 0x41, 0x4c, 0x5f, 0x53,
	0x49, 0x5a, 0x45, 0x5f, 0x42, 0x59, 0x54, 0x45, 0x53, 0x10, 0x80, 0x40, 0x12, 0x2a, 0x0a, 0x24,
	0x4d, 0x41, 0x58, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x4d, 0x45, 0x54, 0x41, 0x44,
	0x41, 0x54, 0x41, 0x5f, 0x54, 0x4f, 0x54, 0x41, 0x4c, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x5f, 0x42,
	0x59, 0x54, 0x45, 0x53, 0x10, 0x80, 0xa0, 0x01, 0x12, 0x27, 0x0a, 0x23, 0x4d, 0x41, 0x58, 0x5f,
	0x4e, 0x4f, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e,
	0x46, 0x49, 0x47, 0x53, 0x5f, 0x50, 0x45, 0x52, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x10,
	0x64, 0x12, 0x22, 0x0a, 0x1e, 0x4d, 0x41, 0x58, 0x5f, 0x4c, 0x49, 0x46, 0x45, 0x43, 0x59, 0x43,
	0x4c, 0x45, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x53, 0x5f, 0x50, 0x45, 0x52, 0x5f, 0x42, 0x55, 0x43,
	0x4b, 0x45, 0x54, 0x10, 0x64, 0x12, 0x26, 0x0a, 0x22, 0x4d, 0x41, 0x58, 0x5f, 0x4e, 0x4f, 0x54,
	0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d,
	0x5f, 0x41, 0x54, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x45, 0x53, 0x10, 0x05, 0x12, 0x31, 0x0a,
	0x2c, 0x4d, 0x41, 0x58, 0x5f, 0x4e, 0x4f, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x5f, 0x41, 0x54, 0x54, 0x52, 0x49, 0x42, 0x55,
	0x54, 0x45, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x4c, 0x45, 0x4e, 0x47, 0x54, 0x48, 0x10, 0x80, 0x02,
	0x12, 0x33, 0x0a, 0x2e, 0x4d, 0x41, 0x58, 0x5f, 0x4e, 0x4f, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x5f, 0x41, 0x54, 0x54, 0x52,
	0x49, 0x42, 0x55, 0x54, 0x45, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x4c, 0x45, 0x4e, 0x47,
	0x54, 0x48, 0x10, 0x80, 0x08, 0x12, 0x1c, 0x0a, 0x18, 0x4d, 0x41, 0x58, 0x5f, 0x4c, 0x41, 0x42,
	0x45, 0x4c, 0x53, 0x5f, 0x45, 0x4e, 0x54, 0x52, 0x49, 0x45, 0x53, 0x5f, 0x43, 0x4f, 0x55, 0x4e,
	0x54, 0x10, 0x40, 0x12, 0x1f, 0x0a, 0x1b, 0x4d, 0x41, 0x58, 0x5f, 0x4c, 0x41, 0x42, 0x45, 0x4c,
	0x53, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x4c, 0x45, 0x4e, 0x47,
	0x54, 0x48, 0x10, 0x3f, 0x12, 0x1f, 0x0a, 0x1a, 0x4d, 0x41, 0x58, 0x5f, 0x4c, 0x41, 0x42, 0x45,
	0x4c, 0x53, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x42, 0x59, 0x54,
	0x45, 0x53, 0x10, 0x80, 0x01, 0x12, 0x2e, 0x0a, 0x29, 0x4d, 0x41, 0x58, 0x5f, 0x4f, 0x42, 0x4a,
	0x45, 0x43, 0x54, 0x5f, 0x49, 0x44, 0x53, 0x5f, 0x50, 0x45, 0x52, 0x5f, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x45, 0x5f, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x53, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45,
	0x53, 0x54, 0x10, 0xe8, 0x07, 0x12, 0x1e, 0x0a, 0x1a, 0x53, 0x50, 0x4c, 0x49, 0x54, 0x5f, 0x54,
	0x4f, 0x4b, 0x45, 0x4e, 0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x44,
	0x41, 0x59, 0x53, 0x10, 0x0e, 0x1a, 0x02, 0x10, 0x01, 0x32, 0x96, 0x30, 0x0a, 0x07, 0x53, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x12, 0x6a, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0x00, 0x12, 0x74, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x22, 0x00, 0x12, 0x7a, 0x0a, 0x19, 0x49, 0x6e, 0x73, 0x65, 0x72,
	0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x22, 0x00, 0x12, 0x85, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73,
	0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x7a, 0x0a, 0x19, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x22, 0x00, 0x12, 0x78, 0x0a, 0x18, 0x50, 0x61, 0x74, 0x63, 0x68,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x22,
	0x00, 0x12, 0x50, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x12, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x22, 0x00, 0x12, 0x4d, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x12, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x22, 0x00, 0x12, 0x53, 0x0a, 0x0c, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x12, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x22, 0x00, 0x12, 0x61, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x12, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x5e, 0x0a, 0x0b, 0x4c, 0x69,
	0x73, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x12, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x67, 0x0a, 0x19, 0x4c, 0x6f,
	0x63, 0x6b, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x6b,
	0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x22, 0x00, 0x12, 0x55, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x00, 0x12, 0x55, 0x0a, 0x12, 0x53, 0x65,
	0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22,
	0x00, 0x12, 0x75, 0x0a, 0x18, 0x54, 0x65, 0x73, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x49,
	0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74,
	0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x51, 0x0a, 0x0b, 0x50, 0x61, 0x74, 0x63,
	0x68, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63,
	0x68, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x22, 0x00, 0x12, 0x53, 0x0a, 0x0c, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x22, 0x00,
	0x12, 0x4e, 0x0a, 0x0b, 0x53, 0x74, 0x6f, 0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x00,
	0x12, 0x78, 0x0a, 0x20, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x00, 0x12, 0x82, 0x01, 0x0a, 0x1d, 0x47,
	0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x22, 0x00, 0x12,
	0x88, 0x01, 0x0a, 0x20, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x44,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x22, 0x00, 0x12, 0x93, 0x01, 0x0a, 0x1f, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x12, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00,
	0x12, 0x86, 0x01, 0x0a, 0x1f, 0x50, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e,
	0x74, 0x72, 0x6f, 0x6c, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x22, 0x00, 0x12, 0x88, 0x01, 0x0a, 0x20, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x22, 0x00, 0x12, 0x5c, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x00, 0x12, 0x5f, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x00, 0x12, 0x65, 0x0a, 0x12, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x4e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x73, 0x65, 0x72, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x00, 0x12, 0x70, 0x0a, 0x11, 0x4c, 0x69,
	0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x6a, 0x0a, 0x19,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x00, 0x12, 0x74, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x22, 0x00, 0x12, 0x7a,
	0x0a, 0x19, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x22, 0x00, 0x12, 0x85, 0x01, 0x0a, 0x18, 0x4c,
	0x69, 0x73, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x00, 0x12, 0x78, 0x0a, 0x18, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x22, 0x00, 0x12, 0x7a, 0x0a, 0x19,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x22, 0x00, 0x12, 0x55, 0x0a, 0x0d, 0x43, 0x6f, 0x6d, 0x70,
	0x6f, 0x73, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x70, 0x6f, 0x73, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x00, 0x12,
	0x4f, 0x0a, 0x0a, 0x43, 0x6f, 0x70, 0x79, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x70, 0x79, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x00,
	0x12, 0x50, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x12, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x00, 0x12, 0x4d, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x22,
	0x00, 0x12, 0x69, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4d, 0x65,
	0x64, 0x69, 0x61, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4d, 0x65, 0x64, 0x69, 0x61,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x30, 0x01, 0x12, 0x55, 0x0a, 0x0c,
	0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x22,
	0x00, 0x28, 0x01, 0x12, 0x5e, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x12, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x00, 0x12, 0x5e, 0x0a, 0x0d, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x00, 0x12, 0x76, 0x0a, 0x13, 0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75,
	0x6d, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x72, 0x69, 0x74, 0x65, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x72, 0x69,
	0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x72, 0x69, 0x74,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x6d, 0x0a, 0x10, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x51, 0x0a, 0x0b, 0x50, 0x61,
	0x74, 0x63, 0x68, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61,
	0x74, 0x63, 0x68, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x00, 0x12, 0x53, 0x0a,
	0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x22, 0x00, 0x12, 0x55, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x00, 0x12, 0x55, 0x0a, 0x12, 0x53, 0x65, 0x74,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x00,
	0x12, 0x75, 0x0a, 0x18, 0x54, 0x65, 0x73, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x61,
	0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49,
	0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x5a, 0x0a, 0x0f, 0x57, 0x61, 0x74, 0x63, 0x68,
	0x41, 0x6c, 0x6c, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57,
	0x61, 0x74, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x22, 0x00, 0x12, 0x6c, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22,
	0x00, 0x12, 0x64, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x48, 0x6d, 0x61, 0x63, 0x4b,
	0x65, 0x79, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x48, 0x6d, 0x61,
	0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x48, 0x6d, 0x61, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x52, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x48, 0x6d, 0x61, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x48, 0x6d, 0x61, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x00, 0x12, 0x58, 0x0a, 0x0a, 0x47,
	0x65, 0x74, 0x48, 0x6d, 0x61, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x48, 0x6d, 0x61, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x48, 0x6d, 0x61, 0x63, 0x4b, 0x65, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x22, 0x00, 0x12, 0x61, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x6d, 0x61,
	0x63, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x6d,
	0x61, 0x63, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x6d, 0x61, 0x63, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x5e, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x48, 0x6d, 0x61, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x48, 0x6d, 0x61, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x6d, 0x61, 0x63, 0x4b, 0x65, 0x79, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x00, 0x1a, 0xa7, 0x02, 0xca, 0x41, 0x16, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x8a, 0x02, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x2d, 0x6f, 0x6e, 0x6c, 0x79, 0x2c,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x64, 0x65, 0x76, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x66, 0x75, 0x6c, 0x6c, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x65, 0x76, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x2c, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x65, 0x76,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x77, 0x72, 0x69,
	0x74, 0x65, 0x42, 0x53, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x50, 0x01, 0x5a, 0x38, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67,
	0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x3b,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_storage_v1_storage_proto_rawDescOnce sync.Once
	file_google_storage_v1_storage_proto_rawDescData = file_google_storage_v1_storage_proto_rawDesc
)

func file_google_storage_v1_storage_proto_rawDescGZIP() []byte {
	file_google_storage_v1_storage_proto_rawDescOnce.Do(func() {
		file_google_storage_v1_storage_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_storage_v1_storage_proto_rawDescData)
	})
	return file_google_storage_v1_storage_proto_rawDescData
}

var file_google_storage_v1_storage_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_storage_v1_storage_proto_msgTypes = make([]protoimpl.MessageInfo, 65)
var file_google_storage_v1_storage_proto_goTypes = []interface{}{
	(ServiceConstants_Values)(0),                                   // 0: google.storage.v1.ServiceConstants.Values
	(*DeleteBucketAccessControlRequest)(nil),                       // 1: google.storage.v1.DeleteBucketAccessControlRequest
	(*GetBucketAccessControlRequest)(nil),                          // 2: google.storage.v1.GetBucketAccessControlRequest
	(*InsertBucketAccessControlRequest)(nil),                       // 3: google.storage.v1.InsertBucketAccessControlRequest
	(*ListBucketAccessControlsRequest)(nil),                        // 4: google.storage.v1.ListBucketAccessControlsRequest
	(*PatchBucketAccessControlRequest)(nil),                        // 5: google.storage.v1.PatchBucketAccessControlRequest
	(*UpdateBucketAccessControlRequest)(nil),                       // 6: google.storage.v1.UpdateBucketAccessControlRequest
	(*DeleteBucketRequest)(nil),                                    // 7: google.storage.v1.DeleteBucketRequest
	(*GetBucketRequest)(nil),                                       // 8: google.storage.v1.GetBucketRequest
	(*InsertBucketRequest)(nil),                                    // 9: google.storage.v1.InsertBucketRequest
	(*ListChannelsRequest)(nil),                                    // 10: google.storage.v1.ListChannelsRequest
	(*ListBucketsRequest)(nil),                                     // 11: google.storage.v1.ListBucketsRequest
	(*LockRetentionPolicyRequest)(nil),                             // 12: google.storage.v1.LockRetentionPolicyRequest
	(*PatchBucketRequest)(nil),                                     // 13: google.storage.v1.PatchBucketRequest
	(*UpdateBucketRequest)(nil),                                    // 14: google.storage.v1.UpdateBucketRequest
	(*StopChannelRequest)(nil),                                     // 15: google.storage.v1.StopChannelRequest
	(*DeleteDefaultObjectAccessControlRequest)(nil),                // 16: google.storage.v1.DeleteDefaultObjectAccessControlRequest
	(*GetDefaultObjectAccessControlRequest)(nil),                   // 17: google.storage.v1.GetDefaultObjectAccessControlRequest
	(*InsertDefaultObjectAccessControlRequest)(nil),                // 18: google.storage.v1.InsertDefaultObjectAccessControlRequest
	(*ListDefaultObjectAccessControlsRequest)(nil),                 // 19: google.storage.v1.ListDefaultObjectAccessControlsRequest
	(*PatchDefaultObjectAccessControlRequest)(nil),                 // 20: google.storage.v1.PatchDefaultObjectAccessControlRequest
	(*UpdateDefaultObjectAccessControlRequest)(nil),                // 21: google.storage.v1.UpdateDefaultObjectAccessControlRequest
	(*DeleteNotificationRequest)(nil),                              // 22: google.storage.v1.DeleteNotificationRequest
	(*GetNotificationRequest)(nil),                                 // 23: google.storage.v1.GetNotificationRequest
	(*InsertNotificationRequest)(nil),                              // 24: google.storage.v1.InsertNotificationRequest
	(*ListNotificationsRequest)(nil),                               // 25: google.storage.v1.ListNotificationsRequest
	(*DeleteObjectAccessControlRequest)(nil),                       // 26: google.storage.v1.DeleteObjectAccessControlRequest
	(*GetObjectAccessControlRequest)(nil),                          // 27: google.storage.v1.GetObjectAccessControlRequest
	(*InsertObjectAccessControlRequest)(nil),                       // 28: google.storage.v1.InsertObjectAccessControlRequest
	(*ListObjectAccessControlsRequest)(nil),                        // 29: google.storage.v1.ListObjectAccessControlsRequest
	(*PatchObjectAccessControlRequest)(nil),                        // 30: google.storage.v1.PatchObjectAccessControlRequest
	(*UpdateObjectAccessControlRequest)(nil),                       // 31: google.storage.v1.UpdateObjectAccessControlRequest
	(*ComposeObjectRequest)(nil),                                   // 32: google.storage.v1.ComposeObjectRequest
	(*CopyObjectRequest)(nil),                                      // 33: google.storage.v1.CopyObjectRequest
	(*DeleteObjectRequest)(nil),                                    // 34: google.storage.v1.DeleteObjectRequest
	(*GetObjectMediaRequest)(nil),                                  // 35: google.storage.v1.GetObjectMediaRequest
	(*GetObjectRequest)(nil),                                       // 36: google.storage.v1.GetObjectRequest
	(*GetObjectMediaResponse)(nil),                                 // 37: google.storage.v1.GetObjectMediaResponse
	(*InsertObjectSpec)(nil),                                       // 38: google.storage.v1.InsertObjectSpec
	(*InsertObjectRequest)(nil),                                    // 39: google.storage.v1.InsertObjectRequest
	(*ListObjectsRequest)(nil),                                     // 40: google.storage.v1.ListObjectsRequest
	(*QueryWriteStatusRequest)(nil),                                // 41: google.storage.v1.QueryWriteStatusRequest
	(*QueryWriteStatusResponse)(nil),                               // 42: google.storage.v1.QueryWriteStatusResponse
	(*RewriteObjectRequest)(nil),                                   // 43: google.storage.v1.RewriteObjectRequest
	(*RewriteResponse)(nil),                                        // 44: google.storage.v1.RewriteResponse
	(*StartResumableWriteRequest)(nil),                             // 45: google.storage.v1.StartResumableWriteRequest
	(*StartResumableWriteResponse)(nil),                            // 46: google.storage.v1.StartResumableWriteResponse
	(*PatchObjectRequest)(nil),                                     // 47: google.storage.v1.PatchObjectRequest
	(*UpdateObjectRequest)(nil),                                    // 48: google.storage.v1.UpdateObjectRequest
	(*WatchAllObjectsRequest)(nil),                                 // 49: google.storage.v1.WatchAllObjectsRequest
	(*GetProjectServiceAccountRequest)(nil),                        // 50: google.storage.v1.GetProjectServiceAccountRequest
	(*CreateHmacKeyRequest)(nil),                                   // 51: google.storage.v1.CreateHmacKeyRequest
	(*CreateHmacKeyResponse)(nil),                                  // 52: google.storage.v1.CreateHmacKeyResponse
	(*DeleteHmacKeyRequest)(nil),                                   // 53: google.storage.v1.DeleteHmacKeyRequest
	(*GetHmacKeyRequest)(nil),                                      // 54: google.storage.v1.GetHmacKeyRequest
	(*ListHmacKeysRequest)(nil),                                    // 55: google.storage.v1.ListHmacKeysRequest
	(*ListHmacKeysResponse)(nil),                                   // 56: google.storage.v1.ListHmacKeysResponse
	(*UpdateHmacKeyRequest)(nil),                                   // 57: google.storage.v1.UpdateHmacKeyRequest
	(*GetIamPolicyRequest)(nil),                                    // 58: google.storage.v1.GetIamPolicyRequest
	(*SetIamPolicyRequest)(nil),                                    // 59: google.storage.v1.SetIamPolicyRequest
	(*TestIamPermissionsRequest)(nil),                              // 60: google.storage.v1.TestIamPermissionsRequest
	(*CommonObjectRequestParams)(nil),                              // 61: google.storage.v1.CommonObjectRequestParams
	(*CommonRequestParams)(nil),                                    // 62: google.storage.v1.CommonRequestParams
	(*ServiceConstants)(nil),                                       // 63: google.storage.v1.ServiceConstants
	(*ComposeObjectRequest_SourceObjects)(nil),                     // 64: google.storage.v1.ComposeObjectRequest.SourceObjects
	(*ComposeObjectRequest_SourceObjects_ObjectPreconditions)(nil), // 65: google.storage.v1.ComposeObjectRequest.SourceObjects.ObjectPreconditions
	(*BucketAccessControl)(nil),                                    // 66: google.storage.v1.BucketAccessControl
	(*field_mask.FieldMask)(nil),                                   // 67: google.protobuf.FieldMask
	(*wrappers.Int64Value)(nil),                                    // 68: google.protobuf.Int64Value
	(CommonEnums_Projection)(0),                                    // 69: google.storage.v1.CommonEnums.Projection
	(CommonEnums_PredefinedBucketAcl)(0),                           // 70: google.storage.v1.CommonEnums.PredefinedBucketAcl
	(CommonEnums_PredefinedObjectAcl)(0),                           // 71: google.storage.v1.CommonEnums.PredefinedObjectAcl
	(*Bucket)(nil),                                                 // 72: google.storage.v1.Bucket
	(*Channel)(nil),                                                // 73: google.storage.v1.Channel
	(*ObjectAccessControl)(nil),                                    // 74: google.storage.v1.ObjectAccessControl
	(*Notification)(nil),                                           // 75: google.storage.v1.Notification
	(*Object)(nil),                                                 // 76: google.storage.v1.Object
	(*ChecksummedData)(nil),                                        // 77: google.storage.v1.ChecksummedData
	(*ObjectChecksums)(nil),                                        // 78: google.storage.v1.ObjectChecksums
	(*ContentRange)(nil),                                           // 79: google.storage.v1.ContentRange
	(*HmacKeyMetadata)(nil),                                        // 80: google.storage.v1.HmacKeyMetadata
	(*v1.GetIamPolicyRequest)(nil),                                 // 81: google.iam.v1.GetIamPolicyRequest
	(*v1.SetIamPolicyRequest)(nil),                                 // 82: google.iam.v1.SetIamPolicyRequest
	(*v1.TestIamPermissionsRequest)(nil),                           // 83: google.iam.v1.TestIamPermissionsRequest
	(*empty.Empty)(nil),                                            // 84: google.protobuf.Empty
	(*ListBucketAccessControlsResponse)(nil),                       // 85: google.storage.v1.ListBucketAccessControlsResponse
	(*ListChannelsResponse)(nil),                                   // 86: google.storage.v1.ListChannelsResponse
	(*ListBucketsResponse)(nil),                                    // 87: google.storage.v1.ListBucketsResponse
	(*v1.Policy)(nil),                                              // 88: google.iam.v1.Policy
	(*v1.TestIamPermissionsResponse)(nil),                          // 89: google.iam.v1.TestIamPermissionsResponse
	(*ListObjectAccessControlsResponse)(nil),                       // 90: google.storage.v1.ListObjectAccessControlsResponse
	(*ListNotificationsResponse)(nil),                              // 91: google.storage.v1.ListNotificationsResponse
	(*ListObjectsResponse)(nil),                                    // 92: google.storage.v1.ListObjectsResponse
	(*ServiceAccount)(nil),                                         // 93: google.storage.v1.ServiceAccount
}
var file_google_storage_v1_storage_proto_depIdxs = []int32{
	62,  // 0: google.storage.v1.DeleteBucketAccessControlRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	62,  // 1: google.storage.v1.GetBucketAccessControlRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	66,  // 2: google.storage.v1.InsertBucketAccessControlRequest.bucket_access_control:type_name -> google.storage.v1.BucketAccessControl
	62,  // 3: google.storage.v1.InsertBucketAccessControlRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	62,  // 4: google.storage.v1.ListBucketAccessControlsRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	66,  // 5: google.storage.v1.PatchBucketAccessControlRequest.bucket_access_control:type_name -> google.storage.v1.BucketAccessControl
	67,  // 6: google.storage.v1.PatchBucketAccessControlRequest.update_mask:type_name -> google.protobuf.FieldMask
	62,  // 7: google.storage.v1.PatchBucketAccessControlRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	66,  // 8: google.storage.v1.UpdateBucketAccessControlRequest.bucket_access_control:type_name -> google.storage.v1.BucketAccessControl
	62,  // 9: google.storage.v1.UpdateBucketAccessControlRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	68,  // 10: google.storage.v1.DeleteBucketRequest.if_metageneration_match:type_name -> google.protobuf.Int64Value
	68,  // 11: google.storage.v1.DeleteBucketRequest.if_metageneration_not_match:type_name -> google.protobuf.Int64Value
	62,  // 12: google.storage.v1.DeleteBucketRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	68,  // 13: google.storage.v1.GetBucketRequest.if_metageneration_match:type_name -> google.protobuf.Int64Value
	68,  // 14: google.storage.v1.GetBucketRequest.if_metageneration_not_match:type_name -> google.protobuf.Int64Value
	69,  // 15: google.storage.v1.GetBucketRequest.projection:type_name -> google.storage.v1.CommonEnums.Projection
	62,  // 16: google.storage.v1.GetBucketRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	70,  // 17: google.storage.v1.InsertBucketRequest.predefined_acl:type_name -> google.storage.v1.CommonEnums.PredefinedBucketAcl
	71,  // 18: google.storage.v1.InsertBucketRequest.predefined_default_object_acl:type_name -> google.storage.v1.CommonEnums.PredefinedObjectAcl
	69,  // 19: google.storage.v1.InsertBucketRequest.projection:type_name -> google.storage.v1.CommonEnums.Projection
	72,  // 20: google.storage.v1.InsertBucketRequest.bucket:type_name -> google.storage.v1.Bucket
	62,  // 21: google.storage.v1.InsertBucketRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	62,  // 22: google.storage.v1.ListChannelsRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	69,  // 23: google.storage.v1.ListBucketsRequest.projection:type_name -> google.storage.v1.CommonEnums.Projection
	62,  // 24: google.storage.v1.ListBucketsRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	62,  // 25: google.storage.v1.LockRetentionPolicyRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	68,  // 26: google.storage.v1.PatchBucketRequest.if_metageneration_match:type_name -> google.protobuf.Int64Value
	68,  // 27: google.storage.v1.PatchBucketRequest.if_metageneration_not_match:type_name -> google.protobuf.Int64Value
	70,  // 28: google.storage.v1.PatchBucketRequest.predefined_acl:type_name -> google.storage.v1.CommonEnums.PredefinedBucketAcl
	71,  // 29: google.storage.v1.PatchBucketRequest.predefined_default_object_acl:type_name -> google.storage.v1.CommonEnums.PredefinedObjectAcl
	69,  // 30: google.storage.v1.PatchBucketRequest.projection:type_name -> google.storage.v1.CommonEnums.Projection
	72,  // 31: google.storage.v1.PatchBucketRequest.metadata:type_name -> google.storage.v1.Bucket
	67,  // 32: google.storage.v1.PatchBucketRequest.update_mask:type_name -> google.protobuf.FieldMask
	62,  // 33: google.storage.v1.PatchBucketRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	68,  // 34: google.storage.v1.UpdateBucketRequest.if_metageneration_match:type_name -> google.protobuf.Int64Value
	68,  // 35: google.storage.v1.UpdateBucketRequest.if_metageneration_not_match:type_name -> google.protobuf.Int64Value
	70,  // 36: google.storage.v1.UpdateBucketRequest.predefined_acl:type_name -> google.storage.v1.CommonEnums.PredefinedBucketAcl
	71,  // 37: google.storage.v1.UpdateBucketRequest.predefined_default_object_acl:type_name -> google.storage.v1.CommonEnums.PredefinedObjectAcl
	69,  // 38: google.storage.v1.UpdateBucketRequest.projection:type_name -> google.storage.v1.CommonEnums.Projection
	72,  // 39: google.storage.v1.UpdateBucketRequest.metadata:type_name -> google.storage.v1.Bucket
	62,  // 40: google.storage.v1.UpdateBucketRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	73,  // 41: google.storage.v1.StopChannelRequest.channel:type_name -> google.storage.v1.Channel
	62,  // 42: google.storage.v1.StopChannelRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	62,  // 43: google.storage.v1.DeleteDefaultObjectAccessControlRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	62,  // 44: google.storage.v1.GetDefaultObjectAccessControlRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	74,  // 45: google.storage.v1.InsertDefaultObjectAccessControlRequest.object_access_control:type_name -> google.storage.v1.ObjectAccessControl
	62,  // 46: google.storage.v1.InsertDefaultObjectAccessControlRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	68,  // 47: google.storage.v1.ListDefaultObjectAccessControlsRequest.if_metageneration_match:type_name -> google.protobuf.Int64Value
	68,  // 48: google.storage.v1.ListDefaultObjectAccessControlsRequest.if_metageneration_not_match:type_name -> google.protobuf.Int64Value
	62,  // 49: google.storage.v1.ListDefaultObjectAccessControlsRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	74,  // 50: google.storage.v1.PatchDefaultObjectAccessControlRequest.object_access_control:type_name -> google.storage.v1.ObjectAccessControl
	67,  // 51: google.storage.v1.PatchDefaultObjectAccessControlRequest.update_mask:type_name -> google.protobuf.FieldMask
	62,  // 52: google.storage.v1.PatchDefaultObjectAccessControlRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	74,  // 53: google.storage.v1.UpdateDefaultObjectAccessControlRequest.object_access_control:type_name -> google.storage.v1.ObjectAccessControl
	62,  // 54: google.storage.v1.UpdateDefaultObjectAccessControlRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	62,  // 55: google.storage.v1.DeleteNotificationRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	62,  // 56: google.storage.v1.GetNotificationRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	75,  // 57: google.storage.v1.InsertNotificationRequest.notification:type_name -> google.storage.v1.Notification
	62,  // 58: google.storage.v1.InsertNotificationRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	62,  // 59: google.storage.v1.ListNotificationsRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	62,  // 60: google.storage.v1.DeleteObjectAccessControlRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	62,  // 61: google.storage.v1.GetObjectAccessControlRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	74,  // 62: google.storage.v1.InsertObjectAccessControlRequest.object_access_control:type_name -> google.storage.v1.ObjectAccessControl
	62,  // 63: google.storage.v1.InsertObjectAccessControlRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	62,  // 64: google.storage.v1.ListObjectAccessControlsRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	74,  // 65: google.storage.v1.PatchObjectAccessControlRequest.object_access_control:type_name -> google.storage.v1.ObjectAccessControl
	62,  // 66: google.storage.v1.PatchObjectAccessControlRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	67,  // 67: google.storage.v1.PatchObjectAccessControlRequest.update_mask:type_name -> google.protobuf.FieldMask
	74,  // 68: google.storage.v1.UpdateObjectAccessControlRequest.object_access_control:type_name -> google.storage.v1.ObjectAccessControl
	62,  // 69: google.storage.v1.UpdateObjectAccessControlRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	67,  // 70: google.storage.v1.UpdateObjectAccessControlRequest.update_mask:type_name -> google.protobuf.FieldMask
	71,  // 71: google.storage.v1.ComposeObjectRequest.destination_predefined_acl:type_name -> google.storage.v1.CommonEnums.PredefinedObjectAcl
	76,  // 72: google.storage.v1.ComposeObjectRequest.destination:type_name -> google.storage.v1.Object
	64,  // 73: google.storage.v1.ComposeObjectRequest.source_objects:type_name -> google.storage.v1.ComposeObjectRequest.SourceObjects
	68,  // 74: google.storage.v1.ComposeObjectRequest.if_generation_match:type_name -> google.protobuf.Int64Value
	68,  // 75: google.storage.v1.ComposeObjectRequest.if_metageneration_match:type_name -> google.protobuf.Int64Value
	61,  // 76: google.storage.v1.ComposeObjectRequest.common_object_request_params:type_name -> google.storage.v1.CommonObjectRequestParams
	62,  // 77: google.storage.v1.ComposeObjectRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	71,  // 78: google.storage.v1.CopyObjectRequest.destination_predefined_acl:type_name -> google.storage.v1.CommonEnums.PredefinedObjectAcl
	68,  // 79: google.storage.v1.CopyObjectRequest.if_generation_match:type_name -> google.protobuf.Int64Value
	68,  // 80: google.storage.v1.CopyObjectRequest.if_generation_not_match:type_name -> google.protobuf.Int64Value
	68,  // 81: google.storage.v1.CopyObjectRequest.if_metageneration_match:type_name -> google.protobuf.Int64Value
	68,  // 82: google.storage.v1.CopyObjectRequest.if_metageneration_not_match:type_name -> google.protobuf.Int64Value
	68,  // 83: google.storage.v1.CopyObjectRequest.if_source_generation_match:type_name -> google.protobuf.Int64Value
	68,  // 84: google.storage.v1.CopyObjectRequest.if_source_generation_not_match:type_name -> google.protobuf.Int64Value
	68,  // 85: google.storage.v1.CopyObjectRequest.if_source_metageneration_match:type_name -> google.protobuf.Int64Value
	68,  // 86: google.storage.v1.CopyObjectRequest.if_source_metageneration_not_match:type_name -> google.protobuf.Int64Value
	69,  // 87: google.storage.v1.CopyObjectRequest.projection:type_name -> google.storage.v1.CommonEnums.Projection
	76,  // 88: google.storage.v1.CopyObjectRequest.destination:type_name -> google.storage.v1.Object
	61,  // 89: google.storage.v1.CopyObjectRequest.common_object_request_params:type_name -> google.storage.v1.CommonObjectRequestParams
	62,  // 90: google.storage.v1.CopyObjectRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	68,  // 91: google.storage.v1.DeleteObjectRequest.if_generation_match:type_name -> google.protobuf.Int64Value
	68,  // 92: google.storage.v1.DeleteObjectRequest.if_generation_not_match:type_name -> google.protobuf.Int64Value
	68,  // 93: google.storage.v1.DeleteObjectRequest.if_metageneration_match:type_name -> google.protobuf.Int64Value
	68,  // 94: google.storage.v1.DeleteObjectRequest.if_metageneration_not_match:type_name -> google.protobuf.Int64Value
	61,  // 95: google.storage.v1.DeleteObjectRequest.common_object_request_params:type_name -> google.storage.v1.CommonObjectRequestParams
	62,  // 96: google.storage.v1.DeleteObjectRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	68,  // 97: google.storage.v1.GetObjectMediaRequest.if_generation_match:type_name -> google.protobuf.Int64Value
	68,  // 98: google.storage.v1.GetObjectMediaRequest.if_generation_not_match:type_name -> google.protobuf.Int64Value
	68,  // 99: google.storage.v1.GetObjectMediaRequest.if_metageneration_match:type_name -> google.protobuf.Int64Value
	68,  // 100: google.storage.v1.GetObjectMediaRequest.if_metageneration_not_match:type_name -> google.protobuf.Int64Value
	61,  // 101: google.storage.v1.GetObjectMediaRequest.common_object_request_params:type_name -> google.storage.v1.CommonObjectRequestParams
	62,  // 102: google.storage.v1.GetObjectMediaRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	68,  // 103: google.storage.v1.GetObjectRequest.if_generation_match:type_name -> google.protobuf.Int64Value
	68,  // 104: google.storage.v1.GetObjectRequest.if_generation_not_match:type_name -> google.protobuf.Int64Value
	68,  // 105: google.storage.v1.GetObjectRequest.if_metageneration_match:type_name -> google.protobuf.Int64Value
	68,  // 106: google.storage.v1.GetObjectRequest.if_metageneration_not_match:type_name -> google.protobuf.Int64Value
	69,  // 107: google.storage.v1.GetObjectRequest.projection:type_name -> google.storage.v1.CommonEnums.Projection
	61,  // 108: google.storage.v1.GetObjectRequest.common_object_request_params:type_name -> google.storage.v1.CommonObjectRequestParams
	62,  // 109: google.storage.v1.GetObjectRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	77,  // 110: google.storage.v1.GetObjectMediaResponse.checksummed_data:type_name -> google.storage.v1.ChecksummedData
	78,  // 111: google.storage.v1.GetObjectMediaResponse.object_checksums:type_name -> google.storage.v1.ObjectChecksums
	79,  // 112: google.storage.v1.GetObjectMediaResponse.content_range:type_name -> google.storage.v1.ContentRange
	76,  // 113: google.storage.v1.GetObjectMediaResponse.metadata:type_name -> google.storage.v1.Object
	76,  // 114: google.storage.v1.InsertObjectSpec.resource:type_name -> google.storage.v1.Object
	71,  // 115: google.storage.v1.InsertObjectSpec.predefined_acl:type_name -> google.storage.v1.CommonEnums.PredefinedObjectAcl
	68,  // 116: google.storage.v1.InsertObjectSpec.if_generation_match:type_name -> google.protobuf.Int64Value
	68,  // 117: google.storage.v1.InsertObjectSpec.if_generation_not_match:type_name -> google.protobuf.Int64Value
	68,  // 118: google.storage.v1.InsertObjectSpec.if_metageneration_match:type_name -> google.protobuf.Int64Value
	68,  // 119: google.storage.v1.InsertObjectSpec.if_metageneration_not_match:type_name -> google.protobuf.Int64Value
	69,  // 120: google.storage.v1.InsertObjectSpec.projection:type_name -> google.storage.v1.CommonEnums.Projection
	38,  // 121: google.storage.v1.InsertObjectRequest.insert_object_spec:type_name -> google.storage.v1.InsertObjectSpec
	77,  // 122: google.storage.v1.InsertObjectRequest.checksummed_data:type_name -> google.storage.v1.ChecksummedData
	35,  // 123: google.storage.v1.InsertObjectRequest.reference:type_name -> google.storage.v1.GetObjectMediaRequest
	78,  // 124: google.storage.v1.InsertObjectRequest.object_checksums:type_name -> google.storage.v1.ObjectChecksums
	61,  // 125: google.storage.v1.InsertObjectRequest.common_object_request_params:type_name -> google.storage.v1.CommonObjectRequestParams
	62,  // 126: google.storage.v1.InsertObjectRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	69,  // 127: google.storage.v1.ListObjectsRequest.projection:type_name -> google.storage.v1.CommonEnums.Projection
	62,  // 128: google.storage.v1.ListObjectsRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	61,  // 129: google.storage.v1.QueryWriteStatusRequest.common_object_request_params:type_name -> google.storage.v1.CommonObjectRequestParams
	62,  // 130: google.storage.v1.QueryWriteStatusRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	71,  // 131: google.storage.v1.RewriteObjectRequest.destination_predefined_acl:type_name -> google.storage.v1.CommonEnums.PredefinedObjectAcl
	68,  // 132: google.storage.v1.RewriteObjectRequest.if_generation_match:type_name -> google.protobuf.Int64Value
	68,  // 133: google.storage.v1.RewriteObjectRequest.if_generation_not_match:type_name -> google.protobuf.Int64Value
	68,  // 134: google.storage.v1.RewriteObjectRequest.if_metageneration_match:type_name -> google.protobuf.Int64Value
	68,  // 135: google.storage.v1.RewriteObjectRequest.if_metageneration_not_match:type_name -> google.protobuf.Int64Value
	68,  // 136: google.storage.v1.RewriteObjectRequest.if_source_generation_match:type_name -> google.protobuf.Int64Value
	68,  // 137: google.storage.v1.RewriteObjectRequest.if_source_generation_not_match:type_name -> google.protobuf.Int64Value
	68,  // 138: google.storage.v1.RewriteObjectRequest.if_source_metageneration_match:type_name -> google.protobuf.Int64Value
	68,  // 139: google.storage.v1.RewriteObjectRequest.if_source_metageneration_not_match:type_name -> google.protobuf.Int64Value
	69,  // 140: google.storage.v1.RewriteObjectRequest.projection:type_name -> google.storage.v1.CommonEnums.Projection
	76,  // 141: google.storage.v1.RewriteObjectRequest.object:type_name -> google.storage.v1.Object
	61,  // 142: google.storage.v1.RewriteObjectRequest.common_object_request_params:type_name -> google.storage.v1.CommonObjectRequestParams
	62,  // 143: google.storage.v1.RewriteObjectRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	76,  // 144: google.storage.v1.RewriteResponse.resource:type_name -> google.storage.v1.Object
	38,  // 145: google.storage.v1.StartResumableWriteRequest.insert_object_spec:type_name -> google.storage.v1.InsertObjectSpec
	61,  // 146: google.storage.v1.StartResumableWriteRequest.common_object_request_params:type_name -> google.storage.v1.CommonObjectRequestParams
	62,  // 147: google.storage.v1.StartResumableWriteRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	68,  // 148: google.storage.v1.PatchObjectRequest.if_generation_match:type_name -> google.protobuf.Int64Value
	68,  // 149: google.storage.v1.PatchObjectRequest.if_generation_not_match:type_name -> google.protobuf.Int64Value
	68,  // 150: google.storage.v1.PatchObjectRequest.if_metageneration_match:type_name -> google.protobuf.Int64Value
	68,  // 151: google.storage.v1.PatchObjectRequest.if_metageneration_not_match:type_name -> google.protobuf.Int64Value
	71,  // 152: google.storage.v1.PatchObjectRequest.predefined_acl:type_name -> google.storage.v1.CommonEnums.PredefinedObjectAcl
	69,  // 153: google.storage.v1.PatchObjectRequest.projection:type_name -> google.storage.v1.CommonEnums.Projection
	76,  // 154: google.storage.v1.PatchObjectRequest.metadata:type_name -> google.storage.v1.Object
	67,  // 155: google.storage.v1.PatchObjectRequest.update_mask:type_name -> google.protobuf.FieldMask
	61,  // 156: google.storage.v1.PatchObjectRequest.common_object_request_params:type_name -> google.storage.v1.CommonObjectRequestParams
	62,  // 157: google.storage.v1.PatchObjectRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	68,  // 158: google.storage.v1.UpdateObjectRequest.if_generation_match:type_name -> google.protobuf.Int64Value
	68,  // 159: google.storage.v1.UpdateObjectRequest.if_generation_not_match:type_name -> google.protobuf.Int64Value
	68,  // 160: google.storage.v1.UpdateObjectRequest.if_metageneration_match:type_name -> google.protobuf.Int64Value
	68,  // 161: google.storage.v1.UpdateObjectRequest.if_metageneration_not_match:type_name -> google.protobuf.Int64Value
	71,  // 162: google.storage.v1.UpdateObjectRequest.predefined_acl:type_name -> google.storage.v1.CommonEnums.PredefinedObjectAcl
	69,  // 163: google.storage.v1.UpdateObjectRequest.projection:type_name -> google.storage.v1.CommonEnums.Projection
	76,  // 164: google.storage.v1.UpdateObjectRequest.metadata:type_name -> google.storage.v1.Object
	61,  // 165: google.storage.v1.UpdateObjectRequest.common_object_request_params:type_name -> google.storage.v1.CommonObjectRequestParams
	62,  // 166: google.storage.v1.UpdateObjectRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	69,  // 167: google.storage.v1.WatchAllObjectsRequest.projection:type_name -> google.storage.v1.CommonEnums.Projection
	73,  // 168: google.storage.v1.WatchAllObjectsRequest.channel:type_name -> google.storage.v1.Channel
	62,  // 169: google.storage.v1.WatchAllObjectsRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	62,  // 170: google.storage.v1.GetProjectServiceAccountRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	62,  // 171: google.storage.v1.CreateHmacKeyRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	80,  // 172: google.storage.v1.CreateHmacKeyResponse.metadata:type_name -> google.storage.v1.HmacKeyMetadata
	62,  // 173: google.storage.v1.DeleteHmacKeyRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	62,  // 174: google.storage.v1.GetHmacKeyRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	62,  // 175: google.storage.v1.ListHmacKeysRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	80,  // 176: google.storage.v1.ListHmacKeysResponse.items:type_name -> google.storage.v1.HmacKeyMetadata
	80,  // 177: google.storage.v1.UpdateHmacKeyRequest.metadata:type_name -> google.storage.v1.HmacKeyMetadata
	62,  // 178: google.storage.v1.UpdateHmacKeyRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	81,  // 179: google.storage.v1.GetIamPolicyRequest.iam_request:type_name -> google.iam.v1.GetIamPolicyRequest
	62,  // 180: google.storage.v1.GetIamPolicyRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	82,  // 181: google.storage.v1.SetIamPolicyRequest.iam_request:type_name -> google.iam.v1.SetIamPolicyRequest
	62,  // 182: google.storage.v1.SetIamPolicyRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	83,  // 183: google.storage.v1.TestIamPermissionsRequest.iam_request:type_name -> google.iam.v1.TestIamPermissionsRequest
	62,  // 184: google.storage.v1.TestIamPermissionsRequest.common_request_params:type_name -> google.storage.v1.CommonRequestParams
	67,  // 185: google.storage.v1.CommonRequestParams.fields:type_name -> google.protobuf.FieldMask
	65,  // 186: google.storage.v1.ComposeObjectRequest.SourceObjects.object_preconditions:type_name -> google.storage.v1.ComposeObjectRequest.SourceObjects.ObjectPreconditions
	68,  // 187: google.storage.v1.ComposeObjectRequest.SourceObjects.ObjectPreconditions.if_generation_match:type_name -> google.protobuf.Int64Value
	1,   // 188: google.storage.v1.Storage.DeleteBucketAccessControl:input_type -> google.storage.v1.DeleteBucketAccessControlRequest
	2,   // 189: google.storage.v1.Storage.GetBucketAccessControl:input_type -> google.storage.v1.GetBucketAccessControlRequest
	3,   // 190: google.storage.v1.Storage.InsertBucketAccessControl:input_type -> google.storage.v1.InsertBucketAccessControlRequest
	4,   // 191: google.storage.v1.Storage.ListBucketAccessControls:input_type -> google.storage.v1.ListBucketAccessControlsRequest
	6,   // 192: google.storage.v1.Storage.UpdateBucketAccessControl:input_type -> google.storage.v1.UpdateBucketAccessControlRequest
	5,   // 193: google.storage.v1.Storage.PatchBucketAccessControl:input_type -> google.storage.v1.PatchBucketAccessControlRequest
	7,   // 194: google.storage.v1.Storage.DeleteBucket:input_type -> google.storage.v1.DeleteBucketRequest
	8,   // 195: google.storage.v1.Storage.GetBucket:input_type -> google.storage.v1.GetBucketRequest
	9,   // 196: google.storage.v1.Storage.InsertBucket:input_type -> google.storage.v1.InsertBucketRequest
	10,  // 197: google.storage.v1.Storage.ListChannels:input_type -> google.storage.v1.ListChannelsRequest
	11,  // 198: google.storage.v1.Storage.ListBuckets:input_type -> google.storage.v1.ListBucketsRequest
	12,  // 199: google.storage.v1.Storage.LockBucketRetentionPolicy:input_type -> google.storage.v1.LockRetentionPolicyRequest
	58,  // 200: google.storage.v1.Storage.GetBucketIamPolicy:input_type -> google.storage.v1.GetIamPolicyRequest
	59,  // 201: google.storage.v1.Storage.SetBucketIamPolicy:input_type -> google.storage.v1.SetIamPolicyRequest
	60,  // 202: google.storage.v1.Storage.TestBucketIamPermissions:input_type -> google.storage.v1.TestIamPermissionsRequest
	13,  // 203: google.storage.v1.Storage.PatchBucket:input_type -> google.storage.v1.PatchBucketRequest
	14,  // 204: google.storage.v1.Storage.UpdateBucket:input_type -> google.storage.v1.UpdateBucketRequest
	15,  // 205: google.storage.v1.Storage.StopChannel:input_type -> google.storage.v1.StopChannelRequest
	16,  // 206: google.storage.v1.Storage.DeleteDefaultObjectAccessControl:input_type -> google.storage.v1.DeleteDefaultObjectAccessControlRequest
	17,  // 207: google.storage.v1.Storage.GetDefaultObjectAccessControl:input_type -> google.storage.v1.GetDefaultObjectAccessControlRequest
	18,  // 208: google.storage.v1.Storage.InsertDefaultObjectAccessControl:input_type -> google.storage.v1.InsertDefaultObjectAccessControlRequest
	19,  // 209: google.storage.v1.Storage.ListDefaultObjectAccessControls:input_type -> google.storage.v1.ListDefaultObjectAccessControlsRequest
	20,  // 210: google.storage.v1.Storage.PatchDefaultObjectAccessControl:input_type -> google.storage.v1.PatchDefaultObjectAccessControlRequest
	21,  // 211: google.storage.v1.Storage.UpdateDefaultObjectAccessControl:input_type -> google.storage.v1.UpdateDefaultObjectAccessControlRequest
	22,  // 212: google.storage.v1.Storage.DeleteNotification:input_type -> google.storage.v1.DeleteNotificationRequest
	23,  // 213: google.storage.v1.Storage.GetNotification:input_type -> google.storage.v1.GetNotificationRequest
	24,  // 214: google.storage.v1.Storage.InsertNotification:input_type -> google.storage.v1.InsertNotificationRequest
	25,  // 215: google.storage.v1.Storage.ListNotifications:input_type -> google.storage.v1.ListNotificationsRequest
	26,  // 216: google.storage.v1.Storage.DeleteObjectAccessControl:input_type -> google.storage.v1.DeleteObjectAccessControlRequest
	27,  // 217: google.storage.v1.Storage.GetObjectAccessControl:input_type -> google.storage.v1.GetObjectAccessControlRequest
	28,  // 218: google.storage.v1.Storage.InsertObjectAccessControl:input_type -> google.storage.v1.InsertObjectAccessControlRequest
	29,  // 219: google.storage.v1.Storage.ListObjectAccessControls:input_type -> google.storage.v1.ListObjectAccessControlsRequest
	30,  // 220: google.storage.v1.Storage.PatchObjectAccessControl:input_type -> google.storage.v1.PatchObjectAccessControlRequest
	31,  // 221: google.storage.v1.Storage.UpdateObjectAccessControl:input_type -> google.storage.v1.UpdateObjectAccessControlRequest
	32,  // 222: google.storage.v1.Storage.ComposeObject:input_type -> google.storage.v1.ComposeObjectRequest
	33,  // 223: google.storage.v1.Storage.CopyObject:input_type -> google.storage.v1.CopyObjectRequest
	34,  // 224: google.storage.v1.Storage.DeleteObject:input_type -> google.storage.v1.DeleteObjectRequest
	36,  // 225: google.storage.v1.Storage.GetObject:input_type -> google.storage.v1.GetObjectRequest
	35,  // 226: google.storage.v1.Storage.GetObjectMedia:input_type -> google.storage.v1.GetObjectMediaRequest
	39,  // 227: google.storage.v1.Storage.InsertObject:input_type -> google.storage.v1.InsertObjectRequest
	40,  // 228: google.storage.v1.Storage.ListObjects:input_type -> google.storage.v1.ListObjectsRequest
	43,  // 229: google.storage.v1.Storage.RewriteObject:input_type -> google.storage.v1.RewriteObjectRequest
	45,  // 230: google.storage.v1.Storage.StartResumableWrite:input_type -> google.storage.v1.StartResumableWriteRequest
	41,  // 231: google.storage.v1.Storage.QueryWriteStatus:input_type -> google.storage.v1.QueryWriteStatusRequest
	47,  // 232: google.storage.v1.Storage.PatchObject:input_type -> google.storage.v1.PatchObjectRequest
	48,  // 233: google.storage.v1.Storage.UpdateObject:input_type -> google.storage.v1.UpdateObjectRequest
	58,  // 234: google.storage.v1.Storage.GetObjectIamPolicy:input_type -> google.storage.v1.GetIamPolicyRequest
	59,  // 235: google.storage.v1.Storage.SetObjectIamPolicy:input_type -> google.storage.v1.SetIamPolicyRequest
	60,  // 236: google.storage.v1.Storage.TestObjectIamPermissions:input_type -> google.storage.v1.TestIamPermissionsRequest
	49,  // 237: google.storage.v1.Storage.WatchAllObjects:input_type -> google.storage.v1.WatchAllObjectsRequest
	50,  // 238: google.storage.v1.Storage.GetServiceAccount:input_type -> google.storage.v1.GetProjectServiceAccountRequest
	51,  // 239: google.storage.v1.Storage.CreateHmacKey:input_type -> google.storage.v1.CreateHmacKeyRequest
	53,  // 240: google.storage.v1.Storage.DeleteHmacKey:input_type -> google.storage.v1.DeleteHmacKeyRequest
	54,  // 241: google.storage.v1.Storage.GetHmacKey:input_type -> google.storage.v1.GetHmacKeyRequest
	55,  // 242: google.storage.v1.Storage.ListHmacKeys:input_type -> google.storage.v1.ListHmacKeysRequest
	57,  // 243: google.storage.v1.Storage.UpdateHmacKey:input_type -> google.storage.v1.UpdateHmacKeyRequest
	84,  // 244: google.storage.v1.Storage.DeleteBucketAccessControl:output_type -> google.protobuf.Empty
	66,  // 245: google.storage.v1.Storage.GetBucketAccessControl:output_type -> google.storage.v1.BucketAccessControl
	66,  // 246: google.storage.v1.Storage.InsertBucketAccessControl:output_type -> google.storage.v1.BucketAccessControl
	85,  // 247: google.storage.v1.Storage.ListBucketAccessControls:output_type -> google.storage.v1.ListBucketAccessControlsResponse
	66,  // 248: google.storage.v1.Storage.UpdateBucketAccessControl:output_type -> google.storage.v1.BucketAccessControl
	66,  // 249: google.storage.v1.Storage.PatchBucketAccessControl:output_type -> google.storage.v1.BucketAccessControl
	84,  // 250: google.storage.v1.Storage.DeleteBucket:output_type -> google.protobuf.Empty
	72,  // 251: google.storage.v1.Storage.GetBucket:output_type -> google.storage.v1.Bucket
	72,  // 252: google.storage.v1.Storage.InsertBucket:output_type -> google.storage.v1.Bucket
	86,  // 253: google.storage.v1.Storage.ListChannels:output_type -> google.storage.v1.ListChannelsResponse
	87,  // 254: google.storage.v1.Storage.ListBuckets:output_type -> google.storage.v1.ListBucketsResponse
	72,  // 255: google.storage.v1.Storage.LockBucketRetentionPolicy:output_type -> google.storage.v1.Bucket
	88,  // 256: google.storage.v1.Storage.GetBucketIamPolicy:output_type -> google.iam.v1.Policy
	88,  // 257: google.storage.v1.Storage.SetBucketIamPolicy:output_type -> google.iam.v1.Policy
	89,  // 258: google.storage.v1.Storage.TestBucketIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	72,  // 259: google.storage.v1.Storage.PatchBucket:output_type -> google.storage.v1.Bucket
	72,  // 260: google.storage.v1.Storage.UpdateBucket:output_type -> google.storage.v1.Bucket
	84,  // 261: google.storage.v1.Storage.StopChannel:output_type -> google.protobuf.Empty
	84,  // 262: google.storage.v1.Storage.DeleteDefaultObjectAccessControl:output_type -> google.protobuf.Empty
	74,  // 263: google.storage.v1.Storage.GetDefaultObjectAccessControl:output_type -> google.storage.v1.ObjectAccessControl
	74,  // 264: google.storage.v1.Storage.InsertDefaultObjectAccessControl:output_type -> google.storage.v1.ObjectAccessControl
	90,  // 265: google.storage.v1.Storage.ListDefaultObjectAccessControls:output_type -> google.storage.v1.ListObjectAccessControlsResponse
	74,  // 266: google.storage.v1.Storage.PatchDefaultObjectAccessControl:output_type -> google.storage.v1.ObjectAccessControl
	74,  // 267: google.storage.v1.Storage.UpdateDefaultObjectAccessControl:output_type -> google.storage.v1.ObjectAccessControl
	84,  // 268: google.storage.v1.Storage.DeleteNotification:output_type -> google.protobuf.Empty
	75,  // 269: google.storage.v1.Storage.GetNotification:output_type -> google.storage.v1.Notification
	75,  // 270: google.storage.v1.Storage.InsertNotification:output_type -> google.storage.v1.Notification
	91,  // 271: google.storage.v1.Storage.ListNotifications:output_type -> google.storage.v1.ListNotificationsResponse
	84,  // 272: google.storage.v1.Storage.DeleteObjectAccessControl:output_type -> google.protobuf.Empty
	74,  // 273: google.storage.v1.Storage.GetObjectAccessControl:output_type -> google.storage.v1.ObjectAccessControl
	74,  // 274: google.storage.v1.Storage.InsertObjectAccessControl:output_type -> google.storage.v1.ObjectAccessControl
	90,  // 275: google.storage.v1.Storage.ListObjectAccessControls:output_type -> google.storage.v1.ListObjectAccessControlsResponse
	74,  // 276: google.storage.v1.Storage.PatchObjectAccessControl:output_type -> google.storage.v1.ObjectAccessControl
	74,  // 277: google.storage.v1.Storage.UpdateObjectAccessControl:output_type -> google.storage.v1.ObjectAccessControl
	76,  // 278: google.storage.v1.Storage.ComposeObject:output_type -> google.storage.v1.Object
	76,  // 279: google.storage.v1.Storage.CopyObject:output_type -> google.storage.v1.Object
	84,  // 280: google.storage.v1.Storage.DeleteObject:output_type -> google.protobuf.Empty
	76,  // 281: google.storage.v1.Storage.GetObject:output_type -> google.storage.v1.Object
	37,  // 282: google.storage.v1.Storage.GetObjectMedia:output_type -> google.storage.v1.GetObjectMediaResponse
	76,  // 283: google.storage.v1.Storage.InsertObject:output_type -> google.storage.v1.Object
	92,  // 284: google.storage.v1.Storage.ListObjects:output_type -> google.storage.v1.ListObjectsResponse
	44,  // 285: google.storage.v1.Storage.RewriteObject:output_type -> google.storage.v1.RewriteResponse
	46,  // 286: google.storage.v1.Storage.StartResumableWrite:output_type -> google.storage.v1.StartResumableWriteResponse
	42,  // 287: google.storage.v1.Storage.QueryWriteStatus:output_type -> google.storage.v1.QueryWriteStatusResponse
	76,  // 288: google.storage.v1.Storage.PatchObject:output_type -> google.storage.v1.Object
	76,  // 289: google.storage.v1.Storage.UpdateObject:output_type -> google.storage.v1.Object
	88,  // 290: google.storage.v1.Storage.GetObjectIamPolicy:output_type -> google.iam.v1.Policy
	88,  // 291: google.storage.v1.Storage.SetObjectIamPolicy:output_type -> google.iam.v1.Policy
	89,  // 292: google.storage.v1.Storage.TestObjectIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	73,  // 293: google.storage.v1.Storage.WatchAllObjects:output_type -> google.storage.v1.Channel
	93,  // 294: google.storage.v1.Storage.GetServiceAccount:output_type -> google.storage.v1.ServiceAccount
	52,  // 295: google.storage.v1.Storage.CreateHmacKey:output_type -> google.storage.v1.CreateHmacKeyResponse
	84,  // 296: google.storage.v1.Storage.DeleteHmacKey:output_type -> google.protobuf.Empty
	80,  // 297: google.storage.v1.Storage.GetHmacKey:output_type -> google.storage.v1.HmacKeyMetadata
	56,  // 298: google.storage.v1.Storage.ListHmacKeys:output_type -> google.storage.v1.ListHmacKeysResponse
	80,  // 299: google.storage.v1.Storage.UpdateHmacKey:output_type -> google.storage.v1.HmacKeyMetadata
	244, // [244:300] is the sub-list for method output_type
	188, // [188:244] is the sub-list for method input_type
	188, // [188:188] is the sub-list for extension type_name
	188, // [188:188] is the sub-list for extension extendee
	0,   // [0:188] is the sub-list for field type_name
}

func init() { file_google_storage_v1_storage_proto_init() }
func file_google_storage_v1_storage_proto_init() {
	if File_google_storage_v1_storage_proto != nil {
		return
	}
	file_google_storage_v1_storage_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_storage_v1_storage_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteBucketAccessControlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBucketAccessControlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InsertBucketAccessControlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBucketAccessControlsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchBucketAccessControlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateBucketAccessControlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteBucketRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBucketRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InsertBucketRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListChannelsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBucketsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LockRetentionPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchBucketRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateBucketRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StopChannelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDefaultObjectAccessControlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDefaultObjectAccessControlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InsertDefaultObjectAccessControlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDefaultObjectAccessControlsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchDefaultObjectAccessControlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDefaultObjectAccessControlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteNotificationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetNotificationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InsertNotificationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNotificationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteObjectAccessControlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetObjectAccessControlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InsertObjectAccessControlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListObjectAccessControlsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchObjectAccessControlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateObjectAccessControlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComposeObjectRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CopyObjectRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteObjectRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetObjectMediaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetObjectRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetObjectMediaResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InsertObjectSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InsertObjectRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListObjectsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryWriteStatusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryWriteStatusResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RewriteObjectRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RewriteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartResumableWriteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartResumableWriteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchObjectRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateObjectRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WatchAllObjectsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetProjectServiceAccountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateHmacKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateHmacKeyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteHmacKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetHmacKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListHmacKeysRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListHmacKeysResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateHmacKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetIamPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetIamPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestIamPermissionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommonObjectRequestParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommonRequestParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceConstants); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComposeObjectRequest_SourceObjects); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComposeObjectRequest_SourceObjects_ObjectPreconditions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_storage_v1_storage_proto_msgTypes[38].OneofWrappers = []interface{}{
		(*InsertObjectRequest_UploadId)(nil),
		(*InsertObjectRequest_InsertObjectSpec)(nil),
		(*InsertObjectRequest_ChecksummedData)(nil),
		(*InsertObjectRequest_Reference)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_storage_v1_storage_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   65,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_storage_v1_storage_proto_goTypes,
		DependencyIndexes: file_google_storage_v1_storage_proto_depIdxs,
		EnumInfos:         file_google_storage_v1_storage_proto_enumTypes,
		MessageInfos:      file_google_storage_v1_storage_proto_msgTypes,
	}.Build()
	File_google_storage_v1_storage_proto = out.File
	file_google_storage_v1_storage_proto_rawDesc = nil
	file_google_storage_v1_storage_proto_goTypes = nil
	file_google_storage_v1_storage_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// StorageClient is the client API for Storage service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type StorageClient interface {
	// Permanently deletes the ACL entry for the specified entity on the specified
	// bucket.
	DeleteBucketAccessControl(ctx context.Context, in *DeleteBucketAccessControlRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Returns the ACL entry for the specified entity on the specified bucket.
	GetBucketAccessControl(ctx context.Context, in *GetBucketAccessControlRequest, opts ...grpc.CallOption) (*BucketAccessControl, error)
	// Creates a new ACL entry on the specified bucket.
	InsertBucketAccessControl(ctx context.Context, in *InsertBucketAccessControlRequest, opts ...grpc.CallOption) (*BucketAccessControl, error)
	// Retrieves ACL entries on the specified bucket.
	ListBucketAccessControls(ctx context.Context, in *ListBucketAccessControlsRequest, opts ...grpc.CallOption) (*ListBucketAccessControlsResponse, error)
	// Updates an ACL entry on the specified bucket. Equivalent to
	// PatchBucketAccessControl, but all unspecified fields will be
	// reset to their default values.
	UpdateBucketAccessControl(ctx context.Context, in *UpdateBucketAccessControlRequest, opts ...grpc.CallOption) (*BucketAccessControl, error)
	// Updates an ACL entry on the specified bucket.
	PatchBucketAccessControl(ctx context.Context, in *PatchBucketAccessControlRequest, opts ...grpc.CallOption) (*BucketAccessControl, error)
	// Permanently deletes an empty bucket.
	DeleteBucket(ctx context.Context, in *DeleteBucketRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Returns metadata for the specified bucket.
	GetBucket(ctx context.Context, in *GetBucketRequest, opts ...grpc.CallOption) (*Bucket, error)
	// Creates a new bucket.
	InsertBucket(ctx context.Context, in *InsertBucketRequest, opts ...grpc.CallOption) (*Bucket, error)
	// List active object change notification channels for this bucket.
	ListChannels(ctx context.Context, in *ListChannelsRequest, opts ...grpc.CallOption) (*ListChannelsResponse, error)
	// Retrieves a list of buckets for a given project.
	ListBuckets(ctx context.Context, in *ListBucketsRequest, opts ...grpc.CallOption) (*ListBucketsResponse, error)
	// Locks retention policy on a bucket.
	LockBucketRetentionPolicy(ctx context.Context, in *LockRetentionPolicyRequest, opts ...grpc.CallOption) (*Bucket, error)
	// Gets the IAM policy for the specified bucket.
	GetBucketIamPolicy(ctx context.Context, in *GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Updates an IAM policy for the specified bucket.
	SetBucketIamPolicy(ctx context.Context, in *SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Tests a set of permissions on the given bucket to see which, if
	// any, are held by the caller.
	TestBucketIamPermissions(ctx context.Context, in *TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
	// Updates a bucket. Changes to the bucket will be readable immediately after
	// writing, but configuration changes may take time to propagate.
	PatchBucket(ctx context.Context, in *PatchBucketRequest, opts ...grpc.CallOption) (*Bucket, error)
	// Updates a bucket. Equivalent to PatchBucket, but always replaces all
	// mutatable fields of the bucket with new values, reverting all
	// unspecified fields to their default values.
	// Like PatchBucket, Changes to the bucket will be readable immediately after
	// writing, but configuration changes may take time to propagate.
	UpdateBucket(ctx context.Context, in *UpdateBucketRequest, opts ...grpc.CallOption) (*Bucket, error)
	// Halts "Object Change Notification" push messagages.
	// See https://cloud.google.com/storage/docs/object-change-notification
	// Note: this is not related to the newer "Notifications" resource, which
	// are stopped using DeleteNotification.
	StopChannel(ctx context.Context, in *StopChannelRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Permanently deletes the default object ACL entry for the specified entity
	// on the specified bucket.
	DeleteDefaultObjectAccessControl(ctx context.Context, in *DeleteDefaultObjectAccessControlRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Returns the default object ACL entry for the specified entity on the
	// specified bucket.
	GetDefaultObjectAccessControl(ctx context.Context, in *GetDefaultObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error)
	// Creates a new default object ACL entry on the specified bucket.
	InsertDefaultObjectAccessControl(ctx context.Context, in *InsertDefaultObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error)
	// Retrieves default object ACL entries on the specified bucket.
	ListDefaultObjectAccessControls(ctx context.Context, in *ListDefaultObjectAccessControlsRequest, opts ...grpc.CallOption) (*ListObjectAccessControlsResponse, error)
	// Updates a default object ACL entry on the specified bucket.
	PatchDefaultObjectAccessControl(ctx context.Context, in *PatchDefaultObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error)
	// Updates a default object ACL entry on the specified bucket. Equivalent to
	// PatchDefaultObjectAccessControl, but modifies all unspecified fields to
	// their default values.
	UpdateDefaultObjectAccessControl(ctx context.Context, in *UpdateDefaultObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error)
	// Permanently deletes a notification subscription.
	// Note: Older, "Object Change Notification" push subscriptions should be
	// deleted using StopChannel instead.
	DeleteNotification(ctx context.Context, in *DeleteNotificationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// View a notification configuration.
	GetNotification(ctx context.Context, in *GetNotificationRequest, opts ...grpc.CallOption) (*Notification, error)
	// Creates a notification subscription for a given bucket.
	// These notifications, when triggered, publish messages to the specified
	// Cloud Pub/Sub topics.
	// See https://cloud.google.com/storage/docs/pubsub-notifications.
	InsertNotification(ctx context.Context, in *InsertNotificationRequest, opts ...grpc.CallOption) (*Notification, error)
	// Retrieves a list of notification subscriptions for a given bucket.
	ListNotifications(ctx context.Context, in *ListNotificationsRequest, opts ...grpc.CallOption) (*ListNotificationsResponse, error)
	// Permanently deletes the ACL entry for the specified entity on the specified
	// object.
	DeleteObjectAccessControl(ctx context.Context, in *DeleteObjectAccessControlRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Returns the ACL entry for the specified entity on the specified object.
	GetObjectAccessControl(ctx context.Context, in *GetObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error)
	// Creates a new ACL entry on the specified object.
	InsertObjectAccessControl(ctx context.Context, in *InsertObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error)
	// Retrieves ACL entries on the specified object.
	ListObjectAccessControls(ctx context.Context, in *ListObjectAccessControlsRequest, opts ...grpc.CallOption) (*ListObjectAccessControlsResponse, error)
	// Patches an ACL entry on the specified object.  Patch is similar to update,
	// but only applies or appends the specified fields in the
	// object_access_control object.  Other fields are unaffected.
	PatchObjectAccessControl(ctx context.Context, in *PatchObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error)
	// Updates an ACL entry on the specified object.
	UpdateObjectAccessControl(ctx context.Context, in *UpdateObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error)
	// Concatenates a list of existing objects into a new object in the same
	// bucket.
	ComposeObject(ctx context.Context, in *ComposeObjectRequest, opts ...grpc.CallOption) (*Object, error)
	// Copies a source object to a destination object. Optionally overrides
	// metadata.
	CopyObject(ctx context.Context, in *CopyObjectRequest, opts ...grpc.CallOption) (*Object, error)
	// Deletes an object and its metadata. Deletions are permanent if versioning
	// is not enabled for the bucket, or if the `generation` parameter
	// is used.
	DeleteObject(ctx context.Context, in *DeleteObjectRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Retrieves an object's metadata.
	GetObject(ctx context.Context, in *GetObjectRequest, opts ...grpc.CallOption) (*Object, error)
	// Reads an object's data.
	GetObjectMedia(ctx context.Context, in *GetObjectMediaRequest, opts ...grpc.CallOption) (Storage_GetObjectMediaClient, error)
	// Stores a new object and metadata.
	//
	// An object can be written either in a single message stream or in a
	// resumable sequence of message streams. To write using a single stream,
	// the client should include in the first message of the stream an
	// `InsertObjectSpec` describing the destination bucket, object, and any
	// preconditions. Additionally, the final message must set 'finish_write' to
	// true, or else it is an error.
	//
	// For a resumable write, the client should instead call
	// `StartResumableWrite()` and provide that method an `InsertObjectSpec.`
	// They should then attach the returned `upload_id` to the first message of
	// each following call to `Insert`. If there is an error or the connection is
	// broken during the resumable `Insert()`, the client should check the status
	// of the `Insert()` by calling `QueryWriteStatus()` and continue writing from
	// the returned `committed_size`. This may be less than the amount of data the
	// client previously sent.
	//
	// The service will not view the object as complete until the client has
	// sent an `Insert` with `finish_write` set to `true`. Sending any
	// requests on a stream after sending a request with `finish_write` set to
	// `true` will cause an error. The client **should** check the
	// `Object` it receives to determine how much data the service was
	// able to commit and whether the service views the object as complete.
	InsertObject(ctx context.Context, opts ...grpc.CallOption) (Storage_InsertObjectClient, error)
	// Retrieves a list of objects matching the criteria.
	ListObjects(ctx context.Context, in *ListObjectsRequest, opts ...grpc.CallOption) (*ListObjectsResponse, error)
	// Rewrites a source object to a destination object. Optionally overrides
	// metadata.
	RewriteObject(ctx context.Context, in *RewriteObjectRequest, opts ...grpc.CallOption) (*RewriteResponse, error)
	// Starts a resumable write. How long the write operation remains valid, and
	// what happens when the write operation becomes invalid, are
	// service-dependent.
	StartResumableWrite(ctx context.Context, in *StartResumableWriteRequest, opts ...grpc.CallOption) (*StartResumableWriteResponse, error)
	// Determines the `committed_size` for an object that is being written, which
	// can then be used as the `write_offset` for the next `Write()` call.
	//
	// If the object does not exist (i.e., the object has been deleted, or the
	// first `Write()` has not yet reached the service), this method returns the
	// error `NOT_FOUND`.
	//
	// The client **may** call `QueryWriteStatus()` at any time to determine how
	// much data has been processed for this object. This is useful if the
	// client is buffering data and needs to know which data can be safely
	// evicted. For any sequence of `QueryWriteStatus()` calls for a given
	// object name, the sequence of returned `committed_size` values will be
	// non-decreasing.
	QueryWriteStatus(ctx context.Context, in *QueryWriteStatusRequest, opts ...grpc.CallOption) (*QueryWriteStatusResponse, error)
	// Updates an object's metadata.
	PatchObject(ctx context.Context, in *PatchObjectRequest, opts ...grpc.CallOption) (*Object, error)
	// Updates an object's metadata. Equivalent to PatchObject, but always
	// replaces all mutatable fields of the bucket with new values, reverting all
	// unspecified fields to their default values.
	UpdateObject(ctx context.Context, in *UpdateObjectRequest, opts ...grpc.CallOption) (*Object, error)
	// Gets the IAM policy for the specified object.
	GetObjectIamPolicy(ctx context.Context, in *GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Updates an IAM policy for the specified object.
	SetObjectIamPolicy(ctx context.Context, in *SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Tests a set of permissions on the given object to see which, if
	// any, are held by the caller.
	TestObjectIamPermissions(ctx context.Context, in *TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
	// Watch for changes on all objects in a bucket.
	WatchAllObjects(ctx context.Context, in *WatchAllObjectsRequest, opts ...grpc.CallOption) (*Channel, error)
	// Retrieves the name of a project's Google Cloud Storage service account.
	GetServiceAccount(ctx context.Context, in *GetProjectServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error)
	// Creates a new HMAC key for the given service account.
	CreateHmacKey(ctx context.Context, in *CreateHmacKeyRequest, opts ...grpc.CallOption) (*CreateHmacKeyResponse, error)
	// Deletes a given HMAC key.  Key must be in an INACTIVE state.
	DeleteHmacKey(ctx context.Context, in *DeleteHmacKeyRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Gets an existing HMAC key metadata for the given id.
	GetHmacKey(ctx context.Context, in *GetHmacKeyRequest, opts ...grpc.CallOption) (*HmacKeyMetadata, error)
	// Lists HMAC keys under a given project with the additional filters provided.
	ListHmacKeys(ctx context.Context, in *ListHmacKeysRequest, opts ...grpc.CallOption) (*ListHmacKeysResponse, error)
	// Updates a given HMAC key state between ACTIVE and INACTIVE.
	UpdateHmacKey(ctx context.Context, in *UpdateHmacKeyRequest, opts ...grpc.CallOption) (*HmacKeyMetadata, error)
}

type storageClient struct {
	cc grpc.ClientConnInterface
}

func NewStorageClient(cc grpc.ClientConnInterface) StorageClient {
	return &storageClient{cc}
}

func (c *storageClient) DeleteBucketAccessControl(ctx context.Context, in *DeleteBucketAccessControlRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/DeleteBucketAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetBucketAccessControl(ctx context.Context, in *GetBucketAccessControlRequest, opts ...grpc.CallOption) (*BucketAccessControl, error) {
	out := new(BucketAccessControl)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/GetBucketAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) InsertBucketAccessControl(ctx context.Context, in *InsertBucketAccessControlRequest, opts ...grpc.CallOption) (*BucketAccessControl, error) {
	out := new(BucketAccessControl)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/InsertBucketAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) ListBucketAccessControls(ctx context.Context, in *ListBucketAccessControlsRequest, opts ...grpc.CallOption) (*ListBucketAccessControlsResponse, error) {
	out := new(ListBucketAccessControlsResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/ListBucketAccessControls", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) UpdateBucketAccessControl(ctx context.Context, in *UpdateBucketAccessControlRequest, opts ...grpc.CallOption) (*BucketAccessControl, error) {
	out := new(BucketAccessControl)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/UpdateBucketAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) PatchBucketAccessControl(ctx context.Context, in *PatchBucketAccessControlRequest, opts ...grpc.CallOption) (*BucketAccessControl, error) {
	out := new(BucketAccessControl)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/PatchBucketAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) DeleteBucket(ctx context.Context, in *DeleteBucketRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/DeleteBucket", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetBucket(ctx context.Context, in *GetBucketRequest, opts ...grpc.CallOption) (*Bucket, error) {
	out := new(Bucket)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/GetBucket", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) InsertBucket(ctx context.Context, in *InsertBucketRequest, opts ...grpc.CallOption) (*Bucket, error) {
	out := new(Bucket)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/InsertBucket", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) ListChannels(ctx context.Context, in *ListChannelsRequest, opts ...grpc.CallOption) (*ListChannelsResponse, error) {
	out := new(ListChannelsResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/ListChannels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) ListBuckets(ctx context.Context, in *ListBucketsRequest, opts ...grpc.CallOption) (*ListBucketsResponse, error) {
	out := new(ListBucketsResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/ListBuckets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) LockBucketRetentionPolicy(ctx context.Context, in *LockRetentionPolicyRequest, opts ...grpc.CallOption) (*Bucket, error) {
	out := new(Bucket)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/LockBucketRetentionPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetBucketIamPolicy(ctx context.Context, in *GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/GetBucketIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) SetBucketIamPolicy(ctx context.Context, in *SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/SetBucketIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) TestBucketIamPermissions(ctx context.Context, in *TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/TestBucketIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) PatchBucket(ctx context.Context, in *PatchBucketRequest, opts ...grpc.CallOption) (*Bucket, error) {
	out := new(Bucket)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/PatchBucket", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) UpdateBucket(ctx context.Context, in *UpdateBucketRequest, opts ...grpc.CallOption) (*Bucket, error) {
	out := new(Bucket)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/UpdateBucket", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) StopChannel(ctx context.Context, in *StopChannelRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/StopChannel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) DeleteDefaultObjectAccessControl(ctx context.Context, in *DeleteDefaultObjectAccessControlRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/DeleteDefaultObjectAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetDefaultObjectAccessControl(ctx context.Context, in *GetDefaultObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error) {
	out := new(ObjectAccessControl)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/GetDefaultObjectAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) InsertDefaultObjectAccessControl(ctx context.Context, in *InsertDefaultObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error) {
	out := new(ObjectAccessControl)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/InsertDefaultObjectAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) ListDefaultObjectAccessControls(ctx context.Context, in *ListDefaultObjectAccessControlsRequest, opts ...grpc.CallOption) (*ListObjectAccessControlsResponse, error) {
	out := new(ListObjectAccessControlsResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/ListDefaultObjectAccessControls", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) PatchDefaultObjectAccessControl(ctx context.Context, in *PatchDefaultObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error) {
	out := new(ObjectAccessControl)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/PatchDefaultObjectAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) UpdateDefaultObjectAccessControl(ctx context.Context, in *UpdateDefaultObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error) {
	out := new(ObjectAccessControl)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/UpdateDefaultObjectAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) DeleteNotification(ctx context.Context, in *DeleteNotificationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/DeleteNotification", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetNotification(ctx context.Context, in *GetNotificationRequest, opts ...grpc.CallOption) (*Notification, error) {
	out := new(Notification)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/GetNotification", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) InsertNotification(ctx context.Context, in *InsertNotificationRequest, opts ...grpc.CallOption) (*Notification, error) {
	out := new(Notification)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/InsertNotification", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) ListNotifications(ctx context.Context, in *ListNotificationsRequest, opts ...grpc.CallOption) (*ListNotificationsResponse, error) {
	out := new(ListNotificationsResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/ListNotifications", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) DeleteObjectAccessControl(ctx context.Context, in *DeleteObjectAccessControlRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/DeleteObjectAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetObjectAccessControl(ctx context.Context, in *GetObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error) {
	out := new(ObjectAccessControl)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/GetObjectAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) InsertObjectAccessControl(ctx context.Context, in *InsertObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error) {
	out := new(ObjectAccessControl)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/InsertObjectAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) ListObjectAccessControls(ctx context.Context, in *ListObjectAccessControlsRequest, opts ...grpc.CallOption) (*ListObjectAccessControlsResponse, error) {
	out := new(ListObjectAccessControlsResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/ListObjectAccessControls", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) PatchObjectAccessControl(ctx context.Context, in *PatchObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error) {
	out := new(ObjectAccessControl)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/PatchObjectAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) UpdateObjectAccessControl(ctx context.Context, in *UpdateObjectAccessControlRequest, opts ...grpc.CallOption) (*ObjectAccessControl, error) {
	out := new(ObjectAccessControl)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/UpdateObjectAccessControl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) ComposeObject(ctx context.Context, in *ComposeObjectRequest, opts ...grpc.CallOption) (*Object, error) {
	out := new(Object)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/ComposeObject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) CopyObject(ctx context.Context, in *CopyObjectRequest, opts ...grpc.CallOption) (*Object, error) {
	out := new(Object)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/CopyObject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) DeleteObject(ctx context.Context, in *DeleteObjectRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/DeleteObject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetObject(ctx context.Context, in *GetObjectRequest, opts ...grpc.CallOption) (*Object, error) {
	out := new(Object)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/GetObject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetObjectMedia(ctx context.Context, in *GetObjectMediaRequest, opts ...grpc.CallOption) (Storage_GetObjectMediaClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Storage_serviceDesc.Streams[0], "/google.storage.v1.Storage/GetObjectMedia", opts...)
	if err != nil {
		return nil, err
	}
	x := &storageGetObjectMediaClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Storage_GetObjectMediaClient interface {
	Recv() (*GetObjectMediaResponse, error)
	grpc.ClientStream
}

type storageGetObjectMediaClient struct {
	grpc.ClientStream
}

func (x *storageGetObjectMediaClient) Recv() (*GetObjectMediaResponse, error) {
	m := new(GetObjectMediaResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *storageClient) InsertObject(ctx context.Context, opts ...grpc.CallOption) (Storage_InsertObjectClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Storage_serviceDesc.Streams[1], "/google.storage.v1.Storage/InsertObject", opts...)
	if err != nil {
		return nil, err
	}
	x := &storageInsertObjectClient{stream}
	return x, nil
}

type Storage_InsertObjectClient interface {
	Send(*InsertObjectRequest) error
	CloseAndRecv() (*Object, error)
	grpc.ClientStream
}

type storageInsertObjectClient struct {
	grpc.ClientStream
}

func (x *storageInsertObjectClient) Send(m *InsertObjectRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *storageInsertObjectClient) CloseAndRecv() (*Object, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(Object)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *storageClient) ListObjects(ctx context.Context, in *ListObjectsRequest, opts ...grpc.CallOption) (*ListObjectsResponse, error) {
	out := new(ListObjectsResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/ListObjects", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) RewriteObject(ctx context.Context, in *RewriteObjectRequest, opts ...grpc.CallOption) (*RewriteResponse, error) {
	out := new(RewriteResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/RewriteObject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) StartResumableWrite(ctx context.Context, in *StartResumableWriteRequest, opts ...grpc.CallOption) (*StartResumableWriteResponse, error) {
	out := new(StartResumableWriteResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/StartResumableWrite", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) QueryWriteStatus(ctx context.Context, in *QueryWriteStatusRequest, opts ...grpc.CallOption) (*QueryWriteStatusResponse, error) {
	out := new(QueryWriteStatusResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/QueryWriteStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) PatchObject(ctx context.Context, in *PatchObjectRequest, opts ...grpc.CallOption) (*Object, error) {
	out := new(Object)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/PatchObject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) UpdateObject(ctx context.Context, in *UpdateObjectRequest, opts ...grpc.CallOption) (*Object, error) {
	out := new(Object)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/UpdateObject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetObjectIamPolicy(ctx context.Context, in *GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/GetObjectIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) SetObjectIamPolicy(ctx context.Context, in *SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/SetObjectIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) TestObjectIamPermissions(ctx context.Context, in *TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/TestObjectIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) WatchAllObjects(ctx context.Context, in *WatchAllObjectsRequest, opts ...grpc.CallOption) (*Channel, error) {
	out := new(Channel)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/WatchAllObjects", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetServiceAccount(ctx context.Context, in *GetProjectServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error) {
	out := new(ServiceAccount)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/GetServiceAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) CreateHmacKey(ctx context.Context, in *CreateHmacKeyRequest, opts ...grpc.CallOption) (*CreateHmacKeyResponse, error) {
	out := new(CreateHmacKeyResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/CreateHmacKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) DeleteHmacKey(ctx context.Context, in *DeleteHmacKeyRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/DeleteHmacKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) GetHmacKey(ctx context.Context, in *GetHmacKeyRequest, opts ...grpc.CallOption) (*HmacKeyMetadata, error) {
	out := new(HmacKeyMetadata)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/GetHmacKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) ListHmacKeys(ctx context.Context, in *ListHmacKeysRequest, opts ...grpc.CallOption) (*ListHmacKeysResponse, error) {
	out := new(ListHmacKeysResponse)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/ListHmacKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) UpdateHmacKey(ctx context.Context, in *UpdateHmacKeyRequest, opts ...grpc.CallOption) (*HmacKeyMetadata, error) {
	out := new(HmacKeyMetadata)
	err := c.cc.Invoke(ctx, "/google.storage.v1.Storage/UpdateHmacKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// StorageServer is the server API for Storage service.
type StorageServer interface {
	// Permanently deletes the ACL entry for the specified entity on the specified
	// bucket.
	DeleteBucketAccessControl(context.Context, *DeleteBucketAccessControlRequest) (*empty.Empty, error)
	// Returns the ACL entry for the specified entity on the specified bucket.
	GetBucketAccessControl(context.Context, *GetBucketAccessControlRequest) (*BucketAccessControl, error)
	// Creates a new ACL entry on the specified bucket.
	InsertBucketAccessControl(context.Context, *InsertBucketAccessControlRequest) (*BucketAccessControl, error)
	// Retrieves ACL entries on the specified bucket.
	ListBucketAccessControls(context.Context, *ListBucketAccessControlsRequest) (*ListBucketAccessControlsResponse, error)
	// Updates an ACL entry on the specified bucket. Equivalent to
	// PatchBucketAccessControl, but all unspecified fields will be
	// reset to their default values.
	UpdateBucketAccessControl(context.Context, *UpdateBucketAccessControlRequest) (*BucketAccessControl, error)
	// Updates an ACL entry on the specified bucket.
	PatchBucketAccessControl(context.Context, *PatchBucketAccessControlRequest) (*BucketAccessControl, error)
	// Permanently deletes an empty bucket.
	DeleteBucket(context.Context, *DeleteBucketRequest) (*empty.Empty, error)
	// Returns metadata for the specified bucket.
	GetBucket(context.Context, *GetBucketRequest) (*Bucket, error)
	// Creates a new bucket.
	InsertBucket(context.Context, *InsertBucketRequest) (*Bucket, error)
	// List active object change notification channels for this bucket.
	ListChannels(context.Context, *ListChannelsRequest) (*ListChannelsResponse, error)
	// Retrieves a list of buckets for a given project.
	ListBuckets(context.Context, *ListBucketsRequest) (*ListBucketsResponse, error)
	// Locks retention policy on a bucket.
	LockBucketRetentionPolicy(context.Context, *LockRetentionPolicyRequest) (*Bucket, error)
	// Gets the IAM policy for the specified bucket.
	GetBucketIamPolicy(context.Context, *GetIamPolicyRequest) (*v1.Policy, error)
	// Updates an IAM policy for the specified bucket.
	SetBucketIamPolicy(context.Context, *SetIamPolicyRequest) (*v1.Policy, error)
	// Tests a set of permissions on the given bucket to see which, if
	// any, are held by the caller.
	TestBucketIamPermissions(context.Context, *TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
	// Updates a bucket. Changes to the bucket will be readable immediately after
	// writing, but configuration changes may take time to propagate.
	PatchBucket(context.Context, *PatchBucketRequest) (*Bucket, error)
	// Updates a bucket. Equivalent to PatchBucket, but always replaces all
	// mutatable fields of the bucket with new values, reverting all
	// unspecified fields to their default values.
	// Like PatchBucket, Changes to the bucket will be readable immediately after
	// writing, but configuration changes may take time to propagate.
	UpdateBucket(context.Context, *UpdateBucketRequest) (*Bucket, error)
	// Halts "Object Change Notification" push messagages.
	// See https://cloud.google.com/storage/docs/object-change-notification
	// Note: this is not related to the newer "Notifications" resource, which
	// are stopped using DeleteNotification.
	StopChannel(context.Context, *StopChannelRequest) (*empty.Empty, error)
	// Permanently deletes the default object ACL entry for the specified entity
	// on the specified bucket.
	DeleteDefaultObjectAccessControl(context.Context, *DeleteDefaultObjectAccessControlRequest) (*empty.Empty, error)
	// Returns the default object ACL entry for the specified entity on the
	// specified bucket.
	GetDefaultObjectAccessControl(context.Context, *GetDefaultObjectAccessControlRequest) (*ObjectAccessControl, error)
	// Creates a new default object ACL entry on the specified bucket.
	InsertDefaultObjectAccessControl(context.Context, *InsertDefaultObjectAccessControlRequest) (*ObjectAccessControl, error)
	// Retrieves default object ACL entries on the specified bucket.
	ListDefaultObjectAccessControls(context.Context, *ListDefaultObjectAccessControlsRequest) (*ListObjectAccessControlsResponse, error)
	// Updates a default object ACL entry on the specified bucket.
	PatchDefaultObjectAccessControl(context.Context, *PatchDefaultObjectAccessControlRequest) (*ObjectAccessControl, error)
	// Updates a default object ACL entry on the specified bucket. Equivalent to
	// PatchDefaultObjectAccessControl, but modifies all unspecified fields to
	// their default values.
	UpdateDefaultObjectAccessControl(context.Context, *UpdateDefaultObjectAccessControlRequest) (*ObjectAccessControl, error)
	// Permanently deletes a notification subscription.
	// Note: Older, "Object Change Notification" push subscriptions should be
	// deleted using StopChannel instead.
	DeleteNotification(context.Context, *DeleteNotificationRequest) (*empty.Empty, error)
	// View a notification configuration.
	GetNotification(context.Context, *GetNotificationRequest) (*Notification, error)
	// Creates a notification subscription for a given bucket.
	// These notifications, when triggered, publish messages to the specified
	// Cloud Pub/Sub topics.
	// See https://cloud.google.com/storage/docs/pubsub-notifications.
	InsertNotification(context.Context, *InsertNotificationRequest) (*Notification, error)
	// Retrieves a list of notification subscriptions for a given bucket.
	ListNotifications(context.Context, *ListNotificationsRequest) (*ListNotificationsResponse, error)
	// Permanently deletes the ACL entry for the specified entity on the specified
	// object.
	DeleteObjectAccessControl(context.Context, *DeleteObjectAccessControlRequest) (*empty.Empty, error)
	// Returns the ACL entry for the specified entity on the specified object.
	GetObjectAccessControl(context.Context, *GetObjectAccessControlRequest) (*ObjectAccessControl, error)
	// Creates a new ACL entry on the specified object.
	InsertObjectAccessControl(context.Context, *InsertObjectAccessControlRequest) (*ObjectAccessControl, error)
	// Retrieves ACL entries on the specified object.
	ListObjectAccessControls(context.Context, *ListObjectAccessControlsRequest) (*ListObjectAccessControlsResponse, error)
	// Patches an ACL entry on the specified object.  Patch is similar to update,
	// but only applies or appends the specified fields in the
	// object_access_control object.  Other fields are unaffected.
	PatchObjectAccessControl(context.Context, *PatchObjectAccessControlRequest) (*ObjectAccessControl, error)
	// Updates an ACL entry on the specified object.
	UpdateObjectAccessControl(context.Context, *UpdateObjectAccessControlRequest) (*ObjectAccessControl, error)
	// Concatenates a list of existing objects into a new object in the same
	// bucket.
	ComposeObject(context.Context, *ComposeObjectRequest) (*Object, error)
	// Copies a source object to a destination object. Optionally overrides
	// metadata.
	CopyObject(context.Context, *CopyObjectRequest) (*Object, error)
	// Deletes an object and its metadata. Deletions are permanent if versioning
	// is not enabled for the bucket, or if the `generation` parameter
	// is used.
	DeleteObject(context.Context, *DeleteObjectRequest) (*empty.Empty, error)
	// Retrieves an object's metadata.
	GetObject(context.Context, *GetObjectRequest) (*Object, error)
	// Reads an object's data.
	GetObjectMedia(*GetObjectMediaRequest, Storage_GetObjectMediaServer) error
	// Stores a new object and metadata.
	//
	// An object can be written either in a single message stream or in a
	// resumable sequence of message streams. To write using a single stream,
	// the client should include in the first message of the stream an
	// `InsertObjectSpec` describing the destination bucket, object, and any
	// preconditions. Additionally, the final message must set 'finish_write' to
	// true, or else it is an error.
	//
	// For a resumable write, the client should instead call
	// `StartResumableWrite()` and provide that method an `InsertObjectSpec.`
	// They should then attach the returned `upload_id` to the first message of
	// each following call to `Insert`. If there is an error or the connection is
	// broken during the resumable `Insert()`, the client should check the status
	// of the `Insert()` by calling `QueryWriteStatus()` and continue writing from
	// the returned `committed_size`. This may be less than the amount of data the
	// client previously sent.
	//
	// The service will not view the object as complete until the client has
	// sent an `Insert` with `finish_write` set to `true`. Sending any
	// requests on a stream after sending a request with `finish_write` set to
	// `true` will cause an error. The client **should** check the
	// `Object` it receives to determine how much data the service was
	// able to commit and whether the service views the object as complete.
	InsertObject(Storage_InsertObjectServer) error
	// Retrieves a list of objects matching the criteria.
	ListObjects(context.Context, *ListObjectsRequest) (*ListObjectsResponse, error)
	// Rewrites a source object to a destination object. Optionally overrides
	// metadata.
	RewriteObject(context.Context, *RewriteObjectRequest) (*RewriteResponse, error)
	// Starts a resumable write. How long the write operation remains valid, and
	// what happens when the write operation becomes invalid, are
	// service-dependent.
	StartResumableWrite(context.Context, *StartResumableWriteRequest) (*StartResumableWriteResponse, error)
	// Determines the `committed_size` for an object that is being written, which
	// can then be used as the `write_offset` for the next `Write()` call.
	//
	// If the object does not exist (i.e., the object has been deleted, or the
	// first `Write()` has not yet reached the service), this method returns the
	// error `NOT_FOUND`.
	//
	// The client **may** call `QueryWriteStatus()` at any time to determine how
	// much data has been processed for this object. This is useful if the
	// client is buffering data and needs to know which data can be safely
	// evicted. For any sequence of `QueryWriteStatus()` calls for a given
	// object name, the sequence of returned `committed_size` values will be
	// non-decreasing.
	QueryWriteStatus(context.Context, *QueryWriteStatusRequest) (*QueryWriteStatusResponse, error)
	// Updates an object's metadata.
	PatchObject(context.Context, *PatchObjectRequest) (*Object, error)
	// Updates an object's metadata. Equivalent to PatchObject, but always
	// replaces all mutatable fields of the bucket with new values, reverting all
	// unspecified fields to their default values.
	UpdateObject(context.Context, *UpdateObjectRequest) (*Object, error)
	// Gets the IAM policy for the specified object.
	GetObjectIamPolicy(context.Context, *GetIamPolicyRequest) (*v1.Policy, error)
	// Updates an IAM policy for the specified object.
	SetObjectIamPolicy(context.Context, *SetIamPolicyRequest) (*v1.Policy, error)
	// Tests a set of permissions on the given object to see which, if
	// any, are held by the caller.
	TestObjectIamPermissions(context.Context, *TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
	// Watch for changes on all objects in a bucket.
	WatchAllObjects(context.Context, *WatchAllObjectsRequest) (*Channel, error)
	// Retrieves the name of a project's Google Cloud Storage service account.
	GetServiceAccount(context.Context, *GetProjectServiceAccountRequest) (*ServiceAccount, error)
	// Creates a new HMAC key for the given service account.
	CreateHmacKey(context.Context, *CreateHmacKeyRequest) (*CreateHmacKeyResponse, error)
	// Deletes a given HMAC key.  Key must be in an INACTIVE state.
	DeleteHmacKey(context.Context, *DeleteHmacKeyRequest) (*empty.Empty, error)
	// Gets an existing HMAC key metadata for the given id.
	GetHmacKey(context.Context, *GetHmacKeyRequest) (*HmacKeyMetadata, error)
	// Lists HMAC keys under a given project with the additional filters provided.
	ListHmacKeys(context.Context, *ListHmacKeysRequest) (*ListHmacKeysResponse, error)
	// Updates a given HMAC key state between ACTIVE and INACTIVE.
	UpdateHmacKey(context.Context, *UpdateHmacKeyRequest) (*HmacKeyMetadata, error)
}

// UnimplementedStorageServer can be embedded to have forward compatible implementations.
type UnimplementedStorageServer struct {
}

func (*UnimplementedStorageServer) DeleteBucketAccessControl(context.Context, *DeleteBucketAccessControlRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBucketAccessControl not implemented")
}
func (*UnimplementedStorageServer) GetBucketAccessControl(context.Context, *GetBucketAccessControlRequest) (*BucketAccessControl, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBucketAccessControl not implemented")
}
func (*UnimplementedStorageServer) InsertBucketAccessControl(context.Context, *InsertBucketAccessControlRequest) (*BucketAccessControl, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InsertBucketAccessControl not implemented")
}
func (*UnimplementedStorageServer) ListBucketAccessControls(context.Context, *ListBucketAccessControlsRequest) (*ListBucketAccessControlsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBucketAccessControls not implemented")
}
func (*UnimplementedStorageServer) UpdateBucketAccessControl(context.Context, *UpdateBucketAccessControlRequest) (*BucketAccessControl, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBucketAccessControl not implemented")
}
func (*UnimplementedStorageServer) PatchBucketAccessControl(context.Context, *PatchBucketAccessControlRequest) (*BucketAccessControl, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PatchBucketAccessControl not implemented")
}
func (*UnimplementedStorageServer) DeleteBucket(context.Context, *DeleteBucketRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBucket not implemented")
}
func (*UnimplementedStorageServer) GetBucket(context.Context, *GetBucketRequest) (*Bucket, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBucket not implemented")
}
func (*UnimplementedStorageServer) InsertBucket(context.Context, *InsertBucketRequest) (*Bucket, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InsertBucket not implemented")
}
func (*UnimplementedStorageServer) ListChannels(context.Context, *ListChannelsRequest) (*ListChannelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListChannels not implemented")
}
func (*UnimplementedStorageServer) ListBuckets(context.Context, *ListBucketsRequest) (*ListBucketsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBuckets not implemented")
}
func (*UnimplementedStorageServer) LockBucketRetentionPolicy(context.Context, *LockRetentionPolicyRequest) (*Bucket, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LockBucketRetentionPolicy not implemented")
}
func (*UnimplementedStorageServer) GetBucketIamPolicy(context.Context, *GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBucketIamPolicy not implemented")
}
func (*UnimplementedStorageServer) SetBucketIamPolicy(context.Context, *SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetBucketIamPolicy not implemented")
}
func (*UnimplementedStorageServer) TestBucketIamPermissions(context.Context, *TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestBucketIamPermissions not implemented")
}
func (*UnimplementedStorageServer) PatchBucket(context.Context, *PatchBucketRequest) (*Bucket, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PatchBucket not implemented")
}
func (*UnimplementedStorageServer) UpdateBucket(context.Context, *UpdateBucketRequest) (*Bucket, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBucket not implemented")
}
func (*UnimplementedStorageServer) StopChannel(context.Context, *StopChannelRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopChannel not implemented")
}
func (*UnimplementedStorageServer) DeleteDefaultObjectAccessControl(context.Context, *DeleteDefaultObjectAccessControlRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDefaultObjectAccessControl not implemented")
}
func (*UnimplementedStorageServer) GetDefaultObjectAccessControl(context.Context, *GetDefaultObjectAccessControlRequest) (*ObjectAccessControl, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDefaultObjectAccessControl not implemented")
}
func (*UnimplementedStorageServer) InsertDefaultObjectAccessControl(context.Context, *InsertDefaultObjectAccessControlRequest) (*ObjectAccessControl, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InsertDefaultObjectAccessControl not implemented")
}
func (*UnimplementedStorageServer) ListDefaultObjectAccessControls(context.Context, *ListDefaultObjectAccessControlsRequest) (*ListObjectAccessControlsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDefaultObjectAccessControls not implemented")
}
func (*UnimplementedStorageServer) PatchDefaultObjectAccessControl(context.Context, *PatchDefaultObjectAccessControlRequest) (*ObjectAccessControl, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PatchDefaultObjectAccessControl not implemented")
}
func (*UnimplementedStorageServer) UpdateDefaultObjectAccessControl(context.Context, *UpdateDefaultObjectAccessControlRequest) (*ObjectAccessControl, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDefaultObjectAccessControl not implemented")
}
func (*UnimplementedStorageServer) DeleteNotification(context.Context, *DeleteNotificationRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNotification not implemented")
}
func (*UnimplementedStorageServer) GetNotification(context.Context, *GetNotificationRequest) (*Notification, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNotification not implemented")
}
func (*UnimplementedStorageServer) InsertNotification(context.Context, *InsertNotificationRequest) (*Notification, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InsertNotification not implemented")
}
func (*UnimplementedStorageServer) ListNotifications(context.Context, *ListNotificationsRequest) (*ListNotificationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNotifications not implemented")
}
func (*UnimplementedStorageServer) DeleteObjectAccessControl(context.Context, *DeleteObjectAccessControlRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteObjectAccessControl not implemented")
}
func (*UnimplementedStorageServer) GetObjectAccessControl(context.Context, *GetObjectAccessControlRequest) (*ObjectAccessControl, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetObjectAccessControl not implemented")
}
func (*UnimplementedStorageServer) InsertObjectAccessControl(context.Context, *InsertObjectAccessControlRequest) (*ObjectAccessControl, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InsertObjectAccessControl not implemented")
}
func (*UnimplementedStorageServer) ListObjectAccessControls(context.Context, *ListObjectAccessControlsRequest) (*ListObjectAccessControlsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListObjectAccessControls not implemented")
}
func (*UnimplementedStorageServer) PatchObjectAccessControl(context.Context, *PatchObjectAccessControlRequest) (*ObjectAccessControl, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PatchObjectAccessControl not implemented")
}
func (*UnimplementedStorageServer) UpdateObjectAccessControl(context.Context, *UpdateObjectAccessControlRequest) (*ObjectAccessControl, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateObjectAccessControl not implemented")
}
func (*UnimplementedStorageServer) ComposeObject(context.Context, *ComposeObjectRequest) (*Object, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ComposeObject not implemented")
}
func (*UnimplementedStorageServer) CopyObject(context.Context, *CopyObjectRequest) (*Object, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CopyObject not implemented")
}
func (*UnimplementedStorageServer) DeleteObject(context.Context, *DeleteObjectRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteObject not implemented")
}
func (*UnimplementedStorageServer) GetObject(context.Context, *GetObjectRequest) (*Object, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetObject not implemented")
}
func (*UnimplementedStorageServer) GetObjectMedia(*GetObjectMediaRequest, Storage_GetObjectMediaServer) error {
	return status.Errorf(codes.Unimplemented, "method GetObjectMedia not implemented")
}
func (*UnimplementedStorageServer) InsertObject(Storage_InsertObjectServer) error {
	return status.Errorf(codes.Unimplemented, "method InsertObject not implemented")
}
func (*UnimplementedStorageServer) ListObjects(context.Context, *ListObjectsRequest) (*ListObjectsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListObjects not implemented")
}
func (*UnimplementedStorageServer) RewriteObject(context.Context, *RewriteObjectRequest) (*RewriteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RewriteObject not implemented")
}
func (*UnimplementedStorageServer) StartResumableWrite(context.Context, *StartResumableWriteRequest) (*StartResumableWriteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartResumableWrite not implemented")
}
func (*UnimplementedStorageServer) QueryWriteStatus(context.Context, *QueryWriteStatusRequest) (*QueryWriteStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryWriteStatus not implemented")
}
func (*UnimplementedStorageServer) PatchObject(context.Context, *PatchObjectRequest) (*Object, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PatchObject not implemented")
}
func (*UnimplementedStorageServer) UpdateObject(context.Context, *UpdateObjectRequest) (*Object, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateObject not implemented")
}
func (*UnimplementedStorageServer) GetObjectIamPolicy(context.Context, *GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetObjectIamPolicy not implemented")
}
func (*UnimplementedStorageServer) SetObjectIamPolicy(context.Context, *SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetObjectIamPolicy not implemented")
}
func (*UnimplementedStorageServer) TestObjectIamPermissions(context.Context, *TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestObjectIamPermissions not implemented")
}
func (*UnimplementedStorageServer) WatchAllObjects(context.Context, *WatchAllObjectsRequest) (*Channel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WatchAllObjects not implemented")
}
func (*UnimplementedStorageServer) GetServiceAccount(context.Context, *GetProjectServiceAccountRequest) (*ServiceAccount, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServiceAccount not implemented")
}
func (*UnimplementedStorageServer) CreateHmacKey(context.Context, *CreateHmacKeyRequest) (*CreateHmacKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateHmacKey not implemented")
}
func (*UnimplementedStorageServer) DeleteHmacKey(context.Context, *DeleteHmacKeyRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteHmacKey not implemented")
}
func (*UnimplementedStorageServer) GetHmacKey(context.Context, *GetHmacKeyRequest) (*HmacKeyMetadata, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHmacKey not implemented")
}
func (*UnimplementedStorageServer) ListHmacKeys(context.Context, *ListHmacKeysRequest) (*ListHmacKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHmacKeys not implemented")
}
func (*UnimplementedStorageServer) UpdateHmacKey(context.Context, *UpdateHmacKeyRequest) (*HmacKeyMetadata, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateHmacKey not implemented")
}

func RegisterStorageServer(s *grpc.Server, srv StorageServer) {
	s.RegisterService(&_Storage_serviceDesc, srv)
}

func _Storage_DeleteBucketAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBucketAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).DeleteBucketAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/DeleteBucketAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).DeleteBucketAccessControl(ctx, req.(*DeleteBucketAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetBucketAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBucketAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).GetBucketAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/GetBucketAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).GetBucketAccessControl(ctx, req.(*GetBucketAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_InsertBucketAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertBucketAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).InsertBucketAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/InsertBucketAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).InsertBucketAccessControl(ctx, req.(*InsertBucketAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_ListBucketAccessControls_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBucketAccessControlsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).ListBucketAccessControls(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/ListBucketAccessControls",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).ListBucketAccessControls(ctx, req.(*ListBucketAccessControlsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_UpdateBucketAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBucketAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).UpdateBucketAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/UpdateBucketAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).UpdateBucketAccessControl(ctx, req.(*UpdateBucketAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_PatchBucketAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchBucketAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).PatchBucketAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/PatchBucketAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).PatchBucketAccessControl(ctx, req.(*PatchBucketAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_DeleteBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).DeleteBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/DeleteBucket",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).DeleteBucket(ctx, req.(*DeleteBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).GetBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/GetBucket",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).GetBucket(ctx, req.(*GetBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_InsertBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).InsertBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/InsertBucket",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).InsertBucket(ctx, req.(*InsertBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_ListChannels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListChannelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).ListChannels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/ListChannels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).ListChannels(ctx, req.(*ListChannelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_ListBuckets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBucketsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).ListBuckets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/ListBuckets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).ListBuckets(ctx, req.(*ListBucketsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_LockBucketRetentionPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LockRetentionPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).LockBucketRetentionPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/LockBucketRetentionPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).LockBucketRetentionPolicy(ctx, req.(*LockRetentionPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetBucketIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).GetBucketIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/GetBucketIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).GetBucketIamPolicy(ctx, req.(*GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_SetBucketIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).SetBucketIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/SetBucketIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).SetBucketIamPolicy(ctx, req.(*SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_TestBucketIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).TestBucketIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/TestBucketIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).TestBucketIamPermissions(ctx, req.(*TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_PatchBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).PatchBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/PatchBucket",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).PatchBucket(ctx, req.(*PatchBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_UpdateBucket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).UpdateBucket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/UpdateBucket",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).UpdateBucket(ctx, req.(*UpdateBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_StopChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).StopChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/StopChannel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).StopChannel(ctx, req.(*StopChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_DeleteDefaultObjectAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDefaultObjectAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).DeleteDefaultObjectAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/DeleteDefaultObjectAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).DeleteDefaultObjectAccessControl(ctx, req.(*DeleteDefaultObjectAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetDefaultObjectAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDefaultObjectAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).GetDefaultObjectAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/GetDefaultObjectAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).GetDefaultObjectAccessControl(ctx, req.(*GetDefaultObjectAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_InsertDefaultObjectAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertDefaultObjectAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).InsertDefaultObjectAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/InsertDefaultObjectAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).InsertDefaultObjectAccessControl(ctx, req.(*InsertDefaultObjectAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_ListDefaultObjectAccessControls_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDefaultObjectAccessControlsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).ListDefaultObjectAccessControls(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/ListDefaultObjectAccessControls",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).ListDefaultObjectAccessControls(ctx, req.(*ListDefaultObjectAccessControlsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_PatchDefaultObjectAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchDefaultObjectAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).PatchDefaultObjectAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/PatchDefaultObjectAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).PatchDefaultObjectAccessControl(ctx, req.(*PatchDefaultObjectAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_UpdateDefaultObjectAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDefaultObjectAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).UpdateDefaultObjectAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/UpdateDefaultObjectAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).UpdateDefaultObjectAccessControl(ctx, req.(*UpdateDefaultObjectAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_DeleteNotification_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNotificationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).DeleteNotification(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/DeleteNotification",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).DeleteNotification(ctx, req.(*DeleteNotificationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetNotification_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNotificationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).GetNotification(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/GetNotification",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).GetNotification(ctx, req.(*GetNotificationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_InsertNotification_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertNotificationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).InsertNotification(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/InsertNotification",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).InsertNotification(ctx, req.(*InsertNotificationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_ListNotifications_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNotificationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).ListNotifications(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/ListNotifications",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).ListNotifications(ctx, req.(*ListNotificationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_DeleteObjectAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteObjectAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).DeleteObjectAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/DeleteObjectAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).DeleteObjectAccessControl(ctx, req.(*DeleteObjectAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetObjectAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetObjectAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).GetObjectAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/GetObjectAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).GetObjectAccessControl(ctx, req.(*GetObjectAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_InsertObjectAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertObjectAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).InsertObjectAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/InsertObjectAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).InsertObjectAccessControl(ctx, req.(*InsertObjectAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_ListObjectAccessControls_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListObjectAccessControlsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).ListObjectAccessControls(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/ListObjectAccessControls",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).ListObjectAccessControls(ctx, req.(*ListObjectAccessControlsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_PatchObjectAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchObjectAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).PatchObjectAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/PatchObjectAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).PatchObjectAccessControl(ctx, req.(*PatchObjectAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_UpdateObjectAccessControl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateObjectAccessControlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).UpdateObjectAccessControl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/UpdateObjectAccessControl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).UpdateObjectAccessControl(ctx, req.(*UpdateObjectAccessControlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_ComposeObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ComposeObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).ComposeObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/ComposeObject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).ComposeObject(ctx, req.(*ComposeObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_CopyObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CopyObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).CopyObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/CopyObject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).CopyObject(ctx, req.(*CopyObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_DeleteObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).DeleteObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/DeleteObject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).DeleteObject(ctx, req.(*DeleteObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).GetObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/GetObject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).GetObject(ctx, req.(*GetObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetObjectMedia_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetObjectMediaRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(StorageServer).GetObjectMedia(m, &storageGetObjectMediaServer{stream})
}

type Storage_GetObjectMediaServer interface {
	Send(*GetObjectMediaResponse) error
	grpc.ServerStream
}

type storageGetObjectMediaServer struct {
	grpc.ServerStream
}

func (x *storageGetObjectMediaServer) Send(m *GetObjectMediaResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Storage_InsertObject_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(StorageServer).InsertObject(&storageInsertObjectServer{stream})
}

type Storage_InsertObjectServer interface {
	SendAndClose(*Object) error
	Recv() (*InsertObjectRequest, error)
	grpc.ServerStream
}

type storageInsertObjectServer struct {
	grpc.ServerStream
}

func (x *storageInsertObjectServer) SendAndClose(m *Object) error {
	return x.ServerStream.SendMsg(m)
}

func (x *storageInsertObjectServer) Recv() (*InsertObjectRequest, error) {
	m := new(InsertObjectRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Storage_ListObjects_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListObjectsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).ListObjects(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/ListObjects",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).ListObjects(ctx, req.(*ListObjectsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_RewriteObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RewriteObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).RewriteObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/RewriteObject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).RewriteObject(ctx, req.(*RewriteObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_StartResumableWrite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartResumableWriteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).StartResumableWrite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/StartResumableWrite",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).StartResumableWrite(ctx, req.(*StartResumableWriteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_QueryWriteStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryWriteStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).QueryWriteStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/QueryWriteStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).QueryWriteStatus(ctx, req.(*QueryWriteStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_PatchObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).PatchObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/PatchObject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).PatchObject(ctx, req.(*PatchObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_UpdateObject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateObjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).UpdateObject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/UpdateObject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).UpdateObject(ctx, req.(*UpdateObjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetObjectIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).GetObjectIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/GetObjectIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).GetObjectIamPolicy(ctx, req.(*GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_SetObjectIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).SetObjectIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/SetObjectIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).SetObjectIamPolicy(ctx, req.(*SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_TestObjectIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).TestObjectIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/TestObjectIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).TestObjectIamPermissions(ctx, req.(*TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_WatchAllObjects_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WatchAllObjectsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).WatchAllObjects(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/WatchAllObjects",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).WatchAllObjects(ctx, req.(*WatchAllObjectsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetServiceAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProjectServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).GetServiceAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/GetServiceAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).GetServiceAccount(ctx, req.(*GetProjectServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_CreateHmacKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateHmacKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).CreateHmacKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/CreateHmacKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).CreateHmacKey(ctx, req.(*CreateHmacKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_DeleteHmacKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteHmacKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).DeleteHmacKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/DeleteHmacKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).DeleteHmacKey(ctx, req.(*DeleteHmacKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_GetHmacKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetHmacKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).GetHmacKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/GetHmacKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).GetHmacKey(ctx, req.(*GetHmacKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_ListHmacKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListHmacKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).ListHmacKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/ListHmacKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).ListHmacKeys(ctx, req.(*ListHmacKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_UpdateHmacKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateHmacKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).UpdateHmacKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.storage.v1.Storage/UpdateHmacKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).UpdateHmacKey(ctx, req.(*UpdateHmacKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Storage_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.storage.v1.Storage",
	HandlerType: (*StorageServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DeleteBucketAccessControl",
			Handler:    _Storage_DeleteBucketAccessControl_Handler,
		},
		{
			MethodName: "GetBucketAccessControl",
			Handler:    _Storage_GetBucketAccessControl_Handler,
		},
		{
			MethodName: "InsertBucketAccessControl",
			Handler:    _Storage_InsertBucketAccessControl_Handler,
		},
		{
			MethodName: "ListBucketAccessControls",
			Handler:    _Storage_ListBucketAccessControls_Handler,
		},
		{
			MethodName: "UpdateBucketAccessControl",
			Handler:    _Storage_UpdateBucketAccessControl_Handler,
		},
		{
			MethodName: "PatchBucketAccessControl",
			Handler:    _Storage_PatchBucketAccessControl_Handler,
		},
		{
			MethodName: "DeleteBucket",
			Handler:    _Storage_DeleteBucket_Handler,
		},
		{
			MethodName: "GetBucket",
			Handler:    _Storage_GetBucket_Handler,
		},
		{
			MethodName: "InsertBucket",
			Handler:    _Storage_InsertBucket_Handler,
		},
		{
			MethodName: "ListChannels",
			Handler:    _Storage_ListChannels_Handler,
		},
		{
			MethodName: "ListBuckets",
			Handler:    _Storage_ListBuckets_Handler,
		},
		{
			MethodName: "LockBucketRetentionPolicy",
			Handler:    _Storage_LockBucketRetentionPolicy_Handler,
		},
		{
			MethodName: "GetBucketIamPolicy",
			Handler:    _Storage_GetBucketIamPolicy_Handler,
		},
		{
			MethodName: "SetBucketIamPolicy",
			Handler:    _Storage_SetBucketIamPolicy_Handler,
		},
		{
			MethodName: "TestBucketIamPermissions",
			Handler:    _Storage_TestBucketIamPermissions_Handler,
		},
		{
			MethodName: "PatchBucket",
			Handler:    _Storage_PatchBucket_Handler,
		},
		{
			MethodName: "UpdateBucket",
			Handler:    _Storage_UpdateBucket_Handler,
		},
		{
			MethodName: "StopChannel",
			Handler:    _Storage_StopChannel_Handler,
		},
		{
			MethodName: "DeleteDefaultObjectAccessControl",
			Handler:    _Storage_DeleteDefaultObjectAccessControl_Handler,
		},
		{
			MethodName: "GetDefaultObjectAccessControl",
			Handler:    _Storage_GetDefaultObjectAccessControl_Handler,
		},
		{
			MethodName: "InsertDefaultObjectAccessControl",
			Handler:    _Storage_InsertDefaultObjectAccessControl_Handler,
		},
		{
			MethodName: "ListDefaultObjectAccessControls",
			Handler:    _Storage_ListDefaultObjectAccessControls_Handler,
		},
		{
			MethodName: "PatchDefaultObjectAccessControl",
			Handler:    _Storage_PatchDefaultObjectAccessControl_Handler,
		},
		{
			MethodName: "UpdateDefaultObjectAccessControl",
			Handler:    _Storage_UpdateDefaultObjectAccessControl_Handler,
		},
		{
			MethodName: "DeleteNotification",
			Handler:    _Storage_DeleteNotification_Handler,
		},
		{
			MethodName: "GetNotification",
			Handler:    _Storage_GetNotification_Handler,
		},
		{
			MethodName: "InsertNotification",
			Handler:    _Storage_InsertNotification_Handler,
		},
		{
			MethodName: "ListNotifications",
			Handler:    _Storage_ListNotifications_Handler,
		},
		{
			MethodName: "DeleteObjectAccessControl",
			Handler:    _Storage_DeleteObjectAccessControl_Handler,
		},
		{
			MethodName: "GetObjectAccessControl",
			Handler:    _Storage_GetObjectAccessControl_Handler,
		},
		{
			MethodName: "InsertObjectAccessControl",
			Handler:    _Storage_InsertObjectAccessControl_Handler,
		},
		{
			MethodName: "ListObjectAccessControls",
			Handler:    _Storage_ListObjectAccessControls_Handler,
		},
		{
			MethodName: "PatchObjectAccessControl",
			Handler:    _Storage_PatchObjectAccessControl_Handler,
		},
		{
			MethodName: "UpdateObjectAccessControl",
			Handler:    _Storage_UpdateObjectAccessControl_Handler,
		},
		{
			MethodName: "ComposeObject",
			Handler:    _Storage_ComposeObject_Handler,
		},
		{
			MethodName: "CopyObject",
			Handler:    _Storage_CopyObject_Handler,
		},
		{
			MethodName: "DeleteObject",
			Handler:    _Storage_DeleteObject_Handler,
		},
		{
			MethodName: "GetObject",
			Handler:    _Storage_GetObject_Handler,
		},
		{
			MethodName: "ListObjects",
			Handler:    _Storage_ListObjects_Handler,
		},
		{
			MethodName: "RewriteObject",
			Handler:    _Storage_RewriteObject_Handler,
		},
		{
			MethodName: "StartResumableWrite",
			Handler:    _Storage_StartResumableWrite_Handler,
		},
		{
			MethodName: "QueryWriteStatus",
			Handler:    _Storage_QueryWriteStatus_Handler,
		},
		{
			MethodName: "PatchObject",
			Handler:    _Storage_PatchObject_Handler,
		},
		{
			MethodName: "UpdateObject",
			Handler:    _Storage_UpdateObject_Handler,
		},
		{
			MethodName: "GetObjectIamPolicy",
			Handler:    _Storage_GetObjectIamPolicy_Handler,
		},
		{
			MethodName: "SetObjectIamPolicy",
			Handler:    _Storage_SetObjectIamPolicy_Handler,
		},
		{
			MethodName: "TestObjectIamPermissions",
			Handler:    _Storage_TestObjectIamPermissions_Handler,
		},
		{
			MethodName: "WatchAllObjects",
			Handler:    _Storage_WatchAllObjects_Handler,
		},
		{
			MethodName: "GetServiceAccount",
			Handler:    _Storage_GetServiceAccount_Handler,
		},
		{
			MethodName: "CreateHmacKey",
			Handler:    _Storage_CreateHmacKey_Handler,
		},
		{
			MethodName: "DeleteHmacKey",
			Handler:    _Storage_DeleteHmacKey_Handler,
		},
		{
			MethodName: "GetHmacKey",
			Handler:    _Storage_GetHmacKey_Handler,
		},
		{
			MethodName: "ListHmacKeys",
			Handler:    _Storage_ListHmacKeys_Handler,
		},
		{
			MethodName: "UpdateHmacKey",
			Handler:    _Storage_UpdateHmacKey_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetObjectMedia",
			Handler:       _Storage_GetObjectMedia_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "InsertObject",
			Handler:       _Storage_InsertObject_Handler,
			ClientStreams: true,
		},
	},
	Metadata: "google/storage/v1/storage.proto",
}
