package datamigration

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/datamigration/mgmt/2018-07-15-preview/datamigration"

// AuthenticationType enumerates the values for authentication type.
type AuthenticationType string

const (
	// ActiveDirectoryIntegrated ...
	ActiveDirectoryIntegrated AuthenticationType = "ActiveDirectoryIntegrated"
	// ActiveDirectoryPassword ...
	ActiveDirectoryPassword AuthenticationType = "ActiveDirectoryPassword"
	// None ...
	None AuthenticationType = "None"
	// SQLAuthentication ...
	SQLAuthentication AuthenticationType = "SqlAuthentication"
	// WindowsAuthentication ...
	WindowsAuthentication AuthenticationType = "WindowsAuthentication"
)

// PossibleAuthenticationTypeValues returns an array of possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{ActiveDirectoryIntegrated, ActiveDirectoryPassword, None, SQLAuthentication, WindowsAuthentication}
}

// BackupFileStatus enumerates the values for backup file status.
type BackupFileStatus string

const (
	// Arrived ...
	Arrived BackupFileStatus = "Arrived"
	// Cancelled ...
	Cancelled BackupFileStatus = "Cancelled"
	// Queued ...
	Queued BackupFileStatus = "Queued"
	// Restored ...
	Restored BackupFileStatus = "Restored"
	// Restoring ...
	Restoring BackupFileStatus = "Restoring"
	// Uploaded ...
	Uploaded BackupFileStatus = "Uploaded"
	// Uploading ...
	Uploading BackupFileStatus = "Uploading"
)

// PossibleBackupFileStatusValues returns an array of possible values for the BackupFileStatus const type.
func PossibleBackupFileStatusValues() []BackupFileStatus {
	return []BackupFileStatus{Arrived, Cancelled, Queued, Restored, Restoring, Uploaded, Uploading}
}

// BackupMode enumerates the values for backup mode.
type BackupMode string

const (
	// CreateBackup ...
	CreateBackup BackupMode = "CreateBackup"
	// ExistingBackup ...
	ExistingBackup BackupMode = "ExistingBackup"
)

// PossibleBackupModeValues returns an array of possible values for the BackupMode const type.
func PossibleBackupModeValues() []BackupMode {
	return []BackupMode{CreateBackup, ExistingBackup}
}

// BackupType enumerates the values for backup type.
type BackupType string

const (
	// BackupTypeDatabase ...
	BackupTypeDatabase BackupType = "Database"
	// BackupTypeDifferentialDatabase ...
	BackupTypeDifferentialDatabase BackupType = "DifferentialDatabase"
	// BackupTypeDifferentialFile ...
	BackupTypeDifferentialFile BackupType = "DifferentialFile"
	// BackupTypeDifferentialPartial ...
	BackupTypeDifferentialPartial BackupType = "DifferentialPartial"
	// BackupTypeFile ...
	BackupTypeFile BackupType = "File"
	// BackupTypePartial ...
	BackupTypePartial BackupType = "Partial"
	// BackupTypeTransactionLog ...
	BackupTypeTransactionLog BackupType = "TransactionLog"
)

// PossibleBackupTypeValues returns an array of possible values for the BackupType const type.
func PossibleBackupTypeValues() []BackupType {
	return []BackupType{BackupTypeDatabase, BackupTypeDifferentialDatabase, BackupTypeDifferentialFile, BackupTypeDifferentialPartial, BackupTypeFile, BackupTypePartial, BackupTypeTransactionLog}
}

// CommandState enumerates the values for command state.
type CommandState string

const (
	// Accepted ...
	Accepted CommandState = "Accepted"
	// Failed ...
	Failed CommandState = "Failed"
	// Running ...
	Running CommandState = "Running"
	// Succeeded ...
	Succeeded CommandState = "Succeeded"
	// Unknown ...
	Unknown CommandState = "Unknown"
)

// PossibleCommandStateValues returns an array of possible values for the CommandState const type.
func PossibleCommandStateValues() []CommandState {
	return []CommandState{Accepted, Failed, Running, Succeeded, Unknown}
}

// CommandType enumerates the values for command type.
type CommandType string

const (
	// CommandTypeCancel ...
	CommandTypeCancel CommandType = "cancel"
	// CommandTypeCommandProperties ...
	CommandTypeCommandProperties CommandType = "CommandProperties"
	// CommandTypeFinish ...
	CommandTypeFinish CommandType = "finish"
	// CommandTypeMigrateSQLServerAzureDbSQLMiComplete ...
	CommandTypeMigrateSQLServerAzureDbSQLMiComplete CommandType = "Migrate.SqlServer.AzureDbSqlMi.Complete"
	// CommandTypeMigrateSyncCompleteDatabase ...
	CommandTypeMigrateSyncCompleteDatabase CommandType = "Migrate.Sync.Complete.Database"
	// CommandTypeRestart ...
	CommandTypeRestart CommandType = "restart"
)

// PossibleCommandTypeValues returns an array of possible values for the CommandType const type.
func PossibleCommandTypeValues() []CommandType {
	return []CommandType{CommandTypeCancel, CommandTypeCommandProperties, CommandTypeFinish, CommandTypeMigrateSQLServerAzureDbSQLMiComplete, CommandTypeMigrateSyncCompleteDatabase, CommandTypeRestart}
}

// DatabaseCompatLevel enumerates the values for database compat level.
type DatabaseCompatLevel string

const (
	// CompatLevel100 ...
	CompatLevel100 DatabaseCompatLevel = "CompatLevel100"
	// CompatLevel110 ...
	CompatLevel110 DatabaseCompatLevel = "CompatLevel110"
	// CompatLevel120 ...
	CompatLevel120 DatabaseCompatLevel = "CompatLevel120"
	// CompatLevel130 ...
	CompatLevel130 DatabaseCompatLevel = "CompatLevel130"
	// CompatLevel140 ...
	CompatLevel140 DatabaseCompatLevel = "CompatLevel140"
	// CompatLevel80 ...
	CompatLevel80 DatabaseCompatLevel = "CompatLevel80"
	// CompatLevel90 ...
	CompatLevel90 DatabaseCompatLevel = "CompatLevel90"
)

// PossibleDatabaseCompatLevelValues returns an array of possible values for the DatabaseCompatLevel const type.
func PossibleDatabaseCompatLevelValues() []DatabaseCompatLevel {
	return []DatabaseCompatLevel{CompatLevel100, CompatLevel110, CompatLevel120, CompatLevel130, CompatLevel140, CompatLevel80, CompatLevel90}
}

// DatabaseFileType enumerates the values for database file type.
type DatabaseFileType string

const (
	// Filestream ...
	Filestream DatabaseFileType = "Filestream"
	// Fulltext ...
	Fulltext DatabaseFileType = "Fulltext"
	// Log ...
	Log DatabaseFileType = "Log"
	// NotSupported ...
	NotSupported DatabaseFileType = "NotSupported"
	// Rows ...
	Rows DatabaseFileType = "Rows"
)

// PossibleDatabaseFileTypeValues returns an array of possible values for the DatabaseFileType const type.
func PossibleDatabaseFileTypeValues() []DatabaseFileType {
	return []DatabaseFileType{Filestream, Fulltext, Log, NotSupported, Rows}
}

// DatabaseMigrationStage enumerates the values for database migration stage.
type DatabaseMigrationStage string

const (
	// DatabaseMigrationStageBackup ...
	DatabaseMigrationStageBackup DatabaseMigrationStage = "Backup"
	// DatabaseMigrationStageCompleted ...
	DatabaseMigrationStageCompleted DatabaseMigrationStage = "Completed"
	// DatabaseMigrationStageFileCopy ...
	DatabaseMigrationStageFileCopy DatabaseMigrationStage = "FileCopy"
	// DatabaseMigrationStageInitialize ...
	DatabaseMigrationStageInitialize DatabaseMigrationStage = "Initialize"
	// DatabaseMigrationStageNone ...
	DatabaseMigrationStageNone DatabaseMigrationStage = "None"
	// DatabaseMigrationStageRestore ...
	DatabaseMigrationStageRestore DatabaseMigrationStage = "Restore"
)

// PossibleDatabaseMigrationStageValues returns an array of possible values for the DatabaseMigrationStage const type.
func PossibleDatabaseMigrationStageValues() []DatabaseMigrationStage {
	return []DatabaseMigrationStage{DatabaseMigrationStageBackup, DatabaseMigrationStageCompleted, DatabaseMigrationStageFileCopy, DatabaseMigrationStageInitialize, DatabaseMigrationStageNone, DatabaseMigrationStageRestore}
}

// DatabaseMigrationState enumerates the values for database migration state.
type DatabaseMigrationState string

const (
	// CANCELLED ...
	CANCELLED DatabaseMigrationState = "CANCELLED"
	// COMPLETED ...
	COMPLETED DatabaseMigrationState = "COMPLETED"
	// CUTOVERSTART ...
	CUTOVERSTART DatabaseMigrationState = "CUTOVER_START"
	// FAILED ...
	FAILED DatabaseMigrationState = "FAILED"
	// FULLBACKUPUPLOADSTART ...
	FULLBACKUPUPLOADSTART DatabaseMigrationState = "FULL_BACKUP_UPLOAD_START"
	// INITIAL ...
	INITIAL DatabaseMigrationState = "INITIAL"
	// LOGSHIPPINGSTART ...
	LOGSHIPPINGSTART DatabaseMigrationState = "LOG_SHIPPING_START"
	// POSTCUTOVERCOMPLETE ...
	POSTCUTOVERCOMPLETE DatabaseMigrationState = "POST_CUTOVER_COMPLETE"
	// UNDEFINED ...
	UNDEFINED DatabaseMigrationState = "UNDEFINED"
	// UPLOADLOGFILESSTART ...
	UPLOADLOGFILESSTART DatabaseMigrationState = "UPLOAD_LOG_FILES_START"
)

// PossibleDatabaseMigrationStateValues returns an array of possible values for the DatabaseMigrationState const type.
func PossibleDatabaseMigrationStateValues() []DatabaseMigrationState {
	return []DatabaseMigrationState{CANCELLED, COMPLETED, CUTOVERSTART, FAILED, FULLBACKUPUPLOADSTART, INITIAL, LOGSHIPPINGSTART, POSTCUTOVERCOMPLETE, UNDEFINED, UPLOADLOGFILESSTART}
}

// DatabaseState enumerates the values for database state.
type DatabaseState string

const (
	// DatabaseStateCopying ...
	DatabaseStateCopying DatabaseState = "Copying"
	// DatabaseStateEmergency ...
	DatabaseStateEmergency DatabaseState = "Emergency"
	// DatabaseStateOffline ...
	DatabaseStateOffline DatabaseState = "Offline"
	// DatabaseStateOfflineSecondary ...
	DatabaseStateOfflineSecondary DatabaseState = "OfflineSecondary"
	// DatabaseStateOnline ...
	DatabaseStateOnline DatabaseState = "Online"
	// DatabaseStateRecovering ...
	DatabaseStateRecovering DatabaseState = "Recovering"
	// DatabaseStateRecoveryPending ...
	DatabaseStateRecoveryPending DatabaseState = "RecoveryPending"
	// DatabaseStateRestoring ...
	DatabaseStateRestoring DatabaseState = "Restoring"
	// DatabaseStateSuspect ...
	DatabaseStateSuspect DatabaseState = "Suspect"
)

// PossibleDatabaseStateValues returns an array of possible values for the DatabaseState const type.
func PossibleDatabaseStateValues() []DatabaseState {
	return []DatabaseState{DatabaseStateCopying, DatabaseStateEmergency, DatabaseStateOffline, DatabaseStateOfflineSecondary, DatabaseStateOnline, DatabaseStateRecovering, DatabaseStateRecoveryPending, DatabaseStateRestoring, DatabaseStateSuspect}
}

// ErrorType enumerates the values for error type.
type ErrorType string

const (
	// ErrorTypeDefault ...
	ErrorTypeDefault ErrorType = "Default"
	// ErrorTypeError ...
	ErrorTypeError ErrorType = "Error"
	// ErrorTypeWarning ...
	ErrorTypeWarning ErrorType = "Warning"
)

// PossibleErrorTypeValues returns an array of possible values for the ErrorType const type.
func PossibleErrorTypeValues() []ErrorType {
	return []ErrorType{ErrorTypeDefault, ErrorTypeError, ErrorTypeWarning}
}

// LoginMigrationStage enumerates the values for login migration stage.
type LoginMigrationStage string

const (
	// LoginMigrationStageAssignRoleMembership ...
	LoginMigrationStageAssignRoleMembership LoginMigrationStage = "AssignRoleMembership"
	// LoginMigrationStageAssignRoleOwnership ...
	LoginMigrationStageAssignRoleOwnership LoginMigrationStage = "AssignRoleOwnership"
	// LoginMigrationStageCompleted ...
	LoginMigrationStageCompleted LoginMigrationStage = "Completed"
	// LoginMigrationStageEstablishObjectPermissions ...
	LoginMigrationStageEstablishObjectPermissions LoginMigrationStage = "EstablishObjectPermissions"
	// LoginMigrationStageEstablishServerPermissions ...
	LoginMigrationStageEstablishServerPermissions LoginMigrationStage = "EstablishServerPermissions"
	// LoginMigrationStageEstablishUserMapping ...
	LoginMigrationStageEstablishUserMapping LoginMigrationStage = "EstablishUserMapping"
	// LoginMigrationStageInitialize ...
	LoginMigrationStageInitialize LoginMigrationStage = "Initialize"
	// LoginMigrationStageLoginMigration ...
	LoginMigrationStageLoginMigration LoginMigrationStage = "LoginMigration"
	// LoginMigrationStageNone ...
	LoginMigrationStageNone LoginMigrationStage = "None"
)

// PossibleLoginMigrationStageValues returns an array of possible values for the LoginMigrationStage const type.
func PossibleLoginMigrationStageValues() []LoginMigrationStage {
	return []LoginMigrationStage{LoginMigrationStageAssignRoleMembership, LoginMigrationStageAssignRoleOwnership, LoginMigrationStageCompleted, LoginMigrationStageEstablishObjectPermissions, LoginMigrationStageEstablishServerPermissions, LoginMigrationStageEstablishUserMapping, LoginMigrationStageInitialize, LoginMigrationStageLoginMigration, LoginMigrationStageNone}
}

// LoginType enumerates the values for login type.
type LoginType string

const (
	// AsymmetricKey ...
	AsymmetricKey LoginType = "AsymmetricKey"
	// Certificate ...
	Certificate LoginType = "Certificate"
	// ExternalGroup ...
	ExternalGroup LoginType = "ExternalGroup"
	// ExternalUser ...
	ExternalUser LoginType = "ExternalUser"
	// SQLLogin ...
	SQLLogin LoginType = "SqlLogin"
	// WindowsGroup ...
	WindowsGroup LoginType = "WindowsGroup"
	// WindowsUser ...
	WindowsUser LoginType = "WindowsUser"
)

// PossibleLoginTypeValues returns an array of possible values for the LoginType const type.
func PossibleLoginTypeValues() []LoginType {
	return []LoginType{AsymmetricKey, Certificate, ExternalGroup, ExternalUser, SQLLogin, WindowsGroup, WindowsUser}
}

// MigrationState enumerates the values for migration state.
type MigrationState string

const (
	// MigrationStateCompleted ...
	MigrationStateCompleted MigrationState = "Completed"
	// MigrationStateFailed ...
	MigrationStateFailed MigrationState = "Failed"
	// MigrationStateInProgress ...
	MigrationStateInProgress MigrationState = "InProgress"
	// MigrationStateNone ...
	MigrationStateNone MigrationState = "None"
	// MigrationStateSkipped ...
	MigrationStateSkipped MigrationState = "Skipped"
	// MigrationStateStopped ...
	MigrationStateStopped MigrationState = "Stopped"
	// MigrationStateWarning ...
	MigrationStateWarning MigrationState = "Warning"
)

// PossibleMigrationStateValues returns an array of possible values for the MigrationState const type.
func PossibleMigrationStateValues() []MigrationState {
	return []MigrationState{MigrationStateCompleted, MigrationStateFailed, MigrationStateInProgress, MigrationStateNone, MigrationStateSkipped, MigrationStateStopped, MigrationStateWarning}
}

// MigrationStatus enumerates the values for migration status.
type MigrationStatus string

const (
	// MigrationStatusCompleted ...
	MigrationStatusCompleted MigrationStatus = "Completed"
	// MigrationStatusCompletedWithWarnings ...
	MigrationStatusCompletedWithWarnings MigrationStatus = "CompletedWithWarnings"
	// MigrationStatusConfigured ...
	MigrationStatusConfigured MigrationStatus = "Configured"
	// MigrationStatusConnecting ...
	MigrationStatusConnecting MigrationStatus = "Connecting"
	// MigrationStatusDefault ...
	MigrationStatusDefault MigrationStatus = "Default"
	// MigrationStatusError ...
	MigrationStatusError MigrationStatus = "Error"
	// MigrationStatusRunning ...
	MigrationStatusRunning MigrationStatus = "Running"
	// MigrationStatusSelectLogins ...
	MigrationStatusSelectLogins MigrationStatus = "SelectLogins"
	// MigrationStatusSourceAndTargetSelected ...
	MigrationStatusSourceAndTargetSelected MigrationStatus = "SourceAndTargetSelected"
	// MigrationStatusStopped ...
	MigrationStatusStopped MigrationStatus = "Stopped"
)

// PossibleMigrationStatusValues returns an array of possible values for the MigrationStatus const type.
func PossibleMigrationStatusValues() []MigrationStatus {
	return []MigrationStatus{MigrationStatusCompleted, MigrationStatusCompletedWithWarnings, MigrationStatusConfigured, MigrationStatusConnecting, MigrationStatusDefault, MigrationStatusError, MigrationStatusRunning, MigrationStatusSelectLogins, MigrationStatusSourceAndTargetSelected, MigrationStatusStopped}
}

// MongoDbClusterType enumerates the values for mongo db cluster type.
type MongoDbClusterType string

const (
	// BlobContainer ...
	BlobContainer MongoDbClusterType = "BlobContainer"
	// CosmosDb ...
	CosmosDb MongoDbClusterType = "CosmosDb"
	// MongoDb ...
	MongoDb MongoDbClusterType = "MongoDb"
)

// PossibleMongoDbClusterTypeValues returns an array of possible values for the MongoDbClusterType const type.
func PossibleMongoDbClusterTypeValues() []MongoDbClusterType {
	return []MongoDbClusterType{BlobContainer, CosmosDb, MongoDb}
}

// MongoDbErrorType enumerates the values for mongo db error type.
type MongoDbErrorType string

const (
	// MongoDbErrorTypeError ...
	MongoDbErrorTypeError MongoDbErrorType = "Error"
	// MongoDbErrorTypeValidationError ...
	MongoDbErrorTypeValidationError MongoDbErrorType = "ValidationError"
	// MongoDbErrorTypeWarning ...
	MongoDbErrorTypeWarning MongoDbErrorType = "Warning"
)

// PossibleMongoDbErrorTypeValues returns an array of possible values for the MongoDbErrorType const type.
func PossibleMongoDbErrorTypeValues() []MongoDbErrorType {
	return []MongoDbErrorType{MongoDbErrorTypeError, MongoDbErrorTypeValidationError, MongoDbErrorTypeWarning}
}

// MongoDbMigrationState enumerates the values for mongo db migration state.
type MongoDbMigrationState string

const (
	// MongoDbMigrationStateCanceled ...
	MongoDbMigrationStateCanceled MongoDbMigrationState = "Canceled"
	// MongoDbMigrationStateComplete ...
	MongoDbMigrationStateComplete MongoDbMigrationState = "Complete"
	// MongoDbMigrationStateCopying ...
	MongoDbMigrationStateCopying MongoDbMigrationState = "Copying"
	// MongoDbMigrationStateFailed ...
	MongoDbMigrationStateFailed MongoDbMigrationState = "Failed"
	// MongoDbMigrationStateFinalizing ...
	MongoDbMigrationStateFinalizing MongoDbMigrationState = "Finalizing"
	// MongoDbMigrationStateInitializing ...
	MongoDbMigrationStateInitializing MongoDbMigrationState = "Initializing"
	// MongoDbMigrationStateInitialReplay ...
	MongoDbMigrationStateInitialReplay MongoDbMigrationState = "InitialReplay"
	// MongoDbMigrationStateNotStarted ...
	MongoDbMigrationStateNotStarted MongoDbMigrationState = "NotStarted"
	// MongoDbMigrationStateReplaying ...
	MongoDbMigrationStateReplaying MongoDbMigrationState = "Replaying"
	// MongoDbMigrationStateRestarting ...
	MongoDbMigrationStateRestarting MongoDbMigrationState = "Restarting"
	// MongoDbMigrationStateValidatingInput ...
	MongoDbMigrationStateValidatingInput MongoDbMigrationState = "ValidatingInput"
)

// PossibleMongoDbMigrationStateValues returns an array of possible values for the MongoDbMigrationState const type.
func PossibleMongoDbMigrationStateValues() []MongoDbMigrationState {
	return []MongoDbMigrationState{MongoDbMigrationStateCanceled, MongoDbMigrationStateComplete, MongoDbMigrationStateCopying, MongoDbMigrationStateFailed, MongoDbMigrationStateFinalizing, MongoDbMigrationStateInitializing, MongoDbMigrationStateInitialReplay, MongoDbMigrationStateNotStarted, MongoDbMigrationStateReplaying, MongoDbMigrationStateRestarting, MongoDbMigrationStateValidatingInput}
}

// MongoDbReplication enumerates the values for mongo db replication.
type MongoDbReplication string

const (
	// Continuous ...
	Continuous MongoDbReplication = "Continuous"
	// Disabled ...
	Disabled MongoDbReplication = "Disabled"
	// OneTime ...
	OneTime MongoDbReplication = "OneTime"
)

// PossibleMongoDbReplicationValues returns an array of possible values for the MongoDbReplication const type.
func PossibleMongoDbReplicationValues() []MongoDbReplication {
	return []MongoDbReplication{Continuous, Disabled, OneTime}
}

// MongoDbShardKeyOrder enumerates the values for mongo db shard key order.
type MongoDbShardKeyOrder string

const (
	// Forward ...
	Forward MongoDbShardKeyOrder = "Forward"
	// Hashed ...
	Hashed MongoDbShardKeyOrder = "Hashed"
	// Reverse ...
	Reverse MongoDbShardKeyOrder = "Reverse"
)

// PossibleMongoDbShardKeyOrderValues returns an array of possible values for the MongoDbShardKeyOrder const type.
func PossibleMongoDbShardKeyOrderValues() []MongoDbShardKeyOrder {
	return []MongoDbShardKeyOrder{Forward, Hashed, Reverse}
}

// MySQLTargetPlatformType enumerates the values for my sql target platform type.
type MySQLTargetPlatformType string

const (
	// AzureDbForMySQL ...
	AzureDbForMySQL MySQLTargetPlatformType = "AzureDbForMySQL"
	// SQLServer ...
	SQLServer MySQLTargetPlatformType = "SqlServer"
)

// PossibleMySQLTargetPlatformTypeValues returns an array of possible values for the MySQLTargetPlatformType const type.
func PossibleMySQLTargetPlatformTypeValues() []MySQLTargetPlatformType {
	return []MySQLTargetPlatformType{AzureDbForMySQL, SQLServer}
}

// NameCheckFailureReason enumerates the values for name check failure reason.
type NameCheckFailureReason string

const (
	// AlreadyExists ...
	AlreadyExists NameCheckFailureReason = "AlreadyExists"
	// Invalid ...
	Invalid NameCheckFailureReason = "Invalid"
)

// PossibleNameCheckFailureReasonValues returns an array of possible values for the NameCheckFailureReason const type.
func PossibleNameCheckFailureReasonValues() []NameCheckFailureReason {
	return []NameCheckFailureReason{AlreadyExists, Invalid}
}

// ObjectType enumerates the values for object type.
type ObjectType string

const (
	// Function ...
	Function ObjectType = "Function"
	// StoredProcedures ...
	StoredProcedures ObjectType = "StoredProcedures"
	// Table ...
	Table ObjectType = "Table"
	// User ...
	User ObjectType = "User"
	// View ...
	View ObjectType = "View"
)

// PossibleObjectTypeValues returns an array of possible values for the ObjectType const type.
func PossibleObjectTypeValues() []ObjectType {
	return []ObjectType{Function, StoredProcedures, Table, User, View}
}

// ProjectProvisioningState enumerates the values for project provisioning state.
type ProjectProvisioningState string

const (
	// ProjectProvisioningStateDeleting ...
	ProjectProvisioningStateDeleting ProjectProvisioningState = "Deleting"
	// ProjectProvisioningStateSucceeded ...
	ProjectProvisioningStateSucceeded ProjectProvisioningState = "Succeeded"
)

// PossibleProjectProvisioningStateValues returns an array of possible values for the ProjectProvisioningState const type.
func PossibleProjectProvisioningStateValues() []ProjectProvisioningState {
	return []ProjectProvisioningState{ProjectProvisioningStateDeleting, ProjectProvisioningStateSucceeded}
}

// ProjectSourcePlatform enumerates the values for project source platform.
type ProjectSourcePlatform string

const (
	// ProjectSourcePlatformMongoDb ...
	ProjectSourcePlatformMongoDb ProjectSourcePlatform = "MongoDb"
	// ProjectSourcePlatformMySQL ...
	ProjectSourcePlatformMySQL ProjectSourcePlatform = "MySQL"
	// ProjectSourcePlatformPostgreSQL ...
	ProjectSourcePlatformPostgreSQL ProjectSourcePlatform = "PostgreSql"
	// ProjectSourcePlatformSQL ...
	ProjectSourcePlatformSQL ProjectSourcePlatform = "SQL"
	// ProjectSourcePlatformUnknown ...
	ProjectSourcePlatformUnknown ProjectSourcePlatform = "Unknown"
)

// PossibleProjectSourcePlatformValues returns an array of possible values for the ProjectSourcePlatform const type.
func PossibleProjectSourcePlatformValues() []ProjectSourcePlatform {
	return []ProjectSourcePlatform{ProjectSourcePlatformMongoDb, ProjectSourcePlatformMySQL, ProjectSourcePlatformPostgreSQL, ProjectSourcePlatformSQL, ProjectSourcePlatformUnknown}
}

// ProjectTargetPlatform enumerates the values for project target platform.
type ProjectTargetPlatform string

const (
	// ProjectTargetPlatformAzureDbForMySQL ...
	ProjectTargetPlatformAzureDbForMySQL ProjectTargetPlatform = "AzureDbForMySql"
	// ProjectTargetPlatformAzureDbForPostgreSQL ...
	ProjectTargetPlatformAzureDbForPostgreSQL ProjectTargetPlatform = "AzureDbForPostgreSql"
	// ProjectTargetPlatformMongoDb ...
	ProjectTargetPlatformMongoDb ProjectTargetPlatform = "MongoDb"
	// ProjectTargetPlatformSQLDB ...
	ProjectTargetPlatformSQLDB ProjectTargetPlatform = "SQLDB"
	// ProjectTargetPlatformSQLMI ...
	ProjectTargetPlatformSQLMI ProjectTargetPlatform = "SQLMI"
	// ProjectTargetPlatformUnknown ...
	ProjectTargetPlatformUnknown ProjectTargetPlatform = "Unknown"
)

// PossibleProjectTargetPlatformValues returns an array of possible values for the ProjectTargetPlatform const type.
func PossibleProjectTargetPlatformValues() []ProjectTargetPlatform {
	return []ProjectTargetPlatform{ProjectTargetPlatformAzureDbForMySQL, ProjectTargetPlatformAzureDbForPostgreSQL, ProjectTargetPlatformMongoDb, ProjectTargetPlatformSQLDB, ProjectTargetPlatformSQLMI, ProjectTargetPlatformUnknown}
}

// ResourceSkuCapacityScaleType enumerates the values for resource sku capacity scale type.
type ResourceSkuCapacityScaleType string

const (
	// ResourceSkuCapacityScaleTypeAutomatic ...
	ResourceSkuCapacityScaleTypeAutomatic ResourceSkuCapacityScaleType = "Automatic"
	// ResourceSkuCapacityScaleTypeManual ...
	ResourceSkuCapacityScaleTypeManual ResourceSkuCapacityScaleType = "Manual"
	// ResourceSkuCapacityScaleTypeNone ...
	ResourceSkuCapacityScaleTypeNone ResourceSkuCapacityScaleType = "None"
)

// PossibleResourceSkuCapacityScaleTypeValues returns an array of possible values for the ResourceSkuCapacityScaleType const type.
func PossibleResourceSkuCapacityScaleTypeValues() []ResourceSkuCapacityScaleType {
	return []ResourceSkuCapacityScaleType{ResourceSkuCapacityScaleTypeAutomatic, ResourceSkuCapacityScaleTypeManual, ResourceSkuCapacityScaleTypeNone}
}

// ResourceSkuRestrictionsReasonCode enumerates the values for resource sku restrictions reason code.
type ResourceSkuRestrictionsReasonCode string

const (
	// NotAvailableForSubscription ...
	NotAvailableForSubscription ResourceSkuRestrictionsReasonCode = "NotAvailableForSubscription"
	// QuotaID ...
	QuotaID ResourceSkuRestrictionsReasonCode = "QuotaId"
)

// PossibleResourceSkuRestrictionsReasonCodeValues returns an array of possible values for the ResourceSkuRestrictionsReasonCode const type.
func PossibleResourceSkuRestrictionsReasonCodeValues() []ResourceSkuRestrictionsReasonCode {
	return []ResourceSkuRestrictionsReasonCode{NotAvailableForSubscription, QuotaID}
}

// ResourceSkuRestrictionsType enumerates the values for resource sku restrictions type.
type ResourceSkuRestrictionsType string

const (
	// Location ...
	Location ResourceSkuRestrictionsType = "location"
)

// PossibleResourceSkuRestrictionsTypeValues returns an array of possible values for the ResourceSkuRestrictionsType const type.
func PossibleResourceSkuRestrictionsTypeValues() []ResourceSkuRestrictionsType {
	return []ResourceSkuRestrictionsType{Location}
}

// ResultCode enumerates the values for result code.
type ResultCode string

const (
	// Completed ...
	Completed ResultCode = "Completed"
	// FatalError ...
	FatalError ResultCode = "FatalError"
	// Initial ...
	Initial ResultCode = "Initial"
	// ObjectNotExistsInSource ...
	ObjectNotExistsInSource ResultCode = "ObjectNotExistsInSource"
	// ObjectNotExistsInTarget ...
	ObjectNotExistsInTarget ResultCode = "ObjectNotExistsInTarget"
	// TargetObjectIsInaccessible ...
	TargetObjectIsInaccessible ResultCode = "TargetObjectIsInaccessible"
)

// PossibleResultCodeValues returns an array of possible values for the ResultCode const type.
func PossibleResultCodeValues() []ResultCode {
	return []ResultCode{Completed, FatalError, Initial, ObjectNotExistsInSource, ObjectNotExistsInTarget, TargetObjectIsInaccessible}
}

// ResultType enumerates the values for result type.
type ResultType string

const (
	// ResultTypeCollection ...
	ResultTypeCollection ResultType = "Collection"
	// ResultTypeDatabase ...
	ResultTypeDatabase ResultType = "Database"
	// ResultTypeMigration ...
	ResultTypeMigration ResultType = "Migration"
)

// PossibleResultTypeValues returns an array of possible values for the ResultType const type.
func PossibleResultTypeValues() []ResultType {
	return []ResultType{ResultTypeCollection, ResultTypeDatabase, ResultTypeMigration}
}

// ResultTypeBasicConnectToSourceSQLServerTaskOutput enumerates the values for result type basic connect to
// source sql server task output.
type ResultTypeBasicConnectToSourceSQLServerTaskOutput string

const (
	// ResultTypeAgentJobLevelOutput ...
	ResultTypeAgentJobLevelOutput ResultTypeBasicConnectToSourceSQLServerTaskOutput = "AgentJobLevelOutput"
	// ResultTypeConnectToSourceSQLServerTaskOutput ...
	ResultTypeConnectToSourceSQLServerTaskOutput ResultTypeBasicConnectToSourceSQLServerTaskOutput = "ConnectToSourceSqlServerTaskOutput"
	// ResultTypeDatabaseLevelOutput ...
	ResultTypeDatabaseLevelOutput ResultTypeBasicConnectToSourceSQLServerTaskOutput = "DatabaseLevelOutput"
	// ResultTypeLoginLevelOutput ...
	ResultTypeLoginLevelOutput ResultTypeBasicConnectToSourceSQLServerTaskOutput = "LoginLevelOutput"
	// ResultTypeTaskLevelOutput ...
	ResultTypeTaskLevelOutput ResultTypeBasicConnectToSourceSQLServerTaskOutput = "TaskLevelOutput"
)

// PossibleResultTypeBasicConnectToSourceSQLServerTaskOutputValues returns an array of possible values for the ResultTypeBasicConnectToSourceSQLServerTaskOutput const type.
func PossibleResultTypeBasicConnectToSourceSQLServerTaskOutputValues() []ResultTypeBasicConnectToSourceSQLServerTaskOutput {
	return []ResultTypeBasicConnectToSourceSQLServerTaskOutput{ResultTypeAgentJobLevelOutput, ResultTypeConnectToSourceSQLServerTaskOutput, ResultTypeDatabaseLevelOutput, ResultTypeLoginLevelOutput, ResultTypeTaskLevelOutput}
}

// ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput enumerates the values for result type basic migrate
// my sql azure db for my sql sync task output.
type ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput string

const (
	// ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput ...
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = "DatabaseLevelErrorOutput"
	// ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput ...
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = "ErrorOutput"
	// ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput ...
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = "MigrateMySqlAzureDbForMySqlSyncTaskOutput"
	// ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput ...
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = "MigrationLevelOutput"
	// ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput ...
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = "TableLevelOutput"
)

// PossibleResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputValues returns an array of possible values for the ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput const type.
func PossibleResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputValues() []ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput {
	return []ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput{ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput, ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput, ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput, ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput, ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput}
}

// ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput enumerates the values for result type basic
// migrate oracle azure db postgre sql sync task output.
type ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput string

const (
	// ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput ...
	ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput = "DatabaseLevelErrorOutput"
	// ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeErrorOutput ...
	ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeErrorOutput ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput = "ErrorOutput"
	// ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrateOracleAzureDbPostgreSQLSyncTaskOutput ...
	ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrateOracleAzureDbPostgreSQLSyncTaskOutput ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput = "MigrateOracleAzureDbPostgreSqlSyncTaskOutput"
	// ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput ...
	ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput = "MigrationLevelOutput"
	// ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeTableLevelOutput ...
	ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeTableLevelOutput ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput = "TableLevelOutput"
)

// PossibleResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputValues returns an array of possible values for the ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput const type.
func PossibleResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputValues() []ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput {
	return []ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput{ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput, ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeErrorOutput, ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrateOracleAzureDbPostgreSQLSyncTaskOutput, ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput, ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeTableLevelOutput}
}

// ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput enumerates the values for result type
// basic migrate postgre sql azure db for postgre sql sync task output.
type ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput string

const (
	// ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput ...
	ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput = "DatabaseLevelErrorOutput"
	// ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeErrorOutput ...
	ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeErrorOutput ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput = "ErrorOutput"
	// ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput ...
	ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput = "MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput"
	// ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput ...
	ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput = "MigrationLevelOutput"
	// ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeTableLevelOutput ...
	ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeTableLevelOutput ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput = "TableLevelOutput"
)

// PossibleResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputValues returns an array of possible values for the ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput const type.
func PossibleResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputValues() []ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput {
	return []ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput{ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput, ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeErrorOutput, ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput, ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeTableLevelOutput}
}

// ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput enumerates the values for result type basic migrate
// schema sql server sql db task output.
type ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput string

const (
	// ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeErrorOutput ...
	ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeErrorOutput ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput = "ErrorOutput"
	// ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrateSchemaSQLServerSQLDbTaskOutput ...
	ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrateSchemaSQLServerSQLDbTaskOutput ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput = "MigrateSchemaSqlServerSqlDbTaskOutput"
	// ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput ...
	ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput = "MigrationLevelOutput"
	// ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeSchemaErrorOutput ...
	ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeSchemaErrorOutput ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput = "SchemaErrorOutput"
)

// PossibleResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputValues returns an array of possible values for the ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput const type.
func PossibleResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputValues() []ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput {
	return []ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput{ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeErrorOutput, ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrateSchemaSQLServerSQLDbTaskOutput, ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput, ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeSchemaErrorOutput}
}

// ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput enumerates the values for result type basic migrate sql
// server sql db sync task output.
type ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput string

const (
	// ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = "DatabaseLevelErrorOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = "ErrorOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = "MigrateSqlServerSqlDbSyncTaskOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = "MigrationLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = "TableLevelOutput"
)

// PossibleResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputValues returns an array of possible values for the ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput const type.
func PossibleResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputValues() []ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput {
	return []ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput{ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput, ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput, ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput, ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput, ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput}
}

// ResultTypeBasicMigrateSQLServerSQLDbTaskOutput enumerates the values for result type basic migrate sql
// server sql db task output.
type ResultTypeBasicMigrateSQLServerSQLDbTaskOutput string

const (
	// ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = "ErrorOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = "MigrateSqlServerSqlDbTaskOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = "MigrationLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = "TableLevelOutput"
)

// PossibleResultTypeBasicMigrateSQLServerSQLDbTaskOutputValues returns an array of possible values for the ResultTypeBasicMigrateSQLServerSQLDbTaskOutput const type.
func PossibleResultTypeBasicMigrateSQLServerSQLDbTaskOutputValues() []ResultTypeBasicMigrateSQLServerSQLDbTaskOutput {
	return []ResultTypeBasicMigrateSQLServerSQLDbTaskOutput{ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput, ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput, ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput, ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput}
}

// ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput enumerates the values for result type basic migrate sql
// server sqlmi sync task output.
type ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput string

const (
	// ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput ...
	ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput = "ErrorOutput"
	// ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrateSQLServerSQLMISyncTaskOutput ...
	ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrateSQLServerSQLMISyncTaskOutput ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput = "MigrateSqlServerSqlMISyncTaskOutput"
	// ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput = "MigrationLevelOutput"
)

// PossibleResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputValues returns an array of possible values for the ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput const type.
func PossibleResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputValues() []ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput {
	return []ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput{ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput, ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrateSQLServerSQLMISyncTaskOutput, ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput}
}

// ResultTypeBasicMigrateSQLServerSQLMITaskOutput enumerates the values for result type basic migrate sql
// server sqlmi task output.
type ResultTypeBasicMigrateSQLServerSQLMITaskOutput string

const (
	// ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput ResultTypeBasicMigrateSQLServerSQLMITaskOutput = "AgentJobLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicMigrateSQLServerSQLMITaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput ...
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput ResultTypeBasicMigrateSQLServerSQLMITaskOutput = "ErrorOutput"
	// ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput ResultTypeBasicMigrateSQLServerSQLMITaskOutput = "LoginLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput ...
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput ResultTypeBasicMigrateSQLServerSQLMITaskOutput = "MigrateSqlServerSqlMITaskOutput"
	// ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput ResultTypeBasicMigrateSQLServerSQLMITaskOutput = "MigrationLevelOutput"
)

// PossibleResultTypeBasicMigrateSQLServerSQLMITaskOutputValues returns an array of possible values for the ResultTypeBasicMigrateSQLServerSQLMITaskOutput const type.
func PossibleResultTypeBasicMigrateSQLServerSQLMITaskOutputValues() []ResultTypeBasicMigrateSQLServerSQLMITaskOutput {
	return []ResultTypeBasicMigrateSQLServerSQLMITaskOutput{ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput, ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput, ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput, ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput, ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput}
}

// ResultTypeBasicMigrateSsisTaskOutput enumerates the values for result type basic migrate ssis task output.
type ResultTypeBasicMigrateSsisTaskOutput string

const (
	// ResultTypeMigrateSsisTaskOutput ...
	ResultTypeMigrateSsisTaskOutput ResultTypeBasicMigrateSsisTaskOutput = "MigrateSsisTaskOutput"
	// ResultTypeMigrationLevelOutput ...
	ResultTypeMigrationLevelOutput ResultTypeBasicMigrateSsisTaskOutput = "MigrationLevelOutput"
	// ResultTypeSsisProjectLevelOutput ...
	ResultTypeSsisProjectLevelOutput ResultTypeBasicMigrateSsisTaskOutput = "SsisProjectLevelOutput"
)

// PossibleResultTypeBasicMigrateSsisTaskOutputValues returns an array of possible values for the ResultTypeBasicMigrateSsisTaskOutput const type.
func PossibleResultTypeBasicMigrateSsisTaskOutputValues() []ResultTypeBasicMigrateSsisTaskOutput {
	return []ResultTypeBasicMigrateSsisTaskOutput{ResultTypeMigrateSsisTaskOutput, ResultTypeMigrationLevelOutput, ResultTypeSsisProjectLevelOutput}
}

// SchemaMigrationOption enumerates the values for schema migration option.
type SchemaMigrationOption string

const (
	// SchemaMigrationOptionExtractFromSource ...
	SchemaMigrationOptionExtractFromSource SchemaMigrationOption = "ExtractFromSource"
	// SchemaMigrationOptionNone ...
	SchemaMigrationOptionNone SchemaMigrationOption = "None"
	// SchemaMigrationOptionUseStorageFile ...
	SchemaMigrationOptionUseStorageFile SchemaMigrationOption = "UseStorageFile"
)

// PossibleSchemaMigrationOptionValues returns an array of possible values for the SchemaMigrationOption const type.
func PossibleSchemaMigrationOptionValues() []SchemaMigrationOption {
	return []SchemaMigrationOption{SchemaMigrationOptionExtractFromSource, SchemaMigrationOptionNone, SchemaMigrationOptionUseStorageFile}
}

// SchemaMigrationStage enumerates the values for schema migration stage.
type SchemaMigrationStage string

const (
	// SchemaMigrationStageCollectingObjects ...
	SchemaMigrationStageCollectingObjects SchemaMigrationStage = "CollectingObjects"
	// SchemaMigrationStageCompleted ...
	SchemaMigrationStageCompleted SchemaMigrationStage = "Completed"
	// SchemaMigrationStageCompletedWithWarnings ...
	SchemaMigrationStageCompletedWithWarnings SchemaMigrationStage = "CompletedWithWarnings"
	// SchemaMigrationStageDeployingSchema ...
	SchemaMigrationStageDeployingSchema SchemaMigrationStage = "DeployingSchema"
	// SchemaMigrationStageDownloadingScript ...
	SchemaMigrationStageDownloadingScript SchemaMigrationStage = "DownloadingScript"
	// SchemaMigrationStageFailed ...
	SchemaMigrationStageFailed SchemaMigrationStage = "Failed"
	// SchemaMigrationStageGeneratingScript ...
	SchemaMigrationStageGeneratingScript SchemaMigrationStage = "GeneratingScript"
	// SchemaMigrationStageNotStarted ...
	SchemaMigrationStageNotStarted SchemaMigrationStage = "NotStarted"
	// SchemaMigrationStageUploadingScript ...
	SchemaMigrationStageUploadingScript SchemaMigrationStage = "UploadingScript"
	// SchemaMigrationStageValidatingInputs ...
	SchemaMigrationStageValidatingInputs SchemaMigrationStage = "ValidatingInputs"
)

// PossibleSchemaMigrationStageValues returns an array of possible values for the SchemaMigrationStage const type.
func PossibleSchemaMigrationStageValues() []SchemaMigrationStage {
	return []SchemaMigrationStage{SchemaMigrationStageCollectingObjects, SchemaMigrationStageCompleted, SchemaMigrationStageCompletedWithWarnings, SchemaMigrationStageDeployingSchema, SchemaMigrationStageDownloadingScript, SchemaMigrationStageFailed, SchemaMigrationStageGeneratingScript, SchemaMigrationStageNotStarted, SchemaMigrationStageUploadingScript, SchemaMigrationStageValidatingInputs}
}

// ServerLevelPermissionsGroup enumerates the values for server level permissions group.
type ServerLevelPermissionsGroup string

const (
	// Default ...
	Default ServerLevelPermissionsGroup = "Default"
	// MigrationFromMySQLToAzureDBForMySQL ...
	MigrationFromMySQLToAzureDBForMySQL ServerLevelPermissionsGroup = "MigrationFromMySQLToAzureDBForMySQL"
	// MigrationFromSQLServerToAzureDB ...
	MigrationFromSQLServerToAzureDB ServerLevelPermissionsGroup = "MigrationFromSqlServerToAzureDB"
	// MigrationFromSQLServerToAzureMI ...
	MigrationFromSQLServerToAzureMI ServerLevelPermissionsGroup = "MigrationFromSqlServerToAzureMI"
)

// PossibleServerLevelPermissionsGroupValues returns an array of possible values for the ServerLevelPermissionsGroup const type.
func PossibleServerLevelPermissionsGroupValues() []ServerLevelPermissionsGroup {
	return []ServerLevelPermissionsGroup{Default, MigrationFromMySQLToAzureDBForMySQL, MigrationFromSQLServerToAzureDB, MigrationFromSQLServerToAzureMI}
}

// ServiceProvisioningState enumerates the values for service provisioning state.
type ServiceProvisioningState string

const (
	// ServiceProvisioningStateAccepted ...
	ServiceProvisioningStateAccepted ServiceProvisioningState = "Accepted"
	// ServiceProvisioningStateDeleting ...
	ServiceProvisioningStateDeleting ServiceProvisioningState = "Deleting"
	// ServiceProvisioningStateDeploying ...
	ServiceProvisioningStateDeploying ServiceProvisioningState = "Deploying"
	// ServiceProvisioningStateFailed ...
	ServiceProvisioningStateFailed ServiceProvisioningState = "Failed"
	// ServiceProvisioningStateFailedToStart ...
	ServiceProvisioningStateFailedToStart ServiceProvisioningState = "FailedToStart"
	// ServiceProvisioningStateFailedToStop ...
	ServiceProvisioningStateFailedToStop ServiceProvisioningState = "FailedToStop"
	// ServiceProvisioningStateStarting ...
	ServiceProvisioningStateStarting ServiceProvisioningState = "Starting"
	// ServiceProvisioningStateStopped ...
	ServiceProvisioningStateStopped ServiceProvisioningState = "Stopped"
	// ServiceProvisioningStateStopping ...
	ServiceProvisioningStateStopping ServiceProvisioningState = "Stopping"
	// ServiceProvisioningStateSucceeded ...
	ServiceProvisioningStateSucceeded ServiceProvisioningState = "Succeeded"
)

// PossibleServiceProvisioningStateValues returns an array of possible values for the ServiceProvisioningState const type.
func PossibleServiceProvisioningStateValues() []ServiceProvisioningState {
	return []ServiceProvisioningState{ServiceProvisioningStateAccepted, ServiceProvisioningStateDeleting, ServiceProvisioningStateDeploying, ServiceProvisioningStateFailed, ServiceProvisioningStateFailedToStart, ServiceProvisioningStateFailedToStop, ServiceProvisioningStateStarting, ServiceProvisioningStateStopped, ServiceProvisioningStateStopping, ServiceProvisioningStateSucceeded}
}

// ServiceScalability enumerates the values for service scalability.
type ServiceScalability string

const (
	// ServiceScalabilityAutomatic ...
	ServiceScalabilityAutomatic ServiceScalability = "automatic"
	// ServiceScalabilityManual ...
	ServiceScalabilityManual ServiceScalability = "manual"
	// ServiceScalabilityNone ...
	ServiceScalabilityNone ServiceScalability = "none"
)

// PossibleServiceScalabilityValues returns an array of possible values for the ServiceScalability const type.
func PossibleServiceScalabilityValues() []ServiceScalability {
	return []ServiceScalability{ServiceScalabilityAutomatic, ServiceScalabilityManual, ServiceScalabilityNone}
}

// Severity enumerates the values for severity.
type Severity string

const (
	// SeverityError ...
	SeverityError Severity = "Error"
	// SeverityMessage ...
	SeverityMessage Severity = "Message"
	// SeverityWarning ...
	SeverityWarning Severity = "Warning"
)

// PossibleSeverityValues returns an array of possible values for the Severity const type.
func PossibleSeverityValues() []Severity {
	return []Severity{SeverityError, SeverityMessage, SeverityWarning}
}

// SQLSourcePlatform enumerates the values for sql source platform.
type SQLSourcePlatform string

const (
	// SQLOnPrem ...
	SQLOnPrem SQLSourcePlatform = "SqlOnPrem"
)

// PossibleSQLSourcePlatformValues returns an array of possible values for the SQLSourcePlatform const type.
func PossibleSQLSourcePlatformValues() []SQLSourcePlatform {
	return []SQLSourcePlatform{SQLOnPrem}
}

// SsisMigrationOverwriteOption enumerates the values for ssis migration overwrite option.
type SsisMigrationOverwriteOption string

const (
	// Ignore ...
	Ignore SsisMigrationOverwriteOption = "Ignore"
	// Overwrite ...
	Overwrite SsisMigrationOverwriteOption = "Overwrite"
)

// PossibleSsisMigrationOverwriteOptionValues returns an array of possible values for the SsisMigrationOverwriteOption const type.
func PossibleSsisMigrationOverwriteOptionValues() []SsisMigrationOverwriteOption {
	return []SsisMigrationOverwriteOption{Ignore, Overwrite}
}

// SsisMigrationStage enumerates the values for ssis migration stage.
type SsisMigrationStage string

const (
	// SsisMigrationStageCompleted ...
	SsisMigrationStageCompleted SsisMigrationStage = "Completed"
	// SsisMigrationStageInitialize ...
	SsisMigrationStageInitialize SsisMigrationStage = "Initialize"
	// SsisMigrationStageInProgress ...
	SsisMigrationStageInProgress SsisMigrationStage = "InProgress"
	// SsisMigrationStageNone ...
	SsisMigrationStageNone SsisMigrationStage = "None"
)

// PossibleSsisMigrationStageValues returns an array of possible values for the SsisMigrationStage const type.
func PossibleSsisMigrationStageValues() []SsisMigrationStage {
	return []SsisMigrationStage{SsisMigrationStageCompleted, SsisMigrationStageInitialize, SsisMigrationStageInProgress, SsisMigrationStageNone}
}

// SsisStoreType enumerates the values for ssis store type.
type SsisStoreType string

const (
	// SsisCatalog ...
	SsisCatalog SsisStoreType = "SsisCatalog"
)

// PossibleSsisStoreTypeValues returns an array of possible values for the SsisStoreType const type.
func PossibleSsisStoreTypeValues() []SsisStoreType {
	return []SsisStoreType{SsisCatalog}
}

// SyncDatabaseMigrationReportingState enumerates the values for sync database migration reporting state.
type SyncDatabaseMigrationReportingState string

const (
	// SyncDatabaseMigrationReportingStateCANCELLED ...
	SyncDatabaseMigrationReportingStateCANCELLED SyncDatabaseMigrationReportingState = "CANCELLED"
	// SyncDatabaseMigrationReportingStateCANCELLING ...
	SyncDatabaseMigrationReportingStateCANCELLING SyncDatabaseMigrationReportingState = "CANCELLING"
	// SyncDatabaseMigrationReportingStateCOMPLETE ...
	SyncDatabaseMigrationReportingStateCOMPLETE SyncDatabaseMigrationReportingState = "COMPLETE"
	// SyncDatabaseMigrationReportingStateCOMPLETING ...
	SyncDatabaseMigrationReportingStateCOMPLETING SyncDatabaseMigrationReportingState = "COMPLETING"
	// SyncDatabaseMigrationReportingStateCONFIGURING ...
	SyncDatabaseMigrationReportingStateCONFIGURING SyncDatabaseMigrationReportingState = "CONFIGURING"
	// SyncDatabaseMigrationReportingStateFAILED ...
	SyncDatabaseMigrationReportingStateFAILED SyncDatabaseMigrationReportingState = "FAILED"
	// SyncDatabaseMigrationReportingStateINITIALIAZING ...
	SyncDatabaseMigrationReportingStateINITIALIAZING SyncDatabaseMigrationReportingState = "INITIALIAZING"
	// SyncDatabaseMigrationReportingStateREADYTOCOMPLETE ...
	SyncDatabaseMigrationReportingStateREADYTOCOMPLETE SyncDatabaseMigrationReportingState = "READY_TO_COMPLETE"
	// SyncDatabaseMigrationReportingStateRUNNING ...
	SyncDatabaseMigrationReportingStateRUNNING SyncDatabaseMigrationReportingState = "RUNNING"
	// SyncDatabaseMigrationReportingStateSTARTING ...
	SyncDatabaseMigrationReportingStateSTARTING SyncDatabaseMigrationReportingState = "STARTING"
	// SyncDatabaseMigrationReportingStateUNDEFINED ...
	SyncDatabaseMigrationReportingStateUNDEFINED SyncDatabaseMigrationReportingState = "UNDEFINED"
)

// PossibleSyncDatabaseMigrationReportingStateValues returns an array of possible values for the SyncDatabaseMigrationReportingState const type.
func PossibleSyncDatabaseMigrationReportingStateValues() []SyncDatabaseMigrationReportingState {
	return []SyncDatabaseMigrationReportingState{SyncDatabaseMigrationReportingStateCANCELLED, SyncDatabaseMigrationReportingStateCANCELLING, SyncDatabaseMigrationReportingStateCOMPLETE, SyncDatabaseMigrationReportingStateCOMPLETING, SyncDatabaseMigrationReportingStateCONFIGURING, SyncDatabaseMigrationReportingStateFAILED, SyncDatabaseMigrationReportingStateINITIALIAZING, SyncDatabaseMigrationReportingStateREADYTOCOMPLETE, SyncDatabaseMigrationReportingStateRUNNING, SyncDatabaseMigrationReportingStateSTARTING, SyncDatabaseMigrationReportingStateUNDEFINED}
}

// SyncTableMigrationState enumerates the values for sync table migration state.
type SyncTableMigrationState string

const (
	// SyncTableMigrationStateBEFORELOAD ...
	SyncTableMigrationStateBEFORELOAD SyncTableMigrationState = "BEFORE_LOAD"
	// SyncTableMigrationStateCANCELED ...
	SyncTableMigrationStateCANCELED SyncTableMigrationState = "CANCELED"
	// SyncTableMigrationStateCOMPLETED ...
	SyncTableMigrationStateCOMPLETED SyncTableMigrationState = "COMPLETED"
	// SyncTableMigrationStateERROR ...
	SyncTableMigrationStateERROR SyncTableMigrationState = "ERROR"
	// SyncTableMigrationStateFAILED ...
	SyncTableMigrationStateFAILED SyncTableMigrationState = "FAILED"
	// SyncTableMigrationStateFULLLOAD ...
	SyncTableMigrationStateFULLLOAD SyncTableMigrationState = "FULL_LOAD"
)

// PossibleSyncTableMigrationStateValues returns an array of possible values for the SyncTableMigrationState const type.
func PossibleSyncTableMigrationStateValues() []SyncTableMigrationState {
	return []SyncTableMigrationState{SyncTableMigrationStateBEFORELOAD, SyncTableMigrationStateCANCELED, SyncTableMigrationStateCOMPLETED, SyncTableMigrationStateERROR, SyncTableMigrationStateFAILED, SyncTableMigrationStateFULLLOAD}
}

// TaskState enumerates the values for task state.
type TaskState string

const (
	// TaskStateCanceled ...
	TaskStateCanceled TaskState = "Canceled"
	// TaskStateFailed ...
	TaskStateFailed TaskState = "Failed"
	// TaskStateFailedInputValidation ...
	TaskStateFailedInputValidation TaskState = "FailedInputValidation"
	// TaskStateFaulted ...
	TaskStateFaulted TaskState = "Faulted"
	// TaskStateQueued ...
	TaskStateQueued TaskState = "Queued"
	// TaskStateRunning ...
	TaskStateRunning TaskState = "Running"
	// TaskStateSucceeded ...
	TaskStateSucceeded TaskState = "Succeeded"
	// TaskStateUnknown ...
	TaskStateUnknown TaskState = "Unknown"
)

// PossibleTaskStateValues returns an array of possible values for the TaskState const type.
func PossibleTaskStateValues() []TaskState {
	return []TaskState{TaskStateCanceled, TaskStateFailed, TaskStateFailedInputValidation, TaskStateFaulted, TaskStateQueued, TaskStateRunning, TaskStateSucceeded, TaskStateUnknown}
}

// TaskType enumerates the values for task type.
type TaskType string

const (
	// TaskTypeConnectMongoDb ...
	TaskTypeConnectMongoDb TaskType = "Connect.MongoDb"
	// TaskTypeConnectToSourceMySQL ...
	TaskTypeConnectToSourceMySQL TaskType = "ConnectToSource.MySql"
	// TaskTypeConnectToSourceOracleSync ...
	TaskTypeConnectToSourceOracleSync TaskType = "ConnectToSource.Oracle.Sync"
	// TaskTypeConnectToSourcePostgreSQLSync ...
	TaskTypeConnectToSourcePostgreSQLSync TaskType = "ConnectToSource.PostgreSql.Sync"
	// TaskTypeConnectToSourceSQLServer ...
	TaskTypeConnectToSourceSQLServer TaskType = "ConnectToSource.SqlServer"
	// TaskTypeConnectToSourceSQLServerSync ...
	TaskTypeConnectToSourceSQLServerSync TaskType = "ConnectToSource.SqlServer.Sync"
	// TaskTypeConnectToTargetAzureDbForMySQL ...
	TaskTypeConnectToTargetAzureDbForMySQL TaskType = "ConnectToTarget.AzureDbForMySql"
	// TaskTypeConnectToTargetAzureDbForPostgreSQLSync ...
	TaskTypeConnectToTargetAzureDbForPostgreSQLSync TaskType = "ConnectToTarget.AzureDbForPostgreSql.Sync"
	// TaskTypeConnectToTargetAzureSQLDbMI ...
	TaskTypeConnectToTargetAzureSQLDbMI TaskType = "ConnectToTarget.AzureSqlDbMI"
	// TaskTypeConnectToTargetAzureSQLDbMISyncLRS ...
	TaskTypeConnectToTargetAzureSQLDbMISyncLRS TaskType = "ConnectToTarget.AzureSqlDbMI.Sync.LRS"
	// TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync ...
	TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync TaskType = "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync"
	// TaskTypeConnectToTargetSQLDb ...
	TaskTypeConnectToTargetSQLDb TaskType = "ConnectToTarget.SqlDb"
	// TaskTypeConnectToTargetSQLDbSync ...
	TaskTypeConnectToTargetSQLDbSync TaskType = "ConnectToTarget.SqlDb.Sync"
	// TaskTypeGetTDECertificatesSQL ...
	TaskTypeGetTDECertificatesSQL TaskType = "GetTDECertificates.Sql"
	// TaskTypeGetUserTablesAzureSQLDbSync ...
	TaskTypeGetUserTablesAzureSQLDbSync TaskType = "GetUserTables.AzureSqlDb.Sync"
	// TaskTypeGetUserTablesOracle ...
	TaskTypeGetUserTablesOracle TaskType = "GetUserTablesOracle"
	// TaskTypeGetUserTablesPostgreSQL ...
	TaskTypeGetUserTablesPostgreSQL TaskType = "GetUserTablesPostgreSql"
	// TaskTypeGetUserTablesSQL ...
	TaskTypeGetUserTablesSQL TaskType = "GetUserTables.Sql"
	// TaskTypeMigrateMongoDb ...
	TaskTypeMigrateMongoDb TaskType = "Migrate.MongoDb"
	// TaskTypeMigrateMySQLAzureDbForMySQLSync ...
	TaskTypeMigrateMySQLAzureDbForMySQLSync TaskType = "Migrate.MySql.AzureDbForMySql.Sync"
	// TaskTypeMigrateOracleAzureDbForPostgreSQLSync ...
	TaskTypeMigrateOracleAzureDbForPostgreSQLSync TaskType = "Migrate.Oracle.AzureDbForPostgreSql.Sync"
	// TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync ...
	TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync TaskType = "Migrate.PostgreSql.AzureDbForPostgreSql.Sync"
	// TaskTypeMigrateSchemaSQLServerSQLDb ...
	TaskTypeMigrateSchemaSQLServerSQLDb TaskType = "MigrateSchemaSqlServerSqlDb"
	// TaskTypeMigrateSQLServerAzureSQLDbMI ...
	TaskTypeMigrateSQLServerAzureSQLDbMI TaskType = "Migrate.SqlServer.AzureSqlDbMI"
	// TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS ...
	TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS TaskType = "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS"
	// TaskTypeMigrateSQLServerAzureSQLDbSync ...
	TaskTypeMigrateSQLServerAzureSQLDbSync TaskType = "Migrate.SqlServer.AzureSqlDb.Sync"
	// TaskTypeMigrateSQLServerSQLDb ...
	TaskTypeMigrateSQLServerSQLDb TaskType = "Migrate.SqlServer.SqlDb"
	// TaskTypeMigrateSsis ...
	TaskTypeMigrateSsis TaskType = "Migrate.Ssis"
	// TaskTypeProjectTaskProperties ...
	TaskTypeProjectTaskProperties TaskType = "ProjectTaskProperties"
	// TaskTypeServiceCheckOCI ...
	TaskTypeServiceCheckOCI TaskType = "Service.Check.OCI"
	// TaskTypeServiceInstallOCI ...
	TaskTypeServiceInstallOCI TaskType = "Service.Install.OCI"
	// TaskTypeServiceUploadOCI ...
	TaskTypeServiceUploadOCI TaskType = "Service.Upload.OCI"
	// TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI ...
	TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI TaskType = "ValidateMigrationInput.SqlServer.AzureSqlDbMI"
	// TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS ...
	TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS TaskType = "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS"
	// TaskTypeValidateMigrationInputSQLServerSQLDbSync ...
	TaskTypeValidateMigrationInputSQLServerSQLDbSync TaskType = "ValidateMigrationInput.SqlServer.SqlDb.Sync"
	// TaskTypeValidateMongoDb ...
	TaskTypeValidateMongoDb TaskType = "Validate.MongoDb"
	// TaskTypeValidateOracleAzureDbPostgreSQLSync ...
	TaskTypeValidateOracleAzureDbPostgreSQLSync TaskType = "Validate.Oracle.AzureDbPostgreSql.Sync"
)

// PossibleTaskTypeValues returns an array of possible values for the TaskType const type.
func PossibleTaskTypeValues() []TaskType {
	return []TaskType{TaskTypeConnectMongoDb, TaskTypeConnectToSourceMySQL, TaskTypeConnectToSourceOracleSync, TaskTypeConnectToSourcePostgreSQLSync, TaskTypeConnectToSourceSQLServer, TaskTypeConnectToSourceSQLServerSync, TaskTypeConnectToTargetAzureDbForMySQL, TaskTypeConnectToTargetAzureDbForPostgreSQLSync, TaskTypeConnectToTargetAzureSQLDbMI, TaskTypeConnectToTargetAzureSQLDbMISyncLRS, TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync, TaskTypeConnectToTargetSQLDb, TaskTypeConnectToTargetSQLDbSync, TaskTypeGetTDECertificatesSQL, TaskTypeGetUserTablesAzureSQLDbSync, TaskTypeGetUserTablesOracle, TaskTypeGetUserTablesPostgreSQL, TaskTypeGetUserTablesSQL, TaskTypeMigrateMongoDb, TaskTypeMigrateMySQLAzureDbForMySQLSync, TaskTypeMigrateOracleAzureDbForPostgreSQLSync, TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync, TaskTypeMigrateSchemaSQLServerSQLDb, TaskTypeMigrateSQLServerAzureSQLDbMI, TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS, TaskTypeMigrateSQLServerAzureSQLDbSync, TaskTypeMigrateSQLServerSQLDb, TaskTypeMigrateSsis, TaskTypeProjectTaskProperties, TaskTypeServiceCheckOCI, TaskTypeServiceInstallOCI, TaskTypeServiceUploadOCI, TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI, TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS, TaskTypeValidateMigrationInputSQLServerSQLDbSync, TaskTypeValidateMongoDb, TaskTypeValidateOracleAzureDbPostgreSQLSync}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeConnectionInfo ...
	TypeConnectionInfo Type = "ConnectionInfo"
	// TypeMiSQLConnectionInfo ...
	TypeMiSQLConnectionInfo Type = "MiSqlConnectionInfo"
	// TypeMongoDbConnectionInfo ...
	TypeMongoDbConnectionInfo Type = "MongoDbConnectionInfo"
	// TypeMySQLConnectionInfo ...
	TypeMySQLConnectionInfo Type = "MySqlConnectionInfo"
	// TypeOracleConnectionInfo ...
	TypeOracleConnectionInfo Type = "OracleConnectionInfo"
	// TypePostgreSQLConnectionInfo ...
	TypePostgreSQLConnectionInfo Type = "PostgreSqlConnectionInfo"
	// TypeSQLConnectionInfo ...
	TypeSQLConnectionInfo Type = "SqlConnectionInfo"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeConnectionInfo, TypeMiSQLConnectionInfo, TypeMongoDbConnectionInfo, TypeMySQLConnectionInfo, TypeOracleConnectionInfo, TypePostgreSQLConnectionInfo, TypeSQLConnectionInfo}
}

// UpdateActionType enumerates the values for update action type.
type UpdateActionType string

const (
	// AddedOnTarget ...
	AddedOnTarget UpdateActionType = "AddedOnTarget"
	// ChangedOnTarget ...
	ChangedOnTarget UpdateActionType = "ChangedOnTarget"
	// DeletedOnTarget ...
	DeletedOnTarget UpdateActionType = "DeletedOnTarget"
)

// PossibleUpdateActionTypeValues returns an array of possible values for the UpdateActionType const type.
func PossibleUpdateActionTypeValues() []UpdateActionType {
	return []UpdateActionType{AddedOnTarget, ChangedOnTarget, DeletedOnTarget}
}

// ValidationStatus enumerates the values for validation status.
type ValidationStatus string

const (
	// ValidationStatusCompleted ...
	ValidationStatusCompleted ValidationStatus = "Completed"
	// ValidationStatusCompletedWithIssues ...
	ValidationStatusCompletedWithIssues ValidationStatus = "CompletedWithIssues"
	// ValidationStatusDefault ...
	ValidationStatusDefault ValidationStatus = "Default"
	// ValidationStatusFailed ...
	ValidationStatusFailed ValidationStatus = "Failed"
	// ValidationStatusInitialized ...
	ValidationStatusInitialized ValidationStatus = "Initialized"
	// ValidationStatusInProgress ...
	ValidationStatusInProgress ValidationStatus = "InProgress"
	// ValidationStatusNotStarted ...
	ValidationStatusNotStarted ValidationStatus = "NotStarted"
	// ValidationStatusStopped ...
	ValidationStatusStopped ValidationStatus = "Stopped"
)

// PossibleValidationStatusValues returns an array of possible values for the ValidationStatus const type.
func PossibleValidationStatusValues() []ValidationStatus {
	return []ValidationStatus{ValidationStatusCompleted, ValidationStatusCompletedWithIssues, ValidationStatusDefault, ValidationStatusFailed, ValidationStatusInitialized, ValidationStatusInProgress, ValidationStatusNotStarted, ValidationStatusStopped}
}

// APIError error information.
type APIError struct {
	// Error - Error information in OData format
	Error *ODataError `json:"error,omitempty"`
}

// AvailableServiceSku describes the available service SKU.
type AvailableServiceSku struct {
	// ResourceType - The resource type, including the provider namespace
	ResourceType *string `json:"resourceType,omitempty"`
	// Sku - SKU name, tier, etc.
	Sku *AvailableServiceSkuSku `json:"sku,omitempty"`
	// Capacity - A description of the scaling capacities of the SKU
	Capacity *AvailableServiceSkuCapacity `json:"capacity,omitempty"`
}

// AvailableServiceSkuCapacity a description of the scaling capacities of the SKU
type AvailableServiceSkuCapacity struct {
	// Minimum - The minimum capacity, usually 0 or 1.
	Minimum *int32 `json:"minimum,omitempty"`
	// Maximum - The maximum capacity
	Maximum *int32 `json:"maximum,omitempty"`
	// Default - The default capacity
	Default *int32 `json:"default,omitempty"`
	// ScaleType - The scalability approach. Possible values include: 'ServiceScalabilityNone', 'ServiceScalabilityManual', 'ServiceScalabilityAutomatic'
	ScaleType ServiceScalability `json:"scaleType,omitempty"`
}

// AvailableServiceSkuSku SKU name, tier, etc.
type AvailableServiceSkuSku struct {
	// Name - The name of the SKU
	Name *string `json:"name,omitempty"`
	// Family - SKU family
	Family *string `json:"family,omitempty"`
	// Size - SKU size
	Size *string `json:"size,omitempty"`
	// Tier - The tier of the SKU, such as "Basic", "General Purpose", or "Business Critical"
	Tier *string `json:"tier,omitempty"`
}

// AzureActiveDirectoryApp azure Active Directory Application
type AzureActiveDirectoryApp struct {
	// ApplicationID - Application ID of the Azure Active Directory Application
	ApplicationID *string `json:"applicationId,omitempty"`
	// AppKey - Key used to authenticate to the Azure Active Directory Application
	AppKey *string `json:"appKey,omitempty"`
	// TenantID - Tenant id of the customer
	TenantID *string `json:"tenantId,omitempty"`
}

// BackupFileInfo information of the backup file
type BackupFileInfo struct {
	// FileLocation - Location of the backup file in shared folder
	FileLocation *string `json:"fileLocation,omitempty"`
	// FamilySequenceNumber - Sequence number of the backup file in the backup set
	FamilySequenceNumber *int32 `json:"familySequenceNumber,omitempty"`
	// Status - Status of the backup file during migration. Possible values include: 'Arrived', 'Queued', 'Uploading', 'Uploaded', 'Restoring', 'Restored', 'Cancelled'
	Status BackupFileStatus `json:"status,omitempty"`
}

// BackupSetInfo information of backup set
type BackupSetInfo struct {
	// BackupSetID - Id for the set of backup files
	BackupSetID *string `json:"backupSetId,omitempty"`
	// FirstLsn - First log sequence number of the backup file
	FirstLsn *string `json:"firstLsn,omitempty"`
	// LastLsn - Last log sequence number of the backup file
	LastLsn *string `json:"lastLsn,omitempty"`
	// LastModifiedTime - Last modified time of the backup file in share location
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// BackupType - Enum of the different backup types. Possible values include: 'BackupTypeDatabase', 'BackupTypeTransactionLog', 'BackupTypeFile', 'BackupTypeDifferentialDatabase', 'BackupTypeDifferentialFile', 'BackupTypePartial', 'BackupTypeDifferentialPartial'
	BackupType BackupType `json:"backupType,omitempty"`
	// ListOfBackupFiles - List of files in the backup set
	ListOfBackupFiles *[]BackupFileInfo `json:"listOfBackupFiles,omitempty"`
	// DatabaseName - Name of the database to which the backup set belongs
	DatabaseName *string `json:"databaseName,omitempty"`
	// BackupStartDate - Date and time that the backup operation began
	BackupStartDate *date.Time `json:"backupStartDate,omitempty"`
	// BackupFinishedDate - Date and time that the backup operation finished
	BackupFinishedDate *date.Time `json:"backupFinishedDate,omitempty"`
	// IsBackupRestored - Whether the backup set is restored or not
	IsBackupRestored *bool `json:"isBackupRestored,omitempty"`
}

// BlobShare blob container storage information.
type BlobShare struct {
	// SasURI - SAS URI of Azure Storage Account Container.
	SasURI *string `json:"sasUri,omitempty"`
}

// CheckOCIDriverTaskInput input for the service task to check for OCI drivers.
type CheckOCIDriverTaskInput struct {
	// ServerVersion - Version of the source server to check against.  Optional.
	ServerVersion *string `json:"serverVersion,omitempty"`
}

// CheckOCIDriverTaskOutput output for the service task to check for OCI drivers.
type CheckOCIDriverTaskOutput struct {
	// InstalledDriver - Information about the installed driver if found and valid.
	InstalledDriver *OracleOCIDriverInfo `json:"installedDriver,omitempty"`
	// ValidationErrors - READ-ONLY; Validation errors
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// CheckOCIDriverTaskProperties properties for the task that checks for OCI drivers.
type CheckOCIDriverTaskProperties struct {
	Input *CheckOCIDriverTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]CheckOCIDriverTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) MarshalJSON() ([]byte, error) {
	codtp.TaskType = TaskTypeServiceCheckOCI
	objectMap := make(map[string]interface{})
	if codtp.Input != nil {
		objectMap["input"] = codtp.Input
	}
	if codtp.ClientData != nil {
		objectMap["clientData"] = codtp.ClientData
	}
	if codtp.TaskType != "" {
		objectMap["taskType"] = codtp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return &codtp, true
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for CheckOCIDriverTaskProperties.
func (codtp CheckOCIDriverTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &codtp, true
}

// UnmarshalJSON is the custom unmarshaler for CheckOCIDriverTaskProperties struct.
func (codtp *CheckOCIDriverTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input CheckOCIDriverTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				codtp.Input = &input
			}
		case "output":
			if v != nil {
				var output []CheckOCIDriverTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				codtp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				codtp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				codtp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				codtp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				codtp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				codtp.TaskType = taskType
			}
		}
	}

	return nil
}

// BasicCommandProperties base class for all types of DMS command properties. If command is not supported by current
// client, this object is returned.
type BasicCommandProperties interface {
	AsMigrateMISyncCompleteCommandProperties() (*MigrateMISyncCompleteCommandProperties, bool)
	AsMigrateSyncCompleteCommandProperties() (*MigrateSyncCompleteCommandProperties, bool)
	AsMongoDbCancelCommand() (*MongoDbCancelCommand, bool)
	AsMongoDbFinishCommand() (*MongoDbFinishCommand, bool)
	AsMongoDbRestartCommand() (*MongoDbRestartCommand, bool)
	AsCommandProperties() (*CommandProperties, bool)
}

// CommandProperties base class for all types of DMS command properties. If command is not supported by current
// client, this object is returned.
type CommandProperties struct {
	autorest.Response `json:"-"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the command. This is ignored if submitted. Possible values include: 'Unknown', 'Accepted', 'Running', 'Succeeded', 'Failed'
	State CommandState `json:"state,omitempty"`
	// CommandType - Possible values include: 'CommandTypeCommandProperties', 'CommandTypeMigrateSQLServerAzureDbSQLMiComplete', 'CommandTypeMigrateSyncCompleteDatabase', 'CommandTypeCancel', 'CommandTypeFinish', 'CommandTypeRestart'
	CommandType CommandType `json:"commandType,omitempty"`
}

func unmarshalBasicCommandProperties(body []byte) (BasicCommandProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["commandType"] {
	case string(CommandTypeMigrateSQLServerAzureDbSQLMiComplete):
		var mmsccp MigrateMISyncCompleteCommandProperties
		err := json.Unmarshal(body, &mmsccp)
		return mmsccp, err
	case string(CommandTypeMigrateSyncCompleteDatabase):
		var msccp MigrateSyncCompleteCommandProperties
		err := json.Unmarshal(body, &msccp)
		return msccp, err
	case string(CommandTypeCancel):
		var mdcc MongoDbCancelCommand
		err := json.Unmarshal(body, &mdcc)
		return mdcc, err
	case string(CommandTypeFinish):
		var mdfc MongoDbFinishCommand
		err := json.Unmarshal(body, &mdfc)
		return mdfc, err
	case string(CommandTypeRestart):
		var mdrc MongoDbRestartCommand
		err := json.Unmarshal(body, &mdrc)
		return mdrc, err
	default:
		var cp CommandProperties
		err := json.Unmarshal(body, &cp)
		return cp, err
	}
}
func unmarshalBasicCommandPropertiesArray(body []byte) ([]BasicCommandProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cpArray := make([]BasicCommandProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cp, err := unmarshalBasicCommandProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		cpArray[index] = cp
	}
	return cpArray, nil
}

// MarshalJSON is the custom marshaler for CommandProperties.
func (cp CommandProperties) MarshalJSON() ([]byte, error) {
	cp.CommandType = CommandTypeCommandProperties
	objectMap := make(map[string]interface{})
	if cp.CommandType != "" {
		objectMap["commandType"] = cp.CommandType
	}
	return json.Marshal(objectMap)
}

// AsMigrateMISyncCompleteCommandProperties is the BasicCommandProperties implementation for CommandProperties.
func (cp CommandProperties) AsMigrateMISyncCompleteCommandProperties() (*MigrateMISyncCompleteCommandProperties, bool) {
	return nil, false
}

// AsMigrateSyncCompleteCommandProperties is the BasicCommandProperties implementation for CommandProperties.
func (cp CommandProperties) AsMigrateSyncCompleteCommandProperties() (*MigrateSyncCompleteCommandProperties, bool) {
	return nil, false
}

// AsMongoDbCancelCommand is the BasicCommandProperties implementation for CommandProperties.
func (cp CommandProperties) AsMongoDbCancelCommand() (*MongoDbCancelCommand, bool) {
	return nil, false
}

// AsMongoDbFinishCommand is the BasicCommandProperties implementation for CommandProperties.
func (cp CommandProperties) AsMongoDbFinishCommand() (*MongoDbFinishCommand, bool) {
	return nil, false
}

// AsMongoDbRestartCommand is the BasicCommandProperties implementation for CommandProperties.
func (cp CommandProperties) AsMongoDbRestartCommand() (*MongoDbRestartCommand, bool) {
	return nil, false
}

// AsCommandProperties is the BasicCommandProperties implementation for CommandProperties.
func (cp CommandProperties) AsCommandProperties() (*CommandProperties, bool) {
	return &cp, true
}

// AsBasicCommandProperties is the BasicCommandProperties implementation for CommandProperties.
func (cp CommandProperties) AsBasicCommandProperties() (BasicCommandProperties, bool) {
	return &cp, true
}

// CommandPropertiesModel ...
type CommandPropertiesModel struct {
	autorest.Response `json:"-"`
	Value             BasicCommandProperties `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CommandPropertiesModel struct.
func (cpm *CommandPropertiesModel) UnmarshalJSON(body []byte) error {
	cp, err := unmarshalBasicCommandProperties(body)
	if err != nil {
		return err
	}
	cpm.Value = cp

	return nil
}

// BasicConnectionInfo defines the connection properties of a server
type BasicConnectionInfo interface {
	AsMiSQLConnectionInfo() (*MiSQLConnectionInfo, bool)
	AsPostgreSQLConnectionInfo() (*PostgreSQLConnectionInfo, bool)
	AsOracleConnectionInfo() (*OracleConnectionInfo, bool)
	AsMySQLConnectionInfo() (*MySQLConnectionInfo, bool)
	AsMongoDbConnectionInfo() (*MongoDbConnectionInfo, bool)
	AsSQLConnectionInfo() (*SQLConnectionInfo, bool)
	AsConnectionInfo() (*ConnectionInfo, bool)
}

// ConnectionInfo defines the connection properties of a server
type ConnectionInfo struct {
	// UserName - User name
	UserName *string `json:"userName,omitempty"`
	// Password - Password credential.
	Password *string `json:"password,omitempty"`
	// Type - Possible values include: 'TypeConnectionInfo', 'TypeMiSQLConnectionInfo', 'TypePostgreSQLConnectionInfo', 'TypeOracleConnectionInfo', 'TypeMySQLConnectionInfo', 'TypeMongoDbConnectionInfo', 'TypeSQLConnectionInfo'
	Type Type `json:"type,omitempty"`
}

func unmarshalBasicConnectionInfo(body []byte) (BasicConnectionInfo, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeMiSQLConnectionInfo):
		var msci MiSQLConnectionInfo
		err := json.Unmarshal(body, &msci)
		return msci, err
	case string(TypePostgreSQLConnectionInfo):
		var psci PostgreSQLConnectionInfo
		err := json.Unmarshal(body, &psci)
		return psci, err
	case string(TypeOracleConnectionInfo):
		var oci OracleConnectionInfo
		err := json.Unmarshal(body, &oci)
		return oci, err
	case string(TypeMySQLConnectionInfo):
		var msci MySQLConnectionInfo
		err := json.Unmarshal(body, &msci)
		return msci, err
	case string(TypeMongoDbConnectionInfo):
		var mdci MongoDbConnectionInfo
		err := json.Unmarshal(body, &mdci)
		return mdci, err
	case string(TypeSQLConnectionInfo):
		var sci SQLConnectionInfo
		err := json.Unmarshal(body, &sci)
		return sci, err
	default:
		var ci ConnectionInfo
		err := json.Unmarshal(body, &ci)
		return ci, err
	}
}
func unmarshalBasicConnectionInfoArray(body []byte) ([]BasicConnectionInfo, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ciArray := make([]BasicConnectionInfo, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ci, err := unmarshalBasicConnectionInfo(*rawMessage)
		if err != nil {
			return nil, err
		}
		ciArray[index] = ci
	}
	return ciArray, nil
}

// MarshalJSON is the custom marshaler for ConnectionInfo.
func (ci ConnectionInfo) MarshalJSON() ([]byte, error) {
	ci.Type = TypeConnectionInfo
	objectMap := make(map[string]interface{})
	if ci.UserName != nil {
		objectMap["userName"] = ci.UserName
	}
	if ci.Password != nil {
		objectMap["password"] = ci.Password
	}
	if ci.Type != "" {
		objectMap["type"] = ci.Type
	}
	return json.Marshal(objectMap)
}

// AsMiSQLConnectionInfo is the BasicConnectionInfo implementation for ConnectionInfo.
func (ci ConnectionInfo) AsMiSQLConnectionInfo() (*MiSQLConnectionInfo, bool) {
	return nil, false
}

// AsPostgreSQLConnectionInfo is the BasicConnectionInfo implementation for ConnectionInfo.
func (ci ConnectionInfo) AsPostgreSQLConnectionInfo() (*PostgreSQLConnectionInfo, bool) {
	return nil, false
}

// AsOracleConnectionInfo is the BasicConnectionInfo implementation for ConnectionInfo.
func (ci ConnectionInfo) AsOracleConnectionInfo() (*OracleConnectionInfo, bool) {
	return nil, false
}

// AsMySQLConnectionInfo is the BasicConnectionInfo implementation for ConnectionInfo.
func (ci ConnectionInfo) AsMySQLConnectionInfo() (*MySQLConnectionInfo, bool) {
	return nil, false
}

// AsMongoDbConnectionInfo is the BasicConnectionInfo implementation for ConnectionInfo.
func (ci ConnectionInfo) AsMongoDbConnectionInfo() (*MongoDbConnectionInfo, bool) {
	return nil, false
}

// AsSQLConnectionInfo is the BasicConnectionInfo implementation for ConnectionInfo.
func (ci ConnectionInfo) AsSQLConnectionInfo() (*SQLConnectionInfo, bool) {
	return nil, false
}

// AsConnectionInfo is the BasicConnectionInfo implementation for ConnectionInfo.
func (ci ConnectionInfo) AsConnectionInfo() (*ConnectionInfo, bool) {
	return &ci, true
}

// AsBasicConnectionInfo is the BasicConnectionInfo implementation for ConnectionInfo.
func (ci ConnectionInfo) AsBasicConnectionInfo() (BasicConnectionInfo, bool) {
	return &ci, true
}

// ConnectToMongoDbTaskProperties properties for the task that validates the connection to and provides
// information about a MongoDB server
type ConnectToMongoDbTaskProperties struct {
	Input *MongoDbConnectionInfo `json:"input,omitempty"`
	// Output - READ-ONLY; An array containing a single MongoDbClusterInfo object
	Output *[]MongoDbClusterInfo `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) MarshalJSON() ([]byte, error) {
	ctmdtp.TaskType = TaskTypeConnectMongoDb
	objectMap := make(map[string]interface{})
	if ctmdtp.Input != nil {
		objectMap["input"] = ctmdtp.Input
	}
	if ctmdtp.ClientData != nil {
		objectMap["clientData"] = ctmdtp.ClientData
	}
	if ctmdtp.TaskType != "" {
		objectMap["taskType"] = ctmdtp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return &ctmdtp, true
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToMongoDbTaskProperties.
func (ctmdtp ConnectToMongoDbTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &ctmdtp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToMongoDbTaskProperties struct.
func (ctmdtp *ConnectToMongoDbTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input MongoDbConnectionInfo
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				ctmdtp.Input = &input
			}
		case "output":
			if v != nil {
				var output []MongoDbClusterInfo
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				ctmdtp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				ctmdtp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				ctmdtp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				ctmdtp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				ctmdtp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				ctmdtp.TaskType = taskType
			}
		}
	}

	return nil
}

// ConnectToSourceMySQLTaskInput input for the task that validates MySQL database connection
type ConnectToSourceMySQLTaskInput struct {
	// SourceConnectionInfo - Information for connecting to MySQL source
	SourceConnectionInfo *MySQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetPlatform - Target Platform for the migration. Possible values include: 'SQLServer', 'AzureDbForMySQL'
	TargetPlatform MySQLTargetPlatformType `json:"targetPlatform,omitempty"`
	// CheckPermissionsGroup - Permission group for validations. Possible values include: 'Default', 'MigrationFromSQLServerToAzureDB', 'MigrationFromSQLServerToAzureMI', 'MigrationFromMySQLToAzureDBForMySQL'
	CheckPermissionsGroup ServerLevelPermissionsGroup `json:"checkPermissionsGroup,omitempty"`
}

// ConnectToSourceMySQLTaskProperties properties for the task that validates MySQL database connection
type ConnectToSourceMySQLTaskProperties struct {
	// Input - Task input
	Input *ConnectToSourceMySQLTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ConnectToSourceNonSQLTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) MarshalJSON() ([]byte, error) {
	ctsmstp.TaskType = TaskTypeConnectToSourceMySQL
	objectMap := make(map[string]interface{})
	if ctsmstp.Input != nil {
		objectMap["input"] = ctsmstp.Input
	}
	if ctsmstp.ClientData != nil {
		objectMap["clientData"] = ctsmstp.ClientData
	}
	if ctsmstp.TaskType != "" {
		objectMap["taskType"] = ctsmstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return &ctsmstp, true
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &ctsmstp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToSourceMySQLTaskProperties struct.
func (ctsmstp *ConnectToSourceMySQLTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToSourceMySQLTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				ctsmstp.Input = &input
			}
		case "output":
			if v != nil {
				var output []ConnectToSourceNonSQLTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				ctsmstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				ctsmstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				ctsmstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				ctsmstp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				ctsmstp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				ctsmstp.TaskType = taskType
			}
		}
	}

	return nil
}

// ConnectToSourceNonSQLTaskOutput output for connect to MySQL type source
type ConnectToSourceNonSQLTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// SourceServerBrandVersion - READ-ONLY; Server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty"`
	// ServerProperties - READ-ONLY; Server properties
	ServerProperties *ServerProperties `json:"serverProperties,omitempty"`
	// Databases - READ-ONLY; List of databases on the server
	Databases *[]string `json:"databases,omitempty"`
	// ValidationErrors - READ-ONLY; Validation errors associated with the task
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// ConnectToSourceOracleSyncTaskInput input for the task that validates Oracle database connection
type ConnectToSourceOracleSyncTaskInput struct {
	// SourceConnectionInfo - Information for connecting to Oracle source
	SourceConnectionInfo *OracleConnectionInfo `json:"sourceConnectionInfo,omitempty"`
}

// ConnectToSourceOracleSyncTaskOutput output for the task that validates Oracle database connection
type ConnectToSourceOracleSyncTaskOutput struct {
	// SourceServerVersion - READ-ONLY; Version of the source server
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// Databases - READ-ONLY; List of schemas on source server
	Databases *[]string `json:"databases,omitempty"`
	// SourceServerBrandVersion - READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty"`
	// ValidationErrors - READ-ONLY; Validation errors associated with the task
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// ConnectToSourceOracleSyncTaskProperties properties for the task that validates Oracle database
// connection
type ConnectToSourceOracleSyncTaskProperties struct {
	// Input - Task input
	Input *ConnectToSourceOracleSyncTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ConnectToSourceOracleSyncTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) MarshalJSON() ([]byte, error) {
	ctsostp.TaskType = TaskTypeConnectToSourceOracleSync
	objectMap := make(map[string]interface{})
	if ctsostp.Input != nil {
		objectMap["input"] = ctsostp.Input
	}
	if ctsostp.ClientData != nil {
		objectMap["clientData"] = ctsostp.ClientData
	}
	if ctsostp.TaskType != "" {
		objectMap["taskType"] = ctsostp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return &ctsostp, true
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceOracleSyncTaskProperties.
func (ctsostp ConnectToSourceOracleSyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &ctsostp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToSourceOracleSyncTaskProperties struct.
func (ctsostp *ConnectToSourceOracleSyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToSourceOracleSyncTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				ctsostp.Input = &input
			}
		case "output":
			if v != nil {
				var output []ConnectToSourceOracleSyncTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				ctsostp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				ctsostp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				ctsostp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				ctsostp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				ctsostp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				ctsostp.TaskType = taskType
			}
		}
	}

	return nil
}

// ConnectToSourcePostgreSQLSyncTaskInput input for the task that validates connection to PostgreSQL and
// source server requirements
type ConnectToSourcePostgreSQLSyncTaskInput struct {
	// SourceConnectionInfo - Connection information for source PostgreSQL server
	SourceConnectionInfo *PostgreSQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
}

// ConnectToSourcePostgreSQLSyncTaskOutput output for the task that validates connection to PostgreSQL and
// source server requirements
type ConnectToSourcePostgreSQLSyncTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// SourceServerVersion - READ-ONLY; Version of the source server
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// Databases - READ-ONLY; List of databases on source server
	Databases *[]string `json:"databases,omitempty"`
	// SourceServerBrandVersion - READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty"`
	// ValidationErrors - READ-ONLY; Validation errors associated with the task
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// ConnectToSourcePostgreSQLSyncTaskProperties properties for the task that validates connection to
// PostgreSQL server and source server requirements for online migration
type ConnectToSourcePostgreSQLSyncTaskProperties struct {
	// Input - Task input
	Input *ConnectToSourcePostgreSQLSyncTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ConnectToSourcePostgreSQLSyncTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) MarshalJSON() ([]byte, error) {
	ctspsstp.TaskType = TaskTypeConnectToSourcePostgreSQLSync
	objectMap := make(map[string]interface{})
	if ctspsstp.Input != nil {
		objectMap["input"] = ctspsstp.Input
	}
	if ctspsstp.ClientData != nil {
		objectMap["clientData"] = ctspsstp.ClientData
	}
	if ctspsstp.TaskType != "" {
		objectMap["taskType"] = ctspsstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return &ctspsstp, true
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &ctspsstp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToSourcePostgreSQLSyncTaskProperties struct.
func (ctspsstp *ConnectToSourcePostgreSQLSyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToSourcePostgreSQLSyncTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				ctspsstp.Input = &input
			}
		case "output":
			if v != nil {
				var output []ConnectToSourcePostgreSQLSyncTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				ctspsstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				ctspsstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				ctspsstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				ctspsstp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				ctspsstp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				ctspsstp.TaskType = taskType
			}
		}
	}

	return nil
}

// ConnectToSourceSQLServerSyncTaskProperties properties for the task that validates connection to SQL
// Server and source server requirements for online migration
type ConnectToSourceSQLServerSyncTaskProperties struct {
	// Input - Task input
	Input *ConnectToSourceSQLServerTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]BasicConnectToSourceSQLServerTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) MarshalJSON() ([]byte, error) {
	ctsssstp.TaskType = TaskTypeConnectToSourceSQLServerSync
	objectMap := make(map[string]interface{})
	if ctsssstp.Input != nil {
		objectMap["input"] = ctsssstp.Input
	}
	if ctsssstp.ClientData != nil {
		objectMap["clientData"] = ctsssstp.ClientData
	}
	if ctsssstp.TaskType != "" {
		objectMap["taskType"] = ctsssstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return &ctsssstp, true
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &ctsssstp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToSourceSQLServerSyncTaskProperties struct.
func (ctsssstp *ConnectToSourceSQLServerSyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToSourceSQLServerTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				ctsssstp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicConnectToSourceSQLServerTaskOutputArray(*v)
				if err != nil {
					return err
				}
				ctsssstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				ctsssstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				ctsssstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				ctsssstp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				ctsssstp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				ctsssstp.TaskType = taskType
			}
		}
	}

	return nil
}

// ConnectToSourceSQLServerTaskInput input for the task that validates connection to SQL Server and also
// validates source server requirements
type ConnectToSourceSQLServerTaskInput struct {
	// SourceConnectionInfo - Connection information for Source SQL Server
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// CheckPermissionsGroup - Permission group for validations. Possible values include: 'Default', 'MigrationFromSQLServerToAzureDB', 'MigrationFromSQLServerToAzureMI', 'MigrationFromMySQLToAzureDBForMySQL'
	CheckPermissionsGroup ServerLevelPermissionsGroup `json:"checkPermissionsGroup,omitempty"`
	// CollectDatabases - Flag for whether to collect databases from source server.
	CollectDatabases *bool `json:"collectDatabases,omitempty"`
	// CollectLogins - Flag for whether to collect logins from source server.
	CollectLogins *bool `json:"collectLogins,omitempty"`
	// CollectAgentJobs - Flag for whether to collect agent jobs from source server.
	CollectAgentJobs *bool `json:"collectAgentJobs,omitempty"`
	// CollectTdeCertificateInfo - Flag for whether to collect TDE Certificate names from source server.
	CollectTdeCertificateInfo *bool `json:"collectTdeCertificateInfo,omitempty"`
	// ValidateSsisCatalogOnly - Flag for whether to validate SSIS catalog is reachable on the source server.
	ValidateSsisCatalogOnly *bool `json:"validateSsisCatalogOnly,omitempty"`
}

// BasicConnectToSourceSQLServerTaskOutput output for the task that validates connection to SQL Server and also
// validates source server requirements
type BasicConnectToSourceSQLServerTaskOutput interface {
	AsConnectToSourceSQLServerTaskOutputAgentJobLevel() (*ConnectToSourceSQLServerTaskOutputAgentJobLevel, bool)
	AsConnectToSourceSQLServerTaskOutputLoginLevel() (*ConnectToSourceSQLServerTaskOutputLoginLevel, bool)
	AsConnectToSourceSQLServerTaskOutputDatabaseLevel() (*ConnectToSourceSQLServerTaskOutputDatabaseLevel, bool)
	AsConnectToSourceSQLServerTaskOutputTaskLevel() (*ConnectToSourceSQLServerTaskOutputTaskLevel, bool)
	AsConnectToSourceSQLServerTaskOutput() (*ConnectToSourceSQLServerTaskOutput, bool)
}

// ConnectToSourceSQLServerTaskOutput output for the task that validates connection to SQL Server and also
// validates source server requirements
type ConnectToSourceSQLServerTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeConnectToSourceSQLServerTaskOutput', 'ResultTypeAgentJobLevelOutput', 'ResultTypeLoginLevelOutput', 'ResultTypeDatabaseLevelOutput', 'ResultTypeTaskLevelOutput'
	ResultType ResultTypeBasicConnectToSourceSQLServerTaskOutput `json:"resultType,omitempty"`
}

func unmarshalBasicConnectToSourceSQLServerTaskOutput(body []byte) (BasicConnectToSourceSQLServerTaskOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resultType"] {
	case string(ResultTypeAgentJobLevelOutput):
		var ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel
		err := json.Unmarshal(body, &ctssstoajl)
		return ctssstoajl, err
	case string(ResultTypeLoginLevelOutput):
		var ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel
		err := json.Unmarshal(body, &ctssstoll)
		return ctssstoll, err
	case string(ResultTypeDatabaseLevelOutput):
		var ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel
		err := json.Unmarshal(body, &ctssstodl)
		return ctssstodl, err
	case string(ResultTypeTaskLevelOutput):
		var ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel
		err := json.Unmarshal(body, &ctssstotl)
		return ctssstotl, err
	default:
		var ctsssto ConnectToSourceSQLServerTaskOutput
		err := json.Unmarshal(body, &ctsssto)
		return ctsssto, err
	}
}
func unmarshalBasicConnectToSourceSQLServerTaskOutputArray(body []byte) ([]BasicConnectToSourceSQLServerTaskOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ctssstoArray := make([]BasicConnectToSourceSQLServerTaskOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ctsssto, err := unmarshalBasicConnectToSourceSQLServerTaskOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		ctssstoArray[index] = ctsssto
	}
	return ctssstoArray, nil
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) MarshalJSON() ([]byte, error) {
	ctsssto.ResultType = ResultTypeConnectToSourceSQLServerTaskOutput
	objectMap := make(map[string]interface{})
	if ctsssto.ResultType != "" {
		objectMap["resultType"] = ctsssto.ResultType
	}
	return json.Marshal(objectMap)
}

// AsConnectToSourceSQLServerTaskOutputAgentJobLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) AsConnectToSourceSQLServerTaskOutputAgentJobLevel() (*ConnectToSourceSQLServerTaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputLoginLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) AsConnectToSourceSQLServerTaskOutputLoginLevel() (*ConnectToSourceSQLServerTaskOutputLoginLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputDatabaseLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) AsConnectToSourceSQLServerTaskOutputDatabaseLevel() (*ConnectToSourceSQLServerTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputTaskLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) AsConnectToSourceSQLServerTaskOutputTaskLevel() (*ConnectToSourceSQLServerTaskOutputTaskLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) AsConnectToSourceSQLServerTaskOutput() (*ConnectToSourceSQLServerTaskOutput, bool) {
	return &ctsssto, true
}

// AsBasicConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) AsBasicConnectToSourceSQLServerTaskOutput() (BasicConnectToSourceSQLServerTaskOutput, bool) {
	return &ctsssto, true
}

// ConnectToSourceSQLServerTaskOutputAgentJobLevel agent Job level output for the task that validates
// connection to SQL Server and also validates source server requirements
type ConnectToSourceSQLServerTaskOutputAgentJobLevel struct {
	// Name - READ-ONLY; Agent Job name
	Name *string `json:"name,omitempty"`
	// JobCategory - READ-ONLY; The type of Agent Job.
	JobCategory *string `json:"jobCategory,omitempty"`
	// IsEnabled - READ-ONLY; The state of the original Agent Job.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// JobOwner - READ-ONLY; The owner of the Agent Job
	JobOwner *string `json:"jobOwner,omitempty"`
	// LastExecutedOn - READ-ONLY; UTC Date and time when the Agent Job was last executed.
	LastExecutedOn *date.Time `json:"lastExecutedOn,omitempty"`
	// ValidationErrors - READ-ONLY; Validation errors
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
	// MigrationEligibility - READ-ONLY; Information about eligibility of agent job for migration.
	MigrationEligibility *MigrationEligibilityInfo `json:"migrationEligibility,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeConnectToSourceSQLServerTaskOutput', 'ResultTypeAgentJobLevelOutput', 'ResultTypeLoginLevelOutput', 'ResultTypeDatabaseLevelOutput', 'ResultTypeTaskLevelOutput'
	ResultType ResultTypeBasicConnectToSourceSQLServerTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel) MarshalJSON() ([]byte, error) {
	ctssstoajl.ResultType = ResultTypeAgentJobLevelOutput
	objectMap := make(map[string]interface{})
	if ctssstoajl.ResultType != "" {
		objectMap["resultType"] = ctssstoajl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsConnectToSourceSQLServerTaskOutputAgentJobLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel) AsConnectToSourceSQLServerTaskOutputAgentJobLevel() (*ConnectToSourceSQLServerTaskOutputAgentJobLevel, bool) {
	return &ctssstoajl, true
}

// AsConnectToSourceSQLServerTaskOutputLoginLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel) AsConnectToSourceSQLServerTaskOutputLoginLevel() (*ConnectToSourceSQLServerTaskOutputLoginLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputDatabaseLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel) AsConnectToSourceSQLServerTaskOutputDatabaseLevel() (*ConnectToSourceSQLServerTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputTaskLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel) AsConnectToSourceSQLServerTaskOutputTaskLevel() (*ConnectToSourceSQLServerTaskOutputTaskLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel) AsConnectToSourceSQLServerTaskOutput() (*ConnectToSourceSQLServerTaskOutput, bool) {
	return nil, false
}

// AsBasicConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel) AsBasicConnectToSourceSQLServerTaskOutput() (BasicConnectToSourceSQLServerTaskOutput, bool) {
	return &ctssstoajl, true
}

// ConnectToSourceSQLServerTaskOutputDatabaseLevel database level output for the task that validates
// connection to SQL Server and also validates source server requirements
type ConnectToSourceSQLServerTaskOutputDatabaseLevel struct {
	// Name - READ-ONLY; Database name
	Name *string `json:"name,omitempty"`
	// SizeMB - READ-ONLY; Size of the file in megabytes
	SizeMB *float64 `json:"sizeMB,omitempty"`
	// DatabaseFiles - READ-ONLY; The list of database files
	DatabaseFiles *[]DatabaseFileInfo `json:"databaseFiles,omitempty"`
	// CompatibilityLevel - READ-ONLY; SQL Server compatibility level of database. Possible values include: 'CompatLevel80', 'CompatLevel90', 'CompatLevel100', 'CompatLevel110', 'CompatLevel120', 'CompatLevel130', 'CompatLevel140'
	CompatibilityLevel DatabaseCompatLevel `json:"compatibilityLevel,omitempty"`
	// DatabaseState - READ-ONLY; State of the database. Possible values include: 'DatabaseStateOnline', 'DatabaseStateRestoring', 'DatabaseStateRecovering', 'DatabaseStateRecoveryPending', 'DatabaseStateSuspect', 'DatabaseStateEmergency', 'DatabaseStateOffline', 'DatabaseStateCopying', 'DatabaseStateOfflineSecondary'
	DatabaseState DatabaseState `json:"databaseState,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeConnectToSourceSQLServerTaskOutput', 'ResultTypeAgentJobLevelOutput', 'ResultTypeLoginLevelOutput', 'ResultTypeDatabaseLevelOutput', 'ResultTypeTaskLevelOutput'
	ResultType ResultTypeBasicConnectToSourceSQLServerTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	ctssstodl.ResultType = ResultTypeDatabaseLevelOutput
	objectMap := make(map[string]interface{})
	if ctssstodl.ResultType != "" {
		objectMap["resultType"] = ctssstodl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsConnectToSourceSQLServerTaskOutputAgentJobLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) AsConnectToSourceSQLServerTaskOutputAgentJobLevel() (*ConnectToSourceSQLServerTaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputLoginLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) AsConnectToSourceSQLServerTaskOutputLoginLevel() (*ConnectToSourceSQLServerTaskOutputLoginLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputDatabaseLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) AsConnectToSourceSQLServerTaskOutputDatabaseLevel() (*ConnectToSourceSQLServerTaskOutputDatabaseLevel, bool) {
	return &ctssstodl, true
}

// AsConnectToSourceSQLServerTaskOutputTaskLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) AsConnectToSourceSQLServerTaskOutputTaskLevel() (*ConnectToSourceSQLServerTaskOutputTaskLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) AsConnectToSourceSQLServerTaskOutput() (*ConnectToSourceSQLServerTaskOutput, bool) {
	return nil, false
}

// AsBasicConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) AsBasicConnectToSourceSQLServerTaskOutput() (BasicConnectToSourceSQLServerTaskOutput, bool) {
	return &ctssstodl, true
}

// ConnectToSourceSQLServerTaskOutputLoginLevel login level output for the task that validates connection
// to SQL Server and also validates source server requirements
type ConnectToSourceSQLServerTaskOutputLoginLevel struct {
	// Name - READ-ONLY; Login name.
	Name *string `json:"name,omitempty"`
	// LoginType - READ-ONLY; The type of login. Possible values include: 'WindowsUser', 'WindowsGroup', 'SQLLogin', 'Certificate', 'AsymmetricKey', 'ExternalUser', 'ExternalGroup'
	LoginType LoginType `json:"loginType,omitempty"`
	// DefaultDatabase - READ-ONLY; The default database for the login.
	DefaultDatabase *string `json:"defaultDatabase,omitempty"`
	// IsEnabled - READ-ONLY; The state of the login.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// MigrationEligibility - READ-ONLY; Information about eligibility of login for migration.
	MigrationEligibility *MigrationEligibilityInfo `json:"migrationEligibility,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeConnectToSourceSQLServerTaskOutput', 'ResultTypeAgentJobLevelOutput', 'ResultTypeLoginLevelOutput', 'ResultTypeDatabaseLevelOutput', 'ResultTypeTaskLevelOutput'
	ResultType ResultTypeBasicConnectToSourceSQLServerTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerTaskOutputLoginLevel.
func (ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel) MarshalJSON() ([]byte, error) {
	ctssstoll.ResultType = ResultTypeLoginLevelOutput
	objectMap := make(map[string]interface{})
	if ctssstoll.ResultType != "" {
		objectMap["resultType"] = ctssstoll.ResultType
	}
	return json.Marshal(objectMap)
}

// AsConnectToSourceSQLServerTaskOutputAgentJobLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputLoginLevel.
func (ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel) AsConnectToSourceSQLServerTaskOutputAgentJobLevel() (*ConnectToSourceSQLServerTaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputLoginLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputLoginLevel.
func (ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel) AsConnectToSourceSQLServerTaskOutputLoginLevel() (*ConnectToSourceSQLServerTaskOutputLoginLevel, bool) {
	return &ctssstoll, true
}

// AsConnectToSourceSQLServerTaskOutputDatabaseLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputLoginLevel.
func (ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel) AsConnectToSourceSQLServerTaskOutputDatabaseLevel() (*ConnectToSourceSQLServerTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputTaskLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputLoginLevel.
func (ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel) AsConnectToSourceSQLServerTaskOutputTaskLevel() (*ConnectToSourceSQLServerTaskOutputTaskLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputLoginLevel.
func (ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel) AsConnectToSourceSQLServerTaskOutput() (*ConnectToSourceSQLServerTaskOutput, bool) {
	return nil, false
}

// AsBasicConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputLoginLevel.
func (ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel) AsBasicConnectToSourceSQLServerTaskOutput() (BasicConnectToSourceSQLServerTaskOutput, bool) {
	return &ctssstoll, true
}

// ConnectToSourceSQLServerTaskOutputTaskLevel task level output for the task that validates connection to
// SQL Server and also validates source server requirements
type ConnectToSourceSQLServerTaskOutputTaskLevel struct {
	// Databases - READ-ONLY; Source databases as a map from database name to database id
	Databases map[string]*string `json:"databases"`
	// Logins - READ-ONLY; Source logins as a map from login name to login id.
	Logins map[string]*string `json:"logins"`
	// AgentJobs - READ-ONLY; Source agent jobs as a map from agent job name to id.
	AgentJobs map[string]*string `json:"agentJobs"`
	// DatabaseTdeCertificateMapping - READ-ONLY; Mapping from database name to TDE certificate name, if applicable
	DatabaseTdeCertificateMapping map[string]*string `json:"databaseTdeCertificateMapping"`
	// SourceServerVersion - READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// SourceServerBrandVersion - READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty"`
	// ValidationErrors - READ-ONLY; Validation errors
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeConnectToSourceSQLServerTaskOutput', 'ResultTypeAgentJobLevelOutput', 'ResultTypeLoginLevelOutput', 'ResultTypeDatabaseLevelOutput', 'ResultTypeTaskLevelOutput'
	ResultType ResultTypeBasicConnectToSourceSQLServerTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) MarshalJSON() ([]byte, error) {
	ctssstotl.ResultType = ResultTypeTaskLevelOutput
	objectMap := make(map[string]interface{})
	if ctssstotl.ResultType != "" {
		objectMap["resultType"] = ctssstotl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsConnectToSourceSQLServerTaskOutputAgentJobLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) AsConnectToSourceSQLServerTaskOutputAgentJobLevel() (*ConnectToSourceSQLServerTaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputLoginLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) AsConnectToSourceSQLServerTaskOutputLoginLevel() (*ConnectToSourceSQLServerTaskOutputLoginLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputDatabaseLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) AsConnectToSourceSQLServerTaskOutputDatabaseLevel() (*ConnectToSourceSQLServerTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputTaskLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) AsConnectToSourceSQLServerTaskOutputTaskLevel() (*ConnectToSourceSQLServerTaskOutputTaskLevel, bool) {
	return &ctssstotl, true
}

// AsConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) AsConnectToSourceSQLServerTaskOutput() (*ConnectToSourceSQLServerTaskOutput, bool) {
	return nil, false
}

// AsBasicConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) AsBasicConnectToSourceSQLServerTaskOutput() (BasicConnectToSourceSQLServerTaskOutput, bool) {
	return &ctssstotl, true
}

// ConnectToSourceSQLServerTaskProperties properties for the task that validates connection to SQL Server
// and also validates source server requirements
type ConnectToSourceSQLServerTaskProperties struct {
	// Input - Task input
	Input *ConnectToSourceSQLServerTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]BasicConnectToSourceSQLServerTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) MarshalJSON() ([]byte, error) {
	ctssstp.TaskType = TaskTypeConnectToSourceSQLServer
	objectMap := make(map[string]interface{})
	if ctssstp.Input != nil {
		objectMap["input"] = ctssstp.Input
	}
	if ctssstp.ClientData != nil {
		objectMap["clientData"] = ctssstp.ClientData
	}
	if ctssstp.TaskType != "" {
		objectMap["taskType"] = ctssstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return &ctssstp, true
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &ctssstp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToSourceSQLServerTaskProperties struct.
func (ctssstp *ConnectToSourceSQLServerTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToSourceSQLServerTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				ctssstp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicConnectToSourceSQLServerTaskOutputArray(*v)
				if err != nil {
					return err
				}
				ctssstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				ctssstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				ctssstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				ctssstp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				ctssstp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				ctssstp.TaskType = taskType
			}
		}
	}

	return nil
}

// ConnectToTargetAzureDbForMySQLTaskInput input for the task that validates connection to Azure Database
// for MySQL and target server requirements
type ConnectToTargetAzureDbForMySQLTaskInput struct {
	// SourceConnectionInfo - Connection information for source MySQL server
	SourceConnectionInfo *MySQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Connection information for target Azure Database for MySQL server
	TargetConnectionInfo *MySQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// ConnectToTargetAzureDbForMySQLTaskOutput output for the task that validates connection to Azure Database
// for MySQL and target server requirements
type ConnectToTargetAzureDbForMySQLTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ServerVersion - READ-ONLY; Version of the target server
	ServerVersion *string `json:"serverVersion,omitempty"`
	// Databases - READ-ONLY; List of databases on target server
	Databases *[]string `json:"databases,omitempty"`
	// TargetServerBrandVersion - READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
	// ValidationErrors - READ-ONLY; Validation errors associated with the task
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// ConnectToTargetAzureDbForMySQLTaskProperties properties for the task that validates connection to Azure
// Database for MySQL and target server requirements
type ConnectToTargetAzureDbForMySQLTaskProperties struct {
	// Input - Task input
	Input *ConnectToTargetAzureDbForMySQLTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ConnectToTargetAzureDbForMySQLTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) MarshalJSON() ([]byte, error) {
	cttadfmstp.TaskType = TaskTypeConnectToTargetAzureDbForMySQL
	objectMap := make(map[string]interface{})
	if cttadfmstp.Input != nil {
		objectMap["input"] = cttadfmstp.Input
	}
	if cttadfmstp.ClientData != nil {
		objectMap["clientData"] = cttadfmstp.ClientData
	}
	if cttadfmstp.TaskType != "" {
		objectMap["taskType"] = cttadfmstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return &cttadfmstp, true
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &cttadfmstp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToTargetAzureDbForMySQLTaskProperties struct.
func (cttadfmstp *ConnectToTargetAzureDbForMySQLTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToTargetAzureDbForMySQLTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				cttadfmstp.Input = &input
			}
		case "output":
			if v != nil {
				var output []ConnectToTargetAzureDbForMySQLTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				cttadfmstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				cttadfmstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				cttadfmstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				cttadfmstp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				cttadfmstp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				cttadfmstp.TaskType = taskType
			}
		}
	}

	return nil
}

// ConnectToTargetAzureDbForPostgreSQLSyncTaskInput input for the task that validates connection to Azure
// Database for PostgreSQL and target server requirements
type ConnectToTargetAzureDbForPostgreSQLSyncTaskInput struct {
	// SourceConnectionInfo - Connection information for source PostgreSQL server
	SourceConnectionInfo *PostgreSQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Connection information for target Azure Database for PostgreSQL server
	TargetConnectionInfo *PostgreSQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// ConnectToTargetAzureDbForPostgreSQLSyncTaskOutput output for the task that validates connection to Azure
// Database for PostgreSQL and target server requirements
type ConnectToTargetAzureDbForPostgreSQLSyncTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// TargetServerVersion - READ-ONLY; Version of the target server
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// Databases - READ-ONLY; List of databases on target server
	Databases *[]string `json:"databases,omitempty"`
	// TargetServerBrandVersion - READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
	// ValidationErrors - READ-ONLY; Validation errors associated with the task
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties properties for the task that validates connection
// to Azure Database For PostgreSQL server and target server requirements for online migration
type ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties struct {
	// Input - Task input
	Input *ConnectToTargetAzureDbForPostgreSQLSyncTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ConnectToTargetAzureDbForPostgreSQLSyncTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) MarshalJSON() ([]byte, error) {
	cttadfpsstp.TaskType = TaskTypeConnectToTargetAzureDbForPostgreSQLSync
	objectMap := make(map[string]interface{})
	if cttadfpsstp.Input != nil {
		objectMap["input"] = cttadfpsstp.Input
	}
	if cttadfpsstp.ClientData != nil {
		objectMap["clientData"] = cttadfpsstp.ClientData
	}
	if cttadfpsstp.TaskType != "" {
		objectMap["taskType"] = cttadfpsstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return &cttadfpsstp, true
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &cttadfpsstp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties struct.
func (cttadfpsstp *ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToTargetAzureDbForPostgreSQLSyncTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				cttadfpsstp.Input = &input
			}
		case "output":
			if v != nil {
				var output []ConnectToTargetAzureDbForPostgreSQLSyncTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				cttadfpsstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				cttadfpsstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				cttadfpsstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				cttadfpsstp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				cttadfpsstp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				cttadfpsstp.TaskType = taskType
			}
		}
	}

	return nil
}

// ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskInput input for the task that validates connection to
// Azure Database for PostgreSQL and target server requirements for Oracle source.
type ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskInput struct {
	// TargetConnectionInfo - Connection information for target Azure Database for PostgreSQL server
	TargetConnectionInfo *PostgreSQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutput output for the task that validates connection to
// Azure Database for PostgreSQL and target server requirements for Oracle source.
type ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutput struct {
	// TargetServerVersion - READ-ONLY; Version of the target server
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// Databases - READ-ONLY; List of databases on target server
	Databases *[]string `json:"databases,omitempty"`
	// TargetServerBrandVersion - READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
	// ValidationErrors - READ-ONLY; Validation errors associated with the task
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
	// DatabaseSchemaMap - Mapping of schemas per database
	DatabaseSchemaMap *[]ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutputDatabaseSchemaMapItem `json:"databaseSchemaMap,omitempty"`
}

// ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutputDatabaseSchemaMapItem ...
type ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutputDatabaseSchemaMapItem struct {
	Database *string   `json:"database,omitempty"`
	Schemas  *[]string `json:"schemas,omitempty"`
}

// ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties properties for the task that validates
// connection to Azure Database For PostgreSQL server and target server requirements for online migration
// for Oracle source.
type ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties struct {
	// Input - Task input
	Input *ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) MarshalJSON() ([]byte, error) {
	cttoadfpsstp.TaskType = TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync
	objectMap := make(map[string]interface{})
	if cttoadfpsstp.Input != nil {
		objectMap["input"] = cttoadfpsstp.Input
	}
	if cttoadfpsstp.ClientData != nil {
		objectMap["clientData"] = cttoadfpsstp.ClientData
	}
	if cttoadfpsstp.TaskType != "" {
		objectMap["taskType"] = cttoadfpsstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return &cttoadfpsstp, true
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &cttoadfpsstp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties struct.
func (cttoadfpsstp *ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				cttoadfpsstp.Input = &input
			}
		case "output":
			if v != nil {
				var output []ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				cttoadfpsstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				cttoadfpsstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				cttoadfpsstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				cttoadfpsstp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				cttoadfpsstp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				cttoadfpsstp.TaskType = taskType
			}
		}
	}

	return nil
}

// ConnectToTargetSQLDbTaskInput input for the task that validates connection to SQL DB and target server
// requirements
type ConnectToTargetSQLDbTaskInput struct {
	// TargetConnectionInfo - Connection information for target SQL DB
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// ConnectToTargetSQLDbTaskOutput output for the task that validates connection to SQL DB and target server
// requirements
type ConnectToTargetSQLDbTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// Databases - READ-ONLY; Source databases as a map from database name to database id
	Databases map[string]*string `json:"databases"`
	// TargetServerVersion - READ-ONLY; Version of the target server
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServerBrandVersion - READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToTargetSQLDbTaskOutput.
func (cttsdto ConnectToTargetSQLDbTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ConnectToTargetSQLDbTaskProperties properties for the task that validates connection to SQL DB and
// target server requirements
type ConnectToTargetSQLDbTaskProperties struct {
	// Input - Task input
	Input *ConnectToTargetSQLDbTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ConnectToTargetSQLDbTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) MarshalJSON() ([]byte, error) {
	cttsdtp.TaskType = TaskTypeConnectToTargetSQLDb
	objectMap := make(map[string]interface{})
	if cttsdtp.Input != nil {
		objectMap["input"] = cttsdtp.Input
	}
	if cttsdtp.ClientData != nil {
		objectMap["clientData"] = cttsdtp.ClientData
	}
	if cttsdtp.TaskType != "" {
		objectMap["taskType"] = cttsdtp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return &cttsdtp, true
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &cttsdtp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToTargetSQLDbTaskProperties struct.
func (cttsdtp *ConnectToTargetSQLDbTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToTargetSQLDbTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				cttsdtp.Input = &input
			}
		case "output":
			if v != nil {
				var output []ConnectToTargetSQLDbTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				cttsdtp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				cttsdtp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				cttsdtp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				cttsdtp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				cttsdtp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				cttsdtp.TaskType = taskType
			}
		}
	}

	return nil
}

// ConnectToTargetSQLMISyncTaskInput input for the task that validates connection to Azure SQL Database
// Managed Instance online scenario.
type ConnectToTargetSQLMISyncTaskInput struct {
	// TargetConnectionInfo - Connection information for Azure SQL Database Managed Instance
	TargetConnectionInfo *MiSQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
	// AzureApp - Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
	AzureApp *AzureActiveDirectoryApp `json:"azureApp,omitempty"`
}

// ConnectToTargetSQLMISyncTaskOutput output for the task that validates connection to Azure SQL Database
// Managed Instance.
type ConnectToTargetSQLMISyncTaskOutput struct {
	// TargetServerVersion - READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServerBrandVersion - READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
	// ValidationErrors - READ-ONLY; Validation errors
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// ConnectToTargetSQLMISyncTaskProperties properties for the task that validates connection to Azure SQL
// Database Managed Instance
type ConnectToTargetSQLMISyncTaskProperties struct {
	// Input - Task input
	Input *ConnectToTargetSQLMISyncTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ConnectToTargetSQLMISyncTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) MarshalJSON() ([]byte, error) {
	cttsmstp.TaskType = TaskTypeConnectToTargetAzureSQLDbMISyncLRS
	objectMap := make(map[string]interface{})
	if cttsmstp.Input != nil {
		objectMap["input"] = cttsmstp.Input
	}
	if cttsmstp.ClientData != nil {
		objectMap["clientData"] = cttsmstp.ClientData
	}
	if cttsmstp.TaskType != "" {
		objectMap["taskType"] = cttsmstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return &cttsmstp, true
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &cttsmstp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToTargetSQLMISyncTaskProperties struct.
func (cttsmstp *ConnectToTargetSQLMISyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToTargetSQLMISyncTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				cttsmstp.Input = &input
			}
		case "output":
			if v != nil {
				var output []ConnectToTargetSQLMISyncTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				cttsmstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				cttsmstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				cttsmstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				cttsmstp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				cttsmstp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				cttsmstp.TaskType = taskType
			}
		}
	}

	return nil
}

// ConnectToTargetSQLMITaskInput input for the task that validates connection to Azure SQL Database Managed
// Instance.
type ConnectToTargetSQLMITaskInput struct {
	// TargetConnectionInfo - Connection information for target SQL Server
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
	// CollectLogins - Flag for whether to collect logins from target SQL MI server.
	CollectLogins *bool `json:"collectLogins,omitempty"`
	// CollectAgentJobs - Flag for whether to collect agent jobs from target SQL MI server.
	CollectAgentJobs *bool `json:"collectAgentJobs,omitempty"`
	// ValidateSsisCatalogOnly - Flag for whether to validate SSIS catalog is reachable on the target SQL MI server.
	ValidateSsisCatalogOnly *bool `json:"validateSsisCatalogOnly,omitempty"`
}

// ConnectToTargetSQLMITaskOutput output for the task that validates connection to Azure SQL Database
// Managed Instance.
type ConnectToTargetSQLMITaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// TargetServerVersion - READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServerBrandVersion - READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
	// Logins - READ-ONLY; List of logins on the target server.
	Logins *[]string `json:"logins,omitempty"`
	// AgentJobs - READ-ONLY; List of agent jobs on the target server.
	AgentJobs *[]string `json:"agentJobs,omitempty"`
	// ValidationErrors - READ-ONLY; Validation errors
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// ConnectToTargetSQLMITaskProperties properties for the task that validates connection to Azure SQL
// Database Managed Instance
type ConnectToTargetSQLMITaskProperties struct {
	// Input - Task input
	Input *ConnectToTargetSQLMITaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ConnectToTargetSQLMITaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) MarshalJSON() ([]byte, error) {
	cttsmtp.TaskType = TaskTypeConnectToTargetAzureSQLDbMI
	objectMap := make(map[string]interface{})
	if cttsmtp.Input != nil {
		objectMap["input"] = cttsmtp.Input
	}
	if cttsmtp.ClientData != nil {
		objectMap["clientData"] = cttsmtp.ClientData
	}
	if cttsmtp.TaskType != "" {
		objectMap["taskType"] = cttsmtp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return &cttsmtp, true
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &cttsmtp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToTargetSQLMITaskProperties struct.
func (cttsmtp *ConnectToTargetSQLMITaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToTargetSQLMITaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				cttsmtp.Input = &input
			}
		case "output":
			if v != nil {
				var output []ConnectToTargetSQLMITaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				cttsmtp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				cttsmtp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				cttsmtp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				cttsmtp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				cttsmtp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				cttsmtp.TaskType = taskType
			}
		}
	}

	return nil
}

// ConnectToTargetSQLSQLDbSyncTaskInput input for the task that validates connection to Azure SQL DB and
// target server requirements
type ConnectToTargetSQLSQLDbSyncTaskInput struct {
	// SourceConnectionInfo - Connection information for source SQL Server
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Connection information for target SQL DB
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// ConnectToTargetSQLSQLDbSyncTaskProperties properties for the task that validates connection to SQL DB
// and target server requirements for online migration
type ConnectToTargetSQLSQLDbSyncTaskProperties struct {
	// Input - Task input
	Input *ConnectToTargetSQLSQLDbSyncTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ConnectToTargetSQLDbTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) MarshalJSON() ([]byte, error) {
	cttssdstp.TaskType = TaskTypeConnectToTargetSQLDbSync
	objectMap := make(map[string]interface{})
	if cttssdstp.Input != nil {
		objectMap["input"] = cttssdstp.Input
	}
	if cttssdstp.ClientData != nil {
		objectMap["clientData"] = cttssdstp.ClientData
	}
	if cttssdstp.TaskType != "" {
		objectMap["taskType"] = cttssdstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return &cttssdstp, true
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &cttssdstp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToTargetSQLSQLDbSyncTaskProperties struct.
func (cttssdstp *ConnectToTargetSQLSQLDbSyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToTargetSQLSQLDbSyncTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				cttssdstp.Input = &input
			}
		case "output":
			if v != nil {
				var output []ConnectToTargetSQLDbTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				cttssdstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				cttssdstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				cttssdstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				cttssdstp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				cttssdstp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				cttssdstp.TaskType = taskType
			}
		}
	}

	return nil
}

// Database information about a single database
type Database struct {
	// ID - Unique identifier for the database
	ID *string `json:"id,omitempty"`
	// Name - Name of the database
	Name *string `json:"name,omitempty"`
	// CompatibilityLevel - SQL Server compatibility level of database. Possible values include: 'CompatLevel80', 'CompatLevel90', 'CompatLevel100', 'CompatLevel110', 'CompatLevel120', 'CompatLevel130', 'CompatLevel140'
	CompatibilityLevel DatabaseCompatLevel `json:"compatibilityLevel,omitempty"`
	// Collation - Collation name of the database
	Collation *string `json:"collation,omitempty"`
	// ServerName - Name of the server
	ServerName *string `json:"serverName,omitempty"`
	// Fqdn - Fully qualified name
	Fqdn *string `json:"fqdn,omitempty"`
	// InstallID - Install id of the database
	InstallID *string `json:"installId,omitempty"`
	// ServerVersion - Version of the server
	ServerVersion *string `json:"serverVersion,omitempty"`
	// ServerEdition - Edition of the server
	ServerEdition *string `json:"serverEdition,omitempty"`
	// ServerLevel - Product level of the server (RTM, SP, CTP).
	ServerLevel *string `json:"serverLevel,omitempty"`
	// ServerDefaultDataPath - Default path of the data files
	ServerDefaultDataPath *string `json:"serverDefaultDataPath,omitempty"`
	// ServerDefaultLogPath - Default path of the log files
	ServerDefaultLogPath *string `json:"serverDefaultLogPath,omitempty"`
	// ServerDefaultBackupPath - Default path of the backup folder
	ServerDefaultBackupPath *string `json:"serverDefaultBackupPath,omitempty"`
	// ServerCoreCount - Number of cores on the server
	ServerCoreCount *int32 `json:"serverCoreCount,omitempty"`
	// ServerVisibleOnlineCoreCount - Number of cores on the server that have VISIBLE ONLINE status
	ServerVisibleOnlineCoreCount *int32 `json:"serverVisibleOnlineCoreCount,omitempty"`
	// DatabaseState - State of the database. Possible values include: 'DatabaseStateOnline', 'DatabaseStateRestoring', 'DatabaseStateRecovering', 'DatabaseStateRecoveryPending', 'DatabaseStateSuspect', 'DatabaseStateEmergency', 'DatabaseStateOffline', 'DatabaseStateCopying', 'DatabaseStateOfflineSecondary'
	DatabaseState DatabaseState `json:"databaseState,omitempty"`
	// ServerID - The unique Server Id
	ServerID *string `json:"serverId,omitempty"`
}

// DatabaseBackupInfo information about backup files when existing backup mode is used.
type DatabaseBackupInfo struct {
	// DatabaseName - READ-ONLY; Database name.
	DatabaseName *string `json:"databaseName,omitempty"`
	// BackupType - READ-ONLY; Backup Type. Possible values include: 'BackupTypeDatabase', 'BackupTypeTransactionLog', 'BackupTypeFile', 'BackupTypeDifferentialDatabase', 'BackupTypeDifferentialFile', 'BackupTypePartial', 'BackupTypeDifferentialPartial'
	BackupType BackupType `json:"backupType,omitempty"`
	// BackupFiles - READ-ONLY; The list of backup files for the current database.
	BackupFiles *[]string `json:"backupFiles,omitempty"`
	// Position - READ-ONLY; Position of current database backup in the file.
	Position *int32 `json:"position,omitempty"`
	// IsDamaged - READ-ONLY; Database was damaged when backed up, but the backup operation was requested to continue despite errors.
	IsDamaged *bool `json:"isDamaged,omitempty"`
	// IsCompressed - READ-ONLY; Whether the backup set is compressed
	IsCompressed *bool `json:"isCompressed,omitempty"`
	// FamilyCount - READ-ONLY; Number of files in the backup set.
	FamilyCount *int32 `json:"familyCount,omitempty"`
	// BackupFinishDate - READ-ONLY; Date and time when the backup operation finished.
	BackupFinishDate *date.Time `json:"backupFinishDate,omitempty"`
}

// DatabaseFileInfo database file specific information
type DatabaseFileInfo struct {
	// DatabaseName - Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// ID - Unique identifier for database file
	ID *string `json:"id,omitempty"`
	// LogicalName - Logical name of the file
	LogicalName *string `json:"logicalName,omitempty"`
	// PhysicalFullName - Operating-system full path of the file
	PhysicalFullName *string `json:"physicalFullName,omitempty"`
	// RestoreFullName - Suggested full path of the file for restoring
	RestoreFullName *string `json:"restoreFullName,omitempty"`
	// FileType - Database file type. Possible values include: 'Rows', 'Log', 'Filestream', 'NotSupported', 'Fulltext'
	FileType DatabaseFileType `json:"fileType,omitempty"`
	// SizeMB - Size of the file in megabytes
	SizeMB *float64 `json:"sizeMB,omitempty"`
}

// DatabaseFileInput database file specific information for input
type DatabaseFileInput struct {
	// ID - Unique identifier for database file
	ID *string `json:"id,omitempty"`
	// LogicalName - Logical name of the file
	LogicalName *string `json:"logicalName,omitempty"`
	// PhysicalFullName - Operating-system full path of the file
	PhysicalFullName *string `json:"physicalFullName,omitempty"`
	// RestoreFullName - Suggested full path of the file for restoring
	RestoreFullName *string `json:"restoreFullName,omitempty"`
	// FileType - Database file type. Possible values include: 'Rows', 'Log', 'Filestream', 'NotSupported', 'Fulltext'
	FileType DatabaseFileType `json:"fileType,omitempty"`
}

// DatabaseInfo project Database Details
type DatabaseInfo struct {
	// SourceDatabaseName - Name of the database
	SourceDatabaseName *string `json:"sourceDatabaseName,omitempty"`
}

// DatabaseObjectName a representation of the name of an object in a database
type DatabaseObjectName struct {
	// DatabaseName - READ-ONLY; The unescaped name of the database containing the object
	DatabaseName *string `json:"databaseName,omitempty"`
	// ObjectName - READ-ONLY; The unescaped name of the object
	ObjectName *string `json:"objectName,omitempty"`
	// SchemaName - READ-ONLY; The unescaped name of the schema containing the object
	SchemaName *string `json:"schemaName,omitempty"`
	// ObjectType - Type of the object in the database. Possible values include: 'StoredProcedures', 'Table', 'User', 'View', 'Function'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

// DatabaseSummaryResult summary of database results in the migration
type DatabaseSummaryResult struct {
	// SizeMB - READ-ONLY; Size of the database in megabytes
	SizeMB *float64 `json:"sizeMB,omitempty"`
	// Name - READ-ONLY; Name of the item
	Name *string `json:"name,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// StatusMessage - READ-ONLY; Status message
	StatusMessage *string `json:"statusMessage,omitempty"`
	// ItemsCount - READ-ONLY; Number of items
	ItemsCount *int64 `json:"itemsCount,omitempty"`
	// ItemsCompletedCount - READ-ONLY; Number of successfully completed items
	ItemsCompletedCount *int64 `json:"itemsCompletedCount,omitempty"`
	// ErrorPrefix - READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string `json:"errorPrefix,omitempty"`
	// ResultPrefix - READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string `json:"resultPrefix,omitempty"`
}

// DatabaseTable table properties
type DatabaseTable struct {
	// HasRows - READ-ONLY; Indicates whether table is empty or not
	HasRows *bool `json:"hasRows,omitempty"`
	// Name - READ-ONLY; Schema-qualified name of the table
	Name *string `json:"name,omitempty"`
}

// DataIntegrityValidationResult results for checksum based Data Integrity validation results
type DataIntegrityValidationResult struct {
	// FailedObjects - List of failed table names of source and target pair
	FailedObjects map[string]*string `json:"failedObjects"`
	// ValidationErrors - List of errors that happened while performing data integrity validation
	ValidationErrors *ValidationError `json:"validationErrors,omitempty"`
}

// MarshalJSON is the custom marshaler for DataIntegrityValidationResult.
func (divr DataIntegrityValidationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if divr.FailedObjects != nil {
		objectMap["failedObjects"] = divr.FailedObjects
	}
	if divr.ValidationErrors != nil {
		objectMap["validationErrors"] = divr.ValidationErrors
	}
	return json.Marshal(objectMap)
}

// DataItemMigrationSummaryResult basic summary of a data item migration
type DataItemMigrationSummaryResult struct {
	// Name - READ-ONLY; Name of the item
	Name *string `json:"name,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// StatusMessage - READ-ONLY; Status message
	StatusMessage *string `json:"statusMessage,omitempty"`
	// ItemsCount - READ-ONLY; Number of items
	ItemsCount *int64 `json:"itemsCount,omitempty"`
	// ItemsCompletedCount - READ-ONLY; Number of successfully completed items
	ItemsCompletedCount *int64 `json:"itemsCompletedCount,omitempty"`
	// ErrorPrefix - READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string `json:"errorPrefix,omitempty"`
	// ResultPrefix - READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string `json:"resultPrefix,omitempty"`
}

// Error migration Task errors
type Error struct {
	// Message - READ-ONLY; Error description
	Message *string `json:"message,omitempty"`
	// Type - Possible values include: 'ErrorTypeDefault', 'ErrorTypeWarning', 'ErrorTypeError'
	Type ErrorType `json:"type,omitempty"`
}

// ExecutionStatistics description about the errors happen while performing migration validation
type ExecutionStatistics struct {
	// ExecutionCount - No. of query executions
	ExecutionCount *int64 `json:"executionCount,omitempty"`
	// CPUTimeMs - CPU Time in millisecond(s) for the query execution
	CPUTimeMs *float64 `json:"cpuTimeMs,omitempty"`
	// ElapsedTimeMs - Time taken in millisecond(s) for executing the query
	ElapsedTimeMs *float64 `json:"elapsedTimeMs,omitempty"`
	// WaitStats - Dictionary of sql query execution wait types and the respective statistics
	WaitStats map[string]*WaitStatistics `json:"waitStats"`
	// HasErrors - Indicates whether the query resulted in an error
	HasErrors *bool `json:"hasErrors,omitempty"`
	// SQLErrors - List of sql Errors
	SQLErrors *[]string `json:"sqlErrors,omitempty"`
}

// MarshalJSON is the custom marshaler for ExecutionStatistics.
func (es ExecutionStatistics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if es.ExecutionCount != nil {
		objectMap["executionCount"] = es.ExecutionCount
	}
	if es.CPUTimeMs != nil {
		objectMap["cpuTimeMs"] = es.CPUTimeMs
	}
	if es.ElapsedTimeMs != nil {
		objectMap["elapsedTimeMs"] = es.ElapsedTimeMs
	}
	if es.WaitStats != nil {
		objectMap["waitStats"] = es.WaitStats
	}
	if es.HasErrors != nil {
		objectMap["hasErrors"] = es.HasErrors
	}
	if es.SQLErrors != nil {
		objectMap["sqlErrors"] = es.SQLErrors
	}
	return json.Marshal(objectMap)
}

// FileList oData page of files
type FileList struct {
	autorest.Response `json:"-"`
	// Value - List of files
	Value *[]ProjectFile `json:"value,omitempty"`
	// NextLink - URL to load the next page of files
	NextLink *string `json:"nextLink,omitempty"`
}

// FileListIterator provides access to a complete listing of ProjectFile values.
type FileListIterator struct {
	i    int
	page FileListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FileListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FileListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FileListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FileListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FileListIterator) Response() FileList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FileListIterator) Value() ProjectFile {
	if !iter.page.NotDone() {
		return ProjectFile{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FileListIterator type.
func NewFileListIterator(page FileListPage) FileListIterator {
	return FileListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (fl FileList) IsEmpty() bool {
	return fl.Value == nil || len(*fl.Value) == 0
}

// fileListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (fl FileList) fileListPreparer(ctx context.Context) (*http.Request, error) {
	if fl.NextLink == nil || len(to.String(fl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(fl.NextLink)))
}

// FileListPage contains a page of ProjectFile values.
type FileListPage struct {
	fn func(context.Context, FileList) (FileList, error)
	fl FileList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FileListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FileListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.fl)
	if err != nil {
		return err
	}
	page.fl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FileListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FileListPage) NotDone() bool {
	return !page.fl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FileListPage) Response() FileList {
	return page.fl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FileListPage) Values() []ProjectFile {
	if page.fl.IsEmpty() {
		return nil
	}
	return *page.fl.Value
}

// Creates a new instance of the FileListPage type.
func NewFileListPage(getNextPage func(context.Context, FileList) (FileList, error)) FileListPage {
	return FileListPage{fn: getNextPage}
}

// FileShare file share information with Path, Username, and Password.
type FileShare struct {
	// UserName - User name credential to connect to the share location
	UserName *string `json:"userName,omitempty"`
	// Password - Password credential used to connect to the share location.
	Password *string `json:"password,omitempty"`
	// Path - The folder path for this share.
	Path *string `json:"path,omitempty"`
}

// FileStorageInfo file storage information.
type FileStorageInfo struct {
	autorest.Response `json:"-"`
	// URI - A URI that can be used to access the file content.
	URI     *string            `json:"uri,omitempty"`
	Headers map[string]*string `json:"headers"`
}

// MarshalJSON is the custom marshaler for FileStorageInfo.
func (fsi FileStorageInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fsi.URI != nil {
		objectMap["uri"] = fsi.URI
	}
	if fsi.Headers != nil {
		objectMap["headers"] = fsi.Headers
	}
	return json.Marshal(objectMap)
}

// GetProjectDetailsNonSQLTaskInput input for the task that reads configuration from project artifacts
type GetProjectDetailsNonSQLTaskInput struct {
	// ProjectName - Name of the migration project
	ProjectName *string `json:"projectName,omitempty"`
	// ProjectLocation - A URL that points to the location to access project artifacts
	ProjectLocation *string `json:"projectLocation,omitempty"`
}

// GetTdeCertificatesSQLTaskInput input for the task that gets TDE certificates in Base64 encoded format.
type GetTdeCertificatesSQLTaskInput struct {
	// ConnectionInfo - Connection information for SQL Server
	ConnectionInfo *SQLConnectionInfo `json:"connectionInfo,omitempty"`
	// BackupFileShare - Backup file share information for file share to be used for temporarily storing files.
	BackupFileShare *FileShare `json:"backupFileShare,omitempty"`
	// SelectedCertificates - List containing certificate names and corresponding password to use for encrypting the exported certificate.
	SelectedCertificates *[]SelectedCertificateInput `json:"selectedCertificates,omitempty"`
}

// GetTdeCertificatesSQLTaskOutput output of the task that gets TDE certificates in Base64 encoded format.
type GetTdeCertificatesSQLTaskOutput struct {
	// Base64EncodedCertificates - READ-ONLY; Mapping from certificate name to base 64 encoded format.
	Base64EncodedCertificates map[string][]string `json:"base64EncodedCertificates"`
	// ValidationErrors - READ-ONLY; Validation errors
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// MarshalJSON is the custom marshaler for GetTdeCertificatesSQLTaskOutput.
func (gtcsto GetTdeCertificatesSQLTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// GetTdeCertificatesSQLTaskProperties properties for the task that gets TDE certificates in Base64 encoded
// format.
type GetTdeCertificatesSQLTaskProperties struct {
	// Input - Task input
	Input *GetTdeCertificatesSQLTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]GetTdeCertificatesSQLTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) MarshalJSON() ([]byte, error) {
	gtcstp.TaskType = TaskTypeGetTDECertificatesSQL
	objectMap := make(map[string]interface{})
	if gtcstp.Input != nil {
		objectMap["input"] = gtcstp.Input
	}
	if gtcstp.ClientData != nil {
		objectMap["clientData"] = gtcstp.ClientData
	}
	if gtcstp.TaskType != "" {
		objectMap["taskType"] = gtcstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return &gtcstp, true
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &gtcstp, true
}

// UnmarshalJSON is the custom unmarshaler for GetTdeCertificatesSQLTaskProperties struct.
func (gtcstp *GetTdeCertificatesSQLTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input GetTdeCertificatesSQLTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				gtcstp.Input = &input
			}
		case "output":
			if v != nil {
				var output []GetTdeCertificatesSQLTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				gtcstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				gtcstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				gtcstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				gtcstp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				gtcstp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				gtcstp.TaskType = taskType
			}
		}
	}

	return nil
}

// GetUserTablesOracleTaskInput input for the task that gets the list of tables contained within a provided
// list of Oracle schemas.
type GetUserTablesOracleTaskInput struct {
	// ConnectionInfo - Information for connecting to Oracle source
	ConnectionInfo *OracleConnectionInfo `json:"connectionInfo,omitempty"`
	// SelectedSchemas - List of Oracle schemas for which to collect tables
	SelectedSchemas *[]string `json:"selectedSchemas,omitempty"`
}

// GetUserTablesOracleTaskOutput output for the task that gets the list of tables contained within a
// provided list of Oracle schemas.
type GetUserTablesOracleTaskOutput struct {
	// SchemaName - READ-ONLY; The schema this result is for
	SchemaName *string `json:"schemaName,omitempty"`
	// Tables - READ-ONLY; List of valid tables found for this schema
	Tables *[]DatabaseTable `json:"tables,omitempty"`
	// ValidationErrors - READ-ONLY; Validation errors associated with the task
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// GetUserTablesOracleTaskProperties properties for the task that collects user tables for the given list
// of Oracle schemas
type GetUserTablesOracleTaskProperties struct {
	// Input - Task input
	Input *GetUserTablesOracleTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]GetUserTablesOracleTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) MarshalJSON() ([]byte, error) {
	gutotp.TaskType = TaskTypeGetUserTablesOracle
	objectMap := make(map[string]interface{})
	if gutotp.Input != nil {
		objectMap["input"] = gutotp.Input
	}
	if gutotp.ClientData != nil {
		objectMap["clientData"] = gutotp.ClientData
	}
	if gutotp.TaskType != "" {
		objectMap["taskType"] = gutotp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return &gutotp, true
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesOracleTaskProperties.
func (gutotp GetUserTablesOracleTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &gutotp, true
}

// UnmarshalJSON is the custom unmarshaler for GetUserTablesOracleTaskProperties struct.
func (gutotp *GetUserTablesOracleTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input GetUserTablesOracleTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				gutotp.Input = &input
			}
		case "output":
			if v != nil {
				var output []GetUserTablesOracleTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				gutotp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				gutotp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				gutotp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				gutotp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				gutotp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				gutotp.TaskType = taskType
			}
		}
	}

	return nil
}

// GetUserTablesPostgreSQLTaskInput input for the task that gets the list of tables for a provided list of
// PostgreSQL databases.
type GetUserTablesPostgreSQLTaskInput struct {
	// ConnectionInfo - Information for connecting to PostgreSQL source
	ConnectionInfo *PostgreSQLConnectionInfo `json:"connectionInfo,omitempty"`
	// SelectedDatabases - List of PostgreSQL databases for which to collect tables
	SelectedDatabases *[]string `json:"selectedDatabases,omitempty"`
}

// GetUserTablesPostgreSQLTaskOutput output for the task that gets the list of tables for a provided list
// of PostgreSQL databases.
type GetUserTablesPostgreSQLTaskOutput struct {
	// DatabaseName - READ-ONLY; The database this result is for
	DatabaseName *string `json:"databaseName,omitempty"`
	// Tables - READ-ONLY; List of valid tables found for this database
	Tables *[]DatabaseTable `json:"tables,omitempty"`
	// ValidationErrors - READ-ONLY; Validation errors associated with the task
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// GetUserTablesPostgreSQLTaskProperties properties for the task that collects user tables for the given
// list of databases
type GetUserTablesPostgreSQLTaskProperties struct {
	// Input - Task input
	Input *GetUserTablesPostgreSQLTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]GetUserTablesPostgreSQLTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) MarshalJSON() ([]byte, error) {
	gutpstp.TaskType = TaskTypeGetUserTablesPostgreSQL
	objectMap := make(map[string]interface{})
	if gutpstp.Input != nil {
		objectMap["input"] = gutpstp.Input
	}
	if gutpstp.ClientData != nil {
		objectMap["clientData"] = gutpstp.ClientData
	}
	if gutpstp.TaskType != "" {
		objectMap["taskType"] = gutpstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return &gutpstp, true
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesPostgreSQLTaskProperties.
func (gutpstp GetUserTablesPostgreSQLTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &gutpstp, true
}

// UnmarshalJSON is the custom unmarshaler for GetUserTablesPostgreSQLTaskProperties struct.
func (gutpstp *GetUserTablesPostgreSQLTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input GetUserTablesPostgreSQLTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				gutpstp.Input = &input
			}
		case "output":
			if v != nil {
				var output []GetUserTablesPostgreSQLTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				gutpstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				gutpstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				gutpstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				gutpstp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				gutpstp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				gutpstp.TaskType = taskType
			}
		}
	}

	return nil
}

// GetUserTablesSQLSyncTaskInput input for the task that collects user tables for the given list of
// databases
type GetUserTablesSQLSyncTaskInput struct {
	// SourceConnectionInfo - Connection information for SQL Server
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Connection information for SQL DB
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
	// SelectedSourceDatabases - List of source database names to collect tables for
	SelectedSourceDatabases *[]string `json:"selectedSourceDatabases,omitempty"`
	// SelectedTargetDatabases - List of target database names to collect tables for
	SelectedTargetDatabases *[]string `json:"selectedTargetDatabases,omitempty"`
}

// GetUserTablesSQLSyncTaskOutput output of the task that collects user tables for the given list of
// databases
type GetUserTablesSQLSyncTaskOutput struct {
	// DatabasesToSourceTables - READ-ONLY; Mapping from database name to list of source tables
	DatabasesToSourceTables map[string][]DatabaseTable `json:"databasesToSourceTables"`
	// DatabasesToTargetTables - READ-ONLY; Mapping from database name to list of target tables
	DatabasesToTargetTables map[string][]DatabaseTable `json:"databasesToTargetTables"`
	// TableValidationErrors - READ-ONLY; Mapping from database name to list of validation errors
	TableValidationErrors map[string][]string `json:"tableValidationErrors"`
	// ValidationErrors - READ-ONLY; Validation errors
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// MarshalJSON is the custom marshaler for GetUserTablesSQLSyncTaskOutput.
func (gutssto GetUserTablesSQLSyncTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// GetUserTablesSQLSyncTaskProperties properties for the task that collects user tables for the given list
// of databases
type GetUserTablesSQLSyncTaskProperties struct {
	// Input - Task input
	Input *GetUserTablesSQLSyncTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]GetUserTablesSQLSyncTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) MarshalJSON() ([]byte, error) {
	gutsstp.TaskType = TaskTypeGetUserTablesAzureSQLDbSync
	objectMap := make(map[string]interface{})
	if gutsstp.Input != nil {
		objectMap["input"] = gutsstp.Input
	}
	if gutsstp.ClientData != nil {
		objectMap["clientData"] = gutsstp.ClientData
	}
	if gutsstp.TaskType != "" {
		objectMap["taskType"] = gutsstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return &gutsstp, true
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &gutsstp, true
}

// UnmarshalJSON is the custom unmarshaler for GetUserTablesSQLSyncTaskProperties struct.
func (gutsstp *GetUserTablesSQLSyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input GetUserTablesSQLSyncTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				gutsstp.Input = &input
			}
		case "output":
			if v != nil {
				var output []GetUserTablesSQLSyncTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				gutsstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				gutsstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				gutsstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				gutsstp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				gutsstp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				gutsstp.TaskType = taskType
			}
		}
	}

	return nil
}

// GetUserTablesSQLTaskInput input for the task that collects user tables for the given list of databases
type GetUserTablesSQLTaskInput struct {
	// ConnectionInfo - Connection information for SQL Server
	ConnectionInfo *SQLConnectionInfo `json:"connectionInfo,omitempty"`
	// SelectedDatabases - List of database names to collect tables for
	SelectedDatabases *[]string `json:"selectedDatabases,omitempty"`
}

// GetUserTablesSQLTaskOutput output of the task that collects user tables for the given list of databases
type GetUserTablesSQLTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// DatabasesToTables - READ-ONLY; Mapping from database name to list of tables
	DatabasesToTables map[string][]DatabaseTable `json:"databasesToTables"`
	// ValidationErrors - READ-ONLY; Validation errors
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// MarshalJSON is the custom marshaler for GetUserTablesSQLTaskOutput.
func (gutsto GetUserTablesSQLTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// GetUserTablesSQLTaskProperties properties for the task that collects user tables for the given list of
// databases
type GetUserTablesSQLTaskProperties struct {
	// Input - Task input
	Input *GetUserTablesSQLTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]GetUserTablesSQLTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) MarshalJSON() ([]byte, error) {
	gutstp.TaskType = TaskTypeGetUserTablesSQL
	objectMap := make(map[string]interface{})
	if gutstp.Input != nil {
		objectMap["input"] = gutstp.Input
	}
	if gutstp.ClientData != nil {
		objectMap["clientData"] = gutstp.ClientData
	}
	if gutstp.TaskType != "" {
		objectMap["taskType"] = gutstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return &gutstp, true
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &gutstp, true
}

// UnmarshalJSON is the custom unmarshaler for GetUserTablesSQLTaskProperties struct.
func (gutstp *GetUserTablesSQLTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input GetUserTablesSQLTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				gutstp.Input = &input
			}
		case "output":
			if v != nil {
				var output []GetUserTablesSQLTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				gutstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				gutstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				gutstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				gutstp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				gutstp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				gutstp.TaskType = taskType
			}
		}
	}

	return nil
}

// InstallOCIDriverTaskInput input for the service task to install an OCI driver.
type InstallOCIDriverTaskInput struct {
	// DriverPackageName - Name of the uploaded driver package to install.
	DriverPackageName *string `json:"driverPackageName,omitempty"`
}

// InstallOCIDriverTaskOutput output for the service task to install an OCI driver.
type InstallOCIDriverTaskOutput struct {
	// ValidationErrors - READ-ONLY; Validation errors
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// InstallOCIDriverTaskProperties properties for the task that installs an OCI driver.
type InstallOCIDriverTaskProperties struct {
	Input *InstallOCIDriverTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]InstallOCIDriverTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) MarshalJSON() ([]byte, error) {
	iodtp.TaskType = TaskTypeServiceInstallOCI
	objectMap := make(map[string]interface{})
	if iodtp.Input != nil {
		objectMap["input"] = iodtp.Input
	}
	if iodtp.ClientData != nil {
		objectMap["clientData"] = iodtp.ClientData
	}
	if iodtp.TaskType != "" {
		objectMap["taskType"] = iodtp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return &iodtp, true
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for InstallOCIDriverTaskProperties.
func (iodtp InstallOCIDriverTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &iodtp, true
}

// UnmarshalJSON is the custom unmarshaler for InstallOCIDriverTaskProperties struct.
func (iodtp *InstallOCIDriverTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input InstallOCIDriverTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				iodtp.Input = &input
			}
		case "output":
			if v != nil {
				var output []InstallOCIDriverTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				iodtp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				iodtp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				iodtp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				iodtp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				iodtp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				iodtp.TaskType = taskType
			}
		}
	}

	return nil
}

// MigrateMISyncCompleteCommandInput input for command that completes online migration for an Azure SQL
// Database Managed Instance.
type MigrateMISyncCompleteCommandInput struct {
	// SourceDatabaseName - Name of managed instance database
	SourceDatabaseName *string `json:"sourceDatabaseName,omitempty"`
}

// MigrateMISyncCompleteCommandOutput output for command that completes online migration for an Azure SQL
// Database Managed Instance.
type MigrateMISyncCompleteCommandOutput struct {
	// Errors - List of errors that happened during the command execution
	Errors *[]ReportableException `json:"errors,omitempty"`
}

// MigrateMISyncCompleteCommandProperties properties for the command that completes online migration for an
// Azure SQL Database Managed Instance.
type MigrateMISyncCompleteCommandProperties struct {
	// Input - Command input
	Input *MigrateMISyncCompleteCommandInput `json:"input,omitempty"`
	// Output - READ-ONLY; Command output. This is ignored if submitted.
	Output *MigrateMISyncCompleteCommandOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the command. This is ignored if submitted. Possible values include: 'Unknown', 'Accepted', 'Running', 'Succeeded', 'Failed'
	State CommandState `json:"state,omitempty"`
	// CommandType - Possible values include: 'CommandTypeCommandProperties', 'CommandTypeMigrateSQLServerAzureDbSQLMiComplete', 'CommandTypeMigrateSyncCompleteDatabase', 'CommandTypeCancel', 'CommandTypeFinish', 'CommandTypeRestart'
	CommandType CommandType `json:"commandType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateMISyncCompleteCommandProperties.
func (mmsccp MigrateMISyncCompleteCommandProperties) MarshalJSON() ([]byte, error) {
	mmsccp.CommandType = CommandTypeMigrateSQLServerAzureDbSQLMiComplete
	objectMap := make(map[string]interface{})
	if mmsccp.Input != nil {
		objectMap["input"] = mmsccp.Input
	}
	if mmsccp.CommandType != "" {
		objectMap["commandType"] = mmsccp.CommandType
	}
	return json.Marshal(objectMap)
}

// AsMigrateMISyncCompleteCommandProperties is the BasicCommandProperties implementation for MigrateMISyncCompleteCommandProperties.
func (mmsccp MigrateMISyncCompleteCommandProperties) AsMigrateMISyncCompleteCommandProperties() (*MigrateMISyncCompleteCommandProperties, bool) {
	return &mmsccp, true
}

// AsMigrateSyncCompleteCommandProperties is the BasicCommandProperties implementation for MigrateMISyncCompleteCommandProperties.
func (mmsccp MigrateMISyncCompleteCommandProperties) AsMigrateSyncCompleteCommandProperties() (*MigrateSyncCompleteCommandProperties, bool) {
	return nil, false
}

// AsMongoDbCancelCommand is the BasicCommandProperties implementation for MigrateMISyncCompleteCommandProperties.
func (mmsccp MigrateMISyncCompleteCommandProperties) AsMongoDbCancelCommand() (*MongoDbCancelCommand, bool) {
	return nil, false
}

// AsMongoDbFinishCommand is the BasicCommandProperties implementation for MigrateMISyncCompleteCommandProperties.
func (mmsccp MigrateMISyncCompleteCommandProperties) AsMongoDbFinishCommand() (*MongoDbFinishCommand, bool) {
	return nil, false
}

// AsMongoDbRestartCommand is the BasicCommandProperties implementation for MigrateMISyncCompleteCommandProperties.
func (mmsccp MigrateMISyncCompleteCommandProperties) AsMongoDbRestartCommand() (*MongoDbRestartCommand, bool) {
	return nil, false
}

// AsCommandProperties is the BasicCommandProperties implementation for MigrateMISyncCompleteCommandProperties.
func (mmsccp MigrateMISyncCompleteCommandProperties) AsCommandProperties() (*CommandProperties, bool) {
	return nil, false
}

// AsBasicCommandProperties is the BasicCommandProperties implementation for MigrateMISyncCompleteCommandProperties.
func (mmsccp MigrateMISyncCompleteCommandProperties) AsBasicCommandProperties() (BasicCommandProperties, bool) {
	return &mmsccp, true
}

// MigrateMongoDbTaskProperties properties for the task that migrates data between MongoDB data sources
type MigrateMongoDbTaskProperties struct {
	Input *MongoDbMigrationSettings `json:"input,omitempty"`
	// Output - READ-ONLY
	Output *[]MongoDbProgress `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) MarshalJSON() ([]byte, error) {
	mmdtp.TaskType = TaskTypeMigrateMongoDb
	objectMap := make(map[string]interface{})
	if mmdtp.Input != nil {
		objectMap["input"] = mmdtp.Input
	}
	if mmdtp.ClientData != nil {
		objectMap["clientData"] = mmdtp.ClientData
	}
	if mmdtp.TaskType != "" {
		objectMap["taskType"] = mmdtp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return &mmdtp, true
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateMongoDbTaskProperties.
func (mmdtp MigrateMongoDbTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &mmdtp, true
}

// UnmarshalJSON is the custom unmarshaler for MigrateMongoDbTaskProperties struct.
func (mmdtp *MigrateMongoDbTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input MongoDbMigrationSettings
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				mmdtp.Input = &input
			}
		case "output":
			if v != nil {
				var output []MongoDbProgress
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				mmdtp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				mmdtp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				mmdtp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				mmdtp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				mmdtp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				mmdtp.TaskType = taskType
			}
		}
	}

	return nil
}

// MigrateMySQLAzureDbForMySQLSyncDatabaseInput database specific information for MySQL to Azure Database
// for MySQL migration task inputs
type MigrateMySQLAzureDbForMySQLSyncDatabaseInput struct {
	// Name - Name of the database
	Name *string `json:"name,omitempty"`
	// TargetDatabaseName - Name of target database. Note: Target database will be truncated before starting migration.
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// MigrationSetting - Migration settings which tune the migration behavior
	MigrationSetting map[string]*string `json:"migrationSetting"`
	// SourceSetting - Source settings to tune source endpoint migration behavior
	SourceSetting map[string]*string `json:"sourceSetting"`
	// TargetSetting - Target settings to tune target endpoint migration behavior
	TargetSetting map[string]*string `json:"targetSetting"`
}

// MarshalJSON is the custom marshaler for MigrateMySQLAzureDbForMySQLSyncDatabaseInput.
func (mmsadfmssdi MigrateMySQLAzureDbForMySQLSyncDatabaseInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mmsadfmssdi.Name != nil {
		objectMap["name"] = mmsadfmssdi.Name
	}
	if mmsadfmssdi.TargetDatabaseName != nil {
		objectMap["targetDatabaseName"] = mmsadfmssdi.TargetDatabaseName
	}
	if mmsadfmssdi.MigrationSetting != nil {
		objectMap["migrationSetting"] = mmsadfmssdi.MigrationSetting
	}
	if mmsadfmssdi.SourceSetting != nil {
		objectMap["sourceSetting"] = mmsadfmssdi.SourceSetting
	}
	if mmsadfmssdi.TargetSetting != nil {
		objectMap["targetSetting"] = mmsadfmssdi.TargetSetting
	}
	return json.Marshal(objectMap)
}

// MigrateMySQLAzureDbForMySQLSyncTaskInput input for the task that migrates MySQL databases to Azure
// Database for MySQL for online migrations
type MigrateMySQLAzureDbForMySQLSyncTaskInput struct {
	// SourceConnectionInfo - Connection information for source MySQL
	SourceConnectionInfo *MySQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Connection information for target Azure Database for MySQL
	TargetConnectionInfo *MySQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
	// SelectedDatabases - Databases to migrate
	SelectedDatabases *[]MigrateMySQLAzureDbForMySQLSyncDatabaseInput `json:"selectedDatabases,omitempty"`
}

// BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput output for the task that migrates MySQL databases to Azure Database
// for MySQL for online migrations
type BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput interface {
	AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError, bool)
	AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputError, bool)
	AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel, bool)
	AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel, bool)
	AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel, bool)
	AsMigrateMySQLAzureDbForMySQLSyncTaskOutput() (*MigrateMySQLAzureDbForMySQLSyncTaskOutput, bool)
}

// MigrateMySQLAzureDbForMySQLSyncTaskOutput output for the task that migrates MySQL databases to Azure
// Database for MySQL for online migrations
type MigrateMySQLAzureDbForMySQLSyncTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput `json:"resultType,omitempty"`
}

func unmarshalBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput(body []byte) (BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resultType"] {
	case string(ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput):
		var mmsadfmsstode MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError
		err := json.Unmarshal(body, &mmsadfmsstode)
		return mmsadfmsstode, err
	case string(ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput):
		var mmsadfmsstoe MigrateMySQLAzureDbForMySQLSyncTaskOutputError
		err := json.Unmarshal(body, &mmsadfmsstoe)
		return mmsadfmsstoe, err
	case string(ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput):
		var mmsadfmsstotl MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel
		err := json.Unmarshal(body, &mmsadfmsstotl)
		return mmsadfmsstotl, err
	case string(ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput):
		var mmsadfmsstodl MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel
		err := json.Unmarshal(body, &mmsadfmsstodl)
		return mmsadfmsstodl, err
	case string(ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput):
		var mmsadfmsstoml MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel
		err := json.Unmarshal(body, &mmsadfmsstoml)
		return mmsadfmsstoml, err
	default:
		var mmsadfmssto MigrateMySQLAzureDbForMySQLSyncTaskOutput
		err := json.Unmarshal(body, &mmsadfmssto)
		return mmsadfmssto, err
	}
}
func unmarshalBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputArray(body []byte) ([]BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	mmsadfmsstoArray := make([]BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mmsadfmssto, err := unmarshalBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		mmsadfmsstoArray[index] = mmsadfmssto
	}
	return mmsadfmsstoArray, nil
}

// MarshalJSON is the custom marshaler for MigrateMySQLAzureDbForMySQLSyncTaskOutput.
func (mmsadfmssto MigrateMySQLAzureDbForMySQLSyncTaskOutput) MarshalJSON() ([]byte, error) {
	mmsadfmssto.ResultType = ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput
	objectMap := make(map[string]interface{})
	if mmsadfmssto.ResultType != "" {
		objectMap["resultType"] = mmsadfmssto.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutput.
func (mmsadfmssto MigrateMySQLAzureDbForMySQLSyncTaskOutput) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutput.
func (mmsadfmssto MigrateMySQLAzureDbForMySQLSyncTaskOutput) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutput.
func (mmsadfmssto MigrateMySQLAzureDbForMySQLSyncTaskOutput) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutput.
func (mmsadfmssto MigrateMySQLAzureDbForMySQLSyncTaskOutput) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutput.
func (mmsadfmssto MigrateMySQLAzureDbForMySQLSyncTaskOutput) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutput.
func (mmsadfmssto MigrateMySQLAzureDbForMySQLSyncTaskOutput) AsMigrateMySQLAzureDbForMySQLSyncTaskOutput() (*MigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return &mmsadfmssto, true
}

// AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutput.
func (mmsadfmssto MigrateMySQLAzureDbForMySQLSyncTaskOutput) AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput() (BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return &mmsadfmssto, true
}

// MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError ...
type MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError struct {
	// ErrorMessage - Error message
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// Events - List of error events.
	Events *[]SyncMigrationDatabaseErrorEvent `json:"events,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError.
func (mmsadfmsstode MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError) MarshalJSON() ([]byte, error) {
	mmsadfmsstode.ResultType = ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput
	objectMap := make(map[string]interface{})
	if mmsadfmsstode.ErrorMessage != nil {
		objectMap["errorMessage"] = mmsadfmsstode.ErrorMessage
	}
	if mmsadfmsstode.Events != nil {
		objectMap["events"] = mmsadfmsstode.Events
	}
	if mmsadfmsstode.ResultType != "" {
		objectMap["resultType"] = mmsadfmsstode.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError.
func (mmsadfmsstode MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError, bool) {
	return &mmsadfmsstode, true
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError.
func (mmsadfmsstode MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError.
func (mmsadfmsstode MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError.
func (mmsadfmsstode MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError.
func (mmsadfmsstode MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError.
func (mmsadfmsstode MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutput() (*MigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError.
func (mmsadfmsstode MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError) AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput() (BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return &mmsadfmsstode, true
}

// MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel ...
type MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel struct {
	// DatabaseName - READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// MigrationState - READ-ONLY; Migration state that this database is in. Possible values include: 'SyncDatabaseMigrationReportingStateUNDEFINED', 'SyncDatabaseMigrationReportingStateCONFIGURING', 'SyncDatabaseMigrationReportingStateINITIALIAZING', 'SyncDatabaseMigrationReportingStateSTARTING', 'SyncDatabaseMigrationReportingStateRUNNING', 'SyncDatabaseMigrationReportingStateREADYTOCOMPLETE', 'SyncDatabaseMigrationReportingStateCOMPLETING', 'SyncDatabaseMigrationReportingStateCOMPLETE', 'SyncDatabaseMigrationReportingStateCANCELLING', 'SyncDatabaseMigrationReportingStateCANCELLED', 'SyncDatabaseMigrationReportingStateFAILED'
	MigrationState SyncDatabaseMigrationReportingState `json:"migrationState,omitempty"`
	// IncomingChanges - READ-ONLY; Number of incoming changes
	IncomingChanges *int64 `json:"incomingChanges,omitempty"`
	// AppliedChanges - READ-ONLY; Number of applied changes
	AppliedChanges *int64 `json:"appliedChanges,omitempty"`
	// CdcInsertCounter - READ-ONLY; Number of cdc inserts
	CdcInsertCounter *int64 `json:"cdcInsertCounter,omitempty"`
	// CdcDeleteCounter - READ-ONLY; Number of cdc deletes
	CdcDeleteCounter *int64 `json:"cdcDeleteCounter,omitempty"`
	// CdcUpdateCounter - READ-ONLY; Number of cdc updates
	CdcUpdateCounter *int64 `json:"cdcUpdateCounter,omitempty"`
	// FullLoadCompletedTables - READ-ONLY; Number of tables completed in full load
	FullLoadCompletedTables *int64 `json:"fullLoadCompletedTables,omitempty"`
	// FullLoadLoadingTables - READ-ONLY; Number of tables loading in full load
	FullLoadLoadingTables *int64 `json:"fullLoadLoadingTables,omitempty"`
	// FullLoadQueuedTables - READ-ONLY; Number of tables queued in full load
	FullLoadQueuedTables *int64 `json:"fullLoadQueuedTables,omitempty"`
	// FullLoadErroredTables - READ-ONLY; Number of tables errored in full load
	FullLoadErroredTables *int64 `json:"fullLoadErroredTables,omitempty"`
	// InitializationCompleted - READ-ONLY; Indicates if initial load (full load) has been completed
	InitializationCompleted *bool `json:"initializationCompleted,omitempty"`
	// Latency - READ-ONLY; CDC apply latency
	Latency *int64 `json:"latency,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel.
func (mmsadfmsstodl MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	mmsadfmsstodl.ResultType = ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput
	objectMap := make(map[string]interface{})
	if mmsadfmsstodl.ResultType != "" {
		objectMap["resultType"] = mmsadfmsstodl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel.
func (mmsadfmsstodl MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel.
func (mmsadfmsstodl MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel.
func (mmsadfmsstodl MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel.
func (mmsadfmsstodl MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel, bool) {
	return &mmsadfmsstodl, true
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel.
func (mmsadfmsstodl MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel.
func (mmsadfmsstodl MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutput() (*MigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel.
func (mmsadfmsstodl MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel) AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput() (BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return &mmsadfmsstodl, true
}

// MigrateMySQLAzureDbForMySQLSyncTaskOutputError ...
type MigrateMySQLAzureDbForMySQLSyncTaskOutputError struct {
	// Error - READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateMySQLAzureDbForMySQLSyncTaskOutputError.
func (mmsadfmsstoe MigrateMySQLAzureDbForMySQLSyncTaskOutputError) MarshalJSON() ([]byte, error) {
	mmsadfmsstoe.ResultType = ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput
	objectMap := make(map[string]interface{})
	if mmsadfmsstoe.ResultType != "" {
		objectMap["resultType"] = mmsadfmsstoe.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputError.
func (mmsadfmsstoe MigrateMySQLAzureDbForMySQLSyncTaskOutputError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputError.
func (mmsadfmsstoe MigrateMySQLAzureDbForMySQLSyncTaskOutputError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputError, bool) {
	return &mmsadfmsstoe, true
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputError.
func (mmsadfmsstoe MigrateMySQLAzureDbForMySQLSyncTaskOutputError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputError.
func (mmsadfmsstoe MigrateMySQLAzureDbForMySQLSyncTaskOutputError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputError.
func (mmsadfmsstoe MigrateMySQLAzureDbForMySQLSyncTaskOutputError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputError.
func (mmsadfmsstoe MigrateMySQLAzureDbForMySQLSyncTaskOutputError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutput() (*MigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputError.
func (mmsadfmsstoe MigrateMySQLAzureDbForMySQLSyncTaskOutputError) AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput() (BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return &mmsadfmsstoe, true
}

// MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel ...
type MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel struct {
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// SourceServerVersion - READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// SourceServer - READ-ONLY; Source server name
	SourceServer *string `json:"sourceServer,omitempty"`
	// TargetServerVersion - READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServer - READ-ONLY; Target server name
	TargetServer *string `json:"targetServer,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel.
func (mmsadfmsstoml MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	mmsadfmsstoml.ResultType = ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput
	objectMap := make(map[string]interface{})
	if mmsadfmsstoml.ResultType != "" {
		objectMap["resultType"] = mmsadfmsstoml.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel.
func (mmsadfmsstoml MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel.
func (mmsadfmsstoml MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel.
func (mmsadfmsstoml MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel.
func (mmsadfmsstoml MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel.
func (mmsadfmsstoml MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel, bool) {
	return &mmsadfmsstoml, true
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel.
func (mmsadfmsstoml MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutput() (*MigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel.
func (mmsadfmsstoml MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel) AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput() (BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return &mmsadfmsstoml, true
}

// MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel ...
type MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel struct {
	// TableName - READ-ONLY; Name of the table
	TableName *string `json:"tableName,omitempty"`
	// DatabaseName - READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// CdcInsertCounter - READ-ONLY; Number of applied inserts
	CdcInsertCounter *string `json:"cdcInsertCounter,omitempty"`
	// CdcUpdateCounter - READ-ONLY; Number of applied updates
	CdcUpdateCounter *string `json:"cdcUpdateCounter,omitempty"`
	// CdcDeleteCounter - READ-ONLY; Number of applied deletes
	CdcDeleteCounter *string `json:"cdcDeleteCounter,omitempty"`
	// FullLoadEstFinishTime - READ-ONLY; Estimate to finish full load
	FullLoadEstFinishTime *date.Time `json:"fullLoadEstFinishTime,omitempty"`
	// FullLoadStartedOn - READ-ONLY; Full load start time
	FullLoadStartedOn *date.Time `json:"fullLoadStartedOn,omitempty"`
	// FullLoadEndedOn - READ-ONLY; Full load end time
	FullLoadEndedOn *date.Time `json:"fullLoadEndedOn,omitempty"`
	// FullLoadTotalRows - READ-ONLY; Number of rows applied in full load
	FullLoadTotalRows *int64 `json:"fullLoadTotalRows,omitempty"`
	// State - READ-ONLY; Current state of the table migration. Possible values include: 'SyncTableMigrationStateBEFORELOAD', 'SyncTableMigrationStateFULLLOAD', 'SyncTableMigrationStateCOMPLETED', 'SyncTableMigrationStateCANCELED', 'SyncTableMigrationStateERROR', 'SyncTableMigrationStateFAILED'
	State SyncTableMigrationState `json:"state,omitempty"`
	// TotalChangesApplied - READ-ONLY; Total number of applied changes
	TotalChangesApplied *int64 `json:"totalChangesApplied,omitempty"`
	// DataErrorsCounter - READ-ONLY; Number of data errors occurred
	DataErrorsCounter *int64 `json:"dataErrorsCounter,omitempty"`
	// LastModifiedTime - READ-ONLY; Last modified time on target
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel.
func (mmsadfmsstotl MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel) MarshalJSON() ([]byte, error) {
	mmsadfmsstotl.ResultType = ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput
	objectMap := make(map[string]interface{})
	if mmsadfmsstotl.ResultType != "" {
		objectMap["resultType"] = mmsadfmsstotl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel.
func (mmsadfmsstotl MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel.
func (mmsadfmsstotl MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel.
func (mmsadfmsstotl MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel, bool) {
	return &mmsadfmsstotl, true
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel.
func (mmsadfmsstotl MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel.
func (mmsadfmsstotl MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel.
func (mmsadfmsstotl MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutput() (*MigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel.
func (mmsadfmsstotl MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel) AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput() (BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return &mmsadfmsstotl, true
}

// MigrateMySQLAzureDbForMySQLSyncTaskProperties properties for the task that migrates MySQL databases to
// Azure Database for MySQL for online migrations
type MigrateMySQLAzureDbForMySQLSyncTaskProperties struct {
	// Input - Task input
	Input *MigrateMySQLAzureDbForMySQLSyncTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) MarshalJSON() ([]byte, error) {
	mmsadfmsstp.TaskType = TaskTypeMigrateMySQLAzureDbForMySQLSync
	objectMap := make(map[string]interface{})
	if mmsadfmsstp.Input != nil {
		objectMap["input"] = mmsadfmsstp.Input
	}
	if mmsadfmsstp.ClientData != nil {
		objectMap["clientData"] = mmsadfmsstp.ClientData
	}
	if mmsadfmsstp.TaskType != "" {
		objectMap["taskType"] = mmsadfmsstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return &mmsadfmsstp, true
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &mmsadfmsstp, true
}

// UnmarshalJSON is the custom unmarshaler for MigrateMySQLAzureDbForMySQLSyncTaskProperties struct.
func (mmsadfmsstp *MigrateMySQLAzureDbForMySQLSyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input MigrateMySQLAzureDbForMySQLSyncTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				mmsadfmsstp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputArray(*v)
				if err != nil {
					return err
				}
				mmsadfmsstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				mmsadfmsstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				mmsadfmsstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				mmsadfmsstp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				mmsadfmsstp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				mmsadfmsstp.TaskType = taskType
			}
		}
	}

	return nil
}

// MigrateOracleAzureDbForPostgreSQLSyncTaskProperties properties for the task that migrates Oracle to
// Azure Database for PostgreSQL for online migrations
type MigrateOracleAzureDbForPostgreSQLSyncTaskProperties struct {
	// Input - Task input
	Input *MigrateOracleAzureDbPostgreSQLSyncTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) MarshalJSON() ([]byte, error) {
	moadfpsstp.TaskType = TaskTypeMigrateOracleAzureDbForPostgreSQLSync
	objectMap := make(map[string]interface{})
	if moadfpsstp.Input != nil {
		objectMap["input"] = moadfpsstp.Input
	}
	if moadfpsstp.ClientData != nil {
		objectMap["clientData"] = moadfpsstp.ClientData
	}
	if moadfpsstp.TaskType != "" {
		objectMap["taskType"] = moadfpsstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return &moadfpsstp, true
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &moadfpsstp, true
}

// UnmarshalJSON is the custom unmarshaler for MigrateOracleAzureDbForPostgreSQLSyncTaskProperties struct.
func (moadfpsstp *MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input MigrateOracleAzureDbPostgreSQLSyncTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				moadfpsstp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputArray(*v)
				if err != nil {
					return err
				}
				moadfpsstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				moadfpsstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				moadfpsstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				moadfpsstp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				moadfpsstp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				moadfpsstp.TaskType = taskType
			}
		}
	}

	return nil
}

// MigrateOracleAzureDbPostgreSQLSyncDatabaseInput database specific information for Oracle to Azure
// Database for PostgreSQL migration task inputs
type MigrateOracleAzureDbPostgreSQLSyncDatabaseInput struct {
	// CaseManipulation - How to handle object name casing: either Preserve or ToLower
	CaseManipulation *string `json:"caseManipulation,omitempty"`
	// Name - Name of the migration pipeline
	Name *string `json:"name,omitempty"`
	// SchemaName - Name of the source schema
	SchemaName *string `json:"schemaName,omitempty"`
	// TableMap - Mapping of source to target tables
	TableMap map[string]*string `json:"tableMap"`
	// TargetDatabaseName - Name of target database. Note: Target database will be truncated before starting migration.
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// MigrationSetting - Migration settings which tune the migration behavior
	MigrationSetting map[string]*string `json:"migrationSetting"`
	// SourceSetting - Source settings to tune source endpoint migration behavior
	SourceSetting map[string]*string `json:"sourceSetting"`
	// TargetSetting - Target settings to tune target endpoint migration behavior
	TargetSetting map[string]*string `json:"targetSetting"`
}

// MarshalJSON is the custom marshaler for MigrateOracleAzureDbPostgreSQLSyncDatabaseInput.
func (moadpssdi MigrateOracleAzureDbPostgreSQLSyncDatabaseInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if moadpssdi.CaseManipulation != nil {
		objectMap["caseManipulation"] = moadpssdi.CaseManipulation
	}
	if moadpssdi.Name != nil {
		objectMap["name"] = moadpssdi.Name
	}
	if moadpssdi.SchemaName != nil {
		objectMap["schemaName"] = moadpssdi.SchemaName
	}
	if moadpssdi.TableMap != nil {
		objectMap["tableMap"] = moadpssdi.TableMap
	}
	if moadpssdi.TargetDatabaseName != nil {
		objectMap["targetDatabaseName"] = moadpssdi.TargetDatabaseName
	}
	if moadpssdi.MigrationSetting != nil {
		objectMap["migrationSetting"] = moadpssdi.MigrationSetting
	}
	if moadpssdi.SourceSetting != nil {
		objectMap["sourceSetting"] = moadpssdi.SourceSetting
	}
	if moadpssdi.TargetSetting != nil {
		objectMap["targetSetting"] = moadpssdi.TargetSetting
	}
	return json.Marshal(objectMap)
}

// MigrateOracleAzureDbPostgreSQLSyncTaskInput input for the task that migrates Oracle databases to Azure
// Database for PostgreSQL for online migrations
type MigrateOracleAzureDbPostgreSQLSyncTaskInput struct {
	// SelectedDatabases - Databases to migrate
	SelectedDatabases *[]MigrateOracleAzureDbPostgreSQLSyncDatabaseInput `json:"selectedDatabases,omitempty"`
	// TargetConnectionInfo - Connection information for target Azure Database for PostgreSQL
	TargetConnectionInfo *PostgreSQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
	// SourceConnectionInfo - Connection information for source Oracle
	SourceConnectionInfo *OracleConnectionInfo `json:"sourceConnectionInfo,omitempty"`
}

// BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput output for the task that migrates Oracle databases to Azure
// Database for PostgreSQL for online migrations
type BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput interface {
	AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError, bool)
	AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputError() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputError, bool)
	AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel, bool)
	AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel, bool)
	AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel, bool)
	AsMigrateOracleAzureDbPostgreSQLSyncTaskOutput() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutput, bool)
}

// MigrateOracleAzureDbPostgreSQLSyncTaskOutput output for the task that migrates Oracle databases to Azure
// Database for PostgreSQL for online migrations
type MigrateOracleAzureDbPostgreSQLSyncTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrateOracleAzureDbPostgreSQLSyncTaskOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput `json:"resultType,omitempty"`
}

func unmarshalBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput(body []byte) (BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resultType"] {
	case string(ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput):
		var moadpsstode MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError
		err := json.Unmarshal(body, &moadpsstode)
		return moadpsstode, err
	case string(ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeErrorOutput):
		var moadpsstoe MigrateOracleAzureDbPostgreSQLSyncTaskOutputError
		err := json.Unmarshal(body, &moadpsstoe)
		return moadpsstoe, err
	case string(ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeTableLevelOutput):
		var moadpsstotl MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel
		err := json.Unmarshal(body, &moadpsstotl)
		return moadpsstotl, err
	case string(ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput):
		var moadpsstodl MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel
		err := json.Unmarshal(body, &moadpsstodl)
		return moadpsstodl, err
	case string(ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput):
		var moadpsstoml MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel
		err := json.Unmarshal(body, &moadpsstoml)
		return moadpsstoml, err
	default:
		var moadpssto MigrateOracleAzureDbPostgreSQLSyncTaskOutput
		err := json.Unmarshal(body, &moadpssto)
		return moadpssto, err
	}
}
func unmarshalBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputArray(body []byte) ([]BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	moadpsstoArray := make([]BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		moadpssto, err := unmarshalBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		moadpsstoArray[index] = moadpssto
	}
	return moadpsstoArray, nil
}

// MarshalJSON is the custom marshaler for MigrateOracleAzureDbPostgreSQLSyncTaskOutput.
func (moadpssto MigrateOracleAzureDbPostgreSQLSyncTaskOutput) MarshalJSON() ([]byte, error) {
	moadpssto.ResultType = ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrateOracleAzureDbPostgreSQLSyncTaskOutput
	objectMap := make(map[string]interface{})
	if moadpssto.ResultType != "" {
		objectMap["resultType"] = moadpssto.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutput.
func (moadpssto MigrateOracleAzureDbPostgreSQLSyncTaskOutput) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputError is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutput.
func (moadpssto MigrateOracleAzureDbPostgreSQLSyncTaskOutput) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputError() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutput.
func (moadpssto MigrateOracleAzureDbPostgreSQLSyncTaskOutput) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutput.
func (moadpssto MigrateOracleAzureDbPostgreSQLSyncTaskOutput) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutput.
func (moadpssto MigrateOracleAzureDbPostgreSQLSyncTaskOutput) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutput is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutput.
func (moadpssto MigrateOracleAzureDbPostgreSQLSyncTaskOutput) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutput() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutput, bool) {
	return &moadpssto, true
}

// AsBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutput.
func (moadpssto MigrateOracleAzureDbPostgreSQLSyncTaskOutput) AsBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput() (BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput, bool) {
	return &moadpssto, true
}

// MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError ...
type MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError struct {
	// ErrorMessage - Error message
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// Events - List of error events.
	Events *[]SyncMigrationDatabaseErrorEvent `json:"events,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrateOracleAzureDbPostgreSQLSyncTaskOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError.
func (moadpsstode MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError) MarshalJSON() ([]byte, error) {
	moadpsstode.ResultType = ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput
	objectMap := make(map[string]interface{})
	if moadpsstode.ErrorMessage != nil {
		objectMap["errorMessage"] = moadpsstode.ErrorMessage
	}
	if moadpsstode.Events != nil {
		objectMap["events"] = moadpsstode.Events
	}
	if moadpsstode.ResultType != "" {
		objectMap["resultType"] = moadpsstode.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError.
func (moadpsstode MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError, bool) {
	return &moadpsstode, true
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputError is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError.
func (moadpsstode MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputError() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError.
func (moadpsstode MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError.
func (moadpsstode MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError.
func (moadpsstode MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutput is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError.
func (moadpsstode MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutput() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError.
func (moadpsstode MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError) AsBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput() (BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput, bool) {
	return &moadpsstode, true
}

// MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel ...
type MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel struct {
	// DatabaseName - READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// MigrationState - READ-ONLY; Migration state that this database is in. Possible values include: 'SyncDatabaseMigrationReportingStateUNDEFINED', 'SyncDatabaseMigrationReportingStateCONFIGURING', 'SyncDatabaseMigrationReportingStateINITIALIAZING', 'SyncDatabaseMigrationReportingStateSTARTING', 'SyncDatabaseMigrationReportingStateRUNNING', 'SyncDatabaseMigrationReportingStateREADYTOCOMPLETE', 'SyncDatabaseMigrationReportingStateCOMPLETING', 'SyncDatabaseMigrationReportingStateCOMPLETE', 'SyncDatabaseMigrationReportingStateCANCELLING', 'SyncDatabaseMigrationReportingStateCANCELLED', 'SyncDatabaseMigrationReportingStateFAILED'
	MigrationState SyncDatabaseMigrationReportingState `json:"migrationState,omitempty"`
	// IncomingChanges - READ-ONLY; Number of incoming changes
	IncomingChanges *int64 `json:"incomingChanges,omitempty"`
	// AppliedChanges - READ-ONLY; Number of applied changes
	AppliedChanges *int64 `json:"appliedChanges,omitempty"`
	// CdcInsertCounter - READ-ONLY; Number of cdc inserts
	CdcInsertCounter *int64 `json:"cdcInsertCounter,omitempty"`
	// CdcDeleteCounter - READ-ONLY; Number of cdc deletes
	CdcDeleteCounter *int64 `json:"cdcDeleteCounter,omitempty"`
	// CdcUpdateCounter - READ-ONLY; Number of cdc updates
	CdcUpdateCounter *int64 `json:"cdcUpdateCounter,omitempty"`
	// FullLoadCompletedTables - READ-ONLY; Number of tables completed in full load
	FullLoadCompletedTables *int64 `json:"fullLoadCompletedTables,omitempty"`
	// FullLoadLoadingTables - READ-ONLY; Number of tables loading in full load
	FullLoadLoadingTables *int64 `json:"fullLoadLoadingTables,omitempty"`
	// FullLoadQueuedTables - READ-ONLY; Number of tables queued in full load
	FullLoadQueuedTables *int64 `json:"fullLoadQueuedTables,omitempty"`
	// FullLoadErroredTables - READ-ONLY; Number of tables errored in full load
	FullLoadErroredTables *int64 `json:"fullLoadErroredTables,omitempty"`
	// InitializationCompleted - READ-ONLY; Indicates if initial load (full load) has been completed
	InitializationCompleted *bool `json:"initializationCompleted,omitempty"`
	// Latency - READ-ONLY; CDC apply latency
	Latency *int64 `json:"latency,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrateOracleAzureDbPostgreSQLSyncTaskOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel.
func (moadpsstodl MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	moadpsstodl.ResultType = ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput
	objectMap := make(map[string]interface{})
	if moadpsstodl.ResultType != "" {
		objectMap["resultType"] = moadpsstodl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel.
func (moadpsstodl MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputError is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel.
func (moadpsstodl MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputError() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel.
func (moadpsstodl MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel.
func (moadpsstodl MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel, bool) {
	return &moadpsstodl, true
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel.
func (moadpsstodl MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutput is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel.
func (moadpsstodl MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutput() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel.
func (moadpsstodl MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel) AsBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput() (BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput, bool) {
	return &moadpsstodl, true
}

// MigrateOracleAzureDbPostgreSQLSyncTaskOutputError ...
type MigrateOracleAzureDbPostgreSQLSyncTaskOutputError struct {
	// Error - READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrateOracleAzureDbPostgreSQLSyncTaskOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateOracleAzureDbPostgreSQLSyncTaskOutputError.
func (moadpsstoe MigrateOracleAzureDbPostgreSQLSyncTaskOutputError) MarshalJSON() ([]byte, error) {
	moadpsstoe.ResultType = ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeErrorOutput
	objectMap := make(map[string]interface{})
	if moadpsstoe.ResultType != "" {
		objectMap["resultType"] = moadpsstoe.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputError.
func (moadpsstoe MigrateOracleAzureDbPostgreSQLSyncTaskOutputError) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputError is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputError.
func (moadpsstoe MigrateOracleAzureDbPostgreSQLSyncTaskOutputError) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputError() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputError, bool) {
	return &moadpsstoe, true
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputError.
func (moadpsstoe MigrateOracleAzureDbPostgreSQLSyncTaskOutputError) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputError.
func (moadpsstoe MigrateOracleAzureDbPostgreSQLSyncTaskOutputError) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputError.
func (moadpsstoe MigrateOracleAzureDbPostgreSQLSyncTaskOutputError) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutput is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputError.
func (moadpsstoe MigrateOracleAzureDbPostgreSQLSyncTaskOutputError) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutput() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputError.
func (moadpsstoe MigrateOracleAzureDbPostgreSQLSyncTaskOutputError) AsBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput() (BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput, bool) {
	return &moadpsstoe, true
}

// MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel ...
type MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel struct {
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// SourceServerVersion - READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// SourceServer - READ-ONLY; Source server name
	SourceServer *string `json:"sourceServer,omitempty"`
	// TargetServerVersion - READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServer - READ-ONLY; Target server name
	TargetServer *string `json:"targetServer,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrateOracleAzureDbPostgreSQLSyncTaskOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel.
func (moadpsstoml MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	moadpsstoml.ResultType = ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput
	objectMap := make(map[string]interface{})
	if moadpsstoml.ResultType != "" {
		objectMap["resultType"] = moadpsstoml.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel.
func (moadpsstoml MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputError is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel.
func (moadpsstoml MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputError() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel.
func (moadpsstoml MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel.
func (moadpsstoml MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel.
func (moadpsstoml MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel, bool) {
	return &moadpsstoml, true
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutput is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel.
func (moadpsstoml MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutput() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel.
func (moadpsstoml MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel) AsBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput() (BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput, bool) {
	return &moadpsstoml, true
}

// MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel ...
type MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel struct {
	// TableName - READ-ONLY; Name of the table
	TableName *string `json:"tableName,omitempty"`
	// DatabaseName - READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// CdcInsertCounter - READ-ONLY; Number of applied inserts
	CdcInsertCounter *int64 `json:"cdcInsertCounter,omitempty"`
	// CdcUpdateCounter - READ-ONLY; Number of applied updates
	CdcUpdateCounter *int64 `json:"cdcUpdateCounter,omitempty"`
	// CdcDeleteCounter - READ-ONLY; Number of applied deletes
	CdcDeleteCounter *int64 `json:"cdcDeleteCounter,omitempty"`
	// FullLoadEstFinishTime - READ-ONLY; Estimate to finish full load
	FullLoadEstFinishTime *date.Time `json:"fullLoadEstFinishTime,omitempty"`
	// FullLoadStartedOn - READ-ONLY; Full load start time
	FullLoadStartedOn *date.Time `json:"fullLoadStartedOn,omitempty"`
	// FullLoadEndedOn - READ-ONLY; Full load end time
	FullLoadEndedOn *date.Time `json:"fullLoadEndedOn,omitempty"`
	// FullLoadTotalRows - READ-ONLY; Number of rows applied in full load
	FullLoadTotalRows *int64 `json:"fullLoadTotalRows,omitempty"`
	// State - READ-ONLY; Current state of the table migration. Possible values include: 'SyncTableMigrationStateBEFORELOAD', 'SyncTableMigrationStateFULLLOAD', 'SyncTableMigrationStateCOMPLETED', 'SyncTableMigrationStateCANCELED', 'SyncTableMigrationStateERROR', 'SyncTableMigrationStateFAILED'
	State SyncTableMigrationState `json:"state,omitempty"`
	// TotalChangesApplied - READ-ONLY; Total number of applied changes
	TotalChangesApplied *int64 `json:"totalChangesApplied,omitempty"`
	// DataErrorsCounter - READ-ONLY; Number of data errors occurred
	DataErrorsCounter *int64 `json:"dataErrorsCounter,omitempty"`
	// LastModifiedTime - READ-ONLY; Last modified time on target
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrateOracleAzureDbPostgreSQLSyncTaskOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel.
func (moadpsstotl MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel) MarshalJSON() ([]byte, error) {
	moadpsstotl.ResultType = ResultTypeBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutputResultTypeTableLevelOutput
	objectMap := make(map[string]interface{})
	if moadpsstotl.ResultType != "" {
		objectMap["resultType"] = moadpsstotl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel.
func (moadpsstotl MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputError is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel.
func (moadpsstotl MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputError() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel.
func (moadpsstotl MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel, bool) {
	return &moadpsstotl, true
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel.
func (moadpsstotl MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel.
func (moadpsstotl MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbPostgreSQLSyncTaskOutput is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel.
func (moadpsstotl MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel) AsMigrateOracleAzureDbPostgreSQLSyncTaskOutput() (*MigrateOracleAzureDbPostgreSQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput is the BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput implementation for MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel.
func (moadpsstotl MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel) AsBasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput() (BasicMigrateOracleAzureDbPostgreSQLSyncTaskOutput, bool) {
	return &moadpsstotl, true
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseInput database specific information for PostgreSQL to
// Azure Database for PostgreSQL migration task inputs
type MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseInput struct {
	// Name - Name of the database
	Name *string `json:"name,omitempty"`
	// TargetDatabaseName - Name of target database. Note: Target database will be truncated before starting migration.
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// MigrationSetting - Migration settings which tune the migration behavior
	MigrationSetting map[string]*string `json:"migrationSetting"`
	// SourceSetting - Source settings to tune source endpoint migration behavior
	SourceSetting map[string]*string `json:"sourceSetting"`
	// TargetSetting - Target settings to tune target endpoint migration behavior
	TargetSetting map[string]*string `json:"targetSetting"`
}

// MarshalJSON is the custom marshaler for MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseInput.
func (mpsadfpssdi MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mpsadfpssdi.Name != nil {
		objectMap["name"] = mpsadfpssdi.Name
	}
	if mpsadfpssdi.TargetDatabaseName != nil {
		objectMap["targetDatabaseName"] = mpsadfpssdi.TargetDatabaseName
	}
	if mpsadfpssdi.MigrationSetting != nil {
		objectMap["migrationSetting"] = mpsadfpssdi.MigrationSetting
	}
	if mpsadfpssdi.SourceSetting != nil {
		objectMap["sourceSetting"] = mpsadfpssdi.SourceSetting
	}
	if mpsadfpssdi.TargetSetting != nil {
		objectMap["targetSetting"] = mpsadfpssdi.TargetSetting
	}
	return json.Marshal(objectMap)
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncTaskInput input for the task that migrates PostgreSQL databases
// to Azure Database for PostgreSQL for online migrations
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskInput struct {
	// SelectedDatabases - Databases to migrate
	SelectedDatabases *[]MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseInput `json:"selectedDatabases,omitempty"`
	// TargetConnectionInfo - Connection information for target Azure Database for PostgreSQL
	TargetConnectionInfo *PostgreSQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
	// SourceConnectionInfo - Connection information for source PostgreSQL
	SourceConnectionInfo *PostgreSQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
}

// BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput output for the task that migrates PostgreSQL databases to
// Azure Database for PostgreSQL for online migrations
type BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput interface {
	AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError, bool)
	AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError, bool)
	AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel, bool)
	AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel, bool)
	AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel, bool)
	AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool)
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput output for the task that migrates PostgreSQL databases
// to Azure Database for PostgreSQL for online migrations
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput `json:"resultType,omitempty"`
}

func unmarshalBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput(body []byte) (BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resultType"] {
	case string(ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput):
		var mpsadfpsstode MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError
		err := json.Unmarshal(body, &mpsadfpsstode)
		return mpsadfpsstode, err
	case string(ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeErrorOutput):
		var mpsadfpsstoe MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError
		err := json.Unmarshal(body, &mpsadfpsstoe)
		return mpsadfpsstoe, err
	case string(ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeTableLevelOutput):
		var mpsadfpsstotl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel
		err := json.Unmarshal(body, &mpsadfpsstotl)
		return mpsadfpsstotl, err
	case string(ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput):
		var mpsadfpsstodl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel
		err := json.Unmarshal(body, &mpsadfpsstodl)
		return mpsadfpsstodl, err
	case string(ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput):
		var mpsadfpsstoml MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel
		err := json.Unmarshal(body, &mpsadfpsstoml)
		return mpsadfpsstoml, err
	default:
		var mpsadfpssto MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput
		err := json.Unmarshal(body, &mpsadfpssto)
		return mpsadfpssto, err
	}
}
func unmarshalBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputArray(body []byte) ([]BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	mpsadfpsstoArray := make([]BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mpsadfpssto, err := unmarshalBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		mpsadfpsstoArray[index] = mpsadfpssto
	}
	return mpsadfpsstoArray, nil
}

// MarshalJSON is the custom marshaler for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput.
func (mpsadfpssto MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput) MarshalJSON() ([]byte, error) {
	mpsadfpssto.ResultType = ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput
	objectMap := make(map[string]interface{})
	if mpsadfpssto.ResultType != "" {
		objectMap["resultType"] = mpsadfpssto.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput.
func (mpsadfpssto MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput.
func (mpsadfpssto MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput.
func (mpsadfpssto MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput.
func (mpsadfpssto MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput.
func (mpsadfpssto MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput.
func (mpsadfpssto MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return &mpsadfpssto, true
}

// AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput.
func (mpsadfpssto MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput) AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return &mpsadfpssto, true
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError ...
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError struct {
	// ErrorMessage - Error message
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// Events - List of error events.
	Events *[]SyncMigrationDatabaseErrorEvent `json:"events,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError.
func (mpsadfpsstode MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError) MarshalJSON() ([]byte, error) {
	mpsadfpsstode.ResultType = ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput
	objectMap := make(map[string]interface{})
	if mpsadfpsstode.ErrorMessage != nil {
		objectMap["errorMessage"] = mpsadfpsstode.ErrorMessage
	}
	if mpsadfpsstode.Events != nil {
		objectMap["events"] = mpsadfpsstode.Events
	}
	if mpsadfpsstode.ResultType != "" {
		objectMap["resultType"] = mpsadfpsstode.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError.
func (mpsadfpsstode MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError, bool) {
	return &mpsadfpsstode, true
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError.
func (mpsadfpsstode MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError.
func (mpsadfpsstode MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError.
func (mpsadfpsstode MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError.
func (mpsadfpsstode MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError.
func (mpsadfpsstode MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError.
func (mpsadfpsstode MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError) AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return &mpsadfpsstode, true
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel ...
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel struct {
	// DatabaseName - READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// MigrationState - READ-ONLY; Migration state that this database is in. Possible values include: 'SyncDatabaseMigrationReportingStateUNDEFINED', 'SyncDatabaseMigrationReportingStateCONFIGURING', 'SyncDatabaseMigrationReportingStateINITIALIAZING', 'SyncDatabaseMigrationReportingStateSTARTING', 'SyncDatabaseMigrationReportingStateRUNNING', 'SyncDatabaseMigrationReportingStateREADYTOCOMPLETE', 'SyncDatabaseMigrationReportingStateCOMPLETING', 'SyncDatabaseMigrationReportingStateCOMPLETE', 'SyncDatabaseMigrationReportingStateCANCELLING', 'SyncDatabaseMigrationReportingStateCANCELLED', 'SyncDatabaseMigrationReportingStateFAILED'
	MigrationState SyncDatabaseMigrationReportingState `json:"migrationState,omitempty"`
	// IncomingChanges - READ-ONLY; Number of incoming changes
	IncomingChanges *int64 `json:"incomingChanges,omitempty"`
	// AppliedChanges - READ-ONLY; Number of applied changes
	AppliedChanges *int64 `json:"appliedChanges,omitempty"`
	// CdcInsertCounter - READ-ONLY; Number of cdc inserts
	CdcInsertCounter *int64 `json:"cdcInsertCounter,omitempty"`
	// CdcDeleteCounter - READ-ONLY; Number of cdc deletes
	CdcDeleteCounter *int64 `json:"cdcDeleteCounter,omitempty"`
	// CdcUpdateCounter - READ-ONLY; Number of cdc updates
	CdcUpdateCounter *int64 `json:"cdcUpdateCounter,omitempty"`
	// FullLoadCompletedTables - READ-ONLY; Number of tables completed in full load
	FullLoadCompletedTables *int64 `json:"fullLoadCompletedTables,omitempty"`
	// FullLoadLoadingTables - READ-ONLY; Number of tables loading in full load
	FullLoadLoadingTables *int64 `json:"fullLoadLoadingTables,omitempty"`
	// FullLoadQueuedTables - READ-ONLY; Number of tables queued in full load
	FullLoadQueuedTables *int64 `json:"fullLoadQueuedTables,omitempty"`
	// FullLoadErroredTables - READ-ONLY; Number of tables errored in full load
	FullLoadErroredTables *int64 `json:"fullLoadErroredTables,omitempty"`
	// InitializationCompleted - READ-ONLY; Indicates if initial load (full load) has been completed
	InitializationCompleted *bool `json:"initializationCompleted,omitempty"`
	// Latency - READ-ONLY; CDC apply latency
	Latency *int64 `json:"latency,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel.
func (mpsadfpsstodl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	mpsadfpsstodl.ResultType = ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput
	objectMap := make(map[string]interface{})
	if mpsadfpsstodl.ResultType != "" {
		objectMap["resultType"] = mpsadfpsstodl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel.
func (mpsadfpsstodl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel.
func (mpsadfpsstodl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel.
func (mpsadfpsstodl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel.
func (mpsadfpsstodl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel, bool) {
	return &mpsadfpsstodl, true
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel.
func (mpsadfpsstodl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel.
func (mpsadfpsstodl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel.
func (mpsadfpsstodl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel) AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return &mpsadfpsstodl, true
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError ...
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError struct {
	// Error - READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError.
func (mpsadfpsstoe MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError) MarshalJSON() ([]byte, error) {
	mpsadfpsstoe.ResultType = ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeErrorOutput
	objectMap := make(map[string]interface{})
	if mpsadfpsstoe.ResultType != "" {
		objectMap["resultType"] = mpsadfpsstoe.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError.
func (mpsadfpsstoe MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError.
func (mpsadfpsstoe MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError, bool) {
	return &mpsadfpsstoe, true
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError.
func (mpsadfpsstoe MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError.
func (mpsadfpsstoe MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError.
func (mpsadfpsstoe MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError.
func (mpsadfpsstoe MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError.
func (mpsadfpsstoe MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError) AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return &mpsadfpsstoe, true
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel ...
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel struct {
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// SourceServerVersion - READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// SourceServer - READ-ONLY; Source server name
	SourceServer *string `json:"sourceServer,omitempty"`
	// TargetServerVersion - READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServer - READ-ONLY; Target server name
	TargetServer *string `json:"targetServer,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel.
func (mpsadfpsstoml MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	mpsadfpsstoml.ResultType = ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput
	objectMap := make(map[string]interface{})
	if mpsadfpsstoml.ResultType != "" {
		objectMap["resultType"] = mpsadfpsstoml.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel.
func (mpsadfpsstoml MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel.
func (mpsadfpsstoml MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel.
func (mpsadfpsstoml MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel.
func (mpsadfpsstoml MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel.
func (mpsadfpsstoml MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel, bool) {
	return &mpsadfpsstoml, true
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel.
func (mpsadfpsstoml MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel.
func (mpsadfpsstoml MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel) AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return &mpsadfpsstoml, true
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel ...
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel struct {
	// TableName - READ-ONLY; Name of the table
	TableName *string `json:"tableName,omitempty"`
	// DatabaseName - READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// CdcInsertCounter - READ-ONLY; Number of applied inserts
	CdcInsertCounter *int64 `json:"cdcInsertCounter,omitempty"`
	// CdcUpdateCounter - READ-ONLY; Number of applied updates
	CdcUpdateCounter *int64 `json:"cdcUpdateCounter,omitempty"`
	// CdcDeleteCounter - READ-ONLY; Number of applied deletes
	CdcDeleteCounter *int64 `json:"cdcDeleteCounter,omitempty"`
	// FullLoadEstFinishTime - READ-ONLY; Estimate to finish full load
	FullLoadEstFinishTime *date.Time `json:"fullLoadEstFinishTime,omitempty"`
	// FullLoadStartedOn - READ-ONLY; Full load start time
	FullLoadStartedOn *date.Time `json:"fullLoadStartedOn,omitempty"`
	// FullLoadEndedOn - READ-ONLY; Full load end time
	FullLoadEndedOn *date.Time `json:"fullLoadEndedOn,omitempty"`
	// FullLoadTotalRows - READ-ONLY; Number of rows applied in full load
	FullLoadTotalRows *int64 `json:"fullLoadTotalRows,omitempty"`
	// State - READ-ONLY; Current state of the table migration. Possible values include: 'SyncTableMigrationStateBEFORELOAD', 'SyncTableMigrationStateFULLLOAD', 'SyncTableMigrationStateCOMPLETED', 'SyncTableMigrationStateCANCELED', 'SyncTableMigrationStateERROR', 'SyncTableMigrationStateFAILED'
	State SyncTableMigrationState `json:"state,omitempty"`
	// TotalChangesApplied - READ-ONLY; Total number of applied changes
	TotalChangesApplied *int64 `json:"totalChangesApplied,omitempty"`
	// DataErrorsCounter - READ-ONLY; Number of data errors occurred
	DataErrorsCounter *int64 `json:"dataErrorsCounter,omitempty"`
	// LastModifiedTime - READ-ONLY; Last modified time on target
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel.
func (mpsadfpsstotl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel) MarshalJSON() ([]byte, error) {
	mpsadfpsstotl.ResultType = ResultTypeBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputResultTypeTableLevelOutput
	objectMap := make(map[string]interface{})
	if mpsadfpsstotl.ResultType != "" {
		objectMap["resultType"] = mpsadfpsstotl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel.
func (mpsadfpsstotl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel.
func (mpsadfpsstotl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel.
func (mpsadfpsstotl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel, bool) {
	return &mpsadfpsstotl, true
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel.
func (mpsadfpsstotl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel.
func (mpsadfpsstotl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel.
func (mpsadfpsstotl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel.
func (mpsadfpsstotl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel) AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return &mpsadfpsstotl, true
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties properties for the task that migrates PostgreSQL
// databases to Azure Database for PostgreSQL for online migrations
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties struct {
	// Input - Task input
	Input *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) MarshalJSON() ([]byte, error) {
	mpsadfpsstp.TaskType = TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync
	objectMap := make(map[string]interface{})
	if mpsadfpsstp.Input != nil {
		objectMap["input"] = mpsadfpsstp.Input
	}
	if mpsadfpsstp.ClientData != nil {
		objectMap["clientData"] = mpsadfpsstp.ClientData
	}
	if mpsadfpsstp.TaskType != "" {
		objectMap["taskType"] = mpsadfpsstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return &mpsadfpsstp, true
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &mpsadfpsstp, true
}

// UnmarshalJSON is the custom unmarshaler for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties struct.
func (mpsadfpsstp *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input MigratePostgreSQLAzureDbForPostgreSQLSyncTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				mpsadfpsstp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputArray(*v)
				if err != nil {
					return err
				}
				mpsadfpsstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				mpsadfpsstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				mpsadfpsstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				mpsadfpsstp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				mpsadfpsstp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				mpsadfpsstp.TaskType = taskType
			}
		}
	}

	return nil
}

// MigrateSchemaSQLServerSQLDbDatabaseInput database input for migrate schema Sql Server to Azure SQL
// Server scenario
type MigrateSchemaSQLServerSQLDbDatabaseInput struct {
	// Name - Name of source database
	Name *string `json:"name,omitempty"`
	// TargetDatabaseName - Name of target database
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// SchemaSetting - Database schema migration settings
	SchemaSetting *SchemaMigrationSetting `json:"schemaSetting,omitempty"`
}

// MigrateSchemaSQLServerSQLDbTaskInput input for task that migrates Schema for SQL Server databases to
// Azure SQL databases
type MigrateSchemaSQLServerSQLDbTaskInput struct {
	// SelectedDatabases - Databases to migrate
	SelectedDatabases *[]MigrateSchemaSQLServerSQLDbDatabaseInput `json:"selectedDatabases,omitempty"`
	// SourceConnectionInfo - Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// BasicMigrateSchemaSQLServerSQLDbTaskOutput output for the task that migrates Schema for SQL Server databases to
// Azure SQL databases
type BasicMigrateSchemaSQLServerSQLDbTaskOutput interface {
	AsMigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel, bool)
	AsMigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel, bool)
	AsMigrateSchemaSQLServerSQLDbTaskOutputError() (*MigrateSchemaSQLServerSQLDbTaskOutputError, bool)
	AsMigrateSchemaSQLTaskOutputError() (*MigrateSchemaSQLTaskOutputError, bool)
	AsMigrateSchemaSQLServerSQLDbTaskOutput() (*MigrateSchemaSQLServerSQLDbTaskOutput, bool)
}

// MigrateSchemaSQLServerSQLDbTaskOutput output for the task that migrates Schema for SQL Server databases to
// Azure SQL databases
type MigrateSchemaSQLServerSQLDbTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrateSchemaSQLServerSQLDbTaskOutput', 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput', 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeSchemaErrorOutput', 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeErrorOutput'
	ResultType ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput `json:"resultType,omitempty"`
}

func unmarshalBasicMigrateSchemaSQLServerSQLDbTaskOutput(body []byte) (BasicMigrateSchemaSQLServerSQLDbTaskOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resultType"] {
	case string(ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput):
		var mssssdtoml MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel
		err := json.Unmarshal(body, &mssssdtoml)
		return mssssdtoml, err
	case string(ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput):
		var mssssdtodl MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel
		err := json.Unmarshal(body, &mssssdtodl)
		return mssssdtodl, err
	case string(ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeSchemaErrorOutput):
		var mssssdtoe MigrateSchemaSQLServerSQLDbTaskOutputError
		err := json.Unmarshal(body, &mssssdtoe)
		return mssssdtoe, err
	case string(ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeErrorOutput):
		var msstoe MigrateSchemaSQLTaskOutputError
		err := json.Unmarshal(body, &msstoe)
		return msstoe, err
	default:
		var mssssdto MigrateSchemaSQLServerSQLDbTaskOutput
		err := json.Unmarshal(body, &mssssdto)
		return mssssdto, err
	}
}
func unmarshalBasicMigrateSchemaSQLServerSQLDbTaskOutputArray(body []byte) ([]BasicMigrateSchemaSQLServerSQLDbTaskOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	mssssdtoArray := make([]BasicMigrateSchemaSQLServerSQLDbTaskOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mssssdto, err := unmarshalBasicMigrateSchemaSQLServerSQLDbTaskOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		mssssdtoArray[index] = mssssdto
	}
	return mssssdtoArray, nil
}

// MarshalJSON is the custom marshaler for MigrateSchemaSQLServerSQLDbTaskOutput.
func (mssssdto MigrateSchemaSQLServerSQLDbTaskOutput) MarshalJSON() ([]byte, error) {
	mssssdto.ResultType = ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrateSchemaSQLServerSQLDbTaskOutput
	objectMap := make(map[string]interface{})
	if mssssdto.ResultType != "" {
		objectMap["resultType"] = mssssdto.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutput.
func (mssssdto MigrateSchemaSQLServerSQLDbTaskOutput) AsMigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutput.
func (mssssdto MigrateSchemaSQLServerSQLDbTaskOutput) AsMigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskOutputError is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutput.
func (mssssdto MigrateSchemaSQLServerSQLDbTaskOutput) AsMigrateSchemaSQLServerSQLDbTaskOutputError() (*MigrateSchemaSQLServerSQLDbTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSchemaSQLTaskOutputError is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutput.
func (mssssdto MigrateSchemaSQLServerSQLDbTaskOutput) AsMigrateSchemaSQLTaskOutputError() (*MigrateSchemaSQLTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskOutput is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutput.
func (mssssdto MigrateSchemaSQLServerSQLDbTaskOutput) AsMigrateSchemaSQLServerSQLDbTaskOutput() (*MigrateSchemaSQLServerSQLDbTaskOutput, bool) {
	return &mssssdto, true
}

// AsBasicMigrateSchemaSQLServerSQLDbTaskOutput is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutput.
func (mssssdto MigrateSchemaSQLServerSQLDbTaskOutput) AsBasicMigrateSchemaSQLServerSQLDbTaskOutput() (BasicMigrateSchemaSQLServerSQLDbTaskOutput, bool) {
	return &mssssdto, true
}

// MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel ...
type MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel struct {
	// DatabaseName - READ-ONLY; The name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// State - READ-ONLY; State of the schema migration for this database. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// Stage - READ-ONLY; Schema migration stage for this database. Possible values include: 'SchemaMigrationStageNotStarted', 'SchemaMigrationStageValidatingInputs', 'SchemaMigrationStageCollectingObjects', 'SchemaMigrationStageDownloadingScript', 'SchemaMigrationStageGeneratingScript', 'SchemaMigrationStageUploadingScript', 'SchemaMigrationStageDeployingSchema', 'SchemaMigrationStageCompleted', 'SchemaMigrationStageCompletedWithWarnings', 'SchemaMigrationStageFailed'
	Stage SchemaMigrationStage `json:"stage,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// DatabaseErrorResultPrefix - READ-ONLY; Prefix string to use for querying errors for this database
	DatabaseErrorResultPrefix *string `json:"databaseErrorResultPrefix,omitempty"`
	// SchemaErrorResultPrefix - READ-ONLY; Prefix string to use for querying schema errors for this database
	SchemaErrorResultPrefix *string `json:"schemaErrorResultPrefix,omitempty"`
	// NumberOfSuccessfulOperations - READ-ONLY; Number of successful operations for this database
	NumberOfSuccessfulOperations *int64 `json:"numberOfSuccessfulOperations,omitempty"`
	// NumberOfFailedOperations - READ-ONLY; Number of failed operations for this database
	NumberOfFailedOperations *int64 `json:"numberOfFailedOperations,omitempty"`
	// FileID - READ-ONLY; Identifier for the file resource containing the schema of this database
	FileID *string `json:"fileId,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrateSchemaSQLServerSQLDbTaskOutput', 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput', 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeSchemaErrorOutput', 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeErrorOutput'
	ResultType ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel.
func (mssssdtodl MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	mssssdtodl.ResultType = ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput
	objectMap := make(map[string]interface{})
	if mssssdtodl.ResultType != "" {
		objectMap["resultType"] = mssssdtodl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel.
func (mssssdtodl MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel.
func (mssssdtodl MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return &mssssdtodl, true
}

// AsMigrateSchemaSQLServerSQLDbTaskOutputError is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel.
func (mssssdtodl MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSchemaSQLServerSQLDbTaskOutputError() (*MigrateSchemaSQLServerSQLDbTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSchemaSQLTaskOutputError is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel.
func (mssssdtodl MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSchemaSQLTaskOutputError() (*MigrateSchemaSQLTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskOutput is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel.
func (mssssdtodl MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSchemaSQLServerSQLDbTaskOutput() (*MigrateSchemaSQLServerSQLDbTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSchemaSQLServerSQLDbTaskOutput is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel.
func (mssssdtodl MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel) AsBasicMigrateSchemaSQLServerSQLDbTaskOutput() (BasicMigrateSchemaSQLServerSQLDbTaskOutput, bool) {
	return &mssssdtodl, true
}

// MigrateSchemaSQLServerSQLDbTaskOutputError ...
type MigrateSchemaSQLServerSQLDbTaskOutputError struct {
	// CommandText - READ-ONLY; Schema command which failed
	CommandText *string `json:"commandText,omitempty"`
	// ErrorText - READ-ONLY; Reason of failure
	ErrorText *string `json:"errorText,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrateSchemaSQLServerSQLDbTaskOutput', 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput', 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeSchemaErrorOutput', 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeErrorOutput'
	ResultType ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSchemaSQLServerSQLDbTaskOutputError.
func (mssssdtoe MigrateSchemaSQLServerSQLDbTaskOutputError) MarshalJSON() ([]byte, error) {
	mssssdtoe.ResultType = ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeSchemaErrorOutput
	objectMap := make(map[string]interface{})
	if mssssdtoe.ResultType != "" {
		objectMap["resultType"] = mssssdtoe.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutputError.
func (mssssdtoe MigrateSchemaSQLServerSQLDbTaskOutputError) AsMigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutputError.
func (mssssdtoe MigrateSchemaSQLServerSQLDbTaskOutputError) AsMigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskOutputError is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutputError.
func (mssssdtoe MigrateSchemaSQLServerSQLDbTaskOutputError) AsMigrateSchemaSQLServerSQLDbTaskOutputError() (*MigrateSchemaSQLServerSQLDbTaskOutputError, bool) {
	return &mssssdtoe, true
}

// AsMigrateSchemaSQLTaskOutputError is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutputError.
func (mssssdtoe MigrateSchemaSQLServerSQLDbTaskOutputError) AsMigrateSchemaSQLTaskOutputError() (*MigrateSchemaSQLTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskOutput is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutputError.
func (mssssdtoe MigrateSchemaSQLServerSQLDbTaskOutputError) AsMigrateSchemaSQLServerSQLDbTaskOutput() (*MigrateSchemaSQLServerSQLDbTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSchemaSQLServerSQLDbTaskOutput is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutputError.
func (mssssdtoe MigrateSchemaSQLServerSQLDbTaskOutputError) AsBasicMigrateSchemaSQLServerSQLDbTaskOutput() (BasicMigrateSchemaSQLServerSQLDbTaskOutput, bool) {
	return &mssssdtoe, true
}

// MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel ...
type MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel struct {
	// State - READ-ONLY; Overall state of the schema migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// SourceServerVersion - READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// SourceServerBrandVersion - READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty"`
	// TargetServerVersion - READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServerBrandVersion - READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrateSchemaSQLServerSQLDbTaskOutput', 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput', 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeSchemaErrorOutput', 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeErrorOutput'
	ResultType ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel.
func (mssssdtoml MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	mssssdtoml.ResultType = ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput
	objectMap := make(map[string]interface{})
	if mssssdtoml.ResultType != "" {
		objectMap["resultType"] = mssssdtoml.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel.
func (mssssdtoml MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return &mssssdtoml, true
}

// AsMigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel.
func (mssssdtoml MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskOutputError is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel.
func (mssssdtoml MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSchemaSQLServerSQLDbTaskOutputError() (*MigrateSchemaSQLServerSQLDbTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSchemaSQLTaskOutputError is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel.
func (mssssdtoml MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSchemaSQLTaskOutputError() (*MigrateSchemaSQLTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskOutput is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel.
func (mssssdtoml MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSchemaSQLServerSQLDbTaskOutput() (*MigrateSchemaSQLServerSQLDbTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSchemaSQLServerSQLDbTaskOutput is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel.
func (mssssdtoml MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel) AsBasicMigrateSchemaSQLServerSQLDbTaskOutput() (BasicMigrateSchemaSQLServerSQLDbTaskOutput, bool) {
	return &mssssdtoml, true
}

// MigrateSchemaSQLServerSQLDbTaskProperties properties for task that migrates Schema for SQL Server
// databases to Azure SQL databases
type MigrateSchemaSQLServerSQLDbTaskProperties struct {
	// Input - Task input
	Input *MigrateSchemaSQLServerSQLDbTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]BasicMigrateSchemaSQLServerSQLDbTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) MarshalJSON() ([]byte, error) {
	mssssdtp.TaskType = TaskTypeMigrateSchemaSQLServerSQLDb
	objectMap := make(map[string]interface{})
	if mssssdtp.Input != nil {
		objectMap["input"] = mssssdtp.Input
	}
	if mssssdtp.ClientData != nil {
		objectMap["clientData"] = mssssdtp.ClientData
	}
	if mssssdtp.TaskType != "" {
		objectMap["taskType"] = mssssdtp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return &mssssdtp, true
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSchemaSQLServerSQLDbTaskProperties.
func (mssssdtp MigrateSchemaSQLServerSQLDbTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &mssssdtp, true
}

// UnmarshalJSON is the custom unmarshaler for MigrateSchemaSQLServerSQLDbTaskProperties struct.
func (mssssdtp *MigrateSchemaSQLServerSQLDbTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input MigrateSchemaSQLServerSQLDbTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				mssssdtp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMigrateSchemaSQLServerSQLDbTaskOutputArray(*v)
				if err != nil {
					return err
				}
				mssssdtp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				mssssdtp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				mssssdtp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				mssssdtp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				mssssdtp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				mssssdtp.TaskType = taskType
			}
		}
	}

	return nil
}

// MigrateSchemaSQLTaskOutputError ...
type MigrateSchemaSQLTaskOutputError struct {
	// Error - READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrateSchemaSQLServerSQLDbTaskOutput', 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput', 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeSchemaErrorOutput', 'ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeErrorOutput'
	ResultType ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSchemaSQLTaskOutputError.
func (msstoe MigrateSchemaSQLTaskOutputError) MarshalJSON() ([]byte, error) {
	msstoe.ResultType = ResultTypeBasicMigrateSchemaSQLServerSQLDbTaskOutputResultTypeErrorOutput
	objectMap := make(map[string]interface{})
	if msstoe.ResultType != "" {
		objectMap["resultType"] = msstoe.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLTaskOutputError.
func (msstoe MigrateSchemaSQLTaskOutputError) AsMigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLTaskOutputError.
func (msstoe MigrateSchemaSQLTaskOutputError) AsMigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskOutputError is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLTaskOutputError.
func (msstoe MigrateSchemaSQLTaskOutputError) AsMigrateSchemaSQLServerSQLDbTaskOutputError() (*MigrateSchemaSQLServerSQLDbTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSchemaSQLTaskOutputError is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLTaskOutputError.
func (msstoe MigrateSchemaSQLTaskOutputError) AsMigrateSchemaSQLTaskOutputError() (*MigrateSchemaSQLTaskOutputError, bool) {
	return &msstoe, true
}

// AsMigrateSchemaSQLServerSQLDbTaskOutput is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLTaskOutputError.
func (msstoe MigrateSchemaSQLTaskOutputError) AsMigrateSchemaSQLServerSQLDbTaskOutput() (*MigrateSchemaSQLServerSQLDbTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSchemaSQLServerSQLDbTaskOutput is the BasicMigrateSchemaSQLServerSQLDbTaskOutput implementation for MigrateSchemaSQLTaskOutputError.
func (msstoe MigrateSchemaSQLTaskOutputError) AsBasicMigrateSchemaSQLServerSQLDbTaskOutput() (BasicMigrateSchemaSQLServerSQLDbTaskOutput, bool) {
	return &msstoe, true
}

// MigrateSQLServerSQLDbDatabaseInput database specific information for SQL to Azure SQL DB migration task
// inputs
type MigrateSQLServerSQLDbDatabaseInput struct {
	// Name - Name of the database
	Name *string `json:"name,omitempty"`
	// TargetDatabaseName - Name of target database. Note: Target database will be truncated before starting migration.
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// MakeSourceDbReadOnly - Whether to set database read only before migration
	MakeSourceDbReadOnly *bool `json:"makeSourceDbReadOnly,omitempty"`
	// TableMap - Mapping of source to target tables
	TableMap map[string]*string `json:"tableMap"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbDatabaseInput.
func (msssddi MigrateSQLServerSQLDbDatabaseInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msssddi.Name != nil {
		objectMap["name"] = msssddi.Name
	}
	if msssddi.TargetDatabaseName != nil {
		objectMap["targetDatabaseName"] = msssddi.TargetDatabaseName
	}
	if msssddi.MakeSourceDbReadOnly != nil {
		objectMap["makeSourceDbReadOnly"] = msssddi.MakeSourceDbReadOnly
	}
	if msssddi.TableMap != nil {
		objectMap["tableMap"] = msssddi.TableMap
	}
	return json.Marshal(objectMap)
}

// MigrateSQLServerSQLDbSyncDatabaseInput database specific information for SQL to Azure SQL DB sync
// migration task inputs
type MigrateSQLServerSQLDbSyncDatabaseInput struct {
	// ID - Unique identifier for database
	ID *string `json:"id,omitempty"`
	// Name - Name of database
	Name *string `json:"name,omitempty"`
	// TargetDatabaseName - Target database name
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// SchemaName - Schema name to be migrated
	SchemaName *string `json:"schemaName,omitempty"`
	// TableMap - Mapping of source to target tables
	TableMap map[string]*string `json:"tableMap"`
	// MigrationSetting - Migration settings which tune the migration behavior
	MigrationSetting map[string]*string `json:"migrationSetting"`
	// SourceSetting - Source settings to tune source endpoint migration behavior
	SourceSetting map[string]*string `json:"sourceSetting"`
	// TargetSetting - Target settings to tune target endpoint migration behavior
	TargetSetting map[string]*string `json:"targetSetting"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbSyncDatabaseInput.
func (msssdsdi MigrateSQLServerSQLDbSyncDatabaseInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msssdsdi.ID != nil {
		objectMap["id"] = msssdsdi.ID
	}
	if msssdsdi.Name != nil {
		objectMap["name"] = msssdsdi.Name
	}
	if msssdsdi.TargetDatabaseName != nil {
		objectMap["targetDatabaseName"] = msssdsdi.TargetDatabaseName
	}
	if msssdsdi.SchemaName != nil {
		objectMap["schemaName"] = msssdsdi.SchemaName
	}
	if msssdsdi.TableMap != nil {
		objectMap["tableMap"] = msssdsdi.TableMap
	}
	if msssdsdi.MigrationSetting != nil {
		objectMap["migrationSetting"] = msssdsdi.MigrationSetting
	}
	if msssdsdi.SourceSetting != nil {
		objectMap["sourceSetting"] = msssdsdi.SourceSetting
	}
	if msssdsdi.TargetSetting != nil {
		objectMap["targetSetting"] = msssdsdi.TargetSetting
	}
	return json.Marshal(objectMap)
}

// MigrateSQLServerSQLDbSyncTaskInput input for the task that migrates on-prem SQL Server databases to
// Azure SQL Database for online migrations
type MigrateSQLServerSQLDbSyncTaskInput struct {
	// SelectedDatabases - Databases to migrate
	SelectedDatabases *[]MigrateSQLServerSQLDbSyncDatabaseInput `json:"selectedDatabases,omitempty"`
	// ValidationOptions - Validation options
	ValidationOptions *MigrationValidationOptions `json:"validationOptions,omitempty"`
	// SourceConnectionInfo - Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// BasicMigrateSQLServerSQLDbSyncTaskOutput output for the task that migrates on-prem SQL Server databases to Azure SQL
// Database for online migrations
type BasicMigrateSQLServerSQLDbSyncTaskOutput interface {
	AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseError, bool)
	AsMigrateSQLServerSQLDbSyncTaskOutputError() (*MigrateSQLServerSQLDbSyncTaskOutputError, bool)
	AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel() (*MigrateSQLServerSQLDbSyncTaskOutputTableLevel, bool)
	AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel, bool)
	AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel, bool)
	AsMigrateSQLServerSQLDbSyncTaskOutput() (*MigrateSQLServerSQLDbSyncTaskOutput, bool)
}

// MigrateSQLServerSQLDbSyncTaskOutput output for the task that migrates on-prem SQL Server databases to Azure
// SQL Database for online migrations
type MigrateSQLServerSQLDbSyncTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput `json:"resultType,omitempty"`
}

func unmarshalBasicMigrateSQLServerSQLDbSyncTaskOutput(body []byte) (BasicMigrateSQLServerSQLDbSyncTaskOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resultType"] {
	case string(ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput):
		var msssdstode MigrateSQLServerSQLDbSyncTaskOutputDatabaseError
		err := json.Unmarshal(body, &msssdstode)
		return msssdstode, err
	case string(ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput):
		var msssdstoe MigrateSQLServerSQLDbSyncTaskOutputError
		err := json.Unmarshal(body, &msssdstoe)
		return msssdstoe, err
	case string(ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput):
		var msssdstotl MigrateSQLServerSQLDbSyncTaskOutputTableLevel
		err := json.Unmarshal(body, &msssdstotl)
		return msssdstotl, err
	case string(ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput):
		var msssdstodl MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel
		err := json.Unmarshal(body, &msssdstodl)
		return msssdstodl, err
	case string(ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput):
		var msssdstoml MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel
		err := json.Unmarshal(body, &msssdstoml)
		return msssdstoml, err
	default:
		var msssdsto MigrateSQLServerSQLDbSyncTaskOutput
		err := json.Unmarshal(body, &msssdsto)
		return msssdsto, err
	}
}
func unmarshalBasicMigrateSQLServerSQLDbSyncTaskOutputArray(body []byte) ([]BasicMigrateSQLServerSQLDbSyncTaskOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	msssdstoArray := make([]BasicMigrateSQLServerSQLDbSyncTaskOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		msssdsto, err := unmarshalBasicMigrateSQLServerSQLDbSyncTaskOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		msssdstoArray[index] = msssdsto
	}
	return msssdstoArray, nil
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbSyncTaskOutput.
func (msssdsto MigrateSQLServerSQLDbSyncTaskOutput) MarshalJSON() ([]byte, error) {
	msssdsto.ResultType = ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput
	objectMap := make(map[string]interface{})
	if msssdsto.ResultType != "" {
		objectMap["resultType"] = msssdsto.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutput.
func (msssdsto MigrateSQLServerSQLDbSyncTaskOutput) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutput.
func (msssdsto MigrateSQLServerSQLDbSyncTaskOutput) AsMigrateSQLServerSQLDbSyncTaskOutputError() (*MigrateSQLServerSQLDbSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutput.
func (msssdsto MigrateSQLServerSQLDbSyncTaskOutput) AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel() (*MigrateSQLServerSQLDbSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutput.
func (msssdsto MigrateSQLServerSQLDbSyncTaskOutput) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutput.
func (msssdsto MigrateSQLServerSQLDbSyncTaskOutput) AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutput.
func (msssdsto MigrateSQLServerSQLDbSyncTaskOutput) AsMigrateSQLServerSQLDbSyncTaskOutput() (*MigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return &msssdsto, true
}

// AsBasicMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutput.
func (msssdsto MigrateSQLServerSQLDbSyncTaskOutput) AsBasicMigrateSQLServerSQLDbSyncTaskOutput() (BasicMigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return &msssdsto, true
}

// MigrateSQLServerSQLDbSyncTaskOutputDatabaseError ...
type MigrateSQLServerSQLDbSyncTaskOutputDatabaseError struct {
	// ErrorMessage - Error message
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// Events - List of error events.
	Events *[]SyncMigrationDatabaseErrorEvent `json:"events,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbSyncTaskOutputDatabaseError.
func (msssdstode MigrateSQLServerSQLDbSyncTaskOutputDatabaseError) MarshalJSON() ([]byte, error) {
	msssdstode.ResultType = ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput
	objectMap := make(map[string]interface{})
	if msssdstode.ErrorMessage != nil {
		objectMap["errorMessage"] = msssdstode.ErrorMessage
	}
	if msssdstode.Events != nil {
		objectMap["events"] = msssdstode.Events
	}
	if msssdstode.ResultType != "" {
		objectMap["resultType"] = msssdstode.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseError.
func (msssdstode MigrateSQLServerSQLDbSyncTaskOutputDatabaseError) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseError, bool) {
	return &msssdstode, true
}

// AsMigrateSQLServerSQLDbSyncTaskOutputError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseError.
func (msssdstode MigrateSQLServerSQLDbSyncTaskOutputDatabaseError) AsMigrateSQLServerSQLDbSyncTaskOutputError() (*MigrateSQLServerSQLDbSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseError.
func (msssdstode MigrateSQLServerSQLDbSyncTaskOutputDatabaseError) AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel() (*MigrateSQLServerSQLDbSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseError.
func (msssdstode MigrateSQLServerSQLDbSyncTaskOutputDatabaseError) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseError.
func (msssdstode MigrateSQLServerSQLDbSyncTaskOutputDatabaseError) AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseError.
func (msssdstode MigrateSQLServerSQLDbSyncTaskOutputDatabaseError) AsMigrateSQLServerSQLDbSyncTaskOutput() (*MigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseError.
func (msssdstode MigrateSQLServerSQLDbSyncTaskOutputDatabaseError) AsBasicMigrateSQLServerSQLDbSyncTaskOutput() (BasicMigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return &msssdstode, true
}

// MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel ...
type MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel struct {
	// DatabaseName - READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// MigrationState - READ-ONLY; Migration state that this database is in. Possible values include: 'SyncDatabaseMigrationReportingStateUNDEFINED', 'SyncDatabaseMigrationReportingStateCONFIGURING', 'SyncDatabaseMigrationReportingStateINITIALIAZING', 'SyncDatabaseMigrationReportingStateSTARTING', 'SyncDatabaseMigrationReportingStateRUNNING', 'SyncDatabaseMigrationReportingStateREADYTOCOMPLETE', 'SyncDatabaseMigrationReportingStateCOMPLETING', 'SyncDatabaseMigrationReportingStateCOMPLETE', 'SyncDatabaseMigrationReportingStateCANCELLING', 'SyncDatabaseMigrationReportingStateCANCELLED', 'SyncDatabaseMigrationReportingStateFAILED'
	MigrationState SyncDatabaseMigrationReportingState `json:"migrationState,omitempty"`
	// IncomingChanges - READ-ONLY; Number of incoming changes
	IncomingChanges *int64 `json:"incomingChanges,omitempty"`
	// AppliedChanges - READ-ONLY; Number of applied changes
	AppliedChanges *int64 `json:"appliedChanges,omitempty"`
	// CdcInsertCounter - READ-ONLY; Number of cdc inserts
	CdcInsertCounter *int64 `json:"cdcInsertCounter,omitempty"`
	// CdcDeleteCounter - READ-ONLY; Number of cdc deletes
	CdcDeleteCounter *int64 `json:"cdcDeleteCounter,omitempty"`
	// CdcUpdateCounter - READ-ONLY; Number of cdc updates
	CdcUpdateCounter *int64 `json:"cdcUpdateCounter,omitempty"`
	// FullLoadCompletedTables - READ-ONLY; Number of tables completed in full load
	FullLoadCompletedTables *int64 `json:"fullLoadCompletedTables,omitempty"`
	// FullLoadLoadingTables - READ-ONLY; Number of tables loading in full load
	FullLoadLoadingTables *int64 `json:"fullLoadLoadingTables,omitempty"`
	// FullLoadQueuedTables - READ-ONLY; Number of tables queued in full load
	FullLoadQueuedTables *int64 `json:"fullLoadQueuedTables,omitempty"`
	// FullLoadErroredTables - READ-ONLY; Number of tables errored in full load
	FullLoadErroredTables *int64 `json:"fullLoadErroredTables,omitempty"`
	// InitializationCompleted - READ-ONLY; Indicates if initial load (full load) has been completed
	InitializationCompleted *bool `json:"initializationCompleted,omitempty"`
	// Latency - READ-ONLY; CDC apply latency
	Latency *int64 `json:"latency,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel.
func (msssdstodl MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	msssdstodl.ResultType = ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput
	objectMap := make(map[string]interface{})
	if msssdstodl.ResultType != "" {
		objectMap["resultType"] = msssdstodl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel.
func (msssdstodl MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel.
func (msssdstodl MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbSyncTaskOutputError() (*MigrateSQLServerSQLDbSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel.
func (msssdstodl MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel() (*MigrateSQLServerSQLDbSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel.
func (msssdstodl MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel, bool) {
	return &msssdstodl, true
}

// AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel.
func (msssdstodl MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel.
func (msssdstodl MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbSyncTaskOutput() (*MigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel.
func (msssdstodl MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel) AsBasicMigrateSQLServerSQLDbSyncTaskOutput() (BasicMigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return &msssdstodl, true
}

// MigrateSQLServerSQLDbSyncTaskOutputError ...
type MigrateSQLServerSQLDbSyncTaskOutputError struct {
	// Error - READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbSyncTaskOutputError.
func (msssdstoe MigrateSQLServerSQLDbSyncTaskOutputError) MarshalJSON() ([]byte, error) {
	msssdstoe.ResultType = ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput
	objectMap := make(map[string]interface{})
	if msssdstoe.ResultType != "" {
		objectMap["resultType"] = msssdstoe.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputError.
func (msssdstoe MigrateSQLServerSQLDbSyncTaskOutputError) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputError.
func (msssdstoe MigrateSQLServerSQLDbSyncTaskOutputError) AsMigrateSQLServerSQLDbSyncTaskOutputError() (*MigrateSQLServerSQLDbSyncTaskOutputError, bool) {
	return &msssdstoe, true
}

// AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputError.
func (msssdstoe MigrateSQLServerSQLDbSyncTaskOutputError) AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel() (*MigrateSQLServerSQLDbSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputError.
func (msssdstoe MigrateSQLServerSQLDbSyncTaskOutputError) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputError.
func (msssdstoe MigrateSQLServerSQLDbSyncTaskOutputError) AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputError.
func (msssdstoe MigrateSQLServerSQLDbSyncTaskOutputError) AsMigrateSQLServerSQLDbSyncTaskOutput() (*MigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputError.
func (msssdstoe MigrateSQLServerSQLDbSyncTaskOutputError) AsBasicMigrateSQLServerSQLDbSyncTaskOutput() (BasicMigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return &msssdstoe, true
}

// MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel ...
type MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel struct {
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// SourceServerVersion - READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// SourceServer - READ-ONLY; Source server name
	SourceServer *string `json:"sourceServer,omitempty"`
	// TargetServerVersion - READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServer - READ-ONLY; Target server name
	TargetServer *string `json:"targetServer,omitempty"`
	// DatabaseCount - READ-ONLY; Count of databases
	DatabaseCount *int32 `json:"databaseCount,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel.
func (msssdstoml MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	msssdstoml.ResultType = ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput
	objectMap := make(map[string]interface{})
	if msssdstoml.ResultType != "" {
		objectMap["resultType"] = msssdstoml.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel.
func (msssdstoml MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel.
func (msssdstoml MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbSyncTaskOutputError() (*MigrateSQLServerSQLDbSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel.
func (msssdstoml MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel() (*MigrateSQLServerSQLDbSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel.
func (msssdstoml MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel.
func (msssdstoml MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel, bool) {
	return &msssdstoml, true
}

// AsMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel.
func (msssdstoml MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbSyncTaskOutput() (*MigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel.
func (msssdstoml MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel) AsBasicMigrateSQLServerSQLDbSyncTaskOutput() (BasicMigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return &msssdstoml, true
}

// MigrateSQLServerSQLDbSyncTaskOutputTableLevel ...
type MigrateSQLServerSQLDbSyncTaskOutputTableLevel struct {
	// TableName - READ-ONLY; Name of the table
	TableName *string `json:"tableName,omitempty"`
	// DatabaseName - READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// CdcInsertCounter - READ-ONLY; Number of applied inserts
	CdcInsertCounter *int64 `json:"cdcInsertCounter,omitempty"`
	// CdcUpdateCounter - READ-ONLY; Number of applied updates
	CdcUpdateCounter *int64 `json:"cdcUpdateCounter,omitempty"`
	// CdcDeleteCounter - READ-ONLY; Number of applied deletes
	CdcDeleteCounter *int64 `json:"cdcDeleteCounter,omitempty"`
	// FullLoadEstFinishTime - READ-ONLY; Estimate to finish full load
	FullLoadEstFinishTime *date.Time `json:"fullLoadEstFinishTime,omitempty"`
	// FullLoadStartedOn - READ-ONLY; Full load start time
	FullLoadStartedOn *date.Time `json:"fullLoadStartedOn,omitempty"`
	// FullLoadEndedOn - READ-ONLY; Full load end time
	FullLoadEndedOn *date.Time `json:"fullLoadEndedOn,omitempty"`
	// FullLoadTotalRows - READ-ONLY; Number of rows applied in full load
	FullLoadTotalRows *int64 `json:"fullLoadTotalRows,omitempty"`
	// State - READ-ONLY; Current state of the table migration. Possible values include: 'SyncTableMigrationStateBEFORELOAD', 'SyncTableMigrationStateFULLLOAD', 'SyncTableMigrationStateCOMPLETED', 'SyncTableMigrationStateCANCELED', 'SyncTableMigrationStateERROR', 'SyncTableMigrationStateFAILED'
	State SyncTableMigrationState `json:"state,omitempty"`
	// TotalChangesApplied - READ-ONLY; Total number of applied changes
	TotalChangesApplied *int64 `json:"totalChangesApplied,omitempty"`
	// DataErrorsCounter - READ-ONLY; Number of data errors occurred
	DataErrorsCounter *int64 `json:"dataErrorsCounter,omitempty"`
	// LastModifiedTime - READ-ONLY; Last modified time on target
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbSyncTaskOutputTableLevel.
func (msssdstotl MigrateSQLServerSQLDbSyncTaskOutputTableLevel) MarshalJSON() ([]byte, error) {
	msssdstotl.ResultType = ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput
	objectMap := make(map[string]interface{})
	if msssdstotl.ResultType != "" {
		objectMap["resultType"] = msssdstotl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputTableLevel.
func (msssdstotl MigrateSQLServerSQLDbSyncTaskOutputTableLevel) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputTableLevel.
func (msssdstotl MigrateSQLServerSQLDbSyncTaskOutputTableLevel) AsMigrateSQLServerSQLDbSyncTaskOutputError() (*MigrateSQLServerSQLDbSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputTableLevel.
func (msssdstotl MigrateSQLServerSQLDbSyncTaskOutputTableLevel) AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel() (*MigrateSQLServerSQLDbSyncTaskOutputTableLevel, bool) {
	return &msssdstotl, true
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputTableLevel.
func (msssdstotl MigrateSQLServerSQLDbSyncTaskOutputTableLevel) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputTableLevel.
func (msssdstotl MigrateSQLServerSQLDbSyncTaskOutputTableLevel) AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputTableLevel.
func (msssdstotl MigrateSQLServerSQLDbSyncTaskOutputTableLevel) AsMigrateSQLServerSQLDbSyncTaskOutput() (*MigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputTableLevel.
func (msssdstotl MigrateSQLServerSQLDbSyncTaskOutputTableLevel) AsBasicMigrateSQLServerSQLDbSyncTaskOutput() (BasicMigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return &msssdstotl, true
}

// MigrateSQLServerSQLDbSyncTaskProperties properties for the task that migrates on-prem SQL Server
// databases to Azure SQL Database for online migrations
type MigrateSQLServerSQLDbSyncTaskProperties struct {
	// Input - Task input
	Input *MigrateSQLServerSQLDbSyncTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]BasicMigrateSQLServerSQLDbSyncTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) MarshalJSON() ([]byte, error) {
	msssdstp.TaskType = TaskTypeMigrateSQLServerAzureSQLDbSync
	objectMap := make(map[string]interface{})
	if msssdstp.Input != nil {
		objectMap["input"] = msssdstp.Input
	}
	if msssdstp.ClientData != nil {
		objectMap["clientData"] = msssdstp.ClientData
	}
	if msssdstp.TaskType != "" {
		objectMap["taskType"] = msssdstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return &msssdstp, true
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &msssdstp, true
}

// UnmarshalJSON is the custom unmarshaler for MigrateSQLServerSQLDbSyncTaskProperties struct.
func (msssdstp *MigrateSQLServerSQLDbSyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input MigrateSQLServerSQLDbSyncTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				msssdstp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMigrateSQLServerSQLDbSyncTaskOutputArray(*v)
				if err != nil {
					return err
				}
				msssdstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				msssdstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				msssdstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				msssdstp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				msssdstp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				msssdstp.TaskType = taskType
			}
		}
	}

	return nil
}

// MigrateSQLServerSQLDbTaskInput input for the task that migrates on-prem SQL Server databases to Azure
// SQL Database
type MigrateSQLServerSQLDbTaskInput struct {
	// SelectedDatabases - Databases to migrate
	SelectedDatabases *[]MigrateSQLServerSQLDbDatabaseInput `json:"selectedDatabases,omitempty"`
	// ValidationOptions - Options for enabling various post migration validations. Available options,
	//  1.) Data Integrity Check: Performs a checksum based comparison on source and target tables after the migration to ensure the correctness of the data.
	//  2.) Schema Validation: Performs a thorough schema comparison between the source and target tables and provides a list of differences between the source and target database, 3.) Query Analysis: Executes a set of queries picked up automatically either from the Query Plan Cache or Query Store and execute them and compares the execution time between the source and target database.
	ValidationOptions *MigrationValidationOptions `json:"validationOptions,omitempty"`
	// SourceConnectionInfo - Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// BasicMigrateSQLServerSQLDbTaskOutput output for the task that migrates on-prem SQL Server databases to Azure SQL
// Database
type BasicMigrateSQLServerSQLDbTaskOutput interface {
	AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool)
	AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool)
	AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool)
	AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool)
	AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool)
}

// MigrateSQLServerSQLDbTaskOutput output for the task that migrates on-prem SQL Server databases to Azure SQL
// Database
type MigrateSQLServerSQLDbTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbTaskOutput `json:"resultType,omitempty"`
}

func unmarshalBasicMigrateSQLServerSQLDbTaskOutput(body []byte) (BasicMigrateSQLServerSQLDbTaskOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resultType"] {
	case string(ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput):
		var msssdtoe MigrateSQLServerSQLDbTaskOutputError
		err := json.Unmarshal(body, &msssdtoe)
		return msssdtoe, err
	case string(ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput):
		var msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel
		err := json.Unmarshal(body, &msssdtotl)
		return msssdtotl, err
	case string(ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput):
		var msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel
		err := json.Unmarshal(body, &msssdtodl)
		return msssdtodl, err
	case string(ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput):
		var msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel
		err := json.Unmarshal(body, &msssdtoml)
		return msssdtoml, err
	default:
		var msssdto MigrateSQLServerSQLDbTaskOutput
		err := json.Unmarshal(body, &msssdto)
		return msssdto, err
	}
}
func unmarshalBasicMigrateSQLServerSQLDbTaskOutputArray(body []byte) ([]BasicMigrateSQLServerSQLDbTaskOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	msssdtoArray := make([]BasicMigrateSQLServerSQLDbTaskOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		msssdto, err := unmarshalBasicMigrateSQLServerSQLDbTaskOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		msssdtoArray[index] = msssdto
	}
	return msssdtoArray, nil
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) MarshalJSON() ([]byte, error) {
	msssdto.ResultType = ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput
	objectMap := make(map[string]interface{})
	if msssdto.ResultType != "" {
		objectMap["resultType"] = msssdto.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskOutputError is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdto, true
}

// AsBasicMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsBasicMigrateSQLServerSQLDbTaskOutput() (BasicMigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdto, true
}

// MigrateSQLServerSQLDbTaskOutputDatabaseLevel ...
type MigrateSQLServerSQLDbTaskOutputDatabaseLevel struct {
	// DatabaseName - READ-ONLY; Name of the item
	DatabaseName *string `json:"databaseName,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// Stage - READ-ONLY; Migration stage that this database is in. Possible values include: 'DatabaseMigrationStageNone', 'DatabaseMigrationStageInitialize', 'DatabaseMigrationStageBackup', 'DatabaseMigrationStageFileCopy', 'DatabaseMigrationStageRestore', 'DatabaseMigrationStageCompleted'
	Stage DatabaseMigrationStage `json:"stage,omitempty"`
	// StatusMessage - READ-ONLY; Status message
	StatusMessage *string `json:"statusMessage,omitempty"`
	// Message - READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty"`
	// NumberOfObjects - READ-ONLY; Number of objects
	NumberOfObjects *int64 `json:"numberOfObjects,omitempty"`
	// NumberOfObjectsCompleted - READ-ONLY; Number of successfully completed objects
	NumberOfObjectsCompleted *int64 `json:"numberOfObjectsCompleted,omitempty"`
	// ErrorCount - READ-ONLY; Number of database/object errors.
	ErrorCount *int64 `json:"errorCount,omitempty"`
	// ErrorPrefix - READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string `json:"errorPrefix,omitempty"`
	// ResultPrefix - READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string `json:"resultPrefix,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// ObjectSummary - READ-ONLY; Summary of object results in the migration
	ObjectSummary map[string]*DataItemMigrationSummaryResult `json:"objectSummary"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	msssdtodl.ResultType = ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput
	objectMap := make(map[string]interface{})
	if msssdtodl.ResultType != "" {
		objectMap["resultType"] = msssdtodl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskOutputError is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return &msssdtodl, true
}

// AsMigrateSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsBasicMigrateSQLServerSQLDbTaskOutput() (BasicMigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdtodl, true
}

// MigrateSQLServerSQLDbTaskOutputError ...
type MigrateSQLServerSQLDbTaskOutputError struct {
	// Error - READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) MarshalJSON() ([]byte, error) {
	msssdtoe.ResultType = ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput
	objectMap := make(map[string]interface{})
	if msssdtoe.ResultType != "" {
		objectMap["resultType"] = msssdtoe.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskOutputError is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool) {
	return &msssdtoe, true
}

// AsMigrateSQLServerSQLDbTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsBasicMigrateSQLServerSQLDbTaskOutput() (BasicMigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdtoe, true
}

// MigrateSQLServerSQLDbTaskOutputMigrationLevel ...
type MigrateSQLServerSQLDbTaskOutputMigrationLevel struct {
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// DurationInSeconds - READ-ONLY; Duration of task execution in seconds.
	DurationInSeconds *int64 `json:"durationInSeconds,omitempty"`
	// Status - READ-ONLY; Current status of migration. Possible values include: 'MigrationStatusDefault', 'MigrationStatusConnecting', 'MigrationStatusSourceAndTargetSelected', 'MigrationStatusSelectLogins', 'MigrationStatusConfigured', 'MigrationStatusRunning', 'MigrationStatusError', 'MigrationStatusStopped', 'MigrationStatusCompleted', 'MigrationStatusCompletedWithWarnings'
	Status MigrationStatus `json:"status,omitempty"`
	// StatusMessage - READ-ONLY; Migration status message
	StatusMessage *string `json:"statusMessage,omitempty"`
	// Message - READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty"`
	// Databases - READ-ONLY; Selected databases as a map from database name to database id
	Databases map[string]*string `json:"databases"`
	// DatabaseSummary - READ-ONLY; Summary of database results in the migration
	DatabaseSummary map[string]*DatabaseSummaryResult `json:"databaseSummary"`
	// MigrationValidationResult - Migration Validation Results
	MigrationValidationResult *MigrationValidationResult `json:"migrationValidationResult,omitempty"`
	// MigrationReportResult - Migration Report Result, provides unique url for downloading your migration report.
	MigrationReportResult *MigrationReportResult `json:"migrationReportResult,omitempty"`
	// SourceServerVersion - READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// SourceServerBrandVersion - READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty"`
	// TargetServerVersion - READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServerBrandVersion - READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	msssdtoml.ResultType = ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput
	objectMap := make(map[string]interface{})
	if msssdtoml.MigrationValidationResult != nil {
		objectMap["migrationValidationResult"] = msssdtoml.MigrationValidationResult
	}
	if msssdtoml.MigrationReportResult != nil {
		objectMap["migrationReportResult"] = msssdtoml.MigrationReportResult
	}
	if msssdtoml.ResultType != "" {
		objectMap["resultType"] = msssdtoml.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskOutputError is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return &msssdtoml, true
}

// AsMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsBasicMigrateSQLServerSQLDbTaskOutput() (BasicMigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdtoml, true
}

// MigrateSQLServerSQLDbTaskOutputTableLevel ...
type MigrateSQLServerSQLDbTaskOutputTableLevel struct {
	// ObjectName - READ-ONLY; Name of the item
	ObjectName *string `json:"objectName,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// StatusMessage - READ-ONLY; Status message
	StatusMessage *string `json:"statusMessage,omitempty"`
	// ItemsCount - READ-ONLY; Number of items
	ItemsCount *int64 `json:"itemsCount,omitempty"`
	// ItemsCompletedCount - READ-ONLY; Number of successfully completed items
	ItemsCompletedCount *int64 `json:"itemsCompletedCount,omitempty"`
	// ErrorPrefix - READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string `json:"errorPrefix,omitempty"`
	// ResultPrefix - READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string `json:"resultPrefix,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) MarshalJSON() ([]byte, error) {
	msssdtotl.ResultType = ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput
	objectMap := make(map[string]interface{})
	if msssdtotl.ResultType != "" {
		objectMap["resultType"] = msssdtotl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskOutputError is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool) {
	return &msssdtotl, true
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsBasicMigrateSQLServerSQLDbTaskOutput() (BasicMigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdtotl, true
}

// MigrateSQLServerSQLDbTaskProperties properties for the task that migrates on-prem SQL Server databases
// to Azure SQL Database
type MigrateSQLServerSQLDbTaskProperties struct {
	// Input - Task input
	Input *MigrateSQLServerSQLDbTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]BasicMigrateSQLServerSQLDbTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) MarshalJSON() ([]byte, error) {
	msssdtp.TaskType = TaskTypeMigrateSQLServerSQLDb
	objectMap := make(map[string]interface{})
	if msssdtp.Input != nil {
		objectMap["input"] = msssdtp.Input
	}
	if msssdtp.ClientData != nil {
		objectMap["clientData"] = msssdtp.ClientData
	}
	if msssdtp.TaskType != "" {
		objectMap["taskType"] = msssdtp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return &msssdtp, true
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &msssdtp, true
}

// UnmarshalJSON is the custom unmarshaler for MigrateSQLServerSQLDbTaskProperties struct.
func (msssdtp *MigrateSQLServerSQLDbTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input MigrateSQLServerSQLDbTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				msssdtp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMigrateSQLServerSQLDbTaskOutputArray(*v)
				if err != nil {
					return err
				}
				msssdtp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				msssdtp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				msssdtp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				msssdtp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				msssdtp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				msssdtp.TaskType = taskType
			}
		}
	}

	return nil
}

// MigrateSQLServerSQLMIDatabaseInput database specific information for SQL to Azure SQL DB Managed
// Instance migration task inputs
type MigrateSQLServerSQLMIDatabaseInput struct {
	// Name - Name of the database
	Name *string `json:"name,omitempty"`
	// RestoreDatabaseName - Name of the database at destination
	RestoreDatabaseName *string `json:"restoreDatabaseName,omitempty"`
	// BackupFileShare - Backup file share information for backing up this database.
	BackupFileShare *FileShare `json:"backupFileShare,omitempty"`
	// BackupFilePaths - The list of backup files to be used in case of existing backups.
	BackupFilePaths *[]string `json:"backupFilePaths,omitempty"`
}

// MigrateSQLServerSQLMISyncTaskInput input for task that migrates SQL Server databases to Azure SQL
// Database Managed Instance online scenario.
type MigrateSQLServerSQLMISyncTaskInput struct {
	// SelectedDatabases - Databases to migrate
	SelectedDatabases *[]MigrateSQLServerSQLMIDatabaseInput `json:"selectedDatabases,omitempty"`
	// BackupFileShare - Backup file share information for all selected databases.
	BackupFileShare *FileShare `json:"backupFileShare,omitempty"`
	// StorageResourceID - Fully qualified resourceId of storage
	StorageResourceID *string `json:"storageResourceId,omitempty"`
	// SourceConnectionInfo - Connection information for source SQL Server
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Connection information for Azure SQL Database Managed Instance
	TargetConnectionInfo *MiSQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
	// AzureApp - Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
	AzureApp *AzureActiveDirectoryApp `json:"azureApp,omitempty"`
}

// BasicMigrateSQLServerSQLMISyncTaskOutput output for task that migrates SQL Server databases to Azure SQL Database
// Managed Instance using Log Replay Service.
type BasicMigrateSQLServerSQLMISyncTaskOutput interface {
	AsMigrateSQLServerSQLMISyncTaskOutputError() (*MigrateSQLServerSQLMISyncTaskOutputError, bool)
	AsMigrateSQLServerSQLMISyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel, bool)
	AsMigrateSQLServerSQLMISyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLMISyncTaskOutputMigrationLevel, bool)
	AsMigrateSQLServerSQLMISyncTaskOutput() (*MigrateSQLServerSQLMISyncTaskOutput, bool)
}

// MigrateSQLServerSQLMISyncTaskOutput output for task that migrates SQL Server databases to Azure SQL Database
// Managed Instance using Log Replay Service.
type MigrateSQLServerSQLMISyncTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrateSQLServerSQLMISyncTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput `json:"resultType,omitempty"`
}

func unmarshalBasicMigrateSQLServerSQLMISyncTaskOutput(body []byte) (BasicMigrateSQLServerSQLMISyncTaskOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resultType"] {
	case string(ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput):
		var msssmstoe MigrateSQLServerSQLMISyncTaskOutputError
		err := json.Unmarshal(body, &msssmstoe)
		return msssmstoe, err
	case string(ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput):
		var msssmstodl MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel
		err := json.Unmarshal(body, &msssmstodl)
		return msssmstodl, err
	case string(ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput):
		var msssmstoml MigrateSQLServerSQLMISyncTaskOutputMigrationLevel
		err := json.Unmarshal(body, &msssmstoml)
		return msssmstoml, err
	default:
		var msssmsto MigrateSQLServerSQLMISyncTaskOutput
		err := json.Unmarshal(body, &msssmsto)
		return msssmsto, err
	}
}
func unmarshalBasicMigrateSQLServerSQLMISyncTaskOutputArray(body []byte) ([]BasicMigrateSQLServerSQLMISyncTaskOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	msssmstoArray := make([]BasicMigrateSQLServerSQLMISyncTaskOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		msssmsto, err := unmarshalBasicMigrateSQLServerSQLMISyncTaskOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		msssmstoArray[index] = msssmsto
	}
	return msssmstoArray, nil
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMISyncTaskOutput.
func (msssmsto MigrateSQLServerSQLMISyncTaskOutput) MarshalJSON() ([]byte, error) {
	msssmsto.ResultType = ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrateSQLServerSQLMISyncTaskOutput
	objectMap := make(map[string]interface{})
	if msssmsto.ResultType != "" {
		objectMap["resultType"] = msssmsto.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMISyncTaskOutputError is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutput.
func (msssmsto MigrateSQLServerSQLMISyncTaskOutput) AsMigrateSQLServerSQLMISyncTaskOutputError() (*MigrateSQLServerSQLMISyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutput.
func (msssmsto MigrateSQLServerSQLMISyncTaskOutput) AsMigrateSQLServerSQLMISyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutput.
func (msssmsto MigrateSQLServerSQLMISyncTaskOutput) AsMigrateSQLServerSQLMISyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLMISyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskOutput is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutput.
func (msssmsto MigrateSQLServerSQLMISyncTaskOutput) AsMigrateSQLServerSQLMISyncTaskOutput() (*MigrateSQLServerSQLMISyncTaskOutput, bool) {
	return &msssmsto, true
}

// AsBasicMigrateSQLServerSQLMISyncTaskOutput is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutput.
func (msssmsto MigrateSQLServerSQLMISyncTaskOutput) AsBasicMigrateSQLServerSQLMISyncTaskOutput() (BasicMigrateSQLServerSQLMISyncTaskOutput, bool) {
	return &msssmsto, true
}

// MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel ...
type MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel struct {
	// SourceDatabaseName - READ-ONLY; Name of the database
	SourceDatabaseName *string `json:"sourceDatabaseName,omitempty"`
	// MigrationState - READ-ONLY; Current state of database. Possible values include: 'UNDEFINED', 'INITIAL', 'FULLBACKUPUPLOADSTART', 'LOGSHIPPINGSTART', 'UPLOADLOGFILESSTART', 'CUTOVERSTART', 'POSTCUTOVERCOMPLETE', 'COMPLETED', 'CANCELLED', 'FAILED'
	MigrationState DatabaseMigrationState `json:"migrationState,omitempty"`
	// StartedOn - READ-ONLY; Database migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Database migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// FullBackupSetInfo - READ-ONLY; Details of full backup set
	FullBackupSetInfo *BackupSetInfo `json:"fullBackupSetInfo,omitempty"`
	// LastRestoredBackupSetInfo - READ-ONLY; Last applied backup set information
	LastRestoredBackupSetInfo *BackupSetInfo `json:"lastRestoredBackupSetInfo,omitempty"`
	// ActiveBackupSets - READ-ONLY; Backup sets that are currently active (Either being uploaded or getting restored)
	ActiveBackupSets *[]BackupSetInfo `json:"activeBackupSets,omitempty"`
	// ContainerName - READ-ONLY; Name of container created in the Azure Storage account where backups are copied to
	ContainerName *string `json:"containerName,omitempty"`
	// ErrorPrefix - READ-ONLY; prefix string to use for querying errors for this database
	ErrorPrefix *string `json:"errorPrefix,omitempty"`
	// IsFullBackupRestored - READ-ONLY; Whether full backup has been applied to the target database or not
	IsFullBackupRestored *bool `json:"isFullBackupRestored,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Migration exceptions and warnings
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrateSQLServerSQLMISyncTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel.
func (msssmstodl MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	msssmstodl.ResultType = ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput
	objectMap := make(map[string]interface{})
	if msssmstodl.ResultType != "" {
		objectMap["resultType"] = msssmstodl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMISyncTaskOutputError is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel.
func (msssmstodl MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel) AsMigrateSQLServerSQLMISyncTaskOutputError() (*MigrateSQLServerSQLMISyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel.
func (msssmstodl MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel) AsMigrateSQLServerSQLMISyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel, bool) {
	return &msssmstodl, true
}

// AsMigrateSQLServerSQLMISyncTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel.
func (msssmstodl MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel) AsMigrateSQLServerSQLMISyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLMISyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskOutput is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel.
func (msssmstodl MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel) AsMigrateSQLServerSQLMISyncTaskOutput() (*MigrateSQLServerSQLMISyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLMISyncTaskOutput is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel.
func (msssmstodl MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel) AsBasicMigrateSQLServerSQLMISyncTaskOutput() (BasicMigrateSQLServerSQLMISyncTaskOutput, bool) {
	return &msssmstodl, true
}

// MigrateSQLServerSQLMISyncTaskOutputError ...
type MigrateSQLServerSQLMISyncTaskOutputError struct {
	// Error - READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrateSQLServerSQLMISyncTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMISyncTaskOutputError.
func (msssmstoe MigrateSQLServerSQLMISyncTaskOutputError) MarshalJSON() ([]byte, error) {
	msssmstoe.ResultType = ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput
	objectMap := make(map[string]interface{})
	if msssmstoe.ResultType != "" {
		objectMap["resultType"] = msssmstoe.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMISyncTaskOutputError is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputError.
func (msssmstoe MigrateSQLServerSQLMISyncTaskOutputError) AsMigrateSQLServerSQLMISyncTaskOutputError() (*MigrateSQLServerSQLMISyncTaskOutputError, bool) {
	return &msssmstoe, true
}

// AsMigrateSQLServerSQLMISyncTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputError.
func (msssmstoe MigrateSQLServerSQLMISyncTaskOutputError) AsMigrateSQLServerSQLMISyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputError.
func (msssmstoe MigrateSQLServerSQLMISyncTaskOutputError) AsMigrateSQLServerSQLMISyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLMISyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskOutput is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputError.
func (msssmstoe MigrateSQLServerSQLMISyncTaskOutputError) AsMigrateSQLServerSQLMISyncTaskOutput() (*MigrateSQLServerSQLMISyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLMISyncTaskOutput is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputError.
func (msssmstoe MigrateSQLServerSQLMISyncTaskOutputError) AsBasicMigrateSQLServerSQLMISyncTaskOutput() (BasicMigrateSQLServerSQLMISyncTaskOutput, bool) {
	return &msssmstoe, true
}

// MigrateSQLServerSQLMISyncTaskOutputMigrationLevel ...
type MigrateSQLServerSQLMISyncTaskOutputMigrationLevel struct {
	// DatabaseCount - READ-ONLY; Count of databases
	DatabaseCount *int32 `json:"databaseCount,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// SourceServerName - READ-ONLY; Source server name
	SourceServerName *string `json:"sourceServerName,omitempty"`
	// SourceServerVersion - READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// SourceServerBrandVersion - READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty"`
	// TargetServerName - READ-ONLY; Target server name
	TargetServerName *string `json:"targetServerName,omitempty"`
	// TargetServerVersion - READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServerBrandVersion - READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
	// DatabaseErrorCount - READ-ONLY; Number of database level errors
	DatabaseErrorCount *int32 `json:"databaseErrorCount,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrateSQLServerSQLMISyncTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMISyncTaskOutputMigrationLevel.
func (msssmstoml MigrateSQLServerSQLMISyncTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	msssmstoml.ResultType = ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput
	objectMap := make(map[string]interface{})
	if msssmstoml.ResultType != "" {
		objectMap["resultType"] = msssmstoml.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMISyncTaskOutputError is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputMigrationLevel.
func (msssmstoml MigrateSQLServerSQLMISyncTaskOutputMigrationLevel) AsMigrateSQLServerSQLMISyncTaskOutputError() (*MigrateSQLServerSQLMISyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputMigrationLevel.
func (msssmstoml MigrateSQLServerSQLMISyncTaskOutputMigrationLevel) AsMigrateSQLServerSQLMISyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputMigrationLevel.
func (msssmstoml MigrateSQLServerSQLMISyncTaskOutputMigrationLevel) AsMigrateSQLServerSQLMISyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLMISyncTaskOutputMigrationLevel, bool) {
	return &msssmstoml, true
}

// AsMigrateSQLServerSQLMISyncTaskOutput is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputMigrationLevel.
func (msssmstoml MigrateSQLServerSQLMISyncTaskOutputMigrationLevel) AsMigrateSQLServerSQLMISyncTaskOutput() (*MigrateSQLServerSQLMISyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLMISyncTaskOutput is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputMigrationLevel.
func (msssmstoml MigrateSQLServerSQLMISyncTaskOutputMigrationLevel) AsBasicMigrateSQLServerSQLMISyncTaskOutput() (BasicMigrateSQLServerSQLMISyncTaskOutput, bool) {
	return &msssmstoml, true
}

// MigrateSQLServerSQLMISyncTaskProperties properties for task that migrates SQL Server databases to Azure
// SQL Database Managed Instance sync scenario
type MigrateSQLServerSQLMISyncTaskProperties struct {
	// Input - Task input
	Input *MigrateSQLServerSQLMISyncTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]BasicMigrateSQLServerSQLMISyncTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) MarshalJSON() ([]byte, error) {
	msssmstp.TaskType = TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS
	objectMap := make(map[string]interface{})
	if msssmstp.Input != nil {
		objectMap["input"] = msssmstp.Input
	}
	if msssmstp.ClientData != nil {
		objectMap["clientData"] = msssmstp.ClientData
	}
	if msssmstp.TaskType != "" {
		objectMap["taskType"] = msssmstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return &msssmstp, true
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &msssmstp, true
}

// UnmarshalJSON is the custom unmarshaler for MigrateSQLServerSQLMISyncTaskProperties struct.
func (msssmstp *MigrateSQLServerSQLMISyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input MigrateSQLServerSQLMISyncTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				msssmstp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMigrateSQLServerSQLMISyncTaskOutputArray(*v)
				if err != nil {
					return err
				}
				msssmstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				msssmstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				msssmstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				msssmstp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				msssmstp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				msssmstp.TaskType = taskType
			}
		}
	}

	return nil
}

// MigrateSQLServerSQLMITaskInput input for task that migrates SQL Server databases to Azure SQL Database
// Managed Instance.
type MigrateSQLServerSQLMITaskInput struct {
	// SelectedDatabases - Databases to migrate
	SelectedDatabases *[]MigrateSQLServerSQLMIDatabaseInput `json:"selectedDatabases,omitempty"`
	// SelectedLogins - Logins to migrate.
	SelectedLogins *[]string `json:"selectedLogins,omitempty"`
	// SelectedAgentJobs - Agent Jobs to migrate.
	SelectedAgentJobs *[]string `json:"selectedAgentJobs,omitempty"`
	// BackupFileShare - Backup file share information for all selected databases.
	BackupFileShare *FileShare `json:"backupFileShare,omitempty"`
	// BackupBlobShare - SAS URI of Azure Storage Account Container to be used for storing backup files.
	BackupBlobShare *BlobShare `json:"backupBlobShare,omitempty"`
	// BackupMode - Backup Mode to specify whether to use existing backup or create new backup. If using existing backups, backup file paths are required to be provided in selectedDatabases. Possible values include: 'CreateBackup', 'ExistingBackup'
	BackupMode BackupMode `json:"backupMode,omitempty"`
	// AadDomainName - Azure Active Directory domain name in the format of 'contoso.com' for federated Azure AD or 'contoso.onmicrosoft.com' for managed domain, required if and only if Windows logins are selected
	AadDomainName *string `json:"aadDomainName,omitempty"`
	// SourceConnectionInfo - Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// BasicMigrateSQLServerSQLMITaskOutput output for task that migrates SQL Server databases to Azure SQL Database
// Managed Instance.
type BasicMigrateSQLServerSQLMITaskOutput interface {
	AsMigrateSQLServerSQLMITaskOutputError() (*MigrateSQLServerSQLMITaskOutputError, bool)
	AsMigrateSQLServerSQLMITaskOutputLoginLevel() (*MigrateSQLServerSQLMITaskOutputLoginLevel, bool)
	AsMigrateSQLServerSQLMITaskOutputAgentJobLevel() (*MigrateSQLServerSQLMITaskOutputAgentJobLevel, bool)
	AsMigrateSQLServerSQLMITaskOutputDatabaseLevel() (*MigrateSQLServerSQLMITaskOutputDatabaseLevel, bool)
	AsMigrateSQLServerSQLMITaskOutputMigrationLevel() (*MigrateSQLServerSQLMITaskOutputMigrationLevel, bool)
	AsMigrateSQLServerSQLMITaskOutput() (*MigrateSQLServerSQLMITaskOutput, bool)
}

// MigrateSQLServerSQLMITaskOutput output for task that migrates SQL Server databases to Azure SQL Database
// Managed Instance.
type MigrateSQLServerSQLMITaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMITaskOutput `json:"resultType,omitempty"`
}

func unmarshalBasicMigrateSQLServerSQLMITaskOutput(body []byte) (BasicMigrateSQLServerSQLMITaskOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resultType"] {
	case string(ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput):
		var msssmtoe MigrateSQLServerSQLMITaskOutputError
		err := json.Unmarshal(body, &msssmtoe)
		return msssmtoe, err
	case string(ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput):
		var msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel
		err := json.Unmarshal(body, &msssmtoll)
		return msssmtoll, err
	case string(ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput):
		var msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel
		err := json.Unmarshal(body, &msssmtoajl)
		return msssmtoajl, err
	case string(ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput):
		var msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel
		err := json.Unmarshal(body, &msssmtodl)
		return msssmtodl, err
	case string(ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput):
		var msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel
		err := json.Unmarshal(body, &msssmtoml)
		return msssmtoml, err
	default:
		var msssmto MigrateSQLServerSQLMITaskOutput
		err := json.Unmarshal(body, &msssmto)
		return msssmto, err
	}
}
func unmarshalBasicMigrateSQLServerSQLMITaskOutputArray(body []byte) ([]BasicMigrateSQLServerSQLMITaskOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	msssmtoArray := make([]BasicMigrateSQLServerSQLMITaskOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		msssmto, err := unmarshalBasicMigrateSQLServerSQLMITaskOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		msssmtoArray[index] = msssmto
	}
	return msssmtoArray, nil
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) MarshalJSON() ([]byte, error) {
	msssmto.ResultType = ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput
	objectMap := make(map[string]interface{})
	if msssmto.ResultType != "" {
		objectMap["resultType"] = msssmto.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMITaskOutputError is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) AsMigrateSQLServerSQLMITaskOutputError() (*MigrateSQLServerSQLMITaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputLoginLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) AsMigrateSQLServerSQLMITaskOutputLoginLevel() (*MigrateSQLServerSQLMITaskOutputLoginLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputAgentJobLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) AsMigrateSQLServerSQLMITaskOutputAgentJobLevel() (*MigrateSQLServerSQLMITaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) AsMigrateSQLServerSQLMITaskOutputDatabaseLevel() (*MigrateSQLServerSQLMITaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) AsMigrateSQLServerSQLMITaskOutputMigrationLevel() (*MigrateSQLServerSQLMITaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) AsMigrateSQLServerSQLMITaskOutput() (*MigrateSQLServerSQLMITaskOutput, bool) {
	return &msssmto, true
}

// AsBasicMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) AsBasicMigrateSQLServerSQLMITaskOutput() (BasicMigrateSQLServerSQLMITaskOutput, bool) {
	return &msssmto, true
}

// MigrateSQLServerSQLMITaskOutputAgentJobLevel ...
type MigrateSQLServerSQLMITaskOutputAgentJobLevel struct {
	// Name - READ-ONLY; Agent Job name.
	Name *string `json:"name,omitempty"`
	// IsEnabled - READ-ONLY; The state of the original Agent Job.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// Message - READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Migration errors and warnings per job
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMITaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) MarshalJSON() ([]byte, error) {
	msssmtoajl.ResultType = ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput
	objectMap := make(map[string]interface{})
	if msssmtoajl.ResultType != "" {
		objectMap["resultType"] = msssmtoajl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMITaskOutputError is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) AsMigrateSQLServerSQLMITaskOutputError() (*MigrateSQLServerSQLMITaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputLoginLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) AsMigrateSQLServerSQLMITaskOutputLoginLevel() (*MigrateSQLServerSQLMITaskOutputLoginLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputAgentJobLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) AsMigrateSQLServerSQLMITaskOutputAgentJobLevel() (*MigrateSQLServerSQLMITaskOutputAgentJobLevel, bool) {
	return &msssmtoajl, true
}

// AsMigrateSQLServerSQLMITaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) AsMigrateSQLServerSQLMITaskOutputDatabaseLevel() (*MigrateSQLServerSQLMITaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) AsMigrateSQLServerSQLMITaskOutputMigrationLevel() (*MigrateSQLServerSQLMITaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) AsMigrateSQLServerSQLMITaskOutput() (*MigrateSQLServerSQLMITaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) AsBasicMigrateSQLServerSQLMITaskOutput() (BasicMigrateSQLServerSQLMITaskOutput, bool) {
	return &msssmtoajl, true
}

// MigrateSQLServerSQLMITaskOutputDatabaseLevel ...
type MigrateSQLServerSQLMITaskOutputDatabaseLevel struct {
	// DatabaseName - READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// SizeMB - READ-ONLY; Size of the database in megabytes
	SizeMB *float64 `json:"sizeMB,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// Stage - READ-ONLY; Current stage of migration. Possible values include: 'DatabaseMigrationStageNone', 'DatabaseMigrationStageInitialize', 'DatabaseMigrationStageBackup', 'DatabaseMigrationStageFileCopy', 'DatabaseMigrationStageRestore', 'DatabaseMigrationStageCompleted'
	Stage DatabaseMigrationStage `json:"stage,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// Message - READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Migration exceptions and warnings
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMITaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	msssmtodl.ResultType = ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput
	objectMap := make(map[string]interface{})
	if msssmtodl.ResultType != "" {
		objectMap["resultType"] = msssmtodl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMITaskOutputError is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) AsMigrateSQLServerSQLMITaskOutputError() (*MigrateSQLServerSQLMITaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputLoginLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) AsMigrateSQLServerSQLMITaskOutputLoginLevel() (*MigrateSQLServerSQLMITaskOutputLoginLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputAgentJobLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) AsMigrateSQLServerSQLMITaskOutputAgentJobLevel() (*MigrateSQLServerSQLMITaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) AsMigrateSQLServerSQLMITaskOutputDatabaseLevel() (*MigrateSQLServerSQLMITaskOutputDatabaseLevel, bool) {
	return &msssmtodl, true
}

// AsMigrateSQLServerSQLMITaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) AsMigrateSQLServerSQLMITaskOutputMigrationLevel() (*MigrateSQLServerSQLMITaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) AsMigrateSQLServerSQLMITaskOutput() (*MigrateSQLServerSQLMITaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) AsBasicMigrateSQLServerSQLMITaskOutput() (BasicMigrateSQLServerSQLMITaskOutput, bool) {
	return &msssmtodl, true
}

// MigrateSQLServerSQLMITaskOutputError ...
type MigrateSQLServerSQLMITaskOutputError struct {
	// Error - READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMITaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) MarshalJSON() ([]byte, error) {
	msssmtoe.ResultType = ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput
	objectMap := make(map[string]interface{})
	if msssmtoe.ResultType != "" {
		objectMap["resultType"] = msssmtoe.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMITaskOutputError is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) AsMigrateSQLServerSQLMITaskOutputError() (*MigrateSQLServerSQLMITaskOutputError, bool) {
	return &msssmtoe, true
}

// AsMigrateSQLServerSQLMITaskOutputLoginLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) AsMigrateSQLServerSQLMITaskOutputLoginLevel() (*MigrateSQLServerSQLMITaskOutputLoginLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputAgentJobLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) AsMigrateSQLServerSQLMITaskOutputAgentJobLevel() (*MigrateSQLServerSQLMITaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) AsMigrateSQLServerSQLMITaskOutputDatabaseLevel() (*MigrateSQLServerSQLMITaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) AsMigrateSQLServerSQLMITaskOutputMigrationLevel() (*MigrateSQLServerSQLMITaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) AsMigrateSQLServerSQLMITaskOutput() (*MigrateSQLServerSQLMITaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) AsBasicMigrateSQLServerSQLMITaskOutput() (BasicMigrateSQLServerSQLMITaskOutput, bool) {
	return &msssmtoe, true
}

// MigrateSQLServerSQLMITaskOutputLoginLevel ...
type MigrateSQLServerSQLMITaskOutputLoginLevel struct {
	// LoginName - READ-ONLY; Login name.
	LoginName *string `json:"loginName,omitempty"`
	// State - READ-ONLY; Current state of login. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// Stage - READ-ONLY; Current stage of login. Possible values include: 'LoginMigrationStageNone', 'LoginMigrationStageInitialize', 'LoginMigrationStageLoginMigration', 'LoginMigrationStageEstablishUserMapping', 'LoginMigrationStageAssignRoleMembership', 'LoginMigrationStageAssignRoleOwnership', 'LoginMigrationStageEstablishServerPermissions', 'LoginMigrationStageEstablishObjectPermissions', 'LoginMigrationStageCompleted'
	Stage LoginMigrationStage `json:"stage,omitempty"`
	// StartedOn - READ-ONLY; Login migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Login migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// Message - READ-ONLY; Login migration progress message
	Message *string `json:"message,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Login migration errors and warnings per login
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMITaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) MarshalJSON() ([]byte, error) {
	msssmtoll.ResultType = ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput
	objectMap := make(map[string]interface{})
	if msssmtoll.ResultType != "" {
		objectMap["resultType"] = msssmtoll.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMITaskOutputError is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) AsMigrateSQLServerSQLMITaskOutputError() (*MigrateSQLServerSQLMITaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputLoginLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) AsMigrateSQLServerSQLMITaskOutputLoginLevel() (*MigrateSQLServerSQLMITaskOutputLoginLevel, bool) {
	return &msssmtoll, true
}

// AsMigrateSQLServerSQLMITaskOutputAgentJobLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) AsMigrateSQLServerSQLMITaskOutputAgentJobLevel() (*MigrateSQLServerSQLMITaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) AsMigrateSQLServerSQLMITaskOutputDatabaseLevel() (*MigrateSQLServerSQLMITaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) AsMigrateSQLServerSQLMITaskOutputMigrationLevel() (*MigrateSQLServerSQLMITaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) AsMigrateSQLServerSQLMITaskOutput() (*MigrateSQLServerSQLMITaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) AsBasicMigrateSQLServerSQLMITaskOutput() (BasicMigrateSQLServerSQLMITaskOutput, bool) {
	return &msssmtoll, true
}

// MigrateSQLServerSQLMITaskOutputMigrationLevel ...
type MigrateSQLServerSQLMITaskOutputMigrationLevel struct {
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// Status - READ-ONLY; Current status of migration. Possible values include: 'MigrationStatusDefault', 'MigrationStatusConnecting', 'MigrationStatusSourceAndTargetSelected', 'MigrationStatusSelectLogins', 'MigrationStatusConfigured', 'MigrationStatusRunning', 'MigrationStatusError', 'MigrationStatusStopped', 'MigrationStatusCompleted', 'MigrationStatusCompletedWithWarnings'
	Status MigrationStatus `json:"status,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// AgentJobs - READ-ONLY; Selected agent jobs as a map from name to id
	AgentJobs map[string]*string `json:"agentJobs"`
	// Logins - READ-ONLY; Selected logins as a map from name to id
	Logins map[string]*string `json:"logins"`
	// Message - READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty"`
	// ServerRoleResults - READ-ONLY; Map of server role migration results.
	ServerRoleResults map[string]*StartMigrationScenarioServerRoleResult `json:"serverRoleResults"`
	// OrphanedUsersInfo - READ-ONLY; List of orphaned users.
	OrphanedUsersInfo *[]OrphanedUserInfo `json:"orphanedUsersInfo,omitempty"`
	// Databases - READ-ONLY; Selected databases as a map from database name to database id
	Databases map[string]*string `json:"databases"`
	// SourceServerVersion - READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// SourceServerBrandVersion - READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty"`
	// TargetServerVersion - READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServerBrandVersion - READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMITaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	msssmtoml.ResultType = ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput
	objectMap := make(map[string]interface{})
	if msssmtoml.ResultType != "" {
		objectMap["resultType"] = msssmtoml.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMITaskOutputError is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) AsMigrateSQLServerSQLMITaskOutputError() (*MigrateSQLServerSQLMITaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputLoginLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) AsMigrateSQLServerSQLMITaskOutputLoginLevel() (*MigrateSQLServerSQLMITaskOutputLoginLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputAgentJobLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) AsMigrateSQLServerSQLMITaskOutputAgentJobLevel() (*MigrateSQLServerSQLMITaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) AsMigrateSQLServerSQLMITaskOutputDatabaseLevel() (*MigrateSQLServerSQLMITaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) AsMigrateSQLServerSQLMITaskOutputMigrationLevel() (*MigrateSQLServerSQLMITaskOutputMigrationLevel, bool) {
	return &msssmtoml, true
}

// AsMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) AsMigrateSQLServerSQLMITaskOutput() (*MigrateSQLServerSQLMITaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) AsBasicMigrateSQLServerSQLMITaskOutput() (BasicMigrateSQLServerSQLMITaskOutput, bool) {
	return &msssmtoml, true
}

// MigrateSQLServerSQLMITaskProperties properties for task that migrates SQL Server databases to Azure SQL
// Database Managed Instance
type MigrateSQLServerSQLMITaskProperties struct {
	// Input - Task input
	Input *MigrateSQLServerSQLMITaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]BasicMigrateSQLServerSQLMITaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) MarshalJSON() ([]byte, error) {
	msssmtp.TaskType = TaskTypeMigrateSQLServerAzureSQLDbMI
	objectMap := make(map[string]interface{})
	if msssmtp.Input != nil {
		objectMap["input"] = msssmtp.Input
	}
	if msssmtp.ClientData != nil {
		objectMap["clientData"] = msssmtp.ClientData
	}
	if msssmtp.TaskType != "" {
		objectMap["taskType"] = msssmtp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return nil, false
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return &msssmtp, true
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &msssmtp, true
}

// UnmarshalJSON is the custom unmarshaler for MigrateSQLServerSQLMITaskProperties struct.
func (msssmtp *MigrateSQLServerSQLMITaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input MigrateSQLServerSQLMITaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				msssmtp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMigrateSQLServerSQLMITaskOutputArray(*v)
				if err != nil {
					return err
				}
				msssmtp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				msssmtp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				msssmtp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				msssmtp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				msssmtp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				msssmtp.TaskType = taskType
			}
		}
	}

	return nil
}

// MigrateSQLServerSQLServerDatabaseInput database specific information for SQL to SQL migration task
// inputs
type MigrateSQLServerSQLServerDatabaseInput struct {
	// Name - Name of the database
	Name *string `json:"name,omitempty"`
	// RestoreDatabaseName - Name of the database at destination
	RestoreDatabaseName *string `json:"restoreDatabaseName,omitempty"`
	// BackupAndRestoreFolder - The backup and restore folder
	BackupAndRestoreFolder *string `json:"backupAndRestoreFolder,omitempty"`
	// DatabaseFiles - The list of database files
	DatabaseFiles *[]DatabaseFileInput `json:"databaseFiles,omitempty"`
}

// MigrateSsisTaskInput input for task that migrates SSIS packages from SQL Server to Azure SQL Database
// Managed Instance.
type MigrateSsisTaskInput struct {
	// SsisMigrationInfo - SSIS package migration information.
	SsisMigrationInfo *SsisMigrationInfo `json:"ssisMigrationInfo,omitempty"`
	// SourceConnectionInfo - Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// BasicMigrateSsisTaskOutput output for task that migrates SSIS packages from SQL Server to Azure SQL Database Managed
// Instance.
type BasicMigrateSsisTaskOutput interface {
	AsMigrateSsisTaskOutputProjectLevel() (*MigrateSsisTaskOutputProjectLevel, bool)
	AsMigrateSsisTaskOutputMigrationLevel() (*MigrateSsisTaskOutputMigrationLevel, bool)
	AsMigrateSsisTaskOutput() (*MigrateSsisTaskOutput, bool)
}

// MigrateSsisTaskOutput output for task that migrates SSIS packages from SQL Server to Azure SQL Database
// Managed Instance.
type MigrateSsisTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeMigrateSsisTaskOutput', 'ResultTypeSsisProjectLevelOutput', 'ResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSsisTaskOutput `json:"resultType,omitempty"`
}

func unmarshalBasicMigrateSsisTaskOutput(body []byte) (BasicMigrateSsisTaskOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resultType"] {
	case string(ResultTypeSsisProjectLevelOutput):
		var mstopl MigrateSsisTaskOutputProjectLevel
		err := json.Unmarshal(body, &mstopl)
		return mstopl, err
	case string(ResultTypeMigrationLevelOutput):
		var mstoml MigrateSsisTaskOutputMigrationLevel
		err := json.Unmarshal(body, &mstoml)
		return mstoml, err
	default:
		var msto MigrateSsisTaskOutput
		err := json.Unmarshal(body, &msto)
		return msto, err
	}
}
func unmarshalBasicMigrateSsisTaskOutputArray(body []byte) ([]BasicMigrateSsisTaskOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	mstoArray := make([]BasicMigrateSsisTaskOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		msto, err := unmarshalBasicMigrateSsisTaskOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		mstoArray[index] = msto
	}
	return mstoArray, nil
}

// MarshalJSON is the custom marshaler for MigrateSsisTaskOutput.
func (msto MigrateSsisTaskOutput) MarshalJSON() ([]byte, error) {
	msto.ResultType = ResultTypeMigrateSsisTaskOutput
	objectMap := make(map[string]interface{})
	if msto.ResultType != "" {
		objectMap["resultType"] = msto.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskOutputProjectLevel is the BasicMigrateSsisTaskOutput implementation for MigrateSsisTaskOutput.
func (msto MigrateSsisTaskOutput) AsMigrateSsisTaskOutputProjectLevel() (*MigrateSsisTaskOutputProjectLevel, bool) {
	return nil, false
}

// AsMigrateSsisTaskOutputMigrationLevel is the BasicMigrateSsisTaskOutput implementation for MigrateSsisTaskOutput.
func (msto MigrateSsisTaskOutput) AsMigrateSsisTaskOutputMigrationLevel() (*MigrateSsisTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSsisTaskOutput is the BasicMigrateSsisTaskOutput implementation for MigrateSsisTaskOutput.
func (msto MigrateSsisTaskOutput) AsMigrateSsisTaskOutput() (*MigrateSsisTaskOutput, bool) {
	return &msto, true
}

// AsBasicMigrateSsisTaskOutput is the BasicMigrateSsisTaskOutput implementation for MigrateSsisTaskOutput.
func (msto MigrateSsisTaskOutput) AsBasicMigrateSsisTaskOutput() (BasicMigrateSsisTaskOutput, bool) {
	return &msto, true
}

// MigrateSsisTaskOutputMigrationLevel ...
type MigrateSsisTaskOutputMigrationLevel struct {
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// Status - READ-ONLY; Current status of migration. Possible values include: 'MigrationStatusDefault', 'MigrationStatusConnecting', 'MigrationStatusSourceAndTargetSelected', 'MigrationStatusSelectLogins', 'MigrationStatusConfigured', 'MigrationStatusRunning', 'MigrationStatusError', 'MigrationStatusStopped', 'MigrationStatusCompleted', 'MigrationStatusCompletedWithWarnings'
	Status MigrationStatus `json:"status,omitempty"`
	// Message - READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty"`
	// SourceServerVersion - READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// SourceServerBrandVersion - READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty"`
	// TargetServerVersion - READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServerBrandVersion - READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// Stage - READ-ONLY; Stage of SSIS migration. Possible values include: 'SsisMigrationStageNone', 'SsisMigrationStageInitialize', 'SsisMigrationStageInProgress', 'SsisMigrationStageCompleted'
	Stage SsisMigrationStage `json:"stage,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeMigrateSsisTaskOutput', 'ResultTypeSsisProjectLevelOutput', 'ResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSsisTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSsisTaskOutputMigrationLevel.
func (mstoml MigrateSsisTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	mstoml.ResultType = ResultTypeMigrationLevelOutput
	objectMap := make(map[string]interface{})
	if mstoml.ResultType != "" {
		objectMap["resultType"] = mstoml.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskOutputProjectLevel is the BasicMigrateSsisTaskOutput implementation for MigrateSsisTaskOutputMigrationLevel.
func (mstoml MigrateSsisTaskOutputMigrationLevel) AsMigrateSsisTaskOutputProjectLevel() (*MigrateSsisTaskOutputProjectLevel, bool) {
	return nil, false
}

// AsMigrateSsisTaskOutputMigrationLevel is the BasicMigrateSsisTaskOutput implementation for MigrateSsisTaskOutputMigrationLevel.
func (mstoml MigrateSsisTaskOutputMigrationLevel) AsMigrateSsisTaskOutputMigrationLevel() (*MigrateSsisTaskOutputMigrationLevel, bool) {
	return &mstoml, true
}

// AsMigrateSsisTaskOutput is the BasicMigrateSsisTaskOutput implementation for MigrateSsisTaskOutputMigrationLevel.
func (mstoml MigrateSsisTaskOutputMigrationLevel) AsMigrateSsisTaskOutput() (*MigrateSsisTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSsisTaskOutput is the BasicMigrateSsisTaskOutput implementation for MigrateSsisTaskOutputMigrationLevel.
func (mstoml MigrateSsisTaskOutputMigrationLevel) AsBasicMigrateSsisTaskOutput() (BasicMigrateSsisTaskOutput, bool) {
	return &mstoml, true
}

// MigrateSsisTaskOutputProjectLevel ...
type MigrateSsisTaskOutputProjectLevel struct {
	// FolderName - READ-ONLY; Name of the folder
	FolderName *string `json:"folderName,omitempty"`
	// ProjectName - READ-ONLY; Name of the project
	ProjectName *string `json:"projectName,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// Stage - READ-ONLY; Stage of SSIS migration. Possible values include: 'SsisMigrationStageNone', 'SsisMigrationStageInitialize', 'SsisMigrationStageInProgress', 'SsisMigrationStageCompleted'
	Stage SsisMigrationStage `json:"stage,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// Message - READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Migration exceptions and warnings
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeMigrateSsisTaskOutput', 'ResultTypeSsisProjectLevelOutput', 'ResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSsisTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSsisTaskOutputProjectLevel.
func (mstopl MigrateSsisTaskOutputProjectLevel) MarshalJSON() ([]byte, error) {
	mstopl.ResultType = ResultTypeSsisProjectLevelOutput
	objectMap := make(map[string]interface{})
	if mstopl.ResultType != "" {
		objectMap["resultType"] = mstopl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskOutputProjectLevel is the BasicMigrateSsisTaskOutput implementation for MigrateSsisTaskOutputProjectLevel.
func (mstopl MigrateSsisTaskOutputProjectLevel) AsMigrateSsisTaskOutputProjectLevel() (*MigrateSsisTaskOutputProjectLevel, bool) {
	return &mstopl, true
}

// AsMigrateSsisTaskOutputMigrationLevel is the BasicMigrateSsisTaskOutput implementation for MigrateSsisTaskOutputProjectLevel.
func (mstopl MigrateSsisTaskOutputProjectLevel) AsMigrateSsisTaskOutputMigrationLevel() (*MigrateSsisTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSsisTaskOutput is the BasicMigrateSsisTaskOutput implementation for MigrateSsisTaskOutputProjectLevel.
func (mstopl MigrateSsisTaskOutputProjectLevel) AsMigrateSsisTaskOutput() (*MigrateSsisTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSsisTaskOutput is the BasicMigrateSsisTaskOutput implementation for MigrateSsisTaskOutputProjectLevel.
func (mstopl MigrateSsisTaskOutputProjectLevel) AsBasicMigrateSsisTaskOutput() (BasicMigrateSsisTaskOutput, bool) {
	return &mstopl, true
}

// MigrateSsisTaskProperties properties for task that migrates SSIS packages from SQL Server databases to
// Azure SQL Database Managed Instance.
type MigrateSsisTaskProperties struct {
	// Input - Task input
	Input *MigrateSsisTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]BasicMigrateSsisTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) MarshalJSON() ([]byte, error) {
	mstp.TaskType = TaskTypeMigrateSsis
	objectMap := make(map[string]interface{})
	if mstp.Input != nil {
		objectMap["input"] = mstp.Input
	}
	if mstp.ClientData != nil {
		objectMap["clientData"] = mstp.ClientData
	}
	if mstp.TaskType != "" {
		objectMap["taskType"] = mstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSsisTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool) {
	return &mstp, true
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsMigrateMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesPostgreSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesOracleTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceOracleSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToMongoDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsMigrateSchemaSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsCheckOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsUploadOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsInstallOCIDriverTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSsisTaskProperties.
func (mstp MigrateSsisTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &mstp, true
}

// UnmarshalJSON is the custom unmarshaler for MigrateSsisTaskProperties struct.
func (mstp *MigrateSsisTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input MigrateSsisTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				mstp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMigrateSsisTaskOutputArray(*v)
				if err != nil {
					return err
				}
				mstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				mstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				mstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				mstp.Commands = &commands
			}
		case "clientData":
			if v != nil {
				var clientData map[string]*string
				err = json.Unmarshal(*v, &clientData)
				if err != nil {
					return err
				}
				mstp.ClientData = clientData
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				mstp.TaskType = taskType
			}
		}
	}

	return nil
}

// MigrateSyncCompleteCommandInput input for command that completes sync migration for a database.
type MigrateSyncCompleteCommandInput struct {
	// DatabaseName - Name of database
	DatabaseName *string `json:"databaseName,omitempty"`
	// CommitTimeStamp - Time stamp to complete
	CommitTimeStamp *date.Time `json:"commitTimeStamp,omitempty"`
}

// MigrateSyncCompleteCommandOutput output for command that completes sync migration for a database.
type MigrateSyncCompleteCommandOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// Errors - READ-ONLY; List of errors that happened during the command execution
	Errors *[]ReportableException `json:"errors,omitempty"`
}

// MigrateSyncCompleteCommandProperties properties for the command that completes sync migration for a
// database.
type MigrateSyncCompleteCommandProperties struct {
	// Input - Command input
	Input *MigrateSyncCompleteCommandInput `json:"input,omitempty"`
	// Output - READ-ONLY; Command output. This is ignored if submitted.
	Output *MigrateSyncCompleteCommandOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the command. This is ignored if submitted. Possible values include: 'Unknown', 'Accepted', 'Running', 'Succeeded', 'Failed'
	State CommandState `json:"state,omitempty"`
	// CommandType - Possible values include: 'CommandTypeCommandProperties', 'CommandTypeMigrateSQLServerAzureDbSQLMiComplete', 'CommandTypeMigrateSyncCompleteDatabase', 'CommandTypeCancel', 'CommandTypeFinish', 'CommandTypeRestart'
	CommandType CommandType `json:"commandType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSyncCompleteCommandProperties.
func (msccp MigrateSyncCompleteCommandProperties) MarshalJSON() ([]byte, error) {
	msccp.CommandType = CommandTypeMigrateSyncCompleteDatabase
	objectMap := make(map[string]interface{})
	if msccp.Input != nil {
		objectMap["input"] = msccp.Input
	}
	if msccp.CommandType != "" {
		objectMap["commandType"] = msccp.CommandType
	}
	return json.Marshal(objectMap)
}

// AsMigrateMISyncCompleteCommandProperties is the BasicCommandProperties implementation for MigrateSyncCompleteCommandProperties.
func (msccp MigrateSyncCompleteCommandProperties) AsMigrateMISyncCompleteCommandProperties() (*MigrateMISyncCompleteCommandProperties, bool) {
	return nil, false
}

// AsMigrateSyncCompleteCommandProperties is the BasicCommandProperties implementation for MigrateSyncCompleteCommandProperties.
func (msccp MigrateSyncCompleteCommandProperties) AsMigrateSyncCompleteCommandProperties() (*MigrateSyncCompleteCommandProperties, bool) {
	return &msccp, true
}

// AsMongoDbCancelCommand is the BasicCommandProperties implementation for MigrateSyncCompleteCommandProperties.
func (msccp MigrateSyncCompleteCommandProperties) AsMongoDbCancelCommand() (*MongoDbCancelCommand, bool) {
	return nil, false
}

// AsMongoDbFinishCommand is the BasicCommandProperties implementation for MigrateSyncCompleteCommandProperties.
func (msccp MigrateSyncCompleteCommandProperties) AsMongoDbFinishCommand() (*MongoDbFinishCommand, bool) {
	return nil, false
}

// AsMongoDbRestartCommand is the BasicCommandProperties implementation for MigrateSyncCompleteCommandProperties.
func (msccp MigrateSyncCompleteCommandProperties) AsMongoDbRestartCommand() (*MongoDbRestartCommand, bool) {
	return nil, false
}

// AsCommandProperties is the BasicCommandProperties implementation for MigrateSyncCompleteCommandProperties.
func (msccp MigrateSyncCompleteCommandProperties) AsCommandProperties() (*CommandProperties, bool) {
	return nil, false
}

// AsBasicCommandProperties is the BasicCommandProperties implementation for MigrateSyncCompleteCommandProperties.
func (msccp MigrateSyncCompleteCommandProperties) AsBasicCommandProperties() (BasicCommandProperties, bool) {
	return &msccp, true
}

// MigrationEligibilityInfo information about migration eligibility of a server object
type MigrationEligibilityInfo struct {
	// IsEligibleForMigration - READ-ONLY; Whether object is eligible for migration or not.
	IsEligibleForMigration *bool `json:"isEligibleForMigration,omitempty"`
	// ValidationMessages - READ-ONLY; Information about eligibility failure for the server object.
	ValidationMessages *[]string `json:"validationMessages,omitempty"`
}

// MigrationReportResult migration validation report result, contains the url for downloading the generated
// report.
type MigrationReportResult struct {
	// ID - Migration validation result identifier
	ID *string `json:"id,omitempty"`
	// ReportURL - The url of the report.
	ReportURL *string `json:"reportUrl,omitempty"`
}

// MigrationTableMetadata metadata for tables selected in migration project
type MigrationTableMetadata struct {
	// SourceTableName - READ-ONLY; Source table name
	SourceTableName *string `json:"sourceTableName,omitempty"`
	// TargetTableName - READ-ONLY; Target table name
	TargetTableName *string `json:"targetTableName,omitempty"`
}

// MigrationValidationDatabaseLevelResult database level validation results
type MigrationValidationDatabaseLevelResult struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// MigrationID - READ-ONLY; Migration Identifier
	MigrationID *string `json:"migrationId,omitempty"`
	// SourceDatabaseName - READ-ONLY; Name of the source database
	SourceDatabaseName *string `json:"sourceDatabaseName,omitempty"`
	// TargetDatabaseName - READ-ONLY; Name of the target database
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// StartedOn - READ-ONLY; Validation start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Validation end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// DataIntegrityValidationResult - READ-ONLY; Provides data integrity validation result between the source and target tables that are migrated.
	DataIntegrityValidationResult *DataIntegrityValidationResult `json:"dataIntegrityValidationResult,omitempty"`
	// SchemaValidationResult - READ-ONLY; Provides schema comparison result between source and target database
	SchemaValidationResult *SchemaComparisonValidationResult `json:"schemaValidationResult,omitempty"`
	// QueryAnalysisValidationResult - READ-ONLY; Results of some of the query execution result between source and target database
	QueryAnalysisValidationResult *QueryAnalysisValidationResult `json:"queryAnalysisValidationResult,omitempty"`
	// Status - READ-ONLY; Current status of validation at the database level. Possible values include: 'ValidationStatusDefault', 'ValidationStatusNotStarted', 'ValidationStatusInitialized', 'ValidationStatusInProgress', 'ValidationStatusCompleted', 'ValidationStatusCompletedWithIssues', 'ValidationStatusStopped', 'ValidationStatusFailed'
	Status ValidationStatus `json:"status,omitempty"`
}

// MigrationValidationDatabaseSummaryResult migration Validation Database level summary result
type MigrationValidationDatabaseSummaryResult struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// MigrationID - READ-ONLY; Migration Identifier
	MigrationID *string `json:"migrationId,omitempty"`
	// SourceDatabaseName - READ-ONLY; Name of the source database
	SourceDatabaseName *string `json:"sourceDatabaseName,omitempty"`
	// TargetDatabaseName - READ-ONLY; Name of the target database
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// StartedOn - READ-ONLY; Validation start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Validation end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// Status - READ-ONLY; Current status of validation at the database level. Possible values include: 'ValidationStatusDefault', 'ValidationStatusNotStarted', 'ValidationStatusInitialized', 'ValidationStatusInProgress', 'ValidationStatusCompleted', 'ValidationStatusCompletedWithIssues', 'ValidationStatusStopped', 'ValidationStatusFailed'
	Status ValidationStatus `json:"status,omitempty"`
}

// MigrationValidationOptions types of validations to run after the migration
type MigrationValidationOptions struct {
	// EnableSchemaValidation - Allows to compare the schema information between source and target.
	EnableSchemaValidation *bool `json:"enableSchemaValidation,omitempty"`
	// EnableDataIntegrityValidation - Allows to perform a checksum based data integrity validation between source and target for the selected database / tables .
	EnableDataIntegrityValidation *bool `json:"enableDataIntegrityValidation,omitempty"`
	// EnableQueryAnalysisValidation - Allows to perform a quick and intelligent query analysis by retrieving queries from the source database and executes them in the target. The result will have execution statistics for executions in source and target databases for the extracted queries.
	EnableQueryAnalysisValidation *bool `json:"enableQueryAnalysisValidation,omitempty"`
}

// MigrationValidationResult migration Validation Result
type MigrationValidationResult struct {
	// ID - READ-ONLY; Migration validation result identifier
	ID *string `json:"id,omitempty"`
	// MigrationID - READ-ONLY; Migration Identifier
	MigrationID *string `json:"migrationId,omitempty"`
	// SummaryResults - Validation summary results for each database
	SummaryResults map[string]*MigrationValidationDatabaseSummaryResult `json:"summaryResults"`
	// Status - READ-ONLY; Current status of validation at the migration level. Status from the database validation result status will be aggregated here. Possible values include: 'ValidationStatusDefault', 'ValidationStatusNotStarted', 'ValidationStatusInitialized', 'ValidationStatusInProgress', 'ValidationStatusCompleted', 'ValidationStatusCompletedWithIssues', 'ValidationStatusStopped', 'ValidationStatusFailed'
	Status ValidationStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrationValidationResult.
func (mvr MigrationValidationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mvr.SummaryResults != nil {
		objectMap["summaryResults"] = mvr.SummaryResults
	}
	return json.Marshal(objectMap)
}

// MiSQLConnectionInfo properties required to create a connection to Azure SQL database Managed instance
type MiSQLConnectionInfo struct {
	// ManagedInstanceResourceID - Resource id for Azure SQL database Managed instance
	ManagedInstanceResourceID *string `json:"managedInstanceResourceId,omitempty"`
	// UserName - User name
	UserName *string `json:"userName,omitempty"`
	// Password - Password credential.
	Password *string `json:"password,omitempty"`
	// Type - Possible values include: 'TypeConnectionInfo', 'TypeMiSQLConnectionInfo', 'TypePostgreSQLConnectionInfo', 'TypeOracleConnectionInfo', 'TypeMySQLConnectionInfo', 'TypeMongoDbConnectionInfo', 'TypeSQLConnectionInfo'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MiSQLConnectionInfo.
func (msci MiSQLConnectionInfo) MarshalJSON() ([]byte, error) {
	msci.Type = TypeMiSQLConnectionInfo
	objectMap := make(map[string]interface{})
	if msci.ManagedInstanceResourceID != nil {
		objectMap["managedInstanceResourceId"] = msci.ManagedInstanceResourceID
	}
	if msci.UserName != nil {
		objectMap["userName"] = msci.UserName
	}
	if msci.Password != nil {
		objectMap["password"] = msci.Password
	}
	if msci.Type != "" {
		objectMap["type"] = msci.Type
	}
	return json.Marshal(objectMap)
}

// AsMiSQLConnectionInfo is the BasicConnectionInfo implementation for MiSQLConnectionInfo.
func (msci MiSQLConnectionInfo) AsMiSQLConnectionInfo() (*MiSQLConnectionInfo, bool) {
	return &msci, true
}

// AsPostgreSQLConnectionInfo is the BasicConnectionInfo implementation for MiSQLConnectionInfo.
func (msci MiSQLConnectionInfo) AsPostgreSQLConnectionInfo() (*PostgreSQLConnectionInfo, bool) {
	return nil, false
}

// AsOracleConnectionInfo is the BasicConnectionInfo implementation for MiSQLConnectionInfo.
func (msci MiSQLConnectionInfo) AsOracleConnectionInfo() (*OracleConnectionInfo, bool) {
	return nil, false
}

// AsMySQLConnectionInfo is the BasicConnectionInfo implementation for MiSQLConnectionInfo.
func (msci MiSQLConnectionInfo) AsMySQLConnectionInfo() (*MySQLConnectionInfo, bool) {
	return nil, false
}

// AsMongoDbConnectionInfo is the BasicConnectionInfo implementation for MiSQLConnectionInfo.
func (msci MiSQLConnectionInfo) AsMongoDbConnectionInfo() (*MongoDbConnectionInfo, bool) {
	return nil, false
}

// AsSQLConnectionInfo is the BasicConnectionInfo implementation for MiSQLConnectionInfo.
func (msci MiSQLConnectionInfo) AsSQLConnectionInfo() (*SQLConnectionInfo, bool) {
	return nil, false
}

// AsConnectionInfo is the BasicConnectionInfo implementation for MiSQLConnectionInfo.
func (msci MiSQLConnectionInfo) AsConnectionInfo() (*ConnectionInfo, bool) {
	return nil, false
}

// AsBasicConnectionInfo is the BasicConnectionInfo implementation for MiSQLConnectionInfo.
func (msci MiSQLConnectionInfo) AsBasicConnectionInfo() (BasicConnectionInfo, bool) {
	return &msci, true
}

// MongoDbCancelCommand properties for the command that cancels a migration in whole or in part
type MongoDbCancelCommand struct {
	// Input - Command input
	Input *MongoDbCommandInput `json:"input,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the command. This is ignored if submitted. Possible values include: 'Unknown', 'Accepted', 'Running', 'Succeeded', 'Failed'
	State CommandState `json:"state,omitempty"`
	// CommandType - Possible values include: 'CommandTypeCommandProperties', 'CommandTypeMigrateSQLServerAzureDbSQLMiComplete', 'CommandTypeMigrateSyncCompleteDatabase', 'CommandTypeCancel', 'CommandTypeFinish', 'CommandTypeRestart'
	CommandType CommandType `json:"commandType,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDbCancelCommand.
func (mdcc MongoDbCancelCommand) MarshalJSON() ([]byte, error) {
	mdcc.CommandType = CommandTypeCancel
	objectMap := make(map[string]interface{})
	if mdcc.Input != nil {
		objectMap["input"] = mdcc.Input
	}
	if mdcc.CommandType != "" {
		objectMap["commandType"] = mdcc.CommandType
	}
	return json.Marshal(objectMap)
}

// AsMigrateMISyncCompleteCommandProperties is the BasicCommandProperties implementation for MongoDbCancelCommand.
func (mdcc MongoDbCancelCommand) AsMigrateMISyncCompleteCommandProperties() (*MigrateMISyncCompleteCommandProperties, bool) {
	return nil, false
}

// AsMigrateSyncCompleteCommandProperties is the BasicCommandProperties implementation for MongoDbCancelCommand.
func (mdcc MongoDbCancelCommand) AsMigrateSyncCompleteCommandProperties() (*MigrateSyncCompleteCommandProperties, bool) {
	return nil, false
}

// AsMongoDbCancelCommand is the BasicCommandProperties implementation for MongoDbCancelCommand.
func (mdcc MongoDbCancelCommand) AsMongoDbCancelCommand() (*MongoDbCancelCommand, bool) {
	return &mdcc, true
}

// AsMongoDbFinishCommand is the BasicCommandProperties implementation for MongoDbCancelCommand.
func (mdcc MongoDbCancelCommand) AsMongoDbFinishCommand() (*MongoDbFinishCommand, bool) {
	return nil, false
}

// AsMongoDbRestartCommand is the BasicCommandProperties implementation for MongoDbCancelCommand.
func (mdcc MongoDbCancelCommand) AsMongoDbRestartCommand() (*MongoDbRestartCommand, bool) {
	return nil, false
}

// AsCommandProperties is the BasicCommandProperties implementation for MongoDbCancelCommand.
func (mdcc MongoDbCancelCommand) AsCommandProperties() (*CommandProperties, bool) {
	return nil, false
}

// AsBasicCommandProperties is the BasicCommandProperties implementation for MongoDbCancelCommand.
func (mdcc MongoDbCancelCommand) AsBasicCommandProperties() (BasicCommandProperties, bool) {
	return &mdcc, true
}

// MongoDbClusterInfo describes a MongoDB data source
type MongoDbClusterInfo struct {
	// Databases - A list of non-system databases in the cluster
	Databases *[]MongoDbDatabaseInfo `json:"databases,omitempty"`
	// SupportsSharding - Whether the cluster supports sharded collections
	SupportsSharding *bool `json:"supportsSharding,omitempty"`
	// Type - The type of data source. Possible values include: 'BlobContainer', 'CosmosDb', 'MongoDb'
	Type MongoDbClusterType `json:"type,omitempty"`
	// Version - The version of the data source in the form x.y.z (e.g. 3.6.7). Not used if Type is BlobContainer.
	Version *string `json:"version,omitempty"`
}

// MongoDbCollectionInfo describes a supported collection within a MongoDB database
type MongoDbCollectionInfo struct {
	// DatabaseName - The name of the database containing the collection
	DatabaseName *string `json:"databaseName,omitempty"`
	// IsCapped - Whether the collection is a capped collection (i.e. whether it has a fixed size and acts like a circular buffer)
	IsCapped *bool `json:"isCapped,omitempty"`
	// IsSystemCollection - Whether the collection is system collection
	IsSystemCollection *bool `json:"isSystemCollection,omitempty"`
	// IsView - Whether the collection is a view of another collection
	IsView *bool `json:"isView,omitempty"`
	// ShardKey - The shard key on the collection, or null if the collection is not sharded
	ShardKey *MongoDbShardKeyInfo `json:"shardKey,omitempty"`
	// SupportsSharding - Whether the database has sharding enabled. Note that the migration task will enable sharding on the target if necessary.
	SupportsSharding *bool `json:"supportsSharding,omitempty"`
	// ViewOf - The name of the collection that this is a view of, if IsView is true
	ViewOf *string `json:"viewOf,omitempty"`
	// AverageDocumentSize - The average document size, or -1 if the average size is unknown
	AverageDocumentSize *int64 `json:"averageDocumentSize,omitempty"`
	// DataSize - The estimated total data size, in bytes, or -1 if the size is unknown.
	DataSize *int64 `json:"dataSize,omitempty"`
	// DocumentCount - The estimated total number of documents, or -1 if the document count is unknown
	DocumentCount *int64 `json:"documentCount,omitempty"`
	// Name - The unqualified name of the database or collection
	Name *string `json:"name,omitempty"`
	// QualifiedName - The qualified name of the database or collection. For a collection, this is the database-qualified name.
	QualifiedName *string `json:"qualifiedName,omitempty"`
}

// MongoDbCollectionProgress describes the progress of a collection
type MongoDbCollectionProgress struct {
	// BytesCopied - The number of document bytes copied during the Copying stage
	BytesCopied *int64 `json:"bytesCopied,omitempty"`
	// DocumentsCopied - The number of documents copied during the Copying stage
	DocumentsCopied *int64 `json:"documentsCopied,omitempty"`
	// ElapsedTime - The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan format)
	ElapsedTime *string `json:"elapsedTime,omitempty"`
	// Errors - The errors and warnings that have occurred for the current object. The keys are the error codes.
	Errors map[string]*MongoDbError `json:"errors"`
	// EventsPending - The number of oplog events awaiting replay
	EventsPending *int64 `json:"eventsPending,omitempty"`
	// EventsReplayed - The number of oplog events replayed so far
	EventsReplayed *int64 `json:"eventsReplayed,omitempty"`
	// LastEventTime - The timestamp of the last oplog event received, or null if no oplog event has been received yet
	LastEventTime *date.Time `json:"lastEventTime,omitempty"`
	// LastReplayTime - The timestamp of the last oplog event replayed, or null if no oplog event has been replayed yet
	LastReplayTime *date.Time `json:"lastReplayTime,omitempty"`
	// Name - The name of the progress object. For a collection, this is the unqualified collection name. For a database, this is the database name. For the overall migration, this is null.
	Name *string `json:"name,omitempty"`
	// QualifiedName - The qualified name of the progress object. For a collection, this is the database-qualified name. For a database, this is the database name. For the overall migration, this is null.
	QualifiedName *string `json:"qualifiedName,omitempty"`
	// ResultType - The type of progress object. Possible values include: 'ResultTypeMigration', 'ResultTypeDatabase', 'ResultTypeCollection'
	ResultType ResultType `json:"resultType,omitempty"`
	// State - Possible values include: 'MongoDbMigrationStateNotStarted', 'MongoDbMigrationStateValidatingInput', 'MongoDbMigrationStateInitializing', 'MongoDbMigrationStateRestarting', 'MongoDbMigrationStateCopying', 'MongoDbMigrationStateInitialReplay', 'MongoDbMigrationStateReplaying', 'MongoDbMigrationStateFinalizing', 'MongoDbMigrationStateComplete', 'MongoDbMigrationStateCanceled', 'MongoDbMigrationStateFailed'
	State MongoDbMigrationState `json:"state,omitempty"`
	// TotalBytes - The total number of document bytes on the source at the beginning of the Copying stage, or -1 if the total size was unknown
	TotalBytes *int64 `json:"totalBytes,omitempty"`
	// TotalDocuments - The total number of documents on the source at the beginning of the Copying stage, or -1 if the total count was unknown
	TotalDocuments *int64 `json:"totalDocuments,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDbCollectionProgress.
func (mdcp MongoDbCollectionProgress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdcp.BytesCopied != nil {
		objectMap["bytesCopied"] = mdcp.BytesCopied
	}
	if mdcp.DocumentsCopied != nil {
		objectMap["documentsCopied"] = mdcp.DocumentsCopied
	}
	if mdcp.ElapsedTime != nil {
		objectMap["elapsedTime"] = mdcp.ElapsedTime
	}
	if mdcp.Errors != nil {
		objectMap["errors"] = mdcp.Errors
	}
	if mdcp.EventsPending != nil {
		objectMap["eventsPending"] = mdcp.EventsPending
	}
	if mdcp.EventsReplayed != nil {
		objectMap["eventsReplayed"] = mdcp.EventsReplayed
	}
	if mdcp.LastEventTime != nil {
		objectMap["lastEventTime"] = mdcp.LastEventTime
	}
	if mdcp.LastReplayTime != nil {
		objectMap["lastReplayTime"] = mdcp.LastReplayTime
	}
	if mdcp.Name != nil {
		objectMap["name"] = mdcp.Name
	}
	if mdcp.QualifiedName != nil {
		objectMap["qualifiedName"] = mdcp.QualifiedName
	}
	if mdcp.ResultType != "" {
		objectMap["resultType"] = mdcp.ResultType
	}
	if mdcp.State != "" {
		objectMap["state"] = mdcp.State
	}
	if mdcp.TotalBytes != nil {
		objectMap["totalBytes"] = mdcp.TotalBytes
	}
	if mdcp.TotalDocuments != nil {
		objectMap["totalDocuments"] = mdcp.TotalDocuments
	}
	return json.Marshal(objectMap)
}

// MongoDbCollectionSettings describes how an individual MongoDB collection should be migrated
type MongoDbCollectionSettings struct {
	// CanDelete - Whether the migrator is allowed to drop the target collection in the course of performing a migration. The default is true.
	CanDelete *bool                   `json:"canDelete,omitempty"`
	ShardKey  *MongoDbShardKeySetting `json:"shardKey,omitempty"`
	// TargetRUs - The RUs that should be configured on a CosmosDB target, or null to use the default. This has no effect on non-CosmosDB targets.
	TargetRUs *int32 `json:"targetRUs,omitempty"`
}

// MongoDbCommandInput describes the input to the 'cancel' and 'restart' MongoDB migration commands
type MongoDbCommandInput struct {
	// ObjectName - The qualified name of a database or collection to act upon, or null to act upon the entire migration
	ObjectName *string `json:"objectName,omitempty"`
}

// MongoDbConnectionInfo describes a connection to a MongoDB data source
type MongoDbConnectionInfo struct {
	// ConnectionString - A MongoDB connection string or blob container URL. The user name and password can be specified here or in the userName and password properties
	ConnectionString *string `json:"connectionString,omitempty"`
	// UserName - User name
	UserName *string `json:"userName,omitempty"`
	// Password - Password credential.
	Password *string `json:"password,omitempty"`
	// Type - Possible values include: 'TypeConnectionInfo', 'TypeMiSQLConnectionInfo', 'TypePostgreSQLConnectionInfo', 'TypeOracleConnectionInfo', 'TypeMySQLConnectionInfo', 'TypeMongoDbConnectionInfo', 'TypeSQLConnectionInfo'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDbConnectionInfo.
func (mdci MongoDbConnectionInfo) MarshalJSON() ([]byte, error) {
	mdci.Type = TypeMongoDbConnectionInfo
	objectMap := make(map[string]interface{})
	if mdci.ConnectionString != nil {
		objectMap["connectionString"] = mdci.ConnectionString
	}
	if mdci.UserName != nil {
		objectMap["userName"] = mdci.UserName
	}
	if mdci.Password != nil {
		objectMap["password"] = mdci.Password
	}
	if mdci.Type != "" {
		objectMap["type"] = mdci.Type
	}
	return json.Marshal(objectMap)
}

// AsMiSQLConnectionInfo is the BasicConnectionInfo implementation for MongoDbConnectionInfo.
func (mdci MongoDbConnectionInfo) AsMiSQLConnectionInfo() (*MiSQLConnectionInfo, bool) {
	return nil, false
}

// AsPostgreSQLConnectionInfo is the BasicConnectionInfo implementation for MongoDbConnectionInfo.
func (mdci MongoDbConnectionInfo) AsPostgreSQLConnectionInfo() (*PostgreSQLConnectionInfo, bool) {
	return nil, false
}

// AsOracleConnectionInfo is the BasicConnectionInfo implementation for MongoDbConnectionInfo.
func (mdci MongoDbConnectionInfo) AsOracleConnectionInfo() (*OracleConnectionInfo, bool) {
	return nil, false
}

// AsMySQLConnectionInfo is the BasicConnectionInfo implementation for MongoDbConnectionInfo.
func (mdci MongoDbConnectionInfo) AsMySQLConnectionInfo() (*MySQLConnectionInfo, bool) {
	return nil, false
}

// AsMongoDbConnectionInfo is the BasicConnectionInfo implementation for MongoDbConnectionInfo.
func (mdci MongoDbConnectionInfo) AsMongoDbConnectionInfo() (*MongoDbConnectionInfo, bool) {
	return &mdci, true
}

// AsSQLConnectionInfo is the BasicConnectionInfo implementation for MongoDbConnectionInfo.
func (mdci MongoDbConnectionInfo) AsSQLConnectionInfo() (*SQLConnectionInfo, bool) {
	return nil, false
}

// AsConnectionInfo is the BasicConnectionInfo implementation for MongoDbConnectionInfo.
func (mdci MongoDbConnectionInfo) AsConnectionInfo() (*ConnectionInfo, bool) {
	return nil, false
}

// AsBasicConnectionInfo is the BasicConnectionInfo implementation for MongoDbConnectionInfo.
func (mdci MongoDbConnectionInfo) AsBasicConnectionInfo() (BasicConnectionInfo, bool) {
	return &mdci, true
}

// MongoDbDatabaseInfo describes a database within a MongoDB data source
type MongoDbDatabaseInfo struct {
	// Collections - A list of supported collections in a MongoDB database
	Collections *[]MongoDbCollectionInfo `json:"collections,omitempty"`
	// SupportsSharding - Whether the database has sharding enabled. Note that the migration task will enable sharding on the target if necessary.
	SupportsSharding *bool `json:"supportsSharding,omitempty"`
	// AverageDocumentSize - The average document size, or -1 if the average size is unknown
	AverageDocumentSize *int64 `json:"averageDocumentSize,omitempty"`
	// DataSize - The estimated total data size, in bytes, or -1 if the size is unknown.
	DataSize *int64 `json:"dataSize,omitempty"`
	// DocumentCount - The estimated total number of documents, or -1 if the document count is unknown
	DocumentCount *int64 `json:"documentCount,omitempty"`
	// Name - The unqualified name of the database or collection
	Name *string `json:"name,omitempty"`
	// QualifiedName - The qualified name of the database or collection. For a collection, this is the database-qualified name.
	QualifiedName *string `json:"qualifiedName,omitempty"`
}

// MongoDbDatabaseProgress describes the progress of a database
type MongoDbDatabaseProgress struct {
	// Collections - The progress of the collections in the database. The keys are the unqualified names of the collections
	Collections map[string]*MongoDbCollectionProgress `json:"collections"`
	// BytesCopied - The number of document bytes copied during the Copying stage
	BytesCopied *int64 `json:"bytesCopied,omitempty"`
	// DocumentsCopied - The number of documents copied during the Copying stage
	DocumentsCopied *int64 `json:"documentsCopied,omitempty"`
	// ElapsedTime - The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan format)
	ElapsedTime *string `json:"elapsedTime,omitempty"`
	// Errors - The errors and warnings that have occurred for the current object. The keys are the error codes.
	Errors map[string]*MongoDbError `json:"errors"`
	// EventsPending - The number of oplog events awaiting replay
	EventsPending *int64 `json:"eventsPending,omitempty"`
	// EventsReplayed - The number of oplog events replayed so far
	EventsReplayed *int64 `json:"eventsReplayed,omitempty"`
	// LastEventTime - The timestamp of the last oplog event received, or null if no oplog event has been received yet
	LastEventTime *date.Time `json:"lastEventTime,omitempty"`
	// LastReplayTime - The timestamp of the last oplog event replayed, or null if no oplog event has been replayed yet
	LastReplayTime *date.Time `json:"lastReplayTime,omitempty"`
	// Name - The name of the progress object. For a collection, this is the unqualified collection name. For a database, this is the database name. For the overall migration, this is null.
	Name *string `json:"name,omitempty"`
	// QualifiedName - The qualified name of the progress object. For a collection, this is the database-qualified name. For a database, this is the database name. For the overall migration, this is null.
	QualifiedName *string `json:"qualifiedName,omitempty"`
	// ResultType - The type of progress object. Possible values include: 'ResultTypeMigration', 'ResultTypeDatabase', 'ResultTypeCollection'
	ResultType ResultType `json:"resultType,omitempty"`
	// State - Possible values include: 'MongoDbMigrationStateNotStarted', 'MongoDbMigrationStateValidatingInput', 'MongoDbMigrationStateInitializing', 'MongoDbMigrationStateRestarting', 'MongoDbMigrationStateCopying', 'MongoDbMigrationStateInitialReplay', 'MongoDbMigrationStateReplaying', 'MongoDbMigrationStateFinalizing', 'MongoDbMigrationStateComplete', 'MongoDbMigrationStateCanceled', 'MongoDbMigrationStateFailed'
	State MongoDbMigrationState `json:"state,omitempty"`
	// TotalBytes - The total number of document bytes on the source at the beginning of the Copying stage, or -1 if the total size was unknown
	TotalBytes *int64 `json:"totalBytes,omitempty"`
	// TotalDocuments - The total number of documents on the source at the beginning of the Copying stage, or -1 if the total count was unknown
	TotalDocuments *int64 `json:"totalDocuments,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDbDatabaseProgress.
func (mddp MongoDbDatabaseProgress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mddp.Collections != nil {
		objectMap["collections"] = mddp.Collections
	}
	if mddp.BytesCopied != nil {
		objectMap["bytesCopied"] = mddp.BytesCopied
	}
	if mddp.DocumentsCopied != nil {
		objectMap["documentsCopied"] = mddp.DocumentsCopied
	}
	if mddp.ElapsedTime != nil {
		objectMap["elapsedTime"] = mddp.ElapsedTime
	}
	if mddp.Errors != nil {
		objectMap["errors"] = mddp.Errors
	}
	if mddp.EventsPending != nil {
		objectMap["eventsPending"] = mddp.EventsPending
	}
	if mddp.EventsReplayed != nil {
		objectMap["eventsReplayed"] = mddp.EventsReplayed
	}
	if mddp.LastEventTime != nil {
		objectMap["lastEventTime"] = mddp.LastEventTime
	}
	if mddp.LastReplayTime != nil {
		objectMap["lastReplayTime"] = mddp.LastReplayTime
	}
	if mddp.Name != nil {
		objectMap["name"] = mddp.Name
	}
	if mddp.QualifiedName != nil {
		objectMap["qualifiedName"] = mddp.QualifiedName
	}
	if mddp.ResultType != "" {
		objectMap["resultType"] = mddp.ResultType
	}
	if mddp.State != "" {
		objectMap["state"] = mddp.State
	}
	if mddp.TotalBytes != nil {
		objectMap["totalBytes"] = mddp.TotalBytes
	}
	if mddp.TotalDocuments != nil {
		objectMap["totalDocuments"] = mddp.TotalDocuments
	}
	return json.Marshal(objectMap)
}

// MongoDbDatabaseSettings describes how an individual MongoDB database should be migrated
type MongoDbDatabaseSettings struct {
	// Collections - The collections on the source database to migrate to the target. The keys are the unqualified names of the collections.
	Collections map[string]*MongoDbCollectionSettings `json:"collections"`
	// TargetRUs - The RUs that should be configured on a CosmosDB target, or null to use the default, or 0 if throughput should not be provisioned for the database. This has no effect on non-CosmosDB targets.
	TargetRUs *int32 `json:"targetRUs,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDbDatabaseSettings.
func (mdds MongoDbDatabaseSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdds.Collections != nil {
		objectMap["collections"] = mdds.Collections
	}
	if mdds.TargetRUs != nil {
		objectMap["targetRUs"] = mdds.TargetRUs
	}
	return json.Marshal(objectMap)
}

// MongoDbError describes an error or warning that occurred during a MongoDB migration
type MongoDbError struct {
	// Code - The non-localized, machine-readable code that describes the error or warning
	Code *string `json:"code,omitempty"`
	// Count - The number of times the error or warning has occurred
	Count *int32 `json:"count,omitempty"`
	// Message - The localized, human-readable message that describes the error or warning
	Message *string `json:"message,omitempty"`
	// Type - The type of error or warning. Possible values include: 'MongoDbErrorTypeError', 'MongoDbErrorTypeValidationError', 'MongoDbErrorTypeWarning'
	Type MongoDbErrorType `json:"type,omitempty"`
}

// MongoDbFinishCommand properties for the command that finishes a migration in whole or in part
type MongoDbFinishCommand struct {
	// Input - Command input
	Input *MongoDbFinishCommandInput `json:"input,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the command. This is ignored if submitted. Possible values include: 'Unknown', 'Accepted', 'Running', 'Succeeded', 'Failed'
	State CommandState `json:"state,omitempty"`
	// CommandType - Possible values include: 'CommandTypeCommandProperties', 'CommandTypeMigrateSQLServerAzureDbSQLMiComplete', 'CommandTypeMigrateSyncCompleteDatabase', 'CommandTypeCancel', 'CommandTypeFinish', 'CommandTypeRestart'
	CommandType CommandType `json:"commandType,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDbFinishCommand.
func (mdfc MongoDbFinishCommand) MarshalJSON() ([]byte, error) {
	mdfc.CommandType = CommandTypeFinish
	objectMap := make(map[string]interface{})
	if mdfc.Input != nil {
		objectMap["input"] = mdfc.Input
	}
	if mdfc.CommandType != "" {
		objectMap["commandType"] = mdfc.CommandType
	}
	return json.Marshal(objectMap)
}

// AsMigrateMISyncCompleteCommandProperties is the BasicCommandProperties implementation for MongoDbFinishCommand.
func (mdfc MongoDbFinishCommand) AsMigrateMISyncCompleteCommandProperties() (*MigrateMISyncCompleteCommandProperties, bool) {
	return nil, false
}

// AsMigrateSyncCompleteCommandProperties is the BasicCommandProperties implementation for MongoDbFinishCommand.
func (mdfc MongoDbFinishCommand) AsMigrateSyncCompleteCommandProperties() (*MigrateSyncCompleteCommandProperties, bool) {
	return nil, false
}

// AsMongoDbCancelCommand is the BasicCommandProperties implementation for MongoDbFinishCommand.
func (mdfc MongoDbFinishCommand) AsMongoDbCancelCommand() (*MongoDbCancelCommand, bool) {
	return nil, false
}

// AsMongoDbFinishCommand is the BasicCommandProperties implementation for MongoDbFinishCommand.
func (mdfc MongoDbFinishCommand) AsMongoDbFinishCommand() (*MongoDbFinishCommand, bool) {
	return &mdfc, true
}

// AsMongoDbRestartCommand is the BasicCommandProperties implementation for MongoDbFinishCommand.
func (mdfc MongoDbFinishCommand) AsMongoDbRestartCommand() (*MongoDbRestartCommand, bool) {
	return nil, false
}

// AsCommandProperties is the BasicCommandProperties implementation for MongoDbFinishCommand.
func (mdfc MongoDbFinishCommand) AsCommandProperties() (*CommandProperties, bool) {
	return nil, false
}

// AsBasicCommandProperties is the BasicCommandProperties implementation for MongoDbFinishCommand.
func (mdfc MongoDbFinishCommand) AsBasicCommandProperties() (BasicCommandProperties, bool) {
	return &mdfc, true
}

// MongoDbFinishCommandInput describes the input to the 'finish' MongoDB migration command
type MongoDbFinishCommandInput struct {
	// Immediate - If true, replication for the affected objects will be stopped immediately. If false, the migrator will finish replaying queued events before finishing the replication.
	Immediate *bool `json:"immediate,omitempty"`
	// ObjectName - The qualified name of a database or collection to act upon, or null to act upon the entire migration
	ObjectName *string `json:"objectName,omitempty"`
}

// MongoDbMigrationProgress describes the progress of the overall migration
type MongoDbMigrationProgress struct {
	// Databases - The progress of the databases in the migration. The keys are the names of the databases
	Databases map[string]*MongoDbDatabaseProgress `json:"databases"`
	// BytesCopied - The number of document bytes copied during the Copying stage
	BytesCopied *int64 `json:"bytesCopied,omitempty"`
	// DocumentsCopied - The number of documents copied during the Copying stage
	DocumentsCopied *int64 `json:"documentsCopied,omitempty"`
	// ElapsedTime - The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan format)
	ElapsedTime *string `json:"elapsedTime,omitempty"`
	// Errors - The errors and warnings that have occurred for the current object. The keys are the error codes.
	Errors map[string]*MongoDbError `json:"errors"`
	// EventsPending - The number of oplog events awaiting replay
	EventsPending *int64 `json:"eventsPending,omitempty"`
	// EventsReplayed - The number of oplog events replayed so far
	EventsReplayed *int64 `json:"eventsReplayed,omitempty"`
	// LastEventTime - The timestamp of the last oplog event received, or null if no oplog event has been received yet
	LastEventTime *date.Time `json:"lastEventTime,omitempty"`
	// LastReplayTime - The timestamp of the last oplog event replayed, or null if no oplog event has been replayed yet
	LastReplayTime *date.Time `json:"lastReplayTime,omitempty"`
	// Name - The name of the progress object. For a collection, this is the unqualified collection name. For a database, this is the database name. For the overall migration, this is null.
	Name *string `json:"name,omitempty"`
	// QualifiedName - The qualified name of the progress object. For a collection, this is the database-qualified name. For a database, this is the database name. For the overall migration, this is null.
	QualifiedName *string `json:"qualifiedName,omitempty"`
	// ResultType - The type of progress object. Possible values include: 'ResultTypeMigration', 'ResultTypeDatabase', 'ResultTypeCollection'
	ResultType ResultType `json:"resultType,omitempty"`
	// State - Possible values include: 'MongoDbMigrationStateNotStarted', 'MongoDbMigrationStateValidatingInput', 'MongoDbMigrationStateInitializing', 'MongoDbMigrationStateRestarting', 'MongoDbMigrationStateCopying', 'MongoDbMigrationStateInitialReplay', 'MongoDbMigrationStateReplaying', 'MongoDbMigrationStateFinalizing', 'MongoDbMigrationStateComplete', 'MongoDbMigrationStateCanceled', 'MongoDbMigrationStateFailed'
	State MongoDbMigrationState `json:"state,omitempty"`
	// TotalBytes - The total number of document bytes on the source at the beginning of the Copying stage, or -1 if the total size was unknown
	TotalBytes *int64 `json:"totalBytes,omitempty"`
	// TotalDocuments - The total number of documents on the source at the beginning of the Copying stage, or -1 if the total count was unknown
	TotalDocuments *int64 `json:"totalDocuments,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDbMigrationProgress.
func (mdmp MongoDbMigrationProgress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdmp.Databases != nil {
		objectMap["databases"] = mdmp.Databases
	}
	if mdmp.BytesCopied != nil {
		objectMap["bytesCopied"] = mdmp.BytesCopied
	}
	if mdmp.DocumentsCopied != nil {
		objectMap["documentsCopied"] = mdmp.DocumentsCopied
	}
	if mdmp.ElapsedTime != nil {
		objectMap["elapsedTime"] = mdmp.ElapsedTime
	}
	if mdmp.Errors != nil {
		objectMap["errors"] = mdmp.Errors
	}
	if mdmp.EventsPending != nil {
		objectMap["eventsPending"] = mdmp.EventsPending
	}
	if mdmp.EventsReplayed != nil {
		objectMap["eventsReplayed"] = mdmp.EventsReplayed
	}
	if mdmp.LastEventTime != nil {
		objectMap["lastEventTime"] = mdmp.LastEventTime
	}
	if mdmp.LastReplayTime != nil {
		objectMap["lastReplayTime"] = mdmp.LastReplayTime
	}
	if mdmp.Name != nil {
		objectMap["name"] = mdmp.Name
	}
	if mdmp.QualifiedName != nil {
		objectMap["qualifiedName"] = mdmp.QualifiedName
	}
	if mdmp.ResultType != "" {
		objectMap["resultType"] = mdmp.ResultType
	}
	if mdmp.State != "" {
		objectMap["state"] = mdmp.State
	}
	if mdmp.TotalBytes != nil {
		objectMap["totalBytes"] = mdmp.TotalBytes
	}
	if mdmp.TotalDocuments != nil {
		objectMap["totalDocuments"] = mdmp.TotalDocuments
	}
	return json.Marshal(objectMap)
}

// MongoDbMigrationSettings describes how a MongoDB data migration should be performed
type MongoDbMigrationSettings struct {
	// BoostRUs - The RU limit on a CosmosDB target that collections will be temporarily increased to (if lower) during the initial copy of a migration, from 10,000 to 1,000,000, or 0 to use the default boost (which is generally the maximum), or null to not boost the RUs. This setting has no effect on non-CosmosDB targets.
	BoostRUs *int32 `json:"boostRUs,omitempty"`
	// Databases - The databases on the source cluster to migrate to the target. The keys are the names of the databases.
	Databases map[string]*MongoDbDatabaseSettings `json:"databases"`
	// Replication - Describes how changes will be replicated from the source to the target. The default is OneTime. Possible values include: 'Disabled', 'OneTime', 'Continuous'
	Replication MongoDbReplication `json:"replication,omitempty"`
	// Source - Settings used to connect to the source cluster
	Source *MongoDbConnectionInfo `json:"source,omitempty"`
	// Target - Settings used to connect to the target cluster
	Target *MongoDbConnectionInfo `json:"target,omitempty"`
	// Throttling - Settings used to limit the resource usage of the migration
	Throttling *MongoDbThrottlingSettings `json:"throttling,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDbMigrationSettings.
func (mdms MongoDbMigrationSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdms.BoostRUs != nil {
		objectMap["boostRUs"] = mdms.BoostRUs
	}
	if mdms.Databases != nil {
		objectMap["databases"] = mdms.Databases
	}
	if mdms.Replication != "" {
		objectMap["replication"] = mdms.Replication
	}
	if mdms.Source != nil {
		objectMap["source"] = mdms.Source
	}
	if mdms.Target != nil {
		objectMap["target"] = mdms.Target
	}
	if mdms.Throttling != nil {
		objectMap["throttling"] = mdms.Throttling
	}
	return json.Marshal(objectMap)
}

// MongoDbObjectInfo describes a database or collection within a MongoDB data source
type MongoDbObjectInfo struct {
	// AverageDocumentSize - The average document size, or -1 if the average size is unknown
	AverageDocumentSize *int64 `json:"averageDocumentSize,omitempty"`
	// DataSize - The estimated total data size, in bytes, or -1 if the size is unknown.
	DataSize *int64 `json:"dataSize,omitempty"`
	// DocumentCount - The estimated total number of documents, or -1 if the document count is unknown
	DocumentCount *int64 `json:"documentCount,omitempty"`
	// Name - The unqualified name of the database or collection
	Name *string `json:"name,omitempty"`
	// QualifiedName - The qualified name of the database or collection. For a collection, this is the database-qualified name.
	QualifiedName *string `json:"qualifiedName,omitempty"`
}

// MongoDbProgress base class for MongoDB migration outputs
type MongoDbProgress struct {
	// BytesCopied - The number of document bytes copied during the Copying stage
	BytesCopied *int64 `json:"bytesCopied,omitempty"`
	// DocumentsCopied - The number of documents copied during the Copying stage
	DocumentsCopied *int64 `json:"documentsCopied,omitempty"`
	// ElapsedTime - The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan format)
	ElapsedTime *string `json:"elapsedTime,omitempty"`
	// Errors - The errors and warnings that have occurred for the current object. The keys are the error codes.
	Errors map[string]*MongoDbError `json:"errors"`
	// EventsPending - The number of oplog events awaiting replay
	EventsPending *int64 `json:"eventsPending,omitempty"`
	// EventsReplayed - The number of oplog events replayed so far
	EventsReplayed *int64 `json:"eventsReplayed,omitempty"`
	// LastEventTime - The timestamp of the last oplog event received, or null if no oplog event has been received yet
	LastEventTime *date.Time `json:"lastEventTime,omitempty"`
	// LastReplayTime - The timestamp of the last oplog event replayed, or null if no oplog event has been replayed yet
	LastReplayTime *date.Time `json:"lastReplayTime,omitempty"`
	// Name - The name of the progress object. For a collection, this is the unqualified collection name. For a database, this is the database name. For the overall migration, this is null.
	Name *string `json:"name,omitempty"`
	// QualifiedName - The qualified name of the progress object. For a collection, this is the database-qualified name. For a database, this is the database name. For the overall migration, this is null.
	QualifiedName *string `json:"qualifiedName,omitempty"`
	// ResultType - The type of progress object. Possible values include: 'ResultTypeMigration', 'ResultTypeDatabase', 'ResultTypeCollection'
	ResultType ResultType `json:"resultType,omitempty"`
	// State - Possible values include: 'MongoDbMigrationStateNotStarted', 'MongoDbMigrationStateValidatingInput', 'MongoDbMigrationStateInitializing', 'MongoDbMigrationStateRestarting', 'MongoDbMigrationStateCopying', 'MongoDbMigrationStateInitialReplay', 'MongoDbMigrationStateReplaying', 'MongoDbMigrationStateFinalizing', 'MongoDbMigrationStateComplete', 'MongoDbMigrationStateCanceled', 'MongoDbMigrationStateFailed'
	State MongoDbMigrationState `json:"state,omitempty"`
	// TotalBytes - The total number of document bytes on the source at the beginning of the Copying stage, or -1 if the total size was unknown
	TotalBytes *int64 `json:"totalBytes,omitempty"`
	// TotalDocuments - The total number of documents on the source at the beginning of the Copying stage, or -1 if the total count was unknown
	TotalDocuments *int64 `json:"totalDocuments,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDbProgress.
func (mdp MongoDbProgress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdp.BytesCopied != nil {
		objectMap["bytesCopied"] = mdp.BytesCopied
	}
	if mdp.DocumentsCopied != nil {
		objectMap["documentsCopied"] = mdp.DocumentsCopied
	}
	if mdp.ElapsedTime != nil {
		objectMap["elapsedTime"] = mdp.ElapsedTime
	}
	if mdp.Errors != nil {
		objectMap["errors"] = mdp.Errors
	}
	if mdp.EventsPending != nil {
		objectMap["eventsPending"] = mdp.EventsPending
	}
	if mdp.EventsReplayed != nil {
		objectMap["eventsReplayed"] = mdp.EventsReplayed
	}
	if mdp.LastEventTime != nil {
		objectMap["lastEventTime"] = mdp.LastEventTime
	}
	if mdp.LastReplayTime != nil {
		objectMap["lastReplayTime"] = mdp.LastReplayTime
	}
	if mdp.Name != nil {
		objectMap["name"] = mdp.Name
	}
	if mdp.QualifiedName != nil {
		objectMap["qualifiedName"] = mdp.QualifiedName
	}
	if mdp.ResultType != "" {
		objectMap["resultType"] = mdp.ResultType
	}
	if mdp.State != "" {
		objectMap["state"] = mdp.State
	}
	if mdp.TotalBytes != nil {
		objectMap["totalBytes"] = mdp.TotalBytes
	}
	if mdp.TotalDocuments != nil {
		objectMap["totalDocuments"] = mdp.TotalDocuments
	}
	return json.Marshal(objectMap)
}

// MongoDbRestartCommand properties for the command that restarts a migration in whole or in part
type MongoDbRestartCommand struct {
	// Input - Command input
	Input *MongoDbCommandInput `json:"input,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the command. This is ignored if submitted. Possible values include: 'Unknown', 'Accepted', 'Running', 'Succeeded', 'Failed'
	State CommandState `json:"state,omitempty"`
	// CommandType - Possible values include: 'CommandTypeCommandProperties', 'CommandTypeMigrateSQLServerAzureDbSQLMiComplete', 'CommandTypeMigrateSyncCompleteDatabase', 'CommandTypeCancel', 'CommandTypeFinish', 'CommandTypeRestart'
	CommandType CommandType `json:"commandType,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDbRestartCommand.
func (mdrc MongoDbRestartCommand) MarshalJSON() ([]byte, error) {
	mdrc.CommandType = CommandTypeRestart
	objectMap := make(map[string]interface{})
	if mdrc.Input != nil {
		objectMap["input"] = mdrc.Input
	}
	if mdrc.CommandType != "" {
		objectMap["commandType"] = mdrc.CommandType
	}
	return json.Marshal(objectMap)
}

// AsMigrateMISyncCompleteCommandProperties is the BasicCommandProperties implementation for MongoDbRestartCommand.
func (mdrc MongoDbRestartCommand) AsMigrateMISyncCompleteCommandProperties() (*MigrateMISyncCompleteCommandProperties, bool) {
	return nil, false
}

// AsMigrateSyncCompleteCommandProperties is the BasicCommandProperties implementation for MongoDbRestartCommand.
func (mdrc MongoDbRestartCommand) AsMigrateSyncCompleteCommandProperties() (*MigrateSyncCompleteCommandProperties, bool) {
	return nil, false
}

// AsMongoDbCancelCommand is the BasicCommandProperties implementation for MongoDbRestartCommand.
func (mdrc MongoDbRestartCommand) AsMongoDbCancelCommand() (*MongoDbCancelCommand, bool) {
	return nil, false
}

// AsMongoDbFinishCommand is the BasicCommandProperties implementation for MongoDbRestartCommand.
func (mdrc MongoDbRestartCommand) AsMongoDbFinishCommand() (*MongoDbFinishCommand, bool) {
	return nil, false
}

// AsMongoDbRestartCommand is the BasicCommandProperties implementation for MongoDbRestartCommand.
func (mdrc MongoDbRestartCommand) AsMongoDbRestartCommand() (*MongoDbRestartCommand, bool) {
	return &mdrc, true
}

// AsCommandProperties is the BasicCommandProperties implementation for MongoDbRestartCommand.
func (mdrc MongoDbRestartCommand) AsCommandProperties() (*CommandProperties, bool) {
	return nil, false
}

// AsBasicCommandProperties is the BasicCommandProperties implementation for MongoDbRestartCommand.
func (mdrc MongoDbRestartCommand) AsBasicCommandProperties() (BasicCommandProperties, bool) {
	return &mdrc, true
}

// MongoDbShardKeyField describes a field reference within a MongoDB shard key
type MongoDbShardKeyField struct {
	// Name - The name of the field
	Name *string `json:"name,omitempty"`
	// Order - The field ordering. Possible values include: 'Forward', 'Reverse', 'Hashed'
	Order MongoDbShardKeyOrder `json:"order,omitempty"`
}

// MongoDbShardKeyInfo describes a MongoDB shard key
type MongoDbShardKeyInfo struct {
	// Fields - The fields within the shard key
	Fields *[]MongoDbShardKeyField `json:"fields,omitempty"`
	// IsUnique - Whether the shard key is unique
	IsUnique *bool `json:"isUnique,omitempty"`
}

// MongoDbShardKeySetting describes a MongoDB shard key
type MongoDbShardKeySetting struct {
	// Fields - The fields within the shard key
	Fields *[]MongoDbShardKeyField `json:"fields,omitempty"`
	// IsUnique - Whether the shard key is unique
	IsUnique *bool `json:"isUnique,omitempty"`
}

// MongoDbThrottlingSettings specifies resource limits for the migration
type MongoDbThrottlingSettings struct {
	// MinFreeCPU - The percentage of CPU time that the migrator will try to avoid using, from 0 to 100
	MinFreeCPU *int32 `json:"minFreeCpu,omitempty"`
	// MinFreeMemoryMb - The number of megabytes of RAM that the migrator will try to avoid using
	MinFreeMemoryMb *int32 `json:"minFreeMemoryMb,omitempty"`
	// MaxParallelism - The maximum number of work items (e.g. collection copies) that will be processed in parallel
	MaxParallelism *int32 `json:"maxParallelism,omitempty"`
}

// MySQLConnectionInfo information for connecting to MySQL server
type MySQLConnectionInfo struct {
	// ServerName - Name of the server
	ServerName *string `json:"serverName,omitempty"`
	// Port - Port for Server
	Port *int32 `json:"port,omitempty"`
	// UserName - User name
	UserName *string `json:"userName,omitempty"`
	// Password - Password credential.
	Password *string `json:"password,omitempty"`
	// Type - Possible values include: 'TypeConnectionInfo', 'TypeMiSQLConnectionInfo', 'TypePostgreSQLConnectionInfo', 'TypeOracleConnectionInfo', 'TypeMySQLConnectionInfo', 'TypeMongoDbConnectionInfo', 'TypeSQLConnectionInfo'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MySQLConnectionInfo.
func (msci MySQLConnectionInfo) MarshalJSON() ([]byte, error) {
	msci.Type = TypeMySQLConnectionInfo
	objectMap := make(map[string]interface{})
	if msci.ServerName != nil {
		objectMap["serverName"] = msci.ServerName
	}
	if msci.Port != nil {
		objectMap["port"] = msci.Port
	}
	if msci.UserName != nil {
		objectMap["userName"] = msci.UserName
	}
	if msci.Password != nil {
		objectMap["password"] = msci.Password
	}
	if msci.Type != "" {
		objectMap["type"] = msci.Type
	}
	return json.Marshal(objectMap)
}

// AsMiSQLConnectionInfo is the BasicConnectionInfo implementation for MySQLConnectionInfo.
func (msci MySQLConnectionInfo) AsMiSQLConnectionInfo() (*MiSQLConnectionInfo, bool) {
	return nil, false
}

// AsPostgreSQLConnectionInfo is the BasicConnectionInfo implementation for MySQLConnectionInfo.
func (msci MySQLConnectionInfo) AsPostgreSQLConnectionInfo() (*PostgreSQLConnectionInfo, bool) {
	return nil, false
}

// AsOracleConnectionInfo is the BasicConnectionInfo implementation for MySQLConnectionInfo.
func (msci MySQLConnectionInfo) AsOracleConnectionInfo() (*OracleConnectionInfo, bool) {
	return nil, false
}

// AsMySQLConnectionInfo is the BasicConnectionInfo implementation for MySQLConnectionInfo.
func (msci MySQLConnectionInfo) AsMySQLConnectionInfo() (*MySQLConnectionInfo, bool) {
	return &msci, true
}

// AsMongoDbConnectionInfo is the BasicConnectionInfo implementation for MySQLConnectionInfo.
func (msci MySQLConnectionInfo) AsMongoDbConnectionInfo() (*MongoDbConnectionInfo, bool) {
	return nil, false
}

// AsSQLConnectionInfo is the BasicConnectionInfo implementation for MySQLConnectionInfo.
func (msci MySQLConnectionInfo) AsSQLConnectionInfo() (*SQLConnectionInfo, bool) {
	return nil, false
}

// AsConnectionInfo is the BasicConnectionInfo implementation for MySQLConnectionInfo.
func (msci MySQLConnectionInfo) AsConnectionInfo() (*ConnectionInfo, bool) {
	return nil, false
}

// AsBasicConnectionInfo is the BasicConnectionInfo implementation for MySQLConnectionInfo.
func (msci MySQLConnectionInfo) AsBasicConnectionInfo() (BasicConnectionInfo, bool) {
	return &msci, true
}

// NameAvailabilityRequest a resource type and proposed name
type NameAvailabilityRequest struct {
	// Name - The proposed resource name
	Name *string `json:"name,omitempty"`
	// Type - The resource type chain (e.g. virtualMachines/extensions)
	Type *string `json:"type,omitempty"`
}

// NameAvailabilityResponse indicates whether a proposed resource name is available
type NameAvailabilityResponse struct {
	autorest.Response `json:"-"`
	// NameAvailable - If true, the name is valid and available. If false, 'reason' describes why not.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - The reason why the name is not available, if nameAvailable is false. Possible values include: 'AlreadyExists', 'Invalid'
	Reason NameCheckFailureReason `json:"reason,omitempty"`
	// Message - The localized reason why the name is not available, if nameAvailable is false
	Message *string `json:"message,omitempty"`
}

// NonSQLDataMigrationTable defines metadata for table to be migrated
type NonSQLDataMigrationTable struct {
	// SourceName - Source table name
	SourceName *string `json:"sourceName,omitempty"`
}

// NonSQLDataMigrationTableResult object used to report the data migration results of a table
type NonSQLDataMigrationTableResult struct {
	// ResultCode - READ-ONLY; Result code of the data migration. Possible values include: 'Initial', 'Completed', 'ObjectNotExistsInSource', 'ObjectNotExistsInTarget', 'TargetObjectIsInaccessible', 'FatalError'
	ResultCode ResultCode `json:"resultCode,omitempty"`
	// SourceName - READ-ONLY; Name of the source table
	SourceName *string `json:"sourceName,omitempty"`
	// TargetName - READ-ONLY; Name of the target table
	TargetName *string `json:"targetName,omitempty"`
	// SourceRowCount - READ-ONLY; Number of rows in the source table
	SourceRowCount *int64 `json:"sourceRowCount,omitempty"`
	// TargetRowCount - READ-ONLY; Number of rows in the target table
	TargetRowCount *int64 `json:"targetRowCount,omitempty"`
	// ElapsedTimeInMiliseconds - READ-ONLY; Time taken to migrate the data
	ElapsedTimeInMiliseconds *float64 `json:"elapsedTimeInMiliseconds,omitempty"`
	// Errors - READ-ONLY; List of errors, if any, during migration
	Errors *[]Error `json:"errors,omitempty"`
}

// NonSQLMigrationTaskInput base class for non sql migration task input
type NonSQLMigrationTaskInput struct {
	// TargetConnectionInfo - Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
	// TargetDatabaseName - Target database name
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// ProjectName - Name of the migration project
	ProjectName *string `json:"projectName,omitempty"`
	// ProjectLocation - A URL that points to the drop location to access project artifacts
	ProjectLocation *string `json:"projectLocation,omitempty"`
	// SelectedTables - Metadata of the tables selected for migration
	SelectedTables *[]NonSQLDataMigrationTable `json:"selectedTables,omitempty"`
}

// NonSQLMigrationTaskOutput base class for non sql migration task output
type NonSQLMigrationTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// Status - READ-ONLY; Current state of migration. Possible values include: 'MigrationStatusDefault', 'MigrationStatusConnecting', 'MigrationStatusSourceAndTargetSelected', 'MigrationStatusSelectLogins', 'MigrationStatusConfigured', 'MigrationStatusRunning', 'MigrationStatusError', 'MigrationStatusStopped', 'MigrationStatusCompleted', 'MigrationStatusCompletedWithWarnings'
	Status MigrationStatus `json:"status,omitempty"`
	// DataMigrationTableResults - READ-ONLY; Results of the migration. The key contains the table name and the value the table result object
	DataMigrationTableResults map[string]*NonSQLDataMigrationTableResult `json:"dataMigrationTableResults"`
	// ProgressMessage - READ-ONLY; Message about the progress of the migration
	ProgressMessage *string `json:"progressMessage,omitempty"`
	// SourceServerName - READ-ONLY; Name of source server
	SourceServerName *string `json:"sourceServerName,omitempty"`
	// TargetServerName - READ-ONLY; Name of target server
	TargetServerName *string `json:"targetServerName,omitempty"`
}

// MarshalJSON is the custom marshaler for NonSQLMigrationTaskOutput.
func (nsmto NonSQLMigrationTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ODataError error information in OData format.
type ODataError struct {
	// Code - The machine-readable description of the error, such as 'InvalidRequest' or 'InternalServerError'
	Code *string `json:"code,omitempty"`
	// Message - The human-readable description of the error
	Message *string `json:"message,omitempty"`
	// Details - Inner errors that caused this error
	Details *[]ODataError `json:"details,omitempty"`
}

// OracleConnectionInfo information for connecting to Oracle server
type OracleConnectionInfo struct {
	// DataSource - EZConnect or TNSName connection string.
	DataSource *string `json:"dataSource,omitempty"`
	// UserName - User name
	UserName *string `json:"userName,omitempty"`
	// Password - Password credential.
	Password *string `json:"password,omitempty"`
	// Type - Possible values include: 'TypeConnectionInfo', 'TypeMiSQLConnectionInfo', 'TypePostgreSQLConnectionInfo', 'TypeOracleConnectionInfo', 'TypeMySQLConnectionInfo', 'TypeMongoDbConnectionInfo', 'TypeSQLConnectionInfo'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for OracleConnectionInfo.
func (oci OracleConnectionInfo) MarshalJSON() ([]byte, error) {
	oci.Type = TypeOracleConnectionInfo
	objectMap := make(map[string]interface{})
	if oci.DataSource != nil {
		objectMap["dataSource"] = oci.DataSource
	}
	if oci.UserName != nil {
		objectMap["userName"] = oci.UserName
	}
	if oci.Password != nil {
		objectMap["password"] = oci.Password
	}
	if oci.Type != "" {
		objectMap["type"] = oci.Type
	}
	return json.Marshal(objectMap)
}

// AsMiSQLConnectionInfo is the BasicConnectionInfo implementation for OracleConnectionInfo.
func (oci OracleConnectionInfo) AsMiSQLConnectionInfo() (*MiSQLConnectionInfo, bool) {
	return nil, false
}

// AsPostgreSQLConnectionInfo is the BasicConnectionInfo implementation for OracleConnectionInfo.
func (oci OracleConnectionInfo) AsPostgreSQLConnectionInfo() (*PostgreSQLConnectionInfo, bool) {
	return nil, false
}

// AsOracleConnectionInfo is the BasicConnectionInfo implementation for OracleConnectionInfo.
func (oci OracleConnectionInfo) AsOracleConnectionInfo() (*OracleConnectionInfo, bool) {
	return &oci, true
}

// AsMySQLConnectionInfo is the BasicConnectionInfo implementation for OracleConnectionInfo.
func (oci OracleConnectionInfo) AsMySQLConnectionInfo() (*MySQLConnectionInfo, bool) {
	return nil, false
}

// AsMongoDbConnectionInfo is the BasicConnectionInfo implementation for OracleConnectionInfo.
func (oci OracleConnectionInfo) AsMongoDbConnectionInfo() (*MongoDbConnectionInfo, bool) {
	return nil, false
}

// AsSQLConnectionInfo is the BasicConnectionInfo implementation for OracleConnectionInfo.
func (oci OracleConnectionInfo) AsSQLConnectionInfo() (*SQLConnectionInfo, bool) {
	return nil, false
}

// AsConnectionInfo is the BasicConnectionInfo implementation for OracleConnectionInfo.
func (oci OracleConnectionInfo) AsConnectionInfo() (*ConnectionInfo, bool) {
	return nil, false
}

// AsBasicConnectionInfo is the BasicConnectionInfo implementation for OracleConnectionInfo.
func (oci OracleConnectionInfo) AsBasicConnectionInfo() (BasicConnectionInfo, bool) {
	return &oci, true
}

// OracleOCIDriverInfo information about an Oracle OCI driver.
type OracleOCIDriverInfo struct {
	// DriverName - READ-ONLY; The name of the driver package
	DriverName *string `json:"driverName,omitempty"`
	// DriverSize - READ-ONLY; The size in bytes of the driver package
	DriverSize *string `json:"driverSize,omitempty"`
	// ArchiveChecksum - READ-ONLY; The MD5 Base64 encoded checksum for the driver package.
	ArchiveChecksum *string `json:"archiveChecksum,omitempty"`
	// OracleChecksum - READ-ONLY; The checksum for the driver package provided by Oracle.
	OracleChecksum *string `json:"oracleChecksum,omitempty"`
	// AssemblyVersion - READ-ONLY; Version listed in the OCI assembly 'oci.dll'
	AssemblyVersion *string `json:"assemblyVersion,omitempty"`
	// SupportedOracleVersions - READ-ONLY; List of Oracle database versions supported by this driver. Only major minor of the version is listed.
	SupportedOracleVersions *[]string `json:"supportedOracleVersions,omitempty"`
}

// OrphanedUserInfo information of orphaned users on the SQL server database.
type OrphanedUserInfo struct {
	// Name - Name of the orphaned user
	Name *string `json:"name,omitempty"`
	// DatabaseName - Parent database of the user
	DatabaseName *string `json:"databaseName,omitempty"`
}

// PostgreSQLConnectionInfo information for connecting to PostgreSQL server
type PostgreSQLConnectionInfo struct {
	// ServerName - Name of the server
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// Port - Port for Server
	Port *int32 `json:"port,omitempty"`
	// UserName - User name
	UserName *string `json:"userName,omitempty"`
	// Password - Password credential.
	Password *string `json:"password,omitempty"`
	// Type - Possible values include: 'TypeConnectionInfo', 'TypeMiSQLConnectionInfo', 'TypePostgreSQLConnectionInfo', 'TypeOracleConnectionInfo', 'TypeMySQLConnectionInfo', 'TypeMongoDbConnectionInfo', 'TypeSQLConnectionInfo'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PostgreSQLConnectionInfo.
func (psci PostgreSQLConnectionInfo) MarshalJSON() ([]byte, error) {
	psci.Type = TypePostgreSQLConnectionInfo
	objectMap := make(map[string]interface{})
	if psci.ServerName != nil {
		objectMap["serverName"] = psci.ServerName
	}
	if psci.DatabaseName != nil {
		objectMap["databaseName"] = psci.DatabaseName
	}
	if psci.Port != nil {
		objectMap["port"] = psci.Port
	}
	if psci.UserName != nil {
		objectMap["userName"] = psci.UserName
	}
	if psci.Password != nil {
		objectMap["password"] = psci.Password
	}
	if psci.Type != "" {
		objectMap["type"] = psci.Type
	}
	return json.Marshal(objectMap)
}

// AsMiSQLConnectionInfo is the BasicConnectionInfo implementation for PostgreSQLConnectionInfo.
func (psci PostgreSQLConnectionInfo) AsMiSQLConnectionInfo() (*MiSQLConnectionInfo, bool) {
	return nil, false
}

// AsPostgreSQLConnectionInfo is the BasicConnectionInfo implementation for PostgreSQLConnectionInfo.
func (psci PostgreSQLConnectionInfo) AsPostgreSQLConnectionInfo() (*PostgreSQLConnectionInfo, bool) {
	return &psci, true
}

// AsOracleConnectionInfo is the BasicConnectionInfo implementation for PostgreSQLConnectionInfo.
func (psci PostgreSQLConnectionInfo) AsOracleConnectionInfo() (*OracleConnectionInfo, bool) {
	return nil, false
}

// AsMySQLConnectionInfo is the BasicConnectionInfo implementation for PostgreSQLConnectionInfo.
func (psci PostgreSQLConnectionInfo) AsMySQLConnectionInfo() (*MySQLConnectionInfo, bool) {
	return nil, false
}

// AsMongoDbConnectionInfo is the BasicConnectionInfo implementation for PostgreSQLConnectionInfo.
func (psci PostgreSQLConnectionInfo) AsMongoDbConnectionInfo() (*MongoDbConnectionInfo, bool) {
	return nil, false
}

// AsSQLConnectionInfo is the BasicConnectionInfo implementation for PostgreSQLConnectionInfo.
func (psci PostgreSQLConnectionInfo) AsSQLConnectionInfo() (*SQLConnectionInfo, bool) {
	return nil, false
}

// AsConnectionInfo is the BasicConnectionInfo implementation for PostgreSQLConnectionInfo.
func (psci PostgreSQLConnectionInfo) AsConnectionInfo() (*ConnectionInfo, bool) {
	return nil, false
}

// AsBasicConnectionInfo is the BasicConnectionInfo implementation for PostgreSQLConnectionInfo.
func (psci PostgreSQLConnectionInfo) AsBasicConnectionInfo() (BasicConnectionInfo, bool) {
	return &psci, true
}

// Project a project resource
type Project struct {
	autorest.Response `json:"-"`
	// ProjectProperties - Project properties
	*ProjectProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Project.
func (p Project) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.ProjectProperties != nil {
		objectMap["properties"] = p.ProjectProperties
	}
	if p.Tags != nil {
		objectMap["tags"] = p.Tags
	}
	if p.Location != nil {
		objectMap["location"] = p.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Project struct.
func (p *Project) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var projectProperties ProjectProperties
				err = json.Unmarshal(*v, &projectProperties)
				if err != nil {
					return err
				}
				p.ProjectProperties = &projectProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				p.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				p.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		}
	}

	return nil
}

// ProjectFile a file resource
type ProjectFile struct {
	autorest.Response `json:"-"`
	// Etag - HTTP strong entity tag value. This is ignored if submitted.
	Etag *string `json:"etag,omitempty"`
	// Properties - Custom file properties
	Properties *ProjectFileProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// ProjectFileProperties base class for file properties.
type ProjectFileProperties struct {
	// Extension - Optional File extension. If submitted it should not have a leading period and must match the extension from filePath.
	Extension *string `json:"extension,omitempty"`
	// FilePath - Relative path of this file resource. This property can be set when creating or updating the file resource.
	FilePath *string `json:"filePath,omitempty"`
	// LastModified - READ-ONLY; Modification DateTime.
	LastModified *date.Time `json:"lastModified,omitempty"`
	// MediaType - File content type. This property can be modified to reflect the file content type.
	MediaType *string `json:"mediaType,omitempty"`
	// Size - READ-ONLY; File size.
	Size *int64 `json:"size,omitempty"`
}

// ProjectList oData page of project resources
type ProjectList struct {
	autorest.Response `json:"-"`
	// Value - List of projects
	Value *[]Project `json:"value,omitempty"`
	// NextLink - URL to load the next page of projects
	NextLink *string `json:"nextLink,omitempty"`
}

// ProjectListIterator provides access to a complete listing of Project values.
type ProjectListIterator struct {
	i    int
	page ProjectListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProjectListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProjectListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProjectListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProjectListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProjectListIterator) Response() ProjectList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProjectListIterator) Value() Project {
	if !iter.page.NotDone() {
		return Project{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProjectListIterator type.
func NewProjectListIterator(page ProjectListPage) ProjectListIterator {
	return ProjectListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pl ProjectList) IsEmpty() bool {
	return pl.Value == nil || len(*pl.Value) == 0
}

// projectListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pl ProjectList) projectListPreparer(ctx context.Context) (*http.Request, error) {
	if pl.NextLink == nil || len(to.String(pl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pl.NextLink)))
}

// ProjectListPage contains a page of Project values.
type ProjectListPage struct {
	fn func(context.Context, ProjectList) (ProjectList, error)
	pl ProjectList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProjectListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProjectListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pl)
	if err != nil {
		return err
	}
	page.pl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProjectListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProjectListPage) NotDone() bool {
	return !page.pl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProjectListPage) Response() ProjectList {
	return page.pl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProjectListPage) Values() []Project {
	if page.pl.IsEmpty() {
		return nil
	}
	return *page.pl.Value
}

// Creates a new instance of the ProjectListPage type.
func NewProjectListPage(getNextPage func(context.Context, ProjectList) (ProjectList, error)) ProjectListPage {
	return ProjectListPage{fn: getNextPage}
}

// ProjectMetadata common metadata for migration projects
type ProjectMetadata struct {
	// SourceServerName - READ-ONLY; Source server name
	SourceServerName *string `json:"sourceServerName,omitempty"`
	// SourceServerPort - READ-ONLY; Source server port number
	SourceServerPort *string `json:"sourceServerPort,omitempty"`
	// SourceUsername - READ-ONLY; Source username
	SourceUsername *string `json:"sourceUsername,omitempty"`
	// TargetServerName - READ-ONLY; Target server name
	TargetServerName *string `json:"targetServerName,omitempty"`
	// TargetUsername - READ-ONLY; Target username
	TargetUsername *string `json:"targetUsername,omitempty"`
	// TargetDbName - READ-ONLY; Target database name
	TargetDbName *string `json:"targetDbName,omitempty"`
	// TargetUsingWinAuth - READ-ONLY; Whether target connection is Windows authentication
	TargetUsingWinAuth *bool `json:"targetUsingWinAuth,omitempty"`
	// SelectedMigrationTables - READ-ONLY; List of tables selected for migration
	SelectedMigrationTables *[]MigrationTableMetadata `json:"selectedMigrationTables,omitempty"`
}

// ProjectProperties project-specific properties
type ProjectProperties struct {
	// SourcePlatform - Source platform for the project. Possible values include: 'ProjectSourcePlatformSQL', 'ProjectSourcePlatformMySQL', 'ProjectSourcePlatformPostgreSQL', 'ProjectSourcePlatformMongoDb', 'ProjectSourcePlatformUnknown'
	SourcePlatform ProjectSourcePlatform `json:"sourcePlatform,omitempty"`
	// TargetPlatform - Target platform for the project. Possible values include: 'ProjectTargetPlatformSQLDB', 'ProjectTargetPlatformSQLMI', 'ProjectTargetPlatformAzureDbForMySQL', 'ProjectTargetPlatformAzureDbForPostgreSQL', 'ProjectTargetPlatformMongoDb', 'ProjectTargetPlatformUnknown'
	TargetPlatform ProjectTargetPlatform `json:"targetPlatform,omitempty"`
	// CreationTime - READ-ONLY; UTC Date and time when project was created
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// SourceConnectionInfo - Information for connecting to source
	SourceConnectionInfo BasicConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Information for connecting to target
	TargetConnectionInfo BasicConnectionInfo `json:"targetConnectionInfo,omitempty"`
	// DatabasesInfo - List of DatabaseInfo
	DatabasesInfo *[]DatabaseInfo `json:"databasesInfo,omitempty"`
	// ProvisioningState - READ-ONLY; The project's provisioning state. Possible values include: 'ProjectProvisioningStateDeleting', 'ProjectProvisioningStateSucceeded'
	ProvisioningState ProjectProvisioningState `json:"provisioningState,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ProjectProperties struct.
func (pp *ProjectProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sourcePlatform":
			if v != nil {
				var sourcePlatform ProjectSourcePlatform
				err = json.Unmarshal(*v, &sourcePlatform)
				if err != nil {
					return err
				}
				pp.SourcePlatform = sourcePlatform
			}
		case "targetPlatform":
			if v != nil {
				var targetPlatform ProjectTargetPlatform
				err = json.Unmarshal(*v, &targetPlatform)
				if err != nil {
					return err
				}
				pp.TargetPlatform = targetPlatform
			}
		case "creationTime":
			if v != nil {
				var creationTime date.Time
				err = json.Unmarshal(*v, &creationTime)
				if err != nil {
					return err
				}
				pp.CreationTime = &creationTime
			}
		case "sourceConnectionInfo":
			if v != nil {
				sourceConnectionInfo, err := unmarshalBasicConnectionInfo(*v)
				if err != nil {
					return err
				}
				pp.SourceConnectionInfo = sourceConnectionInfo
			}
		case "targetConnectionInfo":
			if v != nil {
				targetConnectionInfo, err := unmarshalBasicConnectionInfo(*v)
				if err != nil {
					return err
				}
				pp.TargetConnectionInfo = targetConnectionInfo
			}
		case "databasesInfo":
			if v != nil {
				var databasesInfo []DatabaseInfo
				err = json.Unmarshal(*v, &databasesInfo)
				if err != nil {
					return err
				}
				pp.DatabasesInfo = &databasesInfo
			}
		case "provisioningState":
			if v != nil {
				var provisioningState ProjectProvisioningState
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				pp.ProvisioningState = provisioningState
			}
		}
	}

	return nil
}

// ProjectTask a task resource
type ProjectTask struct {
	autorest.Response `json:"-"`
	// Etag - HTTP strong entity tag value. This is ignored if submitted.
	Etag *string `json:"etag,omitempty"`
	// Properties - Custom task properties
	Properties BasicProjectTaskProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ProjectTask struct.
func (pt *ProjectTask) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pt.Etag = &etag
			}
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicProjectTaskProperties(*v)
				if err != nil {
					return err
				}
				pt.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pt.Type = &typeVar
			}
		}
	}

	return nil
}

// BasicProjectTaskProperties base class for all types of DMS task properties. If task is not supported by current
// client, this object is returned.
type BasicProjectTaskProperties interface {
	AsMigrateSsisTaskProperties() (*MigrateSsisTaskProperties, bool)
	AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool)
	AsValidateOracleAzureDbForPostgreSQLSyncTaskProperties() (*ValidateOracleAzureDbForPostgreSQLSyncTaskProperties, bool)
	AsValidateMongoDbTaskProperties() (*ValidateMongoDbTaskProperties, bool)
	AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool)
	AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool)
	AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool)
	AsMigrateOracleAzureDbForPostgreSQLSyncTaskProperties() (*MigrateOracleAzureDbForPostgreSQLSyncTaskProperties, bool)
	AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool)
	AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool)
	AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool)
	AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool)
	AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool)
	AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool)
	AsMigrateMongoDbTaskProperties() (*MigrateMongoDbTaskProperties, bool)
	AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool)
	AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool)
	AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool)
	AsGetUserTablesPostgreSQLTaskProperties() (*GetUserTablesPostgreSQLTaskProperties, bool)
	AsGetUserTablesOracleTaskProperties() (*GetUserTablesOracleTaskProperties, bool)
	AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool)
	AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool)
	AsConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties, bool)
	AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool)
	AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool)
	AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool)
	AsConnectToSourceOracleSyncTaskProperties() (*ConnectToSourceOracleSyncTaskProperties, bool)
	AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool)
	AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool)
	AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool)
	AsConnectToMongoDbTaskProperties() (*ConnectToMongoDbTaskProperties, bool)
	AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool)
	AsMigrateSchemaSQLServerSQLDbTaskProperties() (*MigrateSchemaSQLServerSQLDbTaskProperties, bool)
	AsCheckOCIDriverTaskProperties() (*CheckOCIDriverTaskProperties, bool)
	AsUploadOCIDriverTaskProperties() (*UploadOCIDriverTaskProperties, bool)
	AsInstallOCIDriverTaskProperties() (*InstallOCIDriverTaskProperties, bool)
	AsProjectTaskProperties() (*ProjectTaskProperties, bool)
}

// ProjectTaskProperties base class for all types of DMS task properties. If task is not supported by current
// client, this object is returned.
type ProjectTaskProperties struct {
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// ClientData - Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string `json:"clientData"`
	// TaskType - Possible values include: 'TaskTypeProjectTaskProperties', 'TaskTypeMigrateSsis', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateOracleAzureDbPostgreSQLSync', 'TaskTypeValidateMongoDb', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigrateOracleAzureDbForPostgreSQLSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeMigrateMongoDb', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesPostgreSQL', 'TaskTypeGetUserTablesOracle', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourceOracleSync', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectMongoDb', 'TaskTypeConnectToSourceMySQL', 'TaskTypeMigrateSchemaSQLServerSQLDb', 'TaskTypeServiceCheckOCI', 'TaskTypeServiceUploadOCI', 'TaskTypeServiceInstallOCI'
	TaskType TaskType `json:"taskType,omitempty"`
}

func unmarshalBasicProjectTaskProperties(body []byte) (BasicProjectTaskProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["taskType"] {
	case string(TaskTypeMigrateSsis):
		var mstp MigrateSsisTaskProperties
		err := json.Unmarshal(body, &mstp)
		return mstp, err
	case string(TaskTypeGetTDECertificatesSQL):
		var gtcstp GetTdeCertificatesSQLTaskProperties
		err := json.Unmarshal(body, &gtcstp)
		return gtcstp, err
	case string(TaskTypeValidateOracleAzureDbPostgreSQLSync):
		var voadfpsstp ValidateOracleAzureDbForPostgreSQLSyncTaskProperties
		err := json.Unmarshal(body, &voadfpsstp)
		return voadfpsstp, err
	case string(TaskTypeValidateMongoDb):
		var vmdtp ValidateMongoDbTaskProperties
		err := json.Unmarshal(body, &vmdtp)
		return vmdtp, err
	case string(TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS):
		var vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties
		err := json.Unmarshal(body, &vmisssmstp)
		return vmisssmstp, err
	case string(TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI):
		var vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties
		err := json.Unmarshal(body, &vmisssmtp)
		return vmisssmtp, err
	case string(TaskTypeValidateMigrationInputSQLServerSQLDbSync):
		var vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties
		err := json.Unmarshal(body, &vmisssdstp)
		return vmisssdstp, err
	case string(TaskTypeMigrateOracleAzureDbForPostgreSQLSync):
		var moadfpsstp MigrateOracleAzureDbForPostgreSQLSyncTaskProperties
		err := json.Unmarshal(body, &moadfpsstp)
		return moadfpsstp, err
	case string(TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync):
		var mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties
		err := json.Unmarshal(body, &mpsadfpsstp)
		return mpsadfpsstp, err
	case string(TaskTypeMigrateMySQLAzureDbForMySQLSync):
		var mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties
		err := json.Unmarshal(body, &mmsadfmsstp)
		return mmsadfmsstp, err
	case string(TaskTypeMigrateSQLServerAzureSQLDbSync):
		var msssdstp MigrateSQLServerSQLDbSyncTaskProperties
		err := json.Unmarshal(body, &msssdstp)
		return msssdstp, err
	case string(TaskTypeMigrateSQLServerSQLDb):
		var msssdtp MigrateSQLServerSQLDbTaskProperties
		err := json.Unmarshal(body, &msssdtp)
		return msssdtp, err
	case string(TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS):
		var msssmstp MigrateSQLServerSQLMISyncTaskProperties
		err := json.Unmarshal(body, &msssmstp)
		return msssmstp, err
	case string(TaskTypeMigrateSQLServerAzureSQLDbMI):
		var msssmtp MigrateSQLServerSQLMITaskProperties
		err := json.Unmarshal(body, &msssmtp)
		return msssmtp, err
	case string(TaskTypeMigrateMongoDb):
		var mmdtp MigrateMongoDbTaskProperties
		err := json.Unmarshal(body, &mmdtp)
		return mmdtp, err
	case string(TaskTypeConnectToTargetAzureDbForMySQL):
		var cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties
		err := json.Unmarshal(body, &cttadfmstp)
		return cttadfmstp, err
	case string(TaskTypeConnectToTargetAzureSQLDbMISyncLRS):
		var cttsmstp ConnectToTargetSQLMISyncTaskProperties
		err := json.Unmarshal(body, &cttsmstp)
		return cttsmstp, err
	case string(TaskTypeConnectToTargetAzureSQLDbMI):
		var cttsmtp ConnectToTargetSQLMITaskProperties
		err := json.Unmarshal(body, &cttsmtp)
		return cttsmtp, err
	case string(TaskTypeGetUserTablesPostgreSQL):
		var gutpstp GetUserTablesPostgreSQLTaskProperties
		err := json.Unmarshal(body, &gutpstp)
		return gutpstp, err
	case string(TaskTypeGetUserTablesOracle):
		var gutotp GetUserTablesOracleTaskProperties
		err := json.Unmarshal(body, &gutotp)
		return gutotp, err
	case string(TaskTypeGetUserTablesAzureSQLDbSync):
		var gutsstp GetUserTablesSQLSyncTaskProperties
		err := json.Unmarshal(body, &gutsstp)
		return gutsstp, err
	case string(TaskTypeGetUserTablesSQL):
		var gutstp GetUserTablesSQLTaskProperties
		err := json.Unmarshal(body, &gutstp)
		return gutstp, err
	case string(TaskTypeConnectToTargetOracleAzureDbForPostgreSQLSync):
		var cttoadfpsstp ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties
		err := json.Unmarshal(body, &cttoadfpsstp)
		return cttoadfpsstp, err
	case string(TaskTypeConnectToTargetAzureDbForPostgreSQLSync):
		var cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties
		err := json.Unmarshal(body, &cttadfpsstp)
		return cttadfpsstp, err
	case string(TaskTypeConnectToTargetSQLDbSync):
		var cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties
		err := json.Unmarshal(body, &cttssdstp)
		return cttssdstp, err
	case string(TaskTypeConnectToTargetSQLDb):
		var cttsdtp ConnectToTargetSQLDbTaskProperties
		err := json.Unmarshal(body, &cttsdtp)
		return cttsdtp, err
	case string(TaskTypeConnectToSourceOracleSync):
		var ctsostp ConnectToSourceOracleSyncTaskProperties
		err := json.Unmarshal(body, &ctsostp)
		return ctsostp, err
	case string(TaskTypeConnectToSourcePostgreSQLSync):
		var ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties
		err := json.Unmarshal(body, &ctspsstp)
		return ctspsstp, err
	case string(TaskTypeConnectToSourceSQLServerSync):
		var ctsssstp ConnectToSourceSQLServerSyncTaskProperties
		err := json.Unmarshal(body, &