// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehendmedical

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opDescribeEntitiesDetectionV2Job = "DescribeEntitiesDetectionV2Job"

// DescribeEntitiesDetectionV2JobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEntitiesDetectionV2Job operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEntitiesDetectionV2Job for more information on using the DescribeEntitiesDetectionV2Job
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEntitiesDetectionV2JobRequest method.
//    req, resp := client.DescribeEntitiesDetectionV2JobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeEntitiesDetectionV2Job
func (c *ComprehendMedical) DescribeEntitiesDetectionV2JobRequest(input *DescribeEntitiesDetectionV2JobInput) (req *request.Request, output *DescribeEntitiesDetectionV2JobOutput) {
	op := &request.Operation{
		Name:       opDescribeEntitiesDetectionV2Job,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEntitiesDetectionV2JobInput{}
	}

	output = &DescribeEntitiesDetectionV2JobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEntitiesDetectionV2Job API operation for AWS Comprehend Medical.
//
// Gets the properties associated with a medical entities detection job. Use
// this operation to get the status of a detection job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation DescribeEntitiesDetectionV2Job for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request that you made is invalid. Check your request to determine why
//   it's invalid and then retry the request.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You have made too many requests within a short period of time. Wait for a
//   short time and then try your request again. Contact customer support for
//   more information about a service limit increase.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource identified by the specified Amazon Resource Name (ARN) was not
//   found. Check the ARN and try your request again.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeEntitiesDetectionV2Job
func (c *ComprehendMedical) DescribeEntitiesDetectionV2Job(input *DescribeEntitiesDetectionV2JobInput) (*DescribeEntitiesDetectionV2JobOutput, error) {
	req, out := c.DescribeEntitiesDetectionV2JobRequest(input)
	return out, req.Send()
}

// DescribeEntitiesDetectionV2JobWithContext is the same as DescribeEntitiesDetectionV2Job with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEntitiesDetectionV2Job for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) DescribeEntitiesDetectionV2JobWithContext(ctx aws.Context, input *DescribeEntitiesDetectionV2JobInput, opts ...request.Option) (*DescribeEntitiesDetectionV2JobOutput, error) {
	req, out := c.DescribeEntitiesDetectionV2JobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePHIDetectionJob = "DescribePHIDetectionJob"

// DescribePHIDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribePHIDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePHIDetectionJob for more information on using the DescribePHIDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePHIDetectionJobRequest method.
//    req, resp := client.DescribePHIDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribePHIDetectionJob
func (c *ComprehendMedical) DescribePHIDetectionJobRequest(input *DescribePHIDetectionJobInput) (req *request.Request, output *DescribePHIDetectionJobOutput) {
	op := &request.Operation{
		Name:       opDescribePHIDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePHIDetectionJobInput{}
	}

	output = &DescribePHIDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePHIDetectionJob API operation for AWS Comprehend Medical.
//
// Gets the properties associated with a protected health information (PHI)
// detection job. Use this operation to get the status of a detection job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation DescribePHIDetectionJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request that you made is invalid. Check your request to determine why
//   it's invalid and then retry the request.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You have made too many requests within a short period of time. Wait for a
//   short time and then try your request again. Contact customer support for
//   more information about a service limit increase.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource identified by the specified Amazon Resource Name (ARN) was not
//   found. Check the ARN and try your request again.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribePHIDetectionJob
func (c *ComprehendMedical) DescribePHIDetectionJob(input *DescribePHIDetectionJobInput) (*DescribePHIDetectionJobOutput, error) {
	req, out := c.DescribePHIDetectionJobRequest(input)
	return out, req.Send()
}

// DescribePHIDetectionJobWithContext is the same as DescribePHIDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePHIDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) DescribePHIDetectionJobWithContext(ctx aws.Context, input *DescribePHIDetectionJobInput, opts ...request.Option) (*DescribePHIDetectionJobOutput, error) {
	req, out := c.DescribePHIDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectEntities = "DetectEntities"

// DetectEntitiesRequest generates a "aws/request.Request" representing the
// client's request for the DetectEntities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectEntities for more information on using the DetectEntities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectEntitiesRequest method.
//    req, resp := client.DetectEntitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectEntities
//
// Deprecated: This operation is deprecated, use DetectEntitiesV2 instead.
func (c *ComprehendMedical) DetectEntitiesRequest(input *DetectEntitiesInput) (req *request.Request, output *DetectEntitiesOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DetectEntities, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDetectEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectEntitiesInput{}
	}

	output = &DetectEntitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectEntities API operation for AWS Comprehend Medical.
//
// The DetectEntities operation is deprecated. You should use the DetectEntitiesV2
// operation instead.
//
// Inspects the clinical text for a variety of medical entities and returns
// specific information about them such as entity category, location, and confidence
// score on that information .
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation DetectEntities for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The Amazon Comprehend Medical service is temporarily unavailable. Please
//   wait and then retry your request.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You have made too many requests within a short period of time. Wait for a
//   short time and then try your request again. Contact customer support for
//   more information about a service limit increase.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request that you made is invalid. Check your request to determine why
//   it's invalid and then retry the request.
//
//   * ErrCodeInvalidEncodingException "InvalidEncodingException"
//   The input text was not in valid UTF-8 character encoding. Check your text
//   then retry your request.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the text you submitted exceeds the size limit. Reduce the size
//   of the text or use a smaller document and then retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectEntities
//
// Deprecated: This operation is deprecated, use DetectEntitiesV2 instead.
func (c *ComprehendMedical) DetectEntities(input *DetectEntitiesInput) (*DetectEntitiesOutput, error) {
	req, out := c.DetectEntitiesRequest(input)
	return out, req.Send()
}

// DetectEntitiesWithContext is the same as DetectEntities with the addition of
// the ability to pass a context and additional request options.
//
// See DetectEntities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: This operation is deprecated, use DetectEntitiesV2 instead.
func (c *ComprehendMedical) DetectEntitiesWithContext(ctx aws.Context, input *DetectEntitiesInput, opts ...request.Option) (*DetectEntitiesOutput, error) {
	req, out := c.DetectEntitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectEntitiesV2 = "DetectEntitiesV2"

// DetectEntitiesV2Request generates a "aws/request.Request" representing the
// client's request for the DetectEntitiesV2 operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectEntitiesV2 for more information on using the DetectEntitiesV2
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectEntitiesV2Request method.
//    req, resp := client.DetectEntitiesV2Request(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectEntitiesV2
func (c *ComprehendMedical) DetectEntitiesV2Request(input *DetectEntitiesV2Input) (req *request.Request, output *DetectEntitiesV2Output) {
	op := &request.Operation{
		Name:       opDetectEntitiesV2,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectEntitiesV2Input{}
	}

	output = &DetectEntitiesV2Output{}
	req = c.newRequest(op, input, output)
	return
}

// DetectEntitiesV2 API operation for AWS Comprehend Medical.
//
// Inspects the clinical text for a variety of medical entities and returns
// specific information about them such as entity category, location, and confidence
// score on that information.
//
// The DetectEntitiesV2 operation replaces the DetectEntities operation. This
// new action uses a different model for determining the entities in your medical
// text and changes the way that some entities are returned in the output. You
// should use the DetectEntitiesV2 operation in all new applications.
//
// The DetectEntitiesV2 operation returns the Acuity and Direction entities
// as attributes instead of types. It does not return the Quality or Quantity
// entities.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation DetectEntitiesV2 for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The Amazon Comprehend Medical service is temporarily unavailable. Please
//   wait and then retry your request.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You have made too many requests within a short period of time. Wait for a
//   short time and then try your request again. Contact customer support for
//   more information about a service limit increase.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request that you made is invalid. Check your request to determine why
//   it's invalid and then retry the request.
//
//   * ErrCodeInvalidEncodingException "InvalidEncodingException"
//   The input text was not in valid UTF-8 character encoding. Check your text
//   then retry your request.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the text you submitted exceeds the size limit. Reduce the size
//   of the text or use a smaller document and then retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectEntitiesV2
func (c *ComprehendMedical) DetectEntitiesV2(input *DetectEntitiesV2Input) (*DetectEntitiesV2Output, error) {
	req, out := c.DetectEntitiesV2Request(input)
	return out, req.Send()
}

// DetectEntitiesV2WithContext is the same as DetectEntitiesV2 with the addition of
// the ability to pass a context and additional request options.
//
// See DetectEntitiesV2 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) DetectEntitiesV2WithContext(ctx aws.Context, input *DetectEntitiesV2Input, opts ...request.Option) (*DetectEntitiesV2Output, error) {
	req, out := c.DetectEntitiesV2Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectPHI = "DetectPHI"

// DetectPHIRequest generates a "aws/request.Request" representing the
// client's request for the DetectPHI operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectPHI for more information on using the DetectPHI
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectPHIRequest method.
//    req, resp := client.DetectPHIRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectPHI
func (c *ComprehendMedical) DetectPHIRequest(input *DetectPHIInput) (req *request.Request, output *DetectPHIOutput) {
	op := &request.Operation{
		Name:       opDetectPHI,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectPHIInput{}
	}

	output = &DetectPHIOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectPHI API operation for AWS Comprehend Medical.
//
// Inspects the clinical text for protected health information (PHI) entities
// and entity category, location, and confidence score on that information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation DetectPHI for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The Amazon Comprehend Medical service is temporarily unavailable. Please
//   wait and then retry your request.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You have made too many requests within a short period of time. Wait for a
//   short time and then try your request again. Contact customer support for
//   more information about a service limit increase.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request that you made is invalid. Check your request to determine why
//   it's invalid and then retry the request.
//
//   * ErrCodeInvalidEncodingException "InvalidEncodingException"
//   The input text was not in valid UTF-8 character encoding. Check your text
//   then retry your request.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the text you submitted exceeds the size limit. Reduce the size
//   of the text or use a smaller document and then retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectPHI
func (c *ComprehendMedical) DetectPHI(input *DetectPHIInput) (*DetectPHIOutput, error) {
	req, out := c.DetectPHIRequest(input)
	return out, req.Send()
}

// DetectPHIWithContext is the same as DetectPHI with the addition of
// the ability to pass a context and additional request options.
//
// See DetectPHI for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) DetectPHIWithContext(ctx aws.Context, input *DetectPHIInput, opts ...request.Option) (*DetectPHIOutput, error) {
	req, out := c.DetectPHIRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEntitiesDetectionV2Jobs = "ListEntitiesDetectionV2Jobs"

// ListEntitiesDetectionV2JobsRequest generates a "aws/request.Request" representing the
// client's request for the ListEntitiesDetectionV2Jobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEntitiesDetectionV2Jobs for more information on using the ListEntitiesDetectionV2Jobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEntitiesDetectionV2JobsRequest method.
//    req, resp := client.ListEntitiesDetectionV2JobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListEntitiesDetectionV2Jobs
func (c *ComprehendMedical) ListEntitiesDetectionV2JobsRequest(input *ListEntitiesDetectionV2JobsInput) (req *request.Request, output *ListEntitiesDetectionV2JobsOutput) {
	op := &request.Operation{
		Name:       opListEntitiesDetectionV2Jobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListEntitiesDetectionV2JobsInput{}
	}

	output = &ListEntitiesDetectionV2JobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEntitiesDetectionV2Jobs API operation for AWS Comprehend Medical.
//
// Gets a list of medical entity detection jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation ListEntitiesDetectionV2Jobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request that you made is invalid. Check your request to determine why
//   it's invalid and then retry the request.
//
//   * ErrCodeValidationException "ValidationException"
//   The filter that you specified for the operation is invalid. Check the filter
//   values that you entered and try your request again.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You have made too many requests within a short period of time. Wait for a
//   short time and then try your request again. Contact customer support for
//   more information about a service limit increase.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListEntitiesDetectionV2Jobs
func (c *ComprehendMedical) ListEntitiesDetectionV2Jobs(input *ListEntitiesDetectionV2JobsInput) (*ListEntitiesDetectionV2JobsOutput, error) {
	req, out := c.ListEntitiesDetectionV2JobsRequest(input)
	return out, req.Send()
}

// ListEntitiesDetectionV2JobsWithContext is the same as ListEntitiesDetectionV2Jobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListEntitiesDetectionV2Jobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) ListEntitiesDetectionV2JobsWithContext(ctx aws.Context, input *ListEntitiesDetectionV2JobsInput, opts ...request.Option) (*ListEntitiesDetectionV2JobsOutput, error) {
	req, out := c.ListEntitiesDetectionV2JobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPHIDetectionJobs = "ListPHIDetectionJobs"

// ListPHIDetectionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListPHIDetectionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPHIDetectionJobs for more information on using the ListPHIDetectionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPHIDetectionJobsRequest method.
//    req, resp := client.ListPHIDetectionJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListPHIDetectionJobs
func (c *ComprehendMedical) ListPHIDetectionJobsRequest(input *ListPHIDetectionJobsInput) (req *request.Request, output *ListPHIDetectionJobsOutput) {
	op := &request.Operation{
		Name:       opListPHIDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListPHIDetectionJobsInput{}
	}

	output = &ListPHIDetectionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPHIDetectionJobs API operation for AWS Comprehend Medical.
//
// Gets a list of protected health information (PHI) detection jobs that you
// have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation ListPHIDetectionJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request that you made is invalid. Check your request to determine why
//   it's invalid and then retry the request.
//
//   * ErrCodeValidationException "ValidationException"
//   The filter that you specified for the operation is invalid. Check the filter
//   values that you entered and try your request again.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You have made too many requests within a short period of time. Wait for a
//   short time and then try your request again. Contact customer support for
//   more information about a service limit increase.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListPHIDetectionJobs
func (c *ComprehendMedical) ListPHIDetectionJobs(input *ListPHIDetectionJobsInput) (*ListPHIDetectionJobsOutput, error) {
	req, out := c.ListPHIDetectionJobsRequest(input)
	return out, req.Send()
}

// ListPHIDetectionJobsWithContext is the same as ListPHIDetectionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListPHIDetectionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) ListPHIDetectionJobsWithContext(ctx aws.Context, input *ListPHIDetectionJobsInput, opts ...request.Option) (*ListPHIDetectionJobsOutput, error) {
	req, out := c.ListPHIDetectionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartEntitiesDetectionV2Job = "StartEntitiesDetectionV2Job"

// StartEntitiesDetectionV2JobRequest generates a "aws/request.Request" representing the
// client's request for the StartEntitiesDetectionV2Job operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartEntitiesDetectionV2Job for more information on using the StartEntitiesDetectionV2Job
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartEntitiesDetectionV2JobRequest method.
//    req, resp := client.StartEntitiesDetectionV2JobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartEntitiesDetectionV2Job
func (c *ComprehendMedical) StartEntitiesDetectionV2JobRequest(input *StartEntitiesDetectionV2JobInput) (req *request.Request, output *StartEntitiesDetectionV2JobOutput) {
	op := &request.Operation{
		Name:       opStartEntitiesDetectionV2Job,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartEntitiesDetectionV2JobInput{}
	}

	output = &StartEntitiesDetectionV2JobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartEntitiesDetectionV2Job API operation for AWS Comprehend Medical.
//
// Starts an asynchronous medical entity detection job for a collection of documents.
// Use the DescribeEntitiesDetectionV2Job operation to track the status of a
// job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation StartEntitiesDetectionV2Job for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request that you made is invalid. Check your request to determine why
//   it's invalid and then retry the request.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You have made too many requests within a short period of time. Wait for a
//   short time and then try your request again. Contact customer support for
//   more information about a service limit increase.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource identified by the specified Amazon Resource Name (ARN) was not
//   found. Check the ARN and try your request again.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartEntitiesDetectionV2Job
func (c *ComprehendMedical) StartEntitiesDetectionV2Job(input *StartEntitiesDetectionV2JobInput) (*StartEntitiesDetectionV2JobOutput, error) {
	req, out := c.StartEntitiesDetectionV2JobRequest(input)
	return out, req.Send()
}

// StartEntitiesDetectionV2JobWithContext is the same as StartEntitiesDetectionV2Job with the addition of
// the ability to pass a context and additional request options.
//
// See StartEntitiesDetectionV2Job for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) StartEntitiesDetectionV2JobWithContext(ctx aws.Context, input *StartEntitiesDetectionV2JobInput, opts ...request.Option) (*StartEntitiesDetectionV2JobOutput, error) {
	req, out := c.StartEntitiesDetectionV2JobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartPHIDetectionJob = "StartPHIDetectionJob"

// StartPHIDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartPHIDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartPHIDetectionJob for more information on using the StartPHIDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartPHIDetectionJobRequest method.
//    req, resp := client.StartPHIDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartPHIDetectionJob
func (c *ComprehendMedical) StartPHIDetectionJobRequest(input *StartPHIDetectionJobInput) (req *request.Request, output *StartPHIDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStartPHIDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartPHIDetectionJobInput{}
	}

	output = &StartPHIDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartPHIDetectionJob API operation for AWS Comprehend Medical.
//
// Starts an asynchronous job to detect protected health information (PHI).
// Use the DescribePHIDetectionJob operation to track the status of a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation StartPHIDetectionJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request that you made is invalid. Check your request to determine why
//   it's invalid and then retry the request.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   You have made too many requests within a short period of time. Wait for a
//   short time and then try your request again. Contact customer support for
//   more information about a service limit increase.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource identified by the specified Amazon Resource Name (ARN) was not
//   found. Check the ARN and try your request again.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartPHIDetectionJob
func (c *ComprehendMedical) StartPHIDetectionJob(input *StartPHIDetectionJobInput) (*StartPHIDetectionJobOutput, error) {
	req, out := c.StartPHIDetectionJobRequest(input)
	return out, req.Send()
}

// StartPHIDetectionJobWithContext is the same as StartPHIDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartPHIDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) StartPHIDetectionJobWithContext(ctx aws.Context, input *StartPHIDetectionJobInput, opts ...request.Option) (*StartPHIDetectionJobOutput, error) {
	req, out := c.StartPHIDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopEntitiesDetectionV2Job = "StopEntitiesDetectionV2Job"

// StopEntitiesDetectionV2JobRequest generates a "aws/request.Request" representing the
// client's request for the StopEntitiesDetectionV2Job operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopEntitiesDetectionV2Job for more information on using the StopEntitiesDetectionV2Job
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopEntitiesDetectionV2JobRequest method.
//    req, resp := client.StopEntitiesDetectionV2JobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopEntitiesDetectionV2Job
func (c *ComprehendMedical) StopEntitiesDetectionV2JobRequest(input *StopEntitiesDetectionV2JobInput) (req *request.Request, output *StopEntitiesDetectionV2JobOutput) {
	op := &request.Operation{
		Name:       opStopEntitiesDetectionV2Job,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopEntitiesDetectionV2JobInput{}
	}

	output = &StopEntitiesDetectionV2JobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopEntitiesDetectionV2Job API operation for AWS Comprehend Medical.
//
// Stops a medical entities detection job in progress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation StopEntitiesDetectionV2Job for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request that you made is invalid. Check your request to determine why
//   it's invalid and then retry the request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource identified by the specified Amazon Resource Name (ARN) was not
//   found. Check the ARN and try your request again.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopEntitiesDetectionV2Job
func (c *ComprehendMedical) StopEntitiesDetectionV2Job(input *StopEntitiesDetectionV2JobInput) (*StopEntitiesDetectionV2JobOutput, error) {
	req, out := c.StopEntitiesDetectionV2JobRequest(input)
	return out, req.Send()
}

// StopEntitiesDetectionV2JobWithContext is the same as StopEntitiesDetectionV2Job with the addition of
// the ability to pass a context and additional request options.
//
// See StopEntitiesDetectionV2Job for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) StopEntitiesDetectionV2JobWithContext(ctx aws.Context, input *StopEntitiesDetectionV2JobInput, opts ...request.Option) (*StopEntitiesDetectionV2JobOutput, error) {
	req, out := c.StopEntitiesDetectionV2JobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopPHIDetectionJob = "StopPHIDetectionJob"

// StopPHIDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StopPHIDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopPHIDetectionJob for more information on using the StopPHIDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopPHIDetectionJobRequest method.
//    req, resp := client.StopPHIDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopPHIDetectionJob
func (c *ComprehendMedical) StopPHIDetectionJobRequest(input *StopPHIDetectionJobInput) (req *request.Request, output *StopPHIDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStopPHIDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopPHIDetectionJobInput{}
	}

	output = &StopPHIDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopPHIDetectionJob API operation for AWS Comprehend Medical.
//
// Stops a protected health information (PHI) detection job in progress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation StopPHIDetectionJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request that you made is invalid. Check your request to determine why
//   it's invalid and then retry the request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource identified by the specified Amazon Resource Name (ARN) was not
//   found. Check the ARN and try your request again.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopPHIDetectionJob
func (c *ComprehendMedical) StopPHIDetectionJob(input *StopPHIDetectionJobInput) (*StopPHIDetectionJobOutput, error) {
	req, out := c.StopPHIDetectionJobRequest(input)
	return out, req.Send()
}

// StopPHIDetectionJobWithContext is the same as StopPHIDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopPHIDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) StopPHIDetectionJobWithContext(ctx aws.Context, input *StopPHIDetectionJobInput, opts ...request.Option) (*StopPHIDetectionJobOutput, error) {
	req, out := c.StopPHIDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An extracted segment of the text that is an attribute of an entity, or otherwise
// related to an entity, such as the dosage of a medication taken. It contains
// information about the attribute such as id, begin and end offset within the
// input text, and the segment of the input text.
type Attribute struct {
	_ struct{} `type:"structure"`

	// The 0-based character offset in the input text that shows where the attribute
	// begins. The offset returns the UTF-8 code point in the string.
	BeginOffset *int64 `type:"integer"`

	// The 0-based character offset in the input text that shows where the attribute
	// ends. The offset returns the UTF-8 code point in the string.
	EndOffset *int64 `type:"integer"`

	// The numeric identifier for this attribute. This is a monotonically increasing
	// id unique within this response rather than a global unique identifier.
	Id *int64 `type:"integer"`

	// The level of confidence that Amazon Comprehend Medical has that this attribute
	// is correctly related to this entity.
	RelationshipScore *float64 `type:"float"`

	// The level of confidence that Amazon Comprehend Medical has that the segment
	// of text is correctly recognized as an attribute.
	Score *float64 `type:"float"`

	// The segment of input text extracted as this attribute.
	Text *string `min:"1" type:"string"`

	// Contextual information for this attribute.
	Traits []*Trait `type:"list"`

	// The type of attribute.
	Type *string `type:"string" enum:"EntitySubType"`
}

// String returns the string representation
func (s Attribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Attribute) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *Attribute) SetBeginOffset(v int64) *Attribute {
	s.BeginOffset = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *Attribute) SetEndOffset(v int64) *Attribute {
	s.EndOffset = &v
	return s
}

// SetId sets the Id field's value.
func (s *Attribute) SetId(v int64) *Attribute {
	s.Id = &v
	return s
}

// SetRelationshipScore sets the RelationshipScore field's value.
func (s *Attribute) SetRelationshipScore(v float64) *Attribute {
	s.RelationshipScore = &v
	return s
}

// SetScore sets the Score field's value.
func (s *Attribute) SetScore(v float64) *Attribute {
	s.Score = &v
	return s
}

// SetText sets the Text field's value.
func (s *Attribute) SetText(v string) *Attribute {
	s.Text = &v
	return s
}

// SetTraits sets the Traits field's value.
func (s *Attribute) SetTraits(v []*Trait) *Attribute {
	s.Traits = v
	return s
}

// SetType sets the Type field's value.
func (s *Attribute) SetType(v string) *Attribute {
	s.Type = &v
	return s
}

// Provides information for filtering a list of detection jobs.
type ComprehendMedicalAsyncJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ComprehendMedicalAsyncJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComprehendMedicalAsyncJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComprehendMedicalAsyncJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComprehendMedicalAsyncJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *ComprehendMedicalAsyncJobFilter) SetJobName(v string) *ComprehendMedicalAsyncJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *ComprehendMedicalAsyncJobFilter) SetJobStatus(v string) *ComprehendMedicalAsyncJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *ComprehendMedicalAsyncJobFilter) SetSubmitTimeAfter(v time.Time) *ComprehendMedicalAsyncJobFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *ComprehendMedicalAsyncJobFilter) SetSubmitTimeBefore(v time.Time) *ComprehendMedicalAsyncJobFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Provides information about a detection job.
type ComprehendMedicalAsyncJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that gives Amazon Comprehend Medical read
	// access to your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time that the detection job completed.
	EndTime *time.Time `type:"timestamp"`

	// The date and time that job metadata is deleted from the server. Output files
	// in your S3 bucket will not be deleted. After the metadata is deleted, the
	// job will no longer appear in the results of the ListEntitiesDetectionV2Job
	// or the ListPHIDetectionJobs operation.
	ExpirationTime *time.Time `type:"timestamp"`

	// The input data configuration that you supplied when you created the detection
	// job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The identifier assigned to the detection job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned to the detection job.
	JobName *string `min:"1" type:"string"`

	// The current status of the detection job. If the status is FAILED, the Message
	// field shows the reason for the failure.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// The AWS Key Management Service key, if any, used to encrypt the output files.
	KMSKey *string `min:"1" type:"string"`

	// The language code of the input documents.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The path to the file that describes the results of a batch job.
	ManifestFilePath *string `min:"1" type:"string"`

	// A description of the status of a job.
	Message *string `type:"string"`

	// The version of the model used to analyze the documents. The version number
	// looks like X.X.X. You can use this information to track the model used for
	// a particular batch of documents.
	ModelVersion *string `type:"string"`

	// The output data configuration that you supplied when you created the detection
	// job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ComprehendMedicalAsyncJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComprehendMedicalAsyncJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetDataAccessRoleArn(v string) *ComprehendMedicalAsyncJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetEndTime(v time.Time) *ComprehendMedicalAsyncJobProperties {
	s.EndTime = &v
	return s
}

// SetExpirationTime sets the ExpirationTime field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetExpirationTime(v time.Time) *ComprehendMedicalAsyncJobProperties {
	s.ExpirationTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetInputDataConfig(v *InputDataConfig) *ComprehendMedicalAsyncJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetJobId(v string) *ComprehendMedicalAsyncJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetJobName(v string) *ComprehendMedicalAsyncJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetJobStatus(v string) *ComprehendMedicalAsyncJobProperties {
	s.JobStatus = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetKMSKey(v string) *ComprehendMedicalAsyncJobProperties {
	s.KMSKey = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetLanguageCode(v string) *ComprehendMedicalAsyncJobProperties {
	s.LanguageCode = &v
	return s
}

// SetManifestFilePath sets the ManifestFilePath field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetManifestFilePath(v string) *ComprehendMedicalAsyncJobProperties {
	s.ManifestFilePath = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetMessage(v string) *ComprehendMedicalAsyncJobProperties {
	s.Message = &v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetModelVersion(v string) *ComprehendMedicalAsyncJobProperties {
	s.ModelVersion = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetOutputDataConfig(v *OutputDataConfig) *ComprehendMedicalAsyncJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetSubmitTime(v time.Time) *ComprehendMedicalAsyncJobProperties {
	s.SubmitTime = &v
	return s
}

type DescribeEntitiesDetectionV2JobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend Medical generated for the job. The
	// StartEntitiesDetectionV2Job operation returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeEntitiesDetectionV2JobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEntitiesDetectionV2JobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEntitiesDetectionV2JobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEntitiesDetectionV2JobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeEntitiesDetectionV2JobInput) SetJobId(v string) *DescribeEntitiesDetectionV2JobInput {
	s.JobId = &v
	return s
}

type DescribeEntitiesDetectionV2JobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a detection job.
	ComprehendMedicalAsyncJobProperties *ComprehendMedicalAsyncJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeEntitiesDetectionV2JobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEntitiesDetectionV2JobOutput) GoString() string {
	return s.String()
}

// SetComprehendMedicalAsyncJobProperties sets the ComprehendMedicalAsyncJobProperties field's value.
func (s *DescribeEntitiesDetectionV2JobOutput) SetComprehendMedicalAsyncJobProperties(v *ComprehendMedicalAsyncJobProperties) *DescribeEntitiesDetectionV2JobOutput {
	s.ComprehendMedicalAsyncJobProperties = v
	return s
}

type DescribePHIDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend Medical generated for the job. The
	// StartPHIDetectionJob operation returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribePHIDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePHIDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePHIDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePHIDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribePHIDetectionJobInput) SetJobId(v string) *DescribePHIDetectionJobInput {
	s.JobId = &v
	return s
}

type DescribePHIDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a detection job.
	ComprehendMedicalAsyncJobProperties *ComprehendMedicalAsyncJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribePHIDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePHIDetectionJobOutput) GoString() string {
	return s.String()
}

// SetComprehendMedicalAsyncJobProperties sets the ComprehendMedicalAsyncJobProperties field's value.
func (s *DescribePHIDetectionJobOutput) SetComprehendMedicalAsyncJobProperties(v *ComprehendMedicalAsyncJobProperties) *DescribePHIDetectionJobOutput {
	s.ComprehendMedicalAsyncJobProperties = v
	return s
}

type DetectEntitiesInput struct {
	_ struct{} `type:"structure"`

	// A UTF-8 text string containing the clinical content being examined for entities.
	// Each string must contain fewer than 20,000 bytes of characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetectEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectEntitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectEntitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectEntitiesInput"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *DetectEntitiesInput) SetText(v string) *DetectEntitiesInput {
	s.Text = &v
	return s
}

type DetectEntitiesOutput struct {
	_ struct{} `type:"structure"`

	// The collection of medical entities extracted from the input text and their
	// associated information. For each entity, the response provides the entity
	// text, the entity category, where the entity text begins and ends, and the
	// level of confidence that Amazon Comprehend Medical has in the detection and
	// analysis. Attributes and traits of the entity are also returned.
	//
	// Entities is a required field
	Entities []*Entity `type:"list" required:"true"`

	// The version of the model used to analyze the documents. The version number
	// looks like X.X.X. You can use this information to track the model used for
	// a particular batch of documents.
	//
	// ModelVersion is a required field
	ModelVersion *string `min:"1" type:"string" required:"true"`

	// If the result of the previous request to DetectEntities was truncated, include
	// the PaginationToken to fetch the next page of entities.
	PaginationToken *string `min:"1" type:"string"`

	// Attributes extracted from the input text that we were unable to relate to
	// an entity.
	UnmappedAttributes []*UnmappedAttribute `type:"list"`
}

// String returns the string representation
func (s DetectEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectEntitiesOutput) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *DetectEntitiesOutput) SetEntities(v []*Entity) *DetectEntitiesOutput {
	s.Entities = v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *DetectEntitiesOutput) SetModelVersion(v string) *DetectEntitiesOutput {
	s.ModelVersion = &v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *DetectEntitiesOutput) SetPaginationToken(v string) *DetectEntitiesOutput {
	s.PaginationToken = &v
	return s
}

// SetUnmappedAttributes sets the UnmappedAttributes field's value.
func (s *DetectEntitiesOutput) SetUnmappedAttributes(v []*UnmappedAttribute) *DetectEntitiesOutput {
	s.UnmappedAttributes = v
	return s
}

type DetectEntitiesV2Input struct {
	_ struct{} `type:"structure"`

	// A UTF-8 string containing the clinical content being examined for entities.
	// Each string must contain fewer than 20,000 bytes of characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetectEntitiesV2Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectEntitiesV2Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectEntitiesV2Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectEntitiesV2Input"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *DetectEntitiesV2Input) SetText(v string) *DetectEntitiesV2Input {
	s.Text = &v
	return s
}

type DetectEntitiesV2Output struct {
	_ struct{} `type:"structure"`

	// The collection of medical entities extracted from the input text and their
	// associated information. For each entity, the response provides the entity
	// text, the entity category, where the entity text begins and ends, and the
	// level of confidence in the detection and analysis. Attributes and traits
	// of the entity are also returned.
	//
	// Entities is a required field
	Entities []*Entity `type:"list" required:"true"`

	// The version of the model used to analyze the documents. The version number
	// looks like X.X.X. You can use this information to track the model used for
	// a particular batch of documents.
	//
	// ModelVersion is a required field
	ModelVersion *string `min:"1" type:"string" required:"true"`

	// If the result to the DetectEntitiesV2 operation was truncated, include the
	// PaginationToken to fetch the next page of entities.
	PaginationToken *string `min:"1" type:"string"`

	// Attributes extracted from the input text that couldn't be related to an entity.
	UnmappedAttributes []*UnmappedAttribute `type:"list"`
}

// String returns the string representation
func (s DetectEntitiesV2Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectEntitiesV2Output) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *DetectEntitiesV2Output) SetEntities(v []*Entity) *DetectEntitiesV2Output {
	s.Entities = v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *DetectEntitiesV2Output) SetModelVersion(v string) *DetectEntitiesV2Output {
	s.ModelVersion = &v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *DetectEntitiesV2Output) SetPaginationToken(v string) *DetectEntitiesV2Output {
	s.PaginationToken = &v
	return s
}

// SetUnmappedAttributes sets the UnmappedAttributes field's value.
func (s *DetectEntitiesV2Output) SetUnmappedAttributes(v []*UnmappedAttribute) *DetectEntitiesV2Output {
	s.UnmappedAttributes = v
	return s
}

type DetectPHIInput struct {
	_ struct{} `type:"structure"`

	// A UTF-8 text string containing the clinical content being examined for PHI
	// entities. Each string must contain fewer than 20,000 bytes of characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetectPHIInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectPHIInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectPHIInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectPHIInput"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *DetectPHIInput) SetText(v string) *DetectPHIInput {
	s.Text = &v
	return s
}

type DetectPHIOutput struct {
	_ struct{} `type:"structure"`

	// The collection of PHI entities extracted from the input text and their associated
	// information. For each entity, the response provides the entity text, the
	// entity category, where the entity text begins and ends, and the level of
	// confidence that Amazon Comprehend Medical has in its detection.
	//
	// Entities is a required field
	Entities []*Entity `type:"list" required:"true"`

	// The version of the model used to analyze the documents. The version number
	// looks like X.X.X. You can use this information to track the model used for
	// a particular batch of documents.
	//
	// ModelVersion is a required field
	ModelVersion *string `min:"1" type:"string" required:"true"`

	// If the result of the previous request to DetectPHI was truncated, include
	// the PaginationToken to fetch the next page of PHI entities.
	PaginationToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DetectPHIOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectPHIOutput) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *DetectPHIOutput) SetEntities(v []*Entity) *DetectPHIOutput {
	s.Entities = v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *DetectPHIOutput) SetModelVersion(v string) *DetectPHIOutput {
	s.ModelVersion = &v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *DetectPHIOutput) SetPaginationToken(v string) *DetectPHIOutput {
	s.PaginationToken = &v
	return s
}

// Provides information about an extracted medical entity.
type Entity struct {
	_ struct{} `type:"structure"`

	// The extracted attributes that relate to this entity.
	Attributes []*Attribute `type:"list"`

	// The 0-based character offset in the input text that shows where the entity
	// begins. The offset returns the UTF-8 code point in the string.
	BeginOffset *int64 `type:"integer"`

	// The category of the entity.
	Category *string `type:"string" enum:"EntityType"`

	// The 0-based character offset in the input text that shows where the entity
	// ends. The offset returns the UTF-8 code point in the string.
	EndOffset *int64 `type:"integer"`

	// The numeric identifier for the entity. This is a monotonically increasing
	// id unique within this response rather than a global unique identifier.
	Id *int64 `type:"integer"`

	// The level of confidence that Amazon Comprehend Medical has in the accuracy
	// of the detection.
	Score *float64 `type:"float"`

	// The segment of input text extracted as this entity.
	Text *string `min:"1" type:"string"`

	// Contextual information for the entity
	Traits []*Trait `type:"list"`

	// Describes the specific type of entity with category of entities.
	Type *string `type:"string" enum:"EntitySubType"`
}

// String returns the string representation
func (s Entity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Entity) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *Entity) SetAttributes(v []*Attribute) *Entity {
	s.Attributes = v
	return s
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *Entity) SetBeginOffset(v int64) *Entity {
	s.BeginOffset = &v
	return s
}

// SetCategory sets the Category field's value.
func (s *Entity) SetCategory(v string) *Entity {
	s.Category = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *Entity) SetEndOffset(v int64) *Entity {
	s.EndOffset = &v
	return s
}

// SetId sets the Id field's value.
func (s *Entity) SetId(v int64) *Entity {
	s.Id = &v
	return s
}

// SetScore sets the Score field's value.
func (s *Entity) SetScore(v float64) *Entity {
	s.Score = &v
	return s
}

// SetText sets the Text field's value.
func (s *Entity) SetText(v string) *Entity {
	s.Text = &v
	return s
}

// SetTraits sets the Traits field's value.
func (s *Entity) SetTraits(v []*Trait) *Entity {
	s.Traits = v
	return s
}

// SetType sets the Type field's value.
func (s *Entity) SetType(v string) *Entity {
	s.Type = &v
	return s
}

// The input properties for an entities detection job
type InputDataConfig struct {
	_ struct{} `type:"structure"`

	// The URI of the S3 bucket that contains the input data. The bucket must be
	// in the same region as the API endpoint that you are calling.
	//
	// Each file in the document collection must be less than 40 KB. You can store
	// a maximum of 30 GB in the bucket.
	//
	// S3Bucket is a required field
	S3Bucket *string `min:"3" type:"string" required:"true"`

	// The path to the input data files in the S3 bucket.
	S3Key *string `type:"string"`
}

// String returns the string representation
func (s InputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputDataConfig"}
	if s.S3Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Bucket"))
	}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *InputDataConfig) SetS3Bucket(v string) *InputDataConfig {
	s.S3Bucket = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *InputDataConfig) SetS3Key(v string) *InputDataConfig {
	s.S3Key = &v
	return s
}

type ListEntitiesDetectionV2JobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs based on their names,
	// status, or the date and time that they were submitted. You can only set one
	// filter at a time.
	Filter *ComprehendMedicalAsyncJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListEntitiesDetectionV2JobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEntitiesDetectionV2JobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEntitiesDetectionV2JobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEntitiesDetectionV2JobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListEntitiesDetectionV2JobsInput) SetFilter(v *ComprehendMedicalAsyncJobFilter) *ListEntitiesDetectionV2JobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEntitiesDetectionV2JobsInput) SetMaxResults(v int64) *ListEntitiesDetectionV2JobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntitiesDetectionV2JobsInput) SetNextToken(v string) *ListEntitiesDetectionV2JobsInput {
	s.NextToken = &v
	return s
}

type ListEntitiesDetectionV2JobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job returned.
	ComprehendMedicalAsyncJobPropertiesList []*ComprehendMedicalAsyncJobProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListEntitiesDetectionV2JobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEntitiesDetectionV2JobsOutput) GoString() string {
	return s.String()
}

// SetComprehendMedicalAsyncJobPropertiesList sets the ComprehendMedicalAsyncJobPropertiesList field's value.
func (s *ListEntitiesDetectionV2JobsOutput) SetComprehendMedicalAsyncJobPropertiesList(v []*ComprehendMedicalAsyncJobProperties) *ListEntitiesDetectionV2JobsOutput {
	s.ComprehendMedicalAsyncJobPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntitiesDetectionV2JobsOutput) SetNextToken(v string) *ListEntitiesDetectionV2JobsOutput {
	s.NextToken = &v
	return s
}

type ListPHIDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs based on their names,
	// status, or the date and time that they were submitted. You can only set one
	// filter at a time.
	Filter *ComprehendMedicalAsyncJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListPHIDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPHIDetectionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPHIDetectionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPHIDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListPHIDetectionJobsInput) SetFilter(v *ComprehendMedicalAsyncJobFilter) *ListPHIDetectionJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPHIDetectionJobsInput) SetMaxResults(v int64) *ListPHIDetectionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPHIDetectionJobsInput) SetNextToken(v string) *ListPHIDetectionJobsInput {
	s.NextToken = &v
	return s
}

type ListPHIDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job returned.
	ComprehendMedicalAsyncJobPropertiesList []*ComprehendMedicalAsyncJobProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListPHIDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPHIDetectionJobsOutput) GoString() string {
	return s.String()
}

// SetComprehendMedicalAsyncJobPropertiesList sets the ComprehendMedicalAsyncJobPropertiesList field's value.
func (s *ListPHIDetectionJobsOutput) SetComprehendMedicalAsyncJobPropertiesList(v []*ComprehendMedicalAsyncJobProperties) *ListPHIDetectionJobsOutput {
	s.ComprehendMedicalAsyncJobPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPHIDetectionJobsOutput) SetNextToken(v string) *ListPHIDetectionJobsOutput {
	s.NextToken = &v
	return s
}

// The output properties for a detection job.
type OutputDataConfig struct {
	_ struct{} `type:"structure"`

	// When you use the OutputDataConfig object with asynchronous operations, you
	// specify the Amazon S3 location where you want to write the output data. The
	// URI must be in the same region as the API endpoint that you are calling.
	// The location is used as the prefix for the actual location of the output.
	//
	// S3Bucket is a required field
	S3Bucket *string `min:"3" type:"string" required:"true"`

	// The path to the output data files in the S3 bucket. Amazon Comprehend Medical
	// creates an output directory using the job ID so that the output from one
	// job does not overwrite the output of another.
	S3Key *string `type:"string"`
}

// String returns the string representation
func (s OutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputDataConfig"}
	if s.S3Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Bucket"))
	}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *OutputDataConfig) SetS3Bucket(v string) *OutputDataConfig {
	s.S3Bucket = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *OutputDataConfig) SetS3Key(v string) *OutputDataConfig {
	s.S3Key = &v
	return s
}

type StartEntitiesDetectionV2JobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend Medical generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that grants Amazon Comprehend Medical read access to your input
	// data. For more information, see Role-Based Permissions Required for Asynchronous
	// Operations (https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions-med.html#auth-role-permissions-med).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// An AWS Key Management Service key to encrypt your output files. If you do
	// not specify a key, the files are written in plain text.
	KMSKey *string `min:"1" type:"string"`

	// The language of the input documents. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Specifies where to send the output files.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s StartEntitiesDetectionV2JobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartEntitiesDetectionV2JobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartEntitiesDetectionV2JobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartEntitiesDetectionV2JobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.KMSKey != nil && len(*s.KMSKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KMSKey", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartEntitiesDetectionV2JobInput) SetClientRequestToken(v string) *StartEntitiesDetectionV2JobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartEntitiesDetectionV2JobInput) SetDataAccessRoleArn(v string) *StartEntitiesDetectionV2JobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartEntitiesDetectionV2JobInput) SetInputDataConfig(v *InputDataConfig) *StartEntitiesDetectionV2JobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartEntitiesDetectionV2JobInput) SetJobName(v string) *StartEntitiesDetectionV2JobInput {
	s.JobName = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *StartEntitiesDetectionV2JobInput) SetKMSKey(v string) *StartEntitiesDetectionV2JobInput {
	s.KMSKey = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartEntitiesDetectionV2JobInput) SetLanguageCode(v string) *StartEntitiesDetectionV2JobInput {
	s.LanguageCode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartEntitiesDetectionV2JobInput) SetOutputDataConfig(v *OutputDataConfig) *StartEntitiesDetectionV2JobInput {
	s.OutputDataConfig = v
	return s
}

type StartEntitiesDetectionV2JobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of a job, use this
	// identifier with the DescribeEntitiesDetectionV2Job operation.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartEntitiesDetectionV2JobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartEntitiesDetectionV2JobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartEntitiesDetectionV2JobOutput) SetJobId(v string) *StartEntitiesDetectionV2JobOutput {
	s.JobId = &v
	return s
}

type StartPHIDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend Medical generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that grants Amazon Comprehend Medical read access to your input
	// data. For more information, see Role-Based Permissions Required for Asynchronous
	// Operations (https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions-med.html#auth-role-permissions-med).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// An AWS Key Management Service key to encrypt your output files. If you do
	// not specify a key, the files are written in plain text.
	KMSKey *string `min:"1" type:"string"`

	// The language of the input documents. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Specifies where to send the output files.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s StartPHIDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartPHIDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartPHIDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartPHIDetectionJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.KMSKey != nil && len(*s.KMSKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KMSKey", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartPHIDetectionJobInput) SetClientRequestToken(v string) *StartPHIDetectionJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartPHIDetectionJobInput) SetDataAccessRoleArn(v string) *StartPHIDetectionJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartPHIDetectionJobInput) SetInputDataConfig(v *InputDataConfig) *StartPHIDetectionJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartPHIDetectionJobInput) SetJobName(v string) *StartPHIDetectionJobInput {
	s.JobName = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *StartPHIDetectionJobInput) SetKMSKey(v string) *StartPHIDetectionJobInput {
	s.KMSKey = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartPHIDetectionJobInput) SetLanguageCode(v string) *StartPHIDetectionJobInput {
	s.LanguageCode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartPHIDetectionJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartPHIDetectionJobInput {
	s.OutputDataConfig = v
	return s
}

type StartPHIDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of a job, use this
	// identifier with the DescribePHIDetectionJob operation.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartPHIDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartPHIDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartPHIDetectionJobOutput) SetJobId(v string) *StartPHIDetectionJobOutput {
	s.JobId = &v
	return s
}

type StopEntitiesDetectionV2JobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the medical entities job to stop.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopEntitiesDetectionV2JobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopEntitiesDetectionV2JobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopEntitiesDetectionV2JobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopEntitiesDetectionV2JobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopEntitiesDetectionV2JobInput) SetJobId(v string) *StopEntitiesDetectionV2JobInput {
	s.JobId = &v
	return s
}

type StopEntitiesDetectionV2JobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the medical entities detection job that was stopped.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StopEntitiesDetectionV2JobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopEntitiesDetectionV2JobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopEntitiesDetectionV2JobOutput) SetJobId(v string) *StopEntitiesDetectionV2JobOutput {
	s.JobId = &v
	return s
}

type StopPHIDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the PHI detection job to stop.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopPHIDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopPHIDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopPHIDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopPHIDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopPHIDetectionJobInput) SetJobId(v string) *StopPHIDetectionJobInput {
	s.JobId = &v
	return s
}

type StopPHIDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the PHI detection job that was stopped.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StopPHIDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopPHIDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopPHIDetectionJobOutput) SetJobId(v string) *StopPHIDetectionJobOutput {
	s.JobId = &v
	return s
}

// Provides contextual information about the extracted entity.
type Trait struct {
	_ struct{} `type:"structure"`

	// Provides a name or contextual description about the trait.
	Name *string `type:"string" enum:"AttributeName"`

	// The level of confidence that Amazon Comprehend Medical has in the accuracy
	// of this trait.
	Score *float64 `type:"float"`
}

// String returns the string representation
func (s Trait) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Trait) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Trait) SetName(v string) *Trait {
	s.Name = &v
	return s
}

// SetScore sets the Score field's value.
func (s *Trait) SetScore(v float64) *Trait {
	s.Score = &v
	return s
}

// An attribute that we extracted, but were unable to relate to an entity.
type UnmappedAttribute struct {
	_ struct{} `type:"structure"`

	// The specific attribute that has been extracted but not mapped to an entity.
	Attribute *Attribute `type:"structure"`

	// The type of the attribute, could be one of the following values: "MEDICATION",
	// "MEDICAL_CONDITION", "ANATOMY", "TEST_AND_TREATMENT_PROCEDURE" or "PROTECTED_HEALTH_INFORMATION".
	Type *string `type:"string" enum:"EntityType"`
}

// String returns the string representation
func (s UnmappedAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnmappedAttribute) GoString() string {
	return s.String()
}

// SetAttribute sets the Attribute field's value.
func (s *UnmappedAttribute) SetAttribute(v *Attribute) *UnmappedAttribute {
	s.Attribute = v
	return s
}

// SetType sets the Type field's value.
func (s *UnmappedAttribute) SetType(v string) *UnmappedAttribute {
	s.Type = &v
	return s
}

const (
	// AttributeNameSign is a AttributeName enum value
	AttributeNameSign = "SIGN"

	// AttributeNameSymptom is a AttributeName enum value
	AttributeNameSymptom = "SYMPTOM"

	// AttributeNameDiagnosis is a AttributeName enum value
	AttributeNameDiagnosis = "DIAGNOSIS"

	// AttributeNameNegation is a AttributeName enum value
	AttributeNameNegation = "NEGATION"
)

const (
	// EntitySubTypeName is a EntitySubType enum value
	EntitySubTypeName = "NAME"

	// EntitySubTypeDosage is a EntitySubType enum value
	EntitySubTypeDosage = "DOSAGE"

	// EntitySubTypeRouteOrMode is a EntitySubType enum value
	EntitySubTypeRouteOrMode = "ROUTE_OR_MODE"

	// EntitySubTypeForm is a EntitySubType enum value
	EntitySubTypeForm = "FORM"

	// EntitySubTypeFrequency is a EntitySubType enum value
	EntitySubTypeFrequency = "FREQUENCY"

	// EntitySubTypeDuration is a EntitySubType enum value
	EntitySubTypeDuration = "DURATION"

	// EntitySubTypeGenericName is a EntitySubType enum value
	EntitySubTypeGenericName = "GENERIC_NAME"

	// EntitySubTypeBrandName is a EntitySubType enum value
	EntitySubTypeBrandName = "BRAND_NAME"

	// EntitySubTypeStrength is a EntitySubType enum value
	EntitySubTypeStrength = "STRENGTH"

	// EntitySubTypeRate is a EntitySubType enum value
	EntitySubTypeRate = "RATE"

	// EntitySubTypeAcuity is a EntitySubType enum value
	EntitySubTypeAcuity = "ACUITY"

	// EntitySubTypeTestName is a EntitySubType enum value
	EntitySubTypeTestName = "TEST_NAME"

	// EntitySubTypeTestValue is a EntitySubType enum value
	EntitySubTypeTestValue = "TEST_VALUE"

	// EntitySubTypeTestUnits is a EntitySubType enum value
	EntitySubTypeTestUnits = "TEST_UNITS"

	// EntitySubTypeProcedureName is a EntitySubType enum value
	EntitySubTypeProcedureName = "PROCEDURE_NAME"

	// EntitySubTypeTreatmentName is a EntitySubType enum value
	EntitySubTypeTreatmentName = "TREATMENT_NAME"

	// EntitySubTypeDate is a EntitySubType enum value
	EntitySubTypeDate = "DATE"

	// EntitySubTypeAge is a EntitySubType enum value
	EntitySubTypeAge = "AGE"

	// EntitySubTypeContactPoint is a EntitySubType enum value
	EntitySubTypeContactPoint = "CONTACT_POINT"

	// EntitySubTypeEmail is a EntitySubType enum value
	EntitySubTypeEmail = "EMAIL"

	// EntitySubTypeIdentifier is a EntitySubType enum value
	EntitySubTypeIdentifier = "IDENTIFIER"

	// EntitySubTypeUrl is a EntitySubType enum value
	EntitySubTypeUrl = "URL"

	// EntitySubTypeAddress is a EntitySubType enum value
	EntitySubTypeAddress = "ADDRESS"

	// EntitySubTypeProfession is a EntitySubType enum value
	EntitySubTypeProfession = "PROFESSION"

	// EntitySubTypeSystemOrganSite is a EntitySubType enum value
	EntitySubTypeSystemOrganSite = "SYSTEM_ORGAN_SITE"

	// EntitySubTypeDirection is a EntitySubType enum value
	EntitySubTypeDirection = "DIRECTION"

	// EntitySubTypeQuality is a EntitySubType enum value
	EntitySubTypeQuality = "QUALITY"

	// EntitySubTypeQuantity is a EntitySubType enum value
	EntitySubTypeQuantity = "QUANTITY"
)

const (
	// EntityTypeMedication is a EntityType enum value
	EntityTypeMedication = "MEDICATION"

	// EntityTypeMedicalCondition is a EntityType enum value
	EntityTypeMedicalCondition = "MEDICAL_CONDITION"

	// EntityTypeProtectedHealthInformation is a EntityType enum value
	EntityTypeProtectedHealthInformation = "PROTECTED_HEALTH_INFORMATION"

	// EntityTypeTestTreatmentProcedure is a EntityType enum value
	EntityTypeTestTreatmentProcedure = "TEST_TREATMENT_PROCEDURE"

	// EntityTypeAnatomy is a EntityType enum value
	EntityTypeAnatomy = "ANATOMY"
)

const (
	// JobStatusSubmitted is a JobStatus enum value
	JobStatusSubmitted = "SUBMITTED"

	// JobStatusInProgress is a JobStatus enum value
	JobStatusInProgress = "IN_PROGRESS"

	// JobStatusCompleted is a JobStatus enum value
	JobStatusCompleted = "COMPLETED"

	// JobStatusPartialSuccess is a JobStatus enum value
	JobStatusPartialSuccess = "PARTIAL_SUCCESS"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "FAILED"

	// JobStatusStopRequested is a JobStatus enum value
	JobStatusStopRequested = "STOP_REQUESTED"

	// JobStatusStopped is a JobStatus enum value
	JobStatusStopped = "STOPPED"
)

const (
	// LanguageCodeEn is a LanguageCode enum value
	LanguageCodeEn = "en"
)
