// Copyright 2019 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package policytroubleshooter provides access to the Policy Troubleshooter API.
//
// For product documentation, see: https://cloud.google.com/iam/
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/policytroubleshooter/v1beta"
//   ...
//   ctx := context.Background()
//   policytroubleshooterService, err := policytroubleshooter.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   policytroubleshooterService, err := policytroubleshooter.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   policytroubleshooterService, err := policytroubleshooter.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package policytroubleshooter // import "google.golang.org/api/policytroubleshooter/v1beta"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled

const apiId = "policytroubleshooter:v1beta"
const apiName = "policytroubleshooter"
const apiVersion = "v1beta"
const basePath = "https://policytroubleshooter.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// View and manage your data across Google Cloud Platform services
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Iam = NewIamService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Iam *IamService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewIamService(s *Service) *IamService {
	rs := &IamService{s: s}
	return rs
}

type IamService struct {
	s *Service
}

// GoogleCloudPolicytroubleshooterV1betaAccessTuple: AccessTuple defines
// information required for checking an access attempt.
// In other words, this is the tuple given to `CheckAccess`.
type GoogleCloudPolicytroubleshooterV1betaAccessTuple struct {
	// FullResourceName: Required. A full resource name according
	// to
	// https://cloud.google.com/apis/design/resource_names. This is the
	// full
	// resource name of the resource that access is checked against.
	FullResourceName string `json:"fullResourceName,omitempty"`

	// Permission: Required. The Cloud IAM permission under which defines
	// the kind of access
	// being explained. Example: "resourcemanager.projects.get" would
	// explain
	// if and why the principal has the resourcemanager.projects.get
	// permission
	// on the resource specified in full_resource_name declared in this
	// structure.
	// See https://cloud.google.com/iam/docs/testing-permissions
	Permission string `json:"permission,omitempty"`

	// Principal: Required. The principal on behalf of who the access is
	// explained for.
	// The format is one of the principal's email addresses associated
	// with
	// its gaia account. It must be an account that can appear as an
	// actor.
	// For example groups are not supported. Currently, service accounts,
	// users
	// are supported.
	Principal string `json:"principal,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FullResourceName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FullResourceName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPolicytroubleshooterV1betaAccessTuple) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterV1betaAccessTuple
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterV1betaBindingExplanation: Binding
// Explanation.
type GoogleCloudPolicytroubleshooterV1betaBindingExplanation struct {
	// Access: REQUIRED: Access decision for this binding.
	//
	// Possible values:
	//   "ACCESS_STATE_UNSPECIFIED" - Reserved
	//   "GRANTED" - The access is granted due to one or multiple bindings
	// found.
	//   "NOT_GRANTED" - The access is not granted by the policy.
	//   "UNKNOWN_CONDITIONAL" - At least one binding was found but it is
	// conditional. undecided,
	// undetermined ,uncertain, open, tentative, contingent
	//   "UNKNOWN_INFO_DENIED" - Indicating that lack of access to the
	// underlying information
	// causes the result to be undetermined.
	// This can be due to
	//
	// 1) The caller has no access to the policy. In this case
	// ExplainedPolicy
	//    will have not policy set.
	//
	// 2) The caller has no access to some of the items referenced in the
	// policy.
	//    In this case the policy in ExplainedPolicy will be set but the
	//    explanations field will contain at least one inconclusive element.
	Access string `json:"access,omitempty"`

	// Condition: The condition which needs to be satisfied in order for
	// this
	// binding to grant the role to the principal.
	// See https://cloud.google.com/iam/docs/conditions-base
	Condition *GoogleTypeExpr `json:"condition,omitempty"`

	// Memberships: For each member in the binding, provides
	// information
	// whether or not the principal from the request is included
	// in the member by which the CheckResult is keyed.
	// May indicate that the caller has no access to this
	// information.
	// example key: 'group:cloud-iam-assist-eng@google.com'
	// example value '{NOT_GRANTED, HIGH}
	Memberships map[string]GoogleCloudPolicytroubleshooterV1betaBindingExplanationAnnotatedMembership `json:"memberships,omitempty"`

	// Relevance: Bubbles up role_permission level relavance to
	// BindingExplanation object.
	// If role permission is NORMAL, then binding relevance is NORMAL.
	// If role permission is HIGH, then binding relevance is HIGH.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Default value, presence of this
	// should be error.
	//   "NORMAL" - Fields annotated with this value contribute equally to
	// evaluation
	// result. In other words the fields are NOT specially important. This
	// is a
	// superset of fields annotated as HIGH.
	//   "HIGH" - Fields annotated with this are more important than the
	// fields
	// annotated by NORMAL. They are used for annotating fields which on
	// potential
	// modification can alter the overall access result.
	Relevance string `json:"relevance,omitempty"`

	// Role: The role that this binding grants in the policy.
	// for example "roles/compute.serviceAgent"
	Role string `json:"role,omitempty"`

	// RolePermission: Whether the role of this binding contains the checked
	// permission
	//
	// Possible values:
	//   "ROLE_PERMISSION_UNSPECIFIED" - Reserved
	//   "ROLE_PERMISSION_INCLUDED" - Permission is included in the role.
	//   "ROLE_PERMISSION_NOT_INCLUDED" - Permission is included in the
	// role.
	//   "ROLE_PERMISSION_UNKNOWN_INFO_DENIED" - Calling principal has no
	// access to the role permission relation.
	RolePermission string `json:"rolePermission,omitempty"`

	// RolePermissionRelevance: The relevance of this permission with
	// respect to the BindingExplanation.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Default value, presence of this
	// should be error.
	//   "NORMAL" - Fields annotated with this value contribute equally to
	// evaluation
	// result. In other words the fields are NOT specially important. This
	// is a
	// superset of fields annotated as HIGH.
	//   "HIGH" - Fields annotated with this are more important than the
	// fields
	// annotated by NORMAL. They are used for annotating fields which on
	// potential
	// modification can alter the overall access result.
	RolePermissionRelevance string `json:"rolePermissionRelevance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Access") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Access") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPolicytroubleshooterV1betaBindingExplanation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterV1betaBindingExplanation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterV1betaBindingExplanationAnnotatedMember
// ship: Encapsulated membership and the relevance of that membership
// with respect
// to BindingExplanation.
type GoogleCloudPolicytroubleshooterV1betaBindingExplanationAnnotatedMembership struct {
	// Membership: Membership status.
	//
	// Possible values:
	//   "MEMBERSHIP_UNSPECIFIED" - Reserved.
	//   "MEMBERSHIP_INCLUDED" - Member is included in group/domain/allUsers
	// or is a direct match.
	//   "MEMBERSHIP_NOT_INCLUDED" - Member is not included in
	// group/domain/allUsers nor is a direct match.
	//   "MEMBERSHIP_UNKNOWN_INFO_DENIED" - Calling principal has no access
	// to the membership relation.
	//   "MEMBERSHIP_UNKNOWN_UNSUPPORTED" - This member type is currently
	// not supported.
	Membership string `json:"membership,omitempty"`

	// Relevance: Relevance of this membership with respect to
	// BindingExplanation.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Default value, presence of this
	// should be error.
	//   "NORMAL" - Fields annotated with this value contribute equally to
	// evaluation
	// result. In other words the fields are NOT specially important. This
	// is a
	// superset of fields annotated as HIGH.
	//   "HIGH" - Fields annotated with this are more important than the
	// fields
	// annotated by NORMAL. They are used for annotating fields which on
	// potential
	// modification can alter the overall access result.
	Relevance string `json:"relevance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Membership") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Membership") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPolicytroubleshooterV1betaBindingExplanationAnnotatedMembership) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterV1betaBindingExplanationAnnotatedMembership
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterV1betaExplainedPolicy: An explained
// IAM policy combines the raw policy in the context
// of the resource which it is attached to along with
// detailed
// evaluation on the evaluation parameters provided through the request.
type GoogleCloudPolicytroubleshooterV1betaExplainedPolicy struct {
	// Access: Access decision for this section of the resource's effective
	// policy.
	//
	// Possible values:
	//   "ACCESS_STATE_UNSPECIFIED" - Reserved
	//   "GRANTED" - The access is granted due to one or multiple bindings
	// found.
	//   "NOT_GRANTED" - The access is not granted by the policy.
	//   "UNKNOWN_CONDITIONAL" - At least one binding was found but it is
	// conditional. undecided,
	// undetermined ,uncertain, open, tentative, contingent
	//   "UNKNOWN_INFO_DENIED" - Indicating that lack of access to the
	// underlying information
	// causes the result to be undetermined.
	// This can be due to
	//
	// 1) The caller has no access to the policy. In this case
	// ExplainedPolicy
	//    will have not policy set.
	//
	// 2) The caller has no access to some of the items referenced in the
	// policy.
	//    In this case the policy in ExplainedPolicy will be set but the
	//    explanations field will contain at least one inconclusive element.
	Access string `json:"access,omitempty"`

	// BindingExplanations: Detailed binding evaluation explanations provide
	// information
	// about how each binding contributes to the principal's
	// access or the lack thereof.
	BindingExplanations []*GoogleCloudPolicytroubleshooterV1betaBindingExplanation `json:"bindingExplanations,omitempty"`

	// FullResourceName: Resource that this section of the effective policy
	// attaches to.
	FullResourceName string `json:"fullResourceName,omitempty"`

	// Policy: The IAM policy attached to the resource.
	Policy *GoogleIamV1Policy `json:"policy,omitempty"`

	// Relevance: Relevance of this Policy.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Default value, presence of this
	// should be error.
	//   "NORMAL" - Fields annotated with this value contribute equally to
	// evaluation
	// result. In other words the fields are NOT specially important. This
	// is a
	// superset of fields annotated as HIGH.
	//   "HIGH" - Fields annotated with this are more important than the
	// fields
	// annotated by NORMAL. They are used for annotating fields which on
	// potential
	// modification can alter the overall access result.
	Relevance string `json:"relevance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Access") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Access") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPolicytroubleshooterV1betaExplainedPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterV1betaExplainedPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyRequest:
// TroubleshootIamPolicyRequest is used in TroubleshootIamPolicy
type GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyRequest struct {
	// AccessTuple: Collection of attributes for example user, permission,
	// resource that define
	// troubleshooter's input.
	AccessTuple *GoogleCloudPolicytroubleshooterV1betaAccessTuple `json:"accessTuple,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessTuple") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessTuple") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyResponse:
// TroubleshootIamPolicyResponse is used in TroubleshootIamPolicy.
type GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyResponse struct {
	// Access: Reflects whether the probed access was granted, denied
	// or ultimately could not be decided from the caller's point of view.
	//
	// Possible values:
	//   "ACCESS_STATE_UNSPECIFIED" - Reserved
	//   "GRANTED" - The access is granted due to one or multiple bindings
	// found.
	//   "NOT_GRANTED" - The access is not granted by the policy.
	//   "UNKNOWN_CONDITIONAL" - At least one binding was found but it is
	// conditional. undecided,
	// undetermined ,uncertain, open, tentative, contingent
	//   "UNKNOWN_INFO_DENIED" - Indicating that lack of access to the
	// underlying information
	// causes the result to be undetermined.
	// This can be due to
	//
	// 1) The caller has no access to the policy. In this case
	// ExplainedPolicy
	//    will have not policy set.
	//
	// 2) The caller has no access to some of the items referenced in the
	// policy.
	//    In this case the policy in ExplainedPolicy will be set but the
	//    explanations field will contain at least one inconclusive element.
	Access string `json:"access,omitempty"`

	// ExplainedPolicies: List of explained policies.
	// Each explanation corresponds to one policy along the ancestry path.
	ExplainedPolicies []*GoogleCloudPolicytroubleshooterV1betaExplainedPolicy `json:"explainedPolicies,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Access") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Access") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIamV1AuditConfig: Specifies the audit configuration for a
// service.
// The configuration determines which permission types are logged, and
// what
// identities, if any, are exempted from logging.
// An AuditConfig must have one or more AuditLogConfigs.
//
// If there are AuditConfigs for both `allServices` and a specific
// service,
// the union of the two AuditConfigs is used for that service: the
// log_types
// specified in each AuditConfig are enabled, and the exempted_members
// in each
// AuditLogConfig are exempted.
//
// Example Policy with multiple AuditConfigs:
//
//     {
//       "audit_configs": [
//         {
//           "service": "allServices"
//           "audit_log_configs": [
//             {
//               "log_type": "DATA_READ",
//               "exempted_members": [
//                 "user:jose@example.com"
//               ]
//             },
//             {
//               "log_type": "DATA_WRITE",
//             },
//             {
//               "log_type": "ADMIN_READ",
//             }
//           ]
//         },
//         {
//           "service": "sampleservice.googleapis.com"
//           "audit_log_configs": [
//             {
//               "log_type": "DATA_READ",
//             },
//             {
//               "log_type": "DATA_WRITE",
//               "exempted_members": [
//                 "user:aliya@example.com"
//               ]
//             }
//           ]
//         }
//       ]
//     }
//
// For sampleservice, this policy enables DATA_READ, DATA_WRITE and
// ADMIN_READ
// logging. It also exempts jose@example.com from DATA_READ logging,
// and
// aliya@example.com from DATA_WRITE logging.
type GoogleIamV1AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of
	// permission.
	AuditLogConfigs []*GoogleIamV1AuditLogConfig `json:"auditLogConfigs,omitempty"`

	// Service: Specifies a service that will be enabled for audit
	// logging.
	// For example, `storage.googleapis.com`,
	// `cloudsql.googleapis.com`.
	// `allServices` is a special value that covers all services.
	Service string `json:"service,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuditLogConfigs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1AuditConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIamV1AuditLogConfig: Provides the configuration for logging a
// type of permissions.
// Example:
//
//     {
//       "audit_log_configs": [
//         {
//           "log_type": "DATA_READ",
//           "exempted_members": [
//             "user:jose@example.com"
//           ]
//         },
//         {
//           "log_type": "DATA_WRITE",
//         }
//       ]
//     }
//
// This enables 'DATA_READ' and 'DATA_WRITE' logging, while
// exempting
// jose@example.com from DATA_READ logging.
type GoogleIamV1AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging
	// for this type of
	// permission.
	// Follows the same format of Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`

	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	LogType string `json:"logType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExemptedMembers") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1AuditLogConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIamV1Binding: Associates `members` with a `role`.
type GoogleIamV1Binding struct {
	// Condition: The condition that is associated with this binding.
	// NOTE: An unsatisfied condition will not allow user access via
	// current
	// binding. Different bindings, including their conditions, are
	// examined
	// independently.
	Condition *GoogleTypeExpr `json:"condition,omitempty"`

	// Members: Specifies the identities requesting access for a Cloud
	// Platform resource.
	// `members` can have the following values:
	//
	// * `allUsers`: A special identifier that represents anyone who is
	//    on the internet; with or without a Google account.
	//
	// * `allAuthenticatedUsers`: A special identifier that represents
	// anyone
	//    who is authenticated with a Google account or a service
	// account.
	//
	// * `user:{emailid}`: An email address that represents a specific
	// Google
	//    account. For example, `alice@example.com` .
	//
	//
	// * `serviceAccount:{emailid}`: An email address that represents a
	// service
	//    account. For example,
	// `my-other-app@appspot.gserviceaccount.com`.
	//
	// * `group:{emailid}`: An email address that represents a Google
	// group.
	//    For example, `admins@example.com`.
	//
	//
	// * `domain:{domain}`: The G Suite domain (primary) that represents all
	// the
	//    users of that domain. For example, `google.com` or
	// `example.com`.
	//
	//
	Members []string `json:"members,omitempty"`

	// Role: Role that is assigned to `members`.
	// For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
	Role string `json:"role,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Condition") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1Binding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1Binding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIamV1Policy: Defines an Identity and Access Management (IAM)
// policy. It is used to
// specify access control policies for Cloud Platform resources.
//
//
// A `Policy` is a collection of `bindings`. A `binding` binds one or
// more
// `members` to a single `role`. Members can be user accounts, service
// accounts,
// Google groups, and domains (such as G Suite). A `role` is a named
// list of
// permissions (defined by IAM or configured by users). A `binding`
// can
// optionally specify a `condition`, which is a logic expression that
// further
// constrains the role binding based on attributes about the request
// and/or
// target resource.
//
// **JSON Example**
//
//     {
//       "bindings": [
//         {
//           "role": "roles/resourcemanager.organizationAdmin",
//           "members": [
//             "user:mike@example.com",
//             "group:admins@example.com",
//             "domain:google.com",
//
// "serviceAccount:my-project-id@appspot.gserviceaccount.com"
//           ]
//         },
//         {
//           "role": "roles/resourcemanager.organizationViewer",
//           "members": ["user:eve@example.com"],
//           "condition": {
//             "title": "expirable access",
//             "description": "Does not grant access after Sep 2020",
//             "expression": "request.time <
//             timestamp('2020-10-01T00:00:00.000Z')",
//           }
//         }
//       ]
//     }
//
// **YAML Example**
//
//     bindings:
//     - members:
//       - user:mike@example.com
//       - group:admins@example.com
//       - domain:google.com
//       - serviceAccount:my-project-id@appspot.gserviceaccount.com
//       role: roles/resourcemanager.organizationAdmin
//     - members:
//       - user:eve@example.com
//       role: roles/resourcemanager.organizationViewer
//       condition:
//         title: expirable access
//         description: Does not grant access after Sep 2020
//         expression: request.time <
// timestamp('2020-10-01T00:00:00.000Z')
//
// For a description of IAM and its features, see the
// [IAM developer's guide](https://cloud.google.com/iam/docs).
type GoogleIamV1Policy struct {
	// AuditConfigs: Specifies cloud audit logging configuration for this
	// policy.
	AuditConfigs []*GoogleIamV1AuditConfig `json:"auditConfigs,omitempty"`

	// Bindings: Associates a list of `members` to a `role`. Optionally may
	// specify a
	// `condition` that determines when binding is in effect.
	// `bindings` with no members will result in an error.
	Bindings []*GoogleIamV1Binding `json:"bindings,omitempty"`

	// Etag: `etag` is used for optimistic concurrency control as a way to
	// help
	// prevent simultaneous updates of a policy from overwriting each
	// other.
	// It is strongly suggested that systems make use of the `etag` in
	// the
	// read-modify-write cycle to perform policy updates in order to avoid
	// race
	// conditions: An `etag` is returned in the response to `getIamPolicy`,
	// and
	// systems are expected to put that etag in the request to
	// `setIamPolicy` to
	// ensure that their change will be applied to the same version of the
	// policy.
	//
	// If no `etag` is provided in the call to `setIamPolicy`, then the
	// existing
	// policy is overwritten. Due to blind-set semantics of an etag-less
	// policy,
	// 'setIamPolicy' will not fail even if either of incoming or stored
	// policy
	// does not meet the version requirements.
	Etag string `json:"etag,omitempty"`

	// Version: Specifies the format of the policy.
	//
	// Valid values are 0, 1, and 3. Requests specifying an invalid value
	// will be
	// rejected.
	//
	// Operations affecting conditional bindings must specify version 3.
	// This can
	// be either setting a conditional policy, modifying a conditional
	// binding,
	// or removing a conditional binding from the stored conditional
	// policy.
	// Operations on non-conditional policies may specify any valid value
	// or
	// leave the field unset.
	//
	// If no etag is provided in the call to `setIamPolicy`, any
	// version
	// compliance checks on the incoming and/or stored policy is skipped.
	Version int64 `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AuditConfigs") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuditConfigs") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1Policy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1Policy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeExpr: Represents an expression text. Example:
//
//     title: "User account presence"
//     description: "Determines whether the request has a user account"
//     expression: "size(request.user) > 0"
type GoogleTypeExpr struct {
	// Description: An optional description of the expression. This is a
	// longer text which
	// describes the expression, e.g. when hovered over it in a UI.
	Description string `json:"description,omitempty"`

	// Expression: Textual representation of an expression in
	// Common Expression Language syntax.
	//
	// The application context of the containing message determines
	// which
	// well-known feature set of CEL is supported.
	Expression string `json:"expression,omitempty"`

	// Location: An optional string indicating the location of the
	// expression for error
	// reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`

	// Title: An optional title for the expression, i.e. a short string
	// describing
	// its purpose. This can be used e.g. in UIs which allow to enter
	// the
	// expression.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeExpr) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeExpr
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "policytroubleshooter.iam.troubleshoot":

type IamTroubleshootCall struct {
	s                                                                 *Service
	googlecloudpolicytroubleshooterv1betatroubleshootiampolicyrequest *GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyRequest
	urlParams_                                                        gensupport.URLParams
	ctx_                                                              context.Context
	header_                                                           http.Header
}

// Troubleshoot: Perform a check on whether a member is granted a
// permission
// on a resource and how that grant/deny is determined accordinga
// to the resource's effective IAM policy interpretation.
func (r *IamService) Troubleshoot(googlecloudpolicytroubleshooterv1betatroubleshootiampolicyrequest *GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyRequest) *IamTroubleshootCall {
	c := &IamTroubleshootCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlecloudpolicytroubleshooterv1betatroubleshootiampolicyrequest = googlecloudpolicytroubleshooterv1betatroubleshootiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *IamTroubleshootCall) Fields(s ...googleapi.Field) *IamTroubleshootCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *IamTroubleshootCall) Context(ctx context.Context) *IamTroubleshootCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *IamTroubleshootCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *IamTroubleshootCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/1.13.4 gdcl/20191114")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudpolicytroubleshooterv1betatroubleshootiampolicyrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/iam:troubleshoot")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policytroubleshooter.iam.troubleshoot" call.
// Exactly one of
// *GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyResponse.Se
// rverResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *IamTroubleshootCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Perform a check on whether a member is granted a permission\non a resource and how that grant/deny is determined accordinga\nto the resource's effective IAM policy interpretation.",
	//   "flatPath": "v1beta/iam:troubleshoot",
	//   "httpMethod": "POST",
	//   "id": "policytroubleshooter.iam.troubleshoot",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v1beta/iam:troubleshoot",
	//   "request": {
	//     "$ref": "GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudPolicytroubleshooterV1betaTroubleshootIamPolicyResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}
