"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartArea = exports.ChartAreaSortOrder = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const victory_area_1 = require("victory-area");
const ChartContainer_1 = require("../ChartContainer");
const ChartUtils_1 = require("../ChartUtils");
var ChartAreaSortOrder;
(function (ChartAreaSortOrder) {
    ChartAreaSortOrder["ascending"] = "ascending";
    ChartAreaSortOrder["descending"] = "descending";
})(ChartAreaSortOrder = exports.ChartAreaSortOrder || (exports.ChartAreaSortOrder = {}));
const ChartArea = (_a) => {
    var { containerComponent = React.createElement(ChartContainer_1.ChartContainer, null), themeColor, themeVariant, 
    // destructure last
    theme = ChartUtils_1.getTheme(themeColor, themeVariant) } = _a, rest = tslib_1.__rest(_a, ["containerComponent", "themeColor", "themeVariant", "theme"]);
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign({ theme }, containerComponent.props));
    // Note: containerComponent is required for theme
    return React.createElement(victory_area_1.VictoryArea, Object.assign({ containerComponent: container, theme: theme }, rest));
};
exports.ChartArea = ChartArea;
exports.ChartArea.displayName = 'ChartArea';
// Note: VictoryArea.role must be hoisted
hoist_non_react_statics_1.default(exports.ChartArea, victory_area_1.VictoryArea);
//# sourceMappingURL=ChartArea.js.map