import { invariant } from "../../utilities/globals/index.js";
import * as React from 'react';
import { getApolloContext } from "./ApolloContext.js";
export var ApolloConsumer = function (props) {
    var ApolloContext = getApolloContext();
    return React.createElement(ApolloContext.Consumer, null, function (context) {
        __DEV__ ? invariant(context && context.client, 'Could not find "client" in the context of ApolloConsumer. ' +
            'Wrap the root component in an <ApolloProvider>.') : invariant(context && context.client, 27);
        return props.children(context.client);
    });
};
//# sourceMappingURL=ApolloConsumer.js.map