"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JumpLinks = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const react_styles_1 = require("@patternfly/react-styles");
const jump_links_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/JumpLinks/jump-links"));
const JumpLinksItem_1 = require("./JumpLinksItem");
const getScrollItems = (children, hasScrollSpy) => React.Children.toArray(children).map((child) => {
    if (hasScrollSpy && typeof document !== 'undefined' && child.type === JumpLinksItem_1.JumpLinksItem) {
        const scrollNode = child.props.node || child.props.href;
        if (typeof scrollNode === 'string') {
            if (scrollNode.startsWith('#')) {
                // Allow spaces and other special characters as `id`s
                // https://stackoverflow.com/questions/70579/what-are-valid-values-for-the-id-attribute-in-html
                return document.getElementById(scrollNode.substr(1));
            }
            return document.querySelector(scrollNode);
        }
        else if (scrollNode instanceof HTMLElement) {
            return scrollNode;
        }
    }
    return null;
});
exports.JumpLinks = (_a) => {
    var { isCentered, isVertical, children, label, 'aria-label': ariaLabel = typeof label === 'string' ? label : null, scrollableSelector, activeIndex: activeIndexProp = 0, offset = 0 } = _a, props = tslib_1.__rest(_a, ["isCentered", "isVertical", "children", "label", 'aria-label', "scrollableSelector", "activeIndex", "offset"]);
    const hasScrollSpy = Boolean(scrollableSelector);
    const [scrollItems, setScrollItems] = React.useState(getScrollItems(children, hasScrollSpy));
    const [activeIndex, setActiveIndex] = React.useState(activeIndexProp);
    if (hasScrollSpy) {
        React.useEffect(() => {
            if (typeof window === 'undefined') {
                return;
            }
            const scrollableElement = document.querySelector(scrollableSelector);
            if (!(scrollableElement instanceof HTMLElement)) {
                return;
            }
            function scrollSpy() {
                const scrollPosition = scrollableElement.scrollTop + offset;
                window.requestAnimationFrame(() => {
                    let newScrollItems = scrollItems;
                    // Items might have rendered after this component. Do a quick refresh.
                    if (!newScrollItems[0]) {
                        newScrollItems = getScrollItems(children, hasScrollSpy);
                        setScrollItems(newScrollItems);
                    }
                    const scrollElements = newScrollItems
                        .map((e, index) => ({
                        y: e ? e.offsetTop : null,
                        index
                    }))
                        .filter(({ y }) => y !== null)
                        .sort((e1, e2) => e2.y - e1.y);
                    for (const { y, index } of scrollElements) {
                        if (scrollPosition >= y) {
                            return setActiveIndex(index);
                        }
                    }
                });
            }
            if (scrollableElement) {
                scrollSpy();
                scrollableElement.addEventListener('scroll', scrollSpy);
            }
            return () => scrollableElement.removeEventListener('scroll', scrollSpy);
        }, [scrollItems, hasScrollSpy]);
    }
    return (React.createElement("nav", Object.assign({ className: react_styles_1.css(jump_links_1.default.jumpLinks, isCentered && jump_links_1.default.modifiers.center, isVertical && jump_links_1.default.modifiers.vertical), "aria-label": ariaLabel }, props),
        React.createElement("div", { className: jump_links_1.default.jumpLinksMain },
            label && React.createElement("div", { className: jump_links_1.default.jumpLinksLabel }, label),
            React.createElement("ul", { className: jump_links_1.default.jumpLinksList }, React.Children.map(children, (child, i) => {
                if (hasScrollSpy && child.type === JumpLinksItem_1.JumpLinksItem) {
                    const { onClick: onClickProp, isActive: isActiveProp } = child.props;
                    const scrollItem = scrollItems[i];
                    return React.cloneElement(child, {
                        onClick(ev) {
                            // Items might have rendered after this component. Do a quick refresh.
                            let newScrollItems;
                            if (!scrollItem) {
                                newScrollItems = getScrollItems(children, hasScrollSpy);
                                setScrollItems(newScrollItems);
                            }
                            const newScrollItem = scrollItem || newScrollItems[i];
                            if (newScrollItem) {
                                newScrollItem.scrollIntoView();
                                newScrollItem.focus();
                                ev.preventDefault();
                            }
                            if (onClickProp) {
                                onClickProp(ev);
                            }
                        },
                        isActive: isActiveProp || activeIndex === i
                    });
                }
                return child;
            })))));
};
exports.JumpLinks.displayName = 'JumpLinks';
//# sourceMappingURL=JumpLinks.js.map