"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmInlineStatus = exports.StatusType = void 0;
var react_1 = __importDefault(require("react"));
var react_core_1 = require("@patternfly/react-core");
var react_icons_1 = require("@patternfly/react-icons");
var AcmIcons_1 = require("../AcmIcons/AcmIcons");
var core_1 = require("@material-ui/core");
var useStyles = core_1.makeStyles({
    container: {
        display: 'flex',
    },
    icon: {
        width: '18px',
    },
    iconMargin: {
        margin: '3px 2px 1px 2px',
    },
});
var StatusType;
(function (StatusType) {
    StatusType["healthy"] = "healthy";
    StatusType["danger"] = "danger";
    StatusType["warning"] = "warning";
    StatusType["progress"] = "progress";
    StatusType["detached"] = "detached";
    StatusType["pending"] = "pending";
    StatusType["unknown"] = "unknown";
})(StatusType = exports.StatusType || (exports.StatusType = {}));
function AcmInlineStatus(props) {
    var classes = useStyles();
    return (react_1.default.createElement("div", { className: classes.container },
        react_1.default.createElement("div", { className: classes.icon },
            react_1.default.createElement(StatusIcon, { type: props.type })),
        react_1.default.createElement("span", { style: { marginLeft: '.4rem' } }, props.status)));
}
exports.AcmInlineStatus = AcmInlineStatus;
function StatusIcon(props) {
    var classes = useStyles();
    switch (props.type) {
        case StatusType.healthy:
            return react_1.default.createElement(react_icons_1.CheckCircleIcon, { className: classes.iconMargin, color: "var(--pf-global--success-color--100)" });
        case StatusType.danger:
            return react_1.default.createElement(react_icons_1.ExclamationCircleIcon, { className: classes.iconMargin, color: "var(--pf-global--danger-color--100)" });
        case StatusType.warning:
            return (react_1.default.createElement(react_icons_1.ExclamationTriangleIcon, { className: classes.iconMargin, color: "var(--pf-global--warning-color--100)" }));
        case StatusType.progress:
            return react_1.default.createElement(react_core_1.Spinner, { size: "md", style: { verticalAlign: 'middle' } });
        case StatusType.detached:
            return react_1.default.createElement(AcmIcons_1.AcmIcon, { icon: AcmIcons_1.AcmIconVariant.brokenlink });
        case StatusType.pending:
            return react_1.default.createElement(react_icons_1.MinusCircleIcon, { className: classes.iconMargin, color: "var(--pf-global--disabled-color--100)" });
        case 'unknown':
        default:
            return react_1.default.createElement(react_icons_1.UnknownIcon, { className: classes.iconMargin, color: "var(--pf-global--disabled-color--100)" });
    }
}
//# sourceMappingURL=AcmInlineStatus.js.map