import { __rest } from "tslib";
import * as React from 'react';
import styles from '@patternfly/react-styles/css/components/Table/table';
import stylesGrid from '@patternfly/react-styles/css/components/Table/table-grid';
import { css } from '@patternfly/react-styles';
import { toCamel } from '../Table/utils/utils';
import { useOUIAProps } from '@patternfly/react-core';
import { TableGridBreakpoint } from '../Table/TableTypes';
const TableComposableBase = (_a) => {
    var _b;
    var { children, className, variant, borders = true, isStickyHeader = false, gridBreakPoint = TableGridBreakpoint.gridMd, 'aria-label': ariaLabel, role = 'grid', innerRef, ouiaId, ouiaSafe = true } = _a, props = __rest(_a, ["children", "className", "variant", "borders", "isStickyHeader", "gridBreakPoint", 'aria-label', "role", "innerRef", "ouiaId", "ouiaSafe"]);
    const ouiaProps = useOUIAProps('Table', ouiaId, ouiaSafe);
    return (React.createElement("table", Object.assign({ "aria-label": ariaLabel, role: role, className: css(className, styles.table, (_b = stylesGrid.modifiers) === null || _b === void 0 ? void 0 : _b[toCamel(gridBreakPoint || '').replace(/-?2xl/, '_2xl')], styles.modifiers[variant], !borders && styles.modifiers.noBorderRows, isStickyHeader && styles.modifiers.stickyHeader), ref: innerRef }, ouiaProps, props), children));
};
export const TableComposable = React.forwardRef((props, ref) => (React.createElement(TableComposableBase, Object.assign({}, props, { innerRef: ref }))));
TableComposable.displayName = 'TableComposable';
//# sourceMappingURL=TableComposable.js.map