"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createContainer = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const victory_create_container_1 = require("victory-create-container");
const ChartCursorTooltip_1 = require("../ChartCursorTooltip");
const ChartLabel_1 = require("../ChartLabel");
/**
 * Makes a container component with multiple behaviors. It allows you to effectively combine any two
 * containers of type 'brush', 'cursor', 'selection', 'voronoi', or 'zoom'. Default container props are applied to
 * support the PatternFly theme.
 *
 * Each behavior must be one of the following strings: 'brush', 'cursor', 'selection', 'voronoi', and 'zoom'. The
 * resulting container uses the events from both behaviors. For example, if both behaviors use the click event (like
 * zoom and selection) the combined container will trigger both behaviors' events on each click.
 *
 * Note: Order of the behaviors matters in a few cases. It is recommended to use 'zoom' before any other behaviors: for
 * example, createContainer('zoom', 'voronoi') instead of createContainer('voronoi', 'zoom').
 *
 * See https://formidable.com/open-source/victory/docs/create-container
 *
 * @param {string} behaviorA 'brush', 'cursor', 'selection', 'voronoi', or 'zoom'
 * @param {string} behaviorB 'brush', 'cursor', 'selection', 'voronoi', or 'zoom'
 */
exports.createContainer = (behaviorA, behaviorB) => {
    const container = victory_create_container_1.createContainer(behaviorA, behaviorB);
    const isCursor = behaviorA === 'cursor' || behaviorB === 'cursor';
    const isVoronoi = behaviorA === 'voronoi' || behaviorB === 'voronoi';
    if (isCursor) {
        container.defaultProps.cursorLabelComponent = React.createElement(ChartLabel_1.ChartLabel, { textAnchor: "start" });
    }
    if (isVoronoi) {
        container.defaultProps.labelComponent = React.createElement(ChartCursorTooltip_1.ChartCursorTooltip, null);
    }
    return container;
};
//# sourceMappingURL=chart-container.js.map