'use strict';var _path = require('path');var _path2 = _interopRequireDefault(_path);
var _readPkgUp = require('eslint-module-utils/readPkgUp');var _readPkgUp2 = _interopRequireDefault(_readPkgUp);

var _resolve = require('eslint-module-utils/resolve');var _resolve2 = _interopRequireDefault(_resolve);
var _moduleVisitor = require('eslint-module-utils/moduleVisitor');var _moduleVisitor2 = _interopRequireDefault(_moduleVisitor);
var _importType = require('../core/importType');var _importType2 = _interopRequireDefault(_importType);
var _docsUrl = require('../docsUrl');var _docsUrl2 = _interopRequireDefault(_docsUrl);function _interopRequireDefault(obj) {return obj && obj.__esModule ? obj : { 'default': obj };}

function findNamedPackage(filePath) {
  var found = (0, _readPkgUp2['default'])({ cwd: filePath });
  if (found.pkg && !found.pkg.name) {
    return findNamedPackage(_path2['default'].join(found.path, '../..'));
  }
  return found;
}

function checkImportForRelativePackage(context, importPath, node) {
  var potentialViolationTypes = ['parent', 'index', 'sibling'];
  if (potentialViolationTypes.indexOf((0, _importType2['default'])(importPath, context)) === -1) {
    return;
  }

  var resolvedImport = (0, _resolve2['default'])(importPath, context);
  var resolvedContext = context.getPhysicalFilename ? context.getPhysicalFilename() : context.getFilename();

  if (!resolvedImport || !resolvedContext) {
    return;
  }

  var importPkg = findNamedPackage(resolvedImport);
  var contextPkg = findNamedPackage(resolvedContext);

  if (importPkg.pkg && contextPkg.pkg && importPkg.pkg.name !== contextPkg.pkg.name) {
    var importBaseName = _path2['default'].basename(importPath);
    var importRoot = _path2['default'].dirname(importPkg.path);
    var properPath = _path2['default'].relative(importRoot, resolvedImport);
    var properImport = _path2['default'].join(
    importPkg.pkg.name,
    _path2['default'].dirname(properPath),
    importBaseName === _path2['default'].basename(importRoot) ? '' : importBaseName);

    context.report({
      node: node,
      message: 'Relative import from another package is not allowed. Use `' + String(properImport) + '` instead of `' + String(importPath) + '`' });

  }
}

module.exports = {
  meta: {
    type: 'suggestion',
    docs: {
      url: (0, _docsUrl2['default'])('no-relative-packages') },

    schema: [(0, _moduleVisitor.makeOptionsSchema)()] },


  create: function () {function create(context) {
      return (0, _moduleVisitor2['default'])(function (source) {return checkImportForRelativePackage(context, source.value, source);}, context.options[0]);
    }return create;}() };
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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