var $ = require('../internals/export');
var toIndexedObject = require('../internals/to-indexed-object');
var toObject = require('../internals/to-object');
var toString = require('../internals/to-string');
var lengthOfArrayLike = require('../internals/length-of-array-like');

var ArrayPrototype = Array.prototype;
var push = ArrayPrototype.push;
var join = ArrayPrototype.join;

// `String.raw` method
// https://tc39.es/ecma262/#sec-string.raw
$({ target: 'String', stat: true }, {
  raw: function raw(template) {
    var rawTemplate = toIndexedObject(toObject(template).raw);
    var literalSegments = lengthOfArrayLike(rawTemplate);
    var argumentsLength = arguments.length;
    var elements = [];
    var i = 0;
    while (literalSegments > i) {
      push.call(elements, toString(rawTemplate[i++]));
      if (i === literalSegments) return join.call(elements, '');
      if (i < argumentsLength) push.call(elements, toString(arguments[i]));
    }
  }
});
