import { Slot } from "@wry/context";
import { dep } from "optimism";
var varDep = dep();
export var cacheSlot = new Slot();
function consumeAndIterate(set, callback) {
    if (set.size) {
        var items_1 = [];
        set.forEach(function (item) { return items_1.push(item); });
        set.clear();
        items_1.forEach(callback);
    }
}
var varsByCache = new WeakMap();
export function forgetCache(cache) {
    var vars = varsByCache.get(cache);
    if (vars) {
        consumeAndIterate(vars, function (rv) { return rv.forgetCache(cache); });
        varsByCache.delete(cache);
    }
}
export function makeVar(value) {
    var caches = new Set();
    var listeners = new Set();
    var rv = function (newValue) {
        if (arguments.length > 0) {
            if (value !== newValue) {
                value = newValue;
                varDep.dirty(rv);
                caches.forEach(broadcast);
                consumeAndIterate(listeners, function (listener) { return listener(value); });
            }
        }
        else {
            var cache = cacheSlot.getValue();
            if (cache)
                attach(cache);
            varDep(rv);
        }
        return value;
    };
    rv.onNextChange = function (listener) {
        listeners.add(listener);
        return function () {
            listeners.delete(listener);
        };
    };
    var attach = rv.attachCache = function (cache) {
        caches.add(cache);
        var vars = varsByCache.get(cache);
        if (!vars)
            varsByCache.set(cache, vars = new Set);
        vars.add(rv);
        return rv;
    };
    rv.forgetCache = function (cache) {
        var deleted = caches.delete(cache);
        if (deleted) {
            var vars = varsByCache.get(cache);
            if (vars)
                vars.delete(rv);
        }
        return deleted;
    };
    return rv;
}
function broadcast(cache) {
    if (cache.broadcastWatches) {
        cache.broadcastWatches();
    }
}
//# sourceMappingURL=reactiveVars.js.map