'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

const tslib = require('tslib');
const graphql = require('graphql');
const fs = require('fs');
const path = require('path');
const resolveFrom = _interopDefault(require('resolve-from'));

var builtinTypes = ['String', 'Float', 'Int', 'Boolean', 'ID', 'Upload'];
var builtinDirectives = [
    'deprecated',
    'skip',
    'include',
    'cacheControl',
    'key',
    'external',
    'requires',
    'provides',
    'connection',
    'client',
    'specifiedBy',
];
var IMPORT_FROM_REGEX = /^import\s+(\*|(.*))\s+from\s+('|")(.*)('|");?$/;
var IMPORT_DEFAULT_REGEX = /^import\s+('|")(.*)('|");?$/;
function processImport(filePath, cwd, predefinedImports) {
    var e_1, _a, e_2, _b;
    if (cwd === void 0) { cwd = process.cwd(); }
    if (predefinedImports === void 0) { predefinedImports = {}; }
    var visitedFiles = new Map();
    var set = visitFile(filePath, path.join(cwd + '/root.graphql'), visitedFiles, predefinedImports);
    var definitionSet = new Set();
    try {
        for (var _c = tslib.__values(set.values()), _d = _c.next(); !_d.done; _d = _c.next()) {
            var defs = _d.value;
            try {
                for (var defs_1 = (e_2 = void 0, tslib.__values(defs)), defs_1_1 = defs_1.next(); !defs_1_1.done; defs_1_1 = defs_1.next()) {
                    var def = defs_1_1.value;
                    definitionSet.add(def);
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (defs_1_1 && !defs_1_1.done && (_b = defs_1.return)) _b.call(defs_1);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return {
        kind: graphql.Kind.DOCUMENT,
        definitions: tslib.__spread(definitionSet),
    };
}
function visitFile(filePath, cwd, visitedFiles, predefinedImports) {
    var e_3, _a, e_4, _b, e_5, _c, e_6, _d, e_7, _e, e_8, _f, e_9, _g, e_10, _h, e_11, _j, e_12, _k;
    if (!path.isAbsolute(filePath) && !(filePath in predefinedImports)) {
        filePath = resolveFilePath(cwd, filePath);
    }
    if (!visitedFiles.has(filePath)) {
        var fileContent = filePath in predefinedImports ? predefinedImports[filePath] : fs.readFileSync(filePath, 'utf8');
        var importLines = [];
        var otherLines = '';
        try {
            for (var _l = tslib.__values(fileContent.split('\n')), _m = _l.next(); !_m.done; _m = _l.next()) {
                var line = _m.value;
                var trimmedLine = line.trim();
                if (trimmedLine.startsWith('#import ') || trimmedLine.startsWith('# import ')) {
                    importLines.push(trimmedLine);
                }
                else if (trimmedLine) {
                    otherLines += line + '\n';
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_m && !_m.done && (_a = _l.return)) _a.call(_l);
            }
            finally { if (e_3) throw e_3.error; }
        }
        var definitionsByName = new Map();
        var dependenciesByDefinitionName = new Map();
        if (otherLines) {
            var fileDefinitionMap = new Map();
            // To prevent circular dependency
            visitedFiles.set(filePath, fileDefinitionMap);
            var document_1 = graphql.parse(new graphql.Source(otherLines, filePath), {
                noLocation: true,
            });
            try {
                for (var _o = tslib.__values(document_1.definitions), _p = _o.next(); !_p.done; _p = _o.next()) {
                    var definition = _p.value;
                    if ('name' in definition || definition.kind === graphql.Kind.SCHEMA_DEFINITION) {
                        var definitionName = 'name' in definition ? definition.name.value : 'schema';
                        if (!definitionsByName.has(definitionName)) {
                            definitionsByName.set(definitionName, new Set());
                        }
                        var definitionsSet = definitionsByName.get(definitionName);
                        definitionsSet.add(definition);
                        if (!dependenciesByDefinitionName.has(definitionName)) {
                            dependenciesByDefinitionName.set(definitionName, new Set());
                        }
                        var dependencySet = dependenciesByDefinitionName.get(definitionName);
                        switch (definition.kind) {
                            case graphql.Kind.OPERATION_DEFINITION:
                                visitOperationDefinitionNode(definition, dependencySet);
                                break;
                            case graphql.Kind.FRAGMENT_DEFINITION:
                                visitFragmentDefinitionNode(definition, dependencySet);
                                break;
                            case graphql.Kind.OBJECT_TYPE_DEFINITION:
                                visitObjectTypeDefinitionNode(definition, dependencySet, dependenciesByDefinitionName);
                                break;
                            case graphql.Kind.INTERFACE_TYPE_DEFINITION:
                                visitInterfaceTypeDefinitionNode(definition, dependencySet, dependenciesByDefinitionName);
                                break;
                            case graphql.Kind.UNION_TYPE_DEFINITION:
                                visitUnionTypeDefinitionNode(definition, dependencySet);
                                break;
                            case graphql.Kind.ENUM_TYPE_DEFINITION:
                                visitEnumTypeDefinitionNode(definition, dependencySet);
                                break;
                            case graphql.Kind.INPUT_OBJECT_TYPE_DEFINITION:
                                visitInputObjectTypeDefinitionNode(definition, dependencySet, dependenciesByDefinitionName);
                                break;
                            case graphql.Kind.DIRECTIVE_DEFINITION:
                                visitDirectiveDefinitionNode(definition, dependencySet, dependenciesByDefinitionName);
                                break;
                            case graphql.Kind.SCALAR_TYPE_DEFINITION:
                                visitScalarDefinitionNode(definition, dependencySet);
                                break;
                            case graphql.Kind.SCHEMA_DEFINITION:
                                visitSchemaDefinitionNode(definition, dependencySet);
                                break;
                            case graphql.Kind.OBJECT_TYPE_EXTENSION:
                                visitObjectTypeExtensionNode(definition, dependencySet, dependenciesByDefinitionName);
                                break;
                            case graphql.Kind.INTERFACE_TYPE_EXTENSION:
                                visitInterfaceTypeExtensionNode(definition, dependencySet, dependenciesByDefinitionName);
                                break;
                            case graphql.Kind.UNION_TYPE_EXTENSION:
                                visitUnionTypeExtensionNode(definition, dependencySet);
                                break;
                            case graphql.Kind.ENUM_TYPE_EXTENSION:
                                visitEnumTypeExtensionNode(definition, dependencySet);
                                break;
                            case graphql.Kind.INPUT_OBJECT_TYPE_EXTENSION:
                                visitInputObjectTypeExtensionNode(definition, dependencySet, dependenciesByDefinitionName);
                                break;
                            case graphql.Kind.SCALAR_TYPE_EXTENSION:
                                visitScalarExtensionNode(definition, dependencySet);
                                break;
                        }
                        if ('fields' in definition) {
                            try {
                                for (var _q = (e_5 = void 0, tslib.__values(definition.fields)), _r = _q.next(); !_r.done; _r = _q.next()) {
                                    var field = _r.value;
                                    var definitionName_1 = definition.name.value + '.' + field.name.value;
                                    if (!definitionsByName.has(definitionName_1)) {
                                        definitionsByName.set(definitionName_1, new Set());
                                    }
                                    var definitionsSet_1 = definitionsByName.get(definitionName_1);
                                    definitionsSet_1.add(tslib.__assign(tslib.__assign({}, definition), { fields: [field] }));
                                    if (!dependenciesByDefinitionName.has(definitionName_1)) {
                                        dependenciesByDefinitionName.set(definitionName_1, new Set());
                                    }
                                    var dependencySet_1 = dependenciesByDefinitionName.get(definitionName_1);
                                    switch (field.kind) {
                                        case graphql.Kind.FIELD_DEFINITION:
                                            visitFieldDefinitionNode(field, dependencySet_1, dependenciesByDefinitionName);
                                            break;
                                        case graphql.Kind.INPUT_VALUE_DEFINITION:
                                            visitInputValueDefinitionNode(field, dependencySet_1, dependenciesByDefinitionName);
                                            break;
                                    }
                                }
                            }
                            catch (e_5_1) { e_5 = { error: e_5_1 }; }
                            finally {
                                try {
                                    if (_r && !_r.done && (_c = _q.return)) _c.call(_q);
                                }
                                finally { if (e_5) throw e_5.error; }
                            }
                        }
                    }
                }
            }
            catch (e_4_1) { e_4 = { error: e_4_1 }; }
            finally {
                try {
                    if (_p && !_p.done && (_b = _o.return)) _b.call(_o);
                }
                finally { if (e_4) throw e_4.error; }
            }
            var _loop_1 = function (definitionName, definitions) {
                var e_13, _a, e_14, _b;
                if (!fileDefinitionMap.has(definitionName)) {
                    fileDefinitionMap.set(definitionName, new Set());
                }
                var definitionsWithDependencies = fileDefinitionMap.get(definitionName);
                try {
                    for (var definitions_1 = (e_13 = void 0, tslib.__values(definitions)), definitions_1_1 = definitions_1.next(); !definitions_1_1.done; definitions_1_1 = definitions_1.next()) {
                        var definition = definitions_1_1.value;
                        definitionsWithDependencies.add(definition);
                    }
                }
                catch (e_13_1) { e_13 = { error: e_13_1 }; }
                finally {
                    try {
                        if (definitions_1_1 && !definitions_1_1.done && (_a = definitions_1.return)) _a.call(definitions_1);
                    }
                    finally { if (e_13) throw e_13.error; }
                }
                var dependenciesOfDefinition = dependenciesByDefinitionName.get(definitionName);
                try {
                    for (var dependenciesOfDefinition_1 = (e_14 = void 0, tslib.__values(dependenciesOfDefinition)), dependenciesOfDefinition_1_1 = dependenciesOfDefinition_1.next(); !dependenciesOfDefinition_1_1.done; dependenciesOfDefinition_1_1 = dependenciesOfDefinition_1.next()) {
                        var dependencyName = dependenciesOfDefinition_1_1.value;
                        var dependencyDefinitions = definitionsByName.get(dependencyName);
                        dependencyDefinitions === null || dependencyDefinitions === void 0 ? void 0 : dependencyDefinitions.forEach(function (dependencyDefinition) {
                            definitionsWithDependencies.add(dependencyDefinition);
                        });
                    }
                }
                catch (e_14_1) { e_14 = { error: e_14_1 }; }
                finally {
                    try {
                        if (dependenciesOfDefinition_1_1 && !dependenciesOfDefinition_1_1.done && (_b = dependenciesOfDefinition_1.return)) _b.call(dependenciesOfDefinition_1);
                    }
                    finally { if (e_14) throw e_14.error; }
                }
            };
            try {
                for (var definitionsByName_1 = tslib.__values(definitionsByName), definitionsByName_1_1 = definitionsByName_1.next(); !definitionsByName_1_1.done; definitionsByName_1_1 = definitionsByName_1.next()) {
                    var _s = tslib.__read(definitionsByName_1_1.value, 2), definitionName = _s[0], definitions = _s[1];
                    _loop_1(definitionName, definitions);
                }
            }
            catch (e_6_1) { e_6 = { error: e_6_1 }; }
            finally {
                try {
                    if (definitionsByName_1_1 && !definitionsByName_1_1.done && (_d = definitionsByName_1.return)) _d.call(definitionsByName_1);
                }
                finally { if (e_6) throw e_6.error; }
            }
        }
        var allImportedDefinitionsMap_1 = new Map();
        try {
            for (var importLines_1 = tslib.__values(importLines), importLines_1_1 = importLines_1.next(); !importLines_1_1.done; importLines_1_1 = importLines_1.next()) {
                var line = importLines_1_1.value;
                var _t = parseImportLine(line.replace('#', '').trim()), imports = _t.imports, from = _t.from;
                var importFileDefinitionMap = visitFile(from, filePath, visitedFiles, predefinedImports);
                if (imports.includes('*')) {
                    try {
                        for (var importFileDefinitionMap_1 = (e_8 = void 0, tslib.__values(importFileDefinitionMap)), importFileDefinitionMap_1_1 = importFileDefinitionMap_1.next(); !importFileDefinitionMap_1_1.done; importFileDefinitionMap_1_1 = importFileDefinitionMap_1.next()) {
                            var _u = tslib.__read(importFileDefinitionMap_1_1.value, 2), importedDefinitionName = _u[0], importedDefinitions = _u[1];
                            var _v = tslib.__read(importedDefinitionName.split('.'), 1), importedDefinitionTypeName = _v[0];
                            if (!allImportedDefinitionsMap_1.has(importedDefinitionTypeName)) {
                                allImportedDefinitionsMap_1.set(importedDefinitionTypeName, new Set());
                            }
                            var allImportedDefinitions = allImportedDefinitionsMap_1.get(importedDefinitionTypeName);
                            try {
                                for (var importedDefinitions_1 = (e_9 = void 0, tslib.__values(importedDefinitions)), importedDefinitions_1_1 = importedDefinitions_1.next(); !importedDefinitions_1_1.done; importedDefinitions_1_1 = importedDefinitions_1.next()) {
                                    var importedDefinition = importedDefinitions_1_1.value;
                                    allImportedDefinitions.add(importedDefinition);
                                }
                            }
                            catch (e_9_1) { e_9 = { error: e_9_1 }; }
                            finally {
                                try {
                                    if (importedDefinitions_1_1 && !importedDefinitions_1_1.done && (_g = importedDefinitions_1.return)) _g.call(importedDefinitions_1);
                                }
                                finally { if (e_9) throw e_9.error; }
                            }
                        }
                    }
                    catch (e_8_1) { e_8 = { error: e_8_1 }; }
                    finally {
                        try {
                            if (importFileDefinitionMap_1_1 && !importFileDefinitionMap_1_1.done && (_f = importFileDefinitionMap_1.return)) _f.call(importFileDefinitionMap_1);
                        }
                        finally { if (e_8) throw e_8.error; }
                    }
                }
                else {
                    try {
                        for (var imports_1 = (e_10 = void 0, tslib.__values(imports)), imports_1_1 = imports_1.next(); !imports_1_1.done; imports_1_1 = imports_1.next()) {
                            var importedDefinitionName = imports_1_1.value;
                            if (importedDefinitionName.endsWith('.*')) {
                                // Adding whole type means the same thing with adding every single field
                                importedDefinitionName = importedDefinitionName.replace('.*', '');
                            }
                            var _w = tslib.__read(importedDefinitionName.split('.'), 1), importedDefinitionTypeName = _w[0];
                            if (!allImportedDefinitionsMap_1.has(importedDefinitionTypeName)) {
                                allImportedDefinitionsMap_1.set(importedDefinitionTypeName, new Set());
                            }
                            var allImportedDefinitions = allImportedDefinitionsMap_1.get(importedDefinitionTypeName);
                            var importedDefinitions = importFileDefinitionMap.get(importedDefinitionName);
                            if (!importedDefinitions) {
                                throw new Error(importedDefinitionName + " is not exported by " + from + " imported by " + filePath);
                            }
                            try {
                                for (var importedDefinitions_2 = (e_11 = void 0, tslib.__values(importedDefinitions)), importedDefinitions_2_1 = importedDefinitions_2.next(); !importedDefinitions_2_1.done; importedDefinitions_2_1 = importedDefinitions_2.next()) {
                                    var importedDefinition = importedDefinitions_2_1.value;
                                    allImportedDefinitions.add(importedDefinition);
                                }
                            }
                            catch (e_11_1) { e_11 = { error: e_11_1 }; }
                            finally {
                                try {
                                    if (importedDefinitions_2_1 && !importedDefinitions_2_1.done && (_j = importedDefinitions_2.return)) _j.call(importedDefinitions_2);
                                }
                                finally { if (e_11) throw e_11.error; }
                            }
                        }
                    }
                    catch (e_10_1) { e_10 = { error: e_10_1 }; }
                    finally {
                        try {
                            if (imports_1_1 && !imports_1_1.done && (_h = imports_1.return)) _h.call(imports_1);
                        }
                        finally { if (e_10) throw e_10.error; }
                    }
                }
            }
        }
        catch (e_7_1) { e_7 = { error: e_7_1 }; }
        finally {
            try {
                if (importLines_1_1 && !importLines_1_1.done && (_e = importLines_1.return)) _e.call(importLines_1);
            }
            finally { if (e_7) throw e_7.error; }
        }
        if (!otherLines) {
            visitedFiles.set(filePath, allImportedDefinitionsMap_1);
        }
        else {
            var fileDefinitionMap_1 = visitedFiles.get(filePath);
            var _loop_2 = function (definitionName) {
                var e_15, _a;
                var addDefinition = function (definition) {
                    var e_16, _a;
                    definitionsWithDependencies.add(definition);
                    // Regenerate field exports if some fields are imported after visitor
                    if ('fields' in definition) {
                        var _loop_3 = function (field) {
                            var fieldName = field.name.value;
                            var fieldDefinitionName = definition.name.value + '.' + fieldName;
                            var allImportedDefinitions_1 = allImportedDefinitionsMap_1.get(definitionName);
                            allImportedDefinitions_1 === null || allImportedDefinitions_1 === void 0 ? void 0 : allImportedDefinitions_1.forEach(function (importedDefinition) {
                                if (!fileDefinitionMap_1.has(fieldDefinitionName)) {
                                    fileDefinitionMap_1.set(fieldDefinitionName, new Set());
                                }
                                var definitionsWithDeps = fileDefinitionMap_1.get(fieldDefinitionName);
                                definitionsWithDeps.add(importedDefinition);
                            });
                        };
                        try {
                            for (var _b = (e_16 = void 0, tslib.__values(definition.fields)), _c = _b.next(); !_c.done; _c = _b.next()) {
                                var field = _c.value;
                                _loop_3(field);
                            }
                        }
                        catch (e_16_1) { e_16 = { error: e_16_1 }; }
                        finally {
                            try {
                                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                            }
                            finally { if (e_16) throw e_16.error; }
                        }
                    }
                };
                var definitionsWithDependencies = fileDefinitionMap_1.get(definitionName);
                var allImportedDefinitions = allImportedDefinitionsMap_1.get(definitionName);
                allImportedDefinitions === null || allImportedDefinitions === void 0 ? void 0 : allImportedDefinitions.forEach(function (importedDefinition) {
                    addDefinition(importedDefinition);
                });
                var dependenciesOfDefinition = dependenciesByDefinitionName.get(definitionName);
                try {
                    for (var dependenciesOfDefinition_2 = (e_15 = void 0, tslib.__values(dependenciesOfDefinition)), dependenciesOfDefinition_2_1 = dependenciesOfDefinition_2.next(); !dependenciesOfDefinition_2_1.done; dependenciesOfDefinition_2_1 = dependenciesOfDefinition_2.next()) {
                        var dependencyName = dependenciesOfDefinition_2_1.value;
                        // If that dependency cannot be found both in imports and this file, throw an error
                        if (!allImportedDefinitionsMap_1.has(dependencyName) && !definitionsByName.has(dependencyName)) {
                            throw new Error("Couldn't find type " + dependencyName + " in any of the schemas.");
                        }
                        var dependencyDefinitionsFromImports = allImportedDefinitionsMap_1.get(dependencyName);
                        dependencyDefinitionsFromImports === null || dependencyDefinitionsFromImports === void 0 ? void 0 : dependencyDefinitionsFromImports.forEach(function (dependencyDefinition) {
                            addDefinition(dependencyDefinition);
                        });
                    }
                }
                catch (e_15_1) { e_15 = { error: e_15_1 }; }
                finally {
                    try {
                        if (dependenciesOfDefinition_2_1 && !dependenciesOfDefinition_2_1.done && (_a = dependenciesOfDefinition_2.return)) _a.call(dependenciesOfDefinition_2);
                    }
                    finally { if (e_15) throw e_15.error; }
                }
            };
            try {
                for (var definitionsByName_2 = tslib.__values(definitionsByName), definitionsByName_2_1 = definitionsByName_2.next(); !definitionsByName_2_1.done; definitionsByName_2_1 = definitionsByName_2.next()) {
                    var _x = tslib.__read(definitionsByName_2_1.value, 1), definitionName = _x[0];
                    _loop_2(definitionName);
                }
            }
            catch (e_12_1) { e_12 = { error: e_12_1 }; }
            finally {
                try {
                    if (definitionsByName_2_1 && !definitionsByName_2_1.done && (_k = definitionsByName_2.return)) _k.call(definitionsByName_2);
                }
                finally { if (e_12) throw e_12.error; }
            }
        }
    }
    return visitedFiles.get(filePath);
}
function parseImportLine(importLine) {
    if (IMPORT_FROM_REGEX.test(importLine)) {
        // Apply regex to import line
        // Extract matches into named variables
        var _a = tslib.__read(importLine.match(IMPORT_FROM_REGEX), 5), wildcard = _a[1], importsString = _a[2], from = _a[4];
        if (from) {
            // Extract imported types
            var imports = wildcard === '*' ? ['*'] : importsString.split(',').map(function (d) { return d.trim(); });
            // Return information about the import line
            return { imports: imports, from: from };
        }
    }
    else if (IMPORT_DEFAULT_REGEX.test(importLine)) {
        var _b = tslib.__read(importLine.match(IMPORT_DEFAULT_REGEX), 3), from = _b[2];
        if (from) {
            return { imports: ['*'], from: from };
        }
    }
    throw new Error("\n    Import statement is not valid:\n    > " + importLine + "\n    If you want to have comments starting with '# import', please use ''' instead!\n    You can only have 'import' statements in the following pattern;\n    # import [Type].[Field] from [File]\n  ");
}
function resolveFilePath(filePath, importFrom) {
    var dirName = path.dirname(filePath);
    try {
        var fullPath = path.join(dirName, importFrom);
        return fs.realpathSync(fullPath);
    }
    catch (e) {
        if (e.code === 'ENOENT') {
            return resolveFrom(dirName, importFrom);
        }
    }
}
function visitOperationDefinitionNode(node, dependencySet) {
    dependencySet.add(node.name.value);
    node.selectionSet.selections.forEach(function (selectionNode) { return visitSelectionNode(selectionNode, dependencySet); });
}
function visitSelectionNode(node, dependencySet) {
    switch (node.kind) {
        case graphql.Kind.FIELD:
            visitFieldNode(node, dependencySet);
            break;
        case graphql.Kind.FRAGMENT_SPREAD:
            visitFragmentSpreadNode(node, dependencySet);
            break;
        case graphql.Kind.INLINE_FRAGMENT:
            visitInlineFragmentNode(node, dependencySet);
            break;
    }
}
function visitFieldNode(node, dependencySet) {
    var _a;
    (_a = node.selectionSet) === null || _a === void 0 ? void 0 : _a.selections.forEach(function (selectionNode) { return visitSelectionNode(selectionNode, dependencySet); });
}
function visitFragmentSpreadNode(node, dependencySet) {
    dependencySet.add(node.name.value);
}
function visitInlineFragmentNode(node, dependencySet) {
    node.selectionSet.selections.forEach(function (selectionNode) { return visitSelectionNode(selectionNode, dependencySet); });
}
function visitFragmentDefinitionNode(node, dependencySet) {
    dependencySet.add(node.name.value);
    node.selectionSet.selections.forEach(function (selectionNode) { return visitSelectionNode(selectionNode, dependencySet); });
}
function visitObjectTypeDefinitionNode(node, dependencySet, dependenciesByDefinitionName) {
    var _a, _b, _c;
    var typeName = node.name.value;
    dependencySet.add(typeName);
    (_a = node.directives) === null || _a === void 0 ? void 0 : _a.forEach(function (directiveNode) { return visitDirectiveNode(directiveNode, dependencySet); });
    (_b = node.fields) === null || _b === void 0 ? void 0 : _b.forEach(function (fieldDefinitionNode) {
        return visitFieldDefinitionNode(fieldDefinitionNode, dependencySet);
    });
    (_c = node.interfaces) === null || _c === void 0 ? void 0 : _c.forEach(function (namedTypeNode) {
        visitNamedTypeNode(namedTypeNode, dependencySet);
        var interfaceName = namedTypeNode.name.value;
        // interface should be dependent to the type as well
        if (!dependenciesByDefinitionName.has(interfaceName)) {
            dependenciesByDefinitionName.set(interfaceName, new Set());
        }
        dependenciesByDefinitionName.get(interfaceName).add(typeName);
    });
}
function visitDirectiveNode(node, dependencySet) {
    var directiveName = node.name.value;
    if (!builtinDirectives.includes(directiveName)) {
        dependencySet.add(node.name.value);
    }
}
function visitFieldDefinitionNode(node, dependencySet, dependenciesByDefinitionName) {
    var _a, _b;
    (_a = node.arguments) === null || _a === void 0 ? void 0 : _a.forEach(function (inputValueDefinitionNode) {
        return visitInputValueDefinitionNode(inputValueDefinitionNode, dependencySet);
    });
    (_b = node.directives) === null || _b === void 0 ? void 0 : _b.forEach(function (directiveNode) { return visitDirectiveNode(directiveNode, dependencySet); });
    visitTypeNode(node.type, dependencySet);
}
function visitTypeNode(node, dependencySet, dependenciesByDefinitionName) {
    switch (node.kind) {
        case graphql.Kind.LIST_TYPE:
            visitListTypeNode(node, dependencySet);
            break;
        case graphql.Kind.NON_NULL_TYPE:
            visitNonNullTypeNode(node, dependencySet);
            break;
        case graphql.Kind.NAMED_TYPE:
            visitNamedTypeNode(node, dependencySet);
            break;
    }
}
function visitListTypeNode(node, dependencySet, dependenciesByDefinitionName) {
    visitTypeNode(node.type, dependencySet);
}
function visitNonNullTypeNode(node, dependencySet, dependenciesByDefinitionName) {
    visitTypeNode(node.type, dependencySet);
}
function visitNamedTypeNode(node, dependencySet) {
    var namedTypeName = node.name.value;
    if (!builtinTypes.includes(namedTypeName)) {
        dependencySet.add(node.name.value);
    }
}
function visitInputValueDefinitionNode(node, dependencySet, dependenciesByDefinitionName) {
    var _a;
    (_a = node.directives) === null || _a === void 0 ? void 0 : _a.forEach(function (directiveNode) { return visitDirectiveNode(directiveNode, dependencySet); });
    visitTypeNode(node.type, dependencySet);
}
function visitInterfaceTypeDefinitionNode(node, dependencySet, dependenciesByDefinitionName) {
    var _a, _b, _c;
    var typeName = node.name.value;
    dependencySet.add(typeName);
    (_a = node.directives) === null || _a === void 0 ? void 0 : _a.forEach(function (directiveNode) { return visitDirectiveNode(directiveNode, dependencySet); });
    (_b = node.fields) === null || _b === void 0 ? void 0 : _b.forEach(function (fieldDefinitionNode) {
        return visitFieldDefinitionNode(fieldDefinitionNode, dependencySet);
    });
    (_c = node.interfaces) === null || _c === void 0 ? void 0 : _c.forEach(function (namedTypeNode) {
        visitNamedTypeNode(namedTypeNode, dependencySet);
        var interfaceName = namedTypeNode.name.value;
        // interface should be dependent to the type as well
        if (!dependenciesByDefinitionName.has(interfaceName)) {
            dependenciesByDefinitionName.set(interfaceName, new Set());
        }
        dependenciesByDefinitionName.get(interfaceName).add(typeName);
    });
}
function visitUnionTypeDefinitionNode(node, dependencySet) {
    var _a;
    dependencySet.add(node.name.value);
    (_a = node.directives) === null || _a === void 0 ? void 0 : _a.forEach(function (directiveNode) { return visitDirectiveNode(directiveNode, dependencySet); });
    node.types.forEach(function (namedTypeNode) { return visitNamedTypeNode(namedTypeNode, dependencySet); });
}
function visitEnumTypeDefinitionNode(node, dependencySet) {
    var _a;
    dependencySet.add(node.name.value);
    (_a = node.directives) === null || _a === void 0 ? void 0 : _a.forEach(function (directiveNode) { return visitDirectiveNode(directiveNode, dependencySet); });
}
function visitInputObjectTypeDefinitionNode(node, dependencySet, dependenciesByDefinitionName) {
    var _a, _b;
    dependencySet.add(node.name.value);
    (_a = node.directives) === null || _a === void 0 ? void 0 : _a.forEach(function (directiveNode) { return visitDirectiveNode(directiveNode, dependencySet); });
    (_b = node.fields) === null || _b === void 0 ? void 0 : _b.forEach(function (inputValueDefinitionNode) {
        return visitInputValueDefinitionNode(inputValueDefinitionNode, dependencySet);
    });
}
function visitDirectiveDefinitionNode(node, dependencySet, dependenciesByDefinitionName) {
    var _a;
    dependencySet.add(node.name.value);
    (_a = node.arguments) === null || _a === void 0 ? void 0 : _a.forEach(function (inputValueDefinitionNode) {
        return visitInputValueDefinitionNode(inputValueDefinitionNode, dependencySet);
    });
}
function visitObjectTypeExtensionNode(node, dependencySet, dependenciesByDefinitionName) {
    var _a, _b, _c;
    var typeName = node.name.value;
    dependencySet.add(typeName);
    (_a = node.directives) === null || _a === void 0 ? void 0 : _a.forEach(function (directiveNode) { return visitDirectiveNode(directiveNode, dependencySet); });
    (_b = node.fields) === null || _b === void 0 ? void 0 : _b.forEach(function (fieldDefinitionNode) {
        return visitFieldDefinitionNode(fieldDefinitionNode, dependencySet);
    });
    (_c = node.interfaces) === null || _c === void 0 ? void 0 : _c.forEach(function (namedTypeNode) {
        visitNamedTypeNode(namedTypeNode, dependencySet);
        var interfaceName = namedTypeNode.name.value;
        // interface should be dependent to the type as well
        if (!dependenciesByDefinitionName.has(interfaceName)) {
            dependenciesByDefinitionName.set(interfaceName, new Set());
        }
        dependenciesByDefinitionName.get(interfaceName).add(typeName);
    });
}
function visitInterfaceTypeExtensionNode(node, dependencySet, dependenciesByDefinitionName) {
    var _a, _b, _c;
    var typeName = node.name.value;
    dependencySet.add(typeName);
    (_a = node.directives) === null || _a === void 0 ? void 0 : _a.forEach(function (directiveNode) { return visitDirectiveNode(directiveNode, dependencySet); });
    (_b = node.fields) === null || _b === void 0 ? void 0 : _b.forEach(function (fieldDefinitionNode) {
        return visitFieldDefinitionNode(fieldDefinitionNode, dependencySet);
    });
    (_c = node.interfaces) === null || _c === void 0 ? void 0 : _c.forEach(function (namedTypeNode) {
        visitNamedTypeNode(namedTypeNode, dependencySet);
        var interfaceName = namedTypeNode.name.value;
        // interface should be dependent to the type as well
        if (!dependenciesByDefinitionName.has(interfaceName)) {
            dependenciesByDefinitionName.set(interfaceName, new Set());
        }
        dependenciesByDefinitionName.get(interfaceName).add(typeName);
    });
}
function visitUnionTypeExtensionNode(node, dependencySet) {
    var _a;
    dependencySet.add(node.name.value);
    (_a = node.directives) === null || _a === void 0 ? void 0 : _a.forEach(function (directiveNode) { return visitDirectiveNode(directiveNode, dependencySet); });
    node.types.forEach(function (namedTypeNode) { return visitNamedTypeNode(namedTypeNode, dependencySet); });
}
function visitEnumTypeExtensionNode(node, dependencySet) {
    var _a;
    dependencySet.add(node.name.value);
    (_a = node.directives) === null || _a === void 0 ? void 0 : _a.forEach(function (directiveNode) { return visitDirectiveNode(directiveNode, dependencySet); });
}
function visitInputObjectTypeExtensionNode(node, dependencySet, dependenciesByDefinitionName) {
    var _a, _b;
    dependencySet.add(node.name.value);
    (_a = node.directives) === null || _a === void 0 ? void 0 : _a.forEach(function (directiveNode) { return visitDirectiveNode(directiveNode, dependencySet); });
    (_b = node.fields) === null || _b === void 0 ? void 0 : _b.forEach(function (inputValueDefinitionNode) {
        return visitInputValueDefinitionNode(inputValueDefinitionNode, dependencySet);
    });
}
function visitSchemaDefinitionNode(node, dependencySet) {
    var _a;
    dependencySet.add('schema');
    (_a = node.directives) === null || _a === void 0 ? void 0 : _a.forEach(function (directiveNode) { return visitDirectiveNode(directiveNode, dependencySet); });
    node.operationTypes.forEach(function (operationTypeDefinitionNode) {
        return visitOperationTypeDefinitionNode(operationTypeDefinitionNode, dependencySet);
    });
}
function visitScalarDefinitionNode(node, dependencySet) {
    var _a;
    dependencySet.add(node.name.value);
    (_a = node.directives) === null || _a === void 0 ? void 0 : _a.forEach(function (directiveNode) { return visitDirectiveNode(directiveNode, dependencySet); });
}
function visitScalarExtensionNode(node, dependencySet) {
    var _a;
    dependencySet.add(node.name.value);
    (_a = node.directives) === null || _a === void 0 ? void 0 : _a.forEach(function (directiveNode) { return visitDirectiveNode(directiveNode, dependencySet); });
}
function visitOperationTypeDefinitionNode(node, dependencySet) {
    visitNamedTypeNode(node.type, dependencySet);
}

exports.parseImportLine = parseImportLine;
exports.processImport = processImport;
//# sourceMappingURL=index.cjs.js.map
