'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const tslib = require('tslib');
const utils = require('@graphql-tools/utils/es5');
const path = require('path');
const fsExtra = require('fs-extra');
const process = require('process');

var FILE_EXTENSIONS = ['.json'];
/**
 * This loader loads documents and type definitions from JSON files.
 *
 * The JSON file can be the result of an introspection query made against a schema:
 *
 * ```js
 * const schema = await loadSchema('schema-introspection.json', {
 *   loaders: [
 *     new JsonFileLoader()
 *   ]
 * });
 * ```
 *
 * Or it can be a `DocumentNode` object representing a GraphQL document or type definitions:
 *
 * ```js
 * const documents = await loadDocuments('queries/*.json', {
 *   loaders: [
 *     new GraphQLFileLoader()
 *   ]
 * });
 * ```
 */
var JsonFileLoader = /** @class */ (function () {
    function JsonFileLoader() {
    }
    JsonFileLoader.prototype.loaderId = function () {
        return 'json-file';
    };
    JsonFileLoader.prototype.canLoad = function (pointer, options) {
        return tslib.__awaiter(this, void 0, void 0, function () {
            var normalizedFilePath;
            return tslib.__generator(this, function (_a) {
                if (utils.isValidPath(pointer)) {
                    if (FILE_EXTENSIONS.find(function (extension) { return pointer.endsWith(extension); })) {
                        normalizedFilePath = path.isAbsolute(pointer) ? pointer : path.resolve(options.cwd || process.cwd(), pointer);
                        return [2 /*return*/, fsExtra.pathExists(normalizedFilePath)];
                    }
                }
                return [2 /*return*/, false];
            });
        });
    };
    JsonFileLoader.prototype.canLoadSync = function (pointer, options) {
        if (utils.isValidPath(pointer)) {
            if (FILE_EXTENSIONS.find(function (extension) { return pointer.endsWith(extension); })) {
                var normalizedFilePath = path.isAbsolute(pointer) ? pointer : path.resolve(options.cwd || process.cwd(), pointer);
                return fsExtra.pathExistsSync(normalizedFilePath);
            }
        }
        return false;
    };
    JsonFileLoader.prototype.load = function (pointer, options) {
        return tslib.__awaiter(this, void 0, void 0, function () {
            var normalizedFilePath, jsonContent, e_1;
            return tslib.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        normalizedFilePath = path.isAbsolute(pointer) ? pointer : path.resolve(options.cwd || process.cwd(), pointer);
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 4]);
                        return [4 /*yield*/, fsExtra.readFile(normalizedFilePath, { encoding: 'utf8' })];
                    case 2:
                        jsonContent = _a.sent();
                        return [2 /*return*/, utils.parseGraphQLJSON(pointer, jsonContent, options)];
                    case 3:
                        e_1 = _a.sent();
                        throw new Error("Unable to read JSON file: " + normalizedFilePath + ": " + (e_1.message || /* istanbul ignore next */ e_1));
                    case 4: return [2 /*return*/];
                }
            });
        });
    };
    JsonFileLoader.prototype.loadSync = function (pointer, options) {
        var normalizedFilepath = path.isAbsolute(pointer) ? pointer : path.resolve(options.cwd || process.cwd(), pointer);
        try {
            var jsonContent = fsExtra.readFileSync(normalizedFilepath, 'utf8');
            return utils.parseGraphQLJSON(pointer, jsonContent, options);
        }
        catch (e) {
            throw new Error("Unable to read JSON file: " + normalizedFilepath + ": " + (e.message || /* istanbul ignore next */ e));
        }
    };
    return JsonFileLoader;
}());

exports.JsonFileLoader = JsonFileLoader;
//# sourceMappingURL=index.cjs.js.map
