"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class BranchSummaryResult {
    constructor() {
        this.all = [];
        this.branches = {};
        this.current = '';
        this.detached = false;
    }
    push(current, detached, name, commit, label) {
        if (current) {
            this.detached = detached;
            this.current = name;
        }
        this.all.push(name);
        this.branches[name] = {
            current: current,
            name: name,
            commit: commit,
            label: label
        };
    }
}
exports.BranchSummaryResult = BranchSummaryResult;
exports.detachedRegex = /^(\*?\s+)\((?:HEAD )?detached (?:from|at) (\S+)\)\s+([a-z0-9]+)\s(.*)$/;
exports.branchRegex = /^(\*?\s+)(\S+)\s+([a-z0-9]+)\s(.*)$/;
exports.parseBranchSummary = function (commit) {
    const branchSummary = new BranchSummaryResult();
    commit.split('\n')
        .forEach(function (line) {
        let detached = true;
        let branch = exports.detachedRegex.exec(line);
        if (!branch) {
            detached = false;
            branch = exports.branchRegex.exec(line);
        }
        if (branch) {
            branchSummary.push(branch[1].charAt(0) === '*', detached, branch[2], branch[3], branch[4]);
        }
    });
    return branchSummary;
};
//# sourceMappingURL=BranchSummary.js.map