'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

exports.isAbsolute = isAbsolute;
exports.isBuiltIn = isBuiltIn;
exports.isExternalModule = isExternalModule;
exports.isExternalModuleMain = isExternalModuleMain;
exports.isScoped = isScoped;
exports.isScopedMain = isScopedMain;
exports.isScopedModule = isScopedModule;
exports.default = resolveImportType;

var _core = require('resolve/lib/core');

var _core2 = _interopRequireDefault(_core);

var _resolve = require('eslint-module-utils/resolve');

var _resolve2 = _interopRequireDefault(_resolve);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function baseModule(name) {
  if (isScoped(name)) {
    var _name$split = name.split('/'),
        _name$split2 = _slicedToArray(_name$split, 2);

    const scope = _name$split2[0],
          pkg = _name$split2[1];

    return `${scope}/${pkg}`;
  }

  var _name$split3 = name.split('/'),
      _name$split4 = _slicedToArray(_name$split3, 1);

  const pkg = _name$split4[0];

  return pkg;
}

function isAbsolute(name) {
  return name && name.startsWith('/');
}

// path is defined only when a resolver resolves to a non-standard path
function isBuiltIn(name, settings, path) {
  if (path || !name) return false;
  const base = baseModule(name);
  const extras = settings && settings['import/core-modules'] || [];
  return _core2.default[base] || extras.indexOf(base) > -1;
}

function isExternalPath(path, name, settings) {
  const folders = settings && settings['import/external-module-folders'] || ['node_modules'];
  return !path || folders.some(folder => isSubpath(folder, path));
}

function isSubpath(subpath, path) {
  const normPath = path.replace(/\\/g, '/');
  const normSubpath = subpath.replace(/\\/g, '/').replace(/\/$/, '');
  if (normSubpath.length === 0) {
    return false;
  }
  const left = normPath.indexOf(normSubpath);
  const right = left + normSubpath.length;
  return left !== -1 && (left === 0 || normSubpath[0] !== '/' && normPath[left - 1] === '/') && (right >= normPath.length || normPath[right] === '/');
}

const externalModuleRegExp = /^\w/;
function isExternalModule(name, settings, path) {
  return externalModuleRegExp.test(name) && isExternalPath(path, name, settings);
}

const externalModuleMainRegExp = /^[\w]((?!\/).)*$/;
function isExternalModuleMain(name, settings, path) {
  return externalModuleMainRegExp.test(name) && isExternalPath(path, name, settings);
}

const scopedRegExp = /^@[^/]*\/?[^/]+/;
function isScoped(name) {
  return name && scopedRegExp.test(name);
}

const scopedMainRegExp = /^@[^/]+\/?[^/]+$/;
function isScopedMain(name) {
  return name && scopedMainRegExp.test(name);
}

function isInternalModule(name, settings, path) {
  const internalScope = settings && settings['import/internal-regex'];
  const matchesScopedOrExternalRegExp = scopedRegExp.test(name) || externalModuleRegExp.test(name);
  return matchesScopedOrExternalRegExp && (internalScope && new RegExp(internalScope).test(name) || !isExternalPath(path, name, settings));
}

function isRelativeToParent(name) {
  return (/^\.\.$|^\.\.[\\/]/.test(name)
  );
}

const indexFiles = ['.', './', './index', './index.js'];
function isIndex(name) {
  return indexFiles.indexOf(name) !== -1;
}

function isRelativeToSibling(name) {
  return (/^\.[\\/]/.test(name)
  );
}

function typeTest(name, settings, path) {
  if (isAbsolute(name, settings, path)) {
    return 'absolute';
  }
  if (isBuiltIn(name, settings, path)) {
    return 'builtin';
  }
  if (isInternalModule(name, settings, path)) {
    return 'internal';
  }
  if (isExternalModule(name, settings, path)) {
    return 'external';
  }
  if (isScoped(name, settings, path)) {
    return 'external';
  }
  if (isRelativeToParent(name, settings, path)) {
    return 'parent';
  }
  if (isIndex(name, settings, path)) {
    return 'index';
  }
  if (isRelativeToSibling(name, settings, path)) {
    return 'sibling';
  }
  return 'unknown';
}

function isScopedModule(name) {
  return name.indexOf('@') === 0;
}

function resolveImportType(name, context) {
  return typeTest(name, context.settings, (0, _resolve2.default)(name, context));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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