/**
 * Represents the status of a single branch deletion
 */
export interface BranchDeletionSummary {
    branch: string;
    hash: string | null;
    readonly success: boolean;
}
/**
 * Represents the status of having deleted a batch of branches
 */
export interface BranchDeletionBatchSummary {
    /**
     * All branches included in the response
     */
    all: BranchDeletionSummary[];
    /**
     * Branches mapped by their branch name
     */
    branches: {
        [branchName: string]: BranchDeletionSummary;
    };
    /**
     * Array of responses that are in error
     */
    errors: BranchDeletionSummary[];
    /**
     * Flag showing whether all branches were deleted successfully
     */
    readonly success: boolean;
}
export declare class BranchDeletionBatch implements BranchDeletionBatchSummary {
    all: BranchDeletionSummary[];
    branches: {
        [branchName: string]: BranchDeletionSummary;
    };
    errors: BranchDeletionSummary[];
    get success(): boolean;
}
export declare class BranchDeletion implements BranchDeletionSummary {
    branch: string;
    hash: string | null;
    constructor(branch: string, hash: string | null);
    get success(): boolean;
}
export declare const deleteSuccessRegex: RegExp;
export declare const deleteErrorRegex: RegExp;
export declare function hasBranchDeletionError(data: string, processExitCode?: number): boolean;
export declare function parseBranchDeletions(data: string): BranchDeletionBatch;
