'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
/**
 * Copyright (c) 2014-present, Facebook, Inc. All rights reserved.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 */

class NotFoundPackageJsonError extends Error {
  constructor(rootDir) {
    super();
    this.name = '';
    this.message = `Could not find a "package.json" file in ${rootDir}`;
    Error.captureStackTrace(this, () => {});
  }
}

exports.NotFoundPackageJsonError = NotFoundPackageJsonError;
class MalformedPackageJsonError extends Error {
  constructor(packageJsonPath) {
    super();
    this.name = '';
    this.message =
      `There is malformed json in ${packageJsonPath}\n` +
      'Fix it, and then run "jest --init"';
    Error.captureStackTrace(this, () => {});
  }
}
exports.MalformedPackageJsonError = MalformedPackageJsonError;
