// This file was automatically generated by informer-gen

package v1

import (
	oauth_v1 "github.com/openshift/api/oauth/v1"
	versioned "github.com/openshift/client-go/oauth/clientset/versioned"
	internalinterfaces "github.com/openshift/client-go/oauth/informers/externalversions/internalinterfaces"
	v1 "github.com/openshift/client-go/oauth/listers/oauth/v1"
	meta_v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
	time "time"
)

// OAuthClientAuthorizationInformer provides access to a shared informer and lister for
// OAuthClientAuthorizations.
type OAuthClientAuthorizationInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1.OAuthClientAuthorizationLister
}

type oAuthClientAuthorizationInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
}

// NewOAuthClientAuthorizationInformer constructs a new informer for OAuthClientAuthorization type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewOAuthClientAuthorizationInformer(client versioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredOAuthClientAuthorizationInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredOAuthClientAuthorizationInformer constructs a new informer for OAuthClientAuthorization type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredOAuthClientAuthorizationInformer(client versioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options meta_v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.OauthV1().OAuthClientAuthorizations().List(options)
			},
			WatchFunc: func(options meta_v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.OauthV1().OAuthClientAuthorizations().Watch(options)
			},
		},
		&oauth_v1.OAuthClientAuthorization{},
		resyncPeriod,
		indexers,
	)
}

func (f *oAuthClientAuthorizationInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredOAuthClientAuthorizationInformer(client, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *oAuthClientAuthorizationInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&oauth_v1.OAuthClientAuthorization{}, f.defaultInformer)
}

func (f *oAuthClientAuthorizationInformer) Lister() v1.OAuthClientAuthorizationLister {
	return v1.NewOAuthClientAuthorizationLister(f.Informer().GetIndexer())
}
