// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	scheme "open-cluster-management.io/api/client/operator/clientset/versioned/scheme"
	v1 "open-cluster-management.io/api/operator/v1"
)

// ClusterManagersGetter has a method to return a ClusterManagerInterface.
// A group's client should implement this interface.
type ClusterManagersGetter interface {
	ClusterManagers() ClusterManagerInterface
}

// ClusterManagerInterface has methods to work with ClusterManager resources.
type ClusterManagerInterface interface {
	Create(ctx context.Context, clusterManager *v1.ClusterManager, opts metav1.CreateOptions) (*v1.ClusterManager, error)
	Update(ctx context.Context, clusterManager *v1.ClusterManager, opts metav1.UpdateOptions) (*v1.ClusterManager, error)
	UpdateStatus(ctx context.Context, clusterManager *v1.ClusterManager, opts metav1.UpdateOptions) (*v1.ClusterManager, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.ClusterManager, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.ClusterManagerList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ClusterManager, err error)
	ClusterManagerExpansion
}

// clusterManagers implements ClusterManagerInterface
type clusterManagers struct {
	client rest.Interface
}

// newClusterManagers returns a ClusterManagers
func newClusterManagers(c *OperatorV1Client) *clusterManagers {
	return &clusterManagers{
		client: c.RESTClient(),
	}
}

// Get takes name of the clusterManager, and returns the corresponding clusterManager object, and an error if there is any.
func (c *clusterManagers) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.ClusterManager, err error) {
	result = &v1.ClusterManager{}
	err = c.client.Get().
		Resource("clustermanagers").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ClusterManagers that match those selectors.
func (c *clusterManagers) List(ctx context.Context, opts metav1.ListOptions) (result *v1.ClusterManagerList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ClusterManagerList{}
	err = c.client.Get().
		Resource("clustermanagers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested clusterManagers.
func (c *clusterManagers) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("clustermanagers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a clusterManager and creates it.  Returns the server's representation of the clusterManager, and an error, if there is any.
func (c *clusterManagers) Create(ctx context.Context, clusterManager *v1.ClusterManager, opts metav1.CreateOptions) (result *v1.ClusterManager, err error) {
	result = &v1.ClusterManager{}
	err = c.client.Post().
		Resource("clustermanagers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(clusterManager).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a clusterManager and updates it. Returns the server's representation of the clusterManager, and an error, if there is any.
func (c *clusterManagers) Update(ctx context.Context, clusterManager *v1.ClusterManager, opts metav1.UpdateOptions) (result *v1.ClusterManager, err error) {
	result = &v1.ClusterManager{}
	err = c.client.Put().
		Resource("clustermanagers").
		Name(clusterManager.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(clusterManager).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *clusterManagers) UpdateStatus(ctx context.Context, clusterManager *v1.ClusterManager, opts metav1.UpdateOptions) (result *v1.ClusterManager, err error) {
	result = &v1.ClusterManager{}
	err = c.client.Put().
		Resource("clustermanagers").
		Name(clusterManager.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(clusterManager).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the clusterManager and deletes it. Returns an error if one occurs.
func (c *clusterManagers) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("clustermanagers").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *clusterManagers) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("clustermanagers").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched clusterManager.
func (c *clusterManagers) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ClusterManager, err error) {
	result = &v1.ClusterManager{}
	err = c.client.Patch(pt).
		Resource("clustermanagers").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
