// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteAdmChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAdmChannelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAdmChannelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteAdmChannelInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteAdmChannelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteAdmChannelOutput struct {
	_ struct{} `type:"structure" payload:"ADMChannelResponse"`

	// Provides information about the status and settings of the ADM (Amazon Device
	// Messaging) channel for an application.
	//
	// ADMChannelResponse is a required field
	ADMChannelResponse *ADMChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteAdmChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteAdmChannelOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ADMChannelResponse != nil {
		v := s.ADMChannelResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "ADMChannelResponse", v, metadata)
	}
	return nil
}

const opDeleteAdmChannel = "DeleteAdmChannel"

// DeleteAdmChannelRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Disables the ADM channel for an application and deletes any existing settings
// for the channel.
//
//    // Example sending a request using DeleteAdmChannelRequest.
//    req := client.DeleteAdmChannelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteAdmChannel
func (c *Client) DeleteAdmChannelRequest(input *DeleteAdmChannelInput) DeleteAdmChannelRequest {
	op := &aws.Operation{
		Name:       opDeleteAdmChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/adm",
	}

	if input == nil {
		input = &DeleteAdmChannelInput{}
	}

	req := c.newRequest(op, input, &DeleteAdmChannelOutput{})
	return DeleteAdmChannelRequest{Request: req, Input: input, Copy: c.DeleteAdmChannelRequest}
}

// DeleteAdmChannelRequest is the request type for the
// DeleteAdmChannel API operation.
type DeleteAdmChannelRequest struct {
	*aws.Request
	Input *DeleteAdmChannelInput
	Copy  func(*DeleteAdmChannelInput) DeleteAdmChannelRequest
}

// Send marshals and sends the DeleteAdmChannel API request.
func (r DeleteAdmChannelRequest) Send(ctx context.Context) (*DeleteAdmChannelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteAdmChannelResponse{
		DeleteAdmChannelOutput: r.Request.Data.(*DeleteAdmChannelOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteAdmChannelResponse is the response type for the
// DeleteAdmChannel API operation.
type DeleteAdmChannelResponse struct {
	*DeleteAdmChannelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteAdmChannel request.
func (r *DeleteAdmChannelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
