// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetMLTaskRunInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the task run.
	//
	// TaskRunId is a required field
	TaskRunId *string `min:"1" type:"string" required:"true"`

	// The unique identifier of the machine learning transform.
	//
	// TransformId is a required field
	TransformId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMLTaskRunInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMLTaskRunInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetMLTaskRunInput"}

	if s.TaskRunId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskRunId"))
	}
	if s.TaskRunId != nil && len(*s.TaskRunId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TaskRunId", 1))
	}

	if s.TransformId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransformId"))
	}
	if s.TransformId != nil && len(*s.TransformId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TransformId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetMLTaskRunOutput struct {
	_ struct{} `type:"structure"`

	// The date and time when this task run was completed.
	CompletedOn *time.Time `type:"timestamp"`

	// The error strings that are associated with the task run.
	ErrorString *string `type:"string"`

	// The amount of time (in seconds) that the task run consumed resources.
	ExecutionTime *int64 `type:"integer"`

	// The date and time when this task run was last modified.
	LastModifiedOn *time.Time `type:"timestamp"`

	// The names of the log groups that are associated with the task run.
	LogGroupName *string `type:"string"`

	// The list of properties that are associated with the task run.
	Properties *TaskRunProperties `type:"structure"`

	// The date and time when this task run started.
	StartedOn *time.Time `type:"timestamp"`

	// The status for this task run.
	Status TaskStatusType `type:"string" enum:"true"`

	// The unique run identifier associated with this run.
	TaskRunId *string `min:"1" type:"string"`

	// The unique identifier of the task run.
	TransformId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetMLTaskRunOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetMLTaskRun = "GetMLTaskRun"

// GetMLTaskRunRequest returns a request value for making API operation for
// AWS Glue.
//
// Gets details for a specific task run on a machine learning transform. Machine
// learning task runs are asynchronous tasks that AWS Glue runs on your behalf
// as part of various machine learning workflows. You can check the stats of
// any task run by calling GetMLTaskRun with the TaskRunID and its parent transform's
// TransformID.
//
//    // Example sending a request using GetMLTaskRunRequest.
//    req := client.GetMLTaskRunRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMLTaskRun
func (c *Client) GetMLTaskRunRequest(input *GetMLTaskRunInput) GetMLTaskRunRequest {
	op := &aws.Operation{
		Name:       opGetMLTaskRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMLTaskRunInput{}
	}

	req := c.newRequest(op, input, &GetMLTaskRunOutput{})
	return GetMLTaskRunRequest{Request: req, Input: input, Copy: c.GetMLTaskRunRequest}
}

// GetMLTaskRunRequest is the request type for the
// GetMLTaskRun API operation.
type GetMLTaskRunRequest struct {
	*aws.Request
	Input *GetMLTaskRunInput
	Copy  func(*GetMLTaskRunInput) GetMLTaskRunRequest
}

// Send marshals and sends the GetMLTaskRun API request.
func (r GetMLTaskRunRequest) Send(ctx context.Context) (*GetMLTaskRunResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetMLTaskRunResponse{
		GetMLTaskRunOutput: r.Request.Data.(*GetMLTaskRunOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetMLTaskRunResponse is the response type for the
// GetMLTaskRun API operation.
type GetMLTaskRunResponse struct {
	*GetMLTaskRunOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetMLTaskRun request.
func (r *GetMLTaskRunResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
