// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigatewayv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetIntegrationResponseInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// IntegrationId is a required field
	IntegrationId *string `location:"uri" locationName:"integrationId" type:"string" required:"true"`

	// IntegrationResponseId is a required field
	IntegrationResponseId *string `location:"uri" locationName:"integrationResponseId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetIntegrationResponseInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIntegrationResponseInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetIntegrationResponseInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if s.IntegrationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IntegrationId"))
	}

	if s.IntegrationResponseId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IntegrationResponseId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetIntegrationResponseInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IntegrationId != nil {
		v := *s.IntegrationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "integrationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IntegrationResponseId != nil {
		v := *s.IntegrationResponseId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "integrationResponseId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetIntegrationResponseOutput struct {
	_ struct{} `type:"structure"`

	// Specifies how to handle response payload content type conversions. Supported
	// only for WebSocket APIs.
	ContentHandlingStrategy ContentHandlingStrategy `locationName:"contentHandlingStrategy" type:"string" enum:"true"`

	// The identifier.
	IntegrationResponseId *string `locationName:"integrationResponseId" type:"string"`

	// After evaluating a selection expression, the result is compared against one
	// or more selection keys to find a matching key. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for a list of expressions and each expression's associated selection key
	// type.
	IntegrationResponseKey *string `locationName:"integrationResponseKey" type:"string"`

	// A key-value map specifying response parameters that are passed to the method
	// response from the backend. The key is a method response header parameter
	// name and the mapped value is an integration response header value, a static
	// value enclosed within a pair of single quotes, or a JSON expression from
	// the integration response body. The mapping key must match the pattern of
	// method.response.header.{name}, where name is a valid and unique header name.
	// The mapped non-static value must match the pattern of integration.response.header.{name}
	// or integration.response.body.{JSON-expression}, where name is a valid and
	// unique response header name and JSON-expression is a valid JSON expression
	// without the $ prefix.
	ResponseParameters map[string]string `locationName:"responseParameters" type:"map"`

	// A mapping of identifier keys to templates. The value is an actual template
	// script. The key is typically a SelectionKey which is chosen based on evaluating
	// a selection expression.
	ResponseTemplates map[string]string `locationName:"responseTemplates" type:"map"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	TemplateSelectionExpression *string `locationName:"templateSelectionExpression" type:"string"`
}

// String returns the string representation
func (s GetIntegrationResponseOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetIntegrationResponseOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ContentHandlingStrategy) > 0 {
		v := s.ContentHandlingStrategy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "contentHandlingStrategy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.IntegrationResponseId != nil {
		v := *s.IntegrationResponseId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "integrationResponseId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IntegrationResponseKey != nil {
		v := *s.IntegrationResponseKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "integrationResponseKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResponseParameters != nil {
		v := s.ResponseParameters

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "responseParameters", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.ResponseTemplates != nil {
		v := s.ResponseTemplates

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "responseTemplates", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TemplateSelectionExpression != nil {
		v := *s.TemplateSelectionExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "templateSelectionExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetIntegrationResponse = "GetIntegrationResponse"

// GetIntegrationResponseRequest returns a request value for making API operation for
// AmazonApiGatewayV2.
//
// Gets an IntegrationResponses.
//
//    // Example sending a request using GetIntegrationResponseRequest.
//    req := client.GetIntegrationResponseRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetIntegrationResponse
func (c *Client) GetIntegrationResponseRequest(input *GetIntegrationResponseInput) GetIntegrationResponseRequest {
	op := &aws.Operation{
		Name:       opGetIntegrationResponse,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}/integrations/{integrationId}/integrationresponses/{integrationResponseId}",
	}

	if input == nil {
		input = &GetIntegrationResponseInput{}
	}

	req := c.newRequest(op, input, &GetIntegrationResponseOutput{})
	return GetIntegrationResponseRequest{Request: req, Input: input, Copy: c.GetIntegrationResponseRequest}
}

// GetIntegrationResponseRequest is the request type for the
// GetIntegrationResponse API operation.
type GetIntegrationResponseRequest struct {
	*aws.Request
	Input *GetIntegrationResponseInput
	Copy  func(*GetIntegrationResponseInput) GetIntegrationResponseRequest
}

// Send marshals and sends the GetIntegrationResponse API request.
func (r GetIntegrationResponseRequest) Send(ctx context.Context) (*GetIntegrationResponseResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetIntegrationResponseResponse{
		GetIntegrationResponseOutput: r.Request.Data.(*GetIntegrationResponseOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetIntegrationResponseResponse is the response type for the
// GetIntegrationResponse API operation.
type GetIntegrationResponseResponse struct {
	*GetIntegrationResponseOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetIntegrationResponse request.
func (r *GetIntegrationResponseResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
