package storagetables

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ServiceClient is the client for the Service methods of the Storagetables service.
type ServiceClient struct {
	BaseClient
}

// NewServiceClient creates an instance of the ServiceClient client.
func NewServiceClient(URL string) ServiceClient {
	return ServiceClient{New(URL)}
}

// GetProperties gets the properties of an account's Table service, including properties for Analytics and CORS
// (Cross-Origin Resource Sharing) rules.
// Parameters:
// timeout - the timeout parameter is expressed in seconds.
// requestID - provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
// analytics logs when analytics logging is enabled.
func (client ServiceClient) GetProperties(ctx context.Context, timeout *int32, requestID string) (result TableServiceProperties, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceClient.GetProperties")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: timeout,
			Constraints: []validation.Constraint{{Target: "timeout", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "timeout", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("storagetables.ServiceClient", "GetProperties", err.Error())
	}

	req, err := client.GetPropertiesPreparer(ctx, timeout, requestID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.ServiceClient", "GetProperties", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPropertiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storagetables.ServiceClient", "GetProperties", resp, "Failure sending request")
		return
	}

	result, err = client.GetPropertiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.ServiceClient", "GetProperties", resp, "Failure responding to request")
	}

	return
}

// GetPropertiesPreparer prepares the GetProperties request.
func (client ServiceClient) GetPropertiesPreparer(ctx context.Context, timeout *int32, requestID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.URL,
	}

	queryParameters := map[string]interface{}{
		"comp":    autorest.Encode("query", "properties"),
		"restype": autorest.Encode("query", "service"),
	}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPath("/"),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("x-ms-version", "2019-02-02"))
	if len(requestID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-client-request-id", autorest.String(requestID)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPropertiesSender sends the GetProperties request. The method will close the
// http.Response Body if it receives an error.
func (client ServiceClient) GetPropertiesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetPropertiesResponder handles the response to the GetProperties request. The method always
// closes the http.Response Body.
func (client ServiceClient) GetPropertiesResponder(resp *http.Response) (result TableServiceProperties, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetStatistics retrieves statistics related to replication for the Table service. It is only available on the
// secondary location endpoint when read-access geo-redundant replication is enabled for the account.
// Parameters:
// timeout - the timeout parameter is expressed in seconds.
// requestID - provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
// analytics logs when analytics logging is enabled.
func (client ServiceClient) GetStatistics(ctx context.Context, timeout *int32, requestID string) (result TableServiceStats, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceClient.GetStatistics")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: timeout,
			Constraints: []validation.Constraint{{Target: "timeout", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "timeout", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("storagetables.ServiceClient", "GetStatistics", err.Error())
	}

	req, err := client.GetStatisticsPreparer(ctx, timeout, requestID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.ServiceClient", "GetStatistics", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetStatisticsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storagetables.ServiceClient", "GetStatistics", resp, "Failure sending request")
		return
	}

	result, err = client.GetStatisticsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.ServiceClient", "GetStatistics", resp, "Failure responding to request")
	}

	return
}

// GetStatisticsPreparer prepares the GetStatistics request.
func (client ServiceClient) GetStatisticsPreparer(ctx context.Context, timeout *int32, requestID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.URL,
	}

	queryParameters := map[string]interface{}{
		"comp":    autorest.Encode("query", "stats"),
		"restype": autorest.Encode("query", "service"),
	}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPath("/"),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("x-ms-version", "2019-02-02"))
	if len(requestID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-client-request-id", autorest.String(requestID)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetStatisticsSender sends the GetStatistics request. The method will close the
// http.Response Body if it receives an error.
func (client ServiceClient) GetStatisticsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetStatisticsResponder handles the response to the GetStatistics request. The method always
// closes the http.Response Body.
func (client ServiceClient) GetStatisticsResponder(resp *http.Response) (result TableServiceStats, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SetProperties sets properties for an account's Table service endpoint, including properties for Analytics and CORS
// (Cross-Origin Resource Sharing) rules.
// Parameters:
// tableServiceProperties - the Table Service properties.
// timeout - the timeout parameter is expressed in seconds.
// requestID - provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
// analytics logs when analytics logging is enabled.
func (client ServiceClient) SetProperties(ctx context.Context, tableServiceProperties TableServiceProperties, timeout *int32, requestID string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceClient.SetProperties")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: tableServiceProperties,
			Constraints: []validation.Constraint{{Target: "tableServiceProperties.Logging", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "tableServiceProperties.Logging.Version", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "tableServiceProperties.Logging.Delete", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "tableServiceProperties.Logging.Read", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "tableServiceProperties.Logging.Write", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "tableServiceProperties.Logging.RetentionPolicy", Name: validation.Null, Rule: true,
						Chain: []validation.Constraint{{Target: "tableServiceProperties.Logging.RetentionPolicy.Enabled", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "tableServiceProperties.Logging.RetentionPolicy.Days", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "tableServiceProperties.Logging.RetentionPolicy.Days", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil}}},
						}},
				}},
				{Target: "tableServiceProperties.HourMetrics", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "tableServiceProperties.HourMetrics.Enabled", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "tableServiceProperties.HourMetrics.RetentionPolicy", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "tableServiceProperties.HourMetrics.RetentionPolicy.Enabled", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "tableServiceProperties.HourMetrics.RetentionPolicy.Days", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "tableServiceProperties.HourMetrics.RetentionPolicy.Days", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil}}},
							}},
					}},
				{Target: "tableServiceProperties.MinuteMetrics", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "tableServiceProperties.MinuteMetrics.Enabled", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "tableServiceProperties.MinuteMetrics.RetentionPolicy", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "tableServiceProperties.MinuteMetrics.RetentionPolicy.Enabled", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "tableServiceProperties.MinuteMetrics.RetentionPolicy.Days", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "tableServiceProperties.MinuteMetrics.RetentionPolicy.Days", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil}}},
							}},
					}}}},
		{TargetValue: timeout,
			Constraints: []validation.Constraint{{Target: "timeout", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "timeout", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("storagetables.ServiceClient", "SetProperties", err.Error())
	}

	req, err := client.SetPropertiesPreparer(ctx, tableServiceProperties, timeout, requestID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.ServiceClient", "SetProperties", nil, "Failure preparing request")
		return
	}

	resp, err := client.SetPropertiesSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "storagetables.ServiceClient", "SetProperties", resp, "Failure sending request")
		return
	}

	result, err = client.SetPropertiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.ServiceClient", "SetProperties", resp, "Failure responding to request")
	}

	return
}

// SetPropertiesPreparer prepares the SetProperties request.
func (client ServiceClient) SetPropertiesPreparer(ctx context.Context, tableServiceProperties TableServiceProperties, timeout *int32, requestID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.URL,
	}

	queryParameters := map[string]interface{}{
		"comp":    autorest.Encode("query", "properties"),
		"restype": autorest.Encode("query", "service"),
	}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/xml; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPath("/"),
		autorest.WithJSON(tableServiceProperties),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("x-ms-version", "2019-02-02"))
	if len(requestID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-client-request-id", autorest.String(requestID)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SetPropertiesSender sends the SetProperties request. The method will close the
// http.Response Body if it receives an error.
func (client ServiceClient) SetPropertiesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// SetPropertiesResponder handles the response to the SetProperties request. The method always
// closes the http.Response Body.
func (client ServiceClient) SetPropertiesResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}
