package appplatform

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/appplatform/mgmt/2019-05-01-preview/appplatform"

// AppResource app resource payload
type AppResource struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the App resource
	Properties *AppResourceProperties `json:"properties,omitempty"`
	// Identity - The Managed Identity type of the app resource
	Identity *ManagedIdentityProperties `json:"identity,omitempty"`
	// Location - The GEO location of the application, always the same with its parent resource
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AppResource.
func (ar AppResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.Properties != nil {
		objectMap["properties"] = ar.Properties
	}
	if ar.Identity != nil {
		objectMap["identity"] = ar.Identity
	}
	if ar.Location != nil {
		objectMap["location"] = ar.Location
	}
	return json.Marshal(objectMap)
}

// AppResourceCollection object that includes an array of App resources and a possible link for next set
type AppResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of App resources
	Value *[]AppResource `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// AppResourceCollectionIterator provides access to a complete listing of AppResource values.
type AppResourceCollectionIterator struct {
	i    int
	page AppResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AppResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AppResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AppResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AppResourceCollectionIterator) Response() AppResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AppResourceCollectionIterator) Value() AppResource {
	if !iter.page.NotDone() {
		return AppResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AppResourceCollectionIterator type.
func NewAppResourceCollectionIterator(page AppResourceCollectionPage) AppResourceCollectionIterator {
	return AppResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (arc AppResourceCollection) IsEmpty() bool {
	return arc.Value == nil || len(*arc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (arc AppResourceCollection) hasNextLink() bool {
	return arc.NextLink != nil && len(*arc.NextLink) != 0
}

// appResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (arc AppResourceCollection) appResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !arc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(arc.NextLink)))
}

// AppResourceCollectionPage contains a page of AppResource values.
type AppResourceCollectionPage struct {
	fn  func(context.Context, AppResourceCollection) (AppResourceCollection, error)
	arc AppResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AppResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.arc)
		if err != nil {
			return err
		}
		page.arc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AppResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AppResourceCollectionPage) NotDone() bool {
	return !page.arc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AppResourceCollectionPage) Response() AppResourceCollection {
	return page.arc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AppResourceCollectionPage) Values() []AppResource {
	if page.arc.IsEmpty() {
		return nil
	}
	return *page.arc.Value
}

// Creates a new instance of the AppResourceCollectionPage type.
func NewAppResourceCollectionPage(getNextPage func(context.Context, AppResourceCollection) (AppResourceCollection, error)) AppResourceCollectionPage {
	return AppResourceCollectionPage{fn: getNextPage}
}

// AppResourceProperties app resource properties payload
type AppResourceProperties struct {
	// Public - Indicates whether the App exposes public endpoint
	Public *bool `json:"public,omitempty"`
	// URL - READ-ONLY; URL of the App
	URL *string `json:"url,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the App. Possible values include: 'Succeeded', 'Failed', 'Creating', 'Updating'
	ProvisioningState AppResourceProvisioningState `json:"provisioningState,omitempty"`
	// ActiveDeploymentName - Name of the active deployment of the App
	ActiveDeploymentName *string `json:"activeDeploymentName,omitempty"`
	// Fqdn - Fully qualified dns Name.
	Fqdn *string `json:"fqdn,omitempty"`
	// HTTPSOnly - Indicate if only https is allowed.
	HTTPSOnly *bool `json:"httpsOnly,omitempty"`
	// CreatedTime - READ-ONLY; Date time when the resource is created
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// TemporaryDisk - Temporary disk settings
	TemporaryDisk *TemporaryDisk `json:"temporaryDisk,omitempty"`
	// PersistentDisk - Persistent disk settings
	PersistentDisk *PersistentDisk `json:"persistentDisk,omitempty"`
}

// MarshalJSON is the custom marshaler for AppResourceProperties.
func (arp AppResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arp.Public != nil {
		objectMap["public"] = arp.Public
	}
	if arp.ActiveDeploymentName != nil {
		objectMap["activeDeploymentName"] = arp.ActiveDeploymentName
	}
	if arp.Fqdn != nil {
		objectMap["fqdn"] = arp.Fqdn
	}
	if arp.HTTPSOnly != nil {
		objectMap["httpsOnly"] = arp.HTTPSOnly
	}
	if arp.TemporaryDisk != nil {
		objectMap["temporaryDisk"] = arp.TemporaryDisk
	}
	if arp.PersistentDisk != nil {
		objectMap["persistentDisk"] = arp.PersistentDisk
	}
	return json.Marshal(objectMap)
}

// AppsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsCreateOrUpdateFuture) Result(client AppsClient) (ar AppResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.AppsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("appplatform.AppsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ar.Response.Response, err = future.GetResult(sender); err == nil && ar.Response.Response.StatusCode != http.StatusNoContent {
		ar, err = client.CreateOrUpdateResponder(ar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.AppsCreateOrUpdateFuture", "Result", ar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type AppsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AppsUpdateFuture) Result(client AppsClient) (ar AppResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.AppsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("appplatform.AppsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ar.Response.Response, err = future.GetResult(sender); err == nil && ar.Response.Response.StatusCode != http.StatusNoContent {
		ar, err = client.UpdateResponder(ar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.AppsUpdateFuture", "Result", ar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AvailableOperations available operations of the service
type AvailableOperations struct {
	autorest.Response `json:"-"`
	// Value - Collection of available operation details
	Value *[]OperationDetail `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// AvailableOperationsIterator provides access to a complete listing of OperationDetail values.
type AvailableOperationsIterator struct {
	i    int
	page AvailableOperationsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AvailableOperationsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableOperationsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AvailableOperationsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AvailableOperationsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AvailableOperationsIterator) Response() AvailableOperations {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AvailableOperationsIterator) Value() OperationDetail {
	if !iter.page.NotDone() {
		return OperationDetail{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AvailableOperationsIterator type.
func NewAvailableOperationsIterator(page AvailableOperationsPage) AvailableOperationsIterator {
	return AvailableOperationsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ao AvailableOperations) IsEmpty() bool {
	return ao.Value == nil || len(*ao.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ao AvailableOperations) hasNextLink() bool {
	return ao.NextLink != nil && len(*ao.NextLink) != 0
}

// availableOperationsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ao AvailableOperations) availableOperationsPreparer(ctx context.Context) (*http.Request, error) {
	if !ao.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ao.NextLink)))
}

// AvailableOperationsPage contains a page of OperationDetail values.
type AvailableOperationsPage struct {
	fn func(context.Context, AvailableOperations) (AvailableOperations, error)
	ao AvailableOperations
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AvailableOperationsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableOperationsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ao)
		if err != nil {
			return err
		}
		page.ao = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AvailableOperationsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AvailableOperationsPage) NotDone() bool {
	return !page.ao.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AvailableOperationsPage) Response() AvailableOperations {
	return page.ao
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AvailableOperationsPage) Values() []OperationDetail {
	if page.ao.IsEmpty() {
		return nil
	}
	return *page.ao.Value
}

// Creates a new instance of the AvailableOperationsPage type.
func NewAvailableOperationsPage(getNextPage func(context.Context, AvailableOperations) (AvailableOperations, error)) AvailableOperationsPage {
	return AvailableOperationsPage{fn: getNextPage}
}

// BindingResource binding resource payload
type BindingResource struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the Binding resource
	Properties *BindingResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BindingResource.
func (br BindingResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if br.Properties != nil {
		objectMap["properties"] = br.Properties
	}
	return json.Marshal(objectMap)
}

// BindingResourceCollection object that includes an array of Binding resources and a possible link for next
// set
type BindingResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of Binding resources
	Value *[]BindingResource `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// BindingResourceCollectionIterator provides access to a complete listing of BindingResource values.
type BindingResourceCollectionIterator struct {
	i    int
	page BindingResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BindingResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BindingResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BindingResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BindingResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BindingResourceCollectionIterator) Response() BindingResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BindingResourceCollectionIterator) Value() BindingResource {
	if !iter.page.NotDone() {
		return BindingResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BindingResourceCollectionIterator type.
func NewBindingResourceCollectionIterator(page BindingResourceCollectionPage) BindingResourceCollectionIterator {
	return BindingResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (brc BindingResourceCollection) IsEmpty() bool {
	return brc.Value == nil || len(*brc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (brc BindingResourceCollection) hasNextLink() bool {
	return brc.NextLink != nil && len(*brc.NextLink) != 0
}

// bindingResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (brc BindingResourceCollection) bindingResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !brc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(brc.NextLink)))
}

// BindingResourceCollectionPage contains a page of BindingResource values.
type BindingResourceCollectionPage struct {
	fn  func(context.Context, BindingResourceCollection) (BindingResourceCollection, error)
	brc BindingResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BindingResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BindingResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.brc)
		if err != nil {
			return err
		}
		page.brc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BindingResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BindingResourceCollectionPage) NotDone() bool {
	return !page.brc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BindingResourceCollectionPage) Response() BindingResourceCollection {
	return page.brc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BindingResourceCollectionPage) Values() []BindingResource {
	if page.brc.IsEmpty() {
		return nil
	}
	return *page.brc.Value
}

// Creates a new instance of the BindingResourceCollectionPage type.
func NewBindingResourceCollectionPage(getNextPage func(context.Context, BindingResourceCollection) (BindingResourceCollection, error)) BindingResourceCollectionPage {
	return BindingResourceCollectionPage{fn: getNextPage}
}

// BindingResourceProperties binding resource properties payload
type BindingResourceProperties struct {
	// ResourceName - The name of the bound resource
	ResourceName *string `json:"resourceName,omitempty"`
	// ResourceType - The standard Azure resource type of the bound resource
	ResourceType *string `json:"resourceType,omitempty"`
	// ResourceID - The Azure resource id of the bound resource
	ResourceID *string `json:"resourceId,omitempty"`
	// Key - The key of the bound resource
	Key *string `json:"key,omitempty"`
	// BindingParameters - Binding parameters of the Binding resource
	BindingParameters map[string]interface{} `json:"bindingParameters"`
	// GeneratedProperties - READ-ONLY; The generated Spring Boot property file for this binding. The secret will be deducted.
	GeneratedProperties *string `json:"generatedProperties,omitempty"`
	// CreatedAt - READ-ONLY; Creation time of the Binding resource
	CreatedAt *string `json:"createdAt,omitempty"`
	// UpdatedAt - READ-ONLY; Update time of the Binding resource
	UpdatedAt *string `json:"updatedAt,omitempty"`
}

// MarshalJSON is the custom marshaler for BindingResourceProperties.
func (brp BindingResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if brp.ResourceName != nil {
		objectMap["resourceName"] = brp.ResourceName
	}
	if brp.ResourceType != nil {
		objectMap["resourceType"] = brp.ResourceType
	}
	if brp.ResourceID != nil {
		objectMap["resourceId"] = brp.ResourceID
	}
	if brp.Key != nil {
		objectMap["key"] = brp.Key
	}
	if brp.BindingParameters != nil {
		objectMap["bindingParameters"] = brp.BindingParameters
	}
	return json.Marshal(objectMap)
}

// CertificateProperties certificate resource payload.
type CertificateProperties struct {
	// Thumbprint - READ-ONLY; The thumbprint of certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// VaultURI - The vault uri of user key vault.
	VaultURI *string `json:"vaultUri,omitempty"`
	// KeyVaultCertName - The certificate name of key vault.
	KeyVaultCertName *string `json:"keyVaultCertName,omitempty"`
	// CertVersion - The certificate version of key vault.
	CertVersion *string `json:"certVersion,omitempty"`
	// Issuer - READ-ONLY; The issuer of certificate.
	Issuer *string `json:"issuer,omitempty"`
	// IssuedDate - READ-ONLY; The issue date of certificate.
	IssuedDate *string `json:"issuedDate,omitempty"`
	// ExpirationDate - READ-ONLY; The expiration date of certificate.
	ExpirationDate *string `json:"expirationDate,omitempty"`
	// ActivateDate - READ-ONLY; The activate date of certificate.
	ActivateDate *string `json:"activateDate,omitempty"`
	// SubjectName - READ-ONLY; The subject name of certificate.
	SubjectName *string `json:"subjectName,omitempty"`
	// DNSNames - READ-ONLY; The domain list of certificate.
	DNSNames *[]string `json:"dnsNames,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateProperties.
func (cp CertificateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.VaultURI != nil {
		objectMap["vaultUri"] = cp.VaultURI
	}
	if cp.KeyVaultCertName != nil {
		objectMap["keyVaultCertName"] = cp.KeyVaultCertName
	}
	if cp.CertVersion != nil {
		objectMap["certVersion"] = cp.CertVersion
	}
	return json.Marshal(objectMap)
}

// CertificateResource certificate resource payload.
type CertificateResource struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the certificate resource payload.
	Properties *CertificateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateResource.
func (cr CertificateResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cr.Properties != nil {
		objectMap["properties"] = cr.Properties
	}
	return json.Marshal(objectMap)
}

// CertificateResourceCollection collection compose of certificate resources list and a possible link for next
// page.
type CertificateResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - The certificate resources list.
	Value *[]CertificateResource `json:"value,omitempty"`
	// NextLink - The link to next page of certificate list.
	NextLink *string `json:"nextLink,omitempty"`
}

// CertificateResourceCollectionIterator provides access to a complete listing of CertificateResource values.
type CertificateResourceCollectionIterator struct {
	i    int
	page CertificateResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CertificateResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CertificateResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CertificateResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CertificateResourceCollectionIterator) Response() CertificateResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CertificateResourceCollectionIterator) Value() CertificateResource {
	if !iter.page.NotDone() {
		return CertificateResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CertificateResourceCollectionIterator type.
func NewCertificateResourceCollectionIterator(page CertificateResourceCollectionPage) CertificateResourceCollectionIterator {
	return CertificateResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (crc CertificateResourceCollection) IsEmpty() bool {
	return crc.Value == nil || len(*crc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (crc CertificateResourceCollection) hasNextLink() bool {
	return crc.NextLink != nil && len(*crc.NextLink) != 0
}

// certificateResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (crc CertificateResourceCollection) certificateResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !crc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(crc.NextLink)))
}

// CertificateResourceCollectionPage contains a page of CertificateResource values.
type CertificateResourceCollectionPage struct {
	fn  func(context.Context, CertificateResourceCollection) (CertificateResourceCollection, error)
	crc CertificateResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CertificateResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.crc)
		if err != nil {
			return err
		}
		page.crc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CertificateResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CertificateResourceCollectionPage) NotDone() bool {
	return !page.crc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CertificateResourceCollectionPage) Response() CertificateResourceCollection {
	return page.crc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CertificateResourceCollectionPage) Values() []CertificateResource {
	if page.crc.IsEmpty() {
		return nil
	}
	return *page.crc.Value
}

// Creates a new instance of the CertificateResourceCollectionPage type.
func NewCertificateResourceCollectionPage(getNextPage func(context.Context, CertificateResourceCollection) (CertificateResourceCollection, error)) CertificateResourceCollectionPage {
	return CertificateResourceCollectionPage{fn: getNextPage}
}

// CloudError an error response from the service.
type CloudError struct {
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from the service.
type CloudErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// ClusterResourceProperties service properties payload
type ClusterResourceProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state of the Service. Possible values include: 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateDeleted', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateMoving', 'ProvisioningStateMoved', 'ProvisioningStateMoveFailed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ConfigServerProperties - Config server git properties of the Service
	ConfigServerProperties *ConfigServerProperties `json:"configServerProperties,omitempty"`
	// Trace - Trace properties of the Service
	Trace *TraceProperties `json:"trace,omitempty"`
	// Version - READ-ONLY; Version of the Service
	Version *int32 `json:"version,omitempty"`
	// ServiceID - READ-ONLY; ServiceInstanceEntity GUID which uniquely identifies a created resource
	ServiceID *string `json:"serviceId,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterResourceProperties.
func (crp ClusterResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if crp.ConfigServerProperties != nil {
		objectMap["configServerProperties"] = crp.ConfigServerProperties
	}
	if crp.Trace != nil {
		objectMap["trace"] = crp.Trace
	}
	return json.Marshal(objectMap)
}

// ConfigServerGitProperty property of git.
type ConfigServerGitProperty struct {
	// Repositories - Repositories of git.
	Repositories *[]GitPatternRepository `json:"repositories,omitempty"`
	// URI - URI of the repository
	URI *string `json:"uri,omitempty"`
	// Label - Label of the repository
	Label *string `json:"label,omitempty"`
	// SearchPaths - Searching path of the repository
	SearchPaths *[]string `json:"searchPaths,omitempty"`
	// Username - Username of git repository basic auth.
	Username *string `json:"username,omitempty"`
	// Password - Password of git repository basic auth.
	Password *string `json:"password,omitempty"`
	// HostKey - Public sshKey of git repository.
	HostKey *string `json:"hostKey,omitempty"`
	// HostKeyAlgorithm - SshKey algorithm of git repository.
	HostKeyAlgorithm *string `json:"hostKeyAlgorithm,omitempty"`
	// PrivateKey - Private sshKey algorithm of git repository.
	PrivateKey *string `json:"privateKey,omitempty"`
	// StrictHostKeyChecking - Strict host key checking or not.
	StrictHostKeyChecking *bool `json:"strictHostKeyChecking,omitempty"`
}

// ConfigServerProperties config server git properties payload
type ConfigServerProperties struct {
	// State - READ-ONLY; State of the config server. Possible values include: 'ConfigServerStateNotAvailable', 'ConfigServerStateDeleted', 'ConfigServerStateFailed', 'ConfigServerStateSucceeded', 'ConfigServerStateUpdating'
	State ConfigServerState `json:"state,omitempty"`
	// Error - Error when apply config server settings.
	Error *Error `json:"error,omitempty"`
	// ConfigServer - Settings of config server.
	ConfigServer *ConfigServerSettings `json:"configServer,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigServerProperties.
func (csp ConfigServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if csp.Error != nil {
		objectMap["error"] = csp.Error
	}
	if csp.ConfigServer != nil {
		objectMap["configServer"] = csp.ConfigServer
	}
	return json.Marshal(objectMap)
}

// ConfigServerSettings the settings of config server.
type ConfigServerSettings struct {
	// GitProperty - Property of git environment.
	GitProperty *ConfigServerGitProperty `json:"gitProperty,omitempty"`
}

// CustomDomainProperties custom domain of app resource payload.
type CustomDomainProperties struct {
	// Thumbprint - The thumbprint of bound certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// AppName - The app name of domain.
	AppName *string `json:"appName,omitempty"`
	// CertName - The bound certificate name of domain.
	CertName *string `json:"certName,omitempty"`
}

// CustomDomainResource custom domain resource payload.
type CustomDomainResource struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the custom domain resource.
	Properties *CustomDomainProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomDomainResource.
func (cdr CustomDomainResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cdr.Properties != nil {
		objectMap["properties"] = cdr.Properties
	}
	return json.Marshal(objectMap)
}

// CustomDomainResourceCollection collection compose of a custom domain resources list and a possible link for
// next page.
type CustomDomainResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - The custom domain resources list.
	Value *[]CustomDomainResource `json:"value,omitempty"`
	// NextLink - The link to next page of custom domain list.
	NextLink *string `json:"nextLink,omitempty"`
}

// CustomDomainResourceCollectionIterator provides access to a complete listing of CustomDomainResource values.
type CustomDomainResourceCollectionIterator struct {
	i    int
	page CustomDomainResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CustomDomainResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomDomainResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CustomDomainResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CustomDomainResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CustomDomainResourceCollectionIterator) Response() CustomDomainResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CustomDomainResourceCollectionIterator) Value() CustomDomainResource {
	if !iter.page.NotDone() {
		return CustomDomainResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CustomDomainResourceCollectionIterator type.
func NewCustomDomainResourceCollectionIterator(page CustomDomainResourceCollectionPage) CustomDomainResourceCollectionIterator {
	return CustomDomainResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cdrc CustomDomainResourceCollection) IsEmpty() bool {
	return cdrc.Value == nil || len(*cdrc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cdrc CustomDomainResourceCollection) hasNextLink() bool {
	return cdrc.NextLink != nil && len(*cdrc.NextLink) != 0
}

// customDomainResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cdrc CustomDomainResourceCollection) customDomainResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !cdrc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cdrc.NextLink)))
}

// CustomDomainResourceCollectionPage contains a page of CustomDomainResource values.
type CustomDomainResourceCollectionPage struct {
	fn   func(context.Context, CustomDomainResourceCollection) (CustomDomainResourceCollection, error)
	cdrc CustomDomainResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CustomDomainResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomDomainResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cdrc)
		if err != nil {
			return err
		}
		page.cdrc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CustomDomainResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CustomDomainResourceCollectionPage) NotDone() bool {
	return !page.cdrc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CustomDomainResourceCollectionPage) Response() CustomDomainResourceCollection {
	return page.cdrc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CustomDomainResourceCollectionPage) Values() []CustomDomainResource {
	if page.cdrc.IsEmpty() {
		return nil
	}
	return *page.cdrc.Value
}

// Creates a new instance of the CustomDomainResourceCollectionPage type.
func NewCustomDomainResourceCollectionPage(getNextPage func(context.Context, CustomDomainResourceCollection) (CustomDomainResourceCollection, error)) CustomDomainResourceCollectionPage {
	return CustomDomainResourceCollectionPage{fn: getNextPage}
}

// CustomDomainValidatePayload custom domain validate payload.
type CustomDomainValidatePayload struct {
	// Name - Name to be validated
	Name *string `json:"name,omitempty"`
}

// CustomDomainValidateResult validation result for custom domain.
type CustomDomainValidateResult struct {
	autorest.Response `json:"-"`
	// IsValid - Indicates if domain name is valid.
	IsValid *bool `json:"isValid,omitempty"`
	// Message - Message of why domain name is invalid.
	Message *string `json:"message,omitempty"`
}

// DeploymentInstance deployment instance payload
type DeploymentInstance struct {
	// Name - READ-ONLY; Name of the deployment instance
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; Status of the deployment instance
	Status *string `json:"status,omitempty"`
	// Reason - READ-ONLY; Failed reason of the deployment instance
	Reason *string `json:"reason,omitempty"`
	// DiscoveryStatus - READ-ONLY; Discovery status of the deployment instance
	DiscoveryStatus *string `json:"discoveryStatus,omitempty"`
}

// DeploymentResource deployment resource payload
type DeploymentResource struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the Deployment resource
	Properties *DeploymentResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DeploymentResource.
func (dr DeploymentResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dr.Properties != nil {
		objectMap["properties"] = dr.Properties
	}
	return json.Marshal(objectMap)
}

// DeploymentResourceCollection object that includes an array of App resources and a possible link for next set
type DeploymentResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of Deployment resources
	Value *[]DeploymentResource `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// DeploymentResourceCollectionIterator provides access to a complete listing of DeploymentResource values.
type DeploymentResourceCollectionIterator struct {
	i    int
	page DeploymentResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeploymentResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeploymentResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeploymentResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeploymentResourceCollectionIterator) Response() DeploymentResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeploymentResourceCollectionIterator) Value() DeploymentResource {
	if !iter.page.NotDone() {
		return DeploymentResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeploymentResourceCollectionIterator type.
func NewDeploymentResourceCollectionIterator(page DeploymentResourceCollectionPage) DeploymentResourceCollectionIterator {
	return DeploymentResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (drc DeploymentResourceCollection) IsEmpty() bool {
	return drc.Value == nil || len(*drc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (drc DeploymentResourceCollection) hasNextLink() bool {
	return drc.NextLink != nil && len(*drc.NextLink) != 0
}

// deploymentResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (drc DeploymentResourceCollection) deploymentResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !drc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(drc.NextLink)))
}

// DeploymentResourceCollectionPage contains a page of DeploymentResource values.
type DeploymentResourceCollectionPage struct {
	fn  func(context.Context, DeploymentResourceCollection) (DeploymentResourceCollection, error)
	drc DeploymentResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeploymentResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.drc)
		if err != nil {
			return err
		}
		page.drc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeploymentResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeploymentResourceCollectionPage) NotDone() bool {
	return !page.drc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeploymentResourceCollectionPage) Response() DeploymentResourceCollection {
	return page.drc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeploymentResourceCollectionPage) Values() []DeploymentResource {
	if page.drc.IsEmpty() {
		return nil
	}
	return *page.drc.Value
}

// Creates a new instance of the DeploymentResourceCollectionPage type.
func NewDeploymentResourceCollectionPage(getNextPage func(context.Context, DeploymentResourceCollection) (DeploymentResourceCollection, error)) DeploymentResourceCollectionPage {
	return DeploymentResourceCollectionPage{fn: getNextPage}
}

// DeploymentResourceProperties deployment resource properties payload
type DeploymentResourceProperties struct {
	// Source - Uploaded source information of the deployment.
	Source *UserSourceInfo `json:"source,omitempty"`
	// AppName - READ-ONLY; App name of the deployment
	AppName *string `json:"appName,omitempty"`
	// DeploymentSettings - Deployment settings of the Deployment
	DeploymentSettings *DeploymentSettings `json:"deploymentSettings,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the Deployment. Possible values include: 'DeploymentResourceProvisioningStateCreating', 'DeploymentResourceProvisioningStateUpdating', 'DeploymentResourceProvisioningStateSucceeded', 'DeploymentResourceProvisioningStateFailed'
	ProvisioningState DeploymentResourceProvisioningState `json:"provisioningState,omitempty"`
	// Status - READ-ONLY; Status of the Deployment. Possible values include: 'DeploymentResourceStatusUnknown', 'DeploymentResourceStatusStopped', 'DeploymentResourceStatusRunning', 'DeploymentResourceStatusFailed', 'DeploymentResourceStatusAllocating', 'DeploymentResourceStatusUpgrading', 'DeploymentResourceStatusCompiling'
	Status DeploymentResourceStatus `json:"status,omitempty"`
	// Active - READ-ONLY; Indicates whether the Deployment is active
	Active *bool `json:"active,omitempty"`
	// CreatedTime - READ-ONLY; Date time when the resource is created
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// Instances - READ-ONLY; Collection of instances belong to the Deployment
	Instances *[]DeploymentInstance `json:"instances,omitempty"`
}

// MarshalJSON is the custom marshaler for DeploymentResourceProperties.
func (drp DeploymentResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if drp.Source != nil {
		objectMap["source"] = drp.Source
	}
	if drp.DeploymentSettings != nil {
		objectMap["deploymentSettings"] = drp.DeploymentSettings
	}
	return json.Marshal(objectMap)
}

// DeploymentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DeploymentsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DeploymentsCreateOrUpdateFuture) Result(client DeploymentsClient) (dr DeploymentResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.DeploymentsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("appplatform.DeploymentsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dr.Response.Response, err = future.GetResult(sender); err == nil && dr.Response.Response.StatusCode != http.StatusNoContent {
		dr, err = client.CreateOrUpdateResponder(dr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.DeploymentsCreateOrUpdateFuture", "Result", dr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeploymentSettings deployment settings payload
type DeploymentSettings struct {
	// CPU - Required CPU, basic tier should be 1, standard tier should be in range (1, 4)
	CPU *int32 `json:"cpu,omitempty"`
	// MemoryInGB - Required Memory size in GB, basic tier should be in range (1, 2), standard tier should be in range (1, 8)
	MemoryInGB *int32 `json:"memoryInGB,omitempty"`
	// JvmOptions - JVM parameter
	JvmOptions *string `json:"jvmOptions,omitempty"`
	// InstanceCount - Instance count, basic tier should be in range (1, 25), standard tier should be in range (1, 500)
	InstanceCount *int32 `json:"instanceCount,omitempty"`
	// EnvironmentVariables - Collection of environment variables
	EnvironmentVariables map[string]*string `json:"environmentVariables"`
	// RuntimeVersion - Runtime version. Possible values include: 'Java8', 'Java11'
	RuntimeVersion RuntimeVersion `json:"runtimeVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for DeploymentSettings.
func (ds DeploymentSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ds.CPU != nil {
		objectMap["cpu"] = ds.CPU
	}
	if ds.MemoryInGB != nil {
		objectMap["memoryInGB"] = ds.MemoryInGB
	}
	if ds.JvmOptions != nil {
		objectMap["jvmOptions"] = ds.JvmOptions
	}
	if ds.InstanceCount != nil {
		objectMap["instanceCount"] = ds.InstanceCount
	}
	if ds.EnvironmentVariables != nil {
		objectMap["environmentVariables"] = ds.EnvironmentVariables
	}
	if ds.RuntimeVersion != "" {
		objectMap["runtimeVersion"] = ds.RuntimeVersion
	}
	return json.Marshal(objectMap)
}

// DeploymentsRestartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DeploymentsRestartFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DeploymentsRestartFuture) Result(client DeploymentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.DeploymentsRestartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("appplatform.DeploymentsRestartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeploymentsStartFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DeploymentsStartFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DeploymentsStartFuture) Result(client DeploymentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.DeploymentsStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("appplatform.DeploymentsStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeploymentsStopFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DeploymentsStopFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DeploymentsStopFuture) Result(client DeploymentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.DeploymentsStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("appplatform.DeploymentsStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeploymentsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DeploymentsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DeploymentsUpdateFuture) Result(client DeploymentsClient) (dr DeploymentResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.DeploymentsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("appplatform.DeploymentsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dr.Response.Response, err = future.GetResult(sender); err == nil && dr.Response.Response.StatusCode != http.StatusNoContent {
		dr, err = client.UpdateResponder(dr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.DeploymentsUpdateFuture", "Result", dr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Error the error code compose of code and message.
type Error struct {
	// Code - The code of error.
	Code *string `json:"code,omitempty"`
	// Message - The message of error.
	Message *string `json:"message,omitempty"`
}

// GitPatternRepository git repository property payload
type GitPatternRepository struct {
	// Name - Name of the repository
	Name *string `json:"name,omitempty"`
	// Pattern - Collection of pattern of the repository
	Pattern *[]string `json:"pattern,omitempty"`
	// URI - URI of the repository
	URI *string `json:"uri,omitempty"`
	// Label - Label of the repository
	Label *string `json:"label,omitempty"`
	// SearchPaths - Searching path of the repository
	SearchPaths *[]string `json:"searchPaths,omitempty"`
	// Username - Username of git repository basic auth.
	Username *string `json:"username,omitempty"`
	// Password - Password of git repository basic auth.
	Password *string `json:"password,omitempty"`
	// HostKey - Public sshKey of git repository.
	HostKey *string `json:"hostKey,omitempty"`
	// HostKeyAlgorithm - SshKey algorithm of git repository.
	HostKeyAlgorithm *string `json:"hostKeyAlgorithm,omitempty"`
	// PrivateKey - Private sshKey algorithm of git repository.
	PrivateKey *string `json:"privateKey,omitempty"`
	// StrictHostKeyChecking - Strict host key checking or not.
	StrictHostKeyChecking *bool `json:"strictHostKeyChecking,omitempty"`
}

// LogFileURLResponse log file URL payload
type LogFileURLResponse struct {
	autorest.Response `json:"-"`
	// URL - URL of the log file
	URL *string `json:"url,omitempty"`
}

// LogSpecification specifications of the Log for Azure Monitoring
type LogSpecification struct {
	// Name - Name of the log
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the log
	DisplayName *string `json:"displayName,omitempty"`
	// BlobDuration - Blob duration of the log
	BlobDuration *string `json:"blobDuration,omitempty"`
}

// ManagedIdentityProperties managed identity properties retrieved from ARM request headers.
type ManagedIdentityProperties struct {
	// Type - Possible values include: 'None', 'SystemAssigned', 'UserAssigned', 'SystemAssignedUserAssigned'
	Type        ManagedIdentityType `json:"type,omitempty"`
	PrincipalID *string             `json:"principalId,omitempty"`
	TenantID    *string             `json:"tenantId,omitempty"`
}

// MetricDimension specifications of the Dimension of metrics
type MetricDimension struct {
	// Name - Name of the dimension
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the dimension
	DisplayName *string `json:"displayName,omitempty"`
}

// MetricSpecification specifications of the Metrics for Azure Monitoring
type MetricSpecification struct {
	// Name - Name of the metric
	Name *string `json:"name,omitempty"`
	// DisplayName - Localized friendly display name of the metric
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - Localized friendly description of the metric
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - Unit that makes sense for the metric
	Unit *string `json:"unit,omitempty"`
	// Category - Name of the metric category that the metric belongs to. A metric can only belong to a single category.
	Category *string `json:"category,omitempty"`
	// AggregationType - Only provide one value for this field. Valid values: Average, Minimum, Maximum, Total, Count.
	AggregationType *string `json:"aggregationType,omitempty"`
	// SupportedAggregationTypes - Supported aggregation types
	SupportedAggregationTypes *[]string `json:"supportedAggregationTypes,omitempty"`
	// SupportedTimeGrainTypes - Supported time grain types
	SupportedTimeGrainTypes *[]string `json:"supportedTimeGrainTypes,omitempty"`
	// FillGapWithZero - Optional. If set to true, then zero will be returned for time duration where no metric is emitted/published.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`
	// Dimensions - Dimensions of the metric
	Dimensions *[]MetricDimension `json:"dimensions,omitempty"`
}

// NameAvailability name availability result payload
type NameAvailability struct {
	autorest.Response `json:"-"`
	// NameAvailable - Indicates whether the name is available
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - Reason why the name is not available
	Reason *string `json:"reason,omitempty"`
	// Message - Message why the name is not available
	Message *string `json:"message,omitempty"`
}

// NameAvailabilityParameters name availability parameters payload
type NameAvailabilityParameters struct {
	// Type - Type of the resource to check name availability
	Type *string `json:"type,omitempty"`
	// Name - Name to be checked
	Name *string `json:"name,omitempty"`
}

// OperationDetail operation detail payload
type OperationDetail struct {
	// Name - Name of the operation
	Name *string `json:"name,omitempty"`
	// IsDataAction - Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Display - Display of the operation
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - Origin of the operation
	Origin *string `json:"origin,omitempty"`
	// Properties - Properties of the operation
	Properties *OperationProperties `json:"properties,omitempty"`
}

// OperationDisplay operation display payload
type OperationDisplay struct {
	// Provider - Resource provider of the operation
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource of the operation
	Resource *string `json:"resource,omitempty"`
	// Operation - Localized friendly name for the operation
	Operation *string `json:"operation,omitempty"`
	// Description - Localized friendly description for the operation
	Description *string `json:"description,omitempty"`
}

// OperationProperties extra Operation properties
type OperationProperties struct {
	// ServiceSpecification - Service specifications of the operation
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// PersistentDisk persistent disk payload
type PersistentDisk struct {
	// SizeInGB - Size of the persistent disk in GB
	SizeInGB *int32 `json:"sizeInGB,omitempty"`
	// UsedInGB - READ-ONLY; Size of the used persistent disk in GB
	UsedInGB *int32 `json:"usedInGB,omitempty"`
	// MountPath - Mount path of the persistent disk
	MountPath *string `json:"mountPath,omitempty"`
}

// MarshalJSON is the custom marshaler for PersistentDisk.
func (pd PersistentDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pd.SizeInGB != nil {
		objectMap["sizeInGB"] = pd.SizeInGB
	}
	if pd.MountPath != nil {
		objectMap["mountPath"] = pd.MountPath
	}
	return json.Marshal(objectMap)
}

// ProxyResource the resource model definition for a ARM proxy resource. It will have everything other than
// required location and tags.
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// RegenerateTestKeyRequestPayload regenerate test key request payload
type RegenerateTestKeyRequestPayload struct {
	// KeyType - Type of the test key. Possible values include: 'Primary', 'Secondary'
	KeyType TestKeyType `json:"keyType,omitempty"`
}

// Resource the core properties of ARM resources.
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// ResourceSku describes an available Azure Spring Cloud SKU.
type ResourceSku struct {
	// ResourceType - Gets the type of resource the SKU applies to.
	ResourceType *string `json:"resourceType,omitempty"`
	// Name - Gets the name of SKU.
	Name *string `json:"name,omitempty"`
	// Tier - Gets the tier of SKU.
	Tier *string `json:"tier,omitempty"`
	// Capacity - Gets the capacity of SKU.
	Capacity *SkuCapacity `json:"capacity,omitempty"`
	// Locations - Gets the set of locations that the SKU is available.
	Locations *[]string `json:"locations,omitempty"`
	// LocationInfo - Gets a list of locations and availability zones in those locations where the SKU is available.
	LocationInfo *[]ResourceSkuLocationInfo `json:"locationInfo,omitempty"`
	// Restrictions - Gets the restrictions because of which SKU cannot be used. This is
	// empty if there are no restrictions.
	Restrictions *[]ResourceSkuRestrictions `json:"restrictions,omitempty"`
}

// ResourceSkuCapabilities ...
type ResourceSkuCapabilities struct {
	// Name - Gets an invariant to describe the feature.
	Name *string `json:"name,omitempty"`
	// Value - Gets an invariant if the feature is measured by quantity.
	Value *string `json:"value,omitempty"`
}

// ResourceSkuCollection ...
type ResourceSkuCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resource SKU
	Value *[]ResourceSku `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceSkuCollectionIterator provides access to a complete listing of ResourceSku values.
type ResourceSkuCollectionIterator struct {
	i    int
	page ResourceSkuCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceSkuCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceSkuCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceSkuCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceSkuCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceSkuCollectionIterator) Response() ResourceSkuCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceSkuCollectionIterator) Value() ResourceSku {
	if !iter.page.NotDone() {
		return ResourceSku{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceSkuCollectionIterator type.
func NewResourceSkuCollectionIterator(page ResourceSkuCollectionPage) ResourceSkuCollectionIterator {
	return ResourceSkuCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rsc ResourceSkuCollection) IsEmpty() bool {
	return rsc.Value == nil || len(*rsc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rsc ResourceSkuCollection) hasNextLink() bool {
	return rsc.NextLink != nil && len(*rsc.NextLink) != 0
}

// resourceSkuCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rsc ResourceSkuCollection) resourceSkuCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !rsc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rsc.NextLink)))
}

// ResourceSkuCollectionPage contains a page of ResourceSku values.
type ResourceSkuCollectionPage struct {
	fn  func(context.Context, ResourceSkuCollection) (ResourceSkuCollection, error)
	rsc ResourceSkuCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceSkuCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceSkuCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rsc)
		if err != nil {
			return err
		}
		page.rsc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceSkuCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceSkuCollectionPage) NotDone() bool {
	return !page.rsc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceSkuCollectionPage) Response() ResourceSkuCollection {
	return page.rsc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceSkuCollectionPage) Values() []ResourceSku {
	if page.rsc.IsEmpty() {
		return nil
	}
	return *page.rsc.Value
}

// Creates a new instance of the ResourceSkuCollectionPage type.
func NewResourceSkuCollectionPage(getNextPage func(context.Context, ResourceSkuCollection) (ResourceSkuCollection, error)) ResourceSkuCollectionPage {
	return ResourceSkuCollectionPage{fn: getNextPage}
}

// ResourceSkuLocationInfo ...
type ResourceSkuLocationInfo struct {
	// Location - Gets location of the SKU
	Location *string `json:"location,omitempty"`
	// Zones - Gets list of availability zones where the SKU is supported.
	Zones *[]string `json:"zones,omitempty"`
	// ZoneDetails - Gets details of capabilities available to a SKU in specific zones.
	ZoneDetails *[]ResourceSkuZoneDetails `json:"zoneDetails,omitempty"`
}

// ResourceSkuRestrictionInfo ...
type ResourceSkuRestrictionInfo struct {
	// Locations - Gets locations where the SKU is restricted
	Locations *[]string `json:"locations,omitempty"`
	// Zones - Gets list of availability zones where the SKU is restricted.
	Zones *[]string `json:"zones,omitempty"`
}

// ResourceSkuRestrictions ...
type ResourceSkuRestrictions struct {
	// Type - Gets the type of restrictions. Possible values include: 'Location', 'Zone'
	Type ResourceSkuRestrictionsType `json:"type,omitempty"`
	// Values - Gets the value of restrictions. If the restriction type is set to
	// location. This would be different locations where the SKU is restricted.
	Values *[]string `json:"values,omitempty"`
	// RestrictionInfo - Gets the information about the restriction where the SKU cannot be used.
	RestrictionInfo *ResourceSkuRestrictionInfo `json:"restrictionInfo,omitempty"`
	// ReasonCode - Gets the reason for restriction. Possible values include: 'QuotaId', 'NotAvailableForSubscription'. Possible values include: 'QuotaID', 'NotAvailableForSubscription'
	ReasonCode ResourceSkuRestrictionsReasonCode `json:"reasonCode,omitempty"`
}

// ResourceSkuZoneDetails ...
type ResourceSkuZoneDetails struct {
	// Name - Gets the set of zones that the SKU is available in with the
	// specified capabilities.
	Name *[]string `json:"name,omitempty"`
	// Capabilities - Gets a list of capabilities that are available for the SKU in the
	// specified list of zones.
	Capabilities *[]ResourceSkuCapabilities `json:"capabilities,omitempty"`
}

// ResourceUploadDefinition resource upload definition payload
type ResourceUploadDefinition struct {
	autorest.Response `json:"-"`
	// RelativePath - Source relative path
	RelativePath *string `json:"relativePath,omitempty"`
	// UploadURL - Upload URL
	UploadURL *string `json:"uploadUrl,omitempty"`
}

// ServiceResource service resource
type ServiceResource struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the Service resource
	Properties *ClusterResourceProperties `json:"properties,omitempty"`
	// Sku - Sku of the Service resource
	Sku *Sku `json:"sku,omitempty"`
	// Location - The GEO location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Tags of the service which is a list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceResource.
func (sr ServiceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.Properties != nil {
		objectMap["properties"] = sr.Properties
	}
	if sr.Sku != nil {
		objectMap["sku"] = sr.Sku
	}
	if sr.Location != nil {
		objectMap["location"] = sr.Location
	}
	if sr.Tags != nil {
		objectMap["tags"] = sr.Tags
	}
	return json.Marshal(objectMap)
}

// ServiceResourceList object that includes an array of Service resources and a possible link for next set
type ServiceResourceList struct {
	autorest.Response `json:"-"`
	// Value - Collection of Service resources
	Value *[]ServiceResource `json:"value,omitempty"`
	// NextLink - URL client should use to fetch the next page (per server side paging).
	// It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceResourceListIterator provides access to a complete listing of ServiceResource values.
type ServiceResourceListIterator struct {
	i    int
	page ServiceResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceResourceListIterator) Response() ServiceResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceResourceListIterator) Value() ServiceResource {
	if !iter.page.NotDone() {
		return ServiceResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceResourceListIterator type.
func NewServiceResourceListIterator(page ServiceResourceListPage) ServiceResourceListIterator {
	return ServiceResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (srl ServiceResourceList) IsEmpty() bool {
	return srl.Value == nil || len(*srl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (srl ServiceResourceList) hasNextLink() bool {
	return srl.NextLink != nil && len(*srl.NextLink) != 0
}

// serviceResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (srl ServiceResourceList) serviceResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !srl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(srl.NextLink)))
}

// ServiceResourceListPage contains a page of ServiceResource values.
type ServiceResourceListPage struct {
	fn  func(context.Context, ServiceResourceList) (ServiceResourceList, error)
	srl ServiceResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.srl)
		if err != nil {
			return err
		}
		page.srl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceResourceListPage) NotDone() bool {
	return !page.srl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceResourceListPage) Response() ServiceResourceList {
	return page.srl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceResourceListPage) Values() []ServiceResource {
	if page.srl.IsEmpty() {
		return nil
	}
	return *page.srl.Value
}

// Creates a new instance of the ServiceResourceListPage type.
func NewServiceResourceListPage(getNextPage func(context.Context, ServiceResourceList) (ServiceResourceList, error)) ServiceResourceListPage {
	return ServiceResourceListPage{fn: getNextPage}
}

// ServicesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServicesCreateOrUpdateFuture) Result(client ServicesClient) (sr ServiceResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.ServicesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("appplatform.ServicesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sr.Response.Response, err = future.GetResult(sender); err == nil && sr.Response.Response.StatusCode != http.StatusNoContent {
		sr, err = client.CreateOrUpdateResponder(sr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.ServicesCreateOrUpdateFuture", "Result", sr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServicesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ServicesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServicesDeleteFuture) Result(client ServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.ServicesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("appplatform.ServicesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServiceSpecification service specification payload
type ServiceSpecification struct {
	// LogSpecifications - Specifications of the Log for Azure Monitoring
	LogSpecifications *[]LogSpecification `json:"logSpecifications,omitempty"`
	// MetricSpecifications - Specifications of the Metrics for Azure Monitoring
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
}

// ServicesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ServicesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServicesUpdateFuture) Result(client ServicesClient) (sr ServiceResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.ServicesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("appplatform.ServicesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sr.Response.Response, err = future.GetResult(sender); err == nil && sr.Response.Response.StatusCode != http.StatusNoContent {
		sr, err = client.UpdateResponder(sr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "appplatform.ServicesUpdateFuture", "Result", sr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Sku sku of Azure Spring Cloud
type Sku struct {
	// Name - Name of the Sku
	Name *string `json:"name,omitempty"`
	// Tier - Tier of the Sku
	Tier *string `json:"tier,omitempty"`
	// Capacity - Current capacity of the target resource
	Capacity *int32 `json:"capacity,omitempty"`
}

// SkuCapacity the SKU capacity
type SkuCapacity struct {
	// Minimum - Gets or sets the minimum.
	Minimum *int32 `json:"minimum,omitempty"`
	// Maximum - Gets or sets the maximum.
	Maximum *int32 `json:"maximum,omitempty"`
	// Default - Gets or sets the default.
	Default *int32 `json:"default,omitempty"`
	// ScaleType - Gets or sets the type of the scale. Possible values include: 'SkuScaleTypeNone', 'SkuScaleTypeManual', 'SkuScaleTypeAutomatic'
	ScaleType SkuScaleType `json:"scaleType,omitempty"`
}

// TemporaryDisk temporary disk payload
type TemporaryDisk struct {
	// SizeInGB - Size of the temporary disk in GB
	SizeInGB *int32 `json:"sizeInGB,omitempty"`
	// MountPath - Mount path of the temporary disk
	MountPath *string `json:"mountPath,omitempty"`
}

// TestKeys test keys payload
type TestKeys struct {
	autorest.Response `json:"-"`
	// PrimaryKey - Primary key
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - Secondary key
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// PrimaryTestEndpoint - Primary test endpoint
	PrimaryTestEndpoint *string `json:"primaryTestEndpoint,omitempty"`
	// SecondaryTestEndpoint - Secondary test endpoint
	SecondaryTestEndpoint *string `json:"secondaryTestEndpoint,omitempty"`
	// Enabled - Indicates whether the test endpoint feature enabled or not
	Enabled *bool `json:"enabled,omitempty"`
}

// TraceProperties trace properties payload
type TraceProperties struct {
	// State - READ-ONLY; State of the trace proxy. Possible values include: 'TraceProxyStateNotAvailable', 'TraceProxyStateFailed', 'TraceProxyStateSucceeded', 'TraceProxyStateUpdating'
	State TraceProxyState `json:"state,omitempty"`
	// Error - Error when apply trace proxy changes.
	Error *Error `json:"error,omitempty"`
	// Enabled - Indicates whether enable the tracing functionality
	Enabled *bool `json:"enabled,omitempty"`
	// AppInsightInstrumentationKey - Target application insight instrumentation key
	AppInsightInstrumentationKey *string `json:"appInsightInstrumentationKey,omitempty"`
}

// MarshalJSON is the custom marshaler for TraceProperties.
func (tp TraceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tp.Error != nil {
		objectMap["error"] = tp.Error
	}
	if tp.Enabled != nil {
		objectMap["enabled"] = tp.Enabled
	}
	if tp.AppInsightInstrumentationKey != nil {
		objectMap["appInsightInstrumentationKey"] = tp.AppInsightInstrumentationKey
	}
	return json.Marshal(objectMap)
}

// TrackedResource the resource model definition for a ARM tracked top level resource.
type TrackedResource struct {
	// Location - The GEO location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - Tags of the service which is a list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// UserSourceInfo source information for a deployment
type UserSourceInfo struct {
	// Type - Type of the source uploaded. Possible values include: 'Jar', 'Source'
	Type UserSourceType `json:"type,omitempty"`
	// RelativePath - Relative path of the storage which stores the source
	RelativePath *string `json:"relativePath,omitempty"`
	// Version - Version of the source
	Version *string `json:"version,omitempty"`
	// ArtifactSelector - Selector for the artifact to be used for the deployment for multi-module projects. This should be
	// the relative path to the target module/project.
	ArtifactSelector *string `json:"artifactSelector,omitempty"`
}
