package containerregistry

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/containerregistry/mgmt/2019-05-01/containerregistry"

// Actor the agent that initiated the event. For most situations, this could be from the authorization context
// of the request.
type Actor struct {
	// Name - The subject or username associated with the request context that generated the event.
	Name *string `json:"name,omitempty"`
}

// AgentProperties the properties that determine the run agent configuration.
type AgentProperties struct {
	// CPU - The CPU configuration in terms of number of cores required for the run.
	CPU *int32 `json:"cpu,omitempty"`
}

// Argument the properties of a run argument.
type Argument struct {
	// Name - The name of the argument.
	Name *string `json:"name,omitempty"`
	// Value - The value of the argument.
	Value *string `json:"value,omitempty"`
	// IsSecret - Flag to indicate whether the argument represents a secret and want to be removed from build logs.
	IsSecret *bool `json:"isSecret,omitempty"`
}

// AuthInfo the authorization properties for accessing the source code repository.
type AuthInfo struct {
	// TokenType - The type of Auth token. Possible values include: 'PAT', 'OAuth'
	TokenType TokenType `json:"tokenType,omitempty"`
	// Token - The access token used to access the source control provider.
	Token *string `json:"token,omitempty"`
	// RefreshToken - The refresh token used to refresh the access token.
	RefreshToken *string `json:"refreshToken,omitempty"`
	// Scope - The scope of the access token.
	Scope *string `json:"scope,omitempty"`
	// ExpiresIn - Time in seconds that the token remains valid
	ExpiresIn *int32 `json:"expiresIn,omitempty"`
}

// AuthInfoUpdateParameters the authorization properties for accessing the source code repository.
type AuthInfoUpdateParameters struct {
	// TokenType - The type of Auth token. Possible values include: 'PAT', 'OAuth'
	TokenType TokenType `json:"tokenType,omitempty"`
	// Token - The access token used to access the source control provider.
	Token *string `json:"token,omitempty"`
	// RefreshToken - The refresh token used to refresh the access token.
	RefreshToken *string `json:"refreshToken,omitempty"`
	// Scope - The scope of the access token.
	Scope *string `json:"scope,omitempty"`
	// ExpiresIn - Time in seconds that the token remains valid
	ExpiresIn *int32 `json:"expiresIn,omitempty"`
}

// BaseImageDependency properties that describe a base image dependency.
type BaseImageDependency struct {
	// Type - The type of the base image dependency. Possible values include: 'BuildTime', 'RunTime'
	Type BaseImageDependencyType `json:"type,omitempty"`
	// Registry - The registry login server.
	Registry *string `json:"registry,omitempty"`
	// Repository - The repository name.
	Repository *string `json:"repository,omitempty"`
	// Tag - The tag name.
	Tag *string `json:"tag,omitempty"`
	// Digest - The sha256-based digest of the image manifest.
	Digest *string `json:"digest,omitempty"`
}

// BaseImageTrigger the trigger based on base image dependency.
type BaseImageTrigger struct {
	// BaseImageTriggerType - The type of the auto trigger for base image dependency updates. Possible values include: 'All', 'Runtime'
	BaseImageTriggerType BaseImageTriggerType `json:"baseImageTriggerType,omitempty"`
	// Status - The current status of trigger. Possible values include: 'TriggerStatusDisabled', 'TriggerStatusEnabled'
	Status TriggerStatus `json:"status,omitempty"`
	// Name - The name of the trigger.
	Name *string `json:"name,omitempty"`
}

// BaseImageTriggerUpdateParameters the properties for updating base image dependency trigger.
type BaseImageTriggerUpdateParameters struct {
	// BaseImageTriggerType - The type of the auto trigger for base image dependency updates. Possible values include: 'All', 'Runtime'
	BaseImageTriggerType BaseImageTriggerType `json:"baseImageTriggerType,omitempty"`
	// Status - The current status of trigger. Possible values include: 'TriggerStatusDisabled', 'TriggerStatusEnabled'
	Status TriggerStatus `json:"status,omitempty"`
	// Name - The name of the trigger.
	Name *string `json:"name,omitempty"`
}

// CallbackConfig the configuration of service URI and custom headers for the webhook.
type CallbackConfig struct {
	autorest.Response `json:"-"`
	// ServiceURI - The service URI for the webhook to post notifications.
	ServiceURI *string `json:"serviceUri,omitempty"`
	// CustomHeaders - Custom headers that will be added to the webhook notifications.
	CustomHeaders map[string]*string `json:"customHeaders"`
}

// MarshalJSON is the custom marshaler for CallbackConfig.
func (cc CallbackConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cc.ServiceURI != nil {
		objectMap["serviceUri"] = cc.ServiceURI
	}
	if cc.CustomHeaders != nil {
		objectMap["customHeaders"] = cc.CustomHeaders
	}
	return json.Marshal(objectMap)
}

// Credentials the parameters that describes a set of credentials that will be used when a run is invoked.
type Credentials struct {
	// SourceRegistry - Describes the credential parameters for accessing the source registry.
	SourceRegistry *SourceRegistryCredentials `json:"sourceRegistry,omitempty"`
	// CustomRegistries - Describes the credential parameters for accessing other custom registries. The key
	// for the dictionary item will be the registry login server (myregistry.azurecr.io) and
	// the value of the item will be the registry credentials for accessing the registry.
	CustomRegistries map[string]*CustomRegistryCredentials `json:"customRegistries"`
}

// MarshalJSON is the custom marshaler for Credentials.
func (c Credentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.SourceRegistry != nil {
		objectMap["sourceRegistry"] = c.SourceRegistry
	}
	if c.CustomRegistries != nil {
		objectMap["customRegistries"] = c.CustomRegistries
	}
	return json.Marshal(objectMap)
}

// CustomRegistryCredentials describes the credentials that will be used to access a custom registry during a
// run.
type CustomRegistryCredentials struct {
	// UserName - The username for logging into the custom registry.
	UserName *SecretObject `json:"userName,omitempty"`
	// Password - The password for logging into the custom registry. The password is a secret
	// object that allows multiple ways of providing the value for it.
	Password *SecretObject `json:"password,omitempty"`
	// Identity - Indicates the managed identity assigned to the custom credential. If a user-assigned identity
	// this value is the Client ID. If a system-assigned identity, the value will be `system`. In
	// the case of a system-assigned identity, the Client ID will be determined by the runner. This
	// identity may be used to authenticate to key vault to retrieve credentials or it may be the only
	// source of authentication used for accessing the registry.
	Identity *string `json:"identity,omitempty"`
}

// DockerBuildRequest the parameters for a docker quick build.
type DockerBuildRequest struct {
	// ImageNames - The fully qualified image names including the repository and tag.
	ImageNames *[]string `json:"imageNames,omitempty"`
	// IsPushEnabled - The value of this property indicates whether the image built should be pushed to the registry or not.
	IsPushEnabled *bool `json:"isPushEnabled,omitempty"`
	// NoCache - The value of this property indicates whether the image cache is enabled or not.
	NoCache *bool `json:"noCache,omitempty"`
	// DockerFilePath - The Docker file path relative to the source location.
	DockerFilePath *string `json:"dockerFilePath,omitempty"`
	// Target - The name of the target build stage for the docker build.
	Target *string `json:"target,omitempty"`
	// Arguments - The collection of override arguments to be used when executing the run.
	Arguments *[]Argument `json:"arguments,omitempty"`
	// Timeout - Run timeout in seconds.
	Timeout *int32 `json:"timeout,omitempty"`
	// Platform - The platform properties against which the run has to happen.
	Platform *PlatformProperties `json:"platform,omitempty"`
	// AgentConfiguration - The machine configuration of the run agent.
	AgentConfiguration *AgentProperties `json:"agentConfiguration,omitempty"`
	// SourceLocation - The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
	// If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
	SourceLocation *string `json:"sourceLocation,omitempty"`
	// Credentials - The properties that describes a set of credentials that will be used when this run is invoked.
	Credentials *Credentials `json:"credentials,omitempty"`
	// IsArchiveEnabled - The value that indicates whether archiving is enabled for the run or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`
	// Type - Possible values include: 'TypeRunRequest', 'TypeDockerBuildRequest', 'TypeFileTaskRunRequest', 'TypeTaskRunRequest', 'TypeEncodedTaskRunRequest'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DockerBuildRequest.
func (dbr DockerBuildRequest) MarshalJSON() ([]byte, error) {
	dbr.Type = TypeDockerBuildRequest
	objectMap := make(map[string]interface{})
	if dbr.ImageNames != nil {
		objectMap["imageNames"] = dbr.ImageNames
	}
	if dbr.IsPushEnabled != nil {
		objectMap["isPushEnabled"] = dbr.IsPushEnabled
	}
	if dbr.NoCache != nil {
		objectMap["noCache"] = dbr.NoCache
	}
	if dbr.DockerFilePath != nil {
		objectMap["dockerFilePath"] = dbr.DockerFilePath
	}
	if dbr.Target != nil {
		objectMap["target"] = dbr.Target
	}
	if dbr.Arguments != nil {
		objectMap["arguments"] = dbr.Arguments
	}
	if dbr.Timeout != nil {
		objectMap["timeout"] = dbr.Timeout
	}
	if dbr.Platform != nil {
		objectMap["platform"] = dbr.Platform
	}
	if dbr.AgentConfiguration != nil {
		objectMap["agentConfiguration"] = dbr.AgentConfiguration
	}
	if dbr.SourceLocation != nil {
		objectMap["sourceLocation"] = dbr.SourceLocation
	}
	if dbr.Credentials != nil {
		objectMap["credentials"] = dbr.Credentials
	}
	if dbr.IsArchiveEnabled != nil {
		objectMap["isArchiveEnabled"] = dbr.IsArchiveEnabled
	}
	if dbr.Type != "" {
		objectMap["type"] = dbr.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildRequest is the BasicRunRequest implementation for DockerBuildRequest.
func (dbr DockerBuildRequest) AsDockerBuildRequest() (*DockerBuildRequest, bool) {
	return &dbr, true
}

// AsFileTaskRunRequest is the BasicRunRequest implementation for DockerBuildRequest.
func (dbr DockerBuildRequest) AsFileTaskRunRequest() (*FileTaskRunRequest, bool) {
	return nil, false
}

// AsTaskRunRequest is the BasicRunRequest implementation for DockerBuildRequest.
func (dbr DockerBuildRequest) AsTaskRunRequest() (*TaskRunRequest, bool) {
	return nil, false
}

// AsEncodedTaskRunRequest is the BasicRunRequest implementation for DockerBuildRequest.
func (dbr DockerBuildRequest) AsEncodedTaskRunRequest() (*EncodedTaskRunRequest, bool) {
	return nil, false
}

// AsRunRequest is the BasicRunRequest implementation for DockerBuildRequest.
func (dbr DockerBuildRequest) AsRunRequest() (*RunRequest, bool) {
	return nil, false
}

// AsBasicRunRequest is the BasicRunRequest implementation for DockerBuildRequest.
func (dbr DockerBuildRequest) AsBasicRunRequest() (BasicRunRequest, bool) {
	return &dbr, true
}

// DockerBuildStep the Docker build step.
type DockerBuildStep struct {
	// ImageNames - The fully qualified image names including the repository and tag.
	ImageNames *[]string `json:"imageNames,omitempty"`
	// IsPushEnabled - The value of this property indicates whether the image built should be pushed to the registry or not.
	IsPushEnabled *bool `json:"isPushEnabled,omitempty"`
	// NoCache - The value of this property indicates whether the image cache is enabled or not.
	NoCache *bool `json:"noCache,omitempty"`
	// DockerFilePath - The Docker file path relative to the source context.
	DockerFilePath *string `json:"dockerFilePath,omitempty"`
	// Target - The name of the target build stage for the docker build.
	Target *string `json:"target,omitempty"`
	// Arguments - The collection of override arguments to be used when executing this build step.
	Arguments *[]Argument `json:"arguments,omitempty"`
	// BaseImageDependencies - READ-ONLY; List of base image dependencies for a step.
	BaseImageDependencies *[]BaseImageDependency `json:"baseImageDependencies,omitempty"`
	// ContextPath - The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`
	// ContextAccessToken - The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`
	// Type - Possible values include: 'TypeTaskStepProperties', 'TypeDocker', 'TypeFileTask', 'TypeEncodedTask'
	Type TypeBasicTaskStepProperties `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DockerBuildStep.
func (dbs DockerBuildStep) MarshalJSON() ([]byte, error) {
	dbs.Type = TypeDocker
	objectMap := make(map[string]interface{})
	if dbs.ImageNames != nil {
		objectMap["imageNames"] = dbs.ImageNames
	}
	if dbs.IsPushEnabled != nil {
		objectMap["isPushEnabled"] = dbs.IsPushEnabled
	}
	if dbs.NoCache != nil {
		objectMap["noCache"] = dbs.NoCache
	}
	if dbs.DockerFilePath != nil {
		objectMap["dockerFilePath"] = dbs.DockerFilePath
	}
	if dbs.Target != nil {
		objectMap["target"] = dbs.Target
	}
	if dbs.Arguments != nil {
		objectMap["arguments"] = dbs.Arguments
	}
	if dbs.ContextPath != nil {
		objectMap["contextPath"] = dbs.ContextPath
	}
	if dbs.ContextAccessToken != nil {
		objectMap["contextAccessToken"] = dbs.ContextAccessToken
	}
	if dbs.Type != "" {
		objectMap["type"] = dbs.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStep is the BasicTaskStepProperties implementation for DockerBuildStep.
func (dbs DockerBuildStep) AsDockerBuildStep() (*DockerBuildStep, bool) {
	return &dbs, true
}

// AsFileTaskStep is the BasicTaskStepProperties implementation for DockerBuildStep.
func (dbs DockerBuildStep) AsFileTaskStep() (*FileTaskStep, bool) {
	return nil, false
}

// AsEncodedTaskStep is the BasicTaskStepProperties implementation for DockerBuildStep.
func (dbs DockerBuildStep) AsEncodedTaskStep() (*EncodedTaskStep, bool) {
	return nil, false
}

// AsTaskStepProperties is the BasicTaskStepProperties implementation for DockerBuildStep.
func (dbs DockerBuildStep) AsTaskStepProperties() (*TaskStepProperties, bool) {
	return nil, false
}

// AsBasicTaskStepProperties is the BasicTaskStepProperties implementation for DockerBuildStep.
func (dbs DockerBuildStep) AsBasicTaskStepProperties() (BasicTaskStepProperties, bool) {
	return &dbs, true
}

// DockerBuildStepUpdateParameters the properties for updating a docker build step.
type DockerBuildStepUpdateParameters struct {
	// ImageNames - The fully qualified image names including the repository and tag.
	ImageNames *[]string `json:"imageNames,omitempty"`
	// IsPushEnabled - The value of this property indicates whether the image built should be pushed to the registry or not.
	IsPushEnabled *bool `json:"isPushEnabled,omitempty"`
	// NoCache - The value of this property indicates whether the image cache is enabled or not.
	NoCache *bool `json:"noCache,omitempty"`
	// DockerFilePath - The Docker file path relative to the source context.
	DockerFilePath *string `json:"dockerFilePath,omitempty"`
	// Arguments - The collection of override arguments to be used when executing this build step.
	Arguments *[]Argument `json:"arguments,omitempty"`
	// Target - The name of the target build stage for the docker build.
	Target *string `json:"target,omitempty"`
	// ContextPath - The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`
	// ContextAccessToken - The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`
	// Type - Possible values include: 'TypeBasicTaskStepUpdateParametersTypeTaskStepUpdateParameters', 'TypeBasicTaskStepUpdateParametersTypeDocker', 'TypeBasicTaskStepUpdateParametersTypeFileTask', 'TypeBasicTaskStepUpdateParametersTypeEncodedTask'
	Type TypeBasicTaskStepUpdateParameters `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DockerBuildStepUpdateParameters.
func (dbsup DockerBuildStepUpdateParameters) MarshalJSON() ([]byte, error) {
	dbsup.Type = TypeBasicTaskStepUpdateParametersTypeDocker
	objectMap := make(map[string]interface{})
	if dbsup.ImageNames != nil {
		objectMap["imageNames"] = dbsup.ImageNames
	}
	if dbsup.IsPushEnabled != nil {
		objectMap["isPushEnabled"] = dbsup.IsPushEnabled
	}
	if dbsup.NoCache != nil {
		objectMap["noCache"] = dbsup.NoCache
	}
	if dbsup.DockerFilePath != nil {
		objectMap["dockerFilePath"] = dbsup.DockerFilePath
	}
	if dbsup.Arguments != nil {
		objectMap["arguments"] = dbsup.Arguments
	}
	if dbsup.Target != nil {
		objectMap["target"] = dbsup.Target
	}
	if dbsup.ContextPath != nil {
		objectMap["contextPath"] = dbsup.ContextPath
	}
	if dbsup.ContextAccessToken != nil {
		objectMap["contextAccessToken"] = dbsup.ContextAccessToken
	}
	if dbsup.Type != "" {
		objectMap["type"] = dbsup.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for DockerBuildStepUpdateParameters.
func (dbsup DockerBuildStepUpdateParameters) AsDockerBuildStepUpdateParameters() (*DockerBuildStepUpdateParameters, bool) {
	return &dbsup, true
}

// AsFileTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for DockerBuildStepUpdateParameters.
func (dbsup DockerBuildStepUpdateParameters) AsFileTaskStepUpdateParameters() (*FileTaskStepUpdateParameters, bool) {
	return nil, false
}

// AsEncodedTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for DockerBuildStepUpdateParameters.
func (dbsup DockerBuildStepUpdateParameters) AsEncodedTaskStepUpdateParameters() (*EncodedTaskStepUpdateParameters, bool) {
	return nil, false
}

// AsTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for DockerBuildStepUpdateParameters.
func (dbsup DockerBuildStepUpdateParameters) AsTaskStepUpdateParameters() (*TaskStepUpdateParameters, bool) {
	return nil, false
}

// AsBasicTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for DockerBuildStepUpdateParameters.
func (dbsup DockerBuildStepUpdateParameters) AsBasicTaskStepUpdateParameters() (BasicTaskStepUpdateParameters, bool) {
	return &dbsup, true
}

// EncodedTaskRunRequest the parameters for a quick task run request.
type EncodedTaskRunRequest struct {
	// EncodedTaskContent - Base64 encoded value of the template/definition file content.
	EncodedTaskContent *string `json:"encodedTaskContent,omitempty"`
	// EncodedValuesContent - Base64 encoded value of the parameters/values file content.
	EncodedValuesContent *string `json:"encodedValuesContent,omitempty"`
	// Values - The collection of overridable values that can be passed when running a task.
	Values *[]SetValue `json:"values,omitempty"`
	// Timeout - Run timeout in seconds.
	Timeout *int32 `json:"timeout,omitempty"`
	// Platform - The platform properties against which the run has to happen.
	Platform *PlatformProperties `json:"platform,omitempty"`
	// AgentConfiguration - The machine configuration of the run agent.
	AgentConfiguration *AgentProperties `json:"agentConfiguration,omitempty"`
	// SourceLocation - The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
	// If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
	SourceLocation *string `json:"sourceLocation,omitempty"`
	// Credentials - The properties that describes a set of credentials that will be used when this run is invoked.
	Credentials *Credentials `json:"credentials,omitempty"`
	// IsArchiveEnabled - The value that indicates whether archiving is enabled for the run or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`
	// Type - Possible values include: 'TypeRunRequest', 'TypeDockerBuildRequest', 'TypeFileTaskRunRequest', 'TypeTaskRunRequest', 'TypeEncodedTaskRunRequest'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EncodedTaskRunRequest.
func (etrr EncodedTaskRunRequest) MarshalJSON() ([]byte, error) {
	etrr.Type = TypeEncodedTaskRunRequest
	objectMap := make(map[string]interface{})
	if etrr.EncodedTaskContent != nil {
		objectMap["encodedTaskContent"] = etrr.EncodedTaskContent
	}
	if etrr.EncodedValuesContent != nil {
		objectMap["encodedValuesContent"] = etrr.EncodedValuesContent
	}
	if etrr.Values != nil {
		objectMap["values"] = etrr.Values
	}
	if etrr.Timeout != nil {
		objectMap["timeout"] = etrr.Timeout
	}
	if etrr.Platform != nil {
		objectMap["platform"] = etrr.Platform
	}
	if etrr.AgentConfiguration != nil {
		objectMap["agentConfiguration"] = etrr.AgentConfiguration
	}
	if etrr.SourceLocation != nil {
		objectMap["sourceLocation"] = etrr.SourceLocation
	}
	if etrr.Credentials != nil {
		objectMap["credentials"] = etrr.Credentials
	}
	if etrr.IsArchiveEnabled != nil {
		objectMap["isArchiveEnabled"] = etrr.IsArchiveEnabled
	}
	if etrr.Type != "" {
		objectMap["type"] = etrr.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildRequest is the BasicRunRequest implementation for EncodedTaskRunRequest.
func (etrr EncodedTaskRunRequest) AsDockerBuildRequest() (*DockerBuildRequest, bool) {
	return nil, false
}

// AsFileTaskRunRequest is the BasicRunRequest implementation for EncodedTaskRunRequest.
func (etrr EncodedTaskRunRequest) AsFileTaskRunRequest() (*FileTaskRunRequest, bool) {
	return nil, false
}

// AsTaskRunRequest is the BasicRunRequest implementation for EncodedTaskRunRequest.
func (etrr EncodedTaskRunRequest) AsTaskRunRequest() (*TaskRunRequest, bool) {
	return nil, false
}

// AsEncodedTaskRunRequest is the BasicRunRequest implementation for EncodedTaskRunRequest.
func (etrr EncodedTaskRunRequest) AsEncodedTaskRunRequest() (*EncodedTaskRunRequest, bool) {
	return &etrr, true
}

// AsRunRequest is the BasicRunRequest implementation for EncodedTaskRunRequest.
func (etrr EncodedTaskRunRequest) AsRunRequest() (*RunRequest, bool) {
	return nil, false
}

// AsBasicRunRequest is the BasicRunRequest implementation for EncodedTaskRunRequest.
func (etrr EncodedTaskRunRequest) AsBasicRunRequest() (BasicRunRequest, bool) {
	return &etrr, true
}

// EncodedTaskStep the properties of a encoded task step.
type EncodedTaskStep struct {
	// EncodedTaskContent - Base64 encoded value of the template/definition file content.
	EncodedTaskContent *string `json:"encodedTaskContent,omitempty"`
	// EncodedValuesContent - Base64 encoded value of the parameters/values file content.
	EncodedValuesContent *string `json:"encodedValuesContent,omitempty"`
	// Values - The collection of overridable values that can be passed when running a task.
	Values *[]SetValue `json:"values,omitempty"`
	// BaseImageDependencies - READ-ONLY; List of base image dependencies for a step.
	BaseImageDependencies *[]BaseImageDependency `json:"baseImageDependencies,omitempty"`
	// ContextPath - The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`
	// ContextAccessToken - The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`
	// Type - Possible values include: 'TypeTaskStepProperties', 'TypeDocker', 'TypeFileTask', 'TypeEncodedTask'
	Type TypeBasicTaskStepProperties `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EncodedTaskStep.
func (ets EncodedTaskStep) MarshalJSON() ([]byte, error) {
	ets.Type = TypeEncodedTask
	objectMap := make(map[string]interface{})
	if ets.EncodedTaskContent != nil {
		objectMap["encodedTaskContent"] = ets.EncodedTaskContent
	}
	if ets.EncodedValuesContent != nil {
		objectMap["encodedValuesContent"] = ets.EncodedValuesContent
	}
	if ets.Values != nil {
		objectMap["values"] = ets.Values
	}
	if ets.ContextPath != nil {
		objectMap["contextPath"] = ets.ContextPath
	}
	if ets.ContextAccessToken != nil {
		objectMap["contextAccessToken"] = ets.ContextAccessToken
	}
	if ets.Type != "" {
		objectMap["type"] = ets.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStep is the BasicTaskStepProperties implementation for EncodedTaskStep.
func (ets EncodedTaskStep) AsDockerBuildStep() (*DockerBuildStep, bool) {
	return nil, false
}

// AsFileTaskStep is the BasicTaskStepProperties implementation for EncodedTaskStep.
func (ets EncodedTaskStep) AsFileTaskStep() (*FileTaskStep, bool) {
	return nil, false
}

// AsEncodedTaskStep is the BasicTaskStepProperties implementation for EncodedTaskStep.
func (ets EncodedTaskStep) AsEncodedTaskStep() (*EncodedTaskStep, bool) {
	return &ets, true
}

// AsTaskStepProperties is the BasicTaskStepProperties implementation for EncodedTaskStep.
func (ets EncodedTaskStep) AsTaskStepProperties() (*TaskStepProperties, bool) {
	return nil, false
}

// AsBasicTaskStepProperties is the BasicTaskStepProperties implementation for EncodedTaskStep.
func (ets EncodedTaskStep) AsBasicTaskStepProperties() (BasicTaskStepProperties, bool) {
	return &ets, true
}

// EncodedTaskStepUpdateParameters the properties for updating encoded task step.
type EncodedTaskStepUpdateParameters struct {
	// EncodedTaskContent - Base64 encoded value of the template/definition file content.
	EncodedTaskContent *string `json:"encodedTaskContent,omitempty"`
	// EncodedValuesContent - Base64 encoded value of the parameters/values file content.
	EncodedValuesContent *string `json:"encodedValuesContent,omitempty"`
	// Values - The collection of overridable values that can be passed when running a task.
	Values *[]SetValue `json:"values,omitempty"`
	// ContextPath - The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`
	// ContextAccessToken - The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`
	// Type - Possible values include: 'TypeBasicTaskStepUpdateParametersTypeTaskStepUpdateParameters', 'TypeBasicTaskStepUpdateParametersTypeDocker', 'TypeBasicTaskStepUpdateParametersTypeFileTask', 'TypeBasicTaskStepUpdateParametersTypeEncodedTask'
	Type TypeBasicTaskStepUpdateParameters `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EncodedTaskStepUpdateParameters.
func (etsup EncodedTaskStepUpdateParameters) MarshalJSON() ([]byte, error) {
	etsup.Type = TypeBasicTaskStepUpdateParametersTypeEncodedTask
	objectMap := make(map[string]interface{})
	if etsup.EncodedTaskContent != nil {
		objectMap["encodedTaskContent"] = etsup.EncodedTaskContent
	}
	if etsup.EncodedValuesContent != nil {
		objectMap["encodedValuesContent"] = etsup.EncodedValuesContent
	}
	if etsup.Values != nil {
		objectMap["values"] = etsup.Values
	}
	if etsup.ContextPath != nil {
		objectMap["contextPath"] = etsup.ContextPath
	}
	if etsup.ContextAccessToken != nil {
		objectMap["contextAccessToken"] = etsup.ContextAccessToken
	}
	if etsup.Type != "" {
		objectMap["type"] = etsup.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for EncodedTaskStepUpdateParameters.
func (etsup EncodedTaskStepUpdateParameters) AsDockerBuildStepUpdateParameters() (*DockerBuildStepUpdateParameters, bool) {
	return nil, false
}

// AsFileTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for EncodedTaskStepUpdateParameters.
func (etsup EncodedTaskStepUpdateParameters) AsFileTaskStepUpdateParameters() (*FileTaskStepUpdateParameters, bool) {
	return nil, false
}

// AsEncodedTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for EncodedTaskStepUpdateParameters.
func (etsup EncodedTaskStepUpdateParameters) AsEncodedTaskStepUpdateParameters() (*EncodedTaskStepUpdateParameters, bool) {
	return &etsup, true
}

// AsTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for EncodedTaskStepUpdateParameters.
func (etsup EncodedTaskStepUpdateParameters) AsTaskStepUpdateParameters() (*TaskStepUpdateParameters, bool) {
	return nil, false
}

// AsBasicTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for EncodedTaskStepUpdateParameters.
func (etsup EncodedTaskStepUpdateParameters) AsBasicTaskStepUpdateParameters() (BasicTaskStepUpdateParameters, bool) {
	return &etsup, true
}

// Event the event for a webhook.
type Event struct {
	// EventRequestMessage - The event request message sent to the service URI.
	EventRequestMessage *EventRequestMessage `json:"eventRequestMessage,omitempty"`
	// EventResponseMessage - The event response message received from the service URI.
	EventResponseMessage *EventResponseMessage `json:"eventResponseMessage,omitempty"`
	// ID - The event ID.
	ID *string `json:"id,omitempty"`
}

// EventContent the content of the event request message.
type EventContent struct {
	// ID - The event ID.
	ID *string `json:"id,omitempty"`
	// Timestamp - The time at which the event occurred.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Action - The action that encompasses the provided event.
	Action *string `json:"action,omitempty"`
	// Target - The target of the event.
	Target *Target `json:"target,omitempty"`
	// Request - The request that generated the event.
	Request *Request `json:"request,omitempty"`
	// Actor - The agent that initiated the event. For most situations, this could be from the authorization context of the request.
	Actor *Actor `json:"actor,omitempty"`
	// Source - The registry node that generated the event. Put differently, while the actor initiates the event, the source generates it.
	Source *Source `json:"source,omitempty"`
}

// EventInfo the basic information of an event.
type EventInfo struct {
	autorest.Response `json:"-"`
	// ID - The event ID.
	ID *string `json:"id,omitempty"`
}

// EventListResult the result of a request to list events for a webhook.
type EventListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of events. Since this list may be incomplete, the nextLink field should be used to request the next list of events.
	Value *[]Event `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of events.
	NextLink *string `json:"nextLink,omitempty"`
}

// EventListResultIterator provides access to a complete listing of Event values.
type EventListResultIterator struct {
	i    int
	page EventListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EventListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EventListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EventListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EventListResultIterator) Response() EventListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EventListResultIterator) Value() Event {
	if !iter.page.NotDone() {
		return Event{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EventListResultIterator type.
func NewEventListResultIterator(page EventListResultPage) EventListResultIterator {
	return EventListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (elr EventListResult) IsEmpty() bool {
	return elr.Value == nil || len(*elr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (elr EventListResult) hasNextLink() bool {
	return elr.NextLink != nil && len(*elr.NextLink) != 0
}

// eventListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (elr EventListResult) eventListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !elr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(elr.NextLink)))
}

// EventListResultPage contains a page of Event values.
type EventListResultPage struct {
	fn  func(context.Context, EventListResult) (EventListResult, error)
	elr EventListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EventListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.elr)
		if err != nil {
			return err
		}
		page.elr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EventListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EventListResultPage) NotDone() bool {
	return !page.elr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EventListResultPage) Response() EventListResult {
	return page.elr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EventListResultPage) Values() []Event {
	if page.elr.IsEmpty() {
		return nil
	}
	return *page.elr.Value
}

// Creates a new instance of the EventListResultPage type.
func NewEventListResultPage(getNextPage func(context.Context, EventListResult) (EventListResult, error)) EventListResultPage {
	return EventListResultPage{fn: getNextPage}
}

// EventRequestMessage the event request message sent to the service URI.
type EventRequestMessage struct {
	// Content - The content of the event request message.
	Content *EventContent `json:"content,omitempty"`
	// Headers - The headers of the event request message.
	Headers map[string]*string `json:"headers"`
	// Method - The HTTP method used to send the event request message.
	Method *string `json:"method,omitempty"`
	// RequestURI - The URI used to send the event request message.
	RequestURI *string `json:"requestUri,omitempty"`
	// Version - The HTTP message version.
	Version *string `json:"version,omitempty"`
}

// MarshalJSON is the custom marshaler for EventRequestMessage.
func (erm EventRequestMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erm.Content != nil {
		objectMap["content"] = erm.Content
	}
	if erm.Headers != nil {
		objectMap["headers"] = erm.Headers
	}
	if erm.Method != nil {
		objectMap["method"] = erm.Method
	}
	if erm.RequestURI != nil {
		objectMap["requestUri"] = erm.RequestURI
	}
	if erm.Version != nil {
		objectMap["version"] = erm.Version
	}
	return json.Marshal(objectMap)
}

// EventResponseMessage the event response message received from the service URI.
type EventResponseMessage struct {
	// Content - The content of the event response message.
	Content *string `json:"content,omitempty"`
	// Headers - The headers of the event response message.
	Headers map[string]*string `json:"headers"`
	// ReasonPhrase - The reason phrase of the event response message.
	ReasonPhrase *string `json:"reasonPhrase,omitempty"`
	// StatusCode - The status code of the event response message.
	StatusCode *string `json:"statusCode,omitempty"`
	// Version - The HTTP message version.
	Version *string `json:"version,omitempty"`
}

// MarshalJSON is the custom marshaler for EventResponseMessage.
func (erm EventResponseMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erm.Content != nil {
		objectMap["content"] = erm.Content
	}
	if erm.Headers != nil {
		objectMap["headers"] = erm.Headers
	}
	if erm.ReasonPhrase != nil {
		objectMap["reasonPhrase"] = erm.ReasonPhrase
	}
	if erm.StatusCode != nil {
		objectMap["statusCode"] = erm.StatusCode
	}
	if erm.Version != nil {
		objectMap["version"] = erm.Version
	}
	return json.Marshal(objectMap)
}

// FileTaskRunRequest the request parameters for a scheduling run against a task file.
type FileTaskRunRequest struct {
	// TaskFilePath - The template/definition file path relative to the source.
	TaskFilePath *string `json:"taskFilePath,omitempty"`
	// ValuesFilePath - The values/parameters file path relative to the source.
	ValuesFilePath *string `json:"valuesFilePath,omitempty"`
	// Values - The collection of overridable values that can be passed when running a task.
	Values *[]SetValue `json:"values,omitempty"`
	// Timeout - Run timeout in seconds.
	Timeout *int32 `json:"timeout,omitempty"`
	// Platform - The platform properties against which the run has to happen.
	Platform *PlatformProperties `json:"platform,omitempty"`
	// AgentConfiguration - The machine configuration of the run agent.
	AgentConfiguration *AgentProperties `json:"agentConfiguration,omitempty"`
	// SourceLocation - The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
	// If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
	SourceLocation *string `json:"sourceLocation,omitempty"`
	// Credentials - The properties that describes a set of credentials that will be used when this run is invoked.
	Credentials *Credentials `json:"credentials,omitempty"`
	// IsArchiveEnabled - The value that indicates whether archiving is enabled for the run or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`
	// Type - Possible values include: 'TypeRunRequest', 'TypeDockerBuildRequest', 'TypeFileTaskRunRequest', 'TypeTaskRunRequest', 'TypeEncodedTaskRunRequest'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FileTaskRunRequest.
func (ftrr FileTaskRunRequest) MarshalJSON() ([]byte, error) {
	ftrr.Type = TypeFileTaskRunRequest
	objectMap := make(map[string]interface{})
	if ftrr.TaskFilePath != nil {
		objectMap["taskFilePath"] = ftrr.TaskFilePath
	}
	if ftrr.ValuesFilePath != nil {
		objectMap["valuesFilePath"] = ftrr.ValuesFilePath
	}
	if ftrr.Values != nil {
		objectMap["values"] = ftrr.Values
	}
	if ftrr.Timeout != nil {
		objectMap["timeout"] = ftrr.Timeout
	}
	if ftrr.Platform != nil {
		objectMap["platform"] = ftrr.Platform
	}
	if ftrr.AgentConfiguration != nil {
		objectMap["agentConfiguration"] = ftrr.AgentConfiguration
	}
	if ftrr.SourceLocation != nil {
		objectMap["sourceLocation"] = ftrr.SourceLocation
	}
	if ftrr.Credentials != nil {
		objectMap["credentials"] = ftrr.Credentials
	}
	if ftrr.IsArchiveEnabled != nil {
		objectMap["isArchiveEnabled"] = ftrr.IsArchiveEnabled
	}
	if ftrr.Type != "" {
		objectMap["type"] = ftrr.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildRequest is the BasicRunRequest implementation for FileTaskRunRequest.
func (ftrr FileTaskRunRequest) AsDockerBuildRequest() (*DockerBuildRequest, bool) {
	return nil, false
}

// AsFileTaskRunRequest is the BasicRunRequest implementation for FileTaskRunRequest.
func (ftrr FileTaskRunRequest) AsFileTaskRunRequest() (*FileTaskRunRequest, bool) {
	return &ftrr, true
}

// AsTaskRunRequest is the BasicRunRequest implementation for FileTaskRunRequest.
func (ftrr FileTaskRunRequest) AsTaskRunRequest() (*TaskRunRequest, bool) {
	return nil, false
}

// AsEncodedTaskRunRequest is the BasicRunRequest implementation for FileTaskRunRequest.
func (ftrr FileTaskRunRequest) AsEncodedTaskRunRequest() (*EncodedTaskRunRequest, bool) {
	return nil, false
}

// AsRunRequest is the BasicRunRequest implementation for FileTaskRunRequest.
func (ftrr FileTaskRunRequest) AsRunRequest() (*RunRequest, bool) {
	return nil, false
}

// AsBasicRunRequest is the BasicRunRequest implementation for FileTaskRunRequest.
func (ftrr FileTaskRunRequest) AsBasicRunRequest() (BasicRunRequest, bool) {
	return &ftrr, true
}

// FileTaskStep the properties of a task step.
type FileTaskStep struct {
	// TaskFilePath - The task template/definition file path relative to the source context.
	TaskFilePath *string `json:"taskFilePath,omitempty"`
	// ValuesFilePath - The task values/parameters file path relative to the source context.
	ValuesFilePath *string `json:"valuesFilePath,omitempty"`
	// Values - The collection of overridable values that can be passed when running a task.
	Values *[]SetValue `json:"values,omitempty"`
	// BaseImageDependencies - READ-ONLY; List of base image dependencies for a step.
	BaseImageDependencies *[]BaseImageDependency `json:"baseImageDependencies,omitempty"`
	// ContextPath - The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`
	// ContextAccessToken - The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`
	// Type - Possible values include: 'TypeTaskStepProperties', 'TypeDocker', 'TypeFileTask', 'TypeEncodedTask'
	Type TypeBasicTaskStepProperties `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FileTaskStep.
func (fts FileTaskStep) MarshalJSON() ([]byte, error) {
	fts.Type = TypeFileTask
	objectMap := make(map[string]interface{})
	if fts.TaskFilePath != nil {
		objectMap["taskFilePath"] = fts.TaskFilePath
	}
	if fts.ValuesFilePath != nil {
		objectMap["valuesFilePath"] = fts.ValuesFilePath
	}
	if fts.Values != nil {
		objectMap["values"] = fts.Values
	}
	if fts.ContextPath != nil {
		objectMap["contextPath"] = fts.ContextPath
	}
	if fts.ContextAccessToken != nil {
		objectMap["contextAccessToken"] = fts.ContextAccessToken
	}
	if fts.Type != "" {
		objectMap["type"] = fts.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStep is the BasicTaskStepProperties implementation for FileTaskStep.
func (fts FileTaskStep) AsDockerBuildStep() (*DockerBuildStep, bool) {
	return nil, false
}

// AsFileTaskStep is the BasicTaskStepProperties implementation for FileTaskStep.
func (fts FileTaskStep) AsFileTaskStep() (*FileTaskStep, bool) {
	return &fts, true
}

// AsEncodedTaskStep is the BasicTaskStepProperties implementation for FileTaskStep.
func (fts FileTaskStep) AsEncodedTaskStep() (*EncodedTaskStep, bool) {
	return nil, false
}

// AsTaskStepProperties is the BasicTaskStepProperties implementation for FileTaskStep.
func (fts FileTaskStep) AsTaskStepProperties() (*TaskStepProperties, bool) {
	return nil, false
}

// AsBasicTaskStepProperties is the BasicTaskStepProperties implementation for FileTaskStep.
func (fts FileTaskStep) AsBasicTaskStepProperties() (BasicTaskStepProperties, bool) {
	return &fts, true
}

// FileTaskStepUpdateParameters the properties of updating a task step.
type FileTaskStepUpdateParameters struct {
	// TaskFilePath - The task template/definition file path relative to the source context.
	TaskFilePath *string `json:"taskFilePath,omitempty"`
	// ValuesFilePath - The values/parameters file path relative to the source context.
	ValuesFilePath *string `json:"valuesFilePath,omitempty"`
	// Values - The collection of overridable values that can be passed when running a task.
	Values *[]SetValue `json:"values,omitempty"`
	// ContextPath - The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`
	// ContextAccessToken - The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`
	// Type - Possible values include: 'TypeBasicTaskStepUpdateParametersTypeTaskStepUpdateParameters', 'TypeBasicTaskStepUpdateParametersTypeDocker', 'TypeBasicTaskStepUpdateParametersTypeFileTask', 'TypeBasicTaskStepUpdateParametersTypeEncodedTask'
	Type TypeBasicTaskStepUpdateParameters `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FileTaskStepUpdateParameters.
func (ftsup FileTaskStepUpdateParameters) MarshalJSON() ([]byte, error) {
	ftsup.Type = TypeBasicTaskStepUpdateParametersTypeFileTask
	objectMap := make(map[string]interface{})
	if ftsup.TaskFilePath != nil {
		objectMap["taskFilePath"] = ftsup.TaskFilePath
	}
	if ftsup.ValuesFilePath != nil {
		objectMap["valuesFilePath"] = ftsup.ValuesFilePath
	}
	if ftsup.Values != nil {
		objectMap["values"] = ftsup.Values
	}
	if ftsup.ContextPath != nil {
		objectMap["contextPath"] = ftsup.ContextPath
	}
	if ftsup.ContextAccessToken != nil {
		objectMap["contextAccessToken"] = ftsup.ContextAccessToken
	}
	if ftsup.Type != "" {
		objectMap["type"] = ftsup.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for FileTaskStepUpdateParameters.
func (ftsup FileTaskStepUpdateParameters) AsDockerBuildStepUpdateParameters() (*DockerBuildStepUpdateParameters, bool) {
	return nil, false
}

// AsFileTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for FileTaskStepUpdateParameters.
func (ftsup FileTaskStepUpdateParameters) AsFileTaskStepUpdateParameters() (*FileTaskStepUpdateParameters, bool) {
	return &ftsup, true
}

// AsEncodedTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for FileTaskStepUpdateParameters.
func (ftsup FileTaskStepUpdateParameters) AsEncodedTaskStepUpdateParameters() (*EncodedTaskStepUpdateParameters, bool) {
	return nil, false
}

// AsTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for FileTaskStepUpdateParameters.
func (ftsup FileTaskStepUpdateParameters) AsTaskStepUpdateParameters() (*TaskStepUpdateParameters, bool) {
	return nil, false
}

// AsBasicTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for FileTaskStepUpdateParameters.
func (ftsup FileTaskStepUpdateParameters) AsBasicTaskStepUpdateParameters() (BasicTaskStepUpdateParameters, bool) {
	return &ftsup, true
}

// IdentityProperties managed identity for the resource.
type IdentityProperties struct {
	// PrincipalID - The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'SystemAssigned', 'UserAssigned', 'SystemAssignedUserAssigned', 'None'
	Type ResourceIdentityType `json:"type,omitempty"`
	// UserAssignedIdentities - The list of user identities associated with the resource. The user identity
	// dictionary key references will be ARM resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
	//     providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*UserIdentityProperties `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for IdentityProperties.
func (IP IdentityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if IP.PrincipalID != nil {
		objectMap["principalId"] = IP.PrincipalID
	}
	if IP.TenantID != nil {
		objectMap["tenantId"] = IP.TenantID
	}
	if IP.Type != "" {
		objectMap["type"] = IP.Type
	}
	if IP.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = IP.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// ImageDescriptor properties for a registry image.
type ImageDescriptor struct {
	// Registry - The registry login server.
	Registry *string `json:"registry,omitempty"`
	// Repository - The repository name.
	Repository *string `json:"repository,omitempty"`
	// Tag - The tag name.
	Tag *string `json:"tag,omitempty"`
	// Digest - The sha256-based digest of the image manifest.
	Digest *string `json:"digest,omitempty"`
}

// ImageUpdateTrigger the image update trigger that caused a build.
type ImageUpdateTrigger struct {
	// ID - The unique ID of the trigger.
	ID *string `json:"id,omitempty"`
	// Timestamp - The timestamp when the image update happened.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Images - The list of image updates that caused the build.
	Images *[]ImageDescriptor `json:"images,omitempty"`
}

// ImportImageParameters ...
type ImportImageParameters struct {
	// Source - The source of the image.
	Source *ImportSource `json:"source,omitempty"`
	// TargetTags - List of strings of the form repo[:tag]. When tag is omitted the source will be used (or 'latest' if source tag is also omitted).
	TargetTags *[]string `json:"targetTags,omitempty"`
	// UntaggedTargetRepositories - List of strings of repository names to do a manifest only copy. No tag will be created.
	UntaggedTargetRepositories *[]string `json:"untaggedTargetRepositories,omitempty"`
	// Mode - When Force, any existing target tags will be overwritten. When NoForce, any existing target tags will fail the operation before any copying begins. Possible values include: 'NoForce', 'Force'
	Mode ImportMode `json:"mode,omitempty"`
}

// ImportSource ...
type ImportSource struct {
	// ResourceID - The resource identifier of the source Azure Container Registry.
	ResourceID *string `json:"resourceId,omitempty"`
	// RegistryURI - The address of the source registry (e.g. 'mcr.microsoft.com').
	RegistryURI *string `json:"registryUri,omitempty"`
	// Credentials - Credentials used when importing from a registry uri.
	Credentials *ImportSourceCredentials `json:"credentials,omitempty"`
	// SourceImage - Repository name of the source image.
	// Specify an image by repository ('hello-world'). This will use the 'latest' tag.
	// Specify an image by tag ('hello-world:latest').
	// Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123').
	SourceImage *string `json:"sourceImage,omitempty"`
}

// ImportSourceCredentials ...
type ImportSourceCredentials struct {
	// Username - The username to authenticate with the source registry.
	Username *string `json:"username,omitempty"`
	// Password - The password used to authenticate with the source registry.
	Password *string `json:"password,omitempty"`
}

// IPRule IP rule with specific IP or IP range in CIDR format.
type IPRule struct {
	// Action - The action of IP ACL rule. Possible values include: 'Allow'
	Action Action `json:"action,omitempty"`
	// IPAddressOrRange - Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
	IPAddressOrRange *string `json:"value,omitempty"`
}

// NetworkRuleSet the network rule set for a container registry.
type NetworkRuleSet struct {
	// DefaultAction - The default action of allow or deny when no other rules match. Possible values include: 'DefaultActionAllow', 'DefaultActionDeny'
	DefaultAction DefaultAction `json:"defaultAction,omitempty"`
	// VirtualNetworkRules - The virtual network rules.
	VirtualNetworkRules *[]VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
	// IPRules - The IP ACL rules.
	IPRules *[]IPRule `json:"ipRules,omitempty"`
}

// OperationDefinition the definition of a container registry operation.
type OperationDefinition struct {
	// Origin - The origin information of the container registry operation.
	Origin *string `json:"origin,omitempty"`
	// Name - Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
	// Display - The display information for the container registry operation.
	Display *OperationDisplayDefinition `json:"display,omitempty"`
	// OperationPropertiesDefinition - The properties information for the container registry operation.
	*OperationPropertiesDefinition `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDefinition.
func (od OperationDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if od.Origin != nil {
		objectMap["origin"] = od.Origin
	}
	if od.Name != nil {
		objectMap["name"] = od.Name
	}
	if od.Display != nil {
		objectMap["display"] = od.Display
	}
	if od.OperationPropertiesDefinition != nil {
		objectMap["properties"] = od.OperationPropertiesDefinition
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OperationDefinition struct.
func (od *OperationDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				od.Origin = &origin
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				od.Name = &name
			}
		case "display":
			if v != nil {
				var display OperationDisplayDefinition
				err = json.Unmarshal(*v, &display)
				if err != nil {
					return err
				}
				od.Display = &display
			}
		case "properties":
			if v != nil {
				var operationPropertiesDefinition OperationPropertiesDefinition
				err = json.Unmarshal(*v, &operationPropertiesDefinition)
				if err != nil {
					return err
				}
				od.OperationPropertiesDefinition = &operationPropertiesDefinition
			}
		}
	}

	return nil
}

// OperationDisplayDefinition the display information for a container registry operation.
type OperationDisplayDefinition struct {
	// Provider - The resource provider name: Microsoft.ContainerRegistry.
	Provider *string `json:"provider,omitempty"`
	// Resource - The resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - The operation that users can perform.
	Operation *string `json:"operation,omitempty"`
	// Description - The description for the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult the result of a request to list container registry operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of container registry operations. Since this list may be incomplete, the nextLink field should be used to request the next list of operations.
	Value *[]OperationDefinition `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of container registry operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of OperationDefinition values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() OperationDefinition {
	if !iter.page.NotDone() {
		return OperationDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of OperationDefinition values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []OperationDefinition {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{fn: getNextPage}
}

// OperationMetricSpecificationDefinition the definition of Azure Monitoring metric.
type OperationMetricSpecificationDefinition struct {
	// Name - Metric name.
	Name *string `json:"name,omitempty"`
	// DisplayName - Metric display name.
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - Metric description.
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - Metric unit.
	Unit *string `json:"unit,omitempty"`
	// AggregationType - Metric aggregation type.
	AggregationType *string `json:"aggregationType,omitempty"`
	// InternalMetricName - Internal metric name.
	InternalMetricName *string `json:"internalMetricName,omitempty"`
}

// OperationPropertiesDefinition the definition of Azure Monitoring properties.
type OperationPropertiesDefinition struct {
	// ServiceSpecification - The definition of Azure Monitoring service.
	ServiceSpecification *OperationServiceSpecificationDefinition `json:"serviceSpecification,omitempty"`
}

// OperationServiceSpecificationDefinition the definition of Azure Monitoring list.
type OperationServiceSpecificationDefinition struct {
	// MetricSpecifications - A list of Azure Monitoring metrics definition.
	MetricSpecifications *[]OperationMetricSpecificationDefinition `json:"metricSpecifications,omitempty"`
}

// PlatformProperties the platform properties against which the run has to happen.
type PlatformProperties struct {
	// Os - The operating system type required for the run. Possible values include: 'Windows', 'Linux'
	Os OS `json:"os,omitempty"`
	// Architecture - The OS architecture. Possible values include: 'Amd64', 'X86', 'Arm'
	Architecture Architecture `json:"architecture,omitempty"`
	// Variant - Variant of the CPU. Possible values include: 'V6', 'V7', 'V8'
	Variant Variant `json:"variant,omitempty"`
}

// PlatformUpdateParameters the properties for updating the platform configuration.
type PlatformUpdateParameters struct {
	// Os - The operating system type required for the run. Possible values include: 'Windows', 'Linux'
	Os OS `json:"os,omitempty"`
	// Architecture - The OS architecture. Possible values include: 'Amd64', 'X86', 'Arm'
	Architecture Architecture `json:"architecture,omitempty"`
	// Variant - Variant of the CPU. Possible values include: 'V6', 'V7', 'V8'
	Variant Variant `json:"variant,omitempty"`
}

// Policies the policies for a container registry.
type Policies struct {
	// QuarantinePolicy - The quarantine policy for a container registry.
	QuarantinePolicy *QuarantinePolicy `json:"quarantinePolicy,omitempty"`
	// TrustPolicy - The content trust policy for a container registry.
	TrustPolicy *TrustPolicy `json:"trustPolicy,omitempty"`
	// RetentionPolicy - The retention policy for a container registry.
	RetentionPolicy *RetentionPolicy `json:"retentionPolicy,omitempty"`
}

// ProxyResource the resource model definition for a ARM proxy resource. It will have everything other than
// required location and tags.
type ProxyResource struct {
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// QuarantinePolicy the quarantine policy for a container registry.
type QuarantinePolicy struct {
	// Status - The value that indicates whether the policy is enabled or not. Possible values include: 'Enabled', 'Disabled'
	Status PolicyStatus `json:"status,omitempty"`
}

// RegenerateCredentialParameters the parameters used to regenerate the login credential.
type RegenerateCredentialParameters struct {
	// Name - Specifies name of the password which should be regenerated -- password or password2. Possible values include: 'Password', 'Password2'
	Name PasswordName `json:"name,omitempty"`
}

// RegistriesCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RegistriesCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *RegistriesCreateFuture) Result(client RegistriesClient) (r Registry, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RegistriesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.RegistriesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.CreateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.RegistriesCreateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RegistriesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RegistriesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *RegistriesDeleteFuture) Result(client RegistriesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RegistriesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.RegistriesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RegistriesImportImageFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RegistriesImportImageFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *RegistriesImportImageFuture) Result(client RegistriesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RegistriesImportImageFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.RegistriesImportImageFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RegistriesScheduleRunFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RegistriesScheduleRunFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *RegistriesScheduleRunFuture) Result(client RegistriesClient) (r Run, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RegistriesScheduleRunFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.RegistriesScheduleRunFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.ScheduleRunResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.RegistriesScheduleRunFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RegistriesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RegistriesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *RegistriesUpdateFuture) Result(client RegistriesClient) (r Registry, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RegistriesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.RegistriesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.UpdateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.RegistriesUpdateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Registry an object that represents a container registry.
type Registry struct {
	autorest.Response `json:"-"`
	// Sku - The SKU of the container registry.
	Sku *Sku `json:"sku,omitempty"`
	// RegistryProperties - The properties of the container registry.
	*RegistryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Registry.
func (r Registry) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Sku != nil {
		objectMap["sku"] = r.Sku
	}
	if r.RegistryProperties != nil {
		objectMap["properties"] = r.RegistryProperties
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Registry struct.
func (r *Registry) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				r.Sku = &sku
			}
		case "properties":
			if v != nil {
				var registryProperties RegistryProperties
				err = json.Unmarshal(*v, &registryProperties)
				if err != nil {
					return err
				}
				r.RegistryProperties = &registryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				r.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				r.Tags = tags
			}
		}
	}

	return nil
}

// RegistryListCredentialsResult the response from the ListCredentials operation.
type RegistryListCredentialsResult struct {
	autorest.Response `json:"-"`
	// Username - The username for a container registry.
	Username *string `json:"username,omitempty"`
	// Passwords - The list of passwords for a container registry.
	Passwords *[]RegistryPassword `json:"passwords,omitempty"`
}

// RegistryListResult the result of a request to list container registries.
type RegistryListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of container registries. Since this list may be incomplete, the nextLink field should be used to request the next list of container registries.
	Value *[]Registry `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of container registries.
	NextLink *string `json:"nextLink,omitempty"`
}

// RegistryListResultIterator provides access to a complete listing of Registry values.
type RegistryListResultIterator struct {
	i    int
	page RegistryListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RegistryListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegistryListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RegistryListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RegistryListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RegistryListResultIterator) Response() RegistryListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RegistryListResultIterator) Value() Registry {
	if !iter.page.NotDone() {
		return Registry{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RegistryListResultIterator type.
func NewRegistryListResultIterator(page RegistryListResultPage) RegistryListResultIterator {
	return RegistryListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr RegistryListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rlr RegistryListResult) hasNextLink() bool {
	return rlr.NextLink != nil && len(*rlr.NextLink) != 0
}

// registryListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr RegistryListResult) registryListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// RegistryListResultPage contains a page of Registry values.
type RegistryListResultPage struct {
	fn  func(context.Context, RegistryListResult) (RegistryListResult, error)
	rlr RegistryListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RegistryListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegistryListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rlr)
		if err != nil {
			return err
		}
		page.rlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RegistryListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RegistryListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RegistryListResultPage) Response() RegistryListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RegistryListResultPage) Values() []Registry {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Creates a new instance of the RegistryListResultPage type.
func NewRegistryListResultPage(getNextPage func(context.Context, RegistryListResult) (RegistryListResult, error)) RegistryListResultPage {
	return RegistryListResultPage{fn: getNextPage}
}

// RegistryNameCheckRequest a request to check whether a container registry name is available.
type RegistryNameCheckRequest struct {
	// Name - The name of the container registry.
	Name *string `json:"name,omitempty"`
	// Type - The resource type of the container registry. This field must be set to 'Microsoft.ContainerRegistry/registries'.
	Type *string `json:"type,omitempty"`
}

// RegistryNameStatus the result of a request to check the availability of a container registry name.
type RegistryNameStatus struct {
	autorest.Response `json:"-"`
	// NameAvailable - The value that indicates whether the name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - If any, the reason that the name is not available.
	Reason *string `json:"reason,omitempty"`
	// Message - If any, the error message that provides more detail for the reason that the name is not available.
	Message *string `json:"message,omitempty"`
}

// RegistryPassword the login password for the container registry.
type RegistryPassword struct {
	// Name - The password name. Possible values include: 'Password', 'Password2'
	Name PasswordName `json:"name,omitempty"`
	// Value - The password value.
	Value *string `json:"value,omitempty"`
}

// RegistryProperties the properties of a container registry.
type RegistryProperties struct {
	// LoginServer - READ-ONLY; The URL that can be used to log into the container registry.
	LoginServer *string `json:"loginServer,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the container registry in ISO8601 format.
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the container registry at the time the operation was called. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Status - READ-ONLY; The status of the container registry at the time the operation was called.
	Status *Status `json:"status,omitempty"`
	// AdminUserEnabled - The value that indicates whether the admin user is enabled.
	AdminUserEnabled *bool `json:"adminUserEnabled,omitempty"`
	// StorageAccount - The properties of the storage account for the container registry. Only applicable to Classic SKU.
	StorageAccount *StorageAccountProperties `json:"storageAccount,omitempty"`
	// NetworkRuleSet - The network rule set for a container registry.
	NetworkRuleSet *NetworkRuleSet `json:"networkRuleSet,omitempty"`
	// Policies - The policies for a container registry.
	Policies *Policies `json:"policies,omitempty"`
}

// MarshalJSON is the custom marshaler for RegistryProperties.
func (rp RegistryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.AdminUserEnabled != nil {
		objectMap["adminUserEnabled"] = rp.AdminUserEnabled
	}
	if rp.StorageAccount != nil {
		objectMap["storageAccount"] = rp.StorageAccount
	}
	if rp.NetworkRuleSet != nil {
		objectMap["networkRuleSet"] = rp.NetworkRuleSet
	}
	if rp.Policies != nil {
		objectMap["policies"] = rp.Policies
	}
	return json.Marshal(objectMap)
}

// RegistryPropertiesUpdateParameters the parameters for updating the properties of a container registry.
type RegistryPropertiesUpdateParameters struct {
	// AdminUserEnabled - The value that indicates whether the admin user is enabled.
	AdminUserEnabled *bool `json:"adminUserEnabled,omitempty"`
	// NetworkRuleSet - The network rule set for a container registry.
	NetworkRuleSet *NetworkRuleSet `json:"networkRuleSet,omitempty"`
	// Policies - The policies for a container registry.
	Policies *Policies `json:"policies,omitempty"`
}

// RegistryUpdateParameters the parameters for updating a container registry.
type RegistryUpdateParameters struct {
	// Tags - The tags for the container registry.
	Tags map[string]*string `json:"tags"`
	// Sku - The SKU of the container registry.
	Sku *Sku `json:"sku,omitempty"`
	// RegistryPropertiesUpdateParameters - The properties that the container registry will be updated with.
	*RegistryPropertiesUpdateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RegistryUpdateParameters.
func (rup RegistryUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rup.Tags != nil {
		objectMap["tags"] = rup.Tags
	}
	if rup.Sku != nil {
		objectMap["sku"] = rup.Sku
	}
	if rup.RegistryPropertiesUpdateParameters != nil {
		objectMap["properties"] = rup.RegistryPropertiesUpdateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RegistryUpdateParameters struct.
func (rup *RegistryUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rup.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				rup.Sku = &sku
			}
		case "properties":
			if v != nil {
				var registryPropertiesUpdateParameters RegistryPropertiesUpdateParameters
				err = json.Unmarshal(*v, &registryPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				rup.RegistryPropertiesUpdateParameters = &registryPropertiesUpdateParameters
			}
		}
	}

	return nil
}

// RegistryUsage the quota usage for a container registry.
type RegistryUsage struct {
	// Name - The name of the usage.
	Name *string `json:"name,omitempty"`
	// Limit - The limit of the usage.
	Limit *int64 `json:"limit,omitempty"`
	// CurrentValue - The current value of the usage.
	CurrentValue *int64 `json:"currentValue,omitempty"`
	// Unit - The unit of measurement. Possible values include: 'Count', 'Bytes'
	Unit RegistryUsageUnit `json:"unit,omitempty"`
}

// RegistryUsageListResult the result of a request to get container registry quota usages.
type RegistryUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of container registry quota usages.
	Value *[]RegistryUsage `json:"value,omitempty"`
}

// Replication an object that represents a replication for a container registry.
type Replication struct {
	autorest.Response `json:"-"`
	// ReplicationProperties - The properties of the replication.
	*ReplicationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Replication.
func (r Replication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ReplicationProperties != nil {
		objectMap["properties"] = r.ReplicationProperties
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Replication struct.
func (r *Replication) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var replicationProperties ReplicationProperties
				err = json.Unmarshal(*v, &replicationProperties)
				if err != nil {
					return err
				}
				r.ReplicationProperties = &replicationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				r.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				r.Tags = tags
			}
		}
	}

	return nil
}

// ReplicationListResult the result of a request to list replications for a container registry.
type ReplicationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of replications. Since this list may be incomplete, the nextLink field should be used to request the next list of replications.
	Value *[]Replication `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of replications.
	NextLink *string `json:"nextLink,omitempty"`
}

// ReplicationListResultIterator provides access to a complete listing of Replication values.
type ReplicationListResultIterator struct {
	i    int
	page ReplicationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ReplicationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ReplicationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ReplicationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ReplicationListResultIterator) Response() ReplicationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ReplicationListResultIterator) Value() Replication {
	if !iter.page.NotDone() {
		return Replication{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ReplicationListResultIterator type.
func NewReplicationListResultIterator(page ReplicationListResultPage) ReplicationListResultIterator {
	return ReplicationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr ReplicationListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rlr ReplicationListResult) hasNextLink() bool {
	return rlr.NextLink != nil && len(*rlr.NextLink) != 0
}

// replicationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr ReplicationListResult) replicationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// ReplicationListResultPage contains a page of Replication values.
type ReplicationListResultPage struct {
	fn  func(context.Context, ReplicationListResult) (ReplicationListResult, error)
	rlr ReplicationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ReplicationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rlr)
		if err != nil {
			return err
		}
		page.rlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ReplicationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ReplicationListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ReplicationListResultPage) Response() ReplicationListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ReplicationListResultPage) Values() []Replication {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Creates a new instance of the ReplicationListResultPage type.
func NewReplicationListResultPage(getNextPage func(context.Context, ReplicationListResult) (ReplicationListResult, error)) ReplicationListResultPage {
	return ReplicationListResultPage{fn: getNextPage}
}

// ReplicationProperties the properties of a replication.
type ReplicationProperties struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the replication at the time the operation was called. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Status - READ-ONLY; The status of the replication at the time the operation was called.
	Status *Status `json:"status,omitempty"`
}

// ReplicationsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationsCreateFuture) Result(client ReplicationsClient) (r Replication, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.ReplicationsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.ReplicationsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.CreateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.ReplicationsCreateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationsDeleteFuture) Result(client ReplicationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.ReplicationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.ReplicationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationsUpdateFuture) Result(client ReplicationsClient) (r Replication, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.ReplicationsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.ReplicationsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.UpdateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.ReplicationsUpdateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationUpdateParameters the parameters for updating a replication.
type ReplicationUpdateParameters struct {
	// Tags - The tags for the replication.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ReplicationUpdateParameters.
func (rup ReplicationUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rup.Tags != nil {
		objectMap["tags"] = rup.Tags
	}
	return json.Marshal(objectMap)
}

// Request the request that generated the event.
type Request struct {
	// ID - The ID of the request that initiated the event.
	ID *string `json:"id,omitempty"`
	// Addr - The IP or hostname and possibly port of the client connection that initiated the event. This is the RemoteAddr from the standard http request.
	Addr *string `json:"addr,omitempty"`
	// Host - The externally accessible hostname of the registry instance, as specified by the http host header on incoming requests.
	Host *string `json:"host,omitempty"`
	// Method - The request method that generated the event.
	Method *string `json:"method,omitempty"`
	// Useragent - The user agent header of the request.
	Useragent *string `json:"useragent,omitempty"`
}

// Resource an Azure resource.
type Resource struct {
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// RetentionPolicy the retention policy for a container registry.
type RetentionPolicy struct {
	// Days - The number of days to retain an untagged manifest after which it gets purged.
	Days *int32 `json:"days,omitempty"`
	// LastUpdatedTime - READ-ONLY; The timestamp when the policy was last updated.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
	// Status - The value that indicates whether the policy is enabled or not. Possible values include: 'Enabled', 'Disabled'
	Status PolicyStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for RetentionPolicy.
func (rp RetentionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.Days != nil {
		objectMap["days"] = rp.Days
	}
	if rp.Status != "" {
		objectMap["status"] = rp.Status
	}
	return json.Marshal(objectMap)
}

// Run run resource properties
type Run struct {
	autorest.Response `json:"-"`
	// RunProperties - The properties of a run.
	*RunProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Run.
func (r Run) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.RunProperties != nil {
		objectMap["properties"] = r.RunProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Run struct.
func (r *Run) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var runProperties RunProperties
				err = json.Unmarshal(*v, &runProperties)
				if err != nil {
					return err
				}
				r.RunProperties = &runProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = &typeVar
			}
		}
	}

	return nil
}

// RunFilter properties that are enabled for Odata querying on runs.
type RunFilter struct {
	// RunID - The unique identifier for the run.
	RunID *string `json:"runId,omitempty"`
	// RunType - The type of run. Possible values include: 'QuickBuild', 'QuickRun', 'AutoBuild', 'AutoRun'
	RunType RunType `json:"runType,omitempty"`
	// Status - The current status of the run. Possible values include: 'RunStatusQueued', 'RunStatusStarted', 'RunStatusRunning', 'RunStatusSucceeded', 'RunStatusFailed', 'RunStatusCanceled', 'RunStatusError', 'RunStatusTimeout'
	Status RunStatus `json:"status,omitempty"`
	// CreateTime - The create time for a run.
	CreateTime *date.Time `json:"createTime,omitempty"`
	// FinishTime - The time the run finished.
	FinishTime *date.Time `json:"finishTime,omitempty"`
	// OutputImageManifests - The list of comma-separated image manifests that were generated from the run. This is applicable if the run is of
	// build type.
	OutputImageManifests *string `json:"outputImageManifests,omitempty"`
	// IsArchiveEnabled - The value that indicates whether archiving is enabled or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`
	// TaskName - The name of the task that the run corresponds to.
	TaskName *string `json:"taskName,omitempty"`
}

// RunGetLogResult the result of get log link operation.
type RunGetLogResult struct {
	autorest.Response `json:"-"`
	// LogLink - The link to logs for a run on a azure container registry.
	LogLink *string `json:"logLink,omitempty"`
}

// RunListResult collection of runs.
type RunListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection value.
	Value *[]Run `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next set of paged results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RunListResultIterator provides access to a complete listing of Run values.
type RunListResultIterator struct {
	i    int
	page RunListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RunListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RunListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RunListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RunListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RunListResultIterator) Response() RunListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RunListResultIterator) Value() Run {
	if !iter.page.NotDone() {
		return Run{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RunListResultIterator type.
func NewRunListResultIterator(page RunListResultPage) RunListResultIterator {
	return RunListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr RunListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rlr RunListResult) hasNextLink() bool {
	return rlr.NextLink != nil && len(*rlr.NextLink) != 0
}

// runListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr RunListResult) runListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// RunListResultPage contains a page of Run values.
type RunListResultPage struct {
	fn  func(context.Context, RunListResult) (RunListResult, error)
	rlr RunListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RunListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RunListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rlr)
		if err != nil {
			return err
		}
		page.rlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RunListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RunListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RunListResultPage) Response() RunListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RunListResultPage) Values() []Run {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Creates a new instance of the RunListResultPage type.
func NewRunListResultPage(getNextPage func(context.Context, RunListResult) (RunListResult, error)) RunListResultPage {
	return RunListResultPage{fn: getNextPage}
}

// RunProperties the properties for a run.
type RunProperties struct {
	// RunID - The unique identifier for the run.
	RunID *string `json:"runId,omitempty"`
	// Status - The current status of the run. Possible values include: 'RunStatusQueued', 'RunStatusStarted', 'RunStatusRunning', 'RunStatusSucceeded', 'RunStatusFailed', 'RunStatusCanceled', 'RunStatusError', 'RunStatusTimeout'
	Status RunStatus `json:"status,omitempty"`
	// LastUpdatedTime - The last updated time for the run.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
	// RunType - The type of run. Possible values include: 'QuickBuild', 'QuickRun', 'AutoBuild', 'AutoRun'
	RunType RunType `json:"runType,omitempty"`
	// CreateTime - The time the run was scheduled.
	CreateTime *date.Time `json:"createTime,omitempty"`
	// StartTime - The time the run started.
	StartTime *date.Time `json:"startTime,omitempty"`
	// FinishTime - The time the run finished.
	FinishTime *date.Time `json:"finishTime,omitempty"`
	// OutputImages - The list of all images that were generated from the run. This is applicable if the run generates base image dependencies.
	OutputImages *[]ImageDescriptor `json:"outputImages,omitempty"`
	// Task - The task against which run was scheduled.
	Task *string `json:"task,omitempty"`
	// ImageUpdateTrigger - The image update trigger that caused the run. This is applicable if the task has base image trigger configured.
	ImageUpdateTrigger *ImageUpdateTrigger `json:"imageUpdateTrigger,omitempty"`
	// SourceTrigger - The source trigger that caused the run.
	SourceTrigger *SourceTriggerDescriptor `json:"sourceTrigger,omitempty"`
	// Platform - The platform properties against which the run will happen.
	Platform *PlatformProperties `json:"platform,omitempty"`
	// AgentConfiguration - The machine configuration of the run agent.
	AgentConfiguration *AgentProperties `json:"agentConfiguration,omitempty"`
	// SourceRegistryAuth - The scope of the credentials that were used to login to the source registry during this run.
	SourceRegistryAuth *string `json:"sourceRegistryAuth,omitempty"`
	// CustomRegistries - The list of custom registries that were logged in during this run.
	CustomRegistries *[]string `json:"customRegistries,omitempty"`
	// RunErrorMessage - READ-ONLY; The error message received from backend systems after the run is scheduled.
	RunErrorMessage *string `json:"runErrorMessage,omitempty"`
	// ProvisioningState - The provisioning state of a run. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// IsArchiveEnabled - The value that indicates whether archiving is enabled or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`
	// TimerTrigger - The timer trigger that caused the run.
	TimerTrigger *TimerTriggerDescriptor `json:"timerTrigger,omitempty"`
}

// MarshalJSON is the custom marshaler for RunProperties.
func (rp RunProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.RunID != nil {
		objectMap["runId"] = rp.RunID
	}
	if rp.Status != "" {
		objectMap["status"] = rp.Status
	}
	if rp.LastUpdatedTime != nil {
		objectMap["lastUpdatedTime"] = rp.LastUpdatedTime
	}
	if rp.RunType != "" {
		objectMap["runType"] = rp.RunType
	}
	if rp.CreateTime != nil {
		objectMap["createTime"] = rp.CreateTime
	}
	if rp.StartTime != nil {
		objectMap["startTime"] = rp.StartTime
	}
	if rp.FinishTime != nil {
		objectMap["finishTime"] = rp.FinishTime
	}
	if rp.OutputImages != nil {
		objectMap["outputImages"] = rp.OutputImages
	}
	if rp.Task != nil {
		objectMap["task"] = rp.Task
	}
	if rp.ImageUpdateTrigger != nil {
		objectMap["imageUpdateTrigger"] = rp.ImageUpdateTrigger
	}
	if rp.SourceTrigger != nil {
		objectMap["sourceTrigger"] = rp.SourceTrigger
	}
	if rp.Platform != nil {
		objectMap["platform"] = rp.Platform
	}
	if rp.AgentConfiguration != nil {
		objectMap["agentConfiguration"] = rp.AgentConfiguration
	}
	if rp.SourceRegistryAuth != nil {
		objectMap["sourceRegistryAuth"] = rp.SourceRegistryAuth
	}
	if rp.CustomRegistries != nil {
		objectMap["customRegistries"] = rp.CustomRegistries
	}
	if rp.ProvisioningState != "" {
		objectMap["provisioningState"] = rp.ProvisioningState
	}
	if rp.IsArchiveEnabled != nil {
		objectMap["isArchiveEnabled"] = rp.IsArchiveEnabled
	}
	if rp.TimerTrigger != nil {
		objectMap["timerTrigger"] = rp.TimerTrigger
	}
	return json.Marshal(objectMap)
}

// BasicRunRequest the request parameters for scheduling a run.
type BasicRunRequest interface {
	AsDockerBuildRequest() (*DockerBuildRequest, bool)
	AsFileTaskRunRequest() (*FileTaskRunRequest, bool)
	AsTaskRunRequest() (*TaskRunRequest, bool)
	AsEncodedTaskRunRequest() (*EncodedTaskRunRequest, bool)
	AsRunRequest() (*RunRequest, bool)
}

// RunRequest the request parameters for scheduling a run.
type RunRequest struct {
	// IsArchiveEnabled - The value that indicates whether archiving is enabled for the run or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`
	// Type - Possible values include: 'TypeRunRequest', 'TypeDockerBuildRequest', 'TypeFileTaskRunRequest', 'TypeTaskRunRequest', 'TypeEncodedTaskRunRequest'
	Type Type `json:"type,omitempty"`
}

func unmarshalBasicRunRequest(body []byte) (BasicRunRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeDockerBuildRequest):
		var dbr DockerBuildRequest
		err := json.Unmarshal(body, &dbr)
		return dbr, err
	case string(TypeFileTaskRunRequest):
		var ftrr FileTaskRunRequest
		err := json.Unmarshal(body, &ftrr)
		return ftrr, err
	case string(TypeTaskRunRequest):
		var trr TaskRunRequest
		err := json.Unmarshal(body, &trr)
		return trr, err
	case string(TypeEncodedTaskRunRequest):
		var etrr EncodedTaskRunRequest
		err := json.Unmarshal(body, &etrr)
		return etrr, err
	default:
		var rr RunRequest
		err := json.Unmarshal(body, &rr)
		return rr, err
	}
}
func unmarshalBasicRunRequestArray(body []byte) ([]BasicRunRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rrArray := make([]BasicRunRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rr, err := unmarshalBasicRunRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		rrArray[index] = rr
	}
	return rrArray, nil
}

// MarshalJSON is the custom marshaler for RunRequest.
func (rr RunRequest) MarshalJSON() ([]byte, error) {
	rr.Type = TypeRunRequest
	objectMap := make(map[string]interface{})
	if rr.IsArchiveEnabled != nil {
		objectMap["isArchiveEnabled"] = rr.IsArchiveEnabled
	}
	if rr.Type != "" {
		objectMap["type"] = rr.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildRequest is the BasicRunRequest implementation for RunRequest.
func (rr RunRequest) AsDockerBuildRequest() (*DockerBuildRequest, bool) {
	return nil, false
}

// AsFileTaskRunRequest is the BasicRunRequest implementation for RunRequest.
func (rr RunRequest) AsFileTaskRunRequest() (*FileTaskRunRequest, bool) {
	return nil, false
}

// AsTaskRunRequest is the BasicRunRequest implementation for RunRequest.
func (rr RunRequest) AsTaskRunRequest() (*TaskRunRequest, bool) {
	return nil, false
}

// AsEncodedTaskRunRequest is the BasicRunRequest implementation for RunRequest.
func (rr RunRequest) AsEncodedTaskRunRequest() (*EncodedTaskRunRequest, bool) {
	return nil, false
}

// AsRunRequest is the BasicRunRequest implementation for RunRequest.
func (rr RunRequest) AsRunRequest() (*RunRequest, bool) {
	return &rr, true
}

// AsBasicRunRequest is the BasicRunRequest implementation for RunRequest.
func (rr RunRequest) AsBasicRunRequest() (BasicRunRequest, bool) {
	return &rr, true
}

// RunsCancelFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RunsCancelFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *RunsCancelFuture) Result(client RunsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RunsCancelFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.RunsCancelFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RunsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RunsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *RunsUpdateFuture) Result(client RunsClient) (r Run, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RunsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.RunsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.UpdateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.RunsUpdateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RunUpdateParameters the set of run properties that can be updated.
type RunUpdateParameters struct {
	// IsArchiveEnabled - The value that indicates whether archiving is enabled or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`
}

// SecretObject describes the properties of a secret object value.
type SecretObject struct {
	// Value - The value of the secret. The format of this value will be determined
	// based on the type of the secret object. If the type is Opaque, the value will be
	// used as is without any modification.
	Value *string `json:"value,omitempty"`
	// Type - The type of the secret object which determines how the value of the secret object has to be
	// interpreted. Possible values include: 'Opaque', 'Vaultsecret'
	Type SecretObjectType `json:"type,omitempty"`
}

// SetValue the properties of a overridable value that can be passed to a task template.
type SetValue struct {
	// Name - The name of the overridable value.
	Name *string `json:"name,omitempty"`
	// Value - The overridable value.
	Value *string `json:"value,omitempty"`
	// IsSecret - Flag to indicate whether the value represents a secret or not.
	IsSecret *bool `json:"isSecret,omitempty"`
}

// Sku the SKU of a container registry.
type Sku struct {
	// Name - The SKU name of the container registry. Required for registry creation. Possible values include: 'Classic', 'Basic', 'Standard', 'Premium'
	Name SkuName `json:"name,omitempty"`
	// Tier - READ-ONLY; The SKU tier based on the SKU name. Possible values include: 'SkuTierClassic', 'SkuTierBasic', 'SkuTierStandard', 'SkuTierPremium'
	Tier SkuTier `json:"tier,omitempty"`
}

// MarshalJSON is the custom marshaler for Sku.
func (s Sku) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Name != "" {
		objectMap["name"] = s.Name
	}
	return json.Marshal(objectMap)
}

// Source the registry node that generated the event. Put differently, while the actor initiates the event, the
// source generates it.
type Source struct {
	// Addr - The IP or hostname and the port of the registry node that generated the event. Generally, this will be resolved by os.Hostname() along with the running port.
	Addr *string `json:"addr,omitempty"`
	// InstanceID - The running instance of an application. Changes after each restart.
	InstanceID *string `json:"instanceID,omitempty"`
}

// SourceProperties the properties of the source code repository.
type SourceProperties struct {
	// SourceControlType - The type of source control service. Possible values include: 'Github', 'VisualStudioTeamService'
	SourceControlType SourceControlType `json:"sourceControlType,omitempty"`
	// RepositoryURL - The full URL to the source code repository
	RepositoryURL *string `json:"repositoryUrl,omitempty"`
	// Branch - The branch name of the source code.
	Branch *string `json:"branch,omitempty"`
	// SourceControlAuthProperties - The authorization properties for accessing the source code repository and to set up
	// webhooks for notifications.
	SourceControlAuthProperties *AuthInfo `json:"sourceControlAuthProperties,omitempty"`
}

// SourceRegistryCredentials describes the credential parameters for accessing the source registry.
type SourceRegistryCredentials struct {
	// LoginMode - The authentication mode which determines the source registry login scope. The credentials for the source registry
	// will be generated using the given scope. These credentials will be used to login to
	// the source registry during the run. Possible values include: 'SourceRegistryLoginModeNone', 'SourceRegistryLoginModeDefault'
	LoginMode SourceRegistryLoginMode `json:"loginMode,omitempty"`
}

// SourceTrigger the properties of a source based trigger.
type SourceTrigger struct {
	// SourceRepository - The properties that describes the source(code) for the task.
	SourceRepository *SourceProperties `json:"sourceRepository,omitempty"`
	// SourceTriggerEvents - The source event corresponding to the trigger.
	SourceTriggerEvents *[]SourceTriggerEvent `json:"sourceTriggerEvents,omitempty"`
	// Status - The current status of trigger. Possible values include: 'TriggerStatusDisabled', 'TriggerStatusEnabled'
	Status TriggerStatus `json:"status,omitempty"`
	// Name - The name of the trigger.
	Name *string `json:"name,omitempty"`
}

// SourceTriggerDescriptor the source trigger that caused a run.
type SourceTriggerDescriptor struct {
	// ID - The unique ID of the trigger.
	ID *string `json:"id,omitempty"`
	// EventType - The event type of the trigger.
	EventType *string `json:"eventType,omitempty"`
	// CommitID - The unique ID that identifies a commit.
	CommitID *string `json:"commitId,omitempty"`
	// PullRequestID - The unique ID that identifies pull request.
	PullRequestID *string `json:"pullRequestId,omitempty"`
	// RepositoryURL - The repository URL.
	RepositoryURL *string `json:"repositoryUrl,omitempty"`
	// BranchName - The branch name in the repository.
	BranchName *string `json:"branchName,omitempty"`
	// ProviderType - The source control provider type.
	ProviderType *string `json:"providerType,omitempty"`
}

// SourceTriggerUpdateParameters the properties for updating a source based trigger.
type SourceTriggerUpdateParameters struct {
	// SourceRepository - The properties that describes the source(code) for the task.
	SourceRepository *SourceUpdateParameters `json:"sourceRepository,omitempty"`
	// SourceTriggerEvents - The source event corresponding to the trigger.
	SourceTriggerEvents *[]SourceTriggerEvent `json:"sourceTriggerEvents,omitempty"`
	// Status - The current status of trigger. Possible values include: 'TriggerStatusDisabled', 'TriggerStatusEnabled'
	Status TriggerStatus `json:"status,omitempty"`
	// Name - The name of the trigger.
	Name *string `json:"name,omitempty"`
}

// SourceUpdateParameters the properties for updating the source code repository.
type SourceUpdateParameters struct {
	// SourceControlType - The type of source control service. Possible values include: 'Github', 'VisualStudioTeamService'
	SourceControlType SourceControlType `json:"sourceControlType,omitempty"`
	// RepositoryURL - The full URL to the source code repository
	RepositoryURL *string `json:"repositoryUrl,omitempty"`
	// Branch - The branch name of the source code.
	Branch *string `json:"branch,omitempty"`
	// SourceControlAuthProperties - The authorization properties for accessing the source code repository and to set up
	// webhooks for notifications.
	SourceControlAuthProperties *AuthInfoUpdateParameters `json:"sourceControlAuthProperties,omitempty"`
}

// SourceUploadDefinition the properties of a response to source upload request.
type SourceUploadDefinition struct {
	autorest.Response `json:"-"`
	// UploadURL - The URL where the client can upload the source.
	UploadURL *string `json:"uploadUrl,omitempty"`
	// RelativePath - The relative path to the source. This is used to submit the subsequent queue build request.
	RelativePath *string `json:"relativePath,omitempty"`
}

// Status the status of an Azure resource at the time the operation was called.
type Status struct {
	// DisplayStatus - READ-ONLY; The short label for the status.
	DisplayStatus *string `json:"displayStatus,omitempty"`
	// Message - READ-ONLY; The detailed message for the status, including alerts and error messages.
	Message *string `json:"message,omitempty"`
	// Timestamp - READ-ONLY; The timestamp when the status was changed to the current value.
	Timestamp *date.Time `json:"timestamp,omitempty"`
}

// StorageAccountProperties the properties of a storage account for a container registry. Only applicable to
// Classic SKU.
type StorageAccountProperties struct {
	// ID - The resource ID of the storage account.
	ID *string `json:"id,omitempty"`
}

// Target the target of the event.
type Target struct {
	// MediaType - The MIME type of the referenced object.
	MediaType *string `json:"mediaType,omitempty"`
	// Size - The number of bytes of the content. Same as Length field.
	Size *int64 `json:"size,omitempty"`
	// Digest - The digest of the content, as defined by the Registry V2 HTTP API Specification.
	Digest *string `json:"digest,omitempty"`
	// Length - The number of bytes of the content. Same as Size field.
	Length *int64 `json:"length,omitempty"`
	// Repository - The repository name.
	Repository *string `json:"repository,omitempty"`
	// URL - The direct URL to the content.
	URL *string `json:"url,omitempty"`
	// Tag - The tag name.
	Tag *string `json:"tag,omitempty"`
	// Name - The name of the artifact.
	Name *string `json:"name,omitempty"`
	// Version - The version of the artifact.
	Version *string `json:"version,omitempty"`
}

// Task the task that has the ARM resource and task properties.
// The task will have all information to schedule a run against it.
type Task struct {
	autorest.Response `json:"-"`
	// Identity - Identity for the resource.
	Identity *IdentityProperties `json:"identity,omitempty"`
	// TaskProperties - The properties of a task.
	*TaskProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Task.
func (t Task) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.Identity != nil {
		objectMap["identity"] = t.Identity
	}
	if t.TaskProperties != nil {
		objectMap["properties"] = t.TaskProperties
	}
	if t.Location != nil {
		objectMap["location"] = t.Location
	}
	if t.Tags != nil {
		objectMap["tags"] = t.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Task struct.
func (t *Task) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity IdentityProperties
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				t.Identity = &identity
			}
		case "properties":
			if v != nil {
				var taskProperties TaskProperties
				err = json.Unmarshal(*v, &taskProperties)
				if err != nil {
					return err
				}
				t.TaskProperties = &taskProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				t.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				t.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				t.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				t.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				t.Tags = tags
			}
		}
	}

	return nil
}

// TaskListResult the collection of tasks.
type TaskListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection value.
	Value *[]Task `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next set of paged results.
	NextLink *string `json:"nextLink,omitempty"`
}

// TaskListResultIterator provides access to a complete listing of Task values.
type TaskListResultIterator struct {
	i    int
	page TaskListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TaskListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TaskListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TaskListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TaskListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TaskListResultIterator) Response() TaskListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TaskListResultIterator) Value() Task {
	if !iter.page.NotDone() {
		return Task{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TaskListResultIterator type.
func NewTaskListResultIterator(page TaskListResultPage) TaskListResultIterator {
	return TaskListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tlr TaskListResult) IsEmpty() bool {
	return tlr.Value == nil || len(*tlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tlr TaskListResult) hasNextLink() bool {
	return tlr.NextLink != nil && len(*tlr.NextLink) != 0
}

// taskListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tlr TaskListResult) taskListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !tlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tlr.NextLink)))
}

// TaskListResultPage contains a page of Task values.
type TaskListResultPage struct {
	fn  func(context.Context, TaskListResult) (TaskListResult, error)
	tlr TaskListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TaskListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TaskListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tlr)
		if err != nil {
			return err
		}
		page.tlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TaskListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TaskListResultPage) NotDone() bool {
	return !page.tlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TaskListResultPage) Response() TaskListResult {
	return page.tlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TaskListResultPage) Values() []Task {
	if page.tlr.IsEmpty() {
		return nil
	}
	return *page.tlr.Value
}

// Creates a new instance of the TaskListResultPage type.
func NewTaskListResultPage(getNextPage func(context.Context, TaskListResult) (TaskListResult, error)) TaskListResultPage {
	return TaskListResultPage{fn: getNextPage}
}

// TaskProperties the properties of a task.
type TaskProperties struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the task. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CreationDate - READ-ONLY; The creation date of task.
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// Status - The current status of task. Possible values include: 'TaskStatusDisabled', 'TaskStatusEnabled'
	Status TaskStatus `json:"status,omitempty"`
	// Platform - The platform properties against which the run has to happen.
	Platform *PlatformProperties `json:"platform,omitempty"`
	// AgentConfiguration - The machine configuration of the run agent.
	AgentConfiguration *AgentProperties `json:"agentConfiguration,omitempty"`
	// Timeout - Run timeout in seconds.
	Timeout *int32 `json:"timeout,omitempty"`
	// Step - The properties of a task step.
	Step BasicTaskStepProperties `json:"step,omitempty"`
	// Trigger - The properties that describe all triggers for the task.
	Trigger *TriggerProperties `json:"trigger,omitempty"`
	// Credentials - The properties that describes a set of credentials that will be used when this run is invoked.
	Credentials *Credentials `json:"credentials,omitempty"`
}

// MarshalJSON is the custom marshaler for TaskProperties.
func (tp TaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tp.Status != "" {
		objectMap["status"] = tp.Status
	}
	if tp.Platform != nil {
		objectMap["platform"] = tp.Platform
	}
	if tp.AgentConfiguration != nil {
		objectMap["agentConfiguration"] = tp.AgentConfiguration
	}
	if tp.Timeout != nil {
		objectMap["timeout"] = tp.Timeout
	}
	objectMap["step"] = tp.Step
	if tp.Trigger != nil {
		objectMap["trigger"] = tp.Trigger
	}
	if tp.Credentials != nil {
		objectMap["credentials"] = tp.Credentials
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TaskProperties struct.
func (tp *TaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "provisioningState":
			if v != nil {
				var provisioningState ProvisioningState
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				tp.ProvisioningState = provisioningState
			}
		case "creationDate":
			if v != nil {
				var creationDate date.Time
				err = json.Unmarshal(*v, &creationDate)
				if err != nil {
					return err
				}
				tp.CreationDate = &creationDate
			}
		case "status":
			if v != nil {
				var status TaskStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				tp.Status = status
			}
		case "platform":
			if v != nil {
				var platform PlatformProperties
				err = json.Unmarshal(*v, &platform)
				if err != nil {
					return err
				}
				tp.Platform = &platform
			}
		case "agentConfiguration":
			if v != nil {
				var agentConfiguration AgentProperties
				err = json.Unmarshal(*v, &agentConfiguration)
				if err != nil {
					return err
				}
				tp.AgentConfiguration = &agentConfiguration
			}
		case "timeout":
			if v != nil {
				var timeout int32
				err = json.Unmarshal(*v, &timeout)
				if err != nil {
					return err
				}
				tp.Timeout = &timeout
			}
		case "step":
			if v != nil {
				step, err := unmarshalBasicTaskStepProperties(*v)
				if err != nil {
					return err
				}
				tp.Step = step
			}
		case "trigger":
			if v != nil {
				var trigger TriggerProperties
				err = json.Unmarshal(*v, &trigger)
				if err != nil {
					return err
				}
				tp.Trigger = &trigger
			}
		case "credentials":
			if v != nil {
				var credentials Credentials
				err = json.Unmarshal(*v, &credentials)
				if err != nil {
					return err
				}
				tp.Credentials = &credentials
			}
		}
	}

	return nil
}

// TaskPropertiesUpdateParameters the properties for updating a task.
type TaskPropertiesUpdateParameters struct {
	// Status - The current status of task. Possible values include: 'TaskStatusDisabled', 'TaskStatusEnabled'
	Status TaskStatus `json:"status,omitempty"`
	// Platform - The platform properties against which the run has to happen.
	Platform *PlatformUpdateParameters `json:"platform,omitempty"`
	// AgentConfiguration - The machine configuration of the run agent.
	AgentConfiguration *AgentProperties `json:"agentConfiguration,omitempty"`
	// Timeout - Run timeout in seconds.
	Timeout *int32 `json:"timeout,omitempty"`
	// Step - The properties for updating a task step.
	Step BasicTaskStepUpdateParameters `json:"step,omitempty"`
	// Trigger - The properties for updating trigger properties.
	Trigger *TriggerUpdateParameters `json:"trigger,omitempty"`
	// Credentials - The parameters that describes a set of credentials that will be used when this run is invoked.
	Credentials *Credentials `json:"credentials,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for TaskPropertiesUpdateParameters struct.
func (tpup *TaskPropertiesUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "status":
			if v != nil {
				var status TaskStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				tpup.Status = status
			}
		case "platform":
			if v != nil {
				var platform PlatformUpdateParameters
				err = json.Unmarshal(*v, &platform)
				if err != nil {
					return err
				}
				tpup.Platform = &platform
			}
		case "agentConfiguration":
			if v != nil {
				var agentConfiguration AgentProperties
				err = json.Unmarshal(*v, &agentConfiguration)
				if err != nil {
					return err
				}
				tpup.AgentConfiguration = &agentConfiguration
			}
		case "timeout":
			if v != nil {
				var timeout int32
				err = json.Unmarshal(*v, &timeout)
				if err != nil {
					return err
				}
				tpup.Timeout = &timeout
			}
		case "step":
			if v != nil {
				step, err := unmarshalBasicTaskStepUpdateParameters(*v)
				if err != nil {
					return err
				}
				tpup.Step = step
			}
		case "trigger":
			if v != nil {
				var trigger TriggerUpdateParameters
				err = json.Unmarshal(*v, &trigger)
				if err != nil {
					return err
				}
				tpup.Trigger = &trigger
			}
		case "credentials":
			if v != nil {
				var credentials Credentials
				err = json.Unmarshal(*v, &credentials)
				if err != nil {
					return err
				}
				tpup.Credentials = &credentials
			}
		}
	}

	return nil
}

// TaskRunRequest the parameters for a task run request.
type TaskRunRequest struct {
	// TaskName - The name of task against which run has to be queued.
	TaskName *string `json:"taskName,omitempty"`
	// Values - The collection of overridable values that can be passed when running a task.
	Values *[]SetValue `json:"values,omitempty"`
	// IsArchiveEnabled - The value that indicates whether archiving is enabled for the run or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`
	// Type - Possible values include: 'TypeRunRequest', 'TypeDockerBuildRequest', 'TypeFileTaskRunRequest', 'TypeTaskRunRequest', 'TypeEncodedTaskRunRequest'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TaskRunRequest.
func (trr TaskRunRequest) MarshalJSON() ([]byte, error) {
	trr.Type = TypeTaskRunRequest
	objectMap := make(map[string]interface{})
	if trr.TaskName != nil {
		objectMap["taskName"] = trr.TaskName
	}
	if trr.Values != nil {
		objectMap["values"] = trr.Values
	}
	if trr.IsArchiveEnabled != nil {
		objectMap["isArchiveEnabled"] = trr.IsArchiveEnabled
	}
	if trr.Type != "" {
		objectMap["type"] = trr.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildRequest is the BasicRunRequest implementation for TaskRunRequest.
func (trr TaskRunRequest) AsDockerBuildRequest() (*DockerBuildRequest, bool) {
	return nil, false
}

// AsFileTaskRunRequest is the BasicRunRequest implementation for TaskRunRequest.
func (trr TaskRunRequest) AsFileTaskRunRequest() (*FileTaskRunRequest, bool) {
	return nil, false
}

// AsTaskRunRequest is the BasicRunRequest implementation for TaskRunRequest.
func (trr TaskRunRequest) AsTaskRunRequest() (*TaskRunRequest, bool) {
	return &trr, true
}

// AsEncodedTaskRunRequest is the BasicRunRequest implementation for TaskRunRequest.
func (trr TaskRunRequest) AsEncodedTaskRunRequest() (*EncodedTaskRunRequest, bool) {
	return nil, false
}

// AsRunRequest is the BasicRunRequest implementation for TaskRunRequest.
func (trr TaskRunRequest) AsRunRequest() (*RunRequest, bool) {
	return nil, false
}

// AsBasicRunRequest is the BasicRunRequest implementation for TaskRunRequest.
func (trr TaskRunRequest) AsBasicRunRequest() (BasicRunRequest, bool) {
	return &trr, true
}

// TasksCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type TasksCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *TasksCreateFuture) Result(client TasksClient) (t Task, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.TasksCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.TasksCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if t.Response.Response, err = future.GetResult(sender); err == nil && t.Response.Response.StatusCode != http.StatusNoContent {
		t, err = client.CreateResponder(t.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.TasksCreateFuture", "Result", t.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TasksDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type TasksDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *TasksDeleteFuture) Result(client TasksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.TasksDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.TasksDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BasicTaskStepProperties base properties for any task step.
type BasicTaskStepProperties interface {
	AsDockerBuildStep() (*DockerBuildStep, bool)
	AsFileTaskStep() (*FileTaskStep, bool)
	AsEncodedTaskStep() (*EncodedTaskStep, bool)
	AsTaskStepProperties() (*TaskStepProperties, bool)
}

// TaskStepProperties base properties for any task step.
type TaskStepProperties struct {
	// BaseImageDependencies - READ-ONLY; List of base image dependencies for a step.
	BaseImageDependencies *[]BaseImageDependency `json:"baseImageDependencies,omitempty"`
	// ContextPath - The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`
	// ContextAccessToken - The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`
	// Type - Possible values include: 'TypeTaskStepProperties', 'TypeDocker', 'TypeFileTask', 'TypeEncodedTask'
	Type TypeBasicTaskStepProperties `json:"type,omitempty"`
}

func unmarshalBasicTaskStepProperties(body []byte) (BasicTaskStepProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeDocker):
		var dbs DockerBuildStep
		err := json.Unmarshal(body, &dbs)
		return dbs, err
	case string(TypeFileTask):
		var fts FileTaskStep
		err := json.Unmarshal(body, &fts)
		return fts, err
	case string(TypeEncodedTask):
		var ets EncodedTaskStep
		err := json.Unmarshal(body, &ets)
		return ets, err
	default:
		var tsp TaskStepProperties
		err := json.Unmarshal(body, &tsp)
		return tsp, err
	}
}
func unmarshalBasicTaskStepPropertiesArray(body []byte) ([]BasicTaskStepProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tspArray := make([]BasicTaskStepProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		tsp, err := unmarshalBasicTaskStepProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		tspArray[index] = tsp
	}
	return tspArray, nil
}

// MarshalJSON is the custom marshaler for TaskStepProperties.
func (tsp TaskStepProperties) MarshalJSON() ([]byte, error) {
	tsp.Type = TypeTaskStepProperties
	objectMap := make(map[string]interface{})
	if tsp.ContextPath != nil {
		objectMap["contextPath"] = tsp.ContextPath
	}
	if tsp.ContextAccessToken != nil {
		objectMap["contextAccessToken"] = tsp.ContextAccessToken
	}
	if tsp.Type != "" {
		objectMap["type"] = tsp.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStep is the BasicTaskStepProperties implementation for TaskStepProperties.
func (tsp TaskStepProperties) AsDockerBuildStep() (*DockerBuildStep, bool) {
	return nil, false
}

// AsFileTaskStep is the BasicTaskStepProperties implementation for TaskStepProperties.
func (tsp TaskStepProperties) AsFileTaskStep() (*FileTaskStep, bool) {
	return nil, false
}

// AsEncodedTaskStep is the BasicTaskStepProperties implementation for TaskStepProperties.
func (tsp TaskStepProperties) AsEncodedTaskStep() (*EncodedTaskStep, bool) {
	return nil, false
}

// AsTaskStepProperties is the BasicTaskStepProperties implementation for TaskStepProperties.
func (tsp TaskStepProperties) AsTaskStepProperties() (*TaskStepProperties, bool) {
	return &tsp, true
}

// AsBasicTaskStepProperties is the BasicTaskStepProperties implementation for TaskStepProperties.
func (tsp TaskStepProperties) AsBasicTaskStepProperties() (BasicTaskStepProperties, bool) {
	return &tsp, true
}

// BasicTaskStepUpdateParameters base properties for updating any task step.
type BasicTaskStepUpdateParameters interface {
	AsDockerBuildStepUpdateParameters() (*DockerBuildStepUpdateParameters, bool)
	AsFileTaskStepUpdateParameters() (*FileTaskStepUpdateParameters, bool)
	AsEncodedTaskStepUpdateParameters() (*EncodedTaskStepUpdateParameters, bool)
	AsTaskStepUpdateParameters() (*TaskStepUpdateParameters, bool)
}

// TaskStepUpdateParameters base properties for updating any task step.
type TaskStepUpdateParameters struct {
	// ContextPath - The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`
	// ContextAccessToken - The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`
	// Type - Possible values include: 'TypeBasicTaskStepUpdateParametersTypeTaskStepUpdateParameters', 'TypeBasicTaskStepUpdateParametersTypeDocker', 'TypeBasicTaskStepUpdateParametersTypeFileTask', 'TypeBasicTaskStepUpdateParametersTypeEncodedTask'
	Type TypeBasicTaskStepUpdateParameters `json:"type,omitempty"`
}

func unmarshalBasicTaskStepUpdateParameters(body []byte) (BasicTaskStepUpdateParameters, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeBasicTaskStepUpdateParametersTypeDocker):
		var dbsup DockerBuildStepUpdateParameters
		err := json.Unmarshal(body, &dbsup)
		return dbsup, err
	case string(TypeBasicTaskStepUpdateParametersTypeFileTask):
		var ftsup FileTaskStepUpdateParameters
		err := json.Unmarshal(body, &ftsup)
		return ftsup, err
	case string(TypeBasicTaskStepUpdateParametersTypeEncodedTask):
		var etsup EncodedTaskStepUpdateParameters
		err := json.Unmarshal(body, &etsup)
		return etsup, err
	default:
		var tsup TaskStepUpdateParameters
		err := json.Unmarshal(body, &tsup)
		return tsup, err
	}
}
func unmarshalBasicTaskStepUpdateParametersArray(body []byte) ([]BasicTaskStepUpdateParameters, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tsupArray := make([]BasicTaskStepUpdateParameters, len(rawMessages))

	for index, rawMessage := range rawMessages {
		tsup, err := unmarshalBasicTaskStepUpdateParameters(*rawMessage)
		if err != nil {
			return nil, err
		}
		tsupArray[index] = tsup
	}
	return tsupArray, nil
}

// MarshalJSON is the custom marshaler for TaskStepUpdateParameters.
func (tsup TaskStepUpdateParameters) MarshalJSON() ([]byte, error) {
	tsup.Type = TypeBasicTaskStepUpdateParametersTypeTaskStepUpdateParameters
	objectMap := make(map[string]interface{})
	if tsup.ContextPath != nil {
		objectMap["contextPath"] = tsup.ContextPath
	}
	if tsup.ContextAccessToken != nil {
		objectMap["contextAccessToken"] = tsup.ContextAccessToken
	}
	if tsup.Type != "" {
		objectMap["type"] = tsup.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for TaskStepUpdateParameters.
func (tsup TaskStepUpdateParameters) AsDockerBuildStepUpdateParameters() (*DockerBuildStepUpdateParameters, bool) {
	return nil, false
}

// AsFileTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for TaskStepUpdateParameters.
func (tsup TaskStepUpdateParameters) AsFileTaskStepUpdateParameters() (*FileTaskStepUpdateParameters, bool) {
	return nil, false
}

// AsEncodedTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for TaskStepUpdateParameters.
func (tsup TaskStepUpdateParameters) AsEncodedTaskStepUpdateParameters() (*EncodedTaskStepUpdateParameters, bool) {
	return nil, false
}

// AsTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for TaskStepUpdateParameters.
func (tsup TaskStepUpdateParameters) AsTaskStepUpdateParameters() (*TaskStepUpdateParameters, bool) {
	return &tsup, true
}

// AsBasicTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for TaskStepUpdateParameters.
func (tsup TaskStepUpdateParameters) AsBasicTaskStepUpdateParameters() (BasicTaskStepUpdateParameters, bool) {
	return &tsup, true
}

// TasksUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type TasksUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *TasksUpdateFuture) Result(client TasksClient) (t Task, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.TasksUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.TasksUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if t.Response.Response, err = future.GetResult(sender); err == nil && t.Response.Response.StatusCode != http.StatusNoContent {
		t, err = client.UpdateResponder(t.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.TasksUpdateFuture", "Result", t.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TaskUpdateParameters the parameters for updating a task.
type TaskUpdateParameters struct {
	// Identity - Identity for the resource.
	Identity *IdentityProperties `json:"identity,omitempty"`
	// TaskPropertiesUpdateParameters - The properties for updating a task.
	*TaskPropertiesUpdateParameters `json:"properties,omitempty"`
	// Tags - The ARM resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TaskUpdateParameters.
func (tup TaskUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tup.Identity != nil {
		objectMap["identity"] = tup.Identity
	}
	if tup.TaskPropertiesUpdateParameters != nil {
		objectMap["properties"] = tup.TaskPropertiesUpdateParameters
	}
	if tup.Tags != nil {
		objectMap["tags"] = tup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TaskUpdateParameters struct.
func (tup *TaskUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity IdentityProperties
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				tup.Identity = &identity
			}
		case "properties":
			if v != nil {
				var taskPropertiesUpdateParameters TaskPropertiesUpdateParameters
				err = json.Unmarshal(*v, &taskPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				tup.TaskPropertiesUpdateParameters = &taskPropertiesUpdateParameters
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				tup.Tags = tags
			}
		}
	}

	return nil
}

// TimerTrigger the properties of a timer trigger.
type TimerTrigger struct {
	// Schedule - The CRON expression for the task schedule
	Schedule *string `json:"schedule,omitempty"`
	// Status - The current status of trigger. Possible values include: 'TriggerStatusDisabled', 'TriggerStatusEnabled'
	Status TriggerStatus `json:"status,omitempty"`
	// Name - The name of the trigger.
	Name *string `json:"name,omitempty"`
}

// TimerTriggerDescriptor ...
type TimerTriggerDescriptor struct {
	// TimerTriggerName - The timer trigger name that caused the run.
	TimerTriggerName *string `json:"timerTriggerName,omitempty"`
	// ScheduleOccurrence - The occurrence that triggered the run.
	ScheduleOccurrence *string `json:"scheduleOccurrence,omitempty"`
}

// TimerTriggerUpdateParameters the properties for updating a timer trigger.
type TimerTriggerUpdateParameters struct {
	// Schedule - The CRON expression for the task schedule
	Schedule *string `json:"schedule,omitempty"`
	// Status - The current status of trigger. Possible values include: 'TriggerStatusDisabled', 'TriggerStatusEnabled'
	Status TriggerStatus `json:"status,omitempty"`
	// Name - The name of the trigger.
	Name *string `json:"name,omitempty"`
}

// TriggerProperties the properties of a trigger.
type TriggerProperties struct {
	// TimerTriggers - The collection of timer triggers.
	TimerTriggers *[]TimerTrigger `json:"timerTriggers,omitempty"`
	// SourceTriggers - The collection of triggers based on source code repository.
	SourceTriggers *[]SourceTrigger `json:"sourceTriggers,omitempty"`
	// BaseImageTrigger - The trigger based on base image dependencies.
	BaseImageTrigger *BaseImageTrigger `json:"baseImageTrigger,omitempty"`
}

// TriggerUpdateParameters the properties for updating triggers.
type TriggerUpdateParameters struct {
	// TimerTriggers - The collection of timer triggers.
	TimerTriggers *[]TimerTriggerUpdateParameters `json:"timerTriggers,omitempty"`
	// SourceTriggers - The collection of triggers based on source code repository.
	SourceTriggers *[]SourceTriggerUpdateParameters `json:"sourceTriggers,omitempty"`
	// BaseImageTrigger - The trigger based on base image dependencies.
	BaseImageTrigger *BaseImageTriggerUpdateParameters `json:"baseImageTrigger,omitempty"`
}

// TrustPolicy the content trust policy for a container registry.
type TrustPolicy struct {
	// Type - The type of trust policy. Possible values include: 'Notary'
	Type TrustPolicyType `json:"type,omitempty"`
	// Status - The value that indicates whether the policy is enabled or not. Possible values include: 'Enabled', 'Disabled'
	Status PolicyStatus `json:"status,omitempty"`
}

// UserIdentityProperties ...
type UserIdentityProperties struct {
	// PrincipalID - The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// ClientID - The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
}

// VirtualNetworkRule virtual network rule.
type VirtualNetworkRule struct {
	// Action - The action of virtual network rule. Possible values include: 'Allow'
	Action Action `json:"action,omitempty"`
	// VirtualNetworkResourceID - Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
	VirtualNetworkResourceID *string `json:"id,omitempty"`
}

// Webhook an object that represents a webhook for a container registry.
type Webhook struct {
	autorest.Response `json:"-"`
	// WebhookProperties - The properties of the webhook.
	*WebhookProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Webhook.
func (w Webhook) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.WebhookProperties != nil {
		objectMap["properties"] = w.WebhookProperties
	}
	if w.Location != nil {
		objectMap["location"] = w.Location
	}
	if w.Tags != nil {
		objectMap["tags"] = w.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Webhook struct.
func (w *Webhook) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var webhookProperties WebhookProperties
				err = json.Unmarshal(*v, &webhookProperties)
				if err != nil {
					return err
				}
				w.WebhookProperties = &webhookProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				w.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				w.Tags = tags
			}
		}
	}

	return nil
}

// WebhookCreateParameters the parameters for creating a webhook.
type WebhookCreateParameters struct {
	// Tags - The tags for the webhook.
	Tags map[string]*string `json:"tags"`
	// Location - The location of the webhook. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// WebhookPropertiesCreateParameters - The properties that the webhook will be created with.
	*WebhookPropertiesCreateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookCreateParameters.
func (wcp WebhookCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wcp.Tags != nil {
		objectMap["tags"] = wcp.Tags
	}
	if wcp.Location != nil {
		objectMap["location"] = wcp.Location
	}
	if wcp.WebhookPropertiesCreateParameters != nil {
		objectMap["properties"] = wcp.WebhookPropertiesCreateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WebhookCreateParameters struct.
func (wcp *WebhookCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wcp.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				wcp.Location = &location
			}
		case "properties":
			if v != nil {
				var webhookPropertiesCreateParameters WebhookPropertiesCreateParameters
				err = json.Unmarshal(*v, &webhookPropertiesCreateParameters)
				if err != nil {
					return err
				}
				wcp.WebhookPropertiesCreateParameters = &webhookPropertiesCreateParameters
			}
		}
	}

	return nil
}

// WebhookListResult the result of a request to list webhooks for a container registry.
type WebhookListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of webhooks. Since this list may be incomplete, the nextLink field should be used to request the next list of webhooks.
	Value *[]Webhook `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of webhooks.
	NextLink *string `json:"nextLink,omitempty"`
}

// WebhookListResultIterator provides access to a complete listing of Webhook values.
type WebhookListResultIterator struct {
	i    int
	page WebhookListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WebhookListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WebhookListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WebhookListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WebhookListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WebhookListResultIterator) Response() WebhookListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WebhookListResultIterator) Value() Webhook {
	if !iter.page.NotDone() {
		return Webhook{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WebhookListResultIterator type.
func NewWebhookListResultIterator(page WebhookListResultPage) WebhookListResultIterator {
	return WebhookListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wlr WebhookListResult) IsEmpty() bool {
	return wlr.Value == nil || len(*wlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wlr WebhookListResult) hasNextLink() bool {
	return wlr.NextLink != nil && len(*wlr.NextLink) != 0
}

// webhookListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wlr WebhookListResult) webhookListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wlr.NextLink)))
}

// WebhookListResultPage contains a page of Webhook values.
type WebhookListResultPage struct {
	fn  func(context.Context, WebhookListResult) (WebhookListResult, error)
	wlr WebhookListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WebhookListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WebhookListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wlr)
		if err != nil {
			return err
		}
		page.wlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WebhookListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WebhookListResultPage) NotDone() bool {
	return !page.wlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WebhookListResultPage) Response() WebhookListResult {
	return page.wlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WebhookListResultPage) Values() []Webhook {
	if page.wlr.IsEmpty() {
		return nil
	}
	return *page.wlr.Value
}

// Creates a new instance of the WebhookListResultPage type.
func NewWebhookListResultPage(getNextPage func(context.Context, WebhookListResult) (WebhookListResult, error)) WebhookListResultPage {
	return WebhookListResultPage{fn: getNextPage}
}

// WebhookProperties the properties of a webhook.
type WebhookProperties struct {
	// Status - The status of the webhook at the time the operation was called. Possible values include: 'WebhookStatusEnabled', 'WebhookStatusDisabled'
	Status WebhookStatus `json:"status,omitempty"`
	// Scope - The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
	Scope *string `json:"scope,omitempty"`
	// Actions - The list of actions that trigger the webhook to post notifications.
	Actions *[]WebhookAction `json:"actions,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the webhook at the time the operation was called. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookProperties.
func (wp WebhookProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wp.Status != "" {
		objectMap["status"] = wp.Status
	}
	if wp.Scope != nil {
		objectMap["scope"] = wp.Scope
	}
	if wp.Actions != nil {
		objectMap["actions"] = wp.Actions
	}
	return json.Marshal(objectMap)
}

// WebhookPropertiesCreateParameters the parameters for creating the properties of a webhook.
type WebhookPropertiesCreateParameters struct {
	// ServiceURI - The service URI for the webhook to post notifications.
	ServiceURI *string `json:"serviceUri,omitempty"`
	// CustomHeaders - Custom headers that will be added to the webhook notifications.
	CustomHeaders map[string]*string `json:"customHeaders"`
	// Status - The status of the webhook at the time the operation was called. Possible values include: 'WebhookStatusEnabled', 'WebhookStatusDisabled'
	Status WebhookStatus `json:"status,omitempty"`
	// Scope - The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
	Scope *string `json:"scope,omitempty"`
	// Actions - The list of actions that trigger the webhook to post notifications.
	Actions *[]WebhookAction `json:"actions,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookPropertiesCreateParameters.
func (wpcp WebhookPropertiesCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wpcp.ServiceURI != nil {
		objectMap["serviceUri"] = wpcp.ServiceURI
	}
	if wpcp.CustomHeaders != nil {
		objectMap["customHeaders"] = wpcp.CustomHeaders
	}
	if wpcp.Status != "" {
		objectMap["status"] = wpcp.Status
	}
	if wpcp.Scope != nil {
		objectMap["scope"] = wpcp.Scope
	}
	if wpcp.Actions != nil {
		objectMap["actions"] = wpcp.Actions
	}
	return json.Marshal(objectMap)
}

// WebhookPropertiesUpdateParameters the parameters for updating the properties of a webhook.
type WebhookPropertiesUpdateParameters struct {
	// ServiceURI - The service URI for the webhook to post notifications.
	ServiceURI *string `json:"serviceUri,omitempty"`
	// CustomHeaders - Custom headers that will be added to the webhook notifications.
	CustomHeaders map[string]*string `json:"customHeaders"`
	// Status - The status of the webhook at the time the operation was called. Possible values include: 'WebhookStatusEnabled', 'WebhookStatusDisabled'
	Status WebhookStatus `json:"status,omitempty"`
	// Scope - The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
	Scope *string `json:"scope,omitempty"`
	// Actions - The list of actions that trigger the webhook to post notifications.
	Actions *[]WebhookAction `json:"actions,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookPropertiesUpdateParameters.
func (wpup WebhookPropertiesUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wpup.ServiceURI != nil {
		objectMap["serviceUri"] = wpup.ServiceURI
	}
	if wpup.CustomHeaders != nil {
		objectMap["customHeaders"] = wpup.CustomHeaders
	}
	if wpup.Status != "" {
		objectMap["status"] = wpup.Status
	}
	if wpup.Scope != nil {
		objectMap["scope"] = wpup.Scope
	}
	if wpup.Actions != nil {
		objectMap["actions"] = wpup.Actions
	}
	return json.Marshal(objectMap)
}

// WebhooksCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type WebhooksCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *WebhooksCreateFuture) Result(client WebhooksClient) (w Webhook, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.WebhooksCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.WebhooksCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if w.Response.Response, err = future.GetResult(sender); err == nil && w.Response.Response.StatusCode != http.StatusNoContent {
		w, err = client.CreateResponder(w.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.WebhooksCreateFuture", "Result", w.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WebhooksDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type WebhooksDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *WebhooksDeleteFuture) Result(client WebhooksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.WebhooksDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.WebhooksDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WebhooksUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type WebhooksUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *WebhooksUpdateFuture) Result(client WebhooksClient) (w Webhook, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.WebhooksUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.WebhooksUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if w.Response.Response, err = future.GetResult(sender); err == nil && w.Response.Response.StatusCode != http.StatusNoContent {
		w, err = client.UpdateResponder(w.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.WebhooksUpdateFuture", "Result", w.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WebhookUpdateParameters the parameters for updating a webhook.
type WebhookUpdateParameters struct {
	// Tags - The tags for the webhook.
	Tags map[string]*string `json:"tags"`
	// WebhookPropertiesUpdateParameters - The properties that the webhook will be updated with.
	*WebhookPropertiesUpdateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookUpdateParameters.
func (wup WebhookUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wup.Tags != nil {
		objectMap["tags"] = wup.Tags
	}
	if wup.WebhookPropertiesUpdateParameters != nil {
		objectMap["properties"] = wup.WebhookPropertiesUpdateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WebhookUpdateParameters struct.
func (wup *WebhookUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wup.Tags = tags
			}
		case "properties":
			if v != nil {
				var webhookPropertiesUpdateParameters WebhookPropertiesUpdateParameters
				err = json.Unmarshal(*v, &webhookPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				wup.WebhookPropertiesUpdateParameters = &webhookPropertiesUpdateParameters
			}
		}
	}

	return nil
}
