package cdn

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/cdn/mgmt/2016-10-02/cdn"

// CheckNameAvailabilityInput input of CheckNameAvailability API.
type CheckNameAvailabilityInput struct {
	// Name - The resource name to validate.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource whose name is to be validated.
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityOutput output of check name availability API.
type CheckNameAvailabilityOutput struct {
	autorest.Response `json:"-"`
	// NameAvailable - Indicates whether the name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - The reason why the name is not available.
	Reason *string `json:"reason,omitempty"`
	// Message - The detailed error message describing why the name is not available.
	Message *string `json:"message,omitempty"`
}

// CidrIPAddress CIDR Ip address
type CidrIPAddress struct {
	// BaseIPAddress - IP address itself.
	BaseIPAddress *string `json:"baseIpAddress,omitempty"`
	// PrefixLength - The length of the prefix of the ip address.
	PrefixLength *int32 `json:"prefixLength,omitempty"`
}

// CustomDomain customer provided domain for branding purposes, e.g. www.contoso.com.
type CustomDomain struct {
	autorest.Response       `json:"-"`
	*CustomDomainProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CustomDomain.
func (cd CustomDomain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cd.CustomDomainProperties != nil {
		objectMap["properties"] = cd.CustomDomainProperties
	}
	if cd.Location != nil {
		objectMap["location"] = cd.Location
	}
	if cd.Tags != nil {
		objectMap["tags"] = cd.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomDomain struct.
func (cd *CustomDomain) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var customDomainProperties CustomDomainProperties
				err = json.Unmarshal(*v, &customDomainProperties)
				if err != nil {
					return err
				}
				cd.CustomDomainProperties = &customDomainProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cd.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cd.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cd.Tags = tags
			}
		}
	}

	return nil
}

// CustomDomainListResult result of the request to list custom domains. It contains a list of custom domain
// objects and a URL link to get the next set of results.
type CustomDomainListResult struct {
	autorest.Response `json:"-"`
	// Value - List of CDN CustomDomains within an endpoint.
	Value *[]CustomDomain `json:"value,omitempty"`
	// NextLink - URL to get the next set of custom domain objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// CustomDomainListResultIterator provides access to a complete listing of CustomDomain values.
type CustomDomainListResultIterator struct {
	i    int
	page CustomDomainListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CustomDomainListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomDomainListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CustomDomainListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CustomDomainListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CustomDomainListResultIterator) Response() CustomDomainListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CustomDomainListResultIterator) Value() CustomDomain {
	if !iter.page.NotDone() {
		return CustomDomain{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CustomDomainListResultIterator type.
func NewCustomDomainListResultIterator(page CustomDomainListResultPage) CustomDomainListResultIterator {
	return CustomDomainListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cdlr CustomDomainListResult) IsEmpty() bool {
	return cdlr.Value == nil || len(*cdlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cdlr CustomDomainListResult) hasNextLink() bool {
	return cdlr.NextLink != nil && len(*cdlr.NextLink) != 0
}

// customDomainListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cdlr CustomDomainListResult) customDomainListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !cdlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cdlr.NextLink)))
}

// CustomDomainListResultPage contains a page of CustomDomain values.
type CustomDomainListResultPage struct {
	fn   func(context.Context, CustomDomainListResult) (CustomDomainListResult, error)
	cdlr CustomDomainListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CustomDomainListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomDomainListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cdlr)
		if err != nil {
			return err
		}
		page.cdlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CustomDomainListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CustomDomainListResultPage) NotDone() bool {
	return !page.cdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CustomDomainListResultPage) Response() CustomDomainListResult {
	return page.cdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CustomDomainListResultPage) Values() []CustomDomain {
	if page.cdlr.IsEmpty() {
		return nil
	}
	return *page.cdlr.Value
}

// Creates a new instance of the CustomDomainListResultPage type.
func NewCustomDomainListResultPage(getNextPage func(context.Context, CustomDomainListResult) (CustomDomainListResult, error)) CustomDomainListResultPage {
	return CustomDomainListResultPage{fn: getNextPage}
}

// CustomDomainParameters the customDomain JSON object required for custom domain creation or update.
type CustomDomainParameters struct {
	*CustomDomainPropertiesParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomDomainParameters.
func (cdp CustomDomainParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cdp.CustomDomainPropertiesParameters != nil {
		objectMap["properties"] = cdp.CustomDomainPropertiesParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomDomainParameters struct.
func (cdp *CustomDomainParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var customDomainPropertiesParameters CustomDomainPropertiesParameters
				err = json.Unmarshal(*v, &customDomainPropertiesParameters)
				if err != nil {
					return err
				}
				cdp.CustomDomainPropertiesParameters = &customDomainPropertiesParameters
			}
		}
	}

	return nil
}

// CustomDomainProperties the JSON object that contains the properties of the custom domain to create.
type CustomDomainProperties struct {
	// HostName - The host name of the custom domain. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
	// ResourceState - READ-ONLY; Resource status of the custom domain. Possible values include: 'Creating', 'Active', 'Deleting'
	ResourceState CustomDomainResourceState `json:"resourceState,omitempty"`
	// CustomHTTPSProvisioningState - READ-ONLY; Provisioning state of Custom Https of the custom domain. Possible values include: 'Enabling', 'Enabled', 'Disabling', 'Disabled', 'Failed'
	CustomHTTPSProvisioningState CustomHTTPSProvisioningState `json:"customHttpsProvisioningState,omitempty"`
	// ValidationData - Special validation or data may be required when delivering CDN to some regions due to local compliance reasons. E.g. ICP license number of a custom domain is required to deliver content in China.
	ValidationData *string `json:"validationData,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning status of the custom domain.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomDomainProperties.
func (cdp CustomDomainProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cdp.HostName != nil {
		objectMap["hostName"] = cdp.HostName
	}
	if cdp.ValidationData != nil {
		objectMap["validationData"] = cdp.ValidationData
	}
	return json.Marshal(objectMap)
}

// CustomDomainPropertiesParameters the JSON object that contains the properties of the custom domain to
// create.
type CustomDomainPropertiesParameters struct {
	// HostName - The host name of the custom domain. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
}

// CustomDomainsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CustomDomainsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *CustomDomainsCreateFuture) Result(client CustomDomainsClient) (cd CustomDomain, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.CustomDomainsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.CustomDomainsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cd.Response.Response, err = future.GetResult(sender); err == nil && cd.Response.Response.StatusCode != http.StatusNoContent {
		cd, err = client.CreateResponder(cd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.CustomDomainsCreateFuture", "Result", cd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CustomDomainsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CustomDomainsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *CustomDomainsDeleteFuture) Result(client CustomDomainsClient) (cd CustomDomain, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.CustomDomainsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.CustomDomainsDeleteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cd.Response.Response, err = future.GetResult(sender); err == nil && cd.Response.Response.StatusCode != http.StatusNoContent {
		cd, err = client.DeleteResponder(cd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.CustomDomainsDeleteFuture", "Result", cd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeepCreatedOrigin origin to be added when creating a CDN endpoint.
type DeepCreatedOrigin struct {
	// Name - Origin name
	Name                         *string `json:"name,omitempty"`
	*DeepCreatedOriginProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DeepCreatedOrigin.
func (dco DeepCreatedOrigin) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dco.Name != nil {
		objectMap["name"] = dco.Name
	}
	if dco.DeepCreatedOriginProperties != nil {
		objectMap["properties"] = dco.DeepCreatedOriginProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DeepCreatedOrigin struct.
func (dco *DeepCreatedOrigin) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dco.Name = &name
			}
		case "properties":
			if v != nil {
				var deepCreatedOriginProperties DeepCreatedOriginProperties
				err = json.Unmarshal(*v, &deepCreatedOriginProperties)
				if err != nil {
					return err
				}
				dco.DeepCreatedOriginProperties = &deepCreatedOriginProperties
			}
		}
	}

	return nil
}

// DeepCreatedOriginProperties properties of origin Properties of the origin created on the CDN endpoint.
type DeepCreatedOriginProperties struct {
	// HostName - The address of the origin. It can be a domain names, IPv4 address, or IPv6 address.
	HostName *string `json:"hostName,omitempty"`
	// HTTPPort - The value of the HTTP port. Must be between 1 and 65535
	HTTPPort *int32 `json:"httpPort,omitempty"`
	// HTTPSPort - The value of the HTTPS port. Must be between 1 and 65535
	HTTPSPort *int32 `json:"httpsPort,omitempty"`
}

// EdgeNode edge node of CDN service.
type EdgeNode struct {
	*EdgeNodeProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for EdgeNode.
func (en EdgeNode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if en.EdgeNodeProperties != nil {
		objectMap["properties"] = en.EdgeNodeProperties
	}
	if en.Location != nil {
		objectMap["location"] = en.Location
	}
	if en.Tags != nil {
		objectMap["tags"] = en.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EdgeNode struct.
func (en *EdgeNode) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var edgeNodeProperties EdgeNodeProperties
				err = json.Unmarshal(*v, &edgeNodeProperties)
				if err != nil {
					return err
				}
				en.EdgeNodeProperties = &edgeNodeProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				en.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				en.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				en.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				en.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				en.Tags = tags
			}
		}
	}

	return nil
}

// EdgeNodeProperties the JSON object that contains the properties required to create an edgenode.
type EdgeNodeProperties struct {
	// IPAddressGroups - List of ip address groups.
	IPAddressGroups *[]IPAddressGroup `json:"ipAddressGroups,omitempty"`
}

// EdgenodeResult result of the request to list CDN edgenodes. It contains a list of ip address group and a URL
// link to get the next set of results.
type EdgenodeResult struct {
	autorest.Response `json:"-"`
	// Value - Edge node of CDN service.
	Value *[]EdgeNode `json:"value,omitempty"`
	// NextLink - URL to get the next set of edgenode list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// EdgenodeResultIterator provides access to a complete listing of EdgeNode values.
type EdgenodeResultIterator struct {
	i    int
	page EdgenodeResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EdgenodeResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EdgenodeResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EdgenodeResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EdgenodeResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EdgenodeResultIterator) Response() EdgenodeResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EdgenodeResultIterator) Value() EdgeNode {
	if !iter.page.NotDone() {
		return EdgeNode{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EdgenodeResultIterator type.
func NewEdgenodeResultIterator(page EdgenodeResultPage) EdgenodeResultIterator {
	return EdgenodeResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (er EdgenodeResult) IsEmpty() bool {
	return er.Value == nil || len(*er.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (er EdgenodeResult) hasNextLink() bool {
	return er.NextLink != nil && len(*er.NextLink) != 0
}

// edgenodeResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (er EdgenodeResult) edgenodeResultPreparer(ctx context.Context) (*http.Request, error) {
	if !er.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(er.NextLink)))
}

// EdgenodeResultPage contains a page of EdgeNode values.
type EdgenodeResultPage struct {
	fn func(context.Context, EdgenodeResult) (EdgenodeResult, error)
	er EdgenodeResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EdgenodeResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EdgenodeResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.er)
		if err != nil {
			return err
		}
		page.er = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EdgenodeResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EdgenodeResultPage) NotDone() bool {
	return !page.er.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EdgenodeResultPage) Response() EdgenodeResult {
	return page.er
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EdgenodeResultPage) Values() []EdgeNode {
	if page.er.IsEmpty() {
		return nil
	}
	return *page.er.Value
}

// Creates a new instance of the EdgenodeResultPage type.
func NewEdgenodeResultPage(getNextPage func(context.Context, EdgenodeResult) (EdgenodeResult, error)) EdgenodeResultPage {
	return EdgenodeResultPage{fn: getNextPage}
}

// Endpoint CDN endpoint is the entity within a CDN profile containing configuration information such as
// origin, protocol, content caching and delivery behavior. The CDN endpoint uses the URL format
// <endpointname>.azureedge.net.
type Endpoint struct {
	autorest.Response   `json:"-"`
	*EndpointProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Endpoint.
func (e Endpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.EndpointProperties != nil {
		objectMap["properties"] = e.EndpointProperties
	}
	if e.Location != nil {
		objectMap["location"] = e.Location
	}
	if e.Tags != nil {
		objectMap["tags"] = e.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Endpoint struct.
func (e *Endpoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var endpointProperties EndpointProperties
				err = json.Unmarshal(*v, &endpointProperties)
				if err != nil {
					return err
				}
				e.EndpointProperties = &endpointProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				e.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				e.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				e.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				e.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				e.Tags = tags
			}
		}
	}

	return nil
}

// EndpointListResult result of the request to list endpoints. It contains a list of endpoint objects and a URL
// link to get the next set of results.
type EndpointListResult struct {
	autorest.Response `json:"-"`
	// Value - List of CDN endpoints within a profile
	Value *[]Endpoint `json:"value,omitempty"`
	// NextLink - URL to get the next set of endpoint objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// EndpointListResultIterator provides access to a complete listing of Endpoint values.
type EndpointListResultIterator struct {
	i    int
	page EndpointListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EndpointListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EndpointListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EndpointListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EndpointListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EndpointListResultIterator) Response() EndpointListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EndpointListResultIterator) Value() Endpoint {
	if !iter.page.NotDone() {
		return Endpoint{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EndpointListResultIterator type.
func NewEndpointListResultIterator(page EndpointListResultPage) EndpointListResultIterator {
	return EndpointListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (elr EndpointListResult) IsEmpty() bool {
	return elr.Value == nil || len(*elr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (elr EndpointListResult) hasNextLink() bool {
	return elr.NextLink != nil && len(*elr.NextLink) != 0
}

// endpointListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (elr EndpointListResult) endpointListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !elr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(elr.NextLink)))
}

// EndpointListResultPage contains a page of Endpoint values.
type EndpointListResultPage struct {
	fn  func(context.Context, EndpointListResult) (EndpointListResult, error)
	elr EndpointListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EndpointListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EndpointListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.elr)
		if err != nil {
			return err
		}
		page.elr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EndpointListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EndpointListResultPage) NotDone() bool {
	return !page.elr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EndpointListResultPage) Response() EndpointListResult {
	return page.elr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EndpointListResultPage) Values() []Endpoint {
	if page.elr.IsEmpty() {
		return nil
	}
	return *page.elr.Value
}

// Creates a new instance of the EndpointListResultPage type.
func NewEndpointListResultPage(getNextPage func(context.Context, EndpointListResult) (EndpointListResult, error)) EndpointListResultPage {
	return EndpointListResultPage{fn: getNextPage}
}

// EndpointProperties the JSON object that contains the properties required to create an endpoint.
type EndpointProperties struct {
	// HostName - READ-ONLY; The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g. contoso.azureedge.net
	HostName *string `json:"hostName,omitempty"`
	// Origins - The source of the content being delivered via CDN.
	Origins *[]DeepCreatedOrigin `json:"origins,omitempty"`
	// ResourceState - READ-ONLY; Resource status of the endpoint. Possible values include: 'EndpointResourceStateCreating', 'EndpointResourceStateDeleting', 'EndpointResourceStateRunning', 'EndpointResourceStateStarting', 'EndpointResourceStateStopped', 'EndpointResourceStateStopping'
	ResourceState EndpointResourceState `json:"resourceState,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning status of the endpoint.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// OriginHostHeader - The host header CDN sends along with content requests to origin. The default value is the host name of the origin.
	OriginHostHeader *string `json:"originHostHeader,omitempty"`
	// OriginPath - The path used when CDN sends request to origin.
	OriginPath *string `json:"originPath,omitempty"`
	// ContentTypesToCompress - List of content types on which compression applies. The value should be a valid MIME type.
	ContentTypesToCompress *[]string `json:"contentTypesToCompress,omitempty"`
	// IsCompressionEnabled - Indicates whether content compression is enabled on CDN. Default value is false. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on CDN when requested content is smaller than 1 byte or larger than 1 MB.
	IsCompressionEnabled *bool `json:"isCompressionEnabled,omitempty"`
	// IsHTTPAllowed - Indicates whether HTTP traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
	IsHTTPAllowed *bool `json:"isHttpAllowed,omitempty"`
	// IsHTTPSAllowed - Indicates whether HTTPS traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
	IsHTTPSAllowed *bool `json:"isHttpsAllowed,omitempty"`
	// QueryStringCachingBehavior - Defines the query string caching behavior. Possible values include: 'IgnoreQueryString', 'BypassCaching', 'UseQueryString', 'NotSet'
	QueryStringCachingBehavior QueryStringCachingBehavior `json:"queryStringCachingBehavior,omitempty"`
	// OptimizationType - Customer can specify what scenario they want this CDN endpoint to optimize, e.g. Download, Media services. With this information we can apply scenario driven optimization. Possible values include: 'GeneralWebDelivery', 'GeneralMediaStreaming', 'VideoOnDemandMediaStreaming', 'LargeFileDownload', 'DynamicSiteAcceleration'
	OptimizationType OptimizationType `json:"optimizationType,omitempty"`
	// GeoFilters - List of rules defining user geo access within a CDN endpoint. Each geo filter defines an access rule to a specified path or content, e.g. block APAC for path /pictures/
	GeoFilters *[]GeoFilter `json:"geoFilters,omitempty"`
}

// MarshalJSON is the custom marshaler for EndpointProperties.
func (ep EndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ep.Origins != nil {
		objectMap["origins"] = ep.Origins
	}
	if ep.OriginHostHeader != nil {
		objectMap["originHostHeader"] = ep.OriginHostHeader
	}
	if ep.OriginPath != nil {
		objectMap["originPath"] = ep.OriginPath
	}
	if ep.ContentTypesToCompress != nil {
		objectMap["contentTypesToCompress"] = ep.ContentTypesToCompress
	}
	if ep.IsCompressionEnabled != nil {
		objectMap["isCompressionEnabled"] = ep.IsCompressionEnabled
	}
	if ep.IsHTTPAllowed != nil {
		objectMap["isHttpAllowed"] = ep.IsHTTPAllowed
	}
	if ep.IsHTTPSAllowed != nil {
		objectMap["isHttpsAllowed"] = ep.IsHTTPSAllowed
	}
	if ep.QueryStringCachingBehavior != "" {
		objectMap["queryStringCachingBehavior"] = ep.QueryStringCachingBehavior
	}
	if ep.OptimizationType != "" {
		objectMap["optimizationType"] = ep.OptimizationType
	}
	if ep.GeoFilters != nil {
		objectMap["geoFilters"] = ep.GeoFilters
	}
	return json.Marshal(objectMap)
}

// EndpointPropertiesUpdateParameters result of the request to list endpoints. It contains a list of endpoints
// and a URL link to get the next set of results.
type EndpointPropertiesUpdateParameters struct {
	// OriginHostHeader - The host header CDN sends along with content requests to origin. The default value is the host name of the origin.
	OriginHostHeader *string `json:"originHostHeader,omitempty"`
	// OriginPath - The path used when CDN sends request to origin.
	OriginPath *string `json:"originPath,omitempty"`
	// ContentTypesToCompress - List of content types on which compression applies. The value should be a valid MIME type.
	ContentTypesToCompress *[]string `json:"contentTypesToCompress,omitempty"`
	// IsCompressionEnabled - Indicates whether content compression is enabled on CDN. Default value is false. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on CDN when requested content is smaller than 1 byte or larger than 1 MB.
	IsCompressionEnabled *bool `json:"isCompressionEnabled,omitempty"`
	// IsHTTPAllowed - Indicates whether HTTP traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
	IsHTTPAllowed *bool `json:"isHttpAllowed,omitempty"`
	// IsHTTPSAllowed - Indicates whether HTTPS traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
	IsHTTPSAllowed *bool `json:"isHttpsAllowed,omitempty"`
	// QueryStringCachingBehavior - Defines the query string caching behavior. Possible values include: 'IgnoreQueryString', 'BypassCaching', 'UseQueryString', 'NotSet'
	QueryStringCachingBehavior QueryStringCachingBehavior `json:"queryStringCachingBehavior,omitempty"`
	// OptimizationType - Customer can specify what scenario they want this CDN endpoint to optimize, e.g. Download, Media services. With this information we can apply scenario driven optimization. Possible values include: 'GeneralWebDelivery', 'GeneralMediaStreaming', 'VideoOnDemandMediaStreaming', 'LargeFileDownload', 'DynamicSiteAcceleration'
	OptimizationType OptimizationType `json:"optimizationType,omitempty"`
	// GeoFilters - List of rules defining user geo access within a CDN endpoint. Each geo filter defines an access rule to a specified path or content, e.g. block APAC for path /pictures/
	GeoFilters *[]GeoFilter `json:"geoFilters,omitempty"`
}

// EndpointsCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type EndpointsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EndpointsCreateFuture) Result(client EndpointsClient) (e Endpoint, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.CreateResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.EndpointsCreateFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EndpointsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type EndpointsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EndpointsDeleteFuture) Result(client EndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EndpointsLoadContentFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EndpointsLoadContentFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EndpointsLoadContentFuture) Result(client EndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsLoadContentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsLoadContentFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EndpointsPurgeContentFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EndpointsPurgeContentFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EndpointsPurgeContentFuture) Result(client EndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsPurgeContentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsPurgeContentFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EndpointsStartFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type EndpointsStartFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EndpointsStartFuture) Result(client EndpointsClient) (e Endpoint, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsStartFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.StartResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.EndpointsStartFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EndpointsStopFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type EndpointsStopFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EndpointsStopFuture) Result(client EndpointsClient) (e Endpoint, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsStopFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.StopResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.EndpointsStopFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EndpointsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type EndpointsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EndpointsUpdateFuture) Result(client EndpointsClient) (e Endpoint, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.UpdateResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.EndpointsUpdateFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EndpointUpdateParameters properties required to create a new endpoint.
type EndpointUpdateParameters struct {
	// Tags - Endpoint tags.
	Tags                                map[string]*string `json:"tags"`
	*EndpointPropertiesUpdateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for EndpointUpdateParameters.
func (eup EndpointUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eup.Tags != nil {
		objectMap["tags"] = eup.Tags
	}
	if eup.EndpointPropertiesUpdateParameters != nil {
		objectMap["properties"] = eup.EndpointPropertiesUpdateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EndpointUpdateParameters struct.
func (eup *EndpointUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				eup.Tags = tags
			}
		case "properties":
			if v != nil {
				var endpointPropertiesUpdateParameters EndpointPropertiesUpdateParameters
				err = json.Unmarshal(*v, &endpointPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				eup.EndpointPropertiesUpdateParameters = &endpointPropertiesUpdateParameters
			}
		}
	}

	return nil
}

// ErrorResponse error response indicates CDN service is not able to process the incoming request. The reason
// is provided in the error message.
type ErrorResponse struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// GeoFilter rules defining user geo access within a CDN endpoint.
type GeoFilter struct {
	// RelativePath - Relative path applicable to geo filter. (e.g. '/mypictures', '/mypicture/kitty.jpg', and etc.)
	RelativePath *string `json:"relativePath,omitempty"`
	// Action - Action of the geo filter, i.e. allow or block access. Possible values include: 'Block', 'Allow'
	Action GeoFilterActions `json:"action,omitempty"`
	// CountryCodes - Two letter country codes defining user country access in a geo filter, e.g. AU, MX, US.
	CountryCodes *[]string `json:"countryCodes,omitempty"`
}

// IPAddressGroup CDN Ip address group
type IPAddressGroup struct {
	// DeliveryRegion - The delivery region of the ip address group
	DeliveryRegion *string `json:"deliveryRegion,omitempty"`
	// Ipv4Addresses - The list of ip v4 addresses.
	Ipv4Addresses *[]CidrIPAddress `json:"ipv4Addresses,omitempty"`
	// Ipv6Addresses - The list of ip v6 addresses.
	Ipv6Addresses *[]CidrIPAddress `json:"ipv6Addresses,omitempty"`
}

// LoadParameters parameters required for content load.
type LoadParameters struct {
	// ContentPaths - The path to the content to be loaded. Path should be a relative file URL of the origin.
	ContentPaths *[]string `json:"contentPaths,omitempty"`
}

// Operation CDN REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.Cdn
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult result of the request to list CDN operations. It contains a list of operations and a URL
// link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of CDN operations supported by the CDN resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{fn: getNextPage}
}

// Origin CDN origin is the source of the content being delivered via CDN. When the edge nodes represented by
// an endpoint do not have the requested content cached, they attempt to fetch it from one or more of the
// configured origins.
type Origin struct {
	autorest.Response `json:"-"`
	*OriginProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Origin.
func (o Origin) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.OriginProperties != nil {
		objectMap["properties"] = o.OriginProperties
	}
	if o.Location != nil {
		objectMap["location"] = o.Location
	}
	if o.Tags != nil {
		objectMap["tags"] = o.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Origin struct.
func (o *Origin) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var originProperties OriginProperties
				err = json.Unmarshal(*v, &originProperties)
				if err != nil {
					return err
				}
				o.OriginProperties = &originProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				o.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				o.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				o.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				o.Tags = tags
			}
		}
	}

	return nil
}

// OriginListResult result of the request to list origins. It contains a list of origin objects and a URL link
// to get the next set of results.
type OriginListResult struct {
	autorest.Response `json:"-"`
	// Value - List of CDN origins within an endpoint
	Value *[]Origin `json:"value,omitempty"`
	// NextLink - URL to get the next set of origin objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OriginListResultIterator provides access to a complete listing of Origin values.
type OriginListResultIterator struct {
	i    int
	page OriginListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OriginListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OriginListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OriginListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OriginListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OriginListResultIterator) Response() OriginListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OriginListResultIterator) Value() Origin {
	if !iter.page.NotDone() {
		return Origin{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OriginListResultIterator type.
func NewOriginListResultIterator(page OriginListResultPage) OriginListResultIterator {
	return OriginListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OriginListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OriginListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// originListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OriginListResult) originListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OriginListResultPage contains a page of Origin values.
type OriginListResultPage struct {
	fn  func(context.Context, OriginListResult) (OriginListResult, error)
	olr OriginListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OriginListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OriginListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OriginListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OriginListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OriginListResultPage) Response() OriginListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OriginListResultPage) Values() []Origin {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OriginListResultPage type.
func NewOriginListResultPage(getNextPage func(context.Context, OriginListResult) (OriginListResult, error)) OriginListResultPage {
	return OriginListResultPage{fn: getNextPage}
}

// OriginProperties the JSON object that contains the properties of the origin to create.
type OriginProperties struct {
	// HostName - The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.
	HostName *string `json:"hostName,omitempty"`
	// HTTPPort - The value of the HTTP port. Must be between 1 and 65535.
	HTTPPort *int32 `json:"httpPort,omitempty"`
	// HTTPSPort - The value of the https port. Must be between 1 and 65535.
	HTTPSPort *int32 `json:"httpsPort,omitempty"`
	// ResourceState - READ-ONLY; Resource status of the origin. Possible values include: 'OriginResourceStateCreating', 'OriginResourceStateActive', 'OriginResourceStateDeleting'
	ResourceState OriginResourceState `json:"resourceState,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning status of the origin.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for OriginProperties.
func (op OriginProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if op.HostName != nil {
		objectMap["hostName"] = op.HostName
	}
	if op.HTTPPort != nil {
		objectMap["httpPort"] = op.HTTPPort
	}
	if op.HTTPSPort != nil {
		objectMap["httpsPort"] = op.HTTPSPort
	}
	return json.Marshal(objectMap)
}

// OriginPropertiesParameters the JSON object that contains the properties of the origin to create.
type OriginPropertiesParameters struct {
	// HostName - The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.
	HostName *string `json:"hostName,omitempty"`
	// HTTPPort - The value of the HTTP port. Must be between 1 and 65535.
	HTTPPort *int32 `json:"httpPort,omitempty"`
	// HTTPSPort - The value of the HTTPS port. Must be between 1 and 65535.
	HTTPSPort *int32 `json:"httpsPort,omitempty"`
}

// OriginsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type OriginsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *OriginsUpdateFuture) Result(client OriginsClient) (o Origin, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.OriginsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.OriginsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if o.Response.Response, err = future.GetResult(sender); err == nil && o.Response.Response.StatusCode != http.StatusNoContent {
		o, err = client.UpdateResponder(o.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.OriginsUpdateFuture", "Result", o.Response.Response, "Failure responding to request")
		}
	}
	return
}

// OriginUpdateParameters origin properties needed for origin creation or update.
type OriginUpdateParameters struct {
	*OriginPropertiesParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for OriginUpdateParameters.
func (oup OriginUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oup.OriginPropertiesParameters != nil {
		objectMap["properties"] = oup.OriginPropertiesParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OriginUpdateParameters struct.
func (oup *OriginUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var originPropertiesParameters OriginPropertiesParameters
				err = json.Unmarshal(*v, &originPropertiesParameters)
				if err != nil {
					return err
				}
				oup.OriginPropertiesParameters = &originPropertiesParameters
			}
		}
	}

	return nil
}

// Profile CDN profile represents the top level resource and the entry point into the CDN API. This allows
// users to set up a logical grouping of endpoints in addition to creating shared configuration settings and
// selecting pricing tiers and providers.
type Profile struct {
	autorest.Response `json:"-"`
	// Sku - The pricing tier (defines a CDN provider, feature list and rate) of the CDN profile.
	Sku                *Sku `json:"sku,omitempty"`
	*ProfileProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Profile.
func (p Profile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.Sku != nil {
		objectMap["sku"] = p.Sku
	}
	if p.ProfileProperties != nil {
		objectMap["properties"] = p.ProfileProperties
	}
	if p.Location != nil {
		objectMap["location"] = p.Location
	}
	if p.Tags != nil {
		objectMap["tags"] = p.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Profile struct.
func (p *Profile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				p.Sku = &sku
			}
		case "properties":
			if v != nil {
				var profileProperties ProfileProperties
				err = json.Unmarshal(*v, &profileProperties)
				if err != nil {
					return err
				}
				p.ProfileProperties = &profileProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				p.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				p.Tags = tags
			}
		}
	}

	return nil
}

// ProfileListResult result of the request to list profiles. It contains a list of profile objects and a URL
// link to get the next set of results.
type ProfileListResult struct {
	autorest.Response `json:"-"`
	// Value - List of CDN profiles within a resource group.
	Value *[]Profile `json:"value,omitempty"`
	// NextLink - URL to get the next set of profile objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProfileListResultIterator provides access to a complete listing of Profile values.
type ProfileListResultIterator struct {
	i    int
	page ProfileListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProfileListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProfileListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProfileListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProfileListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProfileListResultIterator) Response() ProfileListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProfileListResultIterator) Value() Profile {
	if !iter.page.NotDone() {
		return Profile{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProfileListResultIterator type.
func NewProfileListResultIterator(page ProfileListResultPage) ProfileListResultIterator {
	return ProfileListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plr ProfileListResult) IsEmpty() bool {
	return plr.Value == nil || len(*plr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plr ProfileListResult) hasNextLink() bool {
	return plr.NextLink != nil && len(*plr.NextLink) != 0
}

// profileListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plr ProfileListResult) profileListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !plr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plr.NextLink)))
}

// ProfileListResultPage contains a page of Profile values.
type ProfileListResultPage struct {
	fn  func(context.Context, ProfileListResult) (ProfileListResult, error)
	plr ProfileListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProfileListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProfileListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plr)
		if err != nil {
			return err
		}
		page.plr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProfileListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProfileListResultPage) NotDone() bool {
	return !page.plr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProfileListResultPage) Response() ProfileListResult {
	return page.plr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProfileListResultPage) Values() []Profile {
	if page.plr.IsEmpty() {
		return nil
	}
	return *page.plr.Value
}

// Creates a new instance of the ProfileListResultPage type.
func NewProfileListResultPage(getNextPage func(context.Context, ProfileListResult) (ProfileListResult, error)) ProfileListResultPage {
	return ProfileListResultPage{fn: getNextPage}
}

// ProfileProperties the JSON object that contains the properties required to create a profile.
type ProfileProperties struct {
	// ResourceState - READ-ONLY; Resource status of the profile. Possible values include: 'ProfileResourceStateCreating', 'ProfileResourceStateActive', 'ProfileResourceStateDeleting', 'ProfileResourceStateDisabled'
	ResourceState ProfileResourceState `json:"resourceState,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning status of the profile.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ProfilesCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ProfilesCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ProfilesCreateFuture) Result(client ProfilesClient) (p Profile, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.ProfilesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.ProfilesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if p.Response.Response, err = future.GetResult(sender); err == nil && p.Response.Response.StatusCode != http.StatusNoContent {
		p, err = client.CreateResponder(p.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.ProfilesCreateFuture", "Result", p.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ProfilesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ProfilesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ProfilesDeleteFuture) Result(client ProfilesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.ProfilesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.ProfilesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ProfilesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ProfilesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ProfilesUpdateFuture) Result(client ProfilesClient) (p Profile, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.ProfilesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.ProfilesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if p.Response.Response, err = future.GetResult(sender); err == nil && p.Response.Response.StatusCode != http.StatusNoContent {
		p, err = client.UpdateResponder(p.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.ProfilesUpdateFuture", "Result", p.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ProfileUpdateParameters properties required to update a profile.
type ProfileUpdateParameters struct {
	// Tags - Profile tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ProfileUpdateParameters.
func (pup ProfileUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pup.Tags != nil {
		objectMap["tags"] = pup.Tags
	}
	return json.Marshal(objectMap)
}

// PurgeParameters parameters required for content purge.
type PurgeParameters struct {
	// ContentPaths - The path to the content to be purged. Can describe a file path or a wild card directory.
	ContentPaths *[]string `json:"contentPaths,omitempty"`
}

// Resource the Resource definition.
type Resource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ResourceUsage output of check resource usage API.
type ResourceUsage struct {
	// ResourceType - Resource type of the usages.
	ResourceType *string `json:"resourceType,omitempty"`
	// Unit - Unit of the usage. e.g. Count.
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - Actual value of the resource type.
	CurrentValue *int32 `json:"currentValue,omitempty"`
	// Limit - Quota of the resource type.
	Limit *int32 `json:"limit,omitempty"`
}

// ResourceUsageListResult output of check resource usage API.
type ResourceUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - List of resource usages.
	Value *[]ResourceUsage `json:"value,omitempty"`
	// NextLink - URL to get the next set of custom domain objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceUsageListResultIterator provides access to a complete listing of ResourceUsage values.
type ResourceUsageListResultIterator struct {
	i    int
	page ResourceUsageListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceUsageListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceUsageListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceUsageListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceUsageListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceUsageListResultIterator) Response() ResourceUsageListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceUsageListResultIterator) Value() ResourceUsage {
	if !iter.page.NotDone() {
		return ResourceUsage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceUsageListResultIterator type.
func NewResourceUsageListResultIterator(page ResourceUsageListResultPage) ResourceUsageListResultIterator {
	return ResourceUsageListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rulr ResourceUsageListResult) IsEmpty() bool {
	return rulr.Value == nil || len(*rulr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rulr ResourceUsageListResult) hasNextLink() bool {
	return rulr.NextLink != nil && len(*rulr.NextLink) != 0
}

// resourceUsageListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rulr ResourceUsageListResult) resourceUsageListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rulr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rulr.NextLink)))
}

// ResourceUsageListResultPage contains a page of ResourceUsage values.
type ResourceUsageListResultPage struct {
	fn   func(context.Context, ResourceUsageListResult) (ResourceUsageListResult, error)
	rulr ResourceUsageListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceUsageListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceUsageListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rulr)
		if err != nil {
			return err
		}
		page.rulr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceUsageListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceUsageListResultPage) NotDone() bool {
	return !page.rulr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceUsageListResultPage) Response() ResourceUsageListResult {
	return page.rulr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceUsageListResultPage) Values() []ResourceUsage {
	if page.rulr.IsEmpty() {
		return nil
	}
	return *page.rulr.Value
}

// Creates a new instance of the ResourceUsageListResultPage type.
func NewResourceUsageListResultPage(getNextPage func(context.Context, ResourceUsageListResult) (ResourceUsageListResult, error)) ResourceUsageListResultPage {
	return ResourceUsageListResultPage{fn: getNextPage}
}

// Sku the pricing tier (defines a CDN provider, feature list and rate) of the CDN profile.
type Sku struct {
	// Name - Name of the pricing tier. Possible values include: 'StandardVerizon', 'PremiumVerizon', 'CustomVerizon', 'StandardAkamai', 'StandardChinaCdn'
	Name SkuName `json:"name,omitempty"`
}

// SsoURI SSO URI required to login to the supplemental portal.
type SsoURI struct {
	autorest.Response `json:"-"`
	// SsoURIValue - The URI used to login to the supplemental portal.
	SsoURIValue *string `json:"ssoUriValue,omitempty"`
}

// SupportedOptimizationTypesResult the result of the GetSupportedOptimizationTypes API
type SupportedOptimizationTypesResult struct {
	autorest.Response `json:"-"`
	// SupportedOptimizationTypes - Supported optimization types for a profile.
	SupportedOptimizationTypes *[]OptimizationType `json:"supportedOptimizationTypes,omitempty"`
}

// ValidateCustomDomainInput input of the custom domain to be validated for DNS mapping.
type ValidateCustomDomainInput struct {
	// HostName - The host name of the custom domain. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
}

// ValidateCustomDomainOutput output of custom domain validation.
type ValidateCustomDomainOutput struct {
	autorest.Response `json:"-"`
	// CustomDomainValidated - Indicates whether the custom domain is validated or not.
	CustomDomainValidated *bool `json:"customDomainValidated,omitempty"`
	// Reason - The reason why the custom domain is not valid.
	Reason *string `json:"reason,omitempty"`
	// Message - Error message describing why the custom domain is not valid.
	Message *string `json:"message,omitempty"`
}
