// Copyright 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.11.2
// source: google/cloud/bigquery/logging/v1/audit_data.proto

package logging

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// BigQuery request and response messages for audit log.
// Note: `Table.schema` has been deprecated in favor of `Table.schemaJson`.
// `Table.schema` may continue to be present in your logs during this
// transition.
type AuditData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Request data for each BigQuery method.
	//
	// Types that are assignable to Request:
	//	*AuditData_TableInsertRequest
	//	*AuditData_TableUpdateRequest
	//	*AuditData_DatasetListRequest
	//	*AuditData_DatasetInsertRequest
	//	*AuditData_DatasetUpdateRequest
	//	*AuditData_JobInsertRequest
	//	*AuditData_JobQueryRequest
	//	*AuditData_JobGetQueryResultsRequest
	//	*AuditData_TableDataListRequest
	Request isAuditData_Request `protobuf_oneof:"request"`
	// Response data for each BigQuery method.
	//
	// Types that are assignable to Response:
	//	*AuditData_TableInsertResponse
	//	*AuditData_TableUpdateResponse
	//	*AuditData_DatasetInsertResponse
	//	*AuditData_DatasetUpdateResponse
	//	*AuditData_JobInsertResponse
	//	*AuditData_JobQueryResponse
	//	*AuditData_JobGetQueryResultsResponse
	//	*AuditData_JobQueryDoneResponse
	Response isAuditData_Response `protobuf_oneof:"response"`
	// A job completion event.
	JobCompletedEvent *JobCompletedEvent `protobuf:"bytes,17,opt,name=job_completed_event,json=jobCompletedEvent,proto3" json:"job_completed_event,omitempty"`
}

func (x *AuditData) Reset() {
	*x = AuditData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuditData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuditData) ProtoMessage() {}

func (x *AuditData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuditData.ProtoReflect.Descriptor instead.
func (*AuditData) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{0}
}

func (m *AuditData) GetRequest() isAuditData_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (x *AuditData) GetTableInsertRequest() *TableInsertRequest {
	if x, ok := x.GetRequest().(*AuditData_TableInsertRequest); ok {
		return x.TableInsertRequest
	}
	return nil
}

func (x *AuditData) GetTableUpdateRequest() *TableUpdateRequest {
	if x, ok := x.GetRequest().(*AuditData_TableUpdateRequest); ok {
		return x.TableUpdateRequest
	}
	return nil
}

func (x *AuditData) GetDatasetListRequest() *DatasetListRequest {
	if x, ok := x.GetRequest().(*AuditData_DatasetListRequest); ok {
		return x.DatasetListRequest
	}
	return nil
}

func (x *AuditData) GetDatasetInsertRequest() *DatasetInsertRequest {
	if x, ok := x.GetRequest().(*AuditData_DatasetInsertRequest); ok {
		return x.DatasetInsertRequest
	}
	return nil
}

func (x *AuditData) GetDatasetUpdateRequest() *DatasetUpdateRequest {
	if x, ok := x.GetRequest().(*AuditData_DatasetUpdateRequest); ok {
		return x.DatasetUpdateRequest
	}
	return nil
}

func (x *AuditData) GetJobInsertRequest() *JobInsertRequest {
	if x, ok := x.GetRequest().(*AuditData_JobInsertRequest); ok {
		return x.JobInsertRequest
	}
	return nil
}

func (x *AuditData) GetJobQueryRequest() *JobQueryRequest {
	if x, ok := x.GetRequest().(*AuditData_JobQueryRequest); ok {
		return x.JobQueryRequest
	}
	return nil
}

func (x *AuditData) GetJobGetQueryResultsRequest() *JobGetQueryResultsRequest {
	if x, ok := x.GetRequest().(*AuditData_JobGetQueryResultsRequest); ok {
		return x.JobGetQueryResultsRequest
	}
	return nil
}

func (x *AuditData) GetTableDataListRequest() *TableDataListRequest {
	if x, ok := x.GetRequest().(*AuditData_TableDataListRequest); ok {
		return x.TableDataListRequest
	}
	return nil
}

func (m *AuditData) GetResponse() isAuditData_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (x *AuditData) GetTableInsertResponse() *TableInsertResponse {
	if x, ok := x.GetResponse().(*AuditData_TableInsertResponse); ok {
		return x.TableInsertResponse
	}
	return nil
}

func (x *AuditData) GetTableUpdateResponse() *TableUpdateResponse {
	if x, ok := x.GetResponse().(*AuditData_TableUpdateResponse); ok {
		return x.TableUpdateResponse
	}
	return nil
}

func (x *AuditData) GetDatasetInsertResponse() *DatasetInsertResponse {
	if x, ok := x.GetResponse().(*AuditData_DatasetInsertResponse); ok {
		return x.DatasetInsertResponse
	}
	return nil
}

func (x *AuditData) GetDatasetUpdateResponse() *DatasetUpdateResponse {
	if x, ok := x.GetResponse().(*AuditData_DatasetUpdateResponse); ok {
		return x.DatasetUpdateResponse
	}
	return nil
}

func (x *AuditData) GetJobInsertResponse() *JobInsertResponse {
	if x, ok := x.GetResponse().(*AuditData_JobInsertResponse); ok {
		return x.JobInsertResponse
	}
	return nil
}

func (x *AuditData) GetJobQueryResponse() *JobQueryResponse {
	if x, ok := x.GetResponse().(*AuditData_JobQueryResponse); ok {
		return x.JobQueryResponse
	}
	return nil
}

func (x *AuditData) GetJobGetQueryResultsResponse() *JobGetQueryResultsResponse {
	if x, ok := x.GetResponse().(*AuditData_JobGetQueryResultsResponse); ok {
		return x.JobGetQueryResultsResponse
	}
	return nil
}

func (x *AuditData) GetJobQueryDoneResponse() *JobQueryDoneResponse {
	if x, ok := x.GetResponse().(*AuditData_JobQueryDoneResponse); ok {
		return x.JobQueryDoneResponse
	}
	return nil
}

func (x *AuditData) GetJobCompletedEvent() *JobCompletedEvent {
	if x != nil {
		return x.JobCompletedEvent
	}
	return nil
}

type isAuditData_Request interface {
	isAuditData_Request()
}

type AuditData_TableInsertRequest struct {
	// Table insert request.
	TableInsertRequest *TableInsertRequest `protobuf:"bytes,1,opt,name=table_insert_request,json=tableInsertRequest,proto3,oneof"`
}

type AuditData_TableUpdateRequest struct {
	// Table update request.
	TableUpdateRequest *TableUpdateRequest `protobuf:"bytes,16,opt,name=table_update_request,json=tableUpdateRequest,proto3,oneof"`
}

type AuditData_DatasetListRequest struct {
	// Dataset list request.
	DatasetListRequest *DatasetListRequest `protobuf:"bytes,2,opt,name=dataset_list_request,json=datasetListRequest,proto3,oneof"`
}

type AuditData_DatasetInsertRequest struct {
	// Dataset insert request.
	DatasetInsertRequest *DatasetInsertRequest `protobuf:"bytes,3,opt,name=dataset_insert_request,json=datasetInsertRequest,proto3,oneof"`
}

type AuditData_DatasetUpdateRequest struct {
	// Dataset update request.
	DatasetUpdateRequest *DatasetUpdateRequest `protobuf:"bytes,4,opt,name=dataset_update_request,json=datasetUpdateRequest,proto3,oneof"`
}

type AuditData_JobInsertRequest struct {
	// Job insert request.
	JobInsertRequest *JobInsertRequest `protobuf:"bytes,5,opt,name=job_insert_request,json=jobInsertRequest,proto3,oneof"`
}

type AuditData_JobQueryRequest struct {
	// Job query request.
	JobQueryRequest *JobQueryRequest `protobuf:"bytes,6,opt,name=job_query_request,json=jobQueryRequest,proto3,oneof"`
}

type AuditData_JobGetQueryResultsRequest struct {
	// Job get query results request.
	JobGetQueryResultsRequest *JobGetQueryResultsRequest `protobuf:"bytes,7,opt,name=job_get_query_results_request,json=jobGetQueryResultsRequest,proto3,oneof"`
}

type AuditData_TableDataListRequest struct {
	// Table data-list request.
	TableDataListRequest *TableDataListRequest `protobuf:"bytes,8,opt,name=table_data_list_request,json=tableDataListRequest,proto3,oneof"`
}

func (*AuditData_TableInsertRequest) isAuditData_Request() {}

func (*AuditData_TableUpdateRequest) isAuditData_Request() {}

func (*AuditData_DatasetListRequest) isAuditData_Request() {}

func (*AuditData_DatasetInsertRequest) isAuditData_Request() {}

func (*AuditData_DatasetUpdateRequest) isAuditData_Request() {}

func (*AuditData_JobInsertRequest) isAuditData_Request() {}

func (*AuditData_JobQueryRequest) isAuditData_Request() {}

func (*AuditData_JobGetQueryResultsRequest) isAuditData_Request() {}

func (*AuditData_TableDataListRequest) isAuditData_Request() {}

type isAuditData_Response interface {
	isAuditData_Response()
}

type AuditData_TableInsertResponse struct {
	// Table insert response.
	TableInsertResponse *TableInsertResponse `protobuf:"bytes,9,opt,name=table_insert_response,json=tableInsertResponse,proto3,oneof"`
}

type AuditData_TableUpdateResponse struct {
	// Table update response.
	TableUpdateResponse *TableUpdateResponse `protobuf:"bytes,10,opt,name=table_update_response,json=tableUpdateResponse,proto3,oneof"`
}

type AuditData_DatasetInsertResponse struct {
	// Dataset insert response.
	DatasetInsertResponse *DatasetInsertResponse `protobuf:"bytes,11,opt,name=dataset_insert_response,json=datasetInsertResponse,proto3,oneof"`
}

type AuditData_DatasetUpdateResponse struct {
	// Dataset update response.
	DatasetUpdateResponse *DatasetUpdateResponse `protobuf:"bytes,12,opt,name=dataset_update_response,json=datasetUpdateResponse,proto3,oneof"`
}

type AuditData_JobInsertResponse struct {
	// Job insert response.
	JobInsertResponse *JobInsertResponse `protobuf:"bytes,18,opt,name=job_insert_response,json=jobInsertResponse,proto3,oneof"`
}

type AuditData_JobQueryResponse struct {
	// Job query response.
	JobQueryResponse *JobQueryResponse `protobuf:"bytes,13,opt,name=job_query_response,json=jobQueryResponse,proto3,oneof"`
}

type AuditData_JobGetQueryResultsResponse struct {
	// Job get query results response.
	JobGetQueryResultsResponse *JobGetQueryResultsResponse `protobuf:"bytes,14,opt,name=job_get_query_results_response,json=jobGetQueryResultsResponse,proto3,oneof"`
}

type AuditData_JobQueryDoneResponse struct {
	// Deprecated: Job query-done response. Use this information for usage
	// analysis.
	JobQueryDoneResponse *JobQueryDoneResponse `protobuf:"bytes,15,opt,name=job_query_done_response,json=jobQueryDoneResponse,proto3,oneof"`
}

func (*AuditData_TableInsertResponse) isAuditData_Response() {}

func (*AuditData_TableUpdateResponse) isAuditData_Response() {}

func (*AuditData_DatasetInsertResponse) isAuditData_Response() {}

func (*AuditData_DatasetUpdateResponse) isAuditData_Response() {}

func (*AuditData_JobInsertResponse) isAuditData_Response() {}

func (*AuditData_JobQueryResponse) isAuditData_Response() {}

func (*AuditData_JobGetQueryResultsResponse) isAuditData_Response() {}

func (*AuditData_JobQueryDoneResponse) isAuditData_Response() {}

// Table insert request.
type TableInsertRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The new table.
	Resource *Table `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *TableInsertRequest) Reset() {
	*x = TableInsertRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableInsertRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableInsertRequest) ProtoMessage() {}

func (x *TableInsertRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableInsertRequest.ProtoReflect.Descriptor instead.
func (*TableInsertRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{1}
}

func (x *TableInsertRequest) GetResource() *Table {
	if x != nil {
		return x.Resource
	}
	return nil
}

// Table update request.
type TableUpdateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The table to be updated.
	Resource *Table `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *TableUpdateRequest) Reset() {
	*x = TableUpdateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableUpdateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableUpdateRequest) ProtoMessage() {}

func (x *TableUpdateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableUpdateRequest.ProtoReflect.Descriptor instead.
func (*TableUpdateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{2}
}

func (x *TableUpdateRequest) GetResource() *Table {
	if x != nil {
		return x.Resource
	}
	return nil
}

// Table insert response.
type TableInsertResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Final state of the inserted table.
	Resource *Table `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *TableInsertResponse) Reset() {
	*x = TableInsertResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableInsertResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableInsertResponse) ProtoMessage() {}

func (x *TableInsertResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableInsertResponse.ProtoReflect.Descriptor instead.
func (*TableInsertResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{3}
}

func (x *TableInsertResponse) GetResource() *Table {
	if x != nil {
		return x.Resource
	}
	return nil
}

// Table update response.
type TableUpdateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Final state of the updated table.
	Resource *Table `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *TableUpdateResponse) Reset() {
	*x = TableUpdateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableUpdateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableUpdateResponse) ProtoMessage() {}

func (x *TableUpdateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableUpdateResponse.ProtoReflect.Descriptor instead.
func (*TableUpdateResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{4}
}

func (x *TableUpdateResponse) GetResource() *Table {
	if x != nil {
		return x.Resource
	}
	return nil
}

// Dataset list request.
type DatasetListRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to list all datasets, including hidden ones.
	ListAll bool `protobuf:"varint,1,opt,name=list_all,json=listAll,proto3" json:"list_all,omitempty"`
}

func (x *DatasetListRequest) Reset() {
	*x = DatasetListRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatasetListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatasetListRequest) ProtoMessage() {}

func (x *DatasetListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatasetListRequest.ProtoReflect.Descriptor instead.
func (*DatasetListRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{5}
}

func (x *DatasetListRequest) GetListAll() bool {
	if x != nil {
		return x.ListAll
	}
	return false
}

// Dataset insert request.
type DatasetInsertRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The dataset to be inserted.
	Resource *Dataset `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *DatasetInsertRequest) Reset() {
	*x = DatasetInsertRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatasetInsertRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatasetInsertRequest) ProtoMessage() {}

func (x *DatasetInsertRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatasetInsertRequest.ProtoReflect.Descriptor instead.
func (*DatasetInsertRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{6}
}

func (x *DatasetInsertRequest) GetResource() *Dataset {
	if x != nil {
		return x.Resource
	}
	return nil
}

// Dataset insert response.
type DatasetInsertResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Final state of the inserted dataset.
	Resource *Dataset `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *DatasetInsertResponse) Reset() {
	*x = DatasetInsertResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatasetInsertResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatasetInsertResponse) ProtoMessage() {}

func (x *DatasetInsertResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatasetInsertResponse.ProtoReflect.Descriptor instead.
func (*DatasetInsertResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{7}
}

func (x *DatasetInsertResponse) GetResource() *Dataset {
	if x != nil {
		return x.Resource
	}
	return nil
}

// Dataset update request.
type DatasetUpdateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The dataset to be updated.
	Resource *Dataset `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *DatasetUpdateRequest) Reset() {
	*x = DatasetUpdateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatasetUpdateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatasetUpdateRequest) ProtoMessage() {}

func (x *DatasetUpdateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatasetUpdateRequest.ProtoReflect.Descriptor instead.
func (*DatasetUpdateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{8}
}

func (x *DatasetUpdateRequest) GetResource() *Dataset {
	if x != nil {
		return x.Resource
	}
	return nil
}

// Dataset update response.
type DatasetUpdateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Final state of the updated dataset.
	Resource *Dataset `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *DatasetUpdateResponse) Reset() {
	*x = DatasetUpdateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatasetUpdateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatasetUpdateResponse) ProtoMessage() {}

func (x *DatasetUpdateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatasetUpdateResponse.ProtoReflect.Descriptor instead.
func (*DatasetUpdateResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{9}
}

func (x *DatasetUpdateResponse) GetResource() *Dataset {
	if x != nil {
		return x.Resource
	}
	return nil
}

// Job insert request.
type JobInsertRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Job insert request.
	Resource *Job `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *JobInsertRequest) Reset() {
	*x = JobInsertRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobInsertRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobInsertRequest) ProtoMessage() {}

func (x *JobInsertRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobInsertRequest.ProtoReflect.Descriptor instead.
func (*JobInsertRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{10}
}

func (x *JobInsertRequest) GetResource() *Job {
	if x != nil {
		return x.Resource
	}
	return nil
}

// Job insert response.
type JobInsertResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Job insert response.
	Resource *Job `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *JobInsertResponse) Reset() {
	*x = JobInsertResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobInsertResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobInsertResponse) ProtoMessage() {}

func (x *JobInsertResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobInsertResponse.ProtoReflect.Descriptor instead.
func (*JobInsertResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{11}
}

func (x *JobInsertResponse) GetResource() *Job {
	if x != nil {
		return x.Resource
	}
	return nil
}

// Job query request.
type JobQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The query.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// The maximum number of results.
	MaxResults uint32 `protobuf:"varint,2,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// The default dataset for tables that do not have a dataset specified.
	DefaultDataset *DatasetName `protobuf:"bytes,3,opt,name=default_dataset,json=defaultDataset,proto3" json:"default_dataset,omitempty"`
	// Project that the query should be charged to.
	ProjectId string `protobuf:"bytes,4,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// If true, don't actually run the job. Just check that it would run.
	DryRun bool `protobuf:"varint,5,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
}

func (x *JobQueryRequest) Reset() {
	*x = JobQueryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobQueryRequest) ProtoMessage() {}

func (x *JobQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobQueryRequest.ProtoReflect.Descriptor instead.
func (*JobQueryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{12}
}

func (x *JobQueryRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *JobQueryRequest) GetMaxResults() uint32 {
	if x != nil {
		return x.MaxResults
	}
	return 0
}

func (x *JobQueryRequest) GetDefaultDataset() *DatasetName {
	if x != nil {
		return x.DefaultDataset
	}
	return nil
}

func (x *JobQueryRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *JobQueryRequest) GetDryRun() bool {
	if x != nil {
		return x.DryRun
	}
	return false
}

// Job query response.
type JobQueryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The total number of rows in the full query result set.
	TotalResults uint64 `protobuf:"varint,1,opt,name=total_results,json=totalResults,proto3" json:"total_results,omitempty"`
	// Information about the queried job.
	Job *Job `protobuf:"bytes,2,opt,name=job,proto3" json:"job,omitempty"`
}

func (x *JobQueryResponse) Reset() {
	*x = JobQueryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobQueryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobQueryResponse) ProtoMessage() {}

func (x *JobQueryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobQueryResponse.ProtoReflect.Descriptor instead.
func (*JobQueryResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{13}
}

func (x *JobQueryResponse) GetTotalResults() uint64 {
	if x != nil {
		return x.TotalResults
	}
	return 0
}

func (x *JobQueryResponse) GetJob() *Job {
	if x != nil {
		return x.Job
	}
	return nil
}

// Job getQueryResults request.
type JobGetQueryResultsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Maximum number of results to return.
	MaxResults uint32 `protobuf:"varint,1,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// Zero-based row number at which to start.
	StartRow uint64 `protobuf:"varint,2,opt,name=start_row,json=startRow,proto3" json:"start_row,omitempty"`
}

func (x *JobGetQueryResultsRequest) Reset() {
	*x = JobGetQueryResultsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobGetQueryResultsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobGetQueryResultsRequest) ProtoMessage() {}

func (x *JobGetQueryResultsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobGetQueryResultsRequest.ProtoReflect.Descriptor instead.
func (*JobGetQueryResultsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{14}
}

func (x *JobGetQueryResultsRequest) GetMaxResults() uint32 {
	if x != nil {
		return x.MaxResults
	}
	return 0
}

func (x *JobGetQueryResultsRequest) GetStartRow() uint64 {
	if x != nil {
		return x.StartRow
	}
	return 0
}

// Job getQueryResults response.
type JobGetQueryResultsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total number of results in query results.
	TotalResults uint64 `protobuf:"varint,1,opt,name=total_results,json=totalResults,proto3" json:"total_results,omitempty"`
	// The job that was created to run the query.
	// It completed if `job.status.state` is `DONE`.
	// It failed if `job.status.errorResult` is also present.
	Job *Job `protobuf:"bytes,2,opt,name=job,proto3" json:"job,omitempty"`
}

func (x *JobGetQueryResultsResponse) Reset() {
	*x = JobGetQueryResultsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobGetQueryResultsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobGetQueryResultsResponse) ProtoMessage() {}

func (x *JobGetQueryResultsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobGetQueryResultsResponse.ProtoReflect.Descriptor instead.
func (*JobGetQueryResultsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{15}
}

func (x *JobGetQueryResultsResponse) GetTotalResults() uint64 {
	if x != nil {
		return x.TotalResults
	}
	return 0
}

func (x *JobGetQueryResultsResponse) GetJob() *Job {
	if x != nil {
		return x.Job
	}
	return nil
}

// Job getQueryDone response.
type JobQueryDoneResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The job and status information.
	// The job completed if `job.status.state` is `DONE`.
	Job *Job `protobuf:"bytes,1,opt,name=job,proto3" json:"job,omitempty"`
}

func (x *JobQueryDoneResponse) Reset() {
	*x = JobQueryDoneResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobQueryDoneResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobQueryDoneResponse) ProtoMessage() {}

func (x *JobQueryDoneResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobQueryDoneResponse.ProtoReflect.Descriptor instead.
func (*JobQueryDoneResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{16}
}

func (x *JobQueryDoneResponse) GetJob() *Job {
	if x != nil {
		return x.Job
	}
	return nil
}

// Query job completed event.
type JobCompletedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the event.
	EventName string `protobuf:"bytes,1,opt,name=event_name,json=eventName,proto3" json:"event_name,omitempty"`
	// Job information.
	Job *Job `protobuf:"bytes,2,opt,name=job,proto3" json:"job,omitempty"`
}

func (x *JobCompletedEvent) Reset() {
	*x = JobCompletedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobCompletedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobCompletedEvent) ProtoMessage() {}

func (x *JobCompletedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobCompletedEvent.ProtoReflect.Descriptor instead.
func (*JobCompletedEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{17}
}

func (x *JobCompletedEvent) GetEventName() string {
	if x != nil {
		return x.EventName
	}
	return ""
}

func (x *JobCompletedEvent) GetJob() *Job {
	if x != nil {
		return x.Job
	}
	return nil
}

// Table data-list request.
type TableDataListRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Starting row offset.
	StartRow uint64 `protobuf:"varint,1,opt,name=start_row,json=startRow,proto3" json:"start_row,omitempty"`
	// Maximum number of results to return.
	MaxResults uint32 `protobuf:"varint,2,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
}

func (x *TableDataListRequest) Reset() {
	*x = TableDataListRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableDataListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableDataListRequest) ProtoMessage() {}

func (x *TableDataListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableDataListRequest.ProtoReflect.Descriptor instead.
func (*TableDataListRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{18}
}

func (x *TableDataListRequest) GetStartRow() uint64 {
	if x != nil {
		return x.StartRow
	}
	return 0
}

func (x *TableDataListRequest) GetMaxResults() uint32 {
	if x != nil {
		return x.MaxResults
	}
	return 0
}

// Describes a BigQuery table.
// See the [Table](/bigquery/docs/reference/v2/tables) API resource
// for more details on individual fields.
// Note: `Table.schema` has been deprecated in favor of `Table.schemaJson`.
// `Table.schema` may continue to be present in your logs during this
// transition.
type Table struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the table.
	TableName *TableName `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// User-provided metadata for the table.
	Info *TableInfo `protobuf:"bytes,2,opt,name=info,proto3" json:"info,omitempty"`
	// A JSON representation of the table's schema.
	SchemaJson string `protobuf:"bytes,8,opt,name=schema_json,json=schemaJson,proto3" json:"schema_json,omitempty"`
	// If present, this is a virtual table defined by a SQL query.
	View *TableViewDefinition `protobuf:"bytes,4,opt,name=view,proto3" json:"view,omitempty"`
	// The expiration date for the table, after which the table
	// is deleted and the storage reclaimed.
	// If not present, the table persists indefinitely.
	ExpireTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// The time the table was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time the table was last truncated
	// by an operation with a `writeDisposition` of `WRITE_TRUNCATE`.
	TruncateTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=truncate_time,json=truncateTime,proto3" json:"truncate_time,omitempty"`
}

func (x *Table) Reset() {
	*x = Table{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Table) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Table) ProtoMessage() {}

func (x *Table) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Table.ProtoReflect.Descriptor instead.
func (*Table) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{19}
}

func (x *Table) GetTableName() *TableName {
	if x != nil {
		return x.TableName
	}
	return nil
}

func (x *Table) GetInfo() *TableInfo {
	if x != nil {
		return x.Info
	}
	return nil
}

func (x *Table) GetSchemaJson() string {
	if x != nil {
		return x.SchemaJson
	}
	return ""
}

func (x *Table) GetView() *TableViewDefinition {
	if x != nil {
		return x.View
	}
	return nil
}

func (x *Table) GetExpireTime() *timestamp.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *Table) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Table) GetTruncateTime() *timestamp.Timestamp {
	if x != nil {
		return x.TruncateTime
	}
	return nil
}

// User-provided metadata for a table.
type TableInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A short name for the table, such as`"Analytics Data - Jan 2011"`.
	FriendlyName string `protobuf:"bytes,1,opt,name=friendly_name,json=friendlyName,proto3" json:"friendly_name,omitempty"`
	// A long description, perhaps several paragraphs,
	// describing the table contents in detail.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *TableInfo) Reset() {
	*x = TableInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableInfo) ProtoMessage() {}

func (x *TableInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableInfo.ProtoReflect.Descriptor instead.
func (*TableInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{20}
}

func (x *TableInfo) GetFriendlyName() string {
	if x != nil {
		return x.FriendlyName
	}
	return ""
}

func (x *TableInfo) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Describes a virtual table defined by a SQL query.
type TableViewDefinition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// SQL query defining the view.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
}

func (x *TableViewDefinition) Reset() {
	*x = TableViewDefinition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableViewDefinition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableViewDefinition) ProtoMessage() {}

func (x *TableViewDefinition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableViewDefinition.ProtoReflect.Descriptor instead.
func (*TableViewDefinition) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{21}
}

func (x *TableViewDefinition) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

// BigQuery dataset information.
// See the [Dataset](/bigquery/docs/reference/v2/datasets) API resource
// for more details on individual fields.
type Dataset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the dataset.
	DatasetName *DatasetName `protobuf:"bytes,1,opt,name=dataset_name,json=datasetName,proto3" json:"dataset_name,omitempty"`
	// User-provided metadata for the dataset.
	Info *DatasetInfo `protobuf:"bytes,2,opt,name=info,proto3" json:"info,omitempty"`
	// The time the dataset was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time the dataset was last modified.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The access control list for the dataset.
	Acl *BigQueryAcl `protobuf:"bytes,6,opt,name=acl,proto3" json:"acl,omitempty"`
	// If this field is present, each table that does not specify an
	// expiration time is assigned an expiration time by adding this
	// duration to the table's `createTime`.  If this field is empty,
	// there is no default table expiration time.
	DefaultTableExpireDuration *duration.Duration `protobuf:"bytes,8,opt,name=default_table_expire_duration,json=defaultTableExpireDuration,proto3" json:"default_table_expire_duration,omitempty"`
}

func (x *Dataset) Reset() {
	*x = Dataset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Dataset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dataset) ProtoMessage() {}

func (x *Dataset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dataset.ProtoReflect.Descriptor instead.
func (*Dataset) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{22}
}

func (x *Dataset) GetDatasetName() *DatasetName {
	if x != nil {
		return x.DatasetName
	}
	return nil
}

func (x *Dataset) GetInfo() *DatasetInfo {
	if x != nil {
		return x.Info
	}
	return nil
}

func (x *Dataset) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Dataset) GetUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Dataset) GetAcl() *BigQueryAcl {
	if x != nil {
		return x.Acl
	}
	return nil
}

func (x *Dataset) GetDefaultTableExpireDuration() *duration.Duration {
	if x != nil {
		return x.DefaultTableExpireDuration
	}
	return nil
}

// User-provided metadata for a dataset.
type DatasetInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A short name for the dataset, such as`"Analytics Data 2011"`.
	FriendlyName string `protobuf:"bytes,1,opt,name=friendly_name,json=friendlyName,proto3" json:"friendly_name,omitempty"`
	// A long description, perhaps several paragraphs,
	// describing the dataset contents in detail.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *DatasetInfo) Reset() {
	*x = DatasetInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatasetInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatasetInfo) ProtoMessage() {}

func (x *DatasetInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatasetInfo.ProtoReflect.Descriptor instead.
func (*DatasetInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{23}
}

func (x *DatasetInfo) GetFriendlyName() string {
	if x != nil {
		return x.FriendlyName
	}
	return ""
}

func (x *DatasetInfo) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// An access control list.
type BigQueryAcl struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Access control entry list.
	Entries []*BigQueryAcl_Entry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *BigQueryAcl) Reset() {
	*x = BigQueryAcl{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAcl) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAcl) ProtoMessage() {}

func (x *BigQueryAcl) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAcl.ProtoReflect.Descriptor instead.
func (*BigQueryAcl) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{24}
}

func (x *BigQueryAcl) GetEntries() []*BigQueryAcl_Entry {
	if x != nil {
		return x.Entries
	}
	return nil
}

// Describes a job.
type Job struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Job name.
	JobName *JobName `protobuf:"bytes,1,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
	// Job configuration.
	JobConfiguration *JobConfiguration `protobuf:"bytes,2,opt,name=job_configuration,json=jobConfiguration,proto3" json:"job_configuration,omitempty"`
	// Job status.
	JobStatus *JobStatus `protobuf:"bytes,3,opt,name=job_status,json=jobStatus,proto3" json:"job_status,omitempty"`
	// Job statistics.
	JobStatistics *JobStatistics `protobuf:"bytes,4,opt,name=job_statistics,json=jobStatistics,proto3" json:"job_statistics,omitempty"`
}

func (x *Job) Reset() {
	*x = Job{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Job) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Job) ProtoMessage() {}

func (x *Job) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Job.ProtoReflect.Descriptor instead.
func (*Job) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{25}
}

func (x *Job) GetJobName() *JobName {
	if x != nil {
		return x.JobName
	}
	return nil
}

func (x *Job) GetJobConfiguration() *JobConfiguration {
	if x != nil {
		return x.JobConfiguration
	}
	return nil
}

func (x *Job) GetJobStatus() *JobStatus {
	if x != nil {
		return x.JobStatus
	}
	return nil
}

func (x *Job) GetJobStatistics() *JobStatistics {
	if x != nil {
		return x.JobStatistics
	}
	return nil
}

// Job configuration information.
// See the [Jobs](/bigquery/docs/reference/v2/jobs) API resource
// for more details on individual fields.
type JobConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Job configuration information.
	//
	// Types that are assignable to Configuration:
	//	*JobConfiguration_Query_
	//	*JobConfiguration_Load_
	//	*JobConfiguration_Extract_
	//	*JobConfiguration_TableCopy_
	Configuration isJobConfiguration_Configuration `protobuf_oneof:"configuration"`
	// If true, don't actually run the job. Just check that it would run.
	DryRun bool `protobuf:"varint,9,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
}

func (x *JobConfiguration) Reset() {
	*x = JobConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobConfiguration) ProtoMessage() {}

func (x *JobConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobConfiguration.ProtoReflect.Descriptor instead.
func (*JobConfiguration) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{26}
}

func (m *JobConfiguration) GetConfiguration() isJobConfiguration_Configuration {
	if m != nil {
		return m.Configuration
	}
	return nil
}

func (x *JobConfiguration) GetQuery() *JobConfiguration_Query {
	if x, ok := x.GetConfiguration().(*JobConfiguration_Query_); ok {
		return x.Query
	}
	return nil
}

func (x *JobConfiguration) GetLoad() *JobConfiguration_Load {
	if x, ok := x.GetConfiguration().(*JobConfiguration_Load_); ok {
		return x.Load
	}
	return nil
}

func (x *JobConfiguration) GetExtract() *JobConfiguration_Extract {
	if x, ok := x.GetConfiguration().(*JobConfiguration_Extract_); ok {
		return x.Extract
	}
	return nil
}

func (x *JobConfiguration) GetTableCopy() *JobConfiguration_TableCopy {
	if x, ok := x.GetConfiguration().(*JobConfiguration_TableCopy_); ok {
		return x.TableCopy
	}
	return nil
}

func (x *JobConfiguration) GetDryRun() bool {
	if x != nil {
		return x.DryRun
	}
	return false
}

type isJobConfiguration_Configuration interface {
	isJobConfiguration_Configuration()
}

type JobConfiguration_Query_ struct {
	// Query job information.
	Query *JobConfiguration_Query `protobuf:"bytes,5,opt,name=query,proto3,oneof"`
}

type JobConfiguration_Load_ struct {
	// Load job information.
	Load *JobConfiguration_Load `protobuf:"bytes,6,opt,name=load,proto3,oneof"`
}

type JobConfiguration_Extract_ struct {
	// Extract job information.
	Extract *JobConfiguration_Extract `protobuf:"bytes,7,opt,name=extract,proto3,oneof"`
}

type JobConfiguration_TableCopy_ struct {
	// TableCopy job information.
	TableCopy *JobConfiguration_TableCopy `protobuf:"bytes,8,opt,name=table_copy,json=tableCopy,proto3,oneof"`
}

func (*JobConfiguration_Query_) isJobConfiguration_Configuration() {}

func (*JobConfiguration_Load_) isJobConfiguration_Configuration() {}

func (*JobConfiguration_Extract_) isJobConfiguration_Configuration() {}

func (*JobConfiguration_TableCopy_) isJobConfiguration_Configuration() {}

// Describes an external data source used in a query.
type TableDefinition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the table, used in queries.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Google Cloud Storage URIs for the data to be imported.
	SourceUris []string `protobuf:"bytes,2,rep,name=source_uris,json=sourceUris,proto3" json:"source_uris,omitempty"`
}

func (x *TableDefinition) Reset() {
	*x = TableDefinition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableDefinition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableDefinition) ProtoMessage() {}

func (x *TableDefinition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableDefinition.ProtoReflect.Descriptor instead.
func (*TableDefinition) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{27}
}

func (x *TableDefinition) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TableDefinition) GetSourceUris() []string {
	if x != nil {
		return x.SourceUris
	}
	return nil
}

// Running state of a job.
type JobStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// State of a job: `PENDING`, `RUNNING`, or `DONE`.
	State string `protobuf:"bytes,1,opt,name=state,proto3" json:"state,omitempty"`
	// If the job did not complete successfully, this field describes why.
	Error *status.Status `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *JobStatus) Reset() {
	*x = JobStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobStatus) ProtoMessage() {}

func (x *JobStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobStatus.ProtoReflect.Descriptor instead.
func (*JobStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{28}
}

func (x *JobStatus) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

func (x *JobStatus) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// Job statistics that may change after a job starts.
type JobStatistics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time when the job was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Time when the job started.
	StartTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time when the job ended.
	EndTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Total bytes processed for a job.
	TotalProcessedBytes int64 `protobuf:"varint,4,opt,name=total_processed_bytes,json=totalProcessedBytes,proto3" json:"total_processed_bytes,omitempty"`
	// Processed bytes, adjusted by the job's CPU usage.
	TotalBilledBytes int64 `protobuf:"varint,5,opt,name=total_billed_bytes,json=totalBilledBytes,proto3" json:"total_billed_bytes,omitempty"`
	// The tier assigned by CPU-based billing.
	BillingTier int32 `protobuf:"varint,7,opt,name=billing_tier,json=billingTier,proto3" json:"billing_tier,omitempty"`
}

func (x *JobStatistics) Reset() {
	*x = JobStatistics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobStatistics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobStatistics) ProtoMessage() {}

func (x *JobStatistics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobStatistics.ProtoReflect.Descriptor instead.
func (*JobStatistics) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{29}
}

func (x *JobStatistics) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *JobStatistics) GetStartTime() *timestamp.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *JobStatistics) GetEndTime() *timestamp.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *JobStatistics) GetTotalProcessedBytes() int64 {
	if x != nil {
		return x.TotalProcessedBytes
	}
	return 0
}

func (x *JobStatistics) GetTotalBilledBytes() int64 {
	if x != nil {
		return x.TotalBilledBytes
	}
	return 0
}

func (x *JobStatistics) GetBillingTier() int32 {
	if x != nil {
		return x.BillingTier
	}
	return 0
}

// The fully-qualified name for a dataset.
type DatasetName struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The project ID.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The dataset ID within the project.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
}

func (x *DatasetName) Reset() {
	*x = DatasetName{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatasetName) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatasetName) ProtoMessage() {}

func (x *DatasetName) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatasetName.ProtoReflect.Descriptor instead.
func (*DatasetName) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{30}
}

func (x *DatasetName) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *DatasetName) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

// The fully-qualified name for a table.
type TableName struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The project ID.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The dataset ID within the project.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// The table ID of the table within the dataset.
	TableId string `protobuf:"bytes,3,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
}

func (x *TableName) Reset() {
	*x = TableName{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableName) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableName) ProtoMessage() {}

func (x *TableName) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableName.ProtoReflect.Descriptor instead.
func (*TableName) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{31}
}

func (x *TableName) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *TableName) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *TableName) GetTableId() string {
	if x != nil {
		return x.TableId
	}
	return ""
}

// The fully-qualified name for a job.
type JobName struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The project ID.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The job ID within the project.
	JobId string `protobuf:"bytes,2,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
}

func (x *JobName) Reset() {
	*x = JobName{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobName) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobName) ProtoMessage() {}

func (x *JobName) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobName.ProtoReflect.Descriptor instead.
func (*JobName) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{32}
}

func (x *JobName) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *JobName) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

// Access control entry.
type BigQueryAcl_Entry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The granted role, which can be `READER`, `WRITER`, or `OWNER`.
	Role string `protobuf:"bytes,1,opt,name=role,proto3" json:"role,omitempty"`
	// Grants access to a group identified by an email address.
	GroupEmail string `protobuf:"bytes,2,opt,name=group_email,json=groupEmail,proto3" json:"group_email,omitempty"`
	// Grants access to a user identified by an email address.
	UserEmail string `protobuf:"bytes,3,opt,name=user_email,json=userEmail,proto3" json:"user_email,omitempty"`
	// Grants access to all members of a domain.
	Domain string `protobuf:"bytes,4,opt,name=domain,proto3" json:"domain,omitempty"`
	// Grants access to special groups. Valid groups are `PROJECT_OWNERS`,
	// `PROJECT_READERS`, `PROJECT_WRITERS` and `ALL_AUTHENTICATED_USERS`.
	SpecialGroup string `protobuf:"bytes,5,opt,name=special_group,json=specialGroup,proto3" json:"special_group,omitempty"`
	// Grants access to a BigQuery View.
	ViewName *TableName `protobuf:"bytes,6,opt,name=view_name,json=viewName,proto3" json:"view_name,omitempty"`
}

func (x *BigQueryAcl_Entry) Reset() {
	*x = BigQueryAcl_Entry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryAcl_Entry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryAcl_Entry) ProtoMessage() {}

func (x *BigQueryAcl_Entry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryAcl_Entry.ProtoReflect.Descriptor instead.
func (*BigQueryAcl_Entry) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{24, 0}
}

func (x *BigQueryAcl_Entry) GetRole() string {
	if x != nil {
		return x.Role
	}
	return ""
}

func (x *BigQueryAcl_Entry) GetGroupEmail() string {
	if x != nil {
		return x.GroupEmail
	}
	return ""
}

func (x *BigQueryAcl_Entry) GetUserEmail() string {
	if x != nil {
		return x.UserEmail
	}
	return ""
}

func (x *BigQueryAcl_Entry) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

func (x *BigQueryAcl_Entry) GetSpecialGroup() string {
	if x != nil {
		return x.SpecialGroup
	}
	return ""
}

func (x *BigQueryAcl_Entry) GetViewName() *TableName {
	if x != nil {
		return x.ViewName
	}
	return nil
}

// Describes a query job, which executes a SQL-like query.
type JobConfiguration_Query struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SQL query to run.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// The table where results are written.
	DestinationTable *TableName `protobuf:"bytes,2,opt,name=destination_table,json=destinationTable,proto3" json:"destination_table,omitempty"`
	// Describes when a job is allowed to create a table:
	// `CREATE_IF_NEEDED`, `CREATE_NEVER`.
	CreateDisposition string `protobuf:"bytes,3,opt,name=create_disposition,json=createDisposition,proto3" json:"create_disposition,omitempty"`
	// Describes how writes affect existing tables:
	// `WRITE_TRUNCATE`, `WRITE_APPEND`, `WRITE_EMPTY`.
	WriteDisposition string `protobuf:"bytes,4,opt,name=write_disposition,json=writeDisposition,proto3" json:"write_disposition,omitempty"`
	// If a table name is specified without a dataset in a query,
	// this dataset will be added to table name.
	DefaultDataset *DatasetName `protobuf:"bytes,5,opt,name=default_dataset,json=defaultDataset,proto3" json:"default_dataset,omitempty"`
	// Describes data sources outside BigQuery, if needed.
	TableDefinitions []*TableDefinition `protobuf:"bytes,6,rep,name=table_definitions,json=tableDefinitions,proto3" json:"table_definitions,omitempty"`
}

func (x *JobConfiguration_Query) Reset() {
	*x = JobConfiguration_Query{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobConfiguration_Query) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobConfiguration_Query) ProtoMessage() {}

func (x *JobConfiguration_Query) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobConfiguration_Query.ProtoReflect.Descriptor instead.
func (*JobConfiguration_Query) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{26, 0}
}

func (x *JobConfiguration_Query) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *JobConfiguration_Query) GetDestinationTable() *TableName {
	if x != nil {
		return x.DestinationTable
	}
	return nil
}

func (x *JobConfiguration_Query) GetCreateDisposition() string {
	if x != nil {
		return x.CreateDisposition
	}
	return ""
}

func (x *JobConfiguration_Query) GetWriteDisposition() string {
	if x != nil {
		return x.WriteDisposition
	}
	return ""
}

func (x *JobConfiguration_Query) GetDefaultDataset() *DatasetName {
	if x != nil {
		return x.DefaultDataset
	}
	return nil
}

func (x *JobConfiguration_Query) GetTableDefinitions() []*TableDefinition {
	if x != nil {
		return x.TableDefinitions
	}
	return nil
}

// Describes a load job, which loads data from an external source via
// the  import pipeline.
type JobConfiguration_Load struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URIs for the data to be imported. Only Google Cloud Storage URIs are
	// supported.
	SourceUris []string `protobuf:"bytes,1,rep,name=source_uris,json=sourceUris,proto3" json:"source_uris,omitempty"`
	// The table schema in JSON format representation of a TableSchema.
	SchemaJson string `protobuf:"bytes,6,opt,name=schema_json,json=schemaJson,proto3" json:"schema_json,omitempty"`
	// The table where the imported data is written.
	DestinationTable *TableName `protobuf:"bytes,3,opt,name=destination_table,json=destinationTable,proto3" json:"destination_table,omitempty"`
	// Describes when a job is allowed to create a table:
	// `CREATE_IF_NEEDED`, `CREATE_NEVER`.
	CreateDisposition string `protobuf:"bytes,4,opt,name=create_disposition,json=createDisposition,proto3" json:"create_disposition,omitempty"`
	// Describes how writes affect existing tables:
	// `WRITE_TRUNCATE`, `WRITE_APPEND`, `WRITE_EMPTY`.
	WriteDisposition string `protobuf:"bytes,5,opt,name=write_disposition,json=writeDisposition,proto3" json:"write_disposition,omitempty"`
}

func (x *JobConfiguration_Load) Reset() {
	*x = JobConfiguration_Load{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobConfiguration_Load) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobConfiguration_Load) ProtoMessage() {}

func (x *JobConfiguration_Load) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobConfiguration_Load.ProtoReflect.Descriptor instead.
func (*JobConfiguration_Load) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{26, 1}
}

func (x *JobConfiguration_Load) GetSourceUris() []string {
	if x != nil {
		return x.SourceUris
	}
	return nil
}

func (x *JobConfiguration_Load) GetSchemaJson() string {
	if x != nil {
		return x.SchemaJson
	}
	return ""
}

func (x *JobConfiguration_Load) GetDestinationTable() *TableName {
	if x != nil {
		return x.DestinationTable
	}
	return nil
}

func (x *JobConfiguration_Load) GetCreateDisposition() string {
	if x != nil {
		return x.CreateDisposition
	}
	return ""
}

func (x *JobConfiguration_Load) GetWriteDisposition() string {
	if x != nil {
		return x.WriteDisposition
	}
	return ""
}

// Describes an extract job, which exports data to an external source
// via the  export pipeline.
type JobConfiguration_Extract struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Google Cloud Storage URIs where extracted data should be written.
	DestinationUris []string `protobuf:"bytes,1,rep,name=destination_uris,json=destinationUris,proto3" json:"destination_uris,omitempty"`
	// The source table.
	SourceTable *TableName `protobuf:"bytes,2,opt,name=source_table,json=sourceTable,proto3" json:"source_table,omitempty"`
}

func (x *JobConfiguration_Extract) Reset() {
	*x = JobConfiguration_Extract{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobConfiguration_Extract) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobConfiguration_Extract) ProtoMessage() {}

func (x *JobConfiguration_Extract) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobConfiguration_Extract.ProtoReflect.Descriptor instead.
func (*JobConfiguration_Extract) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{26, 2}
}

func (x *JobConfiguration_Extract) GetDestinationUris() []string {
	if x != nil {
		return x.DestinationUris
	}
	return nil
}

func (x *JobConfiguration_Extract) GetSourceTable() *TableName {
	if x != nil {
		return x.SourceTable
	}
	return nil
}

// Describes a copy job, which copies an existing table to another table.
type JobConfiguration_TableCopy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Source tables.
	SourceTables []*TableName `protobuf:"bytes,1,rep,name=source_tables,json=sourceTables,proto3" json:"source_tables,omitempty"`
	// Destination table.
	DestinationTable *TableName `protobuf:"bytes,2,opt,name=destination_table,json=destinationTable,proto3" json:"destination_table,omitempty"`
	// Describes when a job is allowed to create a table:
	// `CREATE_IF_NEEDED`, `CREATE_NEVER`.
	CreateDisposition string `protobuf:"bytes,3,opt,name=create_disposition,json=createDisposition,proto3" json:"create_disposition,omitempty"`
	// Describes how writes affect existing tables:
	// `WRITE_TRUNCATE`, `WRITE_APPEND`, `WRITE_EMPTY`.
	WriteDisposition string `protobuf:"bytes,4,opt,name=write_disposition,json=writeDisposition,proto3" json:"write_disposition,omitempty"`
}

func (x *JobConfiguration_TableCopy) Reset() {
	*x = JobConfiguration_TableCopy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobConfiguration_TableCopy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobConfiguration_TableCopy) ProtoMessage() {}

func (x *JobConfiguration_TableCopy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobConfiguration_TableCopy.ProtoReflect.Descriptor instead.
func (*JobConfiguration_TableCopy) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP(), []int{26, 3}
}

func (x *JobConfiguration_TableCopy) GetSourceTables() []*TableName {
	if x != nil {
		return x.SourceTables
	}
	return nil
}

func (x *JobConfiguration_TableCopy) GetDestinationTable() *TableName {
	if x != nil {
		return x.DestinationTable
	}
	return nil
}

func (x *JobConfiguration_TableCopy) GetCreateDisposition() string {
	if x != nil {
		return x.CreateDisposition
	}
	return ""
}

func (x *JobConfiguration_TableCopy) GetWriteDisposition() string {
	if x != nil {
		return x.WriteDisposition
	}
	return ""
}

var File_google_cloud_bigquery_logging_v1_audit_data_proto protoreflect.FileDescriptor

var file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f,
	0x76, 0x31, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63,
	0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xdd, 0x0f,
	0x0a, 0x09, 0x41, 0x75, 0x64, 0x69, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x68, 0x0a, 0x14, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48,
	0x00, 0x52, 0x12, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x68, 0x0a, 0x14, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x12, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x68, 0x0a, 0x14, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x5f,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x12, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6e, 0x0a, 0x16, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x48, 0x00, 0x52, 0x14, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x65,
	0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6e, 0x0a, 0x16, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x48, 0x00, 0x52, 0x14, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x62, 0x0a, 0x12, 0x6a, 0x6f, 0x62,
	0x5f, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x49, 0x6e, 0x73, 0x65,
	0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x10, 0x6a, 0x6f, 0x62,
	0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5f, 0x0a,
	0x11, 0x6a, 0x6f, 0x62, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0f, 0x6a,
	0x6f, 0x62, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x7f,
	0x0a, 0x1d, 0x6a, 0x6f, 0x62, 0x5f, 0x67, 0x65, 0x74, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x47, 0x65, 0x74, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x48, 0x00, 0x52, 0x19, 0x6a, 0x6f, 0x62, 0x47, 0x65, 0x74, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x6f, 0x0a, 0x17, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6c, 0x69,
	0x73, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x14, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x6b, 0x0a, 0x15, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74,
	0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x01, 0x52, 0x13, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x49,
	0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6b, 0x0a,
	0x15, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x48, 0x01, 0x52, 0x13, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x71, 0x0a, 0x17, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x5f, 0x72, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x48, 0x01, 0x52, 0x15, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49,
	0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x71, 0x0a,
	0x17, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x01, 0x52, 0x15, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x65, 0x0a, 0x13, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x5f, 0x72,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x4a, 0x6f, 0x62, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x48, 0x01, 0x52, 0x11, 0x6a, 0x6f, 0x62, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x62, 0x0a, 0x12, 0x6a, 0x6f, 0x62, 0x5f, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x01, 0x52, 0x10, 0x6a, 0x6f, 0x62, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x82, 0x01, 0x0a, 0x1e,
	0x6a, 0x6f, 0x62, 0x5f, 0x67, 0x65, 0x74, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x47, 0x65, 0x74, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x48, 0x01, 0x52, 0x1a, 0x6a, 0x6f, 0x62, 0x47, 0x65, 0x74, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x6f, 0x0a, 0x17, 0x6a, 0x6f, 0x62, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x6f,
	0x6e, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x6f, 0x6e,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x01, 0x52, 0x14, 0x6a, 0x6f, 0x62,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x6f, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x63, 0x0a, 0x13, 0x6a, 0x6f, 0x62, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74,
	0x65, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x52, 0x11, 0x6a, 0x6f, 0x62, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65,
	0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x42, 0x0a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x59, 0x0a,
	0x12, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x08,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x59, 0x0a, 0x12, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43,
	0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x22, 0x5a, 0x0a, 0x13, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x73, 0x65,
	0x72, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x43, 0x0a, 0x08, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22,
	0x5a, 0x0a, 0x13, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x43, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x2f, 0x0a, 0x12, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x19, 0x0a, 0x08, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x61, 0x6c, 0x6c, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x07, 0x6c, 0x69, 0x73, 0x74, 0x41, 0x6c, 0x6c, 0x22, 0x5d, 0x0a, 0x14,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x5e, 0x0a, 0x15, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x5d, 0x0a, 0x14, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x5e, 0x0a, 0x15, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x55, 0x0a, 0x10, 0x4a, 0x6f,
	0x62, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x22, 0x56, 0x0a, 0x11, 0x4a, 0x6f, 0x62, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x52,
	0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xd8, 0x01, 0x0a, 0x0f, 0x4a, 0x6f,
	0x62, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x14, 0x0a,
	0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x56, 0x0a, 0x0f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x0e, 0x64, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x64,
	0x72, 0x79, 0x5f, 0x72, 0x75, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x64, 0x72,
	0x79, 0x52, 0x75, 0x6e, 0x22, 0x70, 0x0a, 0x10, 0x4a, 0x6f, 0x62, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x0c, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x37, 0x0a,
	0x03, 0x6a, 0x6f, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f,
	0x62, 0x52, 0x03, 0x6a, 0x6f, 0x62, 0x22, 0x59, 0x0a, 0x19, 0x4a, 0x6f, 0x62, 0x47, 0x65, 0x74,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x72, 0x6f,
	0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x73, 0x74, 0x61, 0x72, 0x74, 0x52, 0x6f,
	0x77, 0x22, 0x7a, 0x0a, 0x1a, 0x4a, 0x6f, 0x62, 0x47, 0x65, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x23, 0x0a, 0x0d, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x37, 0x0a, 0x03, 0x6a, 0x6f, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x52, 0x03, 0x6a, 0x6f, 0x62, 0x22, 0x4f, 0x0a,
	0x14, 0x4a, 0x6f, 0x62, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x6f, 0x6e, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x03, 0x6a, 0x6f, 0x62, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x52, 0x03, 0x6a, 0x6f, 0x62, 0x22, 0x6b,
	0x0a, 0x11, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x37, 0x0a, 0x03, 0x6a, 0x6f, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x52, 0x03, 0x6a, 0x6f, 0x62, 0x22, 0x54, 0x0a, 0x14, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x72, 0x6f, 0x77,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x73, 0x74, 0x61, 0x72, 0x74, 0x52, 0x6f, 0x77,
	0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x22, 0xbb, 0x03, 0x0a, 0x05, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x4a, 0x0a, 0x0a, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x09, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x4a, 0x73, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x04, 0x76, 0x69, 0x65,
	0x77, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x56, 0x69, 0x65, 0x77, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04,
	0x76, 0x69, 0x65, 0x77, 0x12, 0x3b, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3f,
	0x0a, 0x0d, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0c, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22,
	0x52, 0x0a, 0x09, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x23, 0x0a, 0x0d,
	0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x6c, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x6c, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x2b, 0x0a, 0x13, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x56, 0x69, 0x65, 0x77,
	0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x22, 0xb7, 0x03, 0x0a, 0x07, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x50, 0x0a, 0x0c,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4e, 0x61, 0x6d,
	0x65, 0x52, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x41,
	0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x04, 0x69, 0x6e, 0x66,
	0x6f, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x03, 0x61,
	0x63, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x41, 0x63, 0x6c, 0x52, 0x03, 0x61, 0x63, 0x6c, 0x12, 0x5c, 0x0a, 0x1d,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x65, 0x78,
	0x70, 0x69, 0x72, 0x65, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1a,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x78, 0x70, 0x69,
	0x72, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x54, 0x0a, 0x0b, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x72, 0x69,
	0x65, 0x6e, 0x64, 0x6c, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x6c, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xc1, 0x02, 0x0a, 0x0b, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x63, 0x6c,
	0x12, 0x4d, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x63, 0x6c,
	0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x1a,
	0xe2, 0x01, 0x0a, 0x05, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6f, 0x6c,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x1f, 0x0a,
	0x0b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x1d,
	0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x16, 0x0a,
	0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x70,
	0x65, 0x63, 0x69, 0x61, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x48, 0x0a, 0x09, 0x76, 0x69,
	0x65, 0x77, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x08, 0x76, 0x69, 0x65, 0x77,
	0x4e, 0x61, 0x6d, 0x65, 0x22, 0xd0, 0x02, 0x0a, 0x03, 0x4a, 0x6f, 0x62, 0x12, 0x44, 0x0a, 0x08,
	0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x5f, 0x0a, 0x11, 0x6a, 0x6f, 0x62, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x10, 0x6a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x0a, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x09, 0x6a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x56, 0x0a, 0x0e, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74,
	0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x52, 0x0d, 0x6a, 0x6f, 0x62, 0x53, 0x74, 0x61,
	0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x22, 0xc0, 0x0b, 0x0a, 0x10, 0x4a, 0x6f, 0x62, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x05,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4a,
	0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x48, 0x00, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x4d,
	0x0a, 0x04, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x48, 0x00, 0x52, 0x04, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x56, 0x0a,
	0x07, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x48, 0x00, 0x52, 0x07, 0x65, 0x78,
	0x74, 0x72, 0x61, 0x63, 0x74, 0x12, 0x5d, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63,
	0x6f, 0x70, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x43, 0x6f, 0x70, 0x79, 0x48, 0x00, 0x52, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x43, 0x6f, 0x70, 0x79, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x72, 0x79, 0x5f, 0x72, 0x75, 0x6e, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x64, 0x72, 0x79, 0x52, 0x75, 0x6e, 0x1a, 0x8b, 0x03,
	0x0a, 0x05, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x58, 0x0a,
	0x11, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x10, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x11, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x0a, 0x11, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f,
	0x64, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x10, 0x77, 0x72, 0x69, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x0f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x0e, 0x64, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x5e, 0x0a, 0x11, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x44,
	0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xfe, 0x01, 0x0a, 0x04,
	0x4c, 0x6f, 0x61, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75,
	0x72, 0x69, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x55, 0x72, 0x69, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f,
	0x6a, 0x73, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x4a, 0x73, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x11, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x10,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x12, 0x2d, 0x0a, 0x12, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x2b, 0x0a, 0x11, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x84, 0x01, 0x0a,
	0x07, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55,
	0x72, 0x69, 0x73, 0x12, 0x4e, 0x0a, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x1a, 0x93, 0x02, 0x0a, 0x09, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x70,
	0x79, 0x12, 0x50, 0x0a, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x73, 0x12, 0x58, 0x0a, 0x11, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x52, 0x10, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x2d, 0x0a,
	0x12, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x0a, 0x11,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x77, 0x72, 0x69, 0x74, 0x65, 0x44, 0x69,
	0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0f, 0x0a, 0x0d, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x46, 0x0a, 0x0f, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x72,
	0x69, 0x73, 0x22, 0x4b, 0x0a, 0x09, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70,
	0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22,
	0xc3, 0x02, 0x0a, 0x0d, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63,
	0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x39,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x32, 0x0a, 0x15, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x13, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x42,
	0x79, 0x74, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x62, 0x69,
	0x6c, 0x6c, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x10, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x42, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x42, 0x79, 0x74,
	0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x69,
	0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e,
	0x67, 0x54, 0x69, 0x65, 0x72, 0x22, 0x4b, 0x0a, 0x0b, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x49, 0x64, 0x22, 0x64, 0x0a, 0x09, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1d,
	0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a,
	0x08, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x64, 0x22, 0x3f, 0x0a, 0x07, 0x4a, 0x6f, 0x62, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x49, 0x64, 0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x42, 0x81, 0x01, 0x0a, 0x24, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x42, 0x0e, 0x41, 0x75, 0x64, 0x69, 0x74, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x47, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c,
	0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x2f, 0x76, 0x31, 0x3b, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescOnce sync.Once
	file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescData = file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDesc
)

func file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescGZIP() []byte {
	file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescOnce.Do(func() {
		file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescData)
	})
	return file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDescData
}

var file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes = make([]protoimpl.MessageInfo, 38)
var file_google_cloud_bigquery_logging_v1_audit_data_proto_goTypes = []interface{}{
	(*AuditData)(nil),                  // 0: google.cloud.bigquery.logging.v1.AuditData
	(*TableInsertRequest)(nil),         // 1: google.cloud.bigquery.logging.v1.TableInsertRequest
	(*TableUpdateRequest)(nil),         // 2: google.cloud.bigquery.logging.v1.TableUpdateRequest
	(*TableInsertResponse)(nil),        // 3: google.cloud.bigquery.logging.v1.TableInsertResponse
	(*TableUpdateResponse)(nil),        // 4: google.cloud.bigquery.logging.v1.TableUpdateResponse
	(*DatasetListRequest)(nil),         // 5: google.cloud.bigquery.logging.v1.DatasetListRequest
	(*DatasetInsertRequest)(nil),       // 6: google.cloud.bigquery.logging.v1.DatasetInsertRequest
	(*DatasetInsertResponse)(nil),      // 7: google.cloud.bigquery.logging.v1.DatasetInsertResponse
	(*DatasetUpdateRequest)(nil),       // 8: google.cloud.bigquery.logging.v1.DatasetUpdateRequest
	(*DatasetUpdateResponse)(nil),      // 9: google.cloud.bigquery.logging.v1.DatasetUpdateResponse
	(*JobInsertRequest)(nil),           // 10: google.cloud.bigquery.logging.v1.JobInsertRequest
	(*JobInsertResponse)(nil),          // 11: google.cloud.bigquery.logging.v1.JobInsertResponse
	(*JobQueryRequest)(nil),            // 12: google.cloud.bigquery.logging.v1.JobQueryRequest
	(*JobQueryResponse)(nil),           // 13: google.cloud.bigquery.logging.v1.JobQueryResponse
	(*JobGetQueryResultsRequest)(nil),  // 14: google.cloud.bigquery.logging.v1.JobGetQueryResultsRequest
	(*JobGetQueryResultsResponse)(nil), // 15: google.cloud.bigquery.logging.v1.JobGetQueryResultsResponse
	(*JobQueryDoneResponse)(nil),       // 16: google.cloud.bigquery.logging.v1.JobQueryDoneResponse
	(*JobCompletedEvent)(nil),          // 17: google.cloud.bigquery.logging.v1.JobCompletedEvent
	(*TableDataListRequest)(nil),       // 18: google.cloud.bigquery.logging.v1.TableDataListRequest
	(*Table)(nil),                      // 19: google.cloud.bigquery.logging.v1.Table
	(*TableInfo)(nil),                  // 20: google.cloud.bigquery.logging.v1.TableInfo
	(*TableViewDefinition)(nil),        // 21: google.cloud.bigquery.logging.v1.TableViewDefinition
	(*Dataset)(nil),                    // 22: google.cloud.bigquery.logging.v1.Dataset
	(*DatasetInfo)(nil),                // 23: google.cloud.bigquery.logging.v1.DatasetInfo
	(*BigQueryAcl)(nil),                // 24: google.cloud.bigquery.logging.v1.BigQueryAcl
	(*Job)(nil),                        // 25: google.cloud.bigquery.logging.v1.Job
	(*JobConfiguration)(nil),           // 26: google.cloud.bigquery.logging.v1.JobConfiguration
	(*TableDefinition)(nil),            // 27: google.cloud.bigquery.logging.v1.TableDefinition
	(*JobStatus)(nil),                  // 28: google.cloud.bigquery.logging.v1.JobStatus
	(*JobStatistics)(nil),              // 29: google.cloud.bigquery.logging.v1.JobStatistics
	(*DatasetName)(nil),                // 30: google.cloud.bigquery.logging.v1.DatasetName
	(*TableName)(nil),                  // 31: google.cloud.bigquery.logging.v1.TableName
	(*JobName)(nil),                    // 32: google.cloud.bigquery.logging.v1.JobName
	(*BigQueryAcl_Entry)(nil),          // 33: google.cloud.bigquery.logging.v1.BigQueryAcl.Entry
	(*JobConfiguration_Query)(nil),     // 34: google.cloud.bigquery.logging.v1.JobConfiguration.Query
	(*JobConfiguration_Load)(nil),      // 35: google.cloud.bigquery.logging.v1.JobConfiguration.Load
	(*JobConfiguration_Extract)(nil),   // 36: google.cloud.bigquery.logging.v1.JobConfiguration.Extract
	(*JobConfiguration_TableCopy)(nil), // 37: google.cloud.bigquery.logging.v1.JobConfiguration.TableCopy
	(*timestamp.Timestamp)(nil),        // 38: google.protobuf.Timestamp
	(*duration.Duration)(nil),          // 39: google.protobuf.Duration
	(*status.Status)(nil),              // 40: google.rpc.Status
}
var file_google_cloud_bigquery_logging_v1_audit_data_proto_depIdxs = []int32{
	1,  // 0: google.cloud.bigquery.logging.v1.AuditData.table_insert_request:type_name -> google.cloud.bigquery.logging.v1.TableInsertRequest
	2,  // 1: google.cloud.bigquery.logging.v1.AuditData.table_update_request:type_name -> google.cloud.bigquery.logging.v1.TableUpdateRequest
	5,  // 2: google.cloud.bigquery.logging.v1.AuditData.dataset_list_request:type_name -> google.cloud.bigquery.logging.v1.DatasetListRequest
	6,  // 3: google.cloud.bigquery.logging.v1.AuditData.dataset_insert_request:type_name -> google.cloud.bigquery.logging.v1.DatasetInsertRequest
	8,  // 4: google.cloud.bigquery.logging.v1.AuditData.dataset_update_request:type_name -> google.cloud.bigquery.logging.v1.DatasetUpdateRequest
	10, // 5: google.cloud.bigquery.logging.v1.AuditData.job_insert_request:type_name -> google.cloud.bigquery.logging.v1.JobInsertRequest
	12, // 6: google.cloud.bigquery.logging.v1.AuditData.job_query_request:type_name -> google.cloud.bigquery.logging.v1.JobQueryRequest
	14, // 7: google.cloud.bigquery.logging.v1.AuditData.job_get_query_results_request:type_name -> google.cloud.bigquery.logging.v1.JobGetQueryResultsRequest
	18, // 8: google.cloud.bigquery.logging.v1.AuditData.table_data_list_request:type_name -> google.cloud.bigquery.logging.v1.TableDataListRequest
	3,  // 9: google.cloud.bigquery.logging.v1.AuditData.table_insert_response:type_name -> google.cloud.bigquery.logging.v1.TableInsertResponse
	4,  // 10: google.cloud.bigquery.logging.v1.AuditData.table_update_response:type_name -> google.cloud.bigquery.logging.v1.TableUpdateResponse
	7,  // 11: google.cloud.bigquery.logging.v1.AuditData.dataset_insert_response:type_name -> google.cloud.bigquery.logging.v1.DatasetInsertResponse
	9,  // 12: google.cloud.bigquery.logging.v1.AuditData.dataset_update_response:type_name -> google.cloud.bigquery.logging.v1.DatasetUpdateResponse
	11, // 13: google.cloud.bigquery.logging.v1.AuditData.job_insert_response:type_name -> google.cloud.bigquery.logging.v1.JobInsertResponse
	13, // 14: google.cloud.bigquery.logging.v1.AuditData.job_query_response:type_name -> google.cloud.bigquery.logging.v1.JobQueryResponse
	15, // 15: google.cloud.bigquery.logging.v1.AuditData.job_get_query_results_response:type_name -> google.cloud.bigquery.logging.v1.JobGetQueryResultsResponse
	16, // 16: google.cloud.bigquery.logging.v1.AuditData.job_query_done_response:type_name -> google.cloud.bigquery.logging.v1.JobQueryDoneResponse
	17, // 17: google.cloud.bigquery.logging.v1.AuditData.job_completed_event:type_name -> google.cloud.bigquery.logging.v1.JobCompletedEvent
	19, // 18: google.cloud.bigquery.logging.v1.TableInsertRequest.resource:type_name -> google.cloud.bigquery.logging.v1.Table
	19, // 19: google.cloud.bigquery.logging.v1.TableUpdateRequest.resource:type_name -> google.cloud.bigquery.logging.v1.Table
	19, // 20: google.cloud.bigquery.logging.v1.TableInsertResponse.resource:type_name -> google.cloud.bigquery.logging.v1.Table
	19, // 21: google.cloud.bigquery.logging.v1.TableUpdateResponse.resource:type_name -> google.cloud.bigquery.logging.v1.Table
	22, // 22: google.cloud.bigquery.logging.v1.DatasetInsertRequest.resource:type_name -> google.cloud.bigquery.logging.v1.Dataset
	22, // 23: google.cloud.bigquery.logging.v1.DatasetInsertResponse.resource:type_name -> google.cloud.bigquery.logging.v1.Dataset
	22, // 24: google.cloud.bigquery.logging.v1.DatasetUpdateRequest.resource:type_name -> google.cloud.bigquery.logging.v1.Dataset
	22, // 25: google.cloud.bigquery.logging.v1.DatasetUpdateResponse.resource:type_name -> google.cloud.bigquery.logging.v1.Dataset
	25, // 26: google.cloud.bigquery.logging.v1.JobInsertRequest.resource:type_name -> google.cloud.bigquery.logging.v1.Job
	25, // 27: google.cloud.bigquery.logging.v1.JobInsertResponse.resource:type_name -> google.cloud.bigquery.logging.v1.Job
	30, // 28: google.cloud.bigquery.logging.v1.JobQueryRequest.default_dataset:type_name -> google.cloud.bigquery.logging.v1.DatasetName
	25, // 29: google.cloud.bigquery.logging.v1.JobQueryResponse.job:type_name -> google.cloud.bigquery.logging.v1.Job
	25, // 30: google.cloud.bigquery.logging.v1.JobGetQueryResultsResponse.job:type_name -> google.cloud.bigquery.logging.v1.Job
	25, // 31: google.cloud.bigquery.logging.v1.JobQueryDoneResponse.job:type_name -> google.cloud.bigquery.logging.v1.Job
	25, // 32: google.cloud.bigquery.logging.v1.JobCompletedEvent.job:type_name -> google.cloud.bigquery.logging.v1.Job
	31, // 33: google.cloud.bigquery.logging.v1.Table.table_name:type_name -> google.cloud.bigquery.logging.v1.TableName
	20, // 34: google.cloud.bigquery.logging.v1.Table.info:type_name -> google.cloud.bigquery.logging.v1.TableInfo
	21, // 35: google.cloud.bigquery.logging.v1.Table.view:type_name -> google.cloud.bigquery.logging.v1.TableViewDefinition
	38, // 36: google.cloud.bigquery.logging.v1.Table.expire_time:type_name -> google.protobuf.Timestamp
	38, // 37: google.cloud.bigquery.logging.v1.Table.create_time:type_name -> google.protobuf.Timestamp
	38, // 38: google.cloud.bigquery.logging.v1.Table.truncate_time:type_name -> google.protobuf.Timestamp
	30, // 39: google.cloud.bigquery.logging.v1.Dataset.dataset_name:type_name -> google.cloud.bigquery.logging.v1.DatasetName
	23, // 40: google.cloud.bigquery.logging.v1.Dataset.info:type_name -> google.cloud.bigquery.logging.v1.DatasetInfo
	38, // 41: google.cloud.bigquery.logging.v1.Dataset.create_time:type_name -> google.protobuf.Timestamp
	38, // 42: google.cloud.bigquery.logging.v1.Dataset.update_time:type_name -> google.protobuf.Timestamp
	24, // 43: google.cloud.bigquery.logging.v1.Dataset.acl:type_name -> google.cloud.bigquery.logging.v1.BigQueryAcl
	39, // 44: google.cloud.bigquery.logging.v1.Dataset.default_table_expire_duration:type_name -> google.protobuf.Duration
	33, // 45: google.cloud.bigquery.logging.v1.BigQueryAcl.entries:type_name -> google.cloud.bigquery.logging.v1.BigQueryAcl.Entry
	32, // 46: google.cloud.bigquery.logging.v1.Job.job_name:type_name -> google.cloud.bigquery.logging.v1.JobName
	26, // 47: google.cloud.bigquery.logging.v1.Job.job_configuration:type_name -> google.cloud.bigquery.logging.v1.JobConfiguration
	28, // 48: google.cloud.bigquery.logging.v1.Job.job_status:type_name -> google.cloud.bigquery.logging.v1.JobStatus
	29, // 49: google.cloud.bigquery.logging.v1.Job.job_statistics:type_name -> google.cloud.bigquery.logging.v1.JobStatistics
	34, // 50: google.cloud.bigquery.logging.v1.JobConfiguration.query:type_name -> google.cloud.bigquery.logging.v1.JobConfiguration.Query
	35, // 51: google.cloud.bigquery.logging.v1.JobConfiguration.load:type_name -> google.cloud.bigquery.logging.v1.JobConfiguration.Load
	36, // 52: google.cloud.bigquery.logging.v1.JobConfiguration.extract:type_name -> google.cloud.bigquery.logging.v1.JobConfiguration.Extract
	37, // 53: google.cloud.bigquery.logging.v1.JobConfiguration.table_copy:type_name -> google.cloud.bigquery.logging.v1.JobConfiguration.TableCopy
	40, // 54: google.cloud.bigquery.logging.v1.JobStatus.error:type_name -> google.rpc.Status
	38, // 55: google.cloud.bigquery.logging.v1.JobStatistics.create_time:type_name -> google.protobuf.Timestamp
	38, // 56: google.cloud.bigquery.logging.v1.JobStatistics.start_time:type_name -> google.protobuf.Timestamp
	38, // 57: google.cloud.bigquery.logging.v1.JobStatistics.end_time:type_name -> google.protobuf.Timestamp
	31, // 58: google.cloud.bigquery.logging.v1.BigQueryAcl.Entry.view_name:type_name -> google.cloud.bigquery.logging.v1.TableName
	31, // 59: google.cloud.bigquery.logging.v1.JobConfiguration.Query.destination_table:type_name -> google.cloud.bigquery.logging.v1.TableName
	30, // 60: google.cloud.bigquery.logging.v1.JobConfiguration.Query.default_dataset:type_name -> google.cloud.bigquery.logging.v1.DatasetName
	27, // 61: google.cloud.bigquery.logging.v1.JobConfiguration.Query.table_definitions:type_name -> google.cloud.bigquery.logging.v1.TableDefinition
	31, // 62: google.cloud.bigquery.logging.v1.JobConfiguration.Load.destination_table:type_name -> google.cloud.bigquery.logging.v1.TableName
	31, // 63: google.cloud.bigquery.logging.v1.JobConfiguration.Extract.source_table:type_name -> google.cloud.bigquery.logging.v1.TableName
	31, // 64: google.cloud.bigquery.logging.v1.JobConfiguration.TableCopy.source_tables:type_name -> google.cloud.bigquery.logging.v1.TableName
	31, // 65: google.cloud.bigquery.logging.v1.JobConfiguration.TableCopy.destination_table:type_name -> google.cloud.bigquery.logging.v1.TableName
	66, // [66:66] is the sub-list for method output_type
	66, // [66:66] is the sub-list for method input_type
	66, // [66:66] is the sub-list for extension type_name
	66, // [66:66] is the sub-list for extension extendee
	0,  // [0:66] is the sub-list for field type_name
}

func init() { file_google_cloud_bigquery_logging_v1_audit_data_proto_init() }
func file_google_cloud_bigquery_logging_v1_audit_data_proto_init() {
	if File_google_cloud_bigquery_logging_v1_audit_data_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuditData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TableInsertRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TableUpdateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TableInsertResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TableUpdateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatasetListRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatasetInsertRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatasetInsertResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatasetUpdateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatasetUpdateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobInsertRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobInsertResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobQueryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobQueryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobGetQueryResultsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobGetQueryResultsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobQueryDoneResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobCompletedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TableDataListRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Table); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TableInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TableViewDefinition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Dataset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatasetInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAcl); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Job); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TableDefinition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobStatistics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatasetName); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TableName); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobName); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryAcl_Entry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobConfiguration_Query); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobConfiguration_Load); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobConfiguration_Extract); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobConfiguration_TableCopy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*AuditData_TableInsertRequest)(nil),
		(*AuditData_TableUpdateRequest)(nil),
		(*AuditData_DatasetListRequest)(nil),
		(*AuditData_DatasetInsertRequest)(nil),
		(*AuditData_DatasetUpdateRequest)(nil),
		(*AuditData_JobInsertRequest)(nil),
		(*AuditData_JobQueryRequest)(nil),
		(*AuditData_JobGetQueryResultsRequest)(nil),
		(*AuditData_TableDataListRequest)(nil),
		(*AuditData_TableInsertResponse)(nil),
		(*AuditData_TableUpdateResponse)(nil),
		(*AuditData_DatasetInsertResponse)(nil),
		(*AuditData_DatasetUpdateResponse)(nil),
		(*AuditData_JobInsertResponse)(nil),
		(*AuditData_JobQueryResponse)(nil),
		(*AuditData_JobGetQueryResultsResponse)(nil),
		(*AuditData_JobQueryDoneResponse)(nil),
	}
	file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes[26].OneofWrappers = []interface{}{
		(*JobConfiguration_Query_)(nil),
		(*JobConfiguration_Load_)(nil),
		(*JobConfiguration_Extract_)(nil),
		(*JobConfiguration_TableCopy_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   38,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_bigquery_logging_v1_audit_data_proto_goTypes,
		DependencyIndexes: file_google_cloud_bigquery_logging_v1_audit_data_proto_depIdxs,
		MessageInfos:      file_google_cloud_bigquery_logging_v1_audit_data_proto_msgTypes,
	}.Build()
	File_google_cloud_bigquery_logging_v1_audit_data_proto = out.File
	file_google_cloud_bigquery_logging_v1_audit_data_proto_rawDesc = nil
	file_google_cloud_bigquery_logging_v1_audit_data_proto_goTypes = nil
	file_google_cloud_bigquery_logging_v1_audit_data_proto_depIdxs = nil
}
