// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateDomainInput struct {
	_ struct{} `type:"structure"`

	// The mode of authentication that member use to access the domain.
	//
	// AuthMode is a required field
	AuthMode AuthMode `type:"string" required:"true" enum:"true"`

	// The default user settings.
	//
	// DefaultUserSettings is a required field
	DefaultUserSettings *UserSettings `type:"structure" required:"true"`

	// A name for the domain.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// The AWS Key Management Service encryption key ID.
	HomeEfsFileSystemKmsKeyId *string `type:"string"`

	// Security setting to limit to a set of subnets.
	//
	// SubnetIds is a required field
	SubnetIds []string `min:"1" type:"list" required:"true"`

	// Each tag consists of a key and an optional value. Tag keys must be unique
	// per resource.
	Tags []Tag `type:"list"`

	// Security setting to limit the domain's communication to a Amazon Virtual
	// Private Cloud.
	//
	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDomainInput"}
	if len(s.AuthMode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("AuthMode"))
	}

	if s.DefaultUserSettings == nil {
		invalidParams.Add(aws.NewErrParamRequired("DefaultUserSettings"))
	}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}

	if s.SubnetIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("SubnetIds"))
	}
	if s.SubnetIds != nil && len(s.SubnetIds) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SubnetIds", 1))
	}

	if s.VpcId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VpcId"))
	}
	if s.DefaultUserSettings != nil {
		if err := s.DefaultUserSettings.Validate(); err != nil {
			invalidParams.AddNested("DefaultUserSettings", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateDomainOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the created domain.
	DomainArn *string `type:"string"`

	// The URL to the created domain.
	Url *string `type:"string"`
}

// String returns the string representation
func (s CreateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateDomain = "CreateDomain"

// CreateDomainRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Creates a Domain for Amazon SageMaker Amazon SageMaker Studio (Studio), which
// can be accessed by end-users in a web browser. A Domain has an associated
// directory, list of authorized users, and a variety of security, application,
// policies, and Amazon Virtual Private Cloud configurations. An AWS account
// is limited to one Domain, per region. Users within a domain can share notebook
// files and other artifacts with each other. When a Domain is created, an Amazon
// Elastic File System (EFS) is also created for use by all of the users within
// the Domain. Each user receives a private home directory within the EFS for
// notebooks, Git repositories, and data files.
//
//    // Example sending a request using CreateDomainRequest.
//    req := client.CreateDomainRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDomain
func (c *Client) CreateDomainRequest(input *CreateDomainInput) CreateDomainRequest {
	op := &aws.Operation{
		Name:       opCreateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDomainInput{}
	}

	req := c.newRequest(op, input, &CreateDomainOutput{})
	return CreateDomainRequest{Request: req, Input: input, Copy: c.CreateDomainRequest}
}

// CreateDomainRequest is the request type for the
// CreateDomain API operation.
type CreateDomainRequest struct {
	*aws.Request
	Input *CreateDomainInput
	Copy  func(*CreateDomainInput) CreateDomainRequest
}

// Send marshals and sends the CreateDomain API request.
func (r CreateDomainRequest) Send(ctx context.Context) (*CreateDomainResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDomainResponse{
		CreateDomainOutput: r.Request.Data.(*CreateDomainOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDomainResponse is the response type for the
// CreateDomain API operation.
type CreateDomainResponse struct {
	*CreateDomainOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDomain request.
func (r *CreateDomainResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
