// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package savingsplans

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Information about a Savings Plan offering.
type ParentSavingsPlanOffering struct {
	_ struct{} `type:"structure"`

	// The currency.
	Currency CurrencyCode `locationName:"currency" type:"string" enum:"true"`

	// The duration, in seconds.
	DurationSeconds *int64 `locationName:"durationSeconds" type:"long"`

	// The ID of the offering.
	OfferingId *string `locationName:"offeringId" type:"string"`

	// The payment option.
	PaymentOption SavingsPlanPaymentOption `locationName:"paymentOption" type:"string" enum:"true"`

	// The description.
	PlanDescription *string `locationName:"planDescription" type:"string"`

	// The plan type.
	PlanType SavingsPlanType `locationName:"planType" type:"string" enum:"true"`
}

// String returns the string representation
func (s ParentSavingsPlanOffering) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ParentSavingsPlanOffering) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Currency) > 0 {
		v := s.Currency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "currency", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.DurationSeconds != nil {
		v := *s.DurationSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "durationSeconds", protocol.Int64Value(v), metadata)
	}
	if s.OfferingId != nil {
		v := *s.OfferingId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "offeringId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.PaymentOption) > 0 {
		v := s.PaymentOption

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "paymentOption", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.PlanDescription != nil {
		v := *s.PlanDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "planDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.PlanType) > 0 {
		v := s.PlanType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "planType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Information about a Savings Plan.
type SavingsPlan struct {
	_ struct{} `type:"structure"`

	// The hourly commitment, in USD.
	Commitment *string `locationName:"commitment" type:"string"`

	// The currency.
	Currency CurrencyCode `locationName:"currency" type:"string" enum:"true"`

	// The description.
	Description *string `locationName:"description" type:"string"`

	// The EC2 instance family.
	Ec2InstanceFamily *string `locationName:"ec2InstanceFamily" type:"string"`

	// The end time.
	End *string `locationName:"end" type:"string"`

	// The ID of the offering.
	OfferingId *string `locationName:"offeringId" type:"string"`

	// The payment option.
	PaymentOption SavingsPlanPaymentOption `locationName:"paymentOption" type:"string" enum:"true"`

	// The product types.
	ProductTypes []SavingsPlanProductType `locationName:"productTypes" type:"list"`

	// The recurring payment amount.
	RecurringPaymentAmount *string `locationName:"recurringPaymentAmount" type:"string"`

	// The AWS Region.
	Region *string `locationName:"region" type:"string"`

	// The Amazon Resource Name (ARN) of the Savings Plan.
	SavingsPlanArn *string `locationName:"savingsPlanArn" type:"string"`

	// The ID of the Savings Plan.
	SavingsPlanId *string `locationName:"savingsPlanId" type:"string"`

	// The plan type.
	SavingsPlanType SavingsPlanType `locationName:"savingsPlanType" type:"string" enum:"true"`

	// The start time.
	Start *string `locationName:"start" type:"string"`

	// The state.
	State SavingsPlanState `locationName:"state" type:"string" enum:"true"`

	// One or more tags.
	Tags map[string]string `locationName:"tags" type:"map"`

	// The duration of the term, in seconds.
	TermDurationInSeconds *int64 `locationName:"termDurationInSeconds" type:"long"`

	// The up-front payment amount.
	UpfrontPaymentAmount *string `locationName:"upfrontPaymentAmount" type:"string"`
}

// String returns the string representation
func (s SavingsPlan) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SavingsPlan) MarshalFields(e protocol.FieldEncoder) error {
	if s.Commitment != nil {
		v := *s.Commitment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "commitment", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Currency) > 0 {
		v := s.Currency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "currency", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Ec2InstanceFamily != nil {
		v := *s.Ec2InstanceFamily

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ec2InstanceFamily", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.End != nil {
		v := *s.End

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "end", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OfferingId != nil {
		v := *s.OfferingId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "offeringId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.PaymentOption) > 0 {
		v := s.PaymentOption

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "paymentOption", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ProductTypes != nil {
		v := s.ProductTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "productTypes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.RecurringPaymentAmount != nil {
		v := *s.RecurringPaymentAmount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "recurringPaymentAmount", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Region != nil {
		v := *s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "region", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SavingsPlanArn != nil {
		v := *s.SavingsPlanArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "savingsPlanArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SavingsPlanId != nil {
		v := *s.SavingsPlanId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "savingsPlanId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.SavingsPlanType) > 0 {
		v := s.SavingsPlanType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "savingsPlanType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Start != nil {
		v := *s.Start

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "start", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TermDurationInSeconds != nil {
		v := *s.TermDurationInSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "termDurationInSeconds", protocol.Int64Value(v), metadata)
	}
	if s.UpfrontPaymentAmount != nil {
		v := *s.UpfrontPaymentAmount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "upfrontPaymentAmount", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a filter.
type SavingsPlanFilter struct {
	_ struct{} `type:"structure"`

	// The filter name.
	Name SavingsPlansFilterName `locationName:"name" type:"string" enum:"true"`

	// The filter value.
	Values []string `locationName:"values" type:"list"`
}

// String returns the string representation
func (s SavingsPlanFilter) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SavingsPlanFilter) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Values != nil {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Information about a Savings Plan offering.
type SavingsPlanOffering struct {
	_ struct{} `type:"structure"`

	// The currency.
	Currency CurrencyCode `locationName:"currency" type:"string" enum:"true"`

	// The description.
	Description *string `locationName:"description" type:"string"`

	// The duration, in seconds.
	DurationSeconds *int64 `locationName:"durationSeconds" type:"long"`

	// The ID of the offering.
	OfferingId *string `locationName:"offeringId" type:"string"`

	// The specific AWS operation for the line item in the billing report.
	Operation *string `locationName:"operation" type:"string"`

	// The payment option.
	PaymentOption SavingsPlanPaymentOption `locationName:"paymentOption" type:"string" enum:"true"`

	// The plan type.
	PlanType SavingsPlanType `locationName:"planType" type:"string" enum:"true"`

	// The product type.
	ProductTypes []SavingsPlanProductType `locationName:"productTypes" type:"list"`

	// The properties.
	Properties []SavingsPlanOfferingProperty `locationName:"properties" type:"list"`

	// The service.
	ServiceCode *string `locationName:"serviceCode" type:"string"`

	// The usage details of the line item in the billing report.
	UsageType *string `locationName:"usageType" type:"string"`
}

// String returns the string representation
func (s SavingsPlanOffering) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SavingsPlanOffering) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Currency) > 0 {
		v := s.Currency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "currency", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DurationSeconds != nil {
		v := *s.DurationSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "durationSeconds", protocol.Int64Value(v), metadata)
	}
	if s.OfferingId != nil {
		v := *s.OfferingId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "offeringId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Operation != nil {
		v := *s.Operation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "operation", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.PaymentOption) > 0 {
		v := s.PaymentOption

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "paymentOption", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.PlanType) > 0 {
		v := s.PlanType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "planType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ProductTypes != nil {
		v := s.ProductTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "productTypes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Properties != nil {
		v := s.Properties

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "properties", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ServiceCode != nil {
		v := *s.ServiceCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "serviceCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UsageType != nil {
		v := *s.UsageType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "usageType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a filter.
type SavingsPlanOfferingFilterElement struct {
	_ struct{} `type:"structure"`

	// The filter name.
	Name SavingsPlanOfferingFilterAttribute `locationName:"name" type:"string" enum:"true"`

	// The filter values.
	Values []string `locationName:"values" type:"list"`
}

// String returns the string representation
func (s SavingsPlanOfferingFilterElement) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SavingsPlanOfferingFilterElement) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Values != nil {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Information about a property.
type SavingsPlanOfferingProperty struct {
	_ struct{} `type:"structure"`

	// The property name.
	Name SavingsPlanOfferingPropertyKey `locationName:"name" type:"string" enum:"true"`

	// The property value.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s SavingsPlanOfferingProperty) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SavingsPlanOfferingProperty) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a Savings Plan offering rate.
type SavingsPlanOfferingRate struct {
	_ struct{} `type:"structure"`

	// The specific AWS operation for the line item in the billing report.
	Operation *string `locationName:"operation" type:"string"`

	// The product type.
	ProductType SavingsPlanProductType `locationName:"productType" type:"string" enum:"true"`

	// The properties.
	Properties []SavingsPlanOfferingRateProperty `locationName:"properties" type:"list"`

	// The Savings Plan rate.
	Rate *string `locationName:"rate" type:"string"`

	// The Savings Plan offering.
	SavingsPlanOffering *ParentSavingsPlanOffering `locationName:"savingsPlanOffering" type:"structure"`

	// The service.
	ServiceCode SavingsPlanRateServiceCode `locationName:"serviceCode" type:"string" enum:"true"`

	// The unit.
	Unit SavingsPlanRateUnit `locationName:"unit" type:"string" enum:"true"`

	// The usage details of the line item in the billing report.
	UsageType *string `locationName:"usageType" type:"string"`
}

// String returns the string representation
func (s SavingsPlanOfferingRate) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SavingsPlanOfferingRate) MarshalFields(e protocol.FieldEncoder) error {
	if s.Operation != nil {
		v := *s.Operation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "operation", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ProductType) > 0 {
		v := s.ProductType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "productType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Properties != nil {
		v := s.Properties

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "properties", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Rate != nil {
		v := *s.Rate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "rate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SavingsPlanOffering != nil {
		v := s.SavingsPlanOffering

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "savingsPlanOffering", v, metadata)
	}
	if len(s.ServiceCode) > 0 {
		v := s.ServiceCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "serviceCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Unit) > 0 {
		v := s.Unit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "unit", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.UsageType != nil {
		v := *s.UsageType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "usageType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a filter.
type SavingsPlanOfferingRateFilterElement struct {
	_ struct{} `type:"structure"`

	// The filter name.
	Name SavingsPlanRateFilterAttribute `locationName:"name" type:"string" enum:"true"`

	// The filter values.
	Values []string `locationName:"values" type:"list"`
}

// String returns the string representation
func (s SavingsPlanOfferingRateFilterElement) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SavingsPlanOfferingRateFilterElement) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Values != nil {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Information about a property.
type SavingsPlanOfferingRateProperty struct {
	_ struct{} `type:"structure"`

	// The property name.
	Name *string `locationName:"name" type:"string"`

	// The property value.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s SavingsPlanOfferingRateProperty) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SavingsPlanOfferingRateProperty) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a Savings Plan rate.
type SavingsPlanRate struct {
	_ struct{} `type:"structure"`

	// The currency.
	Currency CurrencyCode `locationName:"currency" type:"string" enum:"true"`

	// The specific AWS operation for the line item in the billing report.
	Operation *string `locationName:"operation" type:"string"`

	// The product type.
	ProductType SavingsPlanProductType `locationName:"productType" type:"string" enum:"true"`

	// The properties.
	Properties []SavingsPlanRateProperty `locationName:"properties" type:"list"`

	// The rate.
	Rate *string `locationName:"rate" type:"string"`

	// The service.
	ServiceCode SavingsPlanRateServiceCode `locationName:"serviceCode" type:"string" enum:"true"`

	// The unit.
	Unit SavingsPlanRateUnit `locationName:"unit" type:"string" enum:"true"`

	// The usage details of the line item in the billing report.
	UsageType *string `locationName:"usageType" type:"string"`
}

// String returns the string representation
func (s SavingsPlanRate) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SavingsPlanRate) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Currency) > 0 {
		v := s.Currency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "currency", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Operation != nil {
		v := *s.Operation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "operation", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ProductType) > 0 {
		v := s.ProductType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "productType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Properties != nil {
		v := s.Properties

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "properties", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Rate != nil {
		v := *s.Rate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "rate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ServiceCode) > 0 {
		v := s.ServiceCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "serviceCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Unit) > 0 {
		v := s.Unit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "unit", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.UsageType != nil {
		v := *s.UsageType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "usageType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a filter.
type SavingsPlanRateFilter struct {
	_ struct{} `type:"structure"`

	// The filter name.
	Name SavingsPlanRateFilterName `locationName:"name" type:"string" enum:"true"`

	// The filter values.
	Values []string `locationName:"values" type:"list"`
}

// String returns the string representation
func (s SavingsPlanRateFilter) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SavingsPlanRateFilter) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Values != nil {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Information about a property.
type SavingsPlanRateProperty struct {
	_ struct{} `type:"structure"`

	// The property name.
	Name SavingsPlanRatePropertyKey `locationName:"name" type:"string" enum:"true"`

	// The property value.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s SavingsPlanRateProperty) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SavingsPlanRateProperty) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
