// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateMonitoringScheduleInput struct {
	_ struct{} `type:"structure"`

	// The configuration object that specifies the monitoring schedule and defines
	// the monitoring job.
	//
	// MonitoringScheduleConfig is a required field
	MonitoringScheduleConfig *MonitoringScheduleConfig `type:"structure" required:"true"`

	// The name of the monitoring schedule. The name must be unique within an AWS
	// Region within an AWS account.
	//
	// MonitoringScheduleName is a required field
	MonitoringScheduleName *string `min:"1" type:"string" required:"true"`

	// (Optional) An array of key-value pairs. For more information, see Using Cost
	// Allocation Tags (https://docs-aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL)
	// in the AWS Billing and Cost Management User Guide.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s CreateMonitoringScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMonitoringScheduleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateMonitoringScheduleInput"}

	if s.MonitoringScheduleConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("MonitoringScheduleConfig"))
	}

	if s.MonitoringScheduleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MonitoringScheduleName"))
	}
	if s.MonitoringScheduleName != nil && len(*s.MonitoringScheduleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MonitoringScheduleName", 1))
	}
	if s.MonitoringScheduleConfig != nil {
		if err := s.MonitoringScheduleConfig.Validate(); err != nil {
			invalidParams.AddNested("MonitoringScheduleConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateMonitoringScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the monitoring schedule.
	//
	// MonitoringScheduleArn is a required field
	MonitoringScheduleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateMonitoringScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateMonitoringSchedule = "CreateMonitoringSchedule"

// CreateMonitoringScheduleRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Creates a schedule that regularly starts Amazon SageMaker Processing Jobs
// to monitor the data captured for an Amazon SageMaker Endoint.
//
//    // Example sending a request using CreateMonitoringScheduleRequest.
//    req := client.CreateMonitoringScheduleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateMonitoringSchedule
func (c *Client) CreateMonitoringScheduleRequest(input *CreateMonitoringScheduleInput) CreateMonitoringScheduleRequest {
	op := &aws.Operation{
		Name:       opCreateMonitoringSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateMonitoringScheduleInput{}
	}

	req := c.newRequest(op, input, &CreateMonitoringScheduleOutput{})
	return CreateMonitoringScheduleRequest{Request: req, Input: input, Copy: c.CreateMonitoringScheduleRequest}
}

// CreateMonitoringScheduleRequest is the request type for the
// CreateMonitoringSchedule API operation.
type CreateMonitoringScheduleRequest struct {
	*aws.Request
	Input *CreateMonitoringScheduleInput
	Copy  func(*CreateMonitoringScheduleInput) CreateMonitoringScheduleRequest
}

// Send marshals and sends the CreateMonitoringSchedule API request.
func (r CreateMonitoringScheduleRequest) Send(ctx context.Context) (*CreateMonitoringScheduleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateMonitoringScheduleResponse{
		CreateMonitoringScheduleOutput: r.Request.Data.(*CreateMonitoringScheduleOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateMonitoringScheduleResponse is the response type for the
// CreateMonitoringSchedule API operation.
type CreateMonitoringScheduleResponse struct {
	*CreateMonitoringScheduleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateMonitoringSchedule request.
func (r *CreateMonitoringScheduleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
