// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListCommandInvocationsInput struct {
	_ struct{} `type:"structure"`

	// (Optional) The invocations for a specific command ID.
	CommandId *string `min:"36" type:"string"`

	// (Optional) If set this returns the response of the command executions and
	// any command output. By default this is set to False.
	Details *bool `type:"boolean"`

	// (Optional) One or more filters. Use a filter to return a more specific list
	// of results. Note that the DocumentName filter is not supported for ListCommandInvocations.
	Filters []CommandFilter `min:"1" type:"list"`

	// (Optional) The command execution details for a specific instance ID.
	InstanceId *string `type:"string"`

	// (Optional) The maximum number of items to return for this call. The call
	// also returns a token that you can specify in a subsequent call to get the
	// next set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) The token for the next set of items to return. (You received this
	// token from a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCommandInvocationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCommandInvocationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListCommandInvocationsInput"}
	if s.CommandId != nil && len(*s.CommandId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("CommandId", 36))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListCommandInvocationsOutput struct {
	_ struct{} `type:"structure"`

	// (Optional) A list of all invocations.
	CommandInvocations []CommandInvocation `type:"list"`

	// (Optional) The token for the next set of items to return. (You received this
	// token from a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCommandInvocationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListCommandInvocations = "ListCommandInvocations"

// ListCommandInvocationsRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// An invocation is copy of a command sent to a specific instance. A command
// can apply to one or more instances. A command invocation applies to one instance.
// For example, if a user runs SendCommand against three instances, then a command
// invocation is created for each requested instance ID. ListCommandInvocations
// provide status about command execution.
//
//    // Example sending a request using ListCommandInvocationsRequest.
//    req := client.ListCommandInvocationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations
func (c *Client) ListCommandInvocationsRequest(input *ListCommandInvocationsInput) ListCommandInvocationsRequest {
	op := &aws.Operation{
		Name:       opListCommandInvocations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCommandInvocationsInput{}
	}

	req := c.newRequest(op, input, &ListCommandInvocationsOutput{})
	return ListCommandInvocationsRequest{Request: req, Input: input, Copy: c.ListCommandInvocationsRequest}
}

// ListCommandInvocationsRequest is the request type for the
// ListCommandInvocations API operation.
type ListCommandInvocationsRequest struct {
	*aws.Request
	Input *ListCommandInvocationsInput
	Copy  func(*ListCommandInvocationsInput) ListCommandInvocationsRequest
}

// Send marshals and sends the ListCommandInvocations API request.
func (r ListCommandInvocationsRequest) Send(ctx context.Context) (*ListCommandInvocationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListCommandInvocationsResponse{
		ListCommandInvocationsOutput: r.Request.Data.(*ListCommandInvocationsOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListCommandInvocationsRequestPaginator returns a paginator for ListCommandInvocations.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListCommandInvocationsRequest(input)
//   p := ssm.NewListCommandInvocationsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListCommandInvocationsPaginator(req ListCommandInvocationsRequest) ListCommandInvocationsPaginator {
	return ListCommandInvocationsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListCommandInvocationsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListCommandInvocationsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListCommandInvocationsPaginator struct {
	aws.Pager
}

func (p *ListCommandInvocationsPaginator) CurrentPage() *ListCommandInvocationsOutput {
	return p.Pager.CurrentPage().(*ListCommandInvocationsOutput)
}

// ListCommandInvocationsResponse is the response type for the
// ListCommandInvocations API operation.
type ListCommandInvocationsResponse struct {
	*ListCommandInvocationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListCommandInvocations request.
func (r *ListCommandInvocationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
