// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sfn

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteStateMachineInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the state machine to delete.
	//
	// StateMachineArn is a required field
	StateMachineArn *string `locationName:"stateMachineArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStateMachineInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStateMachineInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteStateMachineInput"}

	if s.StateMachineArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("StateMachineArn"))
	}
	if s.StateMachineArn != nil && len(*s.StateMachineArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StateMachineArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteStateMachineOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStateMachineOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteStateMachine = "DeleteStateMachine"

// DeleteStateMachineRequest returns a request value for making API operation for
// AWS Step Functions.
//
// Deletes a state machine. This is an asynchronous operation: It sets the state
// machine's status to DELETING and begins the deletion process. Each state
// machine execution is deleted the next time it makes a state transition.
//
// The state machine itself is deleted after all executions are completed or
// deleted.
//
//    // Example sending a request using DeleteStateMachineRequest.
//    req := client.DeleteStateMachineRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/DeleteStateMachine
func (c *Client) DeleteStateMachineRequest(input *DeleteStateMachineInput) DeleteStateMachineRequest {
	op := &aws.Operation{
		Name:       opDeleteStateMachine,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStateMachineInput{}
	}

	req := c.newRequest(op, input, &DeleteStateMachineOutput{})
	return DeleteStateMachineRequest{Request: req, Input: input, Copy: c.DeleteStateMachineRequest}
}

// DeleteStateMachineRequest is the request type for the
// DeleteStateMachine API operation.
type DeleteStateMachineRequest struct {
	*aws.Request
	Input *DeleteStateMachineInput
	Copy  func(*DeleteStateMachineInput) DeleteStateMachineRequest
}

// Send marshals and sends the DeleteStateMachine API request.
func (r DeleteStateMachineRequest) Send(ctx context.Context) (*DeleteStateMachineResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteStateMachineResponse{
		DeleteStateMachineOutput: r.Request.Data.(*DeleteStateMachineOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteStateMachineResponse is the response type for the
// DeleteStateMachine API operation.
type DeleteStateMachineResponse struct {
	*DeleteStateMachineOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteStateMachine request.
func (r *DeleteStateMachineResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
