// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package savingsplans

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateSavingsPlanInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The hourly commitment, in USD. This is a value between 0.001 and 1 million.
	// You cannot specify more than three digits after the decimal point.
	//
	// Commitment is a required field
	Commitment *string `locationName:"commitment" type:"string" required:"true"`

	// The ID of the offering.
	//
	// SavingsPlanOfferingId is a required field
	SavingsPlanOfferingId *string `locationName:"savingsPlanOfferingId" type:"string" required:"true"`

	// One or more tags.
	Tags map[string]string `locationName:"tags" type:"map"`

	// The up-front payment amount. This is a whole number between 50 and 99 percent
	// of the total value of the Savings Plan. This parameter is supported only
	// if the payment option is Partial Upfront.
	UpfrontPaymentAmount *string `locationName:"upfrontPaymentAmount" type:"string"`
}

// String returns the string representation
func (s CreateSavingsPlanInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSavingsPlanInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateSavingsPlanInput"}

	if s.Commitment == nil {
		invalidParams.Add(aws.NewErrParamRequired("Commitment"))
	}

	if s.SavingsPlanOfferingId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SavingsPlanOfferingId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateSavingsPlanInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Commitment != nil {
		v := *s.Commitment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "commitment", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SavingsPlanOfferingId != nil {
		v := *s.SavingsPlanOfferingId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "savingsPlanOfferingId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.UpfrontPaymentAmount != nil {
		v := *s.UpfrontPaymentAmount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "upfrontPaymentAmount", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateSavingsPlanOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the Savings Plan.
	SavingsPlanId *string `locationName:"savingsPlanId" type:"string"`
}

// String returns the string representation
func (s CreateSavingsPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateSavingsPlanOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.SavingsPlanId != nil {
		v := *s.SavingsPlanId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "savingsPlanId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateSavingsPlan = "CreateSavingsPlan"

// CreateSavingsPlanRequest returns a request value for making API operation for
// AWS Savings Plans.
//
// Creates a Savings Plan.
//
//    // Example sending a request using CreateSavingsPlanRequest.
//    req := client.CreateSavingsPlanRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/CreateSavingsPlan
func (c *Client) CreateSavingsPlanRequest(input *CreateSavingsPlanInput) CreateSavingsPlanRequest {
	op := &aws.Operation{
		Name:       opCreateSavingsPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateSavingsPlan",
	}

	if input == nil {
		input = &CreateSavingsPlanInput{}
	}

	req := c.newRequest(op, input, &CreateSavingsPlanOutput{})
	return CreateSavingsPlanRequest{Request: req, Input: input, Copy: c.CreateSavingsPlanRequest}
}

// CreateSavingsPlanRequest is the request type for the
// CreateSavingsPlan API operation.
type CreateSavingsPlanRequest struct {
	*aws.Request
	Input *CreateSavingsPlanInput
	Copy  func(*CreateSavingsPlanInput) CreateSavingsPlanRequest
}

// Send marshals and sends the CreateSavingsPlan API request.
func (r CreateSavingsPlanRequest) Send(ctx context.Context) (*CreateSavingsPlanResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateSavingsPlanResponse{
		CreateSavingsPlanOutput: r.Request.Data.(*CreateSavingsPlanOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateSavingsPlanResponse is the response type for the
// CreateSavingsPlan API operation.
type CreateSavingsPlanResponse struct {
	*CreateSavingsPlanOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateSavingsPlan request.
func (r *CreateSavingsPlanResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
