// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateAutoMLJobInput struct {
	_ struct{} `type:"structure"`

	// Contains CompletionCriteria and SecurityConfig.
	AutoMLJobConfig *AutoMLJobConfig `type:"structure"`

	// Identifies an AutoPilot job. Must be unique to your account and is case-insensitive.
	//
	// AutoMLJobName is a required field
	AutoMLJobName *string `min:"1" type:"string" required:"true"`

	// Defines the job's objective. You provide a MetricName and AutoML will infer
	// minimize or maximize. If this is not provided, the most commonly used ObjectiveMetric
	// for problem type will be selected.
	AutoMLJobObjective *AutoMLJobObjective `type:"structure"`

	// This will generate possible candidates without training a model. A candidate
	// is a combination of data preprocessors, algorithms, and algorithm parameter
	// settings.
	GenerateCandidateDefinitionsOnly *bool `type:"boolean"`

	// Similar to InputDataConfig supported by Tuning. Format(s) supported: CSV.
	//
	// InputDataConfig is a required field
	InputDataConfig []AutoMLChannel `min:"1" type:"list" required:"true"`

	// Similar to OutputDataConfig supported by Tuning. Format(s) supported: CSV.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *AutoMLOutputDataConfig `type:"structure" required:"true"`

	// Defines the kind of preprocessing and algorithms intended for the candidates.
	// Options include: BinaryClassification, MulticlassClassification, and Regression.
	ProblemType ProblemType `type:"string" enum:"true"`

	// The ARN of the role that will be used to access the data.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// Each tag consists of a key and an optional value. Tag keys must be unique
	// per resource.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s CreateAutoMLJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAutoMLJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateAutoMLJobInput"}

	if s.AutoMLJobName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoMLJobName"))
	}
	if s.AutoMLJobName != nil && len(*s.AutoMLJobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoMLJobName", 1))
	}

	if s.InputDataConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputDataConfig"))
	}
	if s.InputDataConfig != nil && len(s.InputDataConfig) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InputDataConfig", 1))
	}

	if s.OutputDataConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("OutputDataConfig"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}
	if s.AutoMLJobConfig != nil {
		if err := s.AutoMLJobConfig.Validate(); err != nil {
			invalidParams.AddNested("AutoMLJobConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.AutoMLJobObjective != nil {
		if err := s.AutoMLJobObjective.Validate(); err != nil {
			invalidParams.AddNested("AutoMLJobObjective", err.(aws.ErrInvalidParams))
		}
	}
	if s.InputDataConfig != nil {
		for i, v := range s.InputDataConfig {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputDataConfig", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateAutoMLJobOutput struct {
	_ struct{} `type:"structure"`

	// When a job is created, it is assigned a unique ARN.
	//
	// AutoMLJobArn is a required field
	AutoMLJobArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAutoMLJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateAutoMLJob = "CreateAutoMLJob"

// CreateAutoMLJobRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Creates an AutoPilot job.
//
//    // Example sending a request using CreateAutoMLJobRequest.
//    req := client.CreateAutoMLJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAutoMLJob
func (c *Client) CreateAutoMLJobRequest(input *CreateAutoMLJobInput) CreateAutoMLJobRequest {
	op := &aws.Operation{
		Name:       opCreateAutoMLJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAutoMLJobInput{}
	}

	req := c.newRequest(op, input, &CreateAutoMLJobOutput{})
	return CreateAutoMLJobRequest{Request: req, Input: input, Copy: c.CreateAutoMLJobRequest}
}

// CreateAutoMLJobRequest is the request type for the
// CreateAutoMLJob API operation.
type CreateAutoMLJobRequest struct {
	*aws.Request
	Input *CreateAutoMLJobInput
	Copy  func(*CreateAutoMLJobInput) CreateAutoMLJobRequest
}

// Send marshals and sends the CreateAutoMLJob API request.
func (r CreateAutoMLJobRequest) Send(ctx context.Context) (*CreateAutoMLJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateAutoMLJobResponse{
		CreateAutoMLJobOutput: r.Request.Data.(*CreateAutoMLJobOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateAutoMLJobResponse is the response type for the
// CreateAutoMLJob API operation.
type CreateAutoMLJobResponse struct {
	*CreateAutoMLJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateAutoMLJob request.
func (r *CreateAutoMLJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
