// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3control

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetAccessPointPolicyStatusInput struct {
	_ struct{} `type:"structure"`

	// The account ID for the account that owns the specified access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the access point whose policy status you want to retrieve.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAccessPointPolicyStatusInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessPointPolicyStatusInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetAccessPointPolicyStatusInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetAccessPointPolicyStatusInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-account-id", protocol.StringValue(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.StringValue(v), metadata)
	}
	return nil
}

type GetAccessPointPolicyStatusOutput struct {
	_ struct{} `type:"structure"`

	// Indicates the current policy status of the specified access point.
	PolicyStatus *PolicyStatus `type:"structure"`
}

// String returns the string representation
func (s GetAccessPointPolicyStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetAccessPointPolicyStatusOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.PolicyStatus != nil {
		v := s.PolicyStatus

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "PolicyStatus", v, metadata)
	}
	return nil
}

const opGetAccessPointPolicyStatus = "GetAccessPointPolicyStatus"

// GetAccessPointPolicyStatusRequest returns a request value for making API operation for
// AWS S3 Control.
//
// Indicates whether the specified access point currently has a policy that
// allows public access. For more information about public access through access
// points, see Managing Data Access with Amazon S3 Access Points (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-points.html)
// in the Amazon Simple Storage Service Developer Guide.
//
//    // Example sending a request using GetAccessPointPolicyStatusRequest.
//    req := client.GetAccessPointPolicyStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointPolicyStatus
func (c *Client) GetAccessPointPolicyStatusRequest(input *GetAccessPointPolicyStatusInput) GetAccessPointPolicyStatusRequest {
	op := &aws.Operation{
		Name:       opGetAccessPointPolicyStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accesspoint/{name}/policyStatus",
	}

	if input == nil {
		input = &GetAccessPointPolicyStatusInput{}
	}

	req := c.newRequest(op, input, &GetAccessPointPolicyStatusOutput{})
	req.Handlers.Build.PushBackNamed(buildPrefixHostHandler("AccountID", aws.StringValue(input.AccountId)))
	req.Handlers.Build.PushBackNamed(buildRemoveHeaderHandler("X-Amz-Account-Id"))
	return GetAccessPointPolicyStatusRequest{Request: req, Input: input, Copy: c.GetAccessPointPolicyStatusRequest}
}

// GetAccessPointPolicyStatusRequest is the request type for the
// GetAccessPointPolicyStatus API operation.
type GetAccessPointPolicyStatusRequest struct {
	*aws.Request
	Input *GetAccessPointPolicyStatusInput
	Copy  func(*GetAccessPointPolicyStatusInput) GetAccessPointPolicyStatusRequest
}

// Send marshals and sends the GetAccessPointPolicyStatus API request.
func (r GetAccessPointPolicyStatusRequest) Send(ctx context.Context) (*GetAccessPointPolicyStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAccessPointPolicyStatusResponse{
		GetAccessPointPolicyStatusOutput: r.Request.Data.(*GetAccessPointPolicyStatusOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetAccessPointPolicyStatusResponse is the response type for the
// GetAccessPointPolicyStatus API operation.
type GetAccessPointPolicyStatusResponse struct {
	*GetAccessPointPolicyStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAccessPointPolicyStatus request.
func (r *GetAccessPointPolicyStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
