// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
)

type PutBucketInventoryConfigurationInput struct {
	_ struct{} `type:"structure" payload:"InventoryConfiguration"`

	// The name of the bucket where the inventory configuration will be stored.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The ID used to identify the inventory configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`

	// Specifies the inventory configuration.
	//
	// InventoryConfiguration is a required field
	InventoryConfiguration *InventoryConfiguration `locationName:"InventoryConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketInventoryConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketInventoryConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketInventoryConfigurationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if s.InventoryConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("InventoryConfiguration"))
	}
	if s.InventoryConfiguration != nil {
		if err := s.InventoryConfiguration.Validate(); err != nil {
			invalidParams.AddNested("InventoryConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketInventoryConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketInventoryConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.InventoryConfiguration != nil {
		v := s.InventoryConfiguration

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "InventoryConfiguration", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "id", protocol.StringValue(v), metadata)
	}
	return nil
}

type PutBucketInventoryConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketInventoryConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketInventoryConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opPutBucketInventoryConfiguration = "PutBucketInventoryConfiguration"

// PutBucketInventoryConfigurationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// This implementation of the PUT operation adds an inventory configuration
// (identified by the inventory ID) to the bucket. You can have up to 1,000
// inventory configurations per bucket.
//
// Amazon S3 inventory generates inventories of the objects in the bucket on
// a daily or weekly basis, and the results are published to a flat file. The
// bucket that is inventoried is called the source bucket, and the bucket where
// the inventory flat file is stored is called the destination bucket. The destination
// bucket must be in the same AWS Region as the source bucket.
//
// When you configure an inventory for a source bucket, you specify the destination
// bucket where you want the inventory to be stored, and whether to generate
// the inventory daily or weekly. You can also configure what object metadata
// to include and whether to inventory all object versions or only current versions.
// For more information, see Amazon S3 Inventory (https://docs.aws.amazon.com/AmazonS3/latest/dev//storage-inventory.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// You must create a bucket policy on the destination bucket to grant permissions
// to Amazon S3 to write objects to the bucket in the defined location. For
// an example policy, see Granting Permissions for Amazon S3 Inventory and Storage
// Class Analysis. (https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html#example-bucket-policies-use-case-9)
//
// To use this operation, you must have permissions to perform the s3:PutInventoryConfiguration
// action. The bucket owner has this permission by default and can grant this
// permission to others. For more information about permissions, see Permissions
// Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/dev//using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/dev//s3-access-control.html)
// in the Amazon Simple Storage Service Developer Guide.
//
// Special Errors
//
//    * HTTP 400 Bad Request Error Code: InvalidArgument Cause: Invalid Argument
//
//    * HTTP 400 Bad Request Error Code: TooManyConfigurations Cause: You are
//    attempting to create a new configuration but have already reached the
//    1,000-configuration limit.
//
//    * HTTP 403 Forbidden Error Code: AccessDenied Cause: You are not the owner
//    of the specified bucket, or you do not have the s3:PutInventoryConfiguration
//    bucket permission to set the configuration on the bucket
//
// Related Resources
//
//    * GetBucketInventoryConfiguration
//
//    * DeleteBucketInventoryConfiguration
//
//    * ListBucketInventoryConfigurations
//
//    // Example sending a request using PutBucketInventoryConfigurationRequest.
//    req := client.PutBucketInventoryConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketInventoryConfiguration
func (c *Client) PutBucketInventoryConfigurationRequest(input *PutBucketInventoryConfigurationInput) PutBucketInventoryConfigurationRequest {
	op := &aws.Operation{
		Name:       opPutBucketInventoryConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?inventory",
	}

	if input == nil {
		input = &PutBucketInventoryConfigurationInput{}
	}

	req := c.newRequest(op, input, &PutBucketInventoryConfigurationOutput{})
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return PutBucketInventoryConfigurationRequest{Request: req, Input: input, Copy: c.PutBucketInventoryConfigurationRequest}
}

// PutBucketInventoryConfigurationRequest is the request type for the
// PutBucketInventoryConfiguration API operation.
type PutBucketInventoryConfigurationRequest struct {
	*aws.Request
	Input *PutBucketInventoryConfigurationInput
	Copy  func(*PutBucketInventoryConfigurationInput) PutBucketInventoryConfigurationRequest
}

// Send marshals and sends the PutBucketInventoryConfiguration API request.
func (r PutBucketInventoryConfigurationRequest) Send(ctx context.Context) (*PutBucketInventoryConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutBucketInventoryConfigurationResponse{
		PutBucketInventoryConfigurationOutput: r.Request.Data.(*PutBucketInventoryConfigurationOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutBucketInventoryConfigurationResponse is the response type for the
// PutBucketInventoryConfiguration API operation.
type PutBucketInventoryConfigurationResponse struct {
	*PutBucketInventoryConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutBucketInventoryConfiguration request.
func (r *PutBucketInventoryConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
